/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.BrowserStringParser;
import org.openqa.selenium.server.browserlaunchers.CustomBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.DrivenSeleniumLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxLauncher;
import org.openqa.selenium.server.browserlaunchers.GoogleChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerLauncher;
import org.openqa.selenium.server.browserlaunchers.KonquerorLauncher;
import org.openqa.selenium.server.browserlaunchers.MockBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionFirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionInternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariLauncher;

public class BrowserLauncherFactory {
    private static Logger log = Logger.getLogger(BrowserLauncherFactory.class.getName());
    private static final Pattern CUSTOM_PATTERN = Pattern.compile("^\\*?custom( .*)?$");
    private final Map<String, Class<? extends BrowserLauncher>> supportedBrowsers = Maps.newHashMap();
    private final DriverSessions webdriverSessions;

    public BrowserLauncherFactory() {
        this(null);
    }

    public BrowserLauncherFactory(DriverSessions webdriverSessions) {
        this.supportedBrowsers.put("firefoxproxy", FirefoxCustomProfileLauncher.class);
        this.supportedBrowsers.put("firefox", FirefoxLauncher.class);
        this.supportedBrowsers.put("chrome", FirefoxChromeLauncher.class);
        this.supportedBrowsers.put("firefoxchrome", FirefoxChromeLauncher.class);
        this.supportedBrowsers.put("iexploreproxy", InternetExplorerCustomProxyLauncher.class);
        this.supportedBrowsers.put("safari", SafariLauncher.class);
        this.supportedBrowsers.put("safariproxy", SafariCustomProfileLauncher.class);
        this.supportedBrowsers.put("iehta", HTABrowserLauncher.class);
        this.supportedBrowsers.put("iexplore", InternetExplorerLauncher.class);
        this.supportedBrowsers.put("piiexplore", ProxyInjectionInternetExplorerCustomProxyLauncher.class);
        this.supportedBrowsers.put("pifirefox", ProxyInjectionFirefoxCustomProfileLauncher.class);
        this.supportedBrowsers.put("konqueror", KonquerorLauncher.class);
        this.supportedBrowsers.put("mock", MockBrowserLauncher.class);
        this.supportedBrowsers.put("googlechrome", GoogleChromeLauncher.class);
        this.supportedBrowsers.put("webdriver", DrivenSeleniumLauncher.class);
        this.webdriverSessions = webdriverSessions;
    }

    public BrowserLauncher getBrowserLauncher(String browser, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        String executablePath = null;
        if (BrowserOptions.hasOptionsSet(browserOptions)) {
            executablePath = BrowserOptions.getExecutablePath(browserOptions);
        } else {
            configuration.copySettingsIntoBrowserOptions(browserOptions);
        }
        for (String key : this.supportedBrowsers.keySet()) {
            BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand(key, browser);
            if (!result.match()) continue;
            if (executablePath == null) {
                executablePath = result.customLauncher();
                browserOptions = BrowserOptions.setExecutablePath(browserOptions, executablePath);
            }
            log.fine("Requested browser string '" + browser + "' matches *" + key + " ");
            return this.createBrowserLauncher(this.supportedBrowsers.get(key), executablePath, sessionId, configuration, browserOptions);
        }
        log.fine("Requested browser string '" + browser + "' does not match any known browser, treating it as a custom browser...");
        Matcher CustomMatcher = CUSTOM_PATTERN.matcher(browser);
        if (CustomMatcher.find()) {
            String browserStartCommand = CustomMatcher.group(1);
            if (browserStartCommand == null) {
                throw new RuntimeException("You must specify the path to an executable when using *custom!\n\n");
            }
            browserStartCommand = browserStartCommand.substring(1);
            return new CustomBrowserLauncher(browserStartCommand, sessionId, configuration, browserOptions);
        }
        throw this.browserNotSupported(browser);
    }

    public Map<String, Class<? extends BrowserLauncher>> getSupportedLaunchers() {
        return this.supportedBrowsers;
    }

    public void addBrowserLauncher(String browser, Class<? extends BrowserLauncher> clazz) {
        this.supportedBrowsers.put(browser, clazz);
    }

    public boolean isBrowserSupported(String browser) {
        for (String key : this.supportedBrowsers.keySet()) {
            BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand(key, browser);
            if (!result.match()) continue;
            return true;
        }
        Matcher CustomMatcher = CUSTOM_PATTERN.matcher(browser);
        return CustomMatcher.find();
    }

    public String getSupportedBrowsersAsString() {
        StringBuffer str = new StringBuffer("");
        for (String name : this.supportedBrowsers.keySet()) {
            str.append("  *").append(name).append('\n');
        }
        str.append("  *custom\n");
        return str.toString();
    }

    private RuntimeException browserNotSupported(String browser) {
        StringBuffer errorMessage = new StringBuffer("Browser not supported: " + browser);
        errorMessage.append('\n');
        if (!browser.startsWith("*")) {
            errorMessage.append("(Did you forget to add a *?)\n");
        }
        errorMessage.append('\n');
        errorMessage.append("Supported browsers include:\n");
        errorMessage.append(this.getSupportedBrowsersAsString());
        return new RuntimeException(errorMessage.toString());
    }

    private BrowserLauncher createBrowserLauncher(Class<? extends BrowserLauncher> c, String browserStartCommand, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        try {
            try {
                Constructor<? extends BrowserLauncher> ctor = c.getConstructor(Capabilities.class, RemoteControlConfiguration.class, String.class, String.class);
                BrowserLauncher browserLauncher = ctor.newInstance(browserOptions, configuration, sessionId, browserStartCommand);
                if (browserLauncher instanceof DrivenSeleniumLauncher) {
                    ((DrivenSeleniumLauncher)browserLauncher).setDriverSessions(this.webdriverSessions);
                }
                return browserLauncher;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

