/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.condition;

import com.thoughtworks.selenium.condition.ConditionRunner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Condition {
    private final String message;

    public abstract boolean isTrue(ConditionRunner.Context var1);

    public Condition() {
        this.message = this.getClass().getCanonicalName();
    }

    public Condition(String message, Object[] args) {
        if (message == null) {
            throw new NullPointerException("Condition names must not be null");
        }
        this.message = this.simulateStringDotFormatMethod(message, args);
    }

    private String simulateStringDotFormatMethod(String message, Object[] args) {
        int vers = Integer.parseInt(System.getProperty("java.class.version").substring(0, 2));
        if (vers >= 49) {
            block6: {
                try {
                    Method format = String.class.getMethod("format", String.class, Object[].class);
                    return (String)format.invoke(null, message, args);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getCause();
                    if (!(throwable instanceof RuntimeException)) break block6;
                    throw (RuntimeException)throwable;
                }
            }
            throw new RuntimeException("String.format(..) can't be that hard to call");
        }
        String msg = "";
        msg = message;
        int i = 0;
        while (i < args.length) {
            msg = String.valueOf(msg) + " " + args[i];
            ++i;
        }
        return msg;
    }

    public Condition(String message) {
        this(message, new Object[0]);
    }

    public Condition(String message, Object arg) {
        this(message, new Object[]{arg});
    }

    public Condition(String message, Object arg0, Object arg1) {
        this(message, new Object[]{arg0, arg1});
    }

    public Condition(String message, Object arg0, Object arg1, Object arg2) {
        this(message, new Object[]{arg0, arg1, arg2});
    }

    public Condition(String message, Object arg0, Object arg1, Object arg2, Object arg3) {
        this(message, new Object[]{arg0, arg1, arg2, arg3});
    }

    public Condition(String message, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this(message, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public String getMessage() {
        return this.toString();
    }

    public String toString() {
        return "Condition \"" + this.message + "\"";
    }
}

