package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Algorithms to use when hashing field values (see {@link com.smartgwt.client.docs.serverds.DataSourceField#storeWithHash
 * DataSourceField.storeWithHash}). Note that the <code>MD5</code> and <code>SHA</code> algorithms are deprecated as secure
 * hashes since they are vulnerable to collisions created by an attacker with current technology, though they may still be
 * useful in detecting corruption due to faulty transmission or storage.
 */
public enum HashAlgorithm implements ValueEnum {
    /**
     * Message Digest algorithm. <i>Deprecated as a secure hash.</i>
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "MD5".
     */
    MD5("MD5"),
    /**
     * Secure Hashing Algorithm (SHA-1). <i>Deprecated as a secure hash.</i>
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "SHA".
     */
    SHA("SHA"),
    /**
     * Secure Hashing Algorithm (SHA-256).
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "SHA-256".
     */
    SHA_256("SHA-256"),
    /**
     * Secure Hashing Algorithm (SHA-512).
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "SHA-512".
     */
    SHA_512("SHA-512"),
    /**
     * bcrypt is a password hashing function designed by Niels Provos and David Mazieres, based on the Blowfish cipher.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "bcrypt".
     */
    BCRYPT("bcrypt"),
    /**
     * Don't hash values. Can be specified to avoid the default algorithm.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "none".
     */
    NONE("none");
    private String value;

    HashAlgorithm(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
