/*

  SmartClient Ajax RIA system
  Version v14.0p_2026-02-03/LGPL Deployment (2026-02-03)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class ToggleSwitch
// A simple control that presents a Boolean value as a toggle-switch, where the value can be 
// toggled by clicking with the mouse, or with the Spacebar and left/right 
// arrow-keys when +link{toggleSwitch.toggleOnKeypress} is true.
//
//  @inheritsFrom StatefulCanvas
//  @treeLocation Client Reference/Control
//  @visibility external
//<
isc.ClassFactory.defineClass("ToggleSwitch", "StatefulCanvas");

//----------  Define instance properties  ----------
isc.ToggleSwitch.addProperties({
    width: 50,
    height: 22,
    overflow: "visible",
    canFocus: true,
    
    showRollOver: false,
    showDown: false,
    showFocused: false,

    //> @attr toggleSwitch.thumbOffset (Integer : 2 : IRW)
    // Spacing to apply inside of this ToggleSwitch, outside of the +link{toggleSwitch.thumb}.
    // @group appearance
    // @visibility external
    //<
    thumbOffset: 2,

    //> @attr toggleSwitch.defaultValue (Boolean : false : IRW)
    // The default value of this ToggleSwitch.
    // @group appearance
    // @visibility external
    //<
    defaultValue: false,

    //> @attr toggleSwitch.toggleBaseStyle (CSSStyleName : "toggleSwitch" : IRW)
    // The name of the CSS class to apply to this ToggleSwitch - the actual styleName applied 
    // will be suffixed "On" or "Off", depending on the widget's current value.
    // @group appearance
    // @visibility external
    //<
    toggleBaseStyle: "toggleSwitch",

    //> @attr toggleSwitch.thumb (AutoChild Canvas : null : IRW)
    // A canvas used as the thumb of this ToggleSwitch, which can be styled using 
    // +link{toggleSwitch.thumbBaseStyle} and otherwise modified according to the AutoChild 
    // pattern - <code>thumbConstructor</code>, <code>thumbDefaults</code> and
    // <code>thumbProperties</code> are valid.
    //
    // @visibility external
    //<
    thumbConstructor: "Canvas",
    thumbDefaults: {
        overflow: "hidden"
    },
    //thumbSize: 18,
    
    //> @attr toggleSwitch.thumbBaseStyle (CSSStyleName : "toggleSwitchThumb" : IRW)
    // The name of the base CSS class to apply to the +link{toggleSwitch.thumb, thumb} of this 
    // toggle switch - the actual styleName applied will be suffixed "On" or "Off",
    // depending on this widget's current value.
    // @group appearance
    // @visibility external
    //<
    thumbBaseStyle: "toggleSwitchThumb",

    //> @attr toggleSwitch.thumbRadius (String : null : IRW)
    // The CSS border-radius for the +link{toggleSwitch.thumb}.  The value can be any variant 
    // of a CSS border-radius value - that is, from 1 to 4 space-separated px values, where one 
    // value affects all corners and 4 values affects individual corners.  For example "10px" 
    // applies a 10px radius to all corners, where "5px 10px 15px 20px" applies a different 
    // radius to each corner, clockwise from Top-Left: "TL TR BR BL".
    // @visibility external
    // @group appearance
    //<
    //thumbRadius: "15px",

    //> @attr toggleSwitch.toggleOnThumbClick (Boolean : true : IRW)
    // When set to true, causes the ToggleSwitch to change value when the 
    // +link{toggleSwitch.thumb, thumb} is clicked, as well as when clicking in the widget body.
    // @group appearance
    // @visibility external
    //<
    toggleOnThumbClick: true,

    //> @attr toggleSwitch.toggleOnKeypress (Boolean : true : IRW)
    // When set to true, the value can be toggled by pressing the <i>Spacebar</i>, or changed 
    // with the left and right arrow-keys.
    // @group appearance
    // @visibility external
    //<
    toggleOnKeypress: true,
    
    //> @attr toggleSwitch.animateThumb (Boolean : true : IRW)
    // When set to true, animates the movement of the +link{toggleSwitch.thumb, thumb} when 
    // the value changes.
    // @group appearance
    // @visibility external
    //<
    animateThumb: true,
    
    //> @attr toggleSwitch.animateThumbTime (Integer : 200 : IRW)
    // When +link{toggleSwitch.animateThumb, animateThumb} is true, the time taken to move 
    // the +link{toggleSwitch.thumb, thumb} from one state to the other.
    // @group appearance
    // @visibility external
    //<
    animateThumbTime: 100,

    initWidget : function () {
        this.Super("initWidget", arguments);

        // it's obvious what an animateTime of zero means, but it doesn't work
        if (this.animateThumbTime == 0) this.animateThumbTime = 1;

        // properties for the thumb
        var props = isc.addProperties({}, this.thumbDefaults, {
            left: this.thumbOffset, top: this.thumbOffset,
            width: this.thumbSize != null ? this.thumbSize : 1,
            height: this.thumbSize != null ? this.thumbSize : 1,
            minHeight: 1,
            animateTime: this.animateThumbTime
        }, this.thumbProperties);

        // apply thumbRadius if set and borderRadius isn't already set
        if (this.thumbRadius && !props.borderRadius ) props.borderRadius = this.thumbRadius;

        // if thumbSize is set, update the outer height to fit
        if (this.thumbSize) {
            var vBorderPad = isc.Element._getVBorderPad(this.getToggleStyle());
            this.height = props.height + (this.thumbOffset*2) + (vBorderPad*2);
        }

        this.thumb = this.createAutoChild("thumb", props);
        this.addChild(this.thumb);
    },

    //> @attr toggleSwitch.value (Boolean : false : IRW)
    // The current value of this ToggleSwitch.
    // @group appearance
    // @visibility external
    //<
    //value: null,

    //> @method toggleSwitch.setValue()
    // Sets the +link{toggleSwitch.value} of this ToggleSwitch.
    // @param value (Boolean) new value for the ToggleSwitch
    // @visibility external
    //<
    setValue : function (value) {
        if (value == null) value = this.defaultValue;
        this.oldValue = this.value;
        this.value = value;
        this.setBaseStyle(this.getToggleStyle());
        this.updateThumb();
    },
    
    // return the actual baseStyle - toggleSwitch[On/Off]
    getToggleStyle : function () {
        return this.toggleBaseStyle + (this.value ? "On" : "Off");
    },

    //> @method toggleSwitch.getValue()
    // Returns the current +link{toggleSwitch.value} of this ToggleSwitch.
    // @return (Boolean) current value of the ToggleSwitch
    // @visibility external
    //<
    getValue : function () {
        return this.value;
    },

    //> @method toggleSwitch.valueChanged() (A)
    // Notification fired when the value is toggled by the user.
    //
    // @param newValue (Boolean) new value for the ToggleSwitch
    // @param oldValue (Boolean) previous value for the ToggleSwitch
    // @visibility external
    //<
    valueChanged : function (newValue, oldValue) {
    },

    draw : function () {
        var result = this.Super("draw", arguments);
        this.setValue(this.value);
    },

    updateThumb : function () {
        if (this.thumb.getVisibleHeight() != this.thumbSize) {
            // consider vBorderPad on the outer widget when auto-sizing the thumb
            var height = Math.floor(this.getHeight() - this.getVBorderPad() - (this.thumbOffset * 2));
            if (this.thumbSize) height = this.thumbSize;
            this.thumbSize = height;
            this.thumb.resizeTo(this.thumbSize, this.thumbSize);
        }
        var _this = this,
            left = !this.value ? this.thumbOffset : 
                       this.getInnerWidth() - this.thumb.getVisibleWidth() - this.thumbOffset
        ;
        if (this.animateThumb) {
            this.thumb.animateMove(left, this.thumbOffset, function () { 
            }, this.animateThumbTime);
        } else {
            this.thumb.moveTo(left, this.thumbOffset);
        }
        this.thumb.setStyleName(this.thumbBaseStyle + (this.value ? "On" : "Off"));
    },
    
    thumbClick : function () {
        if (this.toggleOnThumbClick) this.toggleValue();
    },
    
    toggleValue : function () {
        this.setValue(!this.value) 
        this.valueChanged(this.value, this.oldValue);
    },

    
    handleClick : function () {
        this.toggleValue();
        return this.Super("handleClick", arguments);
    },
    
    // let Spacebar toggle the value, and Left/Right arrows change the value 
    handleKeyPress : function (event, eventInfo) {
        if (this.toggleOnKeypress) {
            var key = event.keyName;
            switch (key) {
                case "Arrow_Left": 
                    if (this.value) this.toggleValue(); 
                    return false;
                case "Arrow_Right": 
                    if (!this.value) this.toggleValue(); 
                    return false;
                case "Space": 
                    this.toggleValue(); 
                    return false;
            }
        }
        return this.Super("handleKeyPress", arguments);
    }

});
