/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Provides class methods for enabling and disabling the use of AI technology, registering and unregistering {@link
 * com.smartgwt.client.ai.AIEngine AI engines}, and performing high-level operations using installed AI engines.
 */
@BeanFactory.FrameworkClass
public class AI {


    // ********************* Static Attributes ***********************

    /** 
     * The ID of the default {@link com.smartgwt.client.ai.AIEngine} to use.
     *
     * @param defaultEngineId new defaultEngineId.  Default value is "gpt-4.1".
     */
    public static native void setDefaultEngineId(String defaultEngineId) /*-{
        @com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)($wnd.isc.AI, "defaultEngineId", defaultEngineId);
    }-*/;

    /** 
     * The ID of the default {@link com.smartgwt.client.ai.AIEngine} to use.
     *
     * @return current value of defaultEngineId
     */
    public static native String getDefaultEngineId() /*-{
        return $wnd.isc.AI.defaultEngineId;
    }-*/;

    /** 
     * The defualt maximum number of retries for any one particular request to AI.
     *
     * @param defaultMaxRetries new defaultMaxRetries.  Default value is 2.
     */
    public static native void setDefaultMaxRetries(int defaultMaxRetries) /*-{
        @com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;I)($wnd.isc.AI, "defaultMaxRetries", defaultMaxRetries);
    }-*/;

    /** 
     * The defualt maximum number of retries for any one particular request to AI.
     *
     * @return current value of defaultMaxRetries
     */
    public static native int getDefaultMaxRetries() /*-{
        var result = $wnd.isc.AI.defaultMaxRetries;
        if (result == null) result = 0;
        return @com.google.gwt.core.client.GWT::isScript()() ? result : result.valueOf(); 
    }-*/;

    /** 
     * Whether AI is disabled. <p> By default, AI is disabled. This static property must be set to <code>false</code> and the
     * {@link com.smartgwt.client.ai.AI#defaultEngineId default} {@link com.smartgwt.client.ai.AIEngine} must be registered in
     * order to enable the use of AI in the application.
     *
     * @param disabled new disabled.  Default value is true.
     */
    public static native void setDisabled(Boolean disabled) /*-{
        @com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/Boolean;)($wnd.isc.AI, "disabled", disabled);
    }-*/;

    /** 
     * Whether AI is disabled. <p> By default, AI is disabled. This static property must be set to <code>false</code> and the
     * {@link com.smartgwt.client.ai.AI#defaultEngineId default} {@link com.smartgwt.client.ai.AIEngine} must be registered in
     * order to enable the use of AI in the application.
     *
     * @return current value of disabled
     */
    public static native Boolean getDisabled() /*-{
        var result = $wnd.isc.AI.disabled;
        if (result == null) result = null;
        if (!@com.google.gwt.core.client.GWT::isScript()()) result = result.valueOf();
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(result);
    }-*/;

    // ********************* Properties / Attributes ***********************

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

	/**
     * Requests that available AI engine(s) be used to evaluate an "aiFilter" {@link com.smartgwt.client.data.AdvancedCriteria}
     * on a list of records.
     * @param applyRequest The request to AI to evaluate an "aiFilter" <code>AdvancedCriteria</code>.
     * @param callback The callback to call with the result.
     */
    public static native void applyAIFilter(ApplyAIFilterRequest applyRequest, ApplyAIFilterResponseCallback callback) /*-{
        $wnd.isc.AI.applyAIFilter(applyRequest.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(applyResponse, applyRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.ApplyAIFilterResponseCallback::execute(Lcom/smartgwt/client/ai/ApplyAIFilterResponse;Lcom/smartgwt/client/ai/ApplyAIFilterRequest;)(
					@com.smartgwt.client.ai.ApplyAIFilterResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(applyResponse), 
					@com.smartgwt.client.ai.ApplyAIFilterRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(applyRequest)
				);
			}));
    }-*/;







	/**
     * Requests that available AI engine(s) be used to build an {@link com.smartgwt.client.ai.AIFieldRequest} from a natural
     * language description of the per-record values to generate for a new AI-generated field.
     * @param buildRequest The request.
     * @param callback The callback to  fire with the result.
     */
    public static native void buildAIFieldRequest(BuildAIFieldRequestRequest buildRequest, BuildAIFieldRequestResponseCallback callback) /*-{
        $wnd.isc.AI.buildAIFieldRequest(buildRequest.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(buildResponse, buildRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.BuildAIFieldRequestResponseCallback::execute(Lcom/smartgwt/client/ai/BuildAIFieldRequestResponse;Lcom/smartgwt/client/ai/BuildAIFieldRequestRequest;)(
					@com.smartgwt.client.ai.BuildAIFieldRequestResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildResponse), 
					@com.smartgwt.client.ai.BuildAIFieldRequestRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildRequest)
				);
			}));
    }-*/;


	/**
     * Requests that available AI engine(s) be used to build an {@link com.smartgwt.client.data.AdvancedCriteria} object
     * according to the user's natural language description of a filter.
     * @param buildRequest The request.
     * @param callback The callback to  fire with the result.
     */
    public static native void buildCriterion(BuildCriterionRequest buildRequest, BuildCriterionResponseCallback callback) /*-{
        $wnd.isc.AI.buildCriterion(buildRequest.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(buildResponse, buildRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.BuildCriterionResponseCallback::execute(Lcom/smartgwt/client/ai/BuildCriterionResponse;Lcom/smartgwt/client/ai/BuildCriterionRequest;)(
					@com.smartgwt.client.ai.BuildCriterionResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildResponse), 
					@com.smartgwt.client.ai.BuildCriterionRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildRequest)
				);
			}));
    }-*/;


	/**
     * Requests that available AI engine(s) be used to build data-bound UI component(s) according to a user's description of
     * what they would like to build.
     * @param buildRequest The request to AI to build data-bound UI.
     * @param callback The callback to call with the result.
     */
    public static native void buildDataBoundUI(BuildDataBoundUIViaAIRequest buildRequest, BuildUIViaAIResponseCallback callback) /*-{
        $wnd.isc.AI.buildDataBoundUI(buildRequest.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(buildResponse, buildRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.BuildUIViaAIResponseCallback::execute(Lcom/smartgwt/client/ai/BuildUIViaAIResponse;Lcom/smartgwt/client/ai/BuildUIViaAIRequest;)(
					@com.smartgwt.client.ai.BuildUIViaAIResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildResponse), 
					@com.smartgwt.client.ai.BuildUIViaAIRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildRequest)
				);
			}));
    }-*/;


	/**
     * Requests that available AI engine(s) be used to build one or more {@link com.smartgwt.client.data.Hilite} objects
     * according to the user's natural language description of hilite criteria and styling to apply.
     * @param buildRequest The request to AI to build <code>Hilite</code> object(s).
     * @param callback The callback to call with the result.
     */
    public static native void buildHilites(BuildHilitesRequest buildRequest, BuildHilitesResponseCallback callback) /*-{
        $wnd.isc.AI.buildHilites(buildRequest.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(buildResponse, buildRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.BuildHilitesResponseCallback::execute(Lcom/smartgwt/client/ai/BuildHilitesResponse;Lcom/smartgwt/client/ai/BuildHilitesRequest;)(
					@com.smartgwt.client.ai.BuildHilitesResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildResponse), 
					@com.smartgwt.client.ai.BuildHilitesRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(buildRequest)
				);
			}));
    }-*/;


	/**
     * Removes information for all records to which an "aiFilter" {@link com.smartgwt.client.data.AdvancedCriteria} has been
     * applied.
     * @param aiCriterion The "aiFilter" <code>AdvancedCriteria</code> to update.
     */
    public static native void clearAIFilterCaches(AdvancedCriteria aiCriterion) /*-{
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(aiCriterion)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(aiCriterion.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        $wnd.isc.AI.clearAIFilterCaches(aiCriterion.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;


	/**
     * Returns the {@link com.smartgwt.client.ai.AIEngine} having the given engine ID.
     *
     * @return the <code>AIEngine</code>, or <code>null</code> if the <code>AIEngine</code> could not be found.
     */
    public static native AIEngine getEngine() /*-{
        var ret = $wnd.isc.AI.getEngine();
        if(ret == null) return null;
        return @com.smartgwt.client.ai.AIEngine::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns the {@link com.smartgwt.client.ai.AIEngine} having the given engine ID.
     * @param engineId the engineId of the <code>AIEngine</code> to get. If not specified, {@link com.smartgwt.client.ai.AI#defaultEngineId
     * defaultEngineId} is used.
     *
     * @return the <code>AIEngine</code>, or <code>null</code> if the <code>AIEngine</code> could not be found.
     */
    public static native AIEngine getEngine(String engineId) /*-{
        var ret = $wnd.isc.AI.getEngine(engineId);
        if(ret == null) return null;
        return @com.smartgwt.client.ai.AIEngine::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	

	/**
     * Returns <code>true</code> if the given {@link com.smartgwt.client.ai.AIFieldRequest} is numerical (its {@link
     * com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is ORDINAL, INTERVAL, or RATIO); <code>false</code>
     * otherwise.
     * @param aiFieldRequest The <code>AIFieldRequest</code> to test.
     *
     * @return <code>true</code> if and only if the given <code>AIFieldRequest</code> is numerical.
     */
    public static native Boolean isAIFieldRequestNumerical(AIFieldRequest aiFieldRequest) /*-{
        var ret = $wnd.isc.AI.isAIFieldRequestNumerical(aiFieldRequest.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Determines whether AI support is enabled. {@link com.smartgwt.client.ai.AI#disabled disabled} must be set to
     * <code>false</code> and the default {@link com.smartgwt.client.ai.AIEngine} must be registered in order to enable the use
     * of AI.
     *
     * @return <code>true</code> if the use of AI is enabled; <code>false</code> otherwise.
     * @see com.smartgwt.client.ai.AI#disabled
     * @see com.smartgwt.client.ai.AI#defaultEngineId
     */
    public static native boolean isEnabled() /*-{
        var ret = $wnd.isc.AI.isEnabled();
        return ret == null ? false : ret;
    }-*/;


	/**
     * Registers the given {@link com.smartgwt.client.ai.AIEngine}.
     * @param engine The <code>AIEngine</code> to register.
     *
     * @return <code>true</code> if the <code>AIEngine</code> was successfully registered; <code>false</code> otherwise.
     * @see com.smartgwt.client.ai.AI#unregisterEngine
     */
    public static native boolean registerEngine(AIEngine engine) /*-{
        var ret = $wnd.isc.AI.registerEngine(engine == null ? null : engine.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
        return ret == null ? false : ret;
    }-*/;


	/**
     * Removes information for the given records from an "aiFilter" {@link com.smartgwt.client.data.AdvancedCriteria}.
     * @param aiCriterion The "aiFilter" <code>AdvancedCriteria</code> to update.
     * @param records The records, about which any information held in <code>aiCriterion</code> will be removed.
     */
    public static native void removeFromAIFilterCaches(AdvancedCriteria aiCriterion, Record... records) /*-{
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(aiCriterion)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(aiCriterion.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        $wnd.isc.AI.removeFromAIFilterCaches(aiCriterion.@com.smartgwt.client.core.DataClass::getJsObj()(), @com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;


	/**
     * Evaluates the given {@link com.smartgwt.client.docs.DynamicStrings dynamic string} to form a prompt string that is then
     * sent as the request to the default AI engine. <p> Within <code>dynamicString</code>, any evaluated JavaScript
     * expressions have access to all of the values in the <code>context</code> ValueMap.
     * @param dynamicString A dynamic string.
     * See {@link com.smartgwt.client.docs.DynamicString DynamicString}
     * @param context A map from each in-scope {@link com.smartgwt.client.docs.Identifier} to its value.
     * @param callback The callback to fire with the response from AI.
     */
    public static native void sendPrompt(String dynamicString, Map context, AIResponseCallback callback) /*-{
        $wnd.isc.AI.sendPrompt(dynamicString, context == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(context), 
			$entry( function(aiResponse, aiRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.AIResponseCallback::execute(Lcom/smartgwt/client/ai/AIResponse;Lcom/smartgwt/client/ai/AIRequest;)(
					@com.smartgwt.client.ai.AIResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(aiResponse), 
					@com.smartgwt.client.ai.AIRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(aiRequest)
				);
			}));
    }-*/;


	/**
     * Requests that available {@link com.smartgwt.client.ai.AIEngine}(s) be used to suggest an appropriate title for a new
     * field that will contain AI-generated record summaries.
     * @param request The request.
     * @param callback The callback to  fire with the result.
     */
    public static native void suggestRecordSummaryTitle(SuggestRecordSummaryTitleRequest request, SuggestRecordSummaryTitleCallback callback) /*-{
        $wnd.isc.AI.suggestRecordSummaryTitle(request.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(result, request) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.SuggestRecordSummaryTitleCallback::execute(Lcom/smartgwt/client/ai/SuggestRecordSummaryTitleResult;Lcom/smartgwt/client/ai/SuggestRecordSummaryTitleRequest;)(
					result != null ? @com.smartgwt.client.ai.SuggestRecordSummaryTitleResult::new(Lcom/google/gwt/core/client/JavaScriptObject;)(result) : null, 
					@com.smartgwt.client.ai.SuggestRecordSummaryTitleRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(request)
				);
			}));
    }-*/;


	/**
     * Requests that available AI engine(s) be used to generate summaries of records according to the user's natural language
     * description of how to summarize each record.
     * @param request The request.
     * @param partialResultCallback The callback to  fire with each partial result.
     * @param callback The callback to fire with the result.
     */
    public static native void summarizeRecords(SummarizeRecordsRequest request, SummarizeRecordsPartialResultCallback partialResultCallback, SummarizeRecordsResultCallback callback) /*-{
        $wnd.isc.AI.summarizeRecords(request.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(partialResult, context) { 
				if(partialResultCallback!=null) partialResultCallback.@com.smartgwt.client.callbacks.SummarizeRecordsPartialResultCallback::execute(Lcom/smartgwt/client/ai/SummarizeRecordsPartialResult;Lcom/smartgwt/client/ai/SummarizeRecordsContext;)(
					partialResult != null ? @com.smartgwt.client.ai.SummarizeRecordsPartialResult::new(Lcom/google/gwt/core/client/JavaScriptObject;)(partialResult) : null, 
					context != null ? @com.smartgwt.client.ai.SummarizeRecordsContext::new(Lcom/google/gwt/core/client/JavaScriptObject;)(context) : null
				);
			}), 
			$entry( function(result, request) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.SummarizeRecordsResultCallback::execute(Lcom/smartgwt/client/ai/SummarizeRecordsResult;Lcom/smartgwt/client/ai/SummarizeRecordsRequest;)(
					result != null ? @com.smartgwt.client.ai.SummarizeRecordsResult::new(Lcom/google/gwt/core/client/JavaScriptObject;)(result) : null, 
					@com.smartgwt.client.ai.SummarizeRecordsRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(request)
				);
			}));
    }-*/;


	/**
     * Requests that available AI engine(s) be used to generate a summary of a value according to a natural language
     * description of how to summarize the value.
     * @param request The request.
     * @param callback The callback to fire with the {@link com.smartgwt.client.ai.SummarizeValueResult}.
     */
    public static native void summarizeValue(SummarizeValueRequest request, SummarizeValueResultCallback callback) /*-{
        $wnd.isc.AI.summarizeValue(request.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(result, request) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.SummarizeValueResultCallback::execute(Lcom/smartgwt/client/ai/SummarizeValueResult;Lcom/smartgwt/client/ai/SummarizeValueRequest;)(
					result != null ? @com.smartgwt.client.ai.SummarizeValueResult::new(Lcom/google/gwt/core/client/JavaScriptObject;)(result) : null, 
					@com.smartgwt.client.ai.SummarizeValueRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(request)
				);
			}));
    }-*/;


	/**
     * Unregisters an {@link com.smartgwt.client.ai.AIEngine} specified by its ID.
     * @param engineId the ID of the <code>AIEngine</code> to unregister.
     *
     * @return <code>true</code> if the <code>AIEngine</code> was successfully unregistered; <code>false</code> otherwise.
     * @see com.smartgwt.client.ai.AI#registerEngine
     */
    public static native boolean unregisterEngine(String engineId) /*-{
        var ret = $wnd.isc.AI.unregisterEngine(engineId);
        return ret == null ? false : ret;
    }-*/;


    // ***********************************************************



    /**
     * Reports whether the optional AI module is loaded for the page.
     * @return true if and only if the AI module has been loaded
     */
    public static native boolean moduleLoaded() /*-{
        return $wnd.isc.AI != null;
    }-*/;

    public static void checkModuleLoaded (String faultingAction) {
        if (!moduleLoaded()) {
            String errorMessage = "Attempt to " + faultingAction +
                ".  This requires the optional AI module which is " + 
                (SC.hasAI() ? "not currently loaded." : "not present in this build.");
            SC.logWarn(errorMessage);
            throw new UnsupportedOperationException(errorMessage);
        }
    }


}
