package com.smartgwt.sample.client;

import com.smartgwt.client.data.*;
import com.smartgwt.client.types.*;

public class AnimalsDataSource extends DataSource {

    public static String ANIMALS_DSID = "AnimalsDS";

    public AnimalsDataSource() {
        setID(ANIMALS_DSID);
        setClientOnly(true);

        DataSourceField     commonName = new DataSourceField("commonName",     FieldType.TEXT);
        DataSourceField scientificName = new DataSourceField("scientificName", FieldType.TEXT);
        DataSourceField       lifeSpan = new DataSourceField("lifeSpan", FieldType.INTEGER);

        DataSourceField status = new DataSourceField("status", FieldType.TEXT);
        status.setValueMap("Threatened", "Endangered", "Not Endangered",
                           "Not currently listed", "May become threatened", "Protected");

        DataSourceField diet = new DataSourceField("diet", FieldType.TEXT);

        setFields(commonName, scientificName, lifeSpan, status, diet);
    }

    public static DataSource getInstance() {
        DataSource instance = DataSource.get(ANIMALS_DSID);
        return instance != null ? instance : new AnimalsDataSource();
    }

    public static class AnimalRecord extends Record {
        public AnimalRecord(String commonName, String scientificName, int lifeSpan,
                            String status, String diet)
        {
            setAttribute("commonName", commonName);
            setAttribute("scientificName", scientificName);
            setAttribute("lifeSpan", lifeSpan);
            setAttribute("status", status);
            setAttribute("diet", diet);
        }
    }

}
