/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFieldFormula;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.io.File;
import java.util.List;
import java.util.Map;

public class SnowflakeDriver
extends SQLDriver {
    private static Logger log = new Logger(SnowflakeDriver.class.getName());

    public SnowflakeDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return true;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        String regexpSQL = "REGEXP_LIKE(" + escapedColumnOrExpression;
        if ("iregexp".equals(operator)) {
            regexp = regexp + ", '', 'i'";
        }
        regexpSQL = regexpSQL + this.escapeRegexpUnquoted(regexp);
        regexpSQL = regexpSQL + "')";
        return regexpSQL;
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        String q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? q + " ORDER BY " : q + ", ";
        }
        return q + " LIMIT " + batchSize + " OFFSET " + startRow;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue((String)ds.getCorrectDs2NativeFieldMap().get(sequenceName), ds);
            if (sequence == null) continue;
            Object obj = SnowflakeDriver.getScalarResult("SELECT " + sequence, this.dbConnection, this.dbName, this, req);
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
                continue;
            }
            primaryKeys.put(sequenceName, obj);
        }
        return primaryKeys;
    }

    @Override
    public boolean useActualSequenceObjects(SQLDataSource ds) {
        return true;
    }

    @Override
    public boolean shouldPrefetchNextSequenceValue(SQLDataSource ds) {
        return true;
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = dataSource.getSchemaName();
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".NextVal";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        throw new Exception("Not Supported");
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String transformFormula(String formula) {
        formula = DSFieldFormula.replace((String)formula, (String)"max", (String)"greatest");
        formula = DSFieldFormula.replace((String)formula, (String)"min", (String)"least");
        formula = DSFieldFormula.replace((String)formula, (String)"pow", (String)"power");
        return formula;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        StringBuffer expr = new StringBuffer("CASE ").append(column);
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr.append(" WHEN ").append(actualValue).append(" THEN ").append(displayValue);
        }
        expr.append(" ELSE CAST (").append(column).append(" AS STRING) END");
        return expr.toString();
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (field.get((Object)"formula") != null && !field.typeIsDefaulted() && DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"text")) {
            return "CAST(" + result + " AS STRING)";
        }
        return super.sqlCast(result, field);
    }

    @Override
    public boolean canSetFetchSize() {
        return false;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }

    @Override
    protected boolean supportsBinaryStreams() {
        return false;
    }

    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        throw new Exception("Snowflake does not currently support snapshots");
    }

    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        throw new Exception("Snowflake does not currently support snapshots");
    }

    @Override
    public int caseInsensitiveStrategy() {
        return 0;
    }

    @Override
    public String caseInsensitiveLikePredicate() {
        return "ILIKE";
    }

    @Override
    public String caseInsensitiveEqualsPredicate() {
        return " ILIKE ";
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        if (length <= 0xFFFFFFL) {
            return "varchar(" + length + ")";
        }
        throw new Exception("Column length > 16MB is not supported by Snowflake");
    }

    @Override
    public String getFloatType() {
        return "float";
    }

    @Override
    public String getAllowNullSuffix() {
        return "NULL";
    }
}

