/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.BaseListenerWrapper;
import com.google.gwt.user.client.HistoryListener;
import com.google.gwt.user.client.Window;

public class History {
    private static HistoryImpl impl = (HistoryImpl)GWT.create(HistoryImpl.class);
    private static HistoryEventSource historyEventSource = new HistoryEventSource();
    private static HistoryTokenEncoder tokenEncoder = (HistoryTokenEncoder)GWT.create(HistoryTokenEncoder.class);
    private static String token = History.getDecodedHash();

    @Deprecated
    public static void addHistoryListener(HistoryListener listener) {
        WrapHistory.add(listener);
    }

    public static HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return historyEventSource.addValueChangeHandler(handler);
    }

    public static native void back();

    public static String encodeHistoryToken(String historyToken) {
        return tokenEncoder.encode(historyToken);
    }

    public static void fireCurrentHistoryState() {
        String currentToken = History.getToken();
        historyEventSource.fireValueChangedEvent(currentToken);
    }

    public static native void forward();

    public static String getToken() {
        return token;
    }

    public static void newItem(String historyToken) {
        History.newItem(historyToken, true);
    }

    public static void newItem(String historyToken, boolean issueEvent) {
        String string = historyToken = historyToken == null ? "" : historyToken;
        if (!historyToken.equals(History.getToken())) {
            token = historyToken;
            String updateToken = History.encodeHistoryToken(historyToken);
            impl.newToken(updateToken);
            if (issueEvent) {
                historyEventSource.fireValueChangedEvent(historyToken);
            }
        }
    }

    @Deprecated
    public static void onHistoryChanged(String historyToken) {
        historyEventSource.fireValueChangedEvent(historyToken);
    }

    @Deprecated
    public static void removeHistoryListener(HistoryListener listener) {
        WrapHistory.remove(historyEventSource.getHandlers(), listener);
    }

    public static void replaceItem(String historyToken) {
        History.replaceItem(historyToken, true);
    }

    public static void replaceItem(String historyToken, boolean issueEvent) {
        token = historyToken;
        impl.replaceToken(History.encodeHistoryToken(historyToken));
        if (issueEvent) {
            History.fireCurrentHistoryState();
        }
    }

    private static String getDecodedHash() {
        String hashToken = Window.Location.getHash();
        if (hashToken == null || hashToken.isEmpty()) {
            return "";
        }
        return tokenEncoder.decode(hashToken.substring(1));
    }

    private static void onHashChanged() {
        String hashToken = History.getDecodedHash();
        if (!hashToken.equals(History.getToken())) {
            token = hashToken;
            historyEventSource.fireValueChangedEvent(hashToken);
        }
    }

    private static class WrapHistory
    extends BaseListenerWrapper<HistoryListener>
    implements ValueChangeHandler<String> {
        @Deprecated
        public static void add(HistoryListener listener) {
            History.addValueChangeHandler(new WrapHistory(listener));
        }

        public static void remove(HandlerManager manager, HistoryListener listener) {
            WrapHistory.baseRemove(manager, listener, ValueChangeEvent.getType());
        }

        private WrapHistory(HistoryListener listener) {
            super(listener);
        }

        @Override
        public void onValueChange(ValueChangeEvent<String> event) {
            ((HistoryListener)this.listener).onHistoryChanged(event.getValue());
        }
    }

    private static class HistoryImpl {
        public HistoryImpl() {
            this.attachListener();
        }

        protected native void attachListener();

        public native void newToken(String var1);

        public void replaceToken(String historyToken) {
            Window.Location.replace("#" + historyToken);
        }
    }

    private static class NoopHistoryTokenEncoder
    extends HistoryTokenEncoder {
        private NoopHistoryTokenEncoder() {
        }

        @Override
        public String encode(String toEncode) {
            return toEncode;
        }

        @Override
        public String decode(String toDecode) {
            return toDecode;
        }
    }

    private static class HistoryTokenEncoder {
        private HistoryTokenEncoder() {
        }

        public native String encode(String var1);

        public native String decode(String var1);
    }

    private static class HistoryEventSource
    implements HasValueChangeHandlers<String> {
        private HandlerManager handlers = new HandlerManager(null);

        private HistoryEventSource() {
        }

        @Override
        public void fireEvent(GwtEvent<?> event) {
            this.handlers.fireEvent(event);
        }

        @Override
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
            return this.handlers.addHandler(ValueChangeEvent.getType(), handler);
        }

        public void fireValueChangedEvent(String newToken) {
            ValueChangeEvent.fire(this, newToken);
        }

        public HandlerManager getHandlers() {
            return this.handlers;
        }
    }
}

