/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class JBossNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JBOSS_JCA_PREFIX = "org.jboss.jca.adapters.jdbc.";
    private static final String JBOSS_RESOURCE_PREFIX = "org.jboss.resource.adapter.jdbc.";
    private Class<?> wrappedConnectionClass;
    private Class<?> wrappedStatementClass;
    private Class<?> wrappedResultSetClass;
    private Method getUnderlyingConnectionMethod;
    private Method getUnderlyingStatementMethod;
    private Method getUnderlyingResultSetMethod;

    public JBossNativeJdbcExtractor() {
        String prefix = JBOSS_JCA_PREFIX;
        try {
            this.wrappedConnectionClass = this.getClass().getClassLoader().loadClass(prefix + "WrappedConnection");
        }
        catch (ClassNotFoundException ex) {
            prefix = JBOSS_RESOURCE_PREFIX;
            try {
                this.wrappedConnectionClass = this.getClass().getClassLoader().loadClass(prefix + "WrappedConnection");
            }
            catch (ClassNotFoundException ex2) {
                throw new IllegalStateException("Could not initialize JBossNativeJdbcExtractor: neither JBoss 7's [org.jboss.jca.adapters.jdbc..WrappedConnection] nor traditional JBoss [org.jboss.resource.adapter.jdbc..WrappedConnection] found");
            }
        }
        try {
            this.wrappedStatementClass = this.getClass().getClassLoader().loadClass(prefix + "WrappedStatement");
            this.wrappedResultSetClass = this.getClass().getClassLoader().loadClass(prefix + "WrappedResultSet");
            this.getUnderlyingConnectionMethod = this.wrappedConnectionClass.getMethod("getUnderlyingConnection", null);
            this.getUnderlyingStatementMethod = this.wrappedStatementClass.getMethod("getUnderlyingStatement", null);
            this.getUnderlyingResultSetMethod = this.wrappedResultSetClass.getMethod("getUnderlyingResultSet", null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize JBossNativeJdbcExtractor because of missing JBoss API methods/classes: " + ex);
        }
    }

    @Override
    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.wrappedConnectionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeJdbcMethod((Method)this.getUnderlyingConnectionMethod, (Object)con);
        }
        return con;
    }

    @Override
    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (this.wrappedStatementClass.isAssignableFrom(stmt.getClass())) {
            return (Statement)ReflectionUtils.invokeJdbcMethod((Method)this.getUnderlyingStatementMethod, (Object)stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        return (PreparedStatement)this.getNativeStatement(ps);
    }

    @Override
    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return (CallableStatement)this.getNativeStatement(cs);
    }

    @Override
    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        if (this.wrappedResultSetClass.isAssignableFrom(rs.getClass())) {
            return (ResultSet)ReflectionUtils.invokeJdbcMethod((Method)this.getUnderlyingResultSetMethod, (Object)rs);
        }
        return rs;
    }
}

