/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.servlet.RequestContext;
import java.util.List;
import java.util.Map;

public abstract class ISCMessageDispatcher {
    static Config config = Config.getGlobal();
    private static Logger log = new Logger(ISCMessageDispatcher.class.getName());

    public static ISCMessageDispatcher instance() throws Exception {
        String implementer = config.getString((Object)"messaging.dispatcherImplementer");
        return (ISCMessageDispatcher)Reflection.instantiateClass((String)implementer);
    }

    public static ISCMessageDispatcher instance(RequestContext context) throws Exception {
        return ISCMessageDispatcher.instance();
    }

    public void setClientID(String clientID) throws Exception {
        throw new Exception("setClientID not supported on " + this.getClass().getName());
    }

    public void register(ISubscriber subscriber) throws Exception {
    }

    public void unregister(ISubscriber subscriber) throws Exception {
    }

    public void subscribe(ISubscriber subscriber, String channel) throws Exception {
        this.subscribe(subscriber, channel, null);
    }

    public void subscribe(ISubscriber subscriber, Map<String, ?> channels) throws Exception {
        if (channels != null) {
            for (String channel : channels.keySet()) {
                Map dataChannel = channels.get(channel) == null ? null : (Map)channels.get(channel);
                String selector = dataChannel.get("selector") == null ? null : (String)dataChannel.get("selector");
                this.subscribe(subscriber, channel, selector);
            }
        }
    }

    public abstract void subscribe(ISubscriber var1, String var2, String var3) throws Exception;

    public void unsubscribe(ISubscriber subscriber, List<String> channels) throws Exception {
        for (String channel : channels) {
            this.unsubscribe(subscriber, channel);
        }
    }

    public abstract void unsubscribe(ISubscriber var1, String var2) throws Exception;

    public void send(ISCMessage msg) throws Exception {
        this.deliver(msg);
    }

    public abstract void deliver(ISCMessage var1) throws Exception;

    public abstract void stop();

    public abstract void closeConnection();

    public boolean isSubscribed(ISubscriber subscriber, String channel) throws Exception {
        throw new Exception("Not valid for this dispatcher");
    }
}

