
package com.smartgwt.client.docs;

/**
 * <h3>StockIcons Overview</h3>
 * The <i>StockIcons</i> system allows known graphics to be re-used throughout your 
 *  projects by using their names in src-strings, instead of their URLs or sprite-strings - 
 *  this avoids the need for hard-coded paths in source-code, and allows the actual image 
 *  applied by the StockIcon name to be easily modified <b><i>at runtime</i></b> without 
 *  trawling through code doing find-and-replace operations.
 *  <p>
 *  StockIcons can also map  from a known file-path, meaning that 
 *  legacy paths in existing code don't need to be modified - if your code requests a 
 *  file-path which is assigned to the <i>fromSrc</i> of a known StockIcon, it will first 
 *  be mapped to that StockIcon, and then it will render whatever image is 
 *   currently assigned to it.
 *  <p>
 *  The framework ships with  many such StockIcon-definitions 
 *  that represent the numerous images available in the "images/" directory of a skin.  
 *  You can use these builtin definitions in your code directly, by setting a widget's 
 *  icon or src property to the name of a StockIcon. For example, to re-use the current 
 *  skin's default "Edit" icon, you could set the image-source for a button's 
 * {@link com.smartgwt.client.widgets.Button#getIcon icon} to "[SKINIMG]actions/edit.png" in your
 * code.  With StockIcons, 
 *  you can use just the associated icon's name, "Edit" - for example:
 *  <pre>
 *  isc.Button.create({ icon: "Edit" });
 *  isc.Img.create({ src: "Edit" });
 *  </pre>
 *  <p>
 *  You can also provide additional customization along with the StockIcon-name.  For 
 * example, if your StockIcons are mapped to {@link com.smartgwt.client.docs.SvgSymbols stylable
 * SVG Symbols} 
 * via {@link com.smartgwt.client.docs.SCSpriteConfig sprite-strings} (our Shiva skin does this),
 * you can 
 *  add a colon (":") right after the StockIcon-name and then include any additional 
 *  properties that are supported by SVG sprite-strings, to modify this instance of the 
 *  base StockIcon definition.
 *  <pre>
 *  // make it red and semi-transparent
 *  isc.Button.create({ icon: "Edit:color:red;opacity:0.5;" });
 *  // set a size and show it upside-down
 *  isc.Img.create({ src: "Edit:size:24,24;rotate:180;" });
 *  </pre>
 *  <p>
 */
public interface StockIcons {
}
