/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.data;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Data components such as {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link
 * com.smartgwt.client.widgets.tile.TileGrid} may allow users to set up their own  search criteria within an application,
 * either via an external {@link com.smartgwt.client.widgets.form.SearchForm}, or through built  in UI such as the {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor ListGrid.filterEditor}. <P> The "Saved Search" subsystem
 * allows users to save out their criteria (and in some cases user-configured view state) so when the application is
 * reloaded they can  easily restore a search or view from a previous session. <P> <i><b>Note:</b> The SavedSearches
 * feature requires <a href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.</i> <P>
 * User interface components for storing and retreiving saved searches are available via the built in ListGrid features
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSaveSearches ListGrid.canSaveSearches} and {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchStoredState ListGrid.savedSearchStoredState}, as well as the
 * explicit the SavedSearchForm and {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem} classes. <P> <h4>The
 * SavedSearches class</h4> <code>SavedSearches</code> is a "singleton" class that provides central handling of storing and
 * loading saved search data. <p> You acquire the <code>SavedSearches</code> singleton via {@link
 * com.smartgwt.client.data.SavedSearches#get get()} and you can configure defaults via  Class.addProperties() or 
 * Class.changeDefaults(). <p> Saved searches are stored {@link com.smartgwt.client.util.JSONEncoder serialized as JSON} in
 * {@link com.smartgwt.client.data.DataSource} Records.<br> By default saved searches are stored in HTML5 browser
 * <code>localStorage</code> via automatically generated custom DataSources. In this mode the searches are only retained
 * for a specific user  on a particular machine, and searches cannot be shared with other users - but this approach is
 * sufficient for many applications, works out of the box, does not require any storage and has no impact on scalability.
 * <P> For more capable saved search storage and retrieval, an explicit saved search dataSource backed by permanent storage
 * such as an SQL database table may be specified.<br> Typically this is done by setting up the {@link
 * com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource}. This will store searches for all users
 * and for every component and the same dataSource may even be used for multiple applications.<br> For finer grained
 * control, individual saved search dataSources may also be specified  {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS per component}. <p> See {@link
 * com.smartgwt.client.data.SavedSearches#getSavedSearchDataSource getSavedSearchDataSource()} for how to retrieve the
 * dataSource for a component. <p> A SavedSearch dataSource has the following fields, some of which are optional, all of
 * which can be renamed as needed. (Click the links to see the purpose of each field): <ul> <li> {@link
 * com.smartgwt.client.data.SavedSearches#getPrimaryKeyField "pk"} (primary key field, typically of type "sequence") <li>
 * {@link com.smartgwt.client.data.SavedSearches#getDataField "data"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getSearchNameField "searchName"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getComponentIdField "componentId"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getProjectIdField "projectId"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getScreenIdField "screenId"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getApplicationIdField "applicationId"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getUserIdField "userId"} <li> {@link
 * com.smartgwt.client.data.SavedSearches#getAdminField "admin"} See "Admin-Configured Shared Searches" below. <li> {@link
 * com.smartgwt.client.data.SavedSearches#getDefaultField "isDefault"}, See "Default Searches" below. <li> {@link
 * com.smartgwt.client.data.SavedSearches#getAdminDefaultField "isSharedDefault"}, See "Default Searches" below. </ul> <p>
 * In your SDK, look for <code>sc_SavedSearches.ds.xml</code> for a sample SQL-based implementation of saved-search
 * (entirely declarative).  Note that {@link com.smartgwt.client.data.DataSource#getCacheAllData DataSource.cacheAllData}
 * is set to true - this causes all searches applicable to a given user to be loaded in advance, the first time any
 * component requests saved searches.  For most applications, this is the right approach, and is much better than
 * performing server requests each time a new component is shown that <i>might</i> have saved searches. <p> Note that the
 * SavedSearches system can be used to store any kind of component setting; in particular, {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getCanSaveSearches ListGrids} used <code>SavedSearches</code> to store
 * complete {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState}, which includes field order &
 * visibility, sorting and group state in addition to search criteria. <p> <h4>Admin-Configured Shared Searches</h4> <p>
 * <i>Shared searches</i> (also referred to as <i>"Admin Searches"</i>) are special searches that appear for <b>all</b>
 * users, as pre-configured default saved searches. While any user can create and edit their own personal saved searches,
 * admin searches  can only be created or edited by users with the {@link
 * com.smartgwt.client.data.SavedSearches#getAdminRole adminRole} (see below). <P> Admin searches are not available when no
 * dataSource was configured to store the savedSearch data. In this case a user's searches are stored to their machine
 * rather than in a central database,  and the concept of sharing admin-created searches does not apply. <P> Admin searches
 * are identified by either  having the {@link com.smartgwt.client.data.SavedSearches#getUserIdField userIdField} null, or
 * by the separate boolean  {@link com.smartgwt.client.data.SavedSearches#getAdminField adminField} set to true. <p> UI
 * components such as {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem} will offer a UI for adding,  editing
 * and removing admin searches if the user has the {@link com.smartgwt.client.data.SavedSearches#getAdminRole adminRole},
 * as determined by {@link com.smartgwt.client.util.Authentication#hasRole Authentication.hasRole()}. <P> In addition to
 * this, for security reasons the server should also enforce role-based authentication for creating and editing admin
 * searches.<br> Note: the sample <code>sc_SavedSearches.ds.xml</code> dataSource has no "admin" field to identify shared
 * or "admin" searches. Instead records in this dataSource with  "userId" set to null are considered to be shared
 * searches.<br> The <code>ownerIdField</code>, <code>ownerIdNullAccess</code> and <code>ownerIdNullRole</code> attributes
 * enforce the appropriate restrictions for editing admin searches -- these settings allow all users to view records with
 * <code>userId:null</code> but only users with the "admin" role may create or edit them. <p> <h4>Default Searches</h4> <P>
 * Default searches are searches which will be automatically applied to a component on draw. The SavedSearch subsystem
 * supports two notions of "default" searches. A user may select their personal default search, in which case the next time
 * they load the page this search will be  applied to the component automatically. Or an administrator may mark a shared
 * admin search  as the default for all users. In this case anyone who loads the application will see this search applied.
 * <P> If a user has a stored personal default search preference, this always takes precedence over any admin-default
 * search. <P> Like any admin-searches, admin-default searches only apply when a dataSource was configured to store the
 * savedSearch data. <P> <h3>Saving default searches</h3> If {@link
 * com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer saveDefaultSearchToServer} is false (the default),
 * the user-default search  preference will be stored in browser <code>localStorage</code>.<br> This is done because the
 * user may choose an Admin Search as their default search, and since Admin Search records are shared between all users, we
 * can't mark the Admin Search record in the database as the default for a specific user (at least not without more complex
 * storage).<br> The drawback is that a user switching browsers or device will not have their default search preserved. <P>
 * If you want to persist default searches chosen by the user to permanent storage on the server, you can  set {@link
 * com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer saveDefaultSearchToServer} to true. In this case the
 * SavedSearch dataSource must include a boolean {@link com.smartgwt.client.data.SavedSearches#getDefaultField
 * defaultField}. Typically this will need to be populated via custom server logic when fetching records to indicate that
 * the record in question is the chosen default for the current user. When <code>saveDefaultSearchToServer</code> is true,
 * the client will issue a custom update operation  when the user wants to modify their default search - see {@link
 * com.smartgwt.client.data.SavedSearches#setDefaultUserSearchOperation setDefaultUserSearchOperation}. <P> Admin default
 * searches are stored on the server regardless of whether {@link
 * com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer saveDefaultSearchToServer} is true. The dataSource
 * should include a boolean {@link com.smartgwt.client.data.SavedSearches#getAdminDefaultField adminDefaultField} to
 * indicate that an admin search record is the shared-default search.<br> If an admin user updates a record to be the new
 * shared default search, the client will issue a different custom update operation - see {@link
 * com.smartgwt.client.data.SavedSearches#setDefaultAdminSearchOperation setDefaultAdminSearchOperation}.<br> Note that
 * we'd recommend marking this operation as <code>requiresRole="admin"</code> on the server, as in the sample
 * <code>sc_SharedSearches.ds.xml</code> dataSource configuration. <h4>Identifying components associated with Saved
 * Searches</h4> <p> Stored SavedSearch records will have the <code>componentId</code> field set to the identifier 
 * returned by {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()} for a component.<br> By
 * default this method returns a {@link com.smartgwt.client.util.AutoTest#getMinimalLocator minimal locator}.  This means
 * that if you assign a unique ID to a component that saves searches, and don't change that ID, stored  saved searches will
 * always be associated with the component. <P> If you don't have a unique ID on the component, the minimal locator is not
 * guaranteed to be consistent across changes to your page layout. While Minimal Locators have a good chance of being
 * unaffected even if you refactor your UI, but there are cases where they may change and previously stored searches would
 * no longer be associated with the component. See the {@link com.smartgwt.client.util.AutoTest#getMinimalLocator
 * AutoTest.getMinimalLocator()} docs for details. <P> Alternatively you can bypass minimal locator system altogether and
 * define an explicit {@link com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId
 * DataBoundComponent.savedSearchId}. This allows you to define a stable identifier for storing saved  searches without
 * setting a component {@link com.smartgwt.client.widgets.Canvas#getID ID}. <P> Note that a component savedSearch ID string
 * is not guaranteed to be immutable over a widget's lifespan.<br> Autotest minimal locators can change in various cases
 * such as changing page structure or binding the component to a new DataSource.<br> Additionally developers may explicitly
 * change the {@link com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId DataBoundComponent.savedSearchId} at
 * runtime. <P> In either case, if the saved search ID changes, the component will be associated with a new set of  saved
 * searches.<br> There are cases where this is desirable. For example if a compnent is bound to one dataSource, and then
 * gets bound to a new dataSource where previously stored searches would no longer be applicable, developers may explicitly
 * change the savedSearchId for the component.  <h4>Security Concerns</h4> <p> If you provide your own {@link
 * com.smartgwt.client.data.SavedSearches#getDefaultDataSource DataSource for storing searches}, you should enforce the
 * following restrictions on the server: <ul> <li> Limiting fetch operations such that the logged-in user can only see
 * their own searches (searches      where the current userId matches the {@link
 * com.smartgwt.client.data.SavedSearches#getUserIdField userIdField}), and       shared or "admin" searches (searches
 * where the {@link com.smartgwt.client.data.SavedSearches#getAdminField adminField}      is <code>true</code>, or if there
 * is no admin field, searches where the <code>userIdField</code> value      is null).</li> <li> Ensuring that logged in
 * users without the {@link com.smartgwt.client.data.SavedSearches#getAdminRole adminRole} can only        add, edit and
 * remove records where the {@link com.smartgwt.client.data.SavedSearches#getUserIdField userIdField} matches      their
 * userId.</li> <li> For logged in users with the {@link com.smartgwt.client.data.SavedSearches#getAdminRole adminRole},
 * also allowing users to      add, update and remove admin searches. What this means in concrete terms depends on whether 
 * the dataSource includes an {@link com.smartgwt.client.data.SavedSearches#getAdminField adminField}.<br>      If an
 * adminField exists, admin users are exempt from userId restrictions when editing or      removing records where this
 * field value is set to true. When adding a new record it is still      recommended the admin user's own userId should be
 * stored in the <code>userIdField</code>.<br>      If no adminField exists, admin searches are identified by having the
 * <code>userIdField</code>      set to <code>null</code>. In this case admin users should be able to add, remove and edit 
 * records where the <code>userIdField</code> matches their own userId, or is null.</li> </ul> <p> <code>searchName</code>
 * field escaping: by default, any character is allowed in the <code>searchName</code> field, and <code>searchName</code>
 * are {@link com.smartgwt.client.data.DataSourceField#getEscapeHTML escaped} when displayed by built-in UI components.  If
 * you provide your own UI for saved searches, you should escape the <code>searchName</code> field before displaying. 
 * Otherwise, users could render your application partly non-functional by using special characters or inline script, or a
 * malicious admin could inject code into other user's browsers.  If you prefer to just limit the <code>searchName</code>
 * field to non-special characters, you can just add a {@link com.smartgwt.client.data.DataSourceField#getValidators
 * dataSourceField validator}  to do this, and the built-in UIs for saved search will handle the validation error as
 * expected (block the save or edit and tell the user what's wrong). <p> If you fail to implement all of the above, then it
 * will be possible for users to save searches for other users or as admin searches, and those saved searches could have
 * malicious code that is then injected into other user's browsers. <p> As noted above - the SavedSearches feature requires
 * <a href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.
 */
@BeanFactory.FrameworkClass
public class SavedSearches extends DataClass {

    public static SavedSearches getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new SavedSearches(jsObj);
    }
        


    public SavedSearches(){
        
    }

    public SavedSearches(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    // ********************* Properties / Attributes ***********************

    /**
     * Type "boolean". Designates an admin search as the shared default search for all users. <P> The user's <i>chosen</i>
     * default search is normally stored separately; the <code>adminDefaultField</code> exists as a way to mark a search as the
     * default for a user that hasn't chosen one yet. <P> See the "Default Searches" section of the  {@link
     * com.smartgwt.client.data.SavedSearches SavedSearches overview} for more information.
     *
     * @return Current adminDefaultField value. Default value is "isSharedDefault"
     */
    public String getAdminDefaultField()  {
        return getAttributeAsString("adminDefaultField");
    }
    

    /**
     * <i>(optional)</i>, type "boolean". Designates this search as an admin search, visible to all users
     *
     * @return Current adminField value. Default value is "admin"
     */
    public String getAdminField()  {
        return getAttributeAsString("adminField");
    }
    

    /**
     * The name of the adminRole (used via +link{Authentication.hasRole()) to check to see if the current user has admin
     * privileges.
     *
     * @return Current adminRole value. Default value is "admin"
     */
    public String getAdminRole()  {
        return getAttributeAsString("adminRole");
    }
    

    /**
     * If {@link com.smartgwt.client.data.SavedSearches#getApplicationId applicationId} is not explicitly specified, it will be
     * defaulted to the current  <a href='https://www.w3schools.com/jsref/prop_loc_pathname.asp'
     * target='_blank'>window.location.pathname</a>. <P> Set this flag to true to disable this behavior and allow SavedSearches
     * to be stored with no explicit applicationId.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param allowNullApplicationId New allowNullApplicationId value. Default value is false
     * @return {@link com.smartgwt.client.data.SavedSearches SavedSearches} instance, for chaining setter calls
     */
    public SavedSearches setAllowNullApplicationId(boolean allowNullApplicationId) {
        return (SavedSearches)setAttribute("allowNullApplicationId", allowNullApplicationId);
    }

    /**
     * If {@link com.smartgwt.client.data.SavedSearches#getApplicationId applicationId} is not explicitly specified, it will be
     * defaulted to the current  <a href='https://www.w3schools.com/jsref/prop_loc_pathname.asp'
     * target='_blank'>window.location.pathname</a>. <P> Set this flag to true to disable this behavior and allow SavedSearches
     * to be stored with no explicit applicationId.
     *
     * @return Current allowNullApplicationId value. Default value is false
     */
    public boolean getAllowNullApplicationId()  {
        Boolean result = getAttributeAsBoolean("allowNullApplicationId", true);
        return result == null ? false : result;
    }
    

    /**
     * The applicationId that will be saved to {@link com.smartgwt.client.data.SavedSearches#getApplicationIdField
     * "applicationIdField"} to disambiguate from other applications that use the same dataSource. <P> If no applicationId was
     * specified, {@link com.smartgwt.client.data.SavedSearches#getApplicationId getApplicationId()} will return the current 
     * <a href='https://www.w3schools.com/jsref/prop_loc_pathname.asp' target='_blank'>window.location.pathname</a> by default.
     * This behavior can be turned off by setting {@link com.smartgwt.client.data.SavedSearches#getAllowNullApplicationId
     * allowNullApplicationId:true}. <P> The <code>applicationId</code> allows the same dataSource to be used to store
     * savedSearches for different applications. It also ensures that if {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource explicit dataSource}  was specified, and searches are being
     * stored to {@link com.smartgwt.client.data.SavedSearches#getLocalDataSource browser local storage}, saved searches will
     * be associated with the current application even if another application running under the same domain/port has a
     * component with the same {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId componentId}.
     *
     * @return Retrieves the value to saves as the link{SavedSearches.applicationIdField,"applicationIdField"} value for saved searches
     * within this application. <P> Returns {@link com.smartgwt.client.data.SavedSearches#getApplicationId this.applicationId}
     * if specified, otherwise the current  <a href='https://www.w3schools.com/jsref/prop_loc_pathname.asp'
     * target='_blank'>window.location.pathname</a> will be returned by default.<br> Set {@link
     * com.smartgwt.client.data.SavedSearches#getAllowNullApplicationId allowNullApplicationId} to suppress this behavior of
     * defaulting to the location.pathname. Default value is null
     */
    public String getApplicationId()  {
        return getAttributeAsString("applicationId");
    }
    

    /**
     * Type: "string" <i>(optional)</i>. This field exists to allow a single DataSource to be used across multiple applications
     * without colliding on <code>componentId</code>.  Set {@link com.smartgwt.client.data.SavedSearches#getApplicationId
     * applicationId} to cause all search lookups to use <code>applicationId</code> as criteria, and all newly saved searches
     * to store that <code>applicationId</code>
     *
     * @return Current applicationIdField value. Default value is "applicationId"
     */
    public String getApplicationIdField()  {
        return getAttributeAsString("applicationIdField");
    }
    

    /**
     * Type: "string".  Stores a unique ID for the component the saved search is associated with.   This does not have to be
     * the {@link com.smartgwt.client.widgets.Canvas#getID Canvas.ID} and is usually a {@link
     * com.smartgwt.client.docs.AutoTestLocator}
     *
     * @return Current componentIdField value. Default value is "componentId"
     */
    public String getComponentIdField()  {
        return getAttributeAsString("componentIdField");
    }
    

    /**
     * Type: "string".  Name dataSource field used for storing the saved search itself with at least 8k of storage (it's
     * possible for searches to get yet larger, but rare).
     *
     * @return Current dataField value. Default value is "data"
     */
    public String getDataField()  {
        return getAttributeAsString("dataField");
    }
    

    /**
     * Default DataSource used for persistence of saved searches. This may be overridden for individual components via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS component.savedSearchDS}. <P> If no default dataSource is
     * explicitly provided, the system will automatically generated a custom DataSource for each component that stores saved
     * searches in HTML5 <code>localStorage</code>. See {@link com.smartgwt.client.data.SavedSearches#getLocalDataSource
     * getLocalDataSource()}. <P> This means the searches are only retained for that specific user on that particular machine,
     * and searches cannot be shared with other users.  However, this approach does mean that you don't have to provide storage
     * for saved searches and saving searches has no impact on scalability.
     *
     * @return Retrieves the DataSource used for persistence of saved searches.   <P> If a {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource} was explicitly specified, it will be
     * returned, otherwise this method returns null. <P> To retrieve the dataSource used to store savedSearches for a specific
     * component see  {@link com.smartgwt.client.data.SavedSearches#getSavedSearchDataSource getSavedSearchDataSource()}. Default value is null
     */
    public DataSource getDefaultDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("defaultDataSource"));
    }

    /**
     * Default DataSource used for persistence of saved searches. This may be overridden for individual components via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS component.savedSearchDS}. <P> If no default dataSource is
     * explicitly provided, the system will automatically generated a custom DataSource for each component that stores saved
     * searches in HTML5 <code>localStorage</code>. See {@link com.smartgwt.client.data.SavedSearches#getLocalDataSource
     * getLocalDataSource()}. <P> This means the searches are only retained for that specific user on that particular machine,
     * and searches cannot be shared with other users.  However, this approach does mean that you don't have to provide storage
     * for saved searches and saving searches has no impact on scalability.
     *
     * @return Retrieves the DataSource used for persistence of saved searches.   <P> If a {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource} was explicitly specified, it will be
     * returned, otherwise this method returns null. <P> To retrieve the dataSource used to store savedSearches for a specific
     * component see  {@link com.smartgwt.client.data.SavedSearches#getSavedSearchDataSource getSavedSearchDataSource()}. Default value is null
     */
    public String getDefaultDataSourceAsString()  {
        return getAttributeAsString("defaultDataSource");
    }
    

    /**
     * <i>optional</i>, type "boolean".  Designates this search as the default search for this user. <P> This field is only
     * required if {@link com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer saveDefaultSearchToServer} is
     * true.<br> See the "Default Searches" section of the  {@link com.smartgwt.client.data.SavedSearches SavedSearches
     * overview} for more information.
     *
     * @return Current defaultField value. Default value is "isDefault"
     */
    public String getDefaultField()  {
        return getAttributeAsString("defaultField");
    }
    

    /**
     * If no explicit {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource} was provided, a
     * custom HTML5 <code>local storage</code> backed dataSource will be automatically created per component to store saved 
     * searches (see {@link com.smartgwt.client.data.SavedSearches#getLocalDataSource getLocalDataSource()}). <P> This property
     * denotes a base storage key for these dataSources.<br> The {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId
     * calculated savedSearch identifier} for the component will be appended to this value to create the key to use when
     * storing serialized searches in local storage.
     *
     * @param offlineStorageKey New offlineStorageKey value. Default value is "isc_savedSearch_"
     * @return {@link com.smartgwt.client.data.SavedSearches SavedSearches} instance, for chaining setter calls
     */
    public SavedSearches setOfflineStorageKey(String offlineStorageKey) {
        return (SavedSearches)setAttribute("offlineStorageKey", offlineStorageKey);
    }

    /**
     * If no explicit {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource} was provided, a
     * custom HTML5 <code>local storage</code> backed dataSource will be automatically created per component to store saved 
     * searches (see {@link com.smartgwt.client.data.SavedSearches#getLocalDataSource getLocalDataSource()}). <P> This property
     * denotes a base storage key for these dataSources.<br> The {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId
     * calculated savedSearch identifier} for the component will be appended to this value to create the key to use when
     * storing serialized searches in local storage.
     *
     * @return Current offlineStorageKey value. Default value is "isc_savedSearch_"
     */
    public String getOfflineStorageKey()  {
        return getAttributeAsString("offlineStorageKey");
    }
    

    /**
     * Type: "string".  Name dataSource field used as the primary key. <P> This is expected to be populated automatically when
     * new search records are added to the data set, so will typically be of {@link com.smartgwt.client.types.FieldType
     * type:sequence}.
     *
     * @return Current primaryKeyField value. Default value is "pk"
     */
    public String getPrimaryKeyField()  {
        return getAttributeAsString("primaryKeyField");
    }
    

    /**
     * Type: "string".  Required because component IDs are not unique if components are loaded as  {@link
     * com.smartgwt.client.rpc.RPCManager#loadScreen screens}, especially {@link com.smartgwt.client.docs.ReifyForDevelopers
     * Reify Screens}.
     *
     * @return Current projectIdField value. Default value is "projectId"
     */
    public String getProjectIdField()  {
        return getAttributeAsString("projectIdField");
    }
    

    /**
     * Should a user's default search preferences be stored to the server? <P> Default user searches are normally saved in
     * browser <code>localStorage</code> - see the "Default Searches" section of the {@link
     * com.smartgwt.client.data.SavedSearches} doc and also the docs for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveDefaultSearch ListGrid.saveDefaultSearch}. <p> If you want to store the
     * default search on the server instead, you can add an {@link com.smartgwt.client.data.OperationBinding} of type "update"
     * called {@link com.smartgwt.client.data.SavedSearches#setDefaultUserSearchOperation "setDefaultUserSearch"} to your
     * {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource}.  This will be called with the PK
     * value of the record to be made the default search, plus a boolean true value for the {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultField defaultField}.  The expectation is that the search identified by
     * the PK is marked as default and any other searches previously marked as default are unmarked. <p> Since Admin Search
     * records are shared among all users, the expectation is that the underlying storage actually stores default markers
     * separately from admin searches, and the {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource
     * defaultDataSource} is acting as a {@link com.smartgwt.client.docs.DsFacade facade DataSource}. <p> Updating a user's
     * default search in the dataSource data should not modify any admin-default search.
     *
     * @param saveDefaultSearchToServer New saveDefaultSearchToServer value. Default value is false
     * @return {@link com.smartgwt.client.data.SavedSearches SavedSearches} instance, for chaining setter calls
     */
    public SavedSearches setSaveDefaultSearchToServer(boolean saveDefaultSearchToServer) {
        return (SavedSearches)setAttribute("saveDefaultSearchToServer", saveDefaultSearchToServer);
    }

    /**
     * Should a user's default search preferences be stored to the server? <P> Default user searches are normally saved in
     * browser <code>localStorage</code> - see the "Default Searches" section of the {@link
     * com.smartgwt.client.data.SavedSearches} doc and also the docs for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveDefaultSearch ListGrid.saveDefaultSearch}. <p> If you want to store the
     * default search on the server instead, you can add an {@link com.smartgwt.client.data.OperationBinding} of type "update"
     * called {@link com.smartgwt.client.data.SavedSearches#setDefaultUserSearchOperation "setDefaultUserSearch"} to your
     * {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource defaultDataSource}.  This will be called with the PK
     * value of the record to be made the default search, plus a boolean true value for the {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultField defaultField}.  The expectation is that the search identified by
     * the PK is marked as default and any other searches previously marked as default are unmarked. <p> Since Admin Search
     * records are shared among all users, the expectation is that the underlying storage actually stores default markers
     * separately from admin searches, and the {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource
     * defaultDataSource} is acting as a {@link com.smartgwt.client.docs.DsFacade facade DataSource}. <p> Updating a user's
     * default search in the dataSource data should not modify any admin-default search.
     *
     * @return Current saveDefaultSearchToServer value. Default value is false
     */
    public boolean getSaveDefaultSearchToServer()  {
        Boolean result = getAttributeAsBoolean("saveDefaultSearchToServer", true);
        return result == null ? false : result;
    }
    

    /**
     * Prefix applied to a specified {@link com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId
     * DataBoundComponent.savedSearchId} by {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()}.
     * This is required to handle the case where a component's savedSearchId matches the ID of some other component.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param savedSearchIDPrefix New savedSearchIDPrefix value. Default value is "SSID:"
     * @return {@link com.smartgwt.client.data.SavedSearches SavedSearches} instance, for chaining setter calls
     */
    public SavedSearches setSavedSearchIDPrefix(String savedSearchIDPrefix) {
        return (SavedSearches)setAttribute("savedSearchIDPrefix", savedSearchIDPrefix);
    }

    /**
     * Prefix applied to a specified {@link com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId
     * DataBoundComponent.savedSearchId} by {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()}.
     * This is required to handle the case where a component's savedSearchId matches the ID of some other component.
     *
     * @return Current savedSearchIDPrefix value. Default value is "SSID:"
     */
    public String getSavedSearchIDPrefix()  {
        return getAttributeAsString("savedSearchIDPrefix");
    }
    

    /**
     * Type: "string".  Required because component IDs are not unique if components are loaded as  {@link
     * com.smartgwt.client.rpc.RPCManager#loadScreen screens}, especially {@link com.smartgwt.client.docs.ReifyForDevelopers
     * Reify Screens}.
     *
     * @return Current screenIdField value. Default value is "screenId"
     */
    public String getScreenIdField()  {
        return getAttributeAsString("screenIdField");
    }
    

    /**
     * Type: "string".  Name dataSource field used for storing names of saved searches.
     *
     * @return Current searchNameField value. Default value is "searchName"
     */
    public String getSearchNameField()  {
        return getAttributeAsString("searchNameField");
    }
    

    /**
     * {@link com.smartgwt.client.data.OperationBinding#getOperationId operationId} for the custom update operation to invoke
     * when updating the default admin search. <P> The update data for this operation will be the saved search record to mark
     * as the shared default with the {@link com.smartgwt.client.data.SavedSearches#getAdminDefaultField adminDefaultField} set
     * to indicate whether the saved search is being set or cleared. <P> When marking a search as the new shared default, the
     * dataSource implementation for this custom  update operation must clear the adminDefaultField value on any previous
     * shared default search. The server should also use the <code>dsResponse.relatedUpdates</code> feature to notify the
     * client  that the previous default was unset.
     *
     * @param setDefaultAdminSearchOperation New setDefaultAdminSearchOperation value. Default value is "setDefaultAdminSearch"
     * @return {@link com.smartgwt.client.data.SavedSearches SavedSearches} instance, for chaining setter calls
     */
    public SavedSearches setSetDefaultAdminSearchOperation(String setDefaultAdminSearchOperation) {
        return (SavedSearches)setAttribute("setDefaultAdminSearchOperation", setDefaultAdminSearchOperation);
    }

    /**
     * {@link com.smartgwt.client.data.OperationBinding#getOperationId operationId} for the custom update operation to invoke
     * when updating the default admin search. <P> The update data for this operation will be the saved search record to mark
     * as the shared default with the {@link com.smartgwt.client.data.SavedSearches#getAdminDefaultField adminDefaultField} set
     * to indicate whether the saved search is being set or cleared. <P> When marking a search as the new shared default, the
     * dataSource implementation for this custom  update operation must clear the adminDefaultField value on any previous
     * shared default search. The server should also use the <code>dsResponse.relatedUpdates</code> feature to notify the
     * client  that the previous default was unset.
     *
     * @return Current setDefaultAdminSearchOperation value. Default value is "setDefaultAdminSearch"
     */
    public String getSetDefaultAdminSearchOperation()  {
        return getAttributeAsString("setDefaultAdminSearchOperation");
    }
    

    /**
     * {@link com.smartgwt.client.data.OperationBinding#getOperationId operationId} for the custom update operation to invoke
     * when updating the default user search if {@link com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer
     * saveDefaultSearchToServer} is true. <P> The update data for this operation will be the saved search record to mark as
     * the user default with the {@link com.smartgwt.client.data.SavedSearches#getDefaultField defaultField} set to indicate
     * whether the saved search is being set or cleared.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param setDefaultUserSearchOperation New setDefaultUserSearchOperation value. Default value is "setDefaultUserSearch"
     * @return {@link com.smartgwt.client.data.SavedSearches SavedSearches} instance, for chaining setter calls
     */
    public SavedSearches setSetDefaultUserSearchOperation(String setDefaultUserSearchOperation) {
        return (SavedSearches)setAttribute("setDefaultUserSearchOperation", setDefaultUserSearchOperation);
    }

    /**
     * {@link com.smartgwt.client.data.OperationBinding#getOperationId operationId} for the custom update operation to invoke
     * when updating the default user search if {@link com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer
     * saveDefaultSearchToServer} is true. <P> The update data for this operation will be the saved search record to mark as
     * the user default with the {@link com.smartgwt.client.data.SavedSearches#getDefaultField defaultField} set to indicate
     * whether the saved search is being set or cleared.
     *
     * @return Current setDefaultUserSearchOperation value. Default value is "setDefaultUserSearch"
     */
    public String getSetDefaultUserSearchOperation()  {
        return getAttributeAsString("setDefaultUserSearchOperation");
    }
    

    /**
     * Type: "string" <i>(optional)</i>. This stores the <code>userId</code> of the user saving the search, populated from
     * {@link com.smartgwt.client.util.Authentication#getCurrentUserId the current userId}.  This field is only optional in the
     * sense that you could instead build a DataSource that returns user-specific saved searches through some other mechanism
     * (for example, by inserting a userId value and forcing userId criteria on the server side).
     *
     * @return Current userIdField value. Default value is "userId"
     */
    public String getUserIdField()  {
        return getAttributeAsString("userIdField");
    }
    

    // ********************* Methods ***********************
	/**
     * This method returns an automatically generated custom DataSource to store saved searches for a component in HTML5
     * localStorage. Note that this dataSource will only be used to store savedSearches if there is no {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource shared default dataSource} specified, and if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS ListGrid.savedSearchDS} is not set for the component. <P> The
     * offline storage key for the data will be generated by combining the {@link
     * com.smartgwt.client.data.SavedSearches#getOfflineStorageKey offlineStorageKey} with the component identifier retrieved
     * from {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()}. <P> <b>Note:</b> The
     * dataSources returned by this method will suppress logging their requests to the {@link
     * com.smartgwt.client.docs.DevConsoleRPCTab Developer Console RPC tag} by default. This is done so developers can more
     * easily see dataSource requests and responses that were explicitly initiated by application code, to simplify debugging.
     * However, if a developer has explicitly created a SavedSearch dataSource either as the {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource global default} or at the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS component level}, requests to access and update SavedSearch
     * data  will be logged as with any other dataSource.
     * @param componentId Component to retrieve the dataSource for, or   saved search component identifier as returned by {@link
     * com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()}
     *
     * @return dataSource for SavedSearches backed by HTML5 local storage.
     */
    public native DataSource getLocalDataSource(Canvas componentId) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        var ret = self.getLocalDataSource(componentId == null ? null : componentId.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.data.DataSource::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * This method returns an automatically generated custom DataSource to store saved searches for a component in HTML5
     * localStorage. Note that this dataSource will only be used to store savedSearches if there is no {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource shared default dataSource} specified, and if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS ListGrid.savedSearchDS} is not set for the component. <P> The
     * offline storage key for the data will be generated by combining the {@link
     * com.smartgwt.client.data.SavedSearches#getOfflineStorageKey offlineStorageKey} with the component identifier retrieved
     * from {@link com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()}. <P> <b>Note:</b> The
     * dataSources returned by this method will suppress logging their requests to the {@link
     * com.smartgwt.client.docs.DevConsoleRPCTab Developer Console RPC tag} by default. This is done so developers can more
     * easily see dataSource requests and responses that were explicitly initiated by application code, to simplify debugging.
     * However, if a developer has explicitly created a SavedSearch dataSource either as the {@link
     * com.smartgwt.client.data.SavedSearches#getDefaultDataSource global default} or at the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS component level}, requests to access and update SavedSearch
     * data  will be logged as with any other dataSource.
     * @param componentId Component to retrieve the dataSource for, or   saved search component identifier as returned by {@link
     * com.smartgwt.client.data.SavedSearches#getSavedSearchId getSavedSearchId()}
     *
     * @return dataSource for SavedSearches backed by HTML5 local storage.
     */
    public native DataSource getLocalDataSource(String componentId) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        var ret = self.getLocalDataSource(componentId);
        if(ret == null) return null;
        return @com.smartgwt.client.data.DataSource::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Retrieves the DataSource used for persistence of saved searches for some component. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS component.savedSearchDS} is specified this will be
     * returned.<br> Otherwise if an explicit {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource default
     * dataSource} was specified, it will be used.<br> <P> If no explicit dataSource was provided either at the component level
     * or as a default for all  SavedSearches, this method will return the result of {@link
     * com.smartgwt.client.data.SavedSearches#getLocalDataSource getLocalDataSource()}.
     * @param component component to retrieve the SavedSearch dataSource for
     *
     * @return the DataSource used to store saved searches for the target component
     */
    public native DataSource getSavedSearchDataSource(DataBoundComponent component) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        var ret = self.getSavedSearchDataSource(component);
        if(ret == null) return null;
        return @com.smartgwt.client.data.DataSource::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns the identifier used to uniquely identify saved searches for some component. <P> This is the value that will be
     * set on the {@link com.smartgwt.client.data.SavedSearches#getComponentIdField componentIdField} when storing saved
     * searches to a DataSource.<br> If there is no explicly specified dataSource for storing saved searches, it will also be
     * used to configure the offline storage key for data stored by the automatically generated {@link
     * com.smartgwt.client.data.SavedSearches#getLocalDataSource local storage backed dataSource}  for the component. <P> The
     * returned value is calculated as follows: <ul><li>If {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId DataBoundComponent.savedSearchId} is set, this method
     * will return         the {@link com.smartgwt.client.data.SavedSearches#getSavedSearchIdPrefix savedSearchIdPrefix} +
     * <code>component.savedSearchId</code>.</li>     <li>Otherwise a {@link
     * com.smartgwt.client.util.AutoTest#getMinimalLocator minimal locator} will be returned.<br>         Note that for
     * components with an explicitly specified {@link com.smartgwt.client.widgets.Canvas#getID ID}, this         will just be
     * the widget ID.</li></ul> Note: The returned ID string is not guaranteed to be immutable over a widget's lifespan. <P> If
     * no explicit component <code>savedSearchId</code> was set, the system will rely on the  AutoTest minimal locator which
     * can change in various cases (a component may be reparented, or bound to a new DataSource, etc).<br> Since this property
     * is used to identify the savedSearch records associated with this component, when it changes a different set of saved
     * searches will be available to the user. <P> If you want to control this explicitly, you can do so by setting an explicit
     * {@link com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId savedSearchId}. Changing the
     * <code>savedSearchId</code> at runtime also allows you to deliberately associate a component with a new set of
     * SavedSearches depending on application state. One common case where this might be desirable is if a component is bound
     * to a dataSource and you want to bind to a new DataSource where the savedSearch criteria would not be applicable.
     * @param component component to retrieve the identifier for
     *
     * @return component saved search ID
     */
    public native String getSavedSearchId(Canvas component) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        var ret = self.getSavedSearchId(component == null ? null : component.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
        return ret;
    }-*/;

	/**
     * Update the admin default search for some component <P> This will invoke the {@link
     * com.smartgwt.client.data.SavedSearches#setDefaultAdminSearchOperation setDefaultAdminSearchOperation} to update the
     * admin search record on the server.
     * @param component component being updated
     * @param isDefault whether the default is being set to true or false
     * @param searchRecord record containing details of the search to be updated
     * @param callback callback to invoke when the search has been updated. Takes no arguments.
     * See {@link com.smartgwt.client.docs.Callback Callback}
     */
    public native void setDefaultAdminSearch(DataBoundComponent component, boolean isDefault, Record searchRecord, String callback) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.setDefaultAdminSearch(component, isDefault, searchRecord.@com.smartgwt.client.core.DataClass::getJsObj()(), callback);
    }-*/;

	/**
     * Update the user's default search. <P> This will invoke the {@link
     * com.smartgwt.client.data.SavedSearches#setDefaultUserSearchOperation setDefaultUserSearchOperation} if {@link
     * com.smartgwt.client.data.SavedSearches#getSaveDefaultSearchToServer saveDefaultSearchToServer} is true, otherwise it
     * will persist the default into offline storage
     * @param component component being updated
     * @param isDefault whether the default is being set to true or false
     * @param searchRecord record containing details of the search to be updated
     * @param callback callback to invoke when the search has been updated. Takes no arguments.
     * See {@link com.smartgwt.client.docs.Callback Callback}
     */
    public native void setDefaultUserSearch(DataBoundComponent component, boolean isDefault, Record searchRecord, String callback) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
        self.setDefaultUserSearch(component, isDefault, searchRecord.@com.smartgwt.client.core.DataClass::getJsObj()(), callback);
    }-*/;


    // ********************* Static Methods ***********************

	/**
     * Singleton accessor method.
     *
     * @return an instance of SavedSearches
     */
    public static native SavedSearches get() /*-{
        var ret = $wnd.isc.SavedSearches.get();
        if(ret == null) return null;
        return @com.smartgwt.client.data.SavedSearches::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


    // ***********************************************************

}
