/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, ButtonItem, DynamicForm, ListGrid, ShuttleItem, TextItem, VLayout } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onCountriesGridSelectionUpdated = function () {
    var selection = this.getSelectedRecord();
    if (selection == null) {
        countryForm.clearValues();
        countryForm.disable();
    } else {
        countryForm.enable();
        countryForm.editRecord(this.getSelectedRecord());
    }
};
let onSaveClick = function () {
    countryForm.saveData('countriesGrid.invalidateCache()');
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout width="100%" height="100%" autoDraw="true">
        <members>
            <ListGrid ID="countriesGrid" selectionType="single" dataSource="countrySQL_oneToManySample" autoFetchData="true" height="200" showResizeBar="true" selectionUpdated={onCountriesGridSelectionUpdated}/>
            <DynamicForm ID="countryForm" dataSource="countrySQL_oneToManySample" disabled="true">
                <fields>
                    <TextItem name="countryName"/>
                    <ShuttleItem name="cities" canEdit="true"/>
                    <ButtonItem title="Save" click={onSaveClick}/>
                </fields>
            </DynamicForm>
        </members>
    </VLayout>,
    document.getElementById(target)
);
