import React from 'react';
import { Process, ProcessProps } from './Process';
import { AsComponentXML } from './core/ReactComponent';


declare interface CoTProcessProps extends ProcessProps {

/**
 * See {@link isc.CoTProcess.getPromptPart() CoTProcess.getPromptPart()}.
 */
getPromptPart?: Function;

/**
 * See {@link isc.CoTProcess.promptModeMinimal CoTProcess.promptModeMinimal}.
 */
promptModeMinimal?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.transitionsPrimer CoTProcess.transitionsPrimer}.
 */
transitionsPrimer?: string;

/**
 * See {@link isc.CoTProcess.isCanceled() CoTProcess.isCanceled()}.
 */
isCanceled?: Function;

/**
 * See {@link isc.CoTProcess.mockOutput() CoTProcess.mockOutput()}.
 */
mockOutput?: Function;

/**
 * See {@link isc.CoTProcess.asyncStart() CoTProcess.asyncStart()}.
 */
asyncStart?: Function;

/**
 * See {@link isc.CoTProcess.mockData CoTProcess.mockData}.
 */
mockData?: Object[];

/**
 * See {@link isc.CoTProcess.goal CoTProcess.goal}.
 */
goal?: string;

/**
 * See {@link isc.CoTProcess.pauseAtTaskBoundaries CoTProcess.pauseAtTaskBoundaries}.
 */
pauseAtTaskBoundaries?: boolean;

/**
 * See {@link isc.CoTProcess.defaultTaskConstructor CoTProcess.defaultTaskConstructor}.
 */
defaultTaskConstructor?: string;

/**
 * See {@link isc.CoTProcess.historyPrimer CoTProcess.historyPrimer}.
 */
historyPrimer?: string;

/**
 * See {@link isc.CoTProcess.processingElement() CoTProcess.processingElement()}.
 */
processingElement?: Function;

/**
 * See {@link isc.CoTProcess.noHistory CoTProcess.noHistory}.
 */
noHistory?: boolean;

/**
 * See {@link isc.CoTProcess.captureMockData CoTProcess.captureMockData}.
 */
captureMockData?: boolean;

/**
 * See {@link isc.CoTProcess.promptModeTaskPromptOnly CoTProcess.promptModeTaskPromptOnly}.
 */
promptModeTaskPromptOnly?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.promptModeTransitionDebug CoTProcess.promptModeTransitionDebug}.
 */
promptModeTransitionDebug?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.unpause() CoTProcess.unpause()}.
 */
unpause?: Function;

/**
 * See {@link isc.CoTProcess.introPrompt CoTProcess.introPrompt}.
 */
introPrompt?: string;

/**
 * See {@link isc.CoTProcess.maxRetries CoTProcess.maxRetries}.
 */
maxRetries?: number;

/**
 * See {@link isc.CoTProcess.promptModeErrorsOnly CoTProcess.promptModeErrorsOnly}.
 */
promptModeErrorsOnly?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.getPartialPrompt() CoTProcess.getPartialPrompt()}.
 */
getPartialPrompt?: Function;

/**
 * See {@link isc.CoTProcess.defaultProcessConstructor CoTProcess.defaultProcessConstructor}.
 */
defaultProcessConstructor?: string;

/**
 * See {@link isc.CoTProcess.mockMode CoTProcess.mockMode}.
 */
mockMode?: boolean;

/**
 * See {@link isc.CoTProcess.optionalPrompts CoTProcess.optionalPrompts}.
 */
optionalPrompts?: Object;

/**
 * See {@link isc.CoTProcess.goalPrimer CoTProcess.goalPrimer}.
 */
goalPrimer?: string;

/**
 * See {@link isc.CoTProcess.promptModeNoData CoTProcess.promptModeNoData}.
 */
promptModeNoData?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.asyncGetResult() CoTProcess.asyncGetResult()}.
 */
asyncGetResult?: Function;

/**
 * See {@link isc.CoTProcess.systemPrompt CoTProcess.systemPrompt}.
 */
systemPrompt?: string;

/**
 * See {@link isc.CoTProcess.promptModeStateTracking CoTProcess.promptModeStateTracking}.
 */
promptModeStateTracking?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.promptModeHistoryOnly CoTProcess.promptModeHistoryOnly}.
 */
promptModeHistoryOnly?: PartialPromptConfig;

/**
 * See {@link isc.CoTProcess.paused CoTProcess.paused}.
 */
paused?: boolean;

/**
 * See {@link isc.CoTProcess.processingElementResult() CoTProcess.processingElementResult()}.
 */
processingElementResult?: Function;

/**
 * See {@link isc.CoTProcess.start() CoTProcess.start()}.
 */
start?: Function;

/**
 * See {@link isc.CoTProcess.cancel() CoTProcess.cancel()}.
 */
cancel?: Function;

/**
 * See {@link isc.CoTProcess.historyMaxItems CoTProcess.historyMaxItems}.
 */
historyMaxItems?: number;

/**
 * See {@link isc.CoTProcess.addHistory() CoTProcess.addHistory()}.
 */
addHistory?: Function;

/**
 * See {@link isc.CoTProcess.defaultReturnTask CoTProcess.defaultReturnTask}.
 */
defaultReturnTask?: string;

/**
 * See {@link isc.CoTProcess.getAsyncOperation() CoTProcess.getAsyncOperation()}.
 */
getAsyncOperation?: Function;

/**
 * See {@link isc.CoTProcess.aiEngineId CoTProcess.aiEngineId}.
 */
aiEngineId?: string;

/**
 * See {@link isc.CoTProcess.history CoTProcess.history}.
 */
history?: CoTHistoryEntry[];

/**
 * See {@link isc.CoTProcess.stateHistoryMaxItems CoTProcess.stateHistoryMaxItems}.
 */
stateHistoryMaxItems?: number;

/**
 * See {@link isc.CoTProcess.setMockReplayFailure() CoTProcess.setMockReplayFailure()}.
 */
setMockReplayFailure?: Function;

/**
 * See {@link isc.CoTProcess.errorsPrimer CoTProcess.errorsPrimer}.
 */
errorsPrimer?: string;

/**
 * See {@link isc.CoTProcess.finished() CoTProcess.finished()}.
 */
finished?: Function;

/**
 * See {@link isc.CoTProcess.asyncOperationParams CoTProcess.asyncOperationParams}.
 */
asyncOperationParams?: AsyncOperationParams;

/**
 * See {@link isc.CoTProcess.pause() CoTProcess.pause()}.
 */
pause?: Function;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * CoTProcess wraps the SmartClient widget class
 * {@link isc.CoTProcess CoTProcess} for React, allowing you to import
 * CoTProcess for use in React JS and JSX.
 * @class
 * @extends Process
 */
declare class CoTProcess extends Process {
    props: AsComponentXML<CoTProcessProps>;
}
