/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-02-03/EVAL Development Only (2026-02-03)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_Foundation){isc.module_Foundation=1;isc._moduleStart=isc._Foundation_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'Foundation load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (window.isc && isc.version != "v13.1p_2026-02-03/EVAL Development Only" && !isc.DevUtil) {
    isc.logWarn("SmartClient module version mismatch detected: This application is loading the core module from "
        + "SmartClient version '" + isc.version + "' and additional modules from 'v13.1p_2026-02-03/EVAL Development Only'. Mixing resources from different "
        + "SmartClient packages is not supported and may lead to unpredictable behavior. If you are deploying resources "
        + "from a single package you may need to clear your browser cache, or restart your browser."
        + (isc.Browser.isSGWT ? " SmartGWT developers may also need to clear the gwt-unitCache and run a GWT Compile." : ""));
}








//> @class Animation
// Class with static APIs used by the animation subsystem.
// @treeLocation  Client Reference/System
// @visibility animation_advanced
//<
isc.ClassFactory.defineClass("Animation");

isc.Animation.addClassProperties({
    //> @classAttr Animation.interval   (number : 20 : IRWA)
    // Interval in ms between animation events.
    // @visibility animation_advanced
    //<
    interval:20,
    registry:[],

    // Some standard ratio functions
    // These functions take a value between zero and one, representing a linear ratio and
    // return a value between zero and one that represents a non linear ratio.
    // Executed in global scope

    //> @classMethod Animation.smoothStart (A)
    // This is a static function which maps a linear ratio (value between zero and one
    // representing how much of an animation has elapsed) to a ratio biased such that the
    // starts slowly and speeds up as it approaches 1.
    // @visibility animation_advanced
    //<
    smoothStart : function (rawRatio) {
        return Math.pow(rawRatio, 2);
    },

    //> @classMethod Animation.smoothEnd (A)
    // This is a static function which maps a linear ratio (value between zero and one
    // representing how much of an animation has elapsed) to a ratio biased such that the
    // animation starts moving quickly, and appears to slow down as it approaches 1.
    // @visibility animation_advanced
    //<
    smoothEnd : function (rawRatio) {
        return 1 - Math.abs(Math.pow(rawRatio-1, 2));
    },

    //> @classMethod Animation.smoothStartEnd (A)
    // This is a static function which maps a linear ratio (value between zero and one
    // representing how much of an animation has elapsed) to a ratio biased such that the
    // animation appears to accelerate from a slow start, then slow down again toward the end
    // of the animation.
    // @visibility animation_advanced
    //<
    smoothStartEnd : function (rawRatio) {
        return (-Math.cos(rawRatio*Math.PI) + 1) / 2.0;
    },

    //> @classAttr Animation.animateTime (number : 1000 : IRWA)
    // Default total duration for animations with no specified duration.  Typically animations
    // involving canvases will pick up their duration from the Canvas level default, so this
    // property is only used in rare cases.
    // @visibility animation_advanced
    // @group animation
    //<
    animateTime:1000

});

isc.Animation.addClassMethods({
    // Unique IDs used to identify registered animation actions
    generateAnimationID : function () {
        if (!this._animationCount) this._animationCount = 0;
        return "_" + (this._animationCount++);
    },

    // Can we use the native requestAnimationFrame() method rather than relying on
    // explicit timeouts?
    _useRequestAnimationFrame : function () {
        if (this._browserHasRequestAnimationFrame == null) {
            this._browserHasRequestAnimationFrame = window.requestAnimationFrame != null;
        }
        return this._browserHasRequestAnimationFrame;
    },


    timeBased:false,

    // Raw handler fired in the global scope by the animation timer - fires the animation
    // events
    timeoutAction : function () {
        if (isc.Animation) isc.Animation.fireTimer();
    },
    requestedAnimationAction : function (nativeTimestamp) {

        if (isc.Animation) isc.Animation.fireTimer();
    },

    //> @type AnimationAcceleration
    // Acceleration effect for animations. Can either be a ratio function or a string.
    // Ratio functions take a value between 0 and 1 which represents how much of the
    // animation's duration has elapsed, and return another value between 0 and 1 indicating
    // how close the animation is to completion. For a completely linear animation, the
    // function would return the value it was passed. This allows you to bias animations to
    // [for example] speed up toward the end of the animation.<br>
    // The following strings are also supported for common ratio bias effects:
    //
    // @value "smoothStart" - animation will speed up as time elapses
    // @value "smoothEnd" - animation will slow down as time elapses
    // @value "smoothStartEnd" - animation will speed up in the middle
    // @value "none" - no bias
    // @visibility animation
    //<

    //> @classMethod Animation.registerAnimation()
    // Register an action to fire repeatedly for some duration of time.
    //
    // @param callback (Callback) Action to fire repeatedly until the duration expires.
    //                            Passed 3 parameters for each step:<br>
    //                              - "ratio" (number between 0 and 1) indicating what fraction
    //                                of the specified duration has elapsed<br>
    //                              - "ID" (string) the unique ID for this registered animation<br>
    //                              - "earlyFinish" (boolean) If true this animation was cut
    //                                short via a call to +link{Animation.finishAnimation()} before
    //                                its duration had elapsed.
    // @param duration (number) Target duration for this animation in ms.  The callback will
    //                          actually be called a fixed number of times based on this target
    //                          duration and the default frame interval
    //                          (isc.Animation.interval), which may result in an animation that
    //                          is longer than the target duration if some frames exceed the
    //                          interval time.  The animation will be cut short if it exceeds
    //                          3 times the target duration
    // @param [acceleration] (AnimationAcceleration) Acceleration bias effect for the animation.
    // @param [target] (Object) If specified the callback will be fired in the scope of the
    //                          target passed in.
    // @return (String) Unique ID for the registered animation action.
    // @visibility animation_advanced
    //<
    registerAnimation : function (callback, duration, acceleration, target) {

        if (this._useRequestAnimationFrame()) {
            if (this._requestedAnimationFrame == null) {
                this._requestedAnimationFrame = window.requestAnimationFrame(this.requestedAnimationAction);
                this._startTime = isc.timeStamp();
            }
        } else {
            if (!this._animationTimer) {
                this._animationTimer = isc.Timer.setTimeout(this.timeoutAction, this.interval);
                this._startTime = isc.timeStamp();
            }
        }

        if (!target) target = this;
        if (!duration) duration = this.animateTime;


        if (isc.isA.String(acceleration)) {
            if (!isc.Animation.accelerationMap) {
                isc.Animation.accelerationMap =  {
                    smoothStart:isc.Animation.smoothStart,
                    smoothEnd:isc.Animation.smoothEnd,
                    smoothStartEnd:isc.Animation.smoothStartEnd
                    // Support the user specifying "none" - just don't use any biasing
                    // function - same as if they said "foo"
                    // none:null
                }
            }
            acceleration = isc.Animation.accelerationMap[acceleration];
        }

        var ID = this.generateAnimationID();
        this.registry.add({
            ID:ID, target:target, callback:callback, duration:duration, elapsed:0,
            totalFrames:Math.round(duration/this.interval), currentFrame:0,
            // For frame based animation (the default), don't allow animation to exceed
            // three times the specified duration.
            maxDuration:duration*3,
            acceleration:acceleration
        });

        return ID;
    },

    //> @classMethod Animation.clearAnimation()
    // Clear a registered animation action. Only meaningful if the registered animation has
    // not completed (i.e. the specified duration for the action has not elapsed since the
    // action was registered). Will un-register the action and prevent it from firing again.
    // @param ID (String) ID for the action to be unregistered. This is the ID returned from
    //                      Animation.registerAnimation().
    // @visibility animation_advanced
    //<
    clearAnimation : function (ID) {
        for (var i=0; i<this.registry.length; i++) {
            if (this.registry[i] && this.registry[i].ID == ID) {
                this.registry.removeAt(i);
                break;
            }
        }
    },

    //> @classMethod Animation.finishAnimation()
    // "Finish" a registered animation, by clearing it, and firing it with a
    // ratio of 1 and an additional 'earlyFinish' which will be passed to the callback.
    // @param ID (String) ID for the action to be finished. This is the ID returned from
    //                      Animation.registerAnimation().
    // @visibility animation_advanced
    //<
    finishAnimation : function (ID) {
        for (var i = 0; i < this.registry.length; i++) {
            if (this.registry[i] && this.registry[i].ID == ID) {
                var entry = this.registry[i];
                break;
            }
        }

        this.clearAnimation(ID);
        if (entry) this.fireAction(entry, 1, true);
    },

    // fireTimer() - this is fired every interval and handles:
    // - firing any animations whose total duration has not yet elapsed
    // - unregistering any animations whose total duration has elapsed
    // - setting up the timer to fire this method again after the next Animation.interval ms
    fireTimer : function () {
        var newTime = isc.timeStamp(),
            elapsed = (newTime - this._startTime),
            // Adjust for the difference between the actual elapsed time and the desired
            // interval so we average out to firing as close to every [interval] ms as possible
            interval = Math.max(0, this.interval - (elapsed - this.interval));

        //this.logWarn("timer firing - elapsed is:"+ elapsed + ", so interval is:"+ interval);
        if (this._useRequestAnimationFrame()) {
            this._requestedAnimationFrame = window.requestAnimationFrame(this.requestedAnimationAction);
        } else {
            this._animationTimer = isc.Timer.setTimeout(this.timeoutAction, interval);
        }
        this._startTime = newTime;

        for (var i = 0; i < this.registry.length; i++) {
            var entry = this.registry[i];
            // We don't expect this to happen because we do a removeEmpty below

            if (entry == null) continue;

            entry.elapsed += elapsed;

            var nextFrame = entry.currentFrame + 1;


            if (!isc.Animation.timeBased &&
                ((entry.elapsed / entry.maxDuration) > (nextFrame / entry.totalFrames) ))
            {
                nextFrame = Math.min(entry.totalFrames,
                                     Math.ceil((entry.elapsed/entry.maxDuration) * entry.totalFrames));
            }

            entry.currentFrame = nextFrame;

            var unbiasedTimeRatio = entry.elapsed/entry.duration,
                unbiasedFrameRatio = entry.currentFrame/entry.totalFrames;

            // We want to use the time-based ratio
            // - if Animation.timeBased is explicitly true
            // - if the time-based ratio exceeds the frame-based ratio (implying we're
            //   getting notified more frequently than once every 'interval' ms).
            var useFrameRatio = !isc.Animation.timeBased  &&
                                (unbiasedTimeRatio > unbiasedFrameRatio),
                unbiasedRatio = useFrameRatio ? unbiasedFrameRatio : unbiasedTimeRatio;



            var ratio = unbiasedRatio,
                acceleration = entry.acceleration;
            if (acceleration && isc.isA.Function(acceleration)) {


                if (!entry.accelerationTested) {
                    try {
                        ratio = entry.acceleration(ratio);
                    } catch(e) {
                        this.logWarn("Custom ratio function for animation:" + isc.Log.echoAll(entry) +
                                     "\nCaused an error:"+ (e.message ? e.message : e));
                        // delete it, so even if its time hasn't elapsed we don't run into this error
                        // repeatedly until the time expires
                        entry.acceleration = null;
                    }
                    entry.accelerationTested = true;
                } else {
                    ratio = entry.acceleration(ratio);
                }
            }
            //this.logWarn("ratio:"+ ratio);

            // If we've fired the animation for the duration of the entry, ensure we clear it
            // out so we don't fire it again
            // Note that we are checking the unbiased ratio - the acceleration is arbitrary, so
            // may fail to give us a value of 1, in which case we don't want to be left with
            // an incompleted animation.
            if (unbiasedRatio >= 1) {
                ratio = 1;
                this.registry[i] = null;
            }


            var error = null;
            try {
                //this.logWarn("firing frame of animation: " + entry.ID + " with ratio: " + ratio);
                error = this.fireAction(entry, ratio);
            } catch(e) {
                error = e;
            }
            if (error != null) {
                this.logWarn("Attempt to fire registered animation:" + isc.Log.echoAll(entry) +
                 "\nCaused an error:"+ (error.message ? error.message : error));
                // delete it, so even if its time hasn't elapsed we don't run into this error
                // repeatedly until the time expires
                this.registry[i] = null;
            }

            if (unbiasedRatio >= 1) {
                this.logDebug("animation " + entry.ID + " completed", "animation");
            }
        }
        this.registry.removeEmpty();
        // Stop looping if we don't have any pending animations
        if (this.registry.length == 0) {
            if (this._useRequestAnimationFrame()) {
                window.cancelAnimationFrame(this._requestedAnimationFrame);
                this._requestedAnimationFrame = null;
            } else {
                isc.Timer.clearTimeout(this._animationTimer);
                this._animationTimer = null;
            }
        }
    },

    // fireAction will be called to actually fire each registered animation action
    _$ratio_ID_earlyFinish:"ratio,ID,earlyFinish",
    fireAction : function (action, ratio, earlyFinish) {

        // pass the earlyFinish param on to the action callback.

        var target = action.target;
        if (!target || target.destroyed) {
            return "No valid target. Target may have been destroyed since animation commenced";
        }
        target.fireCallback(action.callback, this._$ratio_ID_earlyFinish,
                            [ratio,action.ID,earlyFinish]);
    },

    // Globally are any animations in progress?

    isActive : function () {
        return (this.registry && this.registry.length > 0);
    }
});

isc.Canvas.addProperties({
    //> @attr canvas.animateTime (number : 300 : IRWA)
    // Default total duration of animations. Can be overridden by setting animation times for
    // specific animations, or by passing a <code>duration</code> parameter into the appropriate
    // animate...() method.
    // @visibility animation
    // @group animation
    // @example animateMove
    //<

    animateTime:300,

    //> @attr canvas.animateAcceleration (AnimationAcceleration : "smoothEnd" : IRWA)
    // Default acceleration effect to apply to all animations on this Canvas.
    // Can be overridden by setting animationAcceleration for specific animations or by passing
    // an acceleration function directly into the appropriate method.
    // @visibility animation
    // @group animation
    //<
    animateAcceleration:"smoothEnd",

    // List of supported animations.
    // For each of these we need to support the method 'animate[Type]' (like animateMove()).
    // These method names can also be passed as parameters to finishAnimation()

    _animations:["rect","fade","scroll","show","hide", "resize", "move"],

    //> @attr canvas.animateShowEffect (AnimateShowEffectId | AnimateShowEffect : "wipe" : IRWA)
    // Default animation effect to use if +link{Canvas.animateShow()} is called without an
    // explicit <code>effect</code> parameter
    // @visibility animation
    // @group animation
    //<
    animateShowEffect:"wipe",

    //> @attr canvas.animateHideEffect (AnimateShowEffectId | AnimateShowEffect : "wipe" : IRWA)
    // Default animation effect to use if +link{Canvas.animateHide()} is called without an
    // explicit <code>effect</code> parameter
    // @visibility animation
    // @group animation
    //<
    animateHideEffect:"wipe",

    //> @attr canvas.animateMoveTime  (number : null : IRWA)
    // Default time for performing an animated move.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateResizeTime  (number : null : IRWA)
    // Default time for performing an animated resize.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateRectTime  (number : null : IRWA)
    // Default time for performing an animated setRect.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateFadeTime  (number : null : IRWA)
    // Default time for performing an animated fade.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateScrollTime  (number : null : IRWA)
    // Default time for performing an animated scroll.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateShowTime  (number : null : IRWA)
    // Default time for performing an animated show.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateHideTime  (number : null : IRWA)
    // Default time for performing an animated hide.  If unset, <code>this.animateTime</code>
    // will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateMoveAcceleration  (AnimationAcceleration : null : IRWA)
    // Default acceleration effect for performing an animated move.  If unset,
    // <code>this.animateAcceleration</code> will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateResizeAcceleration  (AnimationAcceleration : null : IRWA)
    // Default acceleration function for performing an animated resize.  If unset,
    // <code>this.animateAcceleration</code> will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateRectAcceleration  (AnimationAcceleration : null : IRWA)
    // Default acceleration function for performing an animated move and resize.  If unset,
    // <code>this.animateAcceleration</code> will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateScrollAcceleration  (AnimationAcceleration : null : IRWA)
    // Default acceleration function for performing an animated scroll.  If unset,
    // <code>this.animateAcceleration</code> will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateShowAcceleration  (AnimationAcceleration : null : IRWA)
    // Default acceleration function for performing an animated show.  If unset,
    // <code>this.animateAcceleration</code> will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @attr canvas.animateHideAcceleration  (AnimationAcceleration : null : IRWA)
    // Default acceleration function for performing an animated hide.  If unset,
    // <code>this.animateAcceleration</code> will be used by default instead
    // @visibility animation
    // @group animation
    //<

    //> @type AnimationLayoutMode
    // During a +link{canvas.animateResize(),size animation}. when should the layout of the
    // children be updated?
    //
    // @value "always" - for every change to the target's width or height
    // @value "overflow" - for every size change which leaves the target overflowed
    // @value "atEnd" - only layout the children at the end of the animation
    // @visibility animation
    //<

    //> @attr canvas.animateResizeLayoutMode  (AnimationLayoutMode : "atEnd" : IRWA)
    // When to update the +link{layoutChildren(),child layout} for a +link{animateResize(),
    // size animation}.  Updating the child layout more often may improve appearance, but risks
    // prohibitive overhead with more complicated widget hierarchies.
    // @visibility animation
    // @group animation
    //<
    _shouldRelayoutForAnimateResize : function () {
        switch (this.animateResizeLayoutMode) {
        case "always":
            return true;
        case "overflow":
            return this._isOverflowed;
        default:
            return false;
        }
    }

});

isc.Canvas.addMethods({

    //> @method canvas.registerAnimation  (A)
    // Register some action to fire repeatedly for a specified duration
    // @param callback (Callback) Action to fire repeatedly until the duration expires
    // @param [duration] (Integer) time in ms for which the action should be fired
    // @param [acceleration] (AnimationAcceleration) Acceleration effect to apply to the animation
    // @return (String) Unique identifier for the registered animation action
    // @visibility animation_advanced
    // @group animation
    //<
    registerAnimation : function (callback, duration, acceleration) {
        if (!acceleration) acceleration = this.animationAcceleration;
        if (!duration) duration = this.animateTime;
        return isc.Animation.registerAnimation(callback, duration, acceleration, this);
    },

    //> @method canvas.cancelAnimation  (A)
    // Clear some registered animation action
    // @param ID (String) ID of the animation as returned by canvas.registerAnimation()
    // @visibility animation_advanced
    // @group animation
    //<
    cancelAnimation : function (ID) {
        isc.Animation.clearAnimation(ID);
    },

    // ----------------------------------------------------------------------------------------
    // Specific animation effects (Higher level API)
    // ----------------------------------------------------------------------------------------

    // getAnimationType() will return the default duration for various animation types
    // getAnimationAcceleration() will return the default acceleration function used to bias
    // animation ratios for the appropriate type
    _animateTimeMap:{},
    _animateAccelerationMap:{},
    getAnimateTime : function (type) {
        if (!isc.isA.String(type) || isc.isAn.emptyString(type)) return this.animateTime;

        // type is something like "move" or "resize"
        // - default duration specified via this.animateMoveTime
        if (!this._animateTimeMap[type]) {
            this._animateTimeMap[type] = "animate" +
                                            type.substring(0,1).toUpperCase() + type.substring(1) +
                                            "Time";
        }
        return this[this._animateTimeMap[type]] || this.animateTime;
    },

    getAnimateAcceleration : function (type) {
        if (!isc.isA.String(type) || isc.isAn.emptyString(type)) return this.animateAcceleration;

        // - default ratio biasing function specified via this.animate[Type]Acceleration
        if (!this._animateAccelerationMap[type]) {
            this._animateAccelerationMap[type] = "animate" +
                                            type.substring(0,1).toUpperCase() + type.substring(1) +
                                            "Acceleration";
        }
        return this[this._animateAccelerationMap[type]] || this.animateAcceleration;
    },

    // _getAnimationIDs() - each time an animation is set up, the ID of the animation action
    // is stored under this.[type]Animation (so this.rectAnimation, this.fadeAnimation, etc.)
    // Helper method to retrieve these IDs
    _animationIDs:{},
    _$Animation:"Animation",
    _getAnimationID : function (type) {
        if (!this._animationIDs[type]) {
            this._animationIDs[type] = type + this._$Animation;
        }
        return this._animationIDs[type];
    },
    // _getAnimationMethodName() - the actions fired (repeatedly) for animations are canonically
    // named as this.fireAnimation[ActionType]().
    // Helper to cache / retrieve these names
    _animationMethodNames:{},
    _getAnimationMethodName : function (type) {
        if (!this._animationMethodNames[type]) {
            this._animationMethodNames[type] = "fireAnimation" +
                                                type.substring(0,1).toUpperCase() +
                                                type.substring(1);
        }
        return this._animationMethodNames[type];
    },

    // Helper method fired to start an animation. This method allows us to consolidate the
    // code path to:
    // - check if a current animation is in process (and finish it if so)
    // - store out info for use by repeatedly called animation action
    // - registers the animation to actually start firing
    // This method requires the following:
    // - the repeatedly fired action for an animation will be named "this.fireAnimation[AnimationType]"
    // - the info passed to this method will be stored as "this.[animationType]Info" (so the
    //   action should be prepared to access that object)
    // - the ID of the registered animation will be stored as "this.[animationType]Animation"
    // - When the animation completes, the method _clearAnimationInfo() should be called to
    //   clear out the stored animation ID and info. This is handled by the various
    //   fireAnimation... methods when the animation is complete (ratio == 1), and typically
    //   before the final callback fires to ensure isAnimating(..) is false at that point.

    _animationInfoAttrs:{},
    _runningAnimations:0,
    _startAnimation : function (type, info, duration, acceleration) {
        var ID = this._getAnimationID(type);
        // If an animation of the same type is already running, finish it before starting this
        // one.
        if (this[ID]) this.finishAnimation(type);

        // Hang onto the info passed in - will be used by the animation action fired
        if (!this._animationInfoAttrs[type]) {
            // NB: using $ instead of _ prefix to avoid obfuscation problems
            this._animationInfoAttrs[type] = "$" + type + "AnimationInfo";
        }
        this[this._animationInfoAttrs[type]] = info;

        if (duration == null) duration = this.getAnimateTime(type);
        if (acceleration == null) acceleration = this.getAnimateAcceleration(type);

        // Register the animation method to fire for the specified duration
        var animationId = this[ID] =
            this.registerAnimation(this[this._getAnimationMethodName(type)], duration, acceleration);
        if (this.logIsInfoEnabled("animation")) {
            this.logInfo("starting animation " + animationId + " of type: " + type +
                         ", duration: " + duration +
                         ", acceleration: " + this.echoLeaf(acceleration),
                         "animation");
        }
        this._runningAnimations ++;

        return animationId;
    },

    _clearAnimationInfo : function (type) {
        var ID = this._getAnimationID(type);
        if (!this[ID]) {
            return;
        }
        delete this[ID];
        delete this[this._animationInfoAttrs[type]];

        this._runningAnimations--;

    },

    // helper method to fire the final callback at the end of an animation.

    _pendingAnimationCallbacks: 0,
    animationComplete : function (earlyFinish) {},
    _fireAnimationCompletionCallback : function (callback, earlyFinish, synchronous) {
        if (!callback) return;

        var widget = this,
            fireCallbackNow = earlyFinish || synchronous;

        var fireCallback = function () {
            widget.fireCallback(callback, "earlyFinish", [earlyFinish]);
            if (!fireCallbackNow) widget._pendingAnimationCallbacks--;
            widget.animationComplete(earlyFinish);
        }



        if (fireCallbackNow) {
            fireCallback();
        } else {
            isc.Timer.setTimeout(fireCallback, 0);
            this._pendingAnimationCallbacks++;
        }
    },

    //> @method canvas.finishAnimation()
    // Forces a running animation (animated move / resize, etc.) to instantly complete - jumping
    // to its finished state, and firing its callback, and passing the 'earlyFinish' parameter
    // to the callback.
    // @param [type] (String) animation type name ("move", "resize", etc). If not passed just
    //                        finish all animations
    // @visibility animation_advanced
    // @group animation
    //<

    finishAnimation : function (type) {

        // if type is null finish animations of all types
        if (type == null) {
            for (var i = 0 ; i < this._animations.length; i++) {
                this.finishAnimation(this._animations[i]);
            }
            return;
        }

        // Every animation stores it's currently registered animation as this.[type]Animation
        // If we're not currently performing an animation of this type no need to proceed
        var ID = this._getAnimationID(type);
        if (!this[ID]) return;
        // Call 'finishAnimation' directly on the Animation class. This will cancel further
        // animations and fire the animation action with a ratio of 1, passing in the
        // 'earlyFinish' parameter.
        if (this.logIsInfoEnabled("animation")) {
            this.logInfo("manual finish for animations: " + this.echoAll(this[ID]) +
                          (this.logIsDebugEnabled("animation") ? this.getStackTrace() : ""),
                          "animation");
        }

        isc.Animation.finishAnimation(this[ID]);
    },

    // --------------------------------
    // Developer visible APIS:

    //> @method Callbacks.AnimationCallback
    // A +link{type:Callback} called when the move completes.
    //
    // @param earlyFinish (boolean)  true if the animation was cut short.  To quit an animation
    //                               early, simply call the non-animated version of the same
    //                               API, so for example call +link{canvas.hide()} to cut short
    //                               an animation from +link{canvas.animateHide()} already in
    //                               progress.
    // @visibility external
    //<

    //> @method canvas.animateMove()
    // Animate a reposition of this canvas from its current position to the specified position
    // @param left (Integer) new left position (or null for unchanged)
    // @param top (Integer) new top position (or null for unchanged)
    // @param [callback] (AnimationCallback) When the move completes this callback will be
    //                       fired. Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       APIs +link{moveTo()} or +link{moveBy()}.
    // @param [duration] (Integer) Duration in ms of the animated move
    // @param [acceleration] (AnimationAcceleration) Optional acceleration effect to bias the ratios
    // @visibility animation
    // @group animation
    // @example animateMove
    //<

    _$move:"move",
    animateMove : function (left, top, callback, duration, acceleration) {
        return this.animateRect(left, top, null, null, callback, duration,
                                acceleration, this._$move);
    },
    fireAnimationMove : function (ratio, ID, earlyFinish) {
        // pass along the additional "type" parameter
        return this.fireAnimationRect(ratio, ID, earlyFinish, this._$move);
    },

    //> @method canvas.animateResize()
    // Animate a resize of this canvas from its current size to the specified size
    // <p>
    // Note that +link{animateResizeLayoutMode} allows you to control whether child layout is
    // rerun during every step of the animation, or just at the end, since the former may incur
    // significant overhead depending on the widget hierarchy.
    //
    // @param width (Integer) new width (or null for unchanged)
    // @param height (Integer) new height (or null for unchanged)
    // @param [callback] (AnimationCallback) When the resize completes this callback will be
    //                       fired. Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       APIs +link{resizeTo()} or +link{resizeBy()}.
    // @param [duration] (Integer) Duration in ms of the animated resize
    // @param [acceleration] (AnimationAcceleration) Optional acceleration effect to apply to the resize
    // @visibility animation
    // @group animation
    // @example animateResize
    //<
    _$resize:"resize",
    animateResize : function (width, height, callback, duration, acceleration) {
        return this.animateRect(null, null, width, height, callback, duration, acceleration,
                                    this._$resize);
    },
    fireAnimationResize : function (ratio, ID, earlyFinish) {
        // pass along the additional 'type' parameter
        return this.fireAnimationRect(ratio, ID, earlyFinish, this._$resize);
    },

    //> @method canvas.animateRect()
    // Animate a reposition / resize of this canvas from its current size and position.
    // @param left (Integer) new left position (or null for unchanged)
    // @param top (Integer) new top position (or null for unchanged)
    // @param width (Integer) new width (or null for unchanged)
    // @param height (Integer) new height (or null for unchanged)
    // @param [callback] (AnimationCallback) When the setRect completes this callback will be
    //                       fired. Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       API +link{setRect()}.
    // @param [duration] (Integer) Duration in ms of the animated setRect
    // @param [acceleration] (AnimationAcceleration) Optional acceleration effect to apply to the animation
    // @visibility animation
    // @group animation
    // @example animateZoom
    //<
    // Additional type parameter allows us to pick up default durations for animated
    // move / resizes, which fall through to this method

    _$rect:"rect",
    animateRect : function (left, top, width, height, callback, duration, acceleration, type) {
        if (type == null) {
            type = this._$rect;
            // when starting a new "rect" animation, we need to finish any currently running
            // "resize", "move", or "rect" animations.  "rect" animations will automatically be
            // killed by starting a new "rect" animation (in _startAnimation()), but we have to
            // kill "resize" or "move" animations here directly
            if (this.resizeAnimation != null) this.finishAnimation(this._$resize);
            if (this.moveAnimation != null) this.finishAnimation(this._$move);
        }

        // This info object will be available to the repeatedly fired animation action as
        // this.$rectAnimationInfo
        var info = {_fromRect:this.getRect(), _left:left, _top:top, _width:width, _height:height,
                    _callback:callback};
        // call this._startAnimation() to handle actually setting up the animation.
        return this._startAnimation(type, info, duration, acceleration);
    },

    // fireAnimationRect() - fired repeatedly on a timer as the setRect animation proceeds
    // when ratio == 1 the animation is complete
    // Note: we rely on this naming scheme "fireAnimation[AnimationType]"
    // in '_startAnimation()' / 'finishAnimation()'
    fireAnimationRect : function (ratio, ID, earlyFinish, type) {


        var info = (type == this._$resize ? this.$resizeAnimationInfo :
                    (type == this._$move ? this.$moveAnimationInfo : this.$rectAnimationInfo)),
            fromRect = info._fromRect,
            toLeft  = info._left,  toTop    = info._top,
            toWidth = info._width, toHeight = info._height,

            left =
                toLeft != null ? this._getRatioTargetValue(fromRect[0], toLeft, ratio) : null,
            top =
                toTop != null ? this._getRatioTargetValue(fromRect[1], toTop, ratio) : null;

        // hueristic for smooth enlarge/shrink and similar animations: during eg a shrink from
        // all 4 corners, we are increasing left while shrinking width.  In order for centered
        // content within the rect to stay at a stable position, width must shrink by exactly
        // double what left changes by.  This won't happen if we do separate
        // (ratio * difference) calculations, no matter if we use Math.round,ceil,or floor.
        // Instead, if width and left or height and top are both changing and are an even
        // multiple of each other, use a multiple of left's delta for width instead of
        // calculating the width delta separately (likewise for top/height).
        var width, height;
        if (toWidth != null && left != null && (toLeft - fromRect[0] != 0)) {
            var sideRatio = (toWidth - fromRect[2]) / (toLeft - fromRect[0]);
            if (Math.floor(sideRatio) == sideRatio) {
                //this.logWarn("using ratio: " + sideRatio +
                //             ", fromRect: " + fromRect +
                //             ", toLeft,toWidth: " + [toLeft,toWidth] +
                //             ", on delta: " + (left - fromRect[0]));
                width = fromRect[2] + (sideRatio * (left - fromRect[0]));
            }
        }
        if (toHeight != null && top != null && (toTop - fromRect[1] != 0)) {
            var sideRatio = (toHeight - fromRect[3]) / (toTop - fromRect[1]);
            if (Math.floor(sideRatio) == sideRatio) {
                height = fromRect[3] + (sideRatio * (top - fromRect[1]));
            }
        }
        if (width == null && toWidth != null) {
            width = this._getRatioTargetValue(fromRect[2], toWidth, ratio);
        }
        if (height == null && toHeight != null) {
            height = this._getRatioTargetValue(fromRect[3], toHeight, ratio);
        }


        if (ratio < 1 && (toWidth  == null || toWidth  == width) &&
                         (toHeight == null || toHeight == height))
        {
            width = height = null;
        }

        if (ratio == 1) {
            if (type == null) type = "rect";
            this._clearAnimationInfo(type);
        }
        // Pass in the additional 'animating' param.
        // - avoids setRect from relaying out children
        // - notifies it that this is not an external setRect call in the middle of an
        //   animation.

        //this.logWarn("ratio: " + ratio + ", animateRect: " + [left,top,width,height]);

        this.setRect(left, top, width, height, ratio < 1);

        if (this.isDirty()) this.redraw("animated resize");

        if (ratio == 1) {
            this._fireAnimationCompletionCallback(info._callback, earlyFinish);
        }
    },

    // A very common pattern in our animations is to step incrementally from one value to
    // another.
    _getRatioTargetValue : function (from, to, ratio) {
        // Common thing - a null 'to' indicates no change
        if (to == null) return from;
        return (from + Math.floor(ratio * (to - from)));
    },


    //> @method canvas.animateFade()
    // Animate a change in opacity from the widget's current opacity to the specified opacity.
    // @param opacity (Integer) desired final opacity
    // @param [callback] (AnimationCallback) When the fade completes this callback will be
    //                       fired.  Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       API +link{setOpacity()}.
    // @param [duration] (Integer) Duration in ms of the animated fade
    // @param [acceleration] (AnimationAcceleration) Optional animation acceleration to bias the ratios
    // @visibility animation
    // @group animation
    // @example animateFade
    //<
    animateFade : function (opacity, callback, duration, acceleration) {

        // if we're undrawn, just set the opacity instantly.
        if (!this.isDrawn()) {
            this.setOpacity(opacity);
            this._fireAnimationCompletionCallback(callback, true);
            return;
        }

        if (this.visibility == isc.Canvas.HIDDEN) {
            this.setOpacity(0);
            this.show();
        }
        // opacity of 'null' implies default - 100%
        if (opacity == null) opacity = 100;
        var info = {_fromOpacity:this.opacity != null ? this.opacity : 100,
                    _toOpacity:opacity, _callback:callback};
        return this._startAnimation("fade", info, duration, acceleration)
    },

    // fireAnimationFade() - fired repeatedly to perform an animation fade.
    fireAnimationFade : function (ratio, ID, earlyFinish) {
        var info = this.$fadeAnimationInfo,
            fromOpacity = info._fromOpacity,
            toOpacity = info._toOpacity;

        var opacity = this._getRatioTargetValue(fromOpacity, toOpacity, ratio);

        if (isc.Browser.isIE && opacity > 0 && !info._toggledVis && !isc.Browser.isIE9) {
            var styleHandle = this.getStyleHandle();
            if (styleHandle) {
                styleHandle.visibility = isc.Canvas.VISIBLE;
                styleHandle.visibility = isc.Canvas.INHERIT;
            }
            // we also need to toggle visibility of any peers which get faded with the master!
            var peers = this.peers;
            if (peers && peers.length > 0) {
                for (var i = 0; i < peers.length; i++) {
                    if (peers[i]._setOpacityWithMaster) {
                        var styleHandle = peers[i].getStyleHandle();
                        if (styleHandle) {
                            styleHandle.visibility = isc.Canvas.VISIBLE;
                            styleHandle.visibility = isc.Canvas.INHERIT;
                        }
                    }
                }
            }

            info._toggledVis = true;
        }


        if (ratio == 1) {
            this._clearAnimationInfo("fade");
        }
        this.setOpacity(opacity, (ratio < 1));
        if (ratio == 1) this._fireAnimationCompletionCallback(info._callback, earlyFinish);
    },


    //> @method canvas.animateScroll()
    // Animate a scroll from the current scroll position to the specified position.
    // @param scrollLeft (Integer) desired final left scroll position
    // @param scrollTop (Integer) desired final top scroll position
    // @param [callback] (AnimationCallback) When the scroll completes this callback will be
    //                       fired. Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       APIs +link{scrollTo()} or +link{scrollBy()}.
    // @param [duration] (Integer) Duration in ms of the animated scroll
    // @param [acceleration] (AnimationAcceleration) Optional acceleration to bias the animation ratios
    // @visibility animation
    // @group animation
    //<
    animateScroll : function (scrollLeft, scrollTop, callback, duration, acceleration) {
        var overflow = this.overflow;
        if (this.overflow == isc.Canvas.VISIBLE) return;

        var info = {_fromLeft:this.getScrollLeft(), _fromTop:this.getScrollTop(),
                    _toLeft:scrollLeft, _toTop:scrollTop, _callback:callback};
        return this._startAnimation("scroll", info, duration, acceleration);
    },

    fireAnimationScroll : function (ratio, ID, earlyFinish) {
        var info = this.$scrollAnimationInfo,
            fromLeft = info._fromLeft, toLeft = info._toLeft,
            fromTop = info._fromTop, toTop = info._toTop,
            newLeft = this._getRatioTargetValue(fromLeft, toLeft, ratio),
            newTop = this._getRatioTargetValue(fromTop, toTop, ratio);

        if (ratio == 1) {
            this._clearAnimationInfo("scroll");
        }
        this.scrollTo(newLeft, newTop, null, (ratio < 1));
        if (ratio ==1 && info._callback) {
            this._fireAnimationCompletionCallback(info._callback, earlyFinish);
        }
    },


    // animate show effect / effectID split into separate objects for clarity / integration with
    // tools etc
    // (We could also separate animate hide effects from animate show effects).
    //> @type AnimateShowEffectId
    // String specifying effect to apply during an animated show or hide.
    // @value "slide" content slides into or out of view as the widget grows or shrinks
    // @value "wipe" content is revealed or wiped as the widget grows or shrinks
    // @value "fade" widget's opacity smoothly fades into or out of view
    // @value "fly" widget moves into position from offscreen
    // @visibility animation
    //<

    //> @object AnimateShowEffect
    // Configuration object for effect to apply during an animated show or hide.
    // @treeLocation Client Reference/System
    // @visibility animation
    //<
    //> @attr AnimateShowEffect.effect (AnimateShowEffectId : null : IR)
    // Effect to apply
    // @visibility animation
    //<

    //> @attr AnimateShowEffect.startFrom (String : null : IR)
    //   For show animations of type <code>"wipe"</code> and
    //   <code>"slide"</code> this attribute specifies where the wipe / slide should originate.
    //   Valid values are <code>"T"</code> (vertical animation from the top down, the
    //   default behavior), and <code>"L"</code> (horizontal animation from the left side).
    // @visibility animation
    //<

    //> @attr AnimateShowEffect.endAt (String : null : IR)
    //   For hide animations of type <code>"wipe</code> and
    //   <code>"slide"</code> this attribute specifies where the wipe / slide should finish.
    //   Valid options are <code>"T"</code> (vertical animation upwards to the top of the canvas,
    //   the default behavior) and <code>"L"</code> (horizontal animation to the left of the
    //   canvas).
    // @visibility animation
    //<

    //> @attr AnimateShowEffect.endsAt (String : null : IR)
    // Use +link{endAt} instead.
    // @deprecated This property was misnamed.
    // @visibility animation
    //<

    //> @method canvas.animateShow()
    // Show a canvas by growing it vertically to its fully drawn height over a period of time.
    // This method will not fire if the widget is already drawn and visible, or has overflow
    // other than <code>"visible"</code> or <code>"hidden"</code>.
    // @param [effect] (AnimateShowEffectId | AnimateShowEffect) Animation effect to use
    //      when revealing the widget. If ommitted, default behavior can be configured via
    //      +link{Canvas.animateShowEffect}
    // @param [callback] (AnimationCallback) When the show completes this callback will be
    //                       fired. Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       API +link{show()}.
    // @param [duration] (Integer) Duration in ms of the animated show. If unset, duration will be
    //   picked up from +link{canvas.animateShowTime}
    // @param [acceleration] (AnimationAcceleration) Optional acceleration effect function to
    //   bias the animation ratios.  If unset, acceleration will be picked up from
    //   +link{canvas.animateShowAcceleration}
    // @visibility animation
    // @group animation
    // @example animateWipe
    //<
    _$show:"show",
    _$slide:"slide",
    _$wipe:"wipe",
    _$fade:"fade",
    _$fly:"fly",
    _$T:"T", _$L:"L",
    _showEffectAnimationMap:{slide:"show", wipe:"show", fly:"move", fade:"fade"},
    animateShow : function (effect, callback, duration, acceleration) {
        // have a way to default the animate show / hide effect for all calls to these methods
        if (effect == null) effect = this.animateShowEffect;

        var effectConfig;
        if (isc.isAn.Object(effect)) {
            effectConfig = effect;
            effect = effect.effect;
        }
        // If we're in the process of doing an animateHide(), finish that before we do the
        // animateShow() - this is required to avoid a no-op due to the fact that the widget
        // is currently drawn/visible.
        if (this._animatingHide != null) this.finishAnimation(this._animatingHide);

        // Could fire callback if it's already showing?
        if (this.isDrawn() && this.isVisible()) {
            return;
        }
        // Also - if we're in mid 'animateShow()' just bail

        if (this._animatingShow != null) {
            return;
        }

        // If we're undrawn, draw() if _drawOnShow() is true - true for top level widgets
        // that are not peers.
        // Otherwise fall through to default 'show()' method to show [without drawing]
        // immediately
        if (!this.isDrawn()) {
            if (this.parentElement && !this.parentElement.isDrawn()) {
                this.show();
                this.logInfo("not animating show, component not drawn", "animation");
                // again - this is an 'early finish'
                this.animateShowComplete(true);
                return;
            } else {
                // set _animatingShow before draw(), so that children can know if they're
                // being drawn as a result of their parent being animated - Calendars use
                // this to ensure proper fetching as views draw as part of animate show
                // on the outer Calendar
                this._animatingShow = this._showEffectAnimationMap[effect] || this._$show;
                this.draw();
            }
        }

        // animateShow() / animateHide() fall through to various methods to perform the actual
        // animation based on the effect passed in.
        // This means we can't just check 'this.isAnimating("show")' or 'this.isAnimating("hide")'
        // - the animation may be performed via a move or fade.
        // Add a flag at the beginning of animateShow() / animateHide() so we can readily check
        // for the case where we're in this state.
        // Also - always fire an "animateShowComplete()" callback when the show/hide completes
        // this allows us to clear the flag before firing whatever callback was passed into
        // this method.
        this._animatingShow = this._showEffectAnimationMap[effect] || this._$show;
        this._animateShowCallback = callback;

        if (!this._animateShowCompleteCallback)
            this._animateShowCompleteCallback = {target:this, methodName:"animateShowComplete"}

        if (effect == this._$fade) {
            var targetOpacity = this.opacity;
            this._fadeShowCallback = callback;
            this.setOpacity(0);
            this.show();
            // Explicitly default to animateShowTime / animateShowAcceleration rather than
            // falling through to animateFadeTime / Acceleration
            if (duration == null) duration = this.animateShowTime;
            if (acceleration == null) acceleration = this.animateShowAcceleration;
            // Simply fall through to animate fade, then fire the callback on completion.
            return this.animateFade(targetOpacity, this._animateShowCompleteCallback,
                                    duration, acceleration);
        } else if (effect == this._$fly) {
            // fly effect not currently supported for non-top-level widgets

            if (this.parentElement != null) {
                this.logInfo("animateShow() called with 'fly' effect - not supported for child widgets" +
                             " defaulting to standard 'wipe' animation instead.", "animation");
                effect = this._$wipe;
            } else {

                // Explicitly default to animateShowTime / animateShowAcceleration rather than
                // falling through to animateMoveTime / Acceleration
                if (duration == null) duration = this.animateShowTime;
                if (acceleration == null) acceleration = this.animateShowAcceleration;
                // Simply fall through to animate move, then fire the callback on completion.

                var rtl = this.isRTL(),
                    specifiedLeft = this.getLeft(),
                    offscreenLeft = rtl ? isc.Page.getWidth() + isc.Page.getScrollLeft()
                                        : 0 - this.getVisibleWidth();

                this._flyShowPercentLeft = this._percent_left,

                this.setLeft(offscreenLeft);
                this.show();
                return this.animateMove(specifiedLeft, null, this._animateShowCompleteCallback,
                                        duration, acceleration);
            }
        }
        // If we can't animate the show, just show and fire callback
        if (!this._canAnimateClip(effect)) {
            this.logInfo("not animating show, can't do clip animations", "animation");
            this.show();
            // essentially this is an 'early finish'
            this.animateShowComplete(true);
            return;
        }

        // Start from drawn / hidden - this way we can get the drawn scrollHeight.
        if (this.isVisible()) this.hide();

        var drawnHeight = this.getVisibleHeight(),
            drawnWidth = this.getVisibleWidth(),
            // default to showing from the top down
            // Note that we currently just support top down or left in so convert this to a
            // boolean for simplicity

            vertical = effectConfig ? effectConfig.startFrom == this._$T : true,
            scrollStart = (vertical ? this.getScrollTop() : this.getScrollLeft()),
            slideIn = (effect == "slide"),

            info = {
                _userHeight:this._userHeight, _specifiedHeight:this.getHeight(),
                _drawnHeight:drawnHeight,
                _userWidth:this._userWidth, _specifiedWidth:this.getWidth(),
                _drawnWidth:drawnWidth,

                _percentWidth:this._percent_width, _percentHeight:this._percent_height,

                _originalOverflow:this.overflow,

                _vertical:vertical,
                _scrollStart:scrollStart,
                _slideIn:slideIn,

                _callback:this._animateShowCompleteCallback
            };

        if (vertical) {
            if (this.vscrollOn && this.vscrollbar) {
                info._scrollThumbStart = this.vscrollbar.thumb.getTop();
                info._scrollThumbLength = this.vscrollbar.thumb.getHeight();

                // don't show the thumb with the s-b - we'll show it and grow it into view
                if (this.vscrollbar.thumb) {
                    this.vscrollbar.thumb._showWithMaster = false;
                    this.vscrollbar.thumb._suppressImageResize = true;
                }

                this.vscrollbar._suppressSetThumb = true;
                this.vscrollbar._suppressImageResize = true;

                // resize the scrollbar to be 1px so it doesn't flash when first shown
                this.vscrollbar.setHeight(1);
            }
            if (this.hscrollOn && this.hscrollbar) {
                this.hscrollbar._suppressImageResize = true;
                if (this.hscrollbar.thumb) this.hscrollbar.thumb._suppressImageResize = true;
                // If we're doing a wipe, we won't show the breadth scrollbar until
                // the rest of the widget has been 'wiped' into view
                if (!info._slideIn) {
                    this.hscrollbar._showWithMaster = false;
                } else {
                    this.hscrollbar.setTop(this.getTop());
                    this.hscrollbar.setHeight(1);
                }
            }

        } else {
            if (this.hscrollOn && this.hscrollbar) {
                info._scrollThumbStart = this.hscrollbar.thumb.getLeft();
                info._scrollThumbLength = this.hscrollbar.thumb.getWidth();

                this.hscrollbar._suppressSetThumb = true;
                this.hscrollbar._suppressImageResize = true;


                // don't show the thumb with the s-b - we'll show it and grow it into view
                if (this.hscrollbar.thumb) {
                    this.hscrollbar.thumb._showWithMaster = false;
                    this.hscrollbar.thumb._suppressImageResize = true;
                }
                this.hscrollbar.setWidth(1);
            }
            if (this.vscrollOn && this.vscrollbar) {
                this.vscrollbar._suppressImageResize = true;
                if (this.vscrollbar.thumb) this.vscrollbar.thumb._suppressImageResize = true;
                // If we're doing a wipe, we won't show the breadth scrollbar until
                // the rest of the widget has been 'wiped' into view
                if (!info._slideIn) {
                    this.vscrollbar._showWithMaster = false;
                } else {
                    this.vscrollbar.setLeft(this.getLeft());
                    this.vscrollbar.setWidth(1);
                }
            }
        }

        // If we have a visible edged canvas suppress react to resize before we set overflow
        // to hidden or resize the handle so the edged canvas doesn't get resized as a peer

        if (this.showEdges && this._edgedCanvas) {
            this._edgedCanvas._suppressReactToResize = true;
        }

        // Set overflow to hidden, then grow to the drawn size (and then reset overflow)
        if (this.overflow == isc.Canvas.VISIBLE) {
            this.setOverflowForAnimation(isc.Canvas.HIDDEN, this.overflow);
        }

        // suppress adjustOverflow during the animation if we have scrollbars
        if (this.overflow == isc.Canvas.AUTO || this.overflow == isc.Canvas.SCROLL) {
            this._suppressAdjustOverflow = true;
        }

        // additional param indicates that this is an animated resize
        this.resizeTo((vertical ? drawnWidth : 1), (vertical ? 1 : drawnHeight), true);
        if (slideIn) this.scrollTo((vertical ? null : scrollStart + (drawnWidth-1)),
                                   (vertical ? scrollStart + (drawnHeight-1) : null));


        if (this.showEdges && this._edgedCanvas) {
            // Explicitly size the edgeCanvas' table (rather than sizing at 100%), so that
            // as the edged canvas resizes, the edge clips rather than growing/shrinking
            if (vertical)
                this._assignSize(this._edgedCanvas.getHandle().firstChild.style, "height", drawnHeight);
            else
                this._assignSize(this._edgedCanvas.getHandle().firstChild.style, "width", drawnWidth);

            this._edgedCanvas.setOverflow(isc.Canvas.HIDDEN);

            // If we're sliding in, align the handle with the top of the edged canvas to
            // start with, so it will grow down from the top.
            if (slideIn) {
                if (vertical) {
                    var startEdgeSize = this._edgedCanvas._topMargin;
                    this._assignSize(this.getStyleHandle(), "marginTop", (this.getTopMargin() - startEdgeSize));
                } else {
                    var startEdgeSize = this._edgedCanvas._leftMargin;
                    this._assignSize(this.getStyleHandle(), "marginLeft", (this.getLeftMargin() - startEdgeSize));
                }
            }

            // Don't show the main Canvas right away if we have edges, just show the edges.
            // Only show the edges, then show the main Canvas when the animation has passed the
            // edge.
            this._edgedCanvas.show();
        } else {
            var breadthScrollbar = vertical ? (this.hscrollOn ? this.hscrollbar : null)
                                            : (this.vscrollOn ? this.vscrollbar : null),

                lengthScrollbar = vertical ? (this.vscrollOn ? this.vscrollbar : null)
                                           : (this.hscrollOn ? this.hscrollbar : null);

            // If we're sliding in, and we have an h-scrollbar, show it and allow it to grow
            // before showing this canvas
            if (breadthScrollbar && info._slideIn) {
                breadthScrollbar.show();
                if (lengthScrollbar) lengthScrollbar.show();
            } else {
                this.show();
            }
        }

        return this._startAnimation(this._$show, info, duration, acceleration);

    },

    // Actually fire the show animation
    // Grows the widget (according to the current ratio), and if slideIn is true keeps scrolled
    // so the content appears to slide in with the bottom of the widget.
    fireAnimationShow : function (ratio, ID, earlyFinish) {
        var info = this.$showAnimationInfo,
            vertical = info._vertical;


        if (ratio < 1) {
            var drawnSize = (vertical ? info._drawnHeight : info._drawnWidth),
                size = this._getRatioTargetValue(1, drawnSize, ratio),
                delta = drawnSize - size,
                adjustForEdge = (this.showEdges && this._edgedCanvas),
                // Note if we're wiping into view we show the top edge, then the bottom edge
                // if we're sliding into view it's the other way around because of scrolling
                startEdgeSize, endEdgeSize;


            if (adjustForEdge) {
                // Note: we can't just check this.edgeSize, since we support asymmetric edges
                // and by default the value is just picked up from the EdgedCanvas class.
                startEdgeSize = (info._slideIn ? (vertical ? this._edgedCanvas._bottomMargin
                                                           : this._edgedCanvas._rightMargin)
                                               : (vertical ? this._edgedCanvas._topMargin
                                                           : this._edgedCanvas._leftMargin)),
                endEdgeSize = (info._slideIn ? (vertical ? this._edgedCanvas._topMargin
                                                         : this._edgedCanvas._leftMargin)
                                             : (vertical ? this._edgedCanvas._bottomMargin
                                                         : this._edgedCanvas._rightMargin));

                this._edgedCanvas.resizeTo((vertical ? null : size), (vertical ? size: null), true);
                if (info._slideIn) {
                    if (vertical) this._edgedCanvas.scrollToBottom();
                    else this._edgedCanvas.scrollToRight();
                }

                // Just bail if we haven't started to expose the actual handle yet.
                if (size < startEdgeSize) return;

                // We don't need to resize the handle once it's completely exposed (at this
                // point we're just revealing the final edge)
                if (delta <= endEdgeSize) {
                    // If sliding in, align the top of the handle with the bottom of the
                    // top edge, and ensure we're now scrolled to our final scroll position
                    // (avoids a jump when we actually reach ratio 1).
                    if (info._slideIn) {
                        var marginProp = (vertical ? "marginTop" : "marginLeft"),
                            marginSize = (vertical ? this.getTopMargin() - delta
                                                   : this.getLeftMargin() - delta);
                        this._assignSize(this.getStyleHandle(), marginProp, marginSize);

                        this.scrollTo((vertical ? null : info._scrollStart),
                                      (vertical ? info._scrollTop : null),
                                      null, true);
                    }
                    return;
                }

                // If we got here, we know the handle should be >= 1px tall, so needs to be
                // visible

                if (!this.isVisible()) {
                    this._showingAsAnimation = true;
                    this.show();
                    delete this._showingAsAnimation;
                }
            }


            var lengthScrollOn = vertical ? this.vscrollOn : this.hscrollOn,
                breadthScrollOn = vertical ? this.hscrollOn : this.vscrollOn;
            if (lengthScrollOn) {
                var lengthScrollbar;
                if (vertical) {
                    lengthScrollbar = this.vscrollbar;
                    if (lengthScrollbar) lengthScrollbar.resizeTo(null, size);
                } else {
                    lengthScrollbar = this.hscrollbar;
                    var sbsize = size;
                    if (this.vscrollOn) {
                        if (info._slideIn) {
                            sbsize -= this.scrollbarSize;
                        } else {
                            sbsize = Math.min(size, drawnSize-this.scrollbarSize);
                        }
                    }
                    if (sbsize > 0) {
                        if (lengthScrollbar) lengthScrollbar.resizeTo(sbsize, null);
                    }
                }

                if (info._slideIn && lengthScrollbar) {
                    if (vertical) lengthScrollbar.scrollToBottom();
                    else lengthScrollbar.scrollToRight();
                }

                // thumb
                if (lengthScrollbar && lengthScrollbar.thumb) {
                    var thumb = lengthScrollbar.thumb;

                    // On a "slideIn" we need to grow the thumb then shift it in from the top
                    if (info._slideIn) {
                        var thumbStart = info._scrollThumbStart - delta,
                            thumbEnd = thumbStart + Math.min(size, info._scrollThumbLength),
                            start = vertical ? this.getTop() : this.getLeft();

                        if (thumbEnd <= start) {
                            // thumb should already be hidden - don't show it
                        } else {
                            // shorten the thumb if necessary
                            thumbStart = Math.max(start, thumbStart);
                            var thumbLength = Math.min(thumbEnd-thumbStart, size);

                            thumb.resizeTo(vertical ? null : thumbLength,
                                           vertical ? thumbLength : null);

                            if (vertical) thumb.scrollToBottom()
                            else thumb.scrollToRight();

                            thumb.moveTo(vertical ? null : thumbStart,
                                         vertical ? thumbStart: null);
                            if (!thumb.isVisible()) thumb.show();
                        }

                    // on a wipe animation, we simply show, then resize the thumb from the
                    // top down
                    } else {
                        var thumbStart = info._scrollThumbStart,
                            thumbEnd = Math.min((thumbStart + info._scrollThumbLength),
                                                (vertical ?
                                                    this.getTop() + size :
                                                    this.getLeft() + size));

                        var end = (vertical ? this.getTop() : this.getLeft()) + size
                        if (end <= thumbStart) {
                            // don't show the thumb yet unless its in view
                        } else {
                            if (vertical) thumb.setHeight(thumbEnd -thumbStart);
                            else thumb.setWidth(thumbEnd-thumbStart);
                            if (!thumb.isVisible()) thumb.show();
                        }
                    }
                }
            }

            // If we're showing a breadth scrollbar, the widget handle renders at the the
            // specified size less the scrollbarsize
            // If the scrollbar is (partially or fully) hidden we therefore need to increase our
            // specified size by the difference between the rendered scrollbarSize and
            // this.scrollbarSize to ensure the handle draws large enough
            var hiddenScrollbarDelta = 0;
            if (breadthScrollOn && breadthScrollbar) {
                var breadthScrollbar = vertical ? this.hscrollbar : this.vscrollbar;
                if (info._slideIn) {

                    var sbStart = vertical ? (this.getTop() + Math.max(0, (size - this.scrollbarSize)))
                                           : (this.getLeft() + Math.max(0, (size - this.scrollbarSize)))
                    breadthScrollbar.moveTo(vertical ? null : sbStart, vertical ? sbStart : null);

                    var sbSize = Math.min(size, this.scrollbarSize);
                    breadthScrollbar.resizeTo(vertical ? null : sbSize,
                                              vertical ? sbSize : null);

                    if (vertical) {
                        breadthScrollbar.scrollToBottom();
                        if (breadthScrollbar.thumb) breadthScrollbar.thumb.scrollToBottom();
                    } else {
                        breadthScrollbar.scrollToRight();
                        if (breadthScrollbar.thumb) breadthScrollbar.thumb.scrollToRight();
                    }


                    if (size > this.scrollbarSize && !this.isVisible()) {

                        this._showingAsAnimation = true;
                        this.show();
                        delete this._showingAsAnimation;
                    }
                } else {
                    if (delta <= this.scrollbarSize) {
                        if (!breadthScrollbar.isVisible()) breadthScrollbar.show();
                        breadthScrollbar.resizeTo(vertical ? null : this.scrollbarSize-delta,
                                                  vertical ? this.scrollbarSize-delta : null);
                    }
                    // Otherwise we know the scrollbar isn't showing - nothing to do here
                }

                if (breadthScrollbar.isVisible()) {
                    hiddenScrollbarDelta = this.scrollbarSize -
                                            (vertical ? breadthScrollbar.getHeight()
                                                      : breadthScrollbar.getWidth());
                } else {
                    hiddenScrollbarDelta = this.scrollbarSize;
                }
            }

            // Actually resize the handle.
            // If we're showing edges, modify the height passed to resizeTo so we don't account
            // for the bottom edge which is currently clipped.
            var handleSize = size;
            if (adjustForEdge) handleSize += endEdgeSize;
            // ditto with the "breadth" axis scrollbar
            if (hiddenScrollbarDelta) handleSize += hiddenScrollbarDelta


            // Note additional param
            // - to avoid firing layoutChildren() on every step.
            // - notify that this is not an external 'resize' call

            if (!this.resizeTo((vertical ? null : handleSize), (vertical ? handleSize : null),
                                true))
            {
                this._resized();
            }
            if (info._slideIn) {
                this.scrollTo((vertical ? null : info._scrollStart + delta),
                              (vertical ? info._scrollStart + delta : null),
                              null, true);
            }

        // Ratio == 1
        } else {
            // If we are showing edges we're not show()n until we get pushed / scrolled into
            // view.
            // If we're not visible now, call this.show()
            // (Only likely to happen from an early finish of the animation)
            if (!this.isVisible()) this.show();

            this._clearAnimationInfo("show");

            if (!this.resizeTo(info._specifiedWidth, info._specifiedHeight)) {
                // force _resized() notification to fire - this is required since if we're resizing
                // a breadth scrollbar our reported size may not have changed but our drawn size
                // may  have. We still want layouts etc to respond to the size change.
                this._resized();
            }
            this.setOverflowForAnimation(info._originalOverflow);

            if (this.overflow == isc.Canvas.AUTO || this.overflow == isc.Canvas.SCROLL) {
                delete this._suppressAdjustOverflow;

                // reset all the properties for auto-management of scrollbar.
                if (this.vscrollOn && this.vscrollbar) {
                    if (this.vscrollbar.visibility == isc.Canvas.HIDDEN) this.vscrollbar.show();
                    if (vertical) delete this.vscrollbar._suppressSetThumb;
                    delete this.vscrollbar._suppressImageResize;
                    this.vscrollbar._showWithMaster = true;
                    if (info._slideIn) this.vscrollbar.scrollTo(0,0);
                    if (this.vscrollbar.thumb) {
                        delete this.vscrollbar.thumb._suppressImageResize;
                        this.vscrollbar.thumb._showWithMaster = true;
                        if (info._sideIn) this.vscrollbar.thumb.scrollTo(0,0);
                    }
                    if (!vertical) {
                        this.vscrollbar.setWidth(this.getScrollbarSize());
                        this.vscrollbar.setThumb();
                    }
                }
                if (this.hscrollOn && this.hscrollbar) {
                    if (this.hscrollbar.visibility == isc.Canvas.HIDDEN) this.hscrollbar.show();
                    if (!vertical) {
                        delete this.hscrollbar._suppressSetThumb;
                    } else {
                        this.hscrollbar.setHeight(this.getScrollbarSize());
                        this.hscrollbar.setThumb();
                    }
                    delete this.hscrollbar._suppressImageResize;
                    this.hscrollbar._showWithMaster = true;
                    if (info._slideIn) this.hscrollbar.scrollTo(0,0);
                    if (this.hscrollbar.thumb) {
                        delete this.hscrollbar.thumb._suppressImageResize;
                        this.hscrollbar.thumb._showWithMaster = true;
                        if (info._slideIn) this.hscrollbar.thumb.scrollTo(0,0);
                    }
                }
            }

            if (this.showEdges && this._edgedCanvas) {
                if (info._slideIn) {
                    var marginProp = (vertical ? "marginTop" : "marginLeft"),
                        marginSize = (vertical ? this.getTopMargin() : this.getLeftMargin());
                    this._assignSize(this.getStyleHandle(), marginProp, marginSize);
                    this._edgedCanvas.scrollTo((vertical ? null : 0), (vertical ? 0 : null));
                }
                if (vertical)
                    this._edgedCanvas.getHandle().firstChild.style.height = "100%";
                else
                    this._edgedCanvas.getHandle().firstChild.style.width = "100%";

                this._edgedCanvas.setOverflow(isc.Canvas.VISIBLE);
                delete this._edgedCanvas._suppressReactToResize;
            }



            this.updateUserSize(info._userWidth,  this._$width);
            this.updateUserSize(info._userHeight, this._$height);


            this._percent_width = info._percentWidth;
            this._percent_height = info._percentHeight;

            if (info._slideIn) this.scrollTo((vertical ? null : info._scrollStart),
                                             (vertical ? info._scrollStart : null));
            if (info._callback) {
                this._fireAnimationCompletionCallback(info._callback, earlyFinish);
            }
        }
    },

    // When doing an animateShow/animateHide we have to temporarily set overflow to "hidden"
    // so the user sees the handle clip its content as expected.
    // Use a separate method for this and set a flag so if necessary widgets can see
    // what the actual, suppressed overflow is

    setOverflowForAnimation : function (overflow, specifiedOverflow) {
        if (specifiedOverflow != null) {
            this._$suppressedOverflowDuringAnimation = specifiedOverflow;
        } else {
            delete this._$suppressedOverflowDuringAnimation;
        }
        this.setOverflow(overflow);
    },

    // Always fired when show animation completes
    animateShowComplete : function (earlyFinish) {

        if (this._flyShowPercentLeft != null) {
            this._percent_left = this._flyShowPercentLeft;
            delete this._flyShowPercentLeft;
        }

        this._animatingShow = null;
        var callback = this._animateShowCallback;
        this._animateShowCallback = null;
        // Pass in the 'synchronous' param to fireAnimationComplete so the callback fires
        // synchronously. animateShowComplete() was itself fired asynchronously so no need
        // to delay again.
        if (callback) this._fireAnimationCompletionCallback(callback, earlyFinish, true);
    },

    //> @attr canvas.canAnimateClip (boolean : null : IRWA)
    // Whether to "wipe" and "slide" show/hide animations.  Default is to allow such animations
    // for non-scrolling widgets.
    // @group animation
    // @visibility internal
    //<

    _canAnimateClip : function (effect) {
        if (this.canAnimateClip != null) return this.canAnimateClip;
        // - slide effect calls scrollTo() code - should not do so if scrollTo method has been
        //   overridden, as component may not understand animation, so check:
        //         this.scrollTo == isc.Canvas.getInstanceProperty("scrollTo")
        return (this.scrollTo == isc.Canvas.getInstanceProperty("scrollTo"));

    },

    //> @method canvas.animateHide()
    // Hide a canvas by shrinking it vertically to zero height over a period of time.
    // This method will not fire if the widget is already drawn and visible, or has overflow
    // other than <code>"visible"</code> or <code>"hidden"</code>.
    // @param [effect] (AnimateShowEffectId | AnimateShowEffect) How should the content of the
    //  window be hidden during the hide? If ommitted, default behavior can be configured via
    //  +link{Canvas.animateHideEffect}
    // @param [callback] (AnimationCallback) When the hide completes this callback will be
    //                       fired.  Single 'earlyFinish' parameter will be passed if the
    //                       animation was cut short, for example by a call to the non-animated
    //                       API +link{hide()}.
    // @param [duration] (Integer) Duration in ms of the animated hide.  If unset, duration will be
    //   picked up from +link{canvas.animateHideTime}
    // @param [acceleration] (AnimationAcceleration) Optional acceleration effect function to bias
    //   the animation ratios.  If unset, acceleration will be picked up from
    //   +link{canvas.animateShowTime}
    // @visibility animation
    // @group animation
    // @example animateWipe
    //<
    // @param [synchronousCallback] By default we fire the callback passed into this method
    //                      asynchronously, after the method completes, which allows the
    //                      screen to update before potentially complex callback logic fires
    //                      in some very advanced uses we may require the callback to fire
    //                      synchronously in response to the last step of animation - this
    //                      is achieved via this parameter (used in Layout.js)
    _$hide:"hide",
    _hideEffectAnimationMap:{slide:"hide", wipe:"hide", fly:"move", fade:"fade"},
    animateHide : function (effect, callback, duration, acceleration, synchronousCallback) {
        // have a way to default the animate show / hide effect for all calls to these methods
        if (effect == null) effect = this.animateHideEffect;

        var effectConfig;
        if (isc.isAn.Object(effect)) {
            effectConfig = effect;
            effect = effectConfig.effect;
        }
        // Complate any 'show' animation before starting to hide
        if (this._animatingShow != null) {
            this.finishAnimation(this._animatingShow);
        }
        // If we're already hidden, or undrawn, just bail

        if (!this.isVisible()) return;
        // don't allow 2 calls to animateHide to overlap
        if (this._animatingHide != null) return;
        // If we're undrawn, don't bother doing an animated hide, just hide and fire the
        // callback.

        if (!this.isDrawn() && !isc.isA.LayoutSpacer(this)) {
            this.hide();
            if (callback) this._fireAnimationCompletionCallback(callback, true);
            return;
        }


        this._animatingHide = this._hideEffectAnimationMap[effect] || this._$hide;
        this._animateHideCallback = callback;
        if (!this._animateHideCompleteCallback)
            this._animateHideCompleteCallback = {target:this, methodName:"_animateHideComplete"}

        if (effect == this._$fade) {
            this._fadeHideOpacity = this.opacity;

            this._performingFadeHide = true;

            // default to hide time rather than 'fade' time if no time was passed in
            if (duration == null) duration = this.animateHideTime;
            if (acceleration == null) acceleration = this.animateHideAcceleration;
            // Simply fall through to animate fade, then fire the callback on completion.
            return this.animateFade(0, this._animateHideCompleteCallback,
                                     duration, acceleration, synchronousCallback);
        } else if (effect == this._$fly) {
            this._flyHideLeft = this.getLeft();
            this._flyHidePercentLeft = this._percent_left;

            if (this.parentElement != null) {
                this.logInfo("animateHide() called with 'fly' effect - not supported for child widgets" +
                             " defaulting to standard 'wipe' animation instead.", "animation");
                effect = this._$wipe;
            } else {

                // Explicitly default to animateShowTime / animateShowAcceleration rather than
                // falling through to animateMoveTime / Acceleration
                if (duration == null) duration = this.animateShowTime;
                if (acceleration == null) acceleration = this.animateShowAcceleration;
                // Simply fall through to animate fade, then fire the callback on completion.

                var rtl = this.isRTL(),
                    offscreenLeft = rtl ? isc.Page.getWidth() + isc.Page.getScrollLeft()
                                        : 0 - this.getVisibleWidth();

                return this.animateMove(offscreenLeft, null,
                                        this._animateHideCompleteCallback,
                                        duration, acceleration, synchronousCallback);
            }
        }
        // at this point we're doing a standard hide type animation with wipe / slide effect
        // HACK: LayoutSpacer never reports itself drawn, but can animate
        if ((!this._canAnimateClip(effect) || !this.isDrawn()) &&
            !this.isA(isc.LayoutSpacer))
        {
            this.logInfo("not animating hide, can't do clip animations", "animation");
            this.hide();
            // pass the early-finish parameter
            this._animateHideComplete(true);
            return;
        }

        var drawnHeight = this.getVisibleHeight(),
            drawnWidth = this.getVisibleWidth(),

            vertical = effectConfig ? effectConfig.endsAt == this._$T ||
                                      effectConfig.endAt == this._$T : true,

            info = {_userHeight:this._userHeight, _specifiedHeight:this.getHeight(),
                    _drawnHeight:drawnHeight,
                    _userWidth:this._userWidth, _specifiedWidth:this.getWidth(),
                    _drawnWidth:drawnWidth,
                    _scrollStart:(vertical ? this.getScrollTop() : this.getScrollLeft()),
                    _vertical:vertical,
                    _slideOut:effect == "slide",
                    _originalOverflow:this.overflow,
                    _callback:this._animateHideCompleteCallback,
                    _synchronousCallback:synchronousCallback
            };

        if (info._slideOut) {
            // remember the length-scrollbar thumb position at the beginning of the animation
            // and size
            if (vertical && this.vscrollOn && this.vscrollbar) {
                info._scrollThumbStart = this.vscrollbar.thumb.getTop();
                info._scrollThumbLength = this.vscrollbar.thumb.getHeight();
            } else if (!vertical && this.hscrollOn && this.hscrollbar) {
                info._scrollThumbStart = this.hscrollbar.thumb.getLeft();
                info._scrollThumbLength = this.hscrollbar.thumb.getWidth();
            }
        }

        // If overflow is visible, set to hidden so the content will clip as we shrink

        this.resizeTo(drawnWidth, drawnHeight, true);

        if (this.overflow == isc.Canvas.VISIBLE) {
            this.setOverflowForAnimation(isc.Canvas.HIDDEN, this.overflow);
        }
        // suppress adjustOverflow during the animation if we have scrollbars
        if (this.overflow == isc.Canvas.AUTO || this.overflow == isc.Canvas.SCROLL) {
            this._suppressAdjustOverflow = true;

            if (this.vscrollOn && this.vscrollbar) {
                // allow the master to be hidden without hiding either scrollbar
                this.vscrollbar._showWithMaster = false;
                // avoid setThumb if this is the length scrollbar
                if (vertical) this.vscrollbar._suppressSetThumb = true;
                // avoid image resize so we can clip properly
                this.vscrollbar._suppressImageResize = true;

                if (this.vscrollbar.thumb) {
                    this.vscrollbar.thumb._suppressImageResize = true;
                }
            }
            if (this.hscrollOn && this.hscrollbar) {
                // allow the master to be hidden without hiding either scrollbar
                this.hscrollbar._showWithMaster = false;
                // avoid setThumb if this is the length scrollbar
                if (!vertical) this.hscrollbar._suppressSetThumb = true;
                // avoid image resize so we can clip properly
                this.hscrollbar._suppressImageResize = true;

                if (this.hscrollbar.thumb) {
                    this.hscrollbar.thumb._suppressImageResize = true;
                }
            }
        }

        if (this.showEdges) {
            this._edgedCanvas.setOverflow("hidden");
            this._edgedCanvas._suppressReactToResize = true;
            this._assignSize(this._edgedCanvas.getHandle().firstChild.style,
                             (vertical ? "height" : "width"),
                             (vertical ? this._edgedCanvas.getHeight() : this._edgedCanvas.getWidth()));
        }
        return this._startAnimation(this._$hide, info, duration, acceleration);
    },

    // fireAnimationHide() - called repeatedly during an animated show() / hide() if the
    // animate effect is "slide" or "wipe" rather than "fade".
    fireAnimationHide : function (ratio, ID, earlyFinish) {
        var info = this.$hideAnimationInfo,
            vertical = info._vertical;


        if (ratio < 1) {

            var drawnSize = (vertical ? info._drawnHeight : info._drawnWidth),
                size = this._getRatioTargetValue(drawnSize, 1, ratio),
                delta = drawnSize - size,
                adjustForEdge = (this.showEdges && this._edgedCanvas),
                // Note that if we're sliding in we hide the top edge first, whereas if
                // we're wiping, we hide the bottom edge first
                startEdgeSize, endEdgeSize,

                // if we're showing scrollbars, (for a vertical wipe/slide)
                // - HScrollbar will get clipped, then hidden as the hide proceeds
                // - VScrollbar will get clipped/resized as the hide proceeds
                // Both need to be reset on completion (can probably just use adjustOverflow?)
                hasHScrollbar = this.hscrollOn && this.hscrollbar,
                hasVScrollbar = this.vscrollOn && this.vscrollbar;

            // custom logic for showing edged canvii
            if (adjustForEdge) {

                startEdgeSize = (info._slideOut ? (vertical ? this._edgedCanvas._topMargin
                                                            : this._edgedCanvas._leftMargin)
                                               : (vertical ? this._edgedCanvas._bottomMargin
                                                           : this._edgedCanvas._rightMargin));
                endEdgeSize = (info._slideOut ? (vertical ? this._edgedCanvas._bottomMargin
                                                          : this._edgedCanvas._rightMargin)
                                               : (vertical ? this._edgedCanvas._topMargin
                                                           : this._edgedCanvas._leftMargin));

                this._edgedCanvas.resizeTo((vertical ? null : size), (vertical ? size : null), true);
                if (info._slideOut) {
                    if (vertical) this._edgedCanvas.scrollToBottom();
                    else this._edgedCanvas.scrollToRight();
                }

                // For the first few px of the animation were either clipping the bottom edge,
                // or sliding the top edge out of sight, and leaving the handle visible.
                if (delta < startEdgeSize) {
                    // slide case: shrink the top margin of the handle to shift it up with the
                    // top edge
                    if (info._slideOut) {
                        var marginProp = (vertical ? "marginTop" : "marginLeft"),
                            marginSize = (vertical ? this.getTopMargin() : this.getLeftMargin())
                        this._assignSize(this.getStyleHandle(), marginProp, (marginSize- delta));
                    }
                    // Bail - we don't want to resize the handle at all.
                    // fire resized notification anyway - allows layouts to respond to the new size
                    this._resized();
                    return;
                }

                // If we're sliding out of view, ensure the top of the handle is exactly level
                // with the top of the edged canvas.
                if (info._slideOut && !this._adjustedForEdge) {
                    var marginProp = (vertical ? "marginTop" : "marginLeft"),
                        marginSize = (vertical ? this.getTopMargin() : this.getLeftMargin())

                    this._assignSize(this.getStyleHandle(), marginProp, (marginSize - startEdgeSize));
                    this._adjustedForEdge = true;
                }

                // actually hide the canvas handle (without firing any handlers) if the total
                // size is less than the height of the edge at this point.
                if (adjustForEdge && size <= endEdgeSize) {
                    // set the flag so we don't trip the 'finishAnimation()' from hide()
                    this._hidingAsAnimation = true;
                    this.getStyleHandle().visibility = isc.Canvas.HIDDEN;
                    delete this._hidingAsAnimation;
                }
            }

            // resize the vertical scrollbar with us as we shrink
            var lengthScrollbar = vertical ? (hasVScrollbar ? this.vscrollbar : null)
                                           : (hasHScrollbar ? this.hscrollbar : null);
            if (lengthScrollbar) {
                if (vertical) lengthScrollbar.setHeight(size);
                else {
                    // If we're showing a v-scrollbar it appears to the right of the hscrollbar
                    // On a wipe, just wait till the vscrollbar is completely hidden before
                    // resizing
                    // On a slide, take the v-scrollbar width into account when resizing
                    var sbsize = size;
                    if (this.vscrollOn) {
                        if (info._slideOut) {
                            sbsize -= this.scrollbarSize;
                        } else {
                            sbsize = Math.min(size, drawnSize - this.scrollbarSize);
                        }
                    }
                    if (sbsize > 0) lengthScrollbar.setWidth(sbsize);
                    else lengthScrollbar.hide();
                }

                if (info._slideOut) {
                    if (vertical) lengthScrollbar.scrollToBottom();
                    else lengthScrollbar.scrollToRight();
                }

                if (lengthScrollbar.thumb && lengthScrollbar.thumb.isVisible()) {

                    // On a "slideOut" we need to move the thumb then shrink it off the top
                    if (info._slideOut) {
                        var thumbStart = info._scrollThumbStart - delta,
                            start = vertical ? this.getTop() : this.getLeft();
                        if (thumbStart >= start) {
                            lengthScrollbar.thumb.moveTo(vertical ? null : thumbStart,
                                                         vertical ? thumbStart : null);
                        } else {
                            lengthScrollbar.thumb.moveTo(vertical ? null : this.getLeft(),
                                                         vertical ? this.getTop() : null);
                            var thumbLength = info._scrollThumbLength + (thumbStart - start);
                            if (thumbLength > 0) {
                                lengthScrollbar.thumb.resizeTo(vertical ? null : thumbLength,
                                                               vertical ? thumbLength : null);
                                lengthScrollbar.thumb.scrollTo(vertical ? null : start - thumbStart,
                                                               vertical ? start - thumbStart : null);
                            } else {
                                lengthScrollbar.thumb.hide();
                            }
                        }
                    // on a wipe animation, we simply resize the thumb so it appears to clip out
                    // of view
                    } else {

                        if (vertical) {
                            var bottom = (this.getTop() + size)
                            if (lengthScrollbar.thumb.getBottom() > bottom) {
                                var thumbHeight = bottom - lengthScrollbar.thumb.getTop();
                                if (thumbHeight > 0) lengthScrollbar.thumb.setHeight(thumbHeight);
                                else lengthScrollbar.thumb.hide();
                            }
                        } else {
                            var right = (this.getLeft() + size)
                            if (lengthScrollbar.thumb.getRight() > right) {
                                var thumbWidth = right - lengthScrollbar.thumb.getLeft();
                                if (thumbWidth> 0) lengthScrollbar.thumb.setWidth(thumbWidth);
                                else lengthScrollbar.thumb.hide();
                            }
                        }
                    }
                }

            }


            // "breadth" scrollbar -- scrollbar which will be clipped across its breadth as
            // it shrinks
            var breadthScrollbar = vertical ? (hasHScrollbar ? this.hscrollbar : null)
                                                 : (hasVScrollbar ? this.vscrollbar : null),
                 // If we're showing a breadth scrollbar, the widget handle renders at the the
                 // specified size less the scrollbarsize
                 // If the scrollbar is (partially or fully) hidden we therefore need to increase
                 // our specified size by the difference between the rendered scrollbarSize and
                 // this.scrollbarSize to ensure the handle draws large enough
                 hiddenScrollbarDelta = 0;

            if (breadthScrollbar) {

                var sbSize = this.scrollbarSize;
                // if we're sliding out, it will hide at the end (just move first)
                // Otherwise it'll hide first
                if (info._slideOut) {
                    if (size >= sbSize) {
                        var offset = (vertical ? this.getTop() : this.getLeft()) + size - sbSize;
                        breadthScrollbar.moveTo(vertical ? null : offset, vertical ? offset: null);
                    } else {
                        breadthScrollbar.moveTo(vertical ? null : this.getLeft(),
                                                vertical ? this.getTop() : null);
                        breadthScrollbar.resizeTo(vertical ? null : size, vertical ? size : null);
                        if (vertical) breadthScrollbar.scrollToBottom();
                        else breadthScrollbar.scrollToRight();
                        var thumb = breadthScrollbar.thumb

                        if (thumb) {
                            thumb.resizeTo(vertical ? null : size, vertical ? size : null);
                            if (vertical) thumb.scrollToBottom();
                            else thumb.scrollToRight();
                        }
                    }

                    // hide the handle (leaving just the breadth sb, and bottom of the length sb
                    // visible) if necessary
                    if (size <= sbSize) {
                        this._hidingAsAnimation = true;
                        if (this.isVisible()) this.hide();
                        delete this._hidingAsAnimation;
                        return;
                    }
                } else {
                    if (delta <= sbSize) {
                        breadthScrollbar.resizeTo(vertical ? null : sbSize-delta,
                                                  vertical ? sbSize-delta : null);
                        if (breadthScrollbar.thumb) {
                            breadthScrollbar.thumb.resizeTo(vertical ? null : sbSize-delta,
                                                            vertical ? sbSize-delta: null);
                        }
                    } else {
                        if (breadthScrollbar.isVisible()) breadthScrollbar.hide();
                    }
                }

                if (breadthScrollbar.isVisible()) {
                    hiddenScrollbarDelta = this.scrollbarSize -
                                            (vertical ? breadthScrollbar.getHeight()
                                                      : breadthScrollbar.getWidth());
                } else {
                    hiddenScrollbarDelta = this.scrollbarSize;
                }
            }

            // resize the handle (actually shrink it)
            // If we're showing an edge, resize add the size of the top (or bottom) edge onto
            // the height so we don't erroneously size leave space for the edge which has
            // already been clipped out of view
            var handleSize = size;
            if (adjustForEdge) handleSize += startEdgeSize;

            if (hiddenScrollbarDelta) handleSize += hiddenScrollbarDelta;

            // resize the handle
            if (!this.resizeTo((vertical ? null : handleSize),
                                (vertical ? handleSize : null), true))
            {
                // if resize() didn't change the specified size, explicitly fire _resized so
                // we react to scrollbar size changes et
                this._resized();
            }

            var scrollAdjustment;
            if (info._slideOut) {
                this.scrollTo((vertical ? null : info._scrollStart + delta),
                              (vertical ? info._scrollStart + delta : null), null, true);
            }

        // Ratio == 1
        } else {
            this._clearAnimationInfo("hide");

            if (this.isVisible()) this.hide();

            if (info._originalOverflow) this.setOverflowForAnimation(info._originalOverflow);
            if (this.showEdges && this._edgedCanvas) {
                delete this._adjustedForEdge;
                // allow the edged canvas to show up again
                this._edgedCanvas.setOverflow(isc.Canvas.VISIBLE);
                delete this._edgedCanvas._suppressReactToResize;
                if (vertical) this._edgedCanvas.getHandle().firstChild.style.height = "100%";
                else this._edgedCanvas.getHandle().firstChild.style.width  = "100%"
                // reset the margins to float the handle inside the edges.
                if (info._slideOut) {
                    var margins = this._calculateMargins(),
                        marginProp = (vertical ? "marginTop" : "marginLeft"),
                        marginSize = (vertical ? margins.top : margins.left)
                    this._assignSize(this.getStyleHandle(), marginProp, marginSize);
                }
            }
            if (this.overflow == isc.Canvas.AUTO || this.overflow == isc.Canvas.SCROLL) {

                delete this._suppressAdjustOverflow;
                if (vertical) {
                    if (this.vscrollOn && this.vscrollbar) {
                        if (this.vscrollbar.isVisible()) this.vscrollbar.hide();

                        delete this.vscrollbar._suppressSetThumb;
                        delete this.vscrollbar._suppressImageResize;
                        this.vscrollbar._showWithMaster = true;

                        if (this.vscrollbar.thumb) {
                            delete this.vscrollbar.thumb.suppressImageResize;
                        }
                        if (info._slideOut) {
                            this.vscrollbar.scrollTo(0,0);
                            this.vscrollbar.setHeight(this.getHeight());
                            if (this.vscrollbar.thumb) this.vscrollbar.thumb.scrollTo(0,0);
                        }
                    }
                    // catch the case where we slid the body out of view, leaving just the
                    // breadth scrollbar visible
                    if (this.hscrollOn && this.hscrollbar) {
                        if (this.hscrollbar.isVisible()) this.hscrollbar.hide();
                        this.hscrollbar._showWithMaster = true;
                        delete this.hscrollbar._suppressImageResize;
                        if (info._slideOut) this.hscrollbar.scrollTo(0,0);
                        if (this.hscrollbar.thumb) {
                            delete this.hscrollbar.thumb._suppressImageResize;
                            if (info._slideOut) this.hscrollbar.thumb.scrollTo(0,0);
                        }
                    }
                } else {
                    if (this.hscrollOn && this.hscrollbar) {
                        if (this.hscrollbar.isVisible()) this.hscrollbar.hide();
                        delete this.hscrollbar._suppressSetThumb;
                        delete this.hscrollbar._suppressImageResize;
                        this.hscrollbar._showWithMaster = true;
                        if (this.hscrollbar.thumb)
                            delete this.hscrollbar._suppressImageResize;
                        if (info._slideOut) {
                            this.hscrollbar.scrollTo(0,0);
                            this.hscrollbar.setWidth(this.getWidth());
                            if (this.hscrollbar.thumb) this.hscrollbar.thumb.scrollTo(0,0);
                        }
                    }
                    if (this.vscrollOn && this.vscrollbar) {
                        if (this.vscrollbar.isVisible()) this.vscrollbar.hide();
                        this.vscrollbar._showWithMaster = true;
                        delete this.vscrollbar._suppressImageResize;
                        if (info._slideOut) this.vscrollbar.scrollTo(0,0);
                        if (this.vscrollbar.thumb) {
                            if (info._slideOut) this.vscrollbar.thumb.scrollTo(0,0);
                            delete this.vscrollbar._suppressImageResize;
                        }
                    }
                }

                // no need to reset the size /position of the scrollbars -
                // this will happen automatically  when adjustOverflow runs
            }


            // reset the size (will also resize the edge if necessary)
            this.resizeTo(info._specifiedWidth, info._specifiedHeight);
            this.updateUserSize(info._userWidth,  this._$width);
            this.updateUserSize(info._userHeight, this._$height);

            if (info._slideOut) this.scrollTo((vertical ? null : info._scrollStart),
                                              (vertical ? info._scrollStart : null));
            if (info._callback) {
                this._fireAnimationCompletionCallback(info._callback, earlyFinish, true);
            }
        }
    },

    // animateHide always falls through to this callback regardless of the effect used
    _animateHideComplete : function (earlyFinish) {
        delete this._animatingHide;
        var callback = this._animateHideCallback;
        delete this._animateHideCallback;

        // Fade / fly animations don't actually hide the widget, so call hide() now if we're
        // still visible
        // Note that this IS handled during wipe / slide hide animations by fireAnimationHide()
        // with ratio 1.
        if (this.isVisible()) this.hide();

        // reset anything we altered during the hide
        if (this._performingFadeHide) {
            this.setOpacity(this._fadeHideOpacity);
            delete this._fadeHideOpacity;
            delete this._performingFadeHide;
        }
        if (this._flyHideLeft != null) {
            this.setLeft(this._flyHideLeft);
            delete this._flyHideLeft;
        }
        if (this._flyHidePercentLeft != null) {
            this._percent_left = this._flyHidePercentLeft;
            delete this._flyHidePercentLeft;
        }

        // Always fire the callback passed in synchronously - this is itself a callback so
        // will have already been delayed if synchronousCallback was not set on the animation
        // config object
        if (callback) {
            this._fireAnimationCompletionCallback(callback, earlyFinish, true);
        }
    },


    //> @method canvas.isAnimating()
    // Is this widget currently performing an animation?
    // @param [types] (Array) Animation types to check for - if unspecified all animation types
    //   will be checked.
    // @visibility internal
    //<

    isAnimating : function (types) {
        if (types == null) return this._runningAnimations > 0;

        if (types && !isc.isAn.Array(types)) {
            // reuse an array for efficiency
            if (!this._animatingTypesArray) this._animatingTypesArray = [];
            this._animatingTypesArray[0] = types;
            types = this._animatingTypesArray;
        }

        if (!types) types = this._animations;
        for (var i = 0; i < types.length; i++) {
            if (this[this._getAnimationID(types[i])] != null) {
//                this.logWarn("ID:" + this._getAnimationID(types[i]) +
//                    "set to:"  + this[this._getAnimationID(types[i])]);
                return true;
            }
        }
        return false;
    }

});








//>    @class    StatefulCanvas
// A component that has a set of possible states, and which presents itself differently according to
// which state it is in.  An example is a button, which can be "up", "down", "over" or "disabled".
//
// @inheritsFrom Canvas
// @treeLocation Client Reference/Foundation
// @visibility external
//<
isc.ClassFactory.defineClass("StatefulCanvas", "Canvas");

    //>    @groupDef    state
    // Change of state and it's consequences for presentation.
    //<
isc.StatefulCanvas.addClassProperties({

    //> @type   State
    // Constants for the standard states for a StatefulCanvas.
    // @value  isc.StatefulCanvas.STATE_UP         state when mouse is not acting on this StatefulCanvas
    // @value  isc.StatefulCanvas.STATE_DOWN       state when mouse is down
    // @value  isc.StatefulCanvas.STATE_OVER       state when mouse is over
    // @value  isc.StatefulCanvas.STATE_DISABLED   disabled
    // @group  state
    // @visibility external
    //<

    //> @classAttr StatefulCanvas.STATE_UP (Constant : "" : [R])
    // A declared value of the enum type
    // +link{type:State,State}.
    // @visibility external
    // @constant
    //<
    STATE_UP:"",

    //> @classAttr StatefulCanvas.STATE_DOWN (Constant : "Down" : [R])
    // A declared value of the enum type
    // +link{type:State,State}.
    // @visibility external
    // @constant
    //<
    STATE_DOWN:"Down",

    //> @classAttr StatefulCanvas.STATE_OVER (Constant : "Over" : [R])
    // A declared value of the enum type
    // +link{type:State,State}.
    // @visibility external
    // @constant
    //<
    STATE_OVER:"Over",

    //> @classAttr StatefulCanvas.STATE_DISABLED (Constant : "Disabled" : [R])
    // A declared value of the enum type
    // +link{type:State,State}.
    // @visibility external
    // @constant
    //<
    STATE_DISABLED:"Disabled",

    //> @type  SelectionType
    // Controls how an object changes state when clicked
    // @group  state
    // @group  event handling
    // @value  isc.StatefulCanvas.BUTTON   object moves to "down" state temporarily (normal button)
    // @value  isc.StatefulCanvas.CHECKBOX object remains in "down" state until clicked again (checkbox)
    // @value  isc.StatefulCanvas.RADIO    object moves to "down" state, causing another object to go up (radio)
    // @visibility external
    //<

    //> @classAttr StatefulCanvas.BUTTON (Constant : "button" : [R])
    // A declared value of the enum type
    // +link{type:SelectionType,SelectionType}.
    // @visibility external
    // @constant
    //<
    BUTTON:"button",

    //> @classAttr StatefulCanvas.CHECKBOX (Constant : "checkbox" : [R])
    // A declared value of the enum type
    // +link{type:SelectionType,SelectionType}.
    // @visibility external
    // @constant
    //<
    CHECKBOX:"checkbox",

    //> @classAttr StatefulCanvas.RADIO (Constant : "radio" : [R])
    // A declared value of the enum type
    // +link{type:SelectionType,SelectionType}.
    // @visibility external
    // @constant
    //<
    RADIO:"radio",

    //> @type   Selected
    // @value  isc.StatefulCanvas.FOCUSED  StatefulCanvas should show
    //                                     focused state
    // @value  isc.StatefulCanvas.SELECTED     StatefulCanvas is selected
    // @value  isc.StatefulCanvas.UNSELECTED   StatefulCanvas is not selected
    // @visibility external
    // @group  state
    //<

    //> @classAttr StatefulCanvas.FOCUSED (Constant : "Focused" : [R])
    // A declared value of the enum type
    // +link{type:Selected,Selected}.
    // @visibility external
    // @constant
    //<
    FOCUSED:"Focused",

    //> @classAttr StatefulCanvas.SELECTED (Constant : "Selected" : [R])
    // A declared value of the enum type
    // +link{type:Selected,Selected}.
    // @visibility external
    // @constant
    //<
    SELECTED:"Selected",

    //> @classAttr StatefulCanvas.UNSELECTED (Constant : "" : [R])
    // A declared value of the enum type
    // +link{type:Selected,Selected}.
    // @visibility external
    // @constant
    //<
    UNSELECTED:"",

    // Internal map of radioGroup ID's to arrays of widgets
    _radioGroups:{},

    _mirroredAlign: {
        "left": "right",
        "center": "center",
        "right": "left"
    },

    // ------------------------
    // Properties for manipulating CSS border

    _borderStyleCache: {},
    _borderCSSHTMLCache: {},

    _borderProperties : [
        "borderBottomLeftRadius",
        "borderBottomRightRadius",
        "borderTopRightRadius",
        "borderTopLeftRadius",
        "borderBottomColor",
        "borderBottomStyle",
        "borderBottomWidth",
        "borderLeftColor",
        "borderLeftStyle",
        "borderLeftWidth",
        "borderRightColor",
        "borderRightStyle",
        "borderRightWidth",
        "borderTopColor",
        "borderTopStyle",
        "borderTopWidth"
    ],
    _nRadiusBorderProperties: 4,

    _$separator: " ",

    //> @classAttr statefulCanvas.pushTableBorderStyleToDiv (boolean : ? : IR)
    // Causes border properties to be written onto containing DIV rather than
    // be applied to the internal Table TDs for Button widgets
    //<

    pushTableBorderStyleToDiv: false,

    _shadowStyleCache: {},
    _shadowStyleCSSHTMLCache: {},

    pushTableShadowStyleToDiv: null

});


isc.StatefulCanvas.addProperties({

    //> @attr statefulCanvas.title (HTMLString : null : IRW)
    // The title HTML to display in this button.
    // @group basics
    // @visibility external
    //<

    //>@attr StatefulCanvas.hiliteAccessKey (boolean : null : [IRWA])
    // If set to true, if the +link{statefulCanvas.title, title} of this button contains the
    // specified +link{canvas.accessKey, accessKey}, when the title is displayed to the user
    // it will be modified to include HTML to underline the accessKey.<br>
    // Note that this property may cause titles that include HTML (rather than simple strings)
    // to be inappropriately modified, so should be disabled if your title string includes
    // HTML characters.
    // @visibility internal
    //<

    //> @attr statefulCanvas.ignoreRTL (boolean : false : IRWA)
    // Should horizontal alignment-related attributes +link{align,align} and +link{iconOrientation,iconOrientation}
    // be mirrored in RTL mode? This is the default behavior unless ignoreRTL is set to true.
    // @setter setIgnoreRTL()
    // @group RTL
    // @visibility external
    //<
    // iconAlign is also mirrored.
    ignoreRTL: false,

    // State-related properties
    // -----------------------------------------------------------------------------------------------

    //>    @attr    statefulCanvas.redrawOnStateChange        (Boolean : false : IRWA)
    // Whether this widget needs to redraw to reflect state change
    // @group    state
    // @visibility external
    //<

    //>    @attr    statefulCanvas.selected        (Boolean : false : IRW)
    // Whether this component is selected.  For some components, selection affects appearance.
    // @group    state
    // @visibility external
    //<

    //>    @attr    statefulCanvas.state        (State : "" : IRWA)
    // Current "state" of this widget. The state setting is automatically updated as the
    // user interacts with the component (see +link{statefulCanvas.showRollOver},
    // +link{statefulCanvas.showDown}, +link{statefulCanvas.showDisabled}).
    // <P>
    // StatefulCanvases will have a different appearance based
    // on their current state.
    // By default this is handled by changing the css className applied to
    // the StatefulCanvas - see +link{StatefulCanvas.baseStyle} and
    // +link{StatefulCanvas.getStateSuffix()} for a description of how this is done.
    // <P>
    // For +link{class:Img} or +link{class:StretchImg} based subclasses of StatefulCanvas, the
    // appearance may also be updated by changing the src of the rendered image. See
    // +link{Img.src} and +link{StretchImgButton.src} for a description of how the URL
    // is modified to reflect the state of the widget in this case.
    //
    // @see type:State
    // @see group:state
    // @group    state
    // @visibility external
    //<

    state:"",

    //>    @attr    statefulCanvas.showRollOver        (Boolean : false : IRW)
    // Should we visibly change state when the mouse goes over this object?
    // @group    state
    // @visibility external
    //<


    //>    @attr    statefulCanvas.showFocus        (Boolean : false : IRW)
    // Should we visibly change state when the canvas receives focus?  Note that by default the
    // <code>over</code> state is used to indicate focus.
    // @group    state
    // @deprecated as of SmartClient version 6.1 in favor of +link{statefulCanvas.showFocused}
    // @visibility external
    //<

    //>    @attr    statefulCanvas.showFocused        (Boolean : false : IRW)
    // Should we visibly change state when the canvas receives focus?  If
    // +link{statefulCanvas.showFocusedAsOver} is <code>true</code>, then <b><code>"over"</code></b>
    // will be used to indicate focus. Otherwise a separate <b><code>"focused"</code></b> state
    // will be used.
    // @group    state
    // @visibility external
    //<

    //> @attr statefulCanvas.showFocusedAsOver (Boolean : true : IRW)
    // If +link{StatefulCanvas.showFocused,showFocused} is true for this widget, should the
    // <code>"over"</code> state be used to indicate the widget as focused. If set to false,
    // a separate <code>"focused"</code> state will be used.
    // @group state
    // @visibility external
    //<
    showFocusedAsOver: true,



    //>    @attr    statefulCanvas.showDown        (Boolean : false : IRW)
    // Should we visibly change state when the mouse goes down in this object?
    //        @group    state
    // @visibility external
    //<

    //>    @attr    statefulCanvas.showDisabled  (Boolean : true : IRW)
    // Should we visibly change state when disabled?
    //        @group    state
    // @visibility external
    //<
    showDisabled:true,

    //>    @attr    statefulCanvas.actionType        (SelectionType : "button": IRW)
    // Behavior on state changes -- BUTTON, RADIO or CHECKBOX
    // @group state
    // @group event handling
    // @setter setActionType()
    // @getter getActionType()
    // @visibility external
    //<
    actionType:"button",

    //> @attr statefulCanvas.radioGroup (String : null : IRWA)
    // String identifier for this canvas's mutually exclusive selection group.
    // @group state
    // @group event handling
    // @visibility external
    //<
    //> @method setRadioGroup()
    // Sets the +link{statefulCanvas.radioGroup, radioGroup} identifier for this canvas's
    // mutually exclusive selection group.
    // @group state
    // @group event handling
    // @visibility external
    //<
    setRadioGroup : function (radioGroup) {
        this.removeFromRadioGroup();
        this.addToRadioGroup(radioGroup);
    },

    //> @attr statefulCanvas.styleName (CSSStyleName : "normal" : IRW)
    // StatefulCanvases are styled by combining +link{baseStyle} with +link{state} to build
    // a composite css style name. In most cases, <code>statefulCanvas.styleName</code>
    // will have no effect on statefulCanvas styling and should not be used.
    // <P>
    // If the <code>baseStyle</code> is not explicitly specified for a class, the
    // <code>styleName</code> will be used as a default baseStyle. Other than that, this
    // attribute will be ignored.
    //
    // @visibility external
    //<

    //>    @attr    statefulCanvas.baseStyle        (CSSStyleName : null : IRW)
    // Base CSS style className applied to the component.
    // <P>
    // Note that if specified, this property takes precedence over any specified
    // +link{statefulCanvas.styleName}. If unset, the <code>styleName</code> will be used as a
    // default <code>baseStyle</code> value.
    // <P>
    // As the component changes +link{statefulCanvas.state} and/or is selected,
    // suffixes will be added to the base style. In some cases more than one suffix will
    // be appended to reflect a combined state ("Selected" + "Disabled", for example).
    // <P>
    // See +link{statefulCanvas.getStateSuffix()} for a description of the default set
    // of suffixes which may be applied to the baseStyle
    // <P>
    // <h4>Rotated Titles</h4>
    // <p>
    // The Framework doesn't have built-in support for rotating button titles in a fashion
    // similar to +link{FacetChart.rotateLabels}.  However, you can manually configure
    // a button to render with a rotated title by applying custom CSS via this property.
    // <P>
    // For example, given a button with a height of 120 and a width of 48, if you
    // copied the existing buttonXXX style declarations from skin_styles.css as new,
    // rotatedTitleButtonXXX declarations, and then added the lines:
    // <pre>
    //     -ms-transform:     translate(-38px,0px) rotate(270deg);
    //     -webkit-transform: translate(-38px,0px) rotate(270deg);
    //     transform:         translate(-38px,0px) rotate(270deg);
    //     overflow: hidden;
    //     text-overflow: ellipsis;
    //     width:116px;</pre>
    // in the declaration section beginning:
    // <pre>
    // .rotatedTitleButton,
    // .rotatedTitleButtonSelected,
    // .rotatedTitleButtonSelectedOver,
    // .rotatedTitleButtonSelectedDown,
    // .rotatedTitleButtonSelectedDisabled,
    // .rotatedTitleButtonOver,
    // .rotatedTitleButtonDown,
    // .rotatedTitleButtonDisabled {</pre>
    // then applying that style to the button with +link{canvas.overflow,overflow}: "clip_h"
    // would yield a vertically-rendered title with overflow via ellipsis as expected, and also
    // wrap with +link{button.wrap}.
    //
    // Note that:<ul>
    // <li> The explicit width applied via CSS is needed because rotated
    // elements don't inherit dimensions in their new orientation from the DOM -
    // the transform/rotation occurs independently of layout.
    // <li> The translation transform required along the x-axis is roughly
    // (width - height) / 2, but may need slight offsetting for optimal centering.
    // <li>We've explicitly avoided describing an approach based on CSS "writing-mode", since
    // support is incomplete and bugs are present in popular browsers such as Firefox and
    // Safari that would prevent it from being used without Framework assistance.</ul>
    // <P>
    // Note on css-margins: Developers should be aware that the css "margin" property is unreliable for
    // certain subclasses of StatefulCanvas, including +link{Button,buttons}. Developers may use
    // the explicit +link{canvas.margin} property to specify button margins, or for a
    // button within a layout, consider the layout properties +link{layout.layoutMargin},
    // +link{layout.membersMargin}
    //
    // @visibility external
    //<

    //>    @attr    statefulCanvas.cursor        (Cursor : Canvas.ARROW : IRW)
    //            Specifies the cursor to show when over this canvas.
    //            See Cursor type for different cursors.
    //        @group    cues
    //        @platformNotes    Nav4    Cursor changes are not available in Nav4
    //<
    cursor:isc.Canvas.ARROW,

    //> @attr statefulCanvas.iconCursor (Cursor : null : IR)
    // Specifies the cursor to display when the mouse pointer is over the icon image.
    //
    // @group cues
    // @see attr:disabledIconCursor
    //<
    //iconCursor: null,

    //> @attr statefulCanvas.disabledIconCursor (Cursor : null : IR)
    // Specifies the cursor to display when the mouse pointer is over the icon image and this
    // <code>StatefulCanvas</code> is +link{Canvas.disabled,disabled}.
    // <p>
    // If not set and the mouse pointer is over the icon image, +link{iconCursor,iconCursor}
    // will be used.
    //
    // @group cues
    //<
    //disabledIconCursor: null,

    // Image-based subclasses
    // ---------------------------------------------------------------------------------------
    capSize:0,

    //> @attr statefulCanvas.showTitle (boolean : false : [IRWA])
    // Determines whether any specified +link{statefulCanvas.getTitle(), title} will be
    // displayed for this component.<br>
    // Applies to Image-based components only, where the title will be rendered out in a label
    // floating over the component
    // @visibility internal
    //<
    // Really governs whether a label canvas is created to contain the title.
    // Exposed on img based subclasses only as some statefulCanvas subclasses will support
    // displaying the title without a label canvas
    //showTitle:false,

    //>    @attr    statefulCanvas.align        (Alignment : isc.Canvas.CENTER : [IRW])
    // Horizontal alignment of this component's title.
    // @group appearance
    // @visibility external
    //<
    align:isc.Canvas.CENTER,

    //>    @attr    statefulCanvas.valign        (VerticalAlignment : isc.Canvas.CENTER : [IRW])
    // Vertical alignment of this component's title.
    // @group appearance
    // @visibility external
    //<
    valign:isc.Canvas.CENTER,

    //> @attr StatefulCanvas.autoFit  (boolean : null : IRW)
    // If true, ignore the specified size of this widget and always size just large
    // enough to accommodate the title.  If <code>setWidth()</code> is explicitly called on an
    // autoFit:true button, autoFit will be reset to <code>false</code>.
    // <P>
    // Note that for StretchImgButton instances, autoFit will occur horizontally only, as
    // unpredictable vertical sizing is likely to distort the media. If you do want vertical
    // auto-fit, this can be achieved by simply setting a small height, and having
    // overflow:"visible"
    // @setter setAutoFit()
    // @group sizing
    // @visibility external
    //<
    //autoFit:null

    //> @attr StatefulCanvas.width (Number | String : null : [IRW])
    // Size for this component's horizontal dimension.  See +link{Canvas.width} for more
    // details.
    // <P>
    // Note that if +link{StatefulCanvas.autoFit} is set, this property will be ignored so that the widget
    // is always sized just large enough to accommodate the title.
    // @see StatefulCanvas.autoFit
    // @group sizing
    // @visibility external
    //<

    //> @attr StatefulCanvas.height (Number | String : null : [IRW])
    // Size for this component's vertical dimension.  See +link{Canvas.height} for more
    // details.
    // <P>
    // Note that if +link{StatefulCanvas.autoFit} is set on non-+link{StretchImgButton} instances, this
    // property will be ignored so that the widget is always sized just large enough to
    // accommodate the title.
    // @see StatefulCanvas.autoFit
    // @group sizing
    // @visibility external
    //<

    // autoFitDirection: Undocumented property determining whether we should auto-fit
    // horizontally, vertically or in both directions
    // Options are "both", "horizontal", "vertical"
    autoFitDirection:isc.Canvas.BOTH,

    //
    // Button properties - managed here and @included from Button, ImgButton and
    // StatefulImgButton
    // =================================================================================

    // Icon (optional)
    // ---------------

    //> @attr statefulCanvas.icon           (SCImgURL : null : [IRW])
    // Optional icon to be shown with the button title text.
    // <P>
    // Specify as the partial URL to an image, relative to the imgDir of this component.
    // A sprited image can be specified using the +link{type:SCSpriteConfig} format.
    // <P>
    // Note that the string "blank" is a valid setting for this attribute and will always
    // result in the system blank image, with no state suffixes applied.  Typically, this
    // might be used when an iconStyle is also specified and the iconStyle renders the icon via
    // a stateful background-image or other CSS approach.
    //
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.iconSize (int : 16 : IR)
    // Size in pixels of the icon image.
    // <P>
    // The +link{StatefulCanvas.iconWidth,iconWidth} and +link{StatefulCanvas.iconHeight,iconHeight}
    // properties can be used to configure width and height separately.
    // <P>
    // Note: When configuring the properties of a <code>StatefulCanvas</code> (or derivative)
    // +link{AutoChild,AutoChild}, it is best to set the <code>iconWidth</code> and <code>iconHeight</code>
    // to the same value rather than setting an <code>iconSize</code>. This is because certain
    // skins or customizations thereto might set the <code>iconWidth</code> and <code>iconHeight</code>,
    // making the customization of the AutoChild's <code>iconSize</code> ineffective.
    //
    // @group buttonIcon
    // @visibility external
    //<
    iconSize:16,

    //> @attr statefulCanvas.iconWidth (Integer : null : IR)
    // Width in pixels of the icon image.
    // <P>
    // If unset, defaults to +link{StatefulCanvas.iconSize,iconSize}.
    //
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.iconHeight (Integer : null : IR)
    // Height in pixels of the icon image.
    // <P>
    // If unset, defaults to +link{StatefulCanvas.iconSize,iconSize}.
    //
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.iconStyle (CSSStyleName : null : IRW)
    // Base CSS style applied to the icon image. If set, as the <code>StatefulCanvas</code> changes
    // +link{StatefulCanvas.state,state} and/or is +link{StatefulCanvas.selected,selected},
    // suffixes will be appended to <code>iconStyle</code> to form the className set on the
    // image element.
    // <p>
    // The following table lists out the standard set of suffixes which may be appended:
    // <table border=1>
    // <tr><th>CSS Class Applied</th><th>Description</th></tr>
    // <tr><td><code><i>iconStyle</i></code></td><td>Default CSS style</td></tr>
    // <tr><td><code><i>iconStyle</i>+Selected</code></td>
    //      <td>Applied when +link{StatefulCanvas.selected} and +link{StatefulCanvas.showSelectedIcon}
    //      are true.</td></tr>
    // <tr><td><code><i>iconStyle</i>+Focused</code></td>
    //      <td>Applied when the component has keyboard focus, if
    //      +link{StatefulCanvas.showFocusedIcon} is true, and
    //      +link{StatefulCanvas.showFocusedAsOver} is not true.</td></tr>
    // <tr><td><code><i>iconStyle</i>+Over</code></td>
    //      <td>Applied when +link{StatefulCanvas.showRollOverIcon} is set to true and either
    //      the user rolls over the component or +link{StatefulCanvas.showFocusedAsOver} is true
    //      and the component has keyboard focus.</td></tr>
    // <tr><td><code><i>iconStyle</i>+Down</code></td>
    //      <td>Applied when the user presses the mouse button on the component if
    //          +link{StatefulCanvas.showDownIcon} is set to true</td></tr>
    // <tr><td><code><i>iconStyle</i>+Disabled</code></td>
    //      <td>Applied when the component is +link{Canvas.disabled,disabled}
    //       if +link{statefulCanvas.showDisabledIcon} is true.</td></tr>
    // <tr><td colspan=2><i>Combined styles</i></td></tr>
    // <tr><td><code><i>iconStyle</i>+SelectedFocused</code></td>
    //      <td>Combined Selected and focused styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+SelectedOver</code></td>
    //      <td>Combined Selected and rollOver styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+FocusedOver</code></td>
    //      <td>Combined Focused and rollOver styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+SelectedFocusedOver</code></td>
    //      <td>Combined Selected, Focused and rollOver styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+SelectedDown</code></td>
    //      <td>Combined Selected and mouse-down styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+FocusedDown</code></td>
    //      <td>Combined Focused and mouse-down styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+SelectedFocusedDown</code></td>
    //      <td>Combined Selected, Focused and mouse-down styling</td></tr>
    // <tr><td><code><i>iconStyle</i>+SelectedDisabled</code></td>
    //      <td>Combined Selected and Disabled styling</td></tr>
    // </table>
    // <p>
    // In addition, if +link{StatefulCanvas.showRTLIcon} is true, then in RTL mode, a final
    // "RTL" suffix will be appended.
    // @setter setIconStyle()
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.vIconStyle (CSSStyleName : null : IRW)
    // Base CSS style applied to the icon image when +link{stretchImg.vertical, vertical}
    // is set to true. If set, as the <code>StatefulCanvas</code> changes
    // +link{StatefulCanvas.state,state} and/or is +link{StatefulCanvas.selected,selected},
    // suffixes will be appended to <code>vIconStyle</code> to form the className set on the
    // image element.
    // <p>
    // The +link{statefulCanvas.iconStyle} for details about stateful suffixes.
    // @group buttonIcon
    // @visibility external
    //<

    getIconStyleForOrientation : function () {
        if (this.vertical) return this.vIconStyle || this.iconStyle;
        return this.iconStyle;
    },

    //> @attr statefulCanvas.iconOrientation     (String : "left" : [IR])
    // If this button is showing an icon should it appear to the left or right of the title?
    // valid options are <code>"left"</code> and <code>"right"</code>.
    //
    // @group buttonIcon
    // @visibility external
    //<
    iconOrientation:"left",

    //> @attr statefulCanvas.iconAlign     (String : null : [IR])
    // If this button is showing an icon should it be right or left aligned?
    //
    // @group buttonIcon
    // @visibility internal
    //<
    // Behavior is as follows - if iconOrientation and iconAlign are both left or both right we
    // write the icon out at the extreme right or left of the button, and allow the title to
    // aligned independently of it. (otherwise the icon and the text will be adjacent, and
    // aligned together based on the button's "align" property.


    //> @attr statefulCanvas.iconSpacing   (int : 6 : [IR])
    // Pixels between icon and title text.
    //
    // @group buttonIcon
    // @visibility external
    //<
    iconSpacing:6,

    // internal: controls whether we apply any state to the icon at all
    showIconState: true,

    //> @attr statefulCanvas.showDisabledIcon   (Boolean : true : [IR])
    // If using an icon for this button, whether to switch the icon image if the button becomes
    // disabled.
    //
    // @group buttonIcon
    // @visibility external
    //<
    showDisabledIcon:true,

    //> @attr statefulCanvas.showRollOverIcon   (Boolean : false : [IR])
    // If using an icon for this button, whether to switch the icon image on mouse rollover.
    //
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.showDownIcon       (Boolean : false : [IR])
    // If using an icon for this button, whether to switch the icon image when the mouse goes
    // down on the button.
    //
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.showSelectedIcon   (Boolean : false : [IR])
    // If using an icon for this button, whether to switch the icon image when the button
    // becomes selected.
    //
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr StatefulCanvas.showFocusedIcon (Boolean : false : [IR])
    // If using an icon for this button, whether to switch the icon image when the button
    // receives focus.
    // <P>
    // If +link{statefulCanvas.showFocusedAsOver} is true, the <code>"Over"</code> icon will be
    // displayed when the canvas has focus, otherwise a separate <code>"Focused"</code> icon
    // will be displayed
    // @group buttonIcon
    // @visibility external
    //<

    //> @attr statefulCanvas.showRTLIcon (boolean : false : IR)
    // Is +link{Page.isRTL(),RTL} media available for the icon? If true, then in RTL mode, the
    // image's src will have "_rtl" inserted immediately before the file extension. For example,
    // if +link{icon,icon} is "myIcon.png" and showRTLIcon is true, then in RTL mode, the image's
    // src will be set to "myIcon_rtl.png".
    // @group RTL
    // @visibility external
    //<

    // ---------------------------------------------------------------------------------------

    // doc'd only on StretchImg
    gripImgSuffix:"grip",

    // ---------------------------------------------------------------------------------------

    //> @attr statefulCanvas.showOverCanvas (Boolean  : false : [IRWA])
    // When this property is set to true, this widget will create and show the
    // +link{StatefulCanvas.overCanvas} on user rollover.
    // @visibility external
    //<

    //> @attr statefulCanvas.overCanvas (AutoChild Canvas : null : [R])
    // Auto generated child widget to be shown when the user rolls over this canvas if
    // +link{StatefulCanvas.showOverCanvas} is true. See documentation for +link{type:AutoChild}
    // for information on how to customize this canvas.
    // @visibility external
    //<

    //> @attr statefulCanvas.overCanvasConstructor (String : "Canvas" : [IRWA])
    // Constructor class name for this widget's +link{statefulCanvas.overCanvas,overCanvas}
    // @visibility external
    //<
    overCanvasConstructor: "Canvas",

    //> @attr statefulCanvas.overCanvasDefaults (Canvas : { ... } : [IRWA])
    // Default properties for this widgets +link{statefulCanvas.overCanvas,overCanvas}. To modify
    // these defaults, use +link{Class.changeDefaults()}
    // @visibility external
    //<
    overCanvasDefaults: {
        // override mouseOut to hide this canvas if the user rolls off it and out of the
        // parent/constructor
        mouseOut:function () {
            if (isc.EH.getTarget() != this.creator) this.clear();
            return this.Super("mouseOut", arguments);
        }
    }


});

isc.StatefulCanvas.addMethods({

init : function () {
    // if this.icon is a src that links to a stockIcon with no current mapping,
    // clear this.icon so that no HTML renders and takes up space
    if (isc.isA.String(this.icon)) {
        if (isc.Media.isEmptyStockIcon(this.icon)) this.icon = null;
    }

    return this.Super("init", arguments);
},

//>    @method    statefulCanvas.initWidget()    (A)
// Initialize this StatefulCanvas. Pass in objects with properties to add or override defaults.
//
//        @param    [all arguments]    (Object)    objects with properties to override from default
//<
initWidget : function () {

    // StyleName is ignored in favor of baseStyle+suffix
    // If the styleName doesn't match the default for the class, log a warning as it's very
    // likely a developer is unaware of this.
    var defaultStyleName = this.getClass().getPrototype().styleName;
    if (this.styleName != null && this.styleName != defaultStyleName) {
        // If baseStyle is unset we will use styleName as a default.
        // We could still warn the user off from relying on this but that may be overkill
        if (this.baseStyle != null && this.baseStyle != this.styleName) {
            this.logWarn("Explicit styleName detected ('"
                + this.styleName + "'). This property will be ignored in favor of "
                + "baseStyle ('" + this.baseStyle + "').");
        }
    }


    if (this.src == null) this.src = this.vertical ? this.vSrc : this.hSrc;



    var stateIsDisabled = (this.state == isc.StatefulCanvas.STATE_DISABLED);
    if (stateIsDisabled) {
        if (!this.showDisabled) {
            this.logWarn("The state cannot be initialized to 'Disabled' if this.showDisabled is false. Setting to STATE_UP...");
            this.state = isc.StatefulCanvas.STATE_UP;
            stateIsDisabled = false;
        }
    }

    // the disabled property also affects the state of this object
    if (this.isDisabled()) {

        if (!stateIsDisabled) this._enabledState = this.state;

        if (this.showDisabled) {
            this.state = isc.StatefulCanvas.STATE_DISABLED;
            stateIsDisabled = true;
        }
    }

    // if className has been specified and baseStyle has no default, copy className to
    // baseStyle.  This is needed for the Label where you are expected to set className, not
    // baseStyle.
    // From then on the current className will be derived from the baseStyle setting plus the
    // current state, unless the widget suppresses className, which it may do if it has another
    // element the receives the baseStyle, and it leaves the handle unstyled.
    this.baseStyle = this.baseStyle || this.className;
    var stateName = this.getStateName()
    this.styleName = (this.suppressClassName ? null : stateName);
    this.className = this.styleName;

    // Remember the current stateName so stateChanged doesn't do unnecessary work
    this._currentStateName = stateName;

    // If this button has a radioGroup ID specified, update the array of widgets in the
    // radiogroup to include this one.
    if (this.radioGroup != null) {

        var rg = this.radioGroup;
        // clear out the property to avoid a no-op, then add with the standard setter
        this.radioGroup = null;
        this.addToRadioGroup(rg);
    }

    this._initializedState = true;

    // Initialize autoFit
    this.setAutoFit(this.autoFit, true);

    if (this.showGrip) {
        // use the icon functionality of the label to show an image floated over center (this
        // is mutex with using the icon / label functionality, but most such uses don't make
        // much sense)
        this.showTitle = true;
        this.labelVPad = 0;
        this.labelHPad = 0;
        this.iconSpacing = 0;
        this.align = isc.Canvas.CENTER;

        this._setGripIconDirection();

        this.showRollOverIcon = this.showRollOverGrip;
        this.showDownIcon  = this.showDownGrip;
    }

    var showingLabel = this.shouldShowLabel();
    if (showingLabel) this.makeLabel();

    // the flexEdge autochild/peer is used by ListGrid to show a draggable right-border-like
    // flexEdge on header-buttons when showHeaderResizers is true, and can be used by
    // SimpleTabButton as a bottom border or a narrow, left-aligned highlighted area inside
    // the tabButton
    if (this.shouldShowFlexEdge()) {
        var props = { dragTarget: this };
        if (this.flexEdgeBreadth) {
            props.width = props.maxWidth = this.vertical ?
                    this.flexEdgeBreadth : this.flexEdgeLength;
        }
        if (this.flexEdgeLength) {
            props.height = this.vertical ? this.flexEdgeLength : this.flexEdgeBreadth;
        }
        if (this.flexEdgeSnapTo) props.snapTo = this.flexEdgeSnapTo;
        if (this.flexEdgeSnapOffsetLeft) props.snapOffsetLeft = this.flexEdgeSnapOffsetLeft;
        if (this.flexEdgeSnapOffsetTop) props.snapOffsetTop = this.flexEdgeSnapOffsetTop;

        if (this.flexEdgeBaseStyle) props.baseStyle = this.flexEdgeBaseStyle;
        if (this.flexEdgeColor) props.backgroundColor = this.flexEdgeColor;
        if (this.flexEdgeRadius) props.borderRadius = this.flexEdgeRadius;

        this.flexEdge = this.createAutoChild("flexEdge", props);
        if (this.flexEdge.vertical == null) this.flexEdge.vertical = this.vertical;
        this.addPeer(this.flexEdge);
    }

},

// configure/refresh the grip icon based on the current value of "vertical"
_setGripIconDirection : function () {


    // get the URL for a piece named "grip".

    this.icon = isc.isAn.Object(this.src) ? this.src :
                    this.getImgURL(this.getURL(this.gripImgSuffix));


    this.iconSize = this.gripSize;
    this.iconWidth = this.vertical ? this.gripBreadth : this.gripLength;
    this.iconHeight = this.vertical ? this.gripLength : this.gripBreadth;


    if (this.label) {
        this.label.setProperties({
            icon:       this.icon,
            iconSize:   this.iconSize,
            iconWidth:  this.iconWidth,
            iconHeight: this.iconHeight
        });
    }
},

//> @attr statefulCanvas.ariaLabel (String : null : IRWA)
// If specified this property returns the +link{statefulCanvas.getAriaLabel(),aria-label}
// attribute to write out in +link{isc.setScreenReaderMode(),screenReaderMode}.
// <P>
// If unset, aria-label will default to +link{statefulCanvas.prompt,this.prompt} if specified,
// otherwise +link{statefulCanvas.title,this.title}.
// <P>
// @visibility external
//<
//ariaLabel:null


//> @method statefulCanvas.getAriaLabel()
// Method to return the <code>aria-label</code> for this component
// (see +link{statefulCanvas.getAriaStateDefaults()}).
// <P>
// Returns +link{ariaLabel} if specified, otherwise +link{prompt}, otherwise +link{title}
//
// @return (String) aria label value
// @visibility external
//<
getAriaLabel : function () {
    var undef;
    // Allow explicit null

    if (this.ariaLabel !== undef) return this.ariaLabel;
    var label = this.prompt || this.title;

    // avoid writing out the default "Untitled Button" (or its i18n replacement)
    if (label != null && label != "" && isc.Button.getInstanceProperty("title") != label) {
        return String.htmlStringToString(label);
    }
    return null;
},

// stateful image URL

_showImgStateProps:{
    Over:"showImageRollOver",
    Focused:"showImageFocused",
    Down:"showImageDown",
    Disabled:"showImageDisabled",
    Selected:"showImageSelected"
},
_shouldShowStatefulImage : function (state) {
    if (this.statelessImage) return false;

    var showImgStateProp = this._showImgStateProps[state],
        // showStateProps inherited from StatefulCanvas
        showStateProp = this._showStateProps[state];

    if (this[showImgStateProp] != null) return this[showImgStateProp];

    // src is a 'base' string - assume we should attach a suffix to the URL if
    // the state-level prop (showRollOver, etc) isn't explicitly false
    if (!isc.isAn.Object(this.src)) {
        return showStateProp ? this[showStateProp] : true;

    // If we're using a statefulImgConfig object we can always just return true.
    // If the config obj has an entry for the state we'll use it. If not we'll
    // back off to the appropriate stateless entry and potentially leave the image unchanged
     } else {
        return true;
    }
},

//>    @method    statefulCanvas.getURL()
// Get the URL for an image based on this.src as modified by the piece name and state.
//
//            eg if:        .src         = "foo.gif"
//                        pieceName     = "start"
//                        state        = "down"
//
//            url =         foo_down_start.gif
//
// @param    [pieceName]    (String : "")                 name for part of the image
// @param    [state]        (String : this.state)        state of the image ("up", "off", etc.)
// @param    [selected]    (boolean : this.selected)    whether or not image is also in the
//                                                      "selected" state
// @param  [focused]   (boolean)
//   Whether this image should be rendered in the "focused" state. Defaults to true if
//   this Img has focus and +link{StatefulCanvas.showFocused,this.showFocused} is true and
//   +link{StatefulCanvas.showFocusedAsOver,this.showFocusedAsOver} is false.
//
// @return (SCImgURL) URL for the image
//<
getURL : function (pieceName, state, selected, focused) {

    // Stateless image: We still want to run through urlForState in case this.src is
    // a SCStatefulImgConfig object (required to extract the 'base' state)
    if (this.statelessImage) return isc.Img.urlForState(this.src);


    if (state == null) state = this.state;
    if (selected == null) selected = this.selected;
    if (focused == null) focused = this.getFocusedState();
    if (state && !this._shouldShowStatefulImage(state)) state = null;
    if (selected && !this._shouldShowStatefulImage(isc.StatefulCanvas.STATE_SELECTED)) selected = false;
    if (focused) {

        if (!this._shouldShowStatefulImage(isc.StatefulCanvas.FOCUSED)) {
            focused = false;
        } else {
            // respect 'showFocusedAsOver' for src defined as a string

            var showFocusedAsOver = this.showImageFocusedAsOver;
            if (showFocusedAsOver == null) showFocusedAsOver = this.showFocusedAsOver;
            if (showFocusedAsOver && !isc.isAn.Object(this.src)) {
                // Don't clobber any other state [Selected or Down, say]
                if (this._shouldShowStatefulImage(isc.StatefulCanvas.STATE_OVER) &&
                    (!state || state == isc.StatefulCanvas.STATE_UP))
                {
                    state = isc.StatefulCanvas.STATE_OVER;
                }
                focused = false;
            }
        }
    }

    return isc.Img.urlForState(this.src,
                           selected,
                           focused,
                           state,
                           pieceName,
                           this.getCustomState());
},

//> @method StatefulCanvas.shouldShowLabel()
// Should this widget create a floating label for textual content - used for image based widgets.
// Default implementation returns this.showTitle
// @return (boolean) true if the floating label should be created
//<
shouldShowLabel : function () {
    return this.showTitle;

},

//> @method statefulCanvas.setIgnoreRTL() (A)
// Setter for +link{ignoreRTL,ignoreRTL}.
// @param ignoreRTL (boolean) new value for ignoreRTL.
// @visibility external
//<
setIgnoreRTL : function (ignoreRTL) {
    this.ignoreRTL = !!ignoreRTL;
    if (this.isDrawn()) this.markForRedraw();
    if (this.label) this.label.setIgnoreRTL(ignoreRTL);
},

// State
// ------------------------------------------------------------------------------------------------------
// set the state for this object, and whether or not it is selected

_$visualState:"visualState",
stateChanged : function (forceRedraw) {

    if (this.destroyed) return;
    if (!this._initializedState) return;

    var newState = this.getStateName();


    var stateNameChanged = (this._currentStateName != newState);
    this._currentStateName = newState;

    if (this.logIsDebugEnabled(this._$visualState)) {
        this.logDebug("state changed to: " + newState, "visualState");
    }
    if (forceRedraw || this._shouldRedrawOnStateChange()) {
        this.markForRedraw("state change");
    }
    // NOTE: a redraw doesn't update className
    if (!this.suppressClassName && (stateNameChanged || this.pendingMarkerVisible)) {
        this.setStyleName(newState);
    }
    // set our label to the same state (note it potentially has independent styling)
    var label = this.label;
    if (label != null) {
        label.setState(this.getState());
        label.setSelected(this.isSelected());
        label.setCustomState(this.getCustomState());
    }

},

/* flexEdge */

//> @attr statefulCanvas.flexEdge (AutoChild Canvas : null : [R])
// Auto generated peer widget to be shown when +link{showFlexEdge} is set to true.
// May be +link{flexEdgeBaseStyle, statefully-styled} and sized separately according to
// whether this widget is +link{statefulCanvas.vertical}.
// <p>
// This peer canvas can be sized via
// +link{canvas.width, width} and +link{canvas.height, height}, including percentage sizes,
// and positioned via +link{class:Canvas, Canvas} attributes such as top/left, or via
// +link{canvas.snapTo, snapTo}, +link{canvas.snapOffsetLeft, snapOffsetLeft} and
// +link{canvas.snapOffsetTop, snapOffsetTop}.
// <p>
// Styling can be achieved by applying Canvas attributes such as +link{canvas.backgroundColor}
// or +link{canvas.borderRadius} directly, via <i>flexEdgeProperties</i>, or by
// applying a stateful +link{type:CSSStyleName, CSS class} to
// +link{flexEdgeBaseStyle}.  When the parent widget's state changes, its state is
// appended to the <i>flexEdgeBaseStyle</i> - for example, if that attribute is set to
// <i>highlight</i> and the mouse is moved over the parent, the styleName <i>highlightOver</i>
// will be applied to this peer canvas.
// <p>
// This component is an +link{type:AutoChild} and as such may be customized
// <smartclient>via
// <code>statefulCanvas.flexEdgeProperties</code> and
// <code>statefulCanvas.flexEdgeDefaults</code>.
// </smartclient>
// <smartgwt>by calling
// <code>setAutoChildProperties("flexEdge", statefulCanvas.flexEdgeProperties);</code>
// where <code>flexEdgeProperties</code> is a Canvas instance with the desired customizations.
// </smartgwt>
//
// @visibility internal
//<

// "highlight" canvas to show as a peer somewhere in this button - can be used to resize
// LG headers, or to replace the "contactEdge" of a tabButton, which is just a bottom-border
// and can't be fully styled (can't be rounded for example) - or something like a drag-handle
// (like the "grip") or just a visual artifact
showFlexEdge: false,
shouldShowFlexEdge : function () {
    return this.showFlexEdge;
},
flexEdgeConstructor: "Canvas",
flexEdgeDefaults: {
    overflow: "hidden",
    // drag properties work but need to be switched on
    canDragResposition: false,
    canDragResize: false,

    backgroundColor: "lightgrey",
    width: "100%",
    height: 3,
    snapTo: "B",
    snapOffsetLeft: 0,
    snapOffsetTop: 0,
    borderRadius: "3px",
    //cursor: isc.Canvas.MOVE,
    initWidget : function () {
        this.Super("initWidget", arguments);

        // observe zIndexChanged on the creator - used to keep this canvas above the creator
        this.observe(this.creator, "zIndexChanged", "observer.updateForParentZIndex()");

        if (this.creator.flexEdgeBaseStyle) {
            // if there's a flexEdgeBaseStyle on the creator, set it on this canvas
            // and observe creator.stateChanged() to push the creator's state to this canvas
            this.observe(this.creator, "stateChanged", "observer.updateForParentState()");
        }
    },
    draw : function () {
        this.Super("draw", arguments);

        // apply initial canvas settings - used in SimpleTabButton override to return
        // separate config for each tabPosition
        var props = this.creator.getFlexEdgeProperties();
        if (props) this.setProperties(props);

        if (this.creator.flexEdgeBaseStyle) {
            this.updateForParentState();
        }
    },
    destroy : function () {
        // ignore observations
        if (this.isObserving(this.creator, "zIndexChanged"))
            this.ignore(this.creator, "zIndexChanged");
        if (this.isObserving(this.creator, "stateChanged"))
            this.ignore(this.creator, "stateChanged");

        return this.Super("destroy", arguments);
    },
    updateForParentState : function () {
        // push the parent's current state to the this highlight-canvas
        var state = this.creator.getStateSuffix(),
            style = this.creator.flexEdgeBaseStyle + state
        ;
        this.setStyleName(style);
        this.updateForParentZIndex();
    },
    updateForParentZIndex : function () {
        // move this canvas above the master whenever it's zIndex changes
        this.moveAbove(this.creator);
    },
    // on click, fire flexEdgeClick() on the statefulCanvas
    click : function () {
        if (this.dragTarget.flexEdgeClick) this.dragTarget.flexEdgeClick();
    },
    // on doubleClick, fire flexEdgeDoubleClick() on the statefulCanvas
    doubleClick : function () {
        if (this.dragTarget.flexEdgeDoubleClick) this.dragTarget.flexEdgeDoubleClick();
    }

},

getFlexEdgeProperties : function () {
    var breadth = 3,
        length = this.vertical ? "75%" : "90%"
    ;
    if (this.flexEdge.vertical) {
        // default to a 3px v-bar, 4px in from the left
        return {
            width: breadth,
            height: length,
            snapTo: "L",
            snapOffsetLeft: 4,
            snapOffsetTop: 0
        };
    } else {
        // default to a 2px h-bar, 4px up from the bottom-border
        return {
            width: length,
            height: breadth,
            snapTo: "B",
            snapOffsetLeft: 0,
            snapOffsetTop: -4,
            height: 2
        }
    }
},


observeCSSVariableChanges : true,
cssVariablesChanged : function (varNames) {
    this.stateChanged();
},

// should we redraw on state change?
_shouldRedrawOnStateChange : function () {
    return this.redrawOnStateChange;
},

//>    @method statefulCanvas.setBaseStyle()
// Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be
// added to the base style.
// @visibility external
// @param style (CSSStyleName) new base style
//<
setBaseStyle : function (style) {
    // don't bail if this.pendingMarkerVisible is true - stateChanged() needs to run to make
    // sure the extra pendingMarker class is added/removed as appropriate
    if (this.pendingMarkerVisible == null && this.baseStyle == style) return;
    this.baseStyle = style;
    if (this.label && this.titleStyle == null) this.label.setBaseStyle(style);
    // fall through to stateChanged to actually update the appearance
    this.stateChanged();
},

// override this function to call setBaseStyle() or getStyleName()
setPendingMarkerVisible : function (pendingMarkerVisible) {
    this.pendingMarkerVisible = pendingMarkerVisible;
    if (this.baseStyle) this.setBaseStyle(this.baseStyle);
    else if (this.styleName) this.setStyleName(this.styleName);
},


_getIconCursor : function () {

    var cursor = this.iconCursor;
    if (this.isDisabled() && this.disabledIconCursor != null) cursor = this.disabledIconCursor;
    return cursor;
},


setTitleStyle : function (style) {
    if (this.titleStyle == style) return;
    this.titleStyle = style;
    if (this.label) {
        this.label.setBaseStyle(style || this.baseStyle);
    }
    this.stateChanged();
},

//> @method statefulCanvas.setState() (A)
// Sets the +link{StatefulCanvas.state,state} of this object, changing its appearance.
// Note: <code>newState</code> cannot be
// <smartclient>"Disabled"</smartclient>
// <smartgwt>{@link com.smartgwt.client.types.State#STATE_DISABLED}</smartgwt>
// if +link{StatefulCanvas.showDisabled,this.showDisabled} is <code>false</code>.
//
// @param newState (State) the new state.
// @group state
// @group appearance
// @visibility external
//<
setState : function (newState) {
    if (newState == isc.StatefulCanvas.STATE_DISABLED && !this.showDisabled) {
        this.logWarn("The state cannot be changed to 'Disabled' when this.showDisabled is false.");
        return;
    }
    if (this.state == newState) return;
    this.state = newState;
    // update the appearance - redraw if necessary
    this.stateChanged();
},

_updateChildrenTopElement : function () {
    this.Super("_updateChildrenTopElement", arguments);
    this.setHandleDisabled(this.isDisabled());
},

//>    @method    statefulCanvas.getState()    (A)
// Return the state of this StatefulCanvas
//        @group    state
//
// @visibility external
// @return (State)
//<
getState : function () {
    return this.state;
},

//>    @method    statefulCanvas.setSelected()
// Set this object to be selected or deselected.
//        @group    state
//
//        @param    newIsSelected    (boolean)    new boolean value of whether or not the object is
//                                          selected.
// @visibility external
//<
setSelected : function (newIsSelected) {
    // if this.selected is unset, we are not selected and should no-op if being set to not
    // selected
    if (this.selected == null && newIsSelected == false) {
        this.selected = false;
        return;
    }

    if (this.selected == newIsSelected) return;

    // handle mutually exclusive radioGroups
    if (newIsSelected && this.radioGroup != null) {
        var groupArray = isc.StatefulCanvas._radioGroups[this.radioGroup];
        // catch the (likely common) case of this.radioGroup being out of sync - implies
        // a developer has assigned directly to this.radioGroup without calling the setter
        if (groupArray == null) {
            this.logWarn("'radioGroup' property set for this widget, but no corresponding group " +
                         "exists. To set up a new radioGroup containing this widget, or add this " +
                         " widget to an existing radioGroup at runtime, call 'addToRadioGroup(groupID)'");
        } else {
            for (var i = 0; i < groupArray.length; i++) {
                if (groupArray[i]!= this && groupArray[i].isSelected())
                    groupArray[i].setSelected(false);
            }
        }
    }

    this.selected = newIsSelected;

    if (this.label) this.label.setSelected(this.isSelected());

    this.stateChanged();
},

//>    @method    statefulCanvas.select()
// Select this object.
//        @group    state
// @visibility external
//<
select : function () {
    this.setSelected(true);
},

//>    @method    statefulCanvas.deselect()
// Deselect this object.
//        @group    state
// @visibility external
//<
deselect : function () {
    this.setSelected(false);
},

//>    @method    statefulCanvas.isSelected()
// Find out if this object is selected
//        @group    state
//        @return (Boolean)
// @visibility external
//<
isSelected : function () {
    return this.selected;
},

// actionType - determines whether the button will select / deselect on activation

//>    @method    statefulCanvas.getActionType() (A)
// Return the 'actionType' for this canvas (radio / checkbox / button)
// @return (SelectionType) the current action type
//      @group  state
//      @group event handling
//      @visibility external
//<
getActionType : function () {
    return this.actionType;
},

//>    @method    statefulCanvas.setActionType() (A)
// Update the 'actionType' for this canvas (radio / checkbox / button)
// If the canvas is currently selected, and the passed in actionType is 'button'
// this method will deselect the canvas.
// @param actionType (SelectionType) new action type
//      @group  state
//      @group event handling
//      @visibility external
//<
setActionType : function (actionType) {
    if (actionType == isc.StatefulCanvas.BUTTON && this.isSelected()) {
        this.setSelected(false);
    }
    this.actionType = actionType;
},

// radioGroups - automatic handling for mutually exclusive selection behavior between buttons

//>    @method    statefulCanvas.addToRadioGroup(groupID) (A)
// Add this widget to the specified mutually exclusive selection group with the ID
// passed in.
// Selecting this widget will then deselect any other StatefulCanvases with the same
// radioGroup ID.
// StatefulCanvases can belong to only one radioGroup, so this method will remove from
// any other radiogroup of which this button is already a member.
//      @group  state
//      @group event handling
//      @param  groupID (String)    - ID of the radiogroup to which this widget should be added
//      @visibility external
//<
addToRadioGroup : function (groupID) {
    // Bail if groupID is null, or if we already belong to the specified group, so we don't
    // get duplicated in the array
    if (groupID == null || this.radioGroup == groupID) return;

    if (this.radioGroup != null) this.removeFromRadioGroup();

    this.radioGroup = groupID;

    // make surethe widget-array for the specified group exists  on the Class object
    if (!isc.StatefulCanvas._radioGroups[this.radioGroup]) {
        isc.StatefulCanvas._radioGroups[this.radioGroup] = [];
    }

    // get the specified group's widget-array
    var group = isc.StatefulCanvas._radioGroups[this.radioGroup];

    // add this widget to the widget-array for the specified group
    group.add(this);

    // radios only have one selected member, so if this item is selected, it needs to call
    // setSelected() to deselect any previously selected item
    if (this.selected) {
        // make it false first or setSelected() will bail
        this.selected = false;
        this.setSelected(true);
    }
},

//>    @method    statefulCanvas.removeFromRadioGroup(groupID) (A)
// Remove this widget from the specified mutually exclusive selection group with the ID
// passed in.
// No-op's if this widget is not a member of the groupID passed in.
// If no groupID is passed in, defaults to removing from whatever radioGroup this widget
// is a member of.
//      @group  state
//      @group event handling
//      @visibility external
//      @param  [groupID]   (String)    - optional radio group ID (to ensure the widget is removed
//                                        from the appropriate group.
//<
removeFromRadioGroup : function (groupID) {
    // if we're passed the ID of a group we're not a member of, just bail
    if (this.radioGroup == null || (groupID != null && groupID != this.radioGroup)) return;

    var widgetArray = isc.StatefulCanvas._radioGroups[this.radioGroup];
    if (widgetArray) widgetArray.remove(this);

    delete this.radioGroup;

    // if this widget is selected, deselect it and mark it for redraw
    if (this.selected) {
        this.selected = false;
        this.markForRedraw();
    }
},

// Enable/Disable
// ------------------------------------------------------------------------------------------------------
//    to have an object redraw when it's enabled, set:
//        .redrawOnDisable = true

//>    @method    statefulCanvas.setDisabled()
// Enable or disable this object
//        @group enable, state
//
//    @param    disabled (boolean) true if this widget is to be disabled
// @visibility external
//<
// actually implemented on Canvas, calls setHandleDisabled()

setHandleDisabled : function (disabled,b,c,d) {
    this.invokeSuper(isc.StatefulCanvas, "setHandleDisabled", disabled,b,c,d);

    // set the StatefulCanvas.STATE_DISABLED/StatefulCanvas.STATE_UP states.
    var handleIsDisabled = (this.state == isc.StatefulCanvas.STATE_DISABLED);
    if (handleIsDisabled == disabled) return;

    if (disabled == false) {
        var enabledState = this._enabledState || isc.StatefulCanvas.STATE_UP;
        if (enabledState == isc.StatefulCanvas.STATE_OVER) {
            var EH = this.ns.EH;
            if (!this.visibleAtPoint(EH.getX(), EH.getY())) {
                enabledState = isc.StatefulCanvas.STATE_UP;
                this.setState(enabledState);
            } else {
                // This will state set to over (or "Down" if the mouse is down)
                this._doMouseOverStateChange();
            }
        } else this.setState(enabledState);
    } else {
        // hang onto the enable state so that when we're next enabled we can reset to it.
        this._enabledState = this.state;
        this._doMouseOutStateChange(true);
        if (this.showDisabled) {
            this.setState(isc.StatefulCanvas.STATE_DISABLED);
        }
    }

    if (this.showDisabled && this.iconCursor != null) {
        if (this.icon != null) {
            var imageHandle = this.getImage("icon", this._iconIsSprite() || this._iconIsFont());
            if (imageHandle != null) imageHandle.style.cursor = this._getIconCursor();
        }
    }
},

_getIconURL : function () {

    if (this._ignoreIcon == true) return null;
    var icon = this.icon;
    if (isc.isAn.Object(icon) && icon.src != null) {
        icon = icon.src;
    }
    return icon;
},


_iconIsSprite : function () {
    var icon = this._getIconURL();
    return icon && icon.startsWith("sprite:");
},
_iconIsFont : function () {
    var icon = this._getIconURL();
    //isc.logWarn(icon);
    return icon && icon.startsWith("font:");
},


// CSS Style methods
// ------------------------------------------------------------------------------------------
// methods that allow style to change according to state.

//>    @method    statefulCanvas.getStateName()    (A)
// Get the CSS styleName that should currently be applied to this component, reflecting
// <code>this.baseStyle</code> and the widget's current state.
// <P>
// NOTE: this can differ from the style currently showing if the component has not yet updated
// it's visual state after a state change.
//
//        @group    appearance
//        @return    (CSSStyleName)    name of the style to set the StatefulCanvas to
//<
getStateName : function () {
    var modifier = this.getStateSuffix();

    if (modifier) return this.baseStyle + modifier;
    return this.baseStyle;
},

getTitleStateName : function () {

    if (!this.titleStyle) return null;
    return this.titleStyle + (this.showDisabled && this.isDisabled() ? isc.StatefulCanvas.STATE_DISABLED : isc.emptyString);
},

//>    @method    statefulCanvas.getStateSuffix()
// Returns the suffix that will be appended to the +link{StateFulCanvas.baseStyle}
// as the component changes +link{statefulCanvas.state} and/or is selected / focused.
// <P>
// Note that suffixes will only be included if the relevant <code>show<i>[StateName]</i></code>
// attributes (EG +link{showRollOver}, +link{showFocused}, etc) are set to true.
// <P>
// The following table lists out the standard set of suffixes which may be applied
// to the base style:
// <table border=1>
// <tr><td><b>CSS Class Applied</b></td><td><b>Description</b></td></tr>
// <tr><td><code><i>baseStyle</i></code></td><td>Default css style</td></tr>
// <tr><td><code><i>baseStyle</i>+Selected</code></td>
//      <td>Applied when +link{statefulCanvas.selected} is set to true.</td></tr>
// <tr><td><code><i>baseStyle</i>+Focused</code></td>
//      <td>Applied when the component has keyboard focus, if
//      +link{statefulCanvas.showFocused} is true, and
//      +link{statefulCanvas.showFocusedAsOver} is not true.</td></tr>
// <tr><td><code><i>baseStyle</i>+Over</code></td>
//      <td>Applied when +link{statefulCanvas.showRollOver} is set to true and either the user
//      rolls over the component or +link{statefulCanvas.showFocusedAsOver} is true and the
//      component has keyboard focus.</td></tr>
// <tr><td><code><i>baseStyle</i>+Down</code></td>
//      <td>Applied when the user presses the mouse button on the component if
//          +link{statefulCanvas.showDown} is set to true</td></tr>
// <tr><td><code><i>baseStyle</i>+Disabled</code></td>
//      <td>Applied when the component is +link{Canvas.disabled,disabled}
//       if +link{statefulCanvas.showDisabled} is true.</td></tr>
// <tr><td colspan=2><i>Combined styles</i></td></tr>
// <tr><td><code><i>baseStyle</i>+SelectedFocused</code></td>
//      <td>Combined Selected and focused styling</td></tr>
// <tr><td><code><i>baseStyle</i>+SelectedOver</code></td>
//      <td>Combined Selected and rollOver styling</td></tr>
// <tr><td><code><i>baseStyle</i>+FocusedOver</code></td>
//      <td>Combined Focused and rollOver styling</td></tr>
// <tr><td><code><i>baseStyle</i>+SelectedFocusedOver</code></td>
//      <td>Combined Selected, Focused and rollOver styling</td></tr>
// <tr><td><code><i>baseStyle</i>+SelectedDown</code></td>
//      <td>Combined Selected and mouse-down styling</td></tr>
// <tr><td><code><i>baseStyle</i>+FocusedDown</code></td>
//      <td>Combined Focused and mouse-down styling</td></tr>
// <tr><td><code><i>baseStyle</i>+SelectedFocusedDown</code></td>
//      <td>Combined Selected, Focused and mouse-down styling</td></tr>
// <tr><td><code><i>baseStyle</i>+SelectedDisabled</code></td>
//      <td>Combined Selected and Disabled styling</td></tr>
// </table>
//
// @return (String) suffix to be appended to the baseStyle
// @visibility external
//<

_showStateProps:{
    Over:"showRollOver",
    Focused:"showFocused",
    Down:"showDown",
    Disabled:"showDisabled"
    // note: no "showSelected"
},
getStateSuffix : function () {

    // Note we set the state (STATE_OVER, etc) even if showRollOver is false,
    // so this method needs to check those "showXXX" properties

    var state = this.getState(),
        showStateProp = this._showStateProps[state];

    // If we're in state "Over" [say], and showRollOver is false, ignore this state
    if (state && showStateProp && this[showStateProp] === false) {
        state = null;
    }

    // If we're focused, either update 'state' to be "Over", or include the "Focused"
    // state modifier in the suffix
    var isFocused = this.getFocusedState() && this.showFocused,
        focusedState;
    if (isFocused) {
        if (this.showFocusedAsOver) {
            // Don't clobber any other state [Selected or Down, say]
            if (this.showRollOver && (!state || state == isc.StatefulCanvas.STATE_UP)) {
                state = isc.StatefulCanvas.STATE_OVER;
            }
        } else {
            focusedState = isc.StatefulCanvas.FOCUSED;
        }
    }


    var selected = this.isSelected() ? isc.StatefulCanvas.SELECTED : null,
        customState = this.getCustomState();

    return this._getStateSuffix(state,selected,focusedState,customState);
},

_getStateSuffix : function (state, selected, focused, customState) {

    return isc.StatefulCanvas._getStateSuffix(state, selected, focused, customState);
},

setCustomState : function (customState) {
    if (customState == this.customState) return;
    this.customState = customState;
    this.stateChanged();
},
getCustomState : function () { return this.customState },

// Override getPrintStyleName to pick up the current stateName rather than this.styleName which
// may have been cleared (EG suppressClassName is true)
getPrintStyleName : function () {
    return this.printStyleName || this.getStateName();
},

// Label
// ---------------------------------------------------------------------------------------

labelDefaults : {
    _isStatefulCanvasLabel: true,
    _canFocus : function () { return this.masterElement._canFocus(); },
    focusChanged : function (hasFocus) {
        if (this.hasFocus) this.eventProxy.focus();
    },

    getContents : function () { return this.masterElement.getTitleHTML() },

    // override adjustOverflow to notify us when this has it's overflow changed
    // (probably due to 'setContents')
    adjustOverflow : function (a,b,c,d) {
        this.invokeSuper(null, "adjustOverflow", a,b,c,d);
        if (this.masterElement) this.masterElement._labelAdjustOverflow();
    }
},

_$label: "label",
makeLabel : function () {
    var labelClass = this.getAutoChildClass(this._$label, null, isc.Label);

    var label = labelClass.createRaw();
    label.ignoreRTL = this.ignoreRTL;
    label.clipTitle = this.clipTitle;
    // handle the clipped title hover ourselves
    label.showClippedTitleOnHover = false;
    label._canHover = false;

    if (this._getAfterPadding != null) {
        label._getAfterPadding = function () {
            return this.masterElement._getAfterPadding();
        };
    }

    label.align = this.align;
    label.valign = this.valign;

    label._resizeWithMaster = false;
    label._redrawWithMaster = (this._redrawLabelWithMaster != null ? this._redrawLabelWithMaster : false);
    label._redrawWithParent = false;
    label.containedPeer = true;

    // icon-related
    label.icon = this.icon;
    label.iconWidth = this.iconWidth;
    label.iconHeight = this.iconHeight;
    label.iconSize = this.iconSize;
    label.iconOrientation = this.iconOrientation;
    label.iconAlign = this.iconAlign;
    label.iconSpacing = this.iconSpacing;
    label.iconStyle = this.getIconStyleForOrientation();
    label.vIconStyle = this.vIconStyle;
    label.iconCursor = this.iconCursor;
    label.disabledIconCursor = this.disabledIconCursor;
    label.showDownIcon = this.showDownIcon;
    label.showSelectedIcon = this.showSelectedIcon;
    label.showRollOverIcon = this.showRollOverIcon;
    // set label's showRollOver if we've set showRollOverIcon on the label
    if (label.showRollOverIcon) label.showRollOver = true;

    label.showFocusedIcon = this.showFocusedIcon;
    label.showDisabledIcon = this.showDisabledIcon;
    label.showRTLIcon = this.showRTLIcon;
    if (this.showIconState != null) label.showIconState = this.showIconState;

    // If we show 'focused' state, have our label show it too.
    label.getFocusedAsOverState = function () {
        var button = this.masterElement;
        if (button && button.getFocusedAsOverState) return button.getFocusedAsOverState();
    };
    label.getFocusedState = function () {
        var button = this.masterElement;
        if (button && button.getFocusedState) return button.getFocusedState();
    };


    // By default we'll apply our skinImgDir to the label - allows [SKIN] to be used
    // in icon src.
    label.skinImgDir = this.labelSkinImgDir || this.skinImgDir;


    label.baseStyle = this.titleStyle || this.baseStyle;
    label.showDisabled = this.showDisabled;
    label.state = this.getState();
    label.customState = this.getCustomState();

    // default printStyleName to this.printStyleName
    label.getPrintStyleName = function () {
        return this.masterElement.getPrintStyleName();
    }

    // if we're set to overflow:visible, that means the label should set to overflow:visible
    // and we should match its overflowed size
    label.overflow = this.overflow;


    label.width = this._getLabelSpecifiedWidth();
    label.height = this._getLabelSpecifiedHeight();
    label.left = this._getLabelLeft();
    label.top = this._getLabelTop();


    // NOTE: vertical always false where inapplicable, eg ImgButton
    label.wrap = this.wrap != null ? this.wrap : this.vertical;

    label.eventProxy = this;

    label.isMouseTransparent = true;

    label.zIndex = this.getZIndex(true) + 1;

    label.tabIndex = -1;

    // finish createRaw()/completeCreation() construction style, but allow autoChild defaults
    this._completeCreationWithDefaults(this._$label, label);

    label = this.label = isc.SGWTFactory.extractFromConfigBlock(label);

    // Because the label is a peer of this StatefulCanvas, if we are explicitly disabled, but
    // within an enabled parent, the label, when added to the parent, would be enabled if we
    // did not explicitly disable it.
    label.setDisabled(this.isDisabled());
    label.setSelected(this.isSelected());


    this.addPeer(label, null, null, true);
},


setLabelSkinImgDir : function (dir) {
    this.labelSkinImgDir = dir;
    if (this.label != null) this.label.setSkinImgDir(dir);
},

setSkinImgDir : function (dir) {
    this.Super("setSkinImgDir", arguments);
    if (this.labelSkinImgDir == null && this.label != null) this.label.setSkinImgDir(dir);
},

// Label Sizing Handling
// ---------------------------------------------------------------------------------------

//> @method statefulCanvas.setIconOrientation
// Changes the orientation of the icon relative to the text of the button.
//
// @param orientation (String) The new orientation of the icon relative to the text
// of the button.
//
// @group buttonIcon
// @visibility external
//<
setIconOrientation : function (orientation) {

    this.iconOrientation = orientation;
    if (this.label) {
        this.label.iconOrientation = orientation;
        this.label.markForRedraw();
    } else {
        this.markForRedraw();
    }
},

//>@method statefulCanvas.setAutoFit()
// Setter method for the +link{StatefulCanvas.autoFit} property. Pass in true or false to turn
// autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to
// it's previously specified size.
// @param autoFit (boolean) New autoFit setting.
// @visibility external
//<
setAutoFit : function (autoFit, initializing) {

    // setAutoFit is called directly from resizeTo
    // If we're resizing before the autoFit property's initial setup, don't re-set the
    // autoFit property.
    if (initializing) {
        this._autoFitInitialized = true;
        // No need to make any changes if autoFit is false
        if (!autoFit) return;
    }

    // This can happen if 'setWidth()' et-al are called during 'init' for the statefulCanvas,
    // and should not effect the autoFit setting.
    if (!this._autoFitInitialized) return;

    // Typecast autoFit to a boolean
    autoFit = !!autoFit;

    // bail if no change to autoFit, unless this is the special init-time call
    if (!initializing && (!!this.autoFit == autoFit)) return;

    this._settingAutoFit = true;
    this.autoFit = autoFit;
    var horizontal = (this.autoFitDirection == isc.Canvas.BOTH) ||
                      (this.autoFitDirection == isc.Canvas.HORIZONTAL),
        vertical = (this.autoFitDirection == isc.Canvas.BOTH) ||
                    (this.autoFitDirection == isc.Canvas.VERTICAL);

    // advertise that we should never expand width/height in whatever directions we are
    // autofitting (used by Layout code to suppress expansion on length or breadth axis)
    this.neverExpandWidth = autoFit && horizontal;
    this.neverExpandHeight = autoFit && vertical;

    if (autoFit) {
        // record original overflow, width and height settings so we can restore them if
        // setAutoFit(false) is called
        this._explicitOverflow = this.overflow;
        this.setOverflow(isc.Canvas.VISIBLE);

        if (horizontal) {
            this._explicitWidth = this.width;
            this.setWidth(1);
        }

        if (vertical) {
            this._explicitHeight = this.height;
            this.setHeight(1);
        }
        //this.logWarn("just set autoFit to:"+ autoFit +
        //     ", width/height/overflow:"+ [this.width, this.height, this.overflow]);

    } else {

        // If we had an explicit height before being set to autoFit true, we should reset to
        // that size, otherwise reset to default.
        var width = this._explicitWidth || this.defaultWidth,
            height = this._explicitHeight || this.defaultHeight;


        if (horizontal) this.setWidth(width);
        if (vertical) this.setHeight(height);

        if (this.parentElement && isc.isA.Layout(this.parentElement)) {
            if (horizontal && !this._explicitWidth) this.updateUserSize(null, this._$width);
            if (vertical && !this._explicitHeight) this.updateUserSize(null, this._$height);
        }
        this._explicitWidth = null;
        this._explicitHeight = null;
        if (this._explicitOverflow) this.setOverflow(this._explicitOverflow);
        this._explicitOverflow = null;

    }
    delete this._settingAutoFit;
},


// override 'resizeBy()' / 'setOverflow()' - if these methods are called
// we're essentially clearing out this.autoFit
// Note we override resizeBy() as setWidth / setHeight / resizeTo all fall through to this method.
resizeBy : function (dX, dY, a, b, c, d) {

    var parentElement = this.parentElement;

    if (this.autoFit && this._autoFitInitialized && !this._settingAutoFit &&
        !(isc.isA.Layout(parentElement) && parentElement._layoutInProgress))
    {
        var changeAutoFit = false;

        if (dX != null &&
            (this.autoFitDirection == isc.Canvas.BOTH ||
             this.autoFitDirection == isc.Canvas.HORIZONTAL))
        {
            this._explicitWidth = (1 + dX);
            changeAutoFit = true;
            dX = null;
        }
        if (dY != null &&
            (this.autoFitDirection == isc.Canvas.BOTH ||
             this.autoFitDirection == isc.Canvas.VERTICAL))
        {
            this._explicitHeight = (1 + dY);
            changeAutoFit = true;
            dY = null;
        }

        // one or more of the dimensions where we're autofitting has changed.  Disable
        // autoFitting for this dimension - this will call setWidth / height to return to
        // default or pre-autoFit size
        if (changeAutoFit) this.setAutoFit(false);
        // now continue with normal resizeBy logic for other dimension, if it's non-null
    }
    return this.invokeSuper(isc.StatefulCanvas, "resizeBy", dX, dY, a, b, c, d);
},

//> @attr statefulCanvas.labelHPad (number : null : IRW)
// If non-null, specifies the horizontal padding applied to the label, if any.
// @see stretchImgButton.labelHPad
// @visibility sgwt
//<

getLabelHPad : function () {
    if (this.labelHPad != null) return this.labelHPad;
    if (this.vertical) {
        return this.labelBreadthPad != null ? this.labelBreadthPad : 0;
    } else {
        return this.labelLengthPad != null ? this.labelLengthPad : this.capSize;
    }
},

//> @attr statefulCanvas.labelVPad (number : null : IRW)
// If non-null, specifies the vertical padding applied to the label, if any.
// @see stretchImgButton.labelVPad
// @visibility sgwt
//<
getLabelVPad : function () {
    if (this.labelVPad != null) return this.labelVPad;
    if (!this.vertical) {
        return this.labelBreadthPad != null ? this.labelBreadthPad : 0;
    } else {
        return this.labelLengthPad != null ? this.labelLengthPad : this.capSize;
    }
},

_getLabelLeft : function () {
    var left;

    if (this.isDrawn()) {
        left = (this.position == isc.Canvas.RELATIVE && this.parentElement == null ?
                this.getPageLeft() : this.getOffsetLeft());
    } else {
        left = this.getLeft();
    }

    left += this.getLabelHPad();

    return left;
},

_getLabelTop : function () {
    var top;
    if (this.isDrawn()) {
        top = (this.position == isc.Canvas.RELATIVE && this.parentElement == null ?
               this.getPageTop() : this.getOffsetTop());
    } else {
        top = this.getTop();
    }

    top += this.getLabelVPad();
    return top;
},

_getLabelSpecifiedWidth : function () {
    var width = this.getInnerWidth();
    width -= 2* this.getLabelHPad();

    return Math.max(width, 1);
},

_getLabelSpecifiedHeight : function () {
    var height = this.getInnerHeight();
    height -= 2 * this.getLabelVPad();
    return Math.max(height, 1);
},

// if we are overflow:visible, match the drawn size of the label.
// getImgBreadth/getImgLength return the sizes for the non-stretching and stretching axes
// respectively.
// NOTE that stretching on the breadth axis won't look right with most media sets, eg a
// horizontally stretching rounded button is either going to tile its rounded caps vertically
// (totally wrong) or stretch them, which will probably degrade the media.
getImgBreadth : function () {
    if (this.overflow == isc.Canvas.VISIBLE && isc.isA.Canvas(this.label))
    {
        return this.vertical ? this._getAutoInnerWidth() : this._getAutoInnerHeight();
    }

    //return this.Super("getImgBreadth", arguments);
    // same as the Superclass behavior
    return (this.vertical ? this.getInnerWidth() : this.getInnerHeight());
},

getImgLength : function () {
    if (this.overflow == isc.Canvas.VISIBLE && isc.isA.Canvas(this.label))
    {
        return this.vertical ? this._getAutoInnerHeight() : this._getAutoInnerWidth();
    }
    return (this.vertical ? this.getInnerHeight() : this.getInnerWidth());
},

// get the inner breadth or height we should have if we are overflow:visible and want to size
// to the label and the padding we leave around it
_getAutoInnerHeight : function () {
    var innerHeight = this.getInnerHeight();
    // use the normal inner height if we have no label
    if (!isc.isA.Canvas(this.label)) return innerHeight;

    // if the padding for this dimension is set, use that, otherwise assume the capSize as a
    // default padding for the stretch dimension
    var padding = this.getLabelVPad();
    var labelSize = this.label.getVisibleHeight() + 2*padding;
    return Math.max(labelSize, innerHeight);
},

_getAutoInnerWidth : function () {
    var innerWidth = this.getInnerWidth();
    if (!isc.isA.Canvas(this.label)) return innerWidth;

    var padding = this.getLabelHPad();
    var labelSize = this.label.getVisibleWidth() + 2*padding;
    return Math.max(labelSize, innerWidth);
},


// Have getSizeTestHTML delegate to the label but add the
// labelHPad
_getSizeTestHTML : function (title) {
    if (isc.isA.Canvas(this.label)) {
        return "<table cellpadding=0 cellspacing=0><tr><td>" +
                isc.Canvas.spacerHTML(2*this.getLabelHPad(), 1) + "</td><td>" +
                this.label._getSizeTestHTML(title) + "</td></tr></table>";
    }
    return "<div style='position:absolute;" +
            (this.wrap ? "' " : "white-space:nowrap;' ") +
            "class='" + this.getStateName() + "'>" + title + "</div>";
},


// If we are matching the label size, and it changes, resize images and redraw
_$labelOverflowed:"Label overflowed.",
_labelAdjustOverflow : function () {
    if (this.overflow != isc.Canvas.VISIBLE) return;

    //this.logWarn("our innerWidth:" + this.getInnerWidth() +
    //             ", label visible width: " + this.label.getVisibleWidth() +
    //             " padding: " + (this.labelHPad * 2) +
    //             " resizing to width: " + this.getImgLength());

    // by calling our adjustOveflow, we will re-check the scrollWidth / height which
    // will adjust our size if necessary
    this.adjustOverflow(this._$labelOverflowed);
},

// Override getScrollWidth / Height - if we are overflow:"visible", and have a label we're
// going to size ourselves according to its drawn dimensions
getScrollWidth : function (calcNewValue,B,C,D) {

    if (this.overflow != isc.Canvas.VISIBLE || !isc.isA.Canvas(this.label))
        return this.invokeSuper(isc.StatefulCanvas, "getScrollWidth", calcNewValue,B,C,D);

    if (this._deferredOverflow) {
        this._deferredOverflow = null;
        this.adjustOverflow("widthCheckWhileDeferred");
    }

    if (!calcNewValue && this._scrollWidth != null) return this._scrollWidth;

    // _getAutoInnerWidth() will give us back the greater of our specified size / the
    // label's visible size + our end caps.
    // This is basically our "scroll size" if overflow is visible
    var scrollWidth = this._getAutoInnerWidth()

    return (this._scrollWidth = scrollWidth);
},

getScrollHeight : function (calcNewValue,B,C,D) {

    if (this.overflow != isc.Canvas.VISIBLE || !isc.isA.Canvas(this.label))
        return this.invokeSuper(isc.StatefulCanvas, "getScrollHeight", calcNewValue,B,C,D);

    if (this._deferredOverflow) {
        this._deferredOverflow = null;
        this.adjustOverflow("heightCheckWhileDeferred");
    }

    if (!calcNewValue && this._scrollHeight != null) return this._scrollHeight;

    // _getAutoInnerWidth() will give us back the greater of our specified size / the
    // label's visible size + our end caps.
    // This is basically our "scroll size" if overflow is visible
    var scrollHeight = this._getAutoInnerHeight()

    return (this._scrollHeight = scrollHeight);
},

// Update the label's overflow when our overflow gets updated.
setOverflow : function (newOverflow, a, b, c, d) {

    // If we're autoFit:true, and overflow is getting set to hidden revert the autoFit property
    // to false
    if (this.autoFit && this._autoFitInitialized && !this._settingAutoFit &&
        newOverflow != isc.Canvas.VISIBLE) {

        this._explicitOverflow = newOverflow;
        this.setAutoFit(false);
        return;
    }

    this.invokeSuper(isc.StatefulCanvas, "setOverflow", newOverflow, a, b, c, d);
    if (isc.isA.Canvas(this.label)) this.label.setOverflow(newOverflow, a, b, c, d);

},

// if the SIB is resized, resize the label
// This covers both:
// - the SIB is resized by application code and the label must grow/shrink
// - the SIB resizes itself as a result of the label changing size, in which case the call to
//   resize the label should no-op, since the sizes already agree
_$_resized:"_resized",
_resized : function (deltaX, deltaY, a,b,c) {
    this.invokeSuper(isc.StatefulCanvas, this._$_resized, deltaX,deltaY,a,b,c);
    //if (!this.label || this.overflow != isc.Canvas.VISIBLE) return;
    if (this.label) this.label.resizeTo(this._getLabelSpecifiedWidth(),
                                        this._getLabelSpecifiedHeight());
},


draw : function (a,b,c) {
    if (isc._traceMarkers) arguments.__this = this;


    var returnVal = isc.Canvas._instancePrototype.draw.call(this, a,b,c);
    //var returnVal = this.Super("draw", arguments);

    if (this.position != isc.Canvas.ABSOLUTE && isc.isA.Canvas(this.label)) {

        if (isc.Page.isLoaded()) this._positionLabel();
        else isc.Page.setEvent("load", this.getID() + "._positionLabel()");
    }

    if (this.label != null && isc.Canvas.ariaEnabled()) {
        //var labelDOMId = this.label.getCanvasName();
        //this.logWarn("setting labelledby to: " + labelDOMId);
        //this.setAriaState("labelledby", labelDOMId);

        var label = this.getAriaLabel();
        if (label != null) this.setAriaState("label", label);
    }

    return returnVal;
},

_positionLabel : function () {
    if (!this.isDrawn()) return;
    this.label.moveTo(this._getLabelLeft(), this._getLabelTop());
},

// setAlign() / setVAlign() to set content alignment
// JSDoc'd in subclasses
setAlign : function (align) {
    this.align = align;
    if (this.isDrawn()) this.markForRedraw();
    if (this.label) this.label.setAlign(align);
},

setVAlign : function (valign) {
    this.valign = valign;
    if (this.isDrawn()) this.markForRedraw();
    if (this.label) this.label.setVAlign(valign);
},


// Printing
// --------------------------------------------------------------------------------------

// If we are showing a label default to printing it's text rather than
// our standard content (images etc)
getPrintHTML : function (a,b,c,d) {
    var useLabel = this.shouldShowLabel();
    if (useLabel) {
        if (this.label == null) {
            this.makeLabel();
        }
        return this.label.getPrintHTML(a,b,c,d);
    }
    return this.Super("getPrintHTML", arguments);

},

// Title handling
// ---------------------------------------------------------------------------------------

//> @method statefulCanvas.shouldHiliteAccessKey()
// Should the accessKey be underlined if present in the title for this button.
// Default implementation returns +link{StatefulCanvas.hiliteAccessKey}
//<
shouldHiliteAccessKey : function () {
    return this.hiliteAccessKey;
},


// If this widget has an accessKey, it will underline the first occurrence of the accessKey
// in the title (preferring Uppercase to Lowercase)
getTitleHTML : function () {

    var title = this.getTitle(true);

    // Title formatter
    // Implemented as a separate method for ease of SGWT wrapping
    title = this.formatTitle(this, title);

    if (!this.shouldHiliteAccessKey() || !isc.isA.String(title) || this.accessKey == null) {
        return title;
    }

    return isc.Canvas.hiliteCharacter(title, this.accessKey);
},

//> @method statefulCanvas.formatTitle()
// Formatter method to dynamically modify the title displayed by this component.
// @param component (StatefulCanvas) the StatefulCanvas for which the title will be displayed
// @param title (String) title returned by +link{statefulCanvas.getTitle()}
// @return (String) formatted title to display
// @visibility sgwt
//<
formatTitle : function (component, title) {
    return title;
},

//>    @method    statefulCanvas.getTitle()    (A)
// Return the title - HTML drawn inside the component.
// <p>
// Default is to simply return this.title.
// @return (HTMLString) HTML for the title.
// @visibility external
//<

getTitle : function () {
    return this.title;
},

//> @method statefulCanvas.setTitle()
// Setter for the +link{StatefulCanvas.title,title}.
// @param newTitle (HTMLString) the new title HTML.
// @group    appearance
// @visibility external
//<
setTitle : function (newTitle) {
    // remember the contents
    this.title = newTitle;
    // re-evaluation this.getTitle in case it's dynamic.
    var newTitle = this.getTitleHTML();
    // For performance, don't force a redraw / setContents, etc if the
    // title is unchanged
    if (this._titleHTML != null && this._titleHTML == newTitle) {
        return;
    } else {
        this._titleHTML = newTitle;
    }
    if (this.label) {

        if (this.label._redrawWithMaster && this.label.masterElement == this) this.label._dirty = true;
        this.label.setContents(newTitle);
        this.label.setState(this.getState());
        this.label.setSelected(this.isSelected());
    // if we didn't have a label before, lazily create it.
    } else if (this.title != null && this.shouldShowLabel()) {
        this.makeLabel()
    }

    // Update the ariaLabel to reflect our title (we do this regardless of whether we're
    // showing a title or not.
    if (isc.Canvas.ariaEnabled()) {
        var ariaLabel = this.getAriaLabel();
        if (ariaLabel != null) this.setAriaState("label", ariaLabel);
        else this.clearAriaState("label");
    }

    // redraw even if we have a title label.

    this.markForRedraw("setTitle");
},

// other Label management
// ---------------------------------------------------------------------------------------

// override setZIndex to ensure that this.label is always visible.
setZIndex : function (index,b,c) {

    isc.Canvas._instancePrototype.setZIndex.call(this, index,b,c);
    //this.Super("setZIndex", arguments);

    if (isc.isA.Canvas(this.label)) this.label.moveAbove(this);
},


// Override _updateCanFocus() update the focusability of the label too
_updateCanFocus : function () {
    this.Super("_updateCanFocus", arguments);
    if (this.label != null) this.label._updateCanFocus();
},

//> @method statefulCanvas.setIcon()
// Change the icon being shown next to the title text.
// @param icon (SCImgURL) URL of new icon
// @group buttonIcon
// @visibility external
//<
// NOTE: subclasses that show a Label use the label to show an icon.  Other subclasses (like
// Button) must override setIcon()
setIcon : function (icon) {
    this.icon = icon;
    if (this.label) this.label.setIcon(icon);
    // lazily create a label if necessary
    else if (icon && this.shouldShowLabel()) this.makeLabel();
},

//> @method statefulCanvas.setIconStyle()
// Setter for +link{StatefulCanvas.iconStyle}.
// @param iconStyle (CSSStyleName) the new <code>iconStyle</code> (may be <code>null</code> to
// remove the className on the image).
// @visibility external
//<
// NOTE: subclasses that show a Label use the label to reflect changes in the iconStyle. Other
// subclasses (like Button) must override setIcon().
setIconStyle : function (iconStyle) {
    this.iconStyle = iconStyle;
    if (this.label) this.label.setIconStyle(iconStyle);
},

// Mouse Event Handlers
// --------------------------------------------------------------------------------------------
// various mouse events will set the state of this object.

// implement mouseOver / mouseOut handlers to apply appropriate states to
// this widget.

handleMouseOver : function (event,eventInfo) {
    var rv;
    if (this.mouseOver != null) {
        rv = this.mouseOver(event, eventInfo);
        if (rv == false) return false;
    }
    this._doMouseOverStateChange();
    return rv;
},

// Should we apply "Over" / "Down" state in response to mouseOver / mouseDown
// (This may be disabled while leaving 'showRollOver:true' for cases where we
// want "down" styling etc but need a different model of when it gets applied.
// See Menubar for an example).
autoApplyOverState:true,
autoApplyDownState:true,
_doMouseOverStateChange : function () {

    if (this.ns.EH.mouseIsDown() && this.autoApplyDownState) {


        this.setState(isc.StatefulCanvas.STATE_DOWN);
    } else {
        if (this.autoApplyOverState) this.setState(isc.StatefulCanvas.STATE_OVER);
        if (this.showOverCanvas) {
            if (this.overCanvas == null) {
                this.addAutoChild("overCanvas", {
                    autoDraw:false
                });
            }
            this.overCanvas.moveAbove(this);
            if (!this.overCanvas.isDrawn()) this.overCanvas.draw();
        }
    }
},

// clear rollOver styling on mouseOut
handleMouseOut : function (event,eventInfo) {
    var rv;
    if (this.mouseOut != null) {
        rv = this.mouseOut(event, eventInfo);
        if (rv == false) return rv;
    }
    this._doMouseOutStateChange();
    return rv;
},

_doMouseOutStateChange : function (disabling) {
    if (this.autoApplyOverState) this.setState(isc.StatefulCanvas.STATE_UP);

    if (this.showOverCanvas && this.overCanvas != null && this.overCanvas.isVisible() &&
        (disabling || !this.overCanvas.contains(this.ns.EH.getTarget(), true)))
    {
        this.overCanvas.clear();
    }
},

// override the internal _focusChanged() method to set the state of the canvas to "over" on
// focus.  (Note - overriding this rather than the public 'focusChanged()' method so developers
// can still put functionality into that method without worrying about calling 'super').
_focusChanged : function (hasFocus,b,c,d) {

    var returnVal = this.invokeSuper(isc.StatefulCanvas, "_focusChanged", hasFocus,b,c,d);
    this.updateStateForFocus(hasFocus);

    return returnVal;
},

// Refresh our stateful appearance for a focus change

updateStateForFocus : function (hasFocus) {

    this.stateChanged();
    // Note: normally label styling etc will be updated by stateChanged() - but in this case
    // the other states are all unchanged so the label would not necessarily refresh to reflect
    // the focused state.
    if (this.label) this.label.stateChanged();

},

getFocusedAsOverState : function () {
    if (!this.showFocused || !this.showFocusedAsOver || this.isDisabled()) return false;
    return this.hasFocus;
},

// getFocusedState() - returns a boolean value for whether we should show the "Focused" state
getFocusedState : function () {
    if (this.isDisabled()) return false;
    return this.hasFocus;
},

//>    @method    statefulCanvas.handleMouseDown()    (A)
// MouseDown event handler -- show the button as down if appropriate
// calls this.mouseDown() if assigned
//    may redraw the button
//        @group    event
//<
handleMouseDown : function (event, eventInfo) {
    if (event.target == this && this.useEventParts) {
        if (this.firePartEvent(event, isc.EH.MOUSE_DOWN) == false) return false;
    }
    var rv;
    if (this.mouseDown) {
        rv = this.mouseDown(event, eventInfo);
        if (rv == false) return false;
    }
    if (this.autoApplyDownState && !this.isDisabled()) {
        this.setState(isc.StatefulCanvas.STATE_DOWN);
    }
    return rv;
},


//>    @method    statefulCanvas.handleMouseUp()    (A)
//        @group    event
//            mouseUp event handler -- if showing the button as down, reset to the 'up' state
//          calls this.mouseUp() if assigned
//<
handleMouseUp : function (event, eventInfo) {
    if (event.target == this && this.useEventParts) {
        if (this.firePartEvent(event, isc.EH.MOUSE_UP) == false) return false;
    }

    var rv;
    if (this.mouseUp) {
        rv = this.mouseUp(event, eventInfo);
        if (rv == false) return false;
    }

    var EH = this.ns.EH;

    if (this.autoApplyDownState) {
        // In desktop browsers, when the 'mouseup' event occurs on this StatefulCanvas, the mouse
        // cursor is still over the StatefulCanvas, so if showRollOver is true, go back to the
        // "Over" state. When the mouse cursor leaves this StatefulCanvas, then the 'mouseout'
        // handler will reset the state back to STATE_UP.
        //
        // On touch-enabled devices, the 'mouseout' event will not fire until the user next touches
        // something interactable on screen, possibly not for a very long time. So that we don't
        // leave the StatefulCanvas in the "Over" state, make sure the 'mouseup' event was not
        // fired in response to ending a touch event.
        this.setState(EH._handledTouch != EH._touchEventStatus.TOUCH_ENDING
                        ? isc.StatefulCanvas.STATE_OVER : isc.StatefulCanvas.STATE_UP);
    }
    return rv;
},





//>    @method    statefulCanvas.handleActivate() (A)
//      "Activate" this widget - fired from click or Space / Enter keypress.
//      Sets selection state of this widget if appropriate.
//      Calls this.activate stringMethod if defined
//      Otherwise calls this.click stringMethod if defined.
//      @group  event
//<
handleActivate : function (event, eventInfo) {
    var actionType = this.getActionType();
    if (actionType == isc.StatefulCanvas.RADIO) {
        // if a radio button, select this button
        this.select();

    } else if (actionType == isc.StatefulCanvas.CHECKBOX) {
        // if a checkbox, toggle the selected state
        this.setSelected(!this.isSelected());
    }

    // showMenuOnClick => show contextMenu and cancel propagation
    if (this.showMenuOnClick && this.showContextMenu) {
        if (this.showContextMenu(event) == false) return false;
    }

    if (this.activate) return this.activate(event, eventInfo);

    if (this.action) return this.action();
    if (this.click) return this.click(event, eventInfo);
},

//> @attr statefulCanvas.showMenuOnClick (Boolean : null : IRW)
// If true, this widget will fire +link{canvas.showContextMenu(),showContextMenu()} to
// show the +link{contextMenu,context menu} if one is defined, rather than
// +link{Canvas.click(),click()}, when the left mouse is clicked.
// <P>
// Note that this property has a different interpretation in +link{IconButton} as
// +link{iconButton.showMenuOnClick}.
// @group menu
// @visibility external
//<

//>    @method    statefulCanvas.handleClick()    (A)
//            click event handler -- falls through to handleActivate.
//          Note: Does not call 'this.click' directly - this is handled by handleActivate
//        @group    event
//<
handleClick : function (event, eventInfo) {
    if (isc._traceMarkers) arguments.__this = this;

    // This is required to handle icon clicks on buttons, etc
    if (event.target == this && this.useEventParts) {
        if (this.firePartEvent(event, isc.EH.CLICK) == false) return false;
    }
    return this.handleActivate(event,eventInfo);
},

//>    @method    statefulCanvas.handleKeyPress()    (A)
//            keyPress event handler.
//          Will call this.keyPress if defined on Space or Enter keypress, falls through
//          to this.handleActivate().
//        @group    event
//<
handleKeyPress : function (event, eventInfo) {
    if (isc._traceMarkers) arguments.__this = this;

    if (this.keyPress && (this.keyPress(event, eventInfo) == false)) return false;

    if (event.keyName == "Space" || event.keyName == "Enter") {
        if (this.handleActivate(event, eventInfo) == false) return false;
    }

    return true;

},

// -----------------------
// Helpers used by the Button class. Should we apply css border and shadow styling
// to the widget handle rather than applying it to the table cell?
shouldPushTableBorderStyleToDiv : function () {
    return isc.StatefulCanvas.shouldPushTableBorderStyleToDiv(this);
},

shouldPushTableShadowStyleToDiv : function () {
    return isc.StatefulCanvas.shouldPushTableShadowStyleToDiv(this);
},


// ---------------------------------------------------------------------------------------

// override destroy to removeFromRadioGroup - cleans up a class level pointer to this widget.
destroy : function () {
    this.removeFromRadioGroup();

    return this.Super("destroy", arguments);
}



});

// Add 'activate' as a stringMethod to statefulCanvii, with the same signature as 'click'
isc.StatefulCanvas.registerStringMethods({
    activate:isc.EH._eventHandlerArgString,  //"event, eventInfo"

    //> @method statefulCanvas.action()
    // This property contains the default 'action' for the Button to fire when activated.
    //<
    // exposed on the Button / ImgButton / StretchImgButton subclasses
    action:""
});

isc.StatefulCanvas.addClassMethods({

_$SelectedFocused:"SelectedFocused",
_$Selected:"Selected",
_$Focused:"Focused",
_getStateSuffix : function (state, selected, focused, customState) {
    var modifier;
    if (selected || focused) {
        modifier = (selected && focused) ? this._$SelectedFocused :
                       selected ? this._$Selected : this._$Focused;
    }
    if (!customState) {
        if (modifier) return state ? modifier + state : modifier;
        else return state;
    } else if (modifier) {
        return state ? modifier + state + customState : modifier + customState;
    } else {
        return state ? state + customState : customState;
    }
},

// build a properties object representing the border for supplied CSS class name
_buildBorderStyle : function (borderRadiusOnly, className) {

    // for performance, use cached border style results if present
    var classNameKey = borderRadiusOnly ? "$" + className : className;

    if (this._borderStyleCache[classNameKey]) {
        return this._borderStyleCache[classNameKey];
    }

    // if no cached results are present, we must recompute

    var maxProperties,
        borderStyle = {},
        setProperties = 0;

    // if widget has border specified, we need only propagate border radius
    maxProperties = borderRadiusOnly ? isc.StatefulCanvas._nRadiusBorderProperties :
                                       isc.StatefulCanvas._borderProperties.length;


    var styleInfo = isc.Element.getStyleEdges(className);

    if (styleInfo) {
        for(var j = 0; j < maxProperties; j++) {
            var prop = isc.StatefulCanvas._borderProperties[j];

            if (borderStyle[prop] == null && styleInfo[prop] != isc.emptyString) {
                borderStyle[prop] = styleInfo[prop];
            }
        }
    }
    this._borderStyleCache[classNameKey] = borderStyle;
    return borderStyle;
},

// build an HTML string representing the border for supplied CSS class name
_getBorderCSSHTML : function (borderRadiusOnly, className) {

    // for performance, use cached border CSS HTML results if present
    var classNameKey = borderRadiusOnly ? "$" + className : className;

    if (this._borderCSSHTMLCache[classNameKey]) {
       return this._borderCSSHTMLCache[classNameKey];
    }

    // if no cached results are present, we must recompute
    var borderStyle = this._buildBorderStyle(borderRadiusOnly, className);
    var cssText = isc.emptyString,
        separator = isc.StatefulCanvas._$separator;

    // build border style for each possibly different edge
    var bottom = isc.SB.concat(
        borderStyle.borderBottomWidth, separator,
        borderStyle.borderBottomStyle, separator,
        borderStyle.borderBottomColor).trim();

    var left = isc.SB.concat(
        borderStyle.borderLeftWidth, separator,
        borderStyle.borderLeftStyle, separator,
        borderStyle.borderLeftColor).trim();

    var right = isc.SB.concat(
        borderStyle.borderRightWidth, separator,
        borderStyle.borderRightStyle, separator,
        borderStyle.borderRightColor).trim();

    var top = isc.SB.concat(
        borderStyle.borderTopWidth, separator,
        borderStyle.borderTopStyle, separator,
        borderStyle.borderTopColor).trim();

    // apply border styles separately if necessary, otherwise as simple border
    if (bottom != left || bottom != right || bottom != top) {
        if (bottom != isc.emptyString) cssText += isc.semi + "BORDER-BOTTOM:" + bottom;
        if (left   != isc.emptyString) cssText += isc.semi + "BORDER-LEFT:"   + left;
        if (right  != isc.emptyString) cssText += isc.semi + "BORDER-RIGHT:"  + right;
        if (top    != isc.emptyString) cssText += isc.semi + "BORDER-TOP:"    + top;
    } else {
        if (bottom != isc.emptyString) cssText += isc.semi + "BORDER:" + bottom;
    }

    var bl = borderStyle.borderBottomLeftRadius,
        br = borderStyle.borderBottomRightRadius,
        tr = borderStyle.borderTopRightRadius,
        tl = borderStyle.borderTopLeftRadius;

    // apply border radius separately if necessary, otherwise as simple border radius
    if (bl != br || bl != tr || bl != tl) {
        if (bl != null) cssText += isc.semi + "BORDER-BOTTOM-LEFT-RADIUS:"  + bl;
        if (br != null) cssText += isc.semi + "BORDER-BOTTOM-RIGHT-RADIUS:" + br;
        if (tr != null) cssText += isc.semi + "BORDER-TOP-RIGHT-RADIUS:"    + tr;
        if (tl != null) cssText += isc.semi + "BORDER-TOP-LEFT-RADIUS:"     + tl;
    } else {
        if (bl != null) cssText += isc.semi + "BORDER-RADIUS:" + bl;
    }

    this._borderCSSHTMLCache[classNameKey] = cssText;
    return cssText;
},

// clear the cache of per-class name CSS border objects and HTML strings
clearBorderCSSCache : function () {
    this._borderStyleCache   = {};
    this._borderCSSHTMLCache = {};
},

// Similar logic for drop-shadows.
// These extend past the edges of the target element, so if we
// are applying styling to a table rendered within our handle, and our handle's overflow
// is hidden, we need to explicitly apply the shadow to the outer element.
_$boxShadowRegExp: new RegExp("(?:\\([^)]*\\)|[^,])+", "g"),
_buildShadowStyle : function (className, referenceElement, insetOnly) {

    var classNameKey = className;

    // store separate cache entries for inset only values
    if (insetOnly) classNameKey += "_inset";

    if (this._shadowStyleCache[classNameKey]) {
        return this._shadowStyleCache[classNameKey];
    }

    // We have just a single property to worry about - "boxShadow", so we could just
    // cache a string here. Using an object just in case we find we encounter other
    // css attributes which extend outside the box as shadows do for which we need to
    // apply the same workarounds.
    var shadowStyle = {},
        property = "boxShadow";

    var styleInfo = isc.Element.getStyleEdges(className);
    // if there's no style object, just bail
    if (!styleInfo) return "";

    shadowStyle.boxShadow = styleInfo.boxShadow;

    // Filter out inner box shadows (those specified with the 'inset' keyword).
    if (shadowStyle.boxShadow != null && shadowStyle.boxShadow.indexOf("inset") >= 0) {

        var shadowDefs = shadowStyle.boxShadow.match(this._$boxShadowRegExp).callMethod("trim"),
            numShadowDefs = shadowDefs.length,
            insetShadowDefs = [],
            outsetShadowDefs = [],
            k = 0
        ;
        for (var i = 0; i < numShadowDefs; ++i) {
            var shadowDef = shadowDefs[i];

            if (shadowDef.startsWith("inset") || shadowDef.endsWith("inset")) {
                insetShadowDefs.add(shadowDef);
            } else {
                outsetShadowDefs.add(shadowDef);
            }
        }
        shadowDefs = insetOnly ? insetShadowDefs : outsetShadowDefs;
        shadowStyle.boxShadow = shadowDefs.join(", ");

    }
    this._shadowStyleCache[classNameKey] = shadowStyle;
    return shadowStyle;
},

// build an HTML string representing the shadow for supplied CSS class name
_getShadowCSSHTML : function (className) {

    // for performance, use cached border CSS HTML results if present
    var classNameKey = className;

    var undef;
    if (this._shadowStyleCSSHTMLCache[classNameKey] !== undef) {
        return this._shadowStyleCSSHTMLCache[classNameKey];
    }

    // if no cached results are present, we must recompute
    var shadowStyle = this._buildShadowStyle(className);

    var cssText;
    if (shadowStyle.boxShadow == null) cssText = isc.emptyString;
    else cssText = "box-shadow:" + shadowStyle.boxShadow + ";";

    this._shadowStyleCSSHTMLCache[classNameKey] = cssText;

    return cssText;
},

// clear the cache of per-class name CSS shadow objects and HTML strings
clearShadowCSSCache : function () {
    this._shadowStyleCache   = {};
    this._shadowStyleCSSHTMLCache = {};
},

// shouldPushTableBorderStyleToDiv()


shouldPushTableShadowStyleToDiv : function (widget) {
    if (isc.StatefulCanvas.pushTableShadowStyleToDiv != null) {
        return isc.StatefulCanvas.pushTableShadowStyleToDiv;
    }

    if (widget && widget._getHandleOverflow() != isc.Canvas.VISIBLE) {
        return true;
    }

    if (this._boxShadowImpactsButtonScrollSize == null) {
        var _boxShadowScrollSizeTester = isc.Canvas.create({
            _generated:true,
            autoDraw:false,

            _fontLoaderIgnore:true,
            // Position it offscreen
            left:-500,
            top:-500,
            contents:'<table style="width:100px;height:100px;"><tr><td style="box-shadow:0 0 0 5px red;">x</td></tr></table>'
        });

        _boxShadowScrollSizeTester.draw();

        var reportedHeight = _boxShadowScrollSizeTester.getScrollHeight(),
            reportedWidth = _boxShadowScrollSizeTester.getScrollHeight();

        if (reportedHeight > 100 || reportedWidth > 100) {

            this._boxShadowImpactsButtonScrollSize = true;
        } else {
            this._boxShadowImpactsButtonScrollSize = false;
        }
        _boxShadowScrollSizeTester.markForDestroy();
    }
    return this._boxShadowImpactsButtonScrollSize;
},

// shouldPushTableBorderStyleToDiv()


shouldPushTableBorderStyleToDiv : function (widget) {
    return isc.StatefulCanvas.pushTableBorderStyleToDiv
            || isc.StatefulCanvas.shouldPushTableShadowStyleToDiv(widget);
}

});




//>    @class    Layout
//
// Arranges a set of "member" Canvases in horizontal or vertical stacks, applying a layout
// policy to determine member heights and widths.
// <P>
// A Layout manages a set of "member" Canvases provided as +link{layout.members}.  Layouts
// can have both "members", whose position and size are managed by the Layout, and normal
// Canvas children, which manage their own position and size.
// <P>
// Rather than using the Layout class directly, use the +link{HLayout}, +link{VLayout},
// +link{HStack} and +link{VStack} classes, which are subclasses of Layout preconfigured for
// horizontal or vertical stacking, with the "fill" (VLayout) or "none" (VStack)
// +link{type:LayoutPolicy,policies} already set.
// <P>
// Layouts and Stacks may be nested to create arbitrarily complex layouts.
// <p>
// Since Layouts can be either horizontally or vertically oriented, throughout the
// documentation of Layout and it's subclasses, the term "length" refers to the axis of
// stacking, and the term "breadth" refers to the other axis.  Hence, "length" means height in
// the context of a VLayout or VStack, but means width in the context of an HLayout or HStack.
// <P>
// To show a resizer bar after (to the right or bottom of) a layout member, set
// +link{canvas.showResizeBar,showResizeBar} to
// true on that member component (not on the HLayout or VLayout).  Resizer bars override
// +link{layout.membersMargin,membersMargin} spacing.
// <P>
// Like other Canvas subclasses, Layout and Stack components may have % width and height
// values. To create a dynamically-resizing layout that occupies the entire page (or entire
// parent component), set width and height to "100%".
//
// @inheritsFrom Canvas
// @see type:LayoutPolicy for available policies
// @see class:VLayout
// @see class:HLayout
// @see class:VStack
// @see class:HStack
// @see class:LayoutSpacer
// @treeLocation Client Reference/Layout
// @visibility external
//<

isc.ClassFactory.defineClass("Layout","Canvas");


isc.Layout.addClassProperties({
    //> @type   Orientation
    //          @group  orientation
    // @visibility external
    // @value  isc.Layout.VERTICAL members laid out vertically
    // @value  isc.Layout.HORIZONTAL members laid out horizontally
    //<

    //> @classAttr Layout.VERTICAL (Constant : "vertical" : [R])
    // A declared value of the enum type
    // +link{type:Orientation,Orientation}.
    // @visibility external
    // @constant
    //<
    //VERTICAL:"vertical", // NOTE: constant declared by Canvas

    //> @classAttr Layout.HORIZONTAL (Constant : "horizontal" : [R])
    // A declared value of the enum type
    // +link{type:Orientation,Orientation}.
    // @visibility external
    // @constant
    //<
    //HORIZONTAL:"horizontal", // NOTE: constant declared by Canvas


    //> @type LayoutPolicy
    // Policy controlling how the Layout will manage member sizes on this axis.
    // <P>
    // Note that, by default, Layouts do <i>not</i> automatically expand the size of all members
    // to match a member that overflows the layout on the breadth axis.  This means that a
    // +link{DynamicForm} or other component that can't shrink beyond a minimum width will
    // "stick out" of the Layout, wider than any other member and wider than automatically
    // generated components like resizeBars or sectionHeaders (in a +link{SectionStack}).
    // <P>
    // This is by design: matching the size of overflowing members would cause expensive redraws
    // of all members in the Layout, and with two or more members potentially overflowing, could
    // turn minor browser size reporting bugs or minor glitches in custom components into
    // infinite resizing loops.
    // <P>
    // If you run into this situation, you can either:<ul>
    // <li>set the overflowing member to +link{Canvas.overflow, overflow}: "auto", so that it
    // scrolls if it needs more space
    // <li>set the Layout as a whole to +link{Canvas.overflow, overflow}:"auto", so that the
    // whole Layout scrolls when the member overflows
    // <li>define a +link{Canvas.resized(), resized()} handler to manually update the breadth
    // of the layout
    // <li>set +link{Layout.minBreadthMember} to ensure that the available breadth used to
    // expand all (other) members is artificially increased to match the current breadth of the
    // <code>minBreadthMember</code> member; the layout will still be overflowed in this case
    // and the reported size from +link{Canvas.getWidth} or +link{Canvas.getHeight} won't
    // change, but all members should fill the visible width or height along the breadth axis
    // </ul><P>
    // For the last approach, given the VLayout <code>myLayout</code> and a member <code>
    // myWideMember</code>, then we could define the following +link{Canvas.resized(),
    // resized()} handler on <code>myLayout</code>:
    // <smartclient>
    // <pre>
    // resized : function () {
    //     var memberWidth = myWideMember.getVisibleWidth();
    //     this.setWidth(Math.max(this.getWidth(), memberWidth + offset));
    // }</pre></smartclient><smartgwt>
    // <pre>
    // myLayout.addResizedHandler(new ResizedHandler() {
    //     &#64;Override
    //     public void onResized(ResizedEvent event) {
    //         int memberWidth = myWideMember.getVisibleWidth();
    //         myLayout.setWidth(Math.max(myLayout.getWidth(), memberWidth + offset));
    // }</pre>
    // </smartgwt>
    // where <code>offset</code> reflects the difference in width (due to margins, padding,
    // etc.) between the layout and its widest member.  In most cases, a fixed offset can
    // be used, but it can also be computed via the calculation:
    // <P>
    // <pre>
    //     myLayout.getWidth() - myLayout.getViewportWidth()
    // </pre>
    // <smartclient>in an override of +link{Canvas.draw(), draw()}</smartclient><smartgwt>by
    // adding a {@link com.smartgwt.client.widgets.Canvas#addDrawHandler draw handler}</smartgwt>
    // for <code>myLayout</cOde>.  (That calculation is not always valid inside the
    // +link{Canvas.resized(), resized()} handler itself.)
    // <P>
    // Note: the HLayout case is similar- just substitute height where width appears above.
    // <P>
    // See also +link{layout.overflow}.
    //
    //  @value  isc.Layout.NONE
    //  Layout does not try to size members on the axis at all, merely stacking them (length
    //  axis) and leaving them at default breadth.
    //
    //  @value  isc.Layout.FILL
    //  Layout sizes members so that they fill the specified size of the layout.  The rules
    //  are:
    //  <ul>
    //  <li> Any component given an initial pixel size, programmatically resized to a specific
    //  pixel size, or drag resized by user action is left at that exact size
    //  <li> Any component that +link{button.autoFit,autofits} is given exactly the space it
    //  needs, never forced to take up more.
    //  <li> All other components split the remaining space equally, or according to their
    //  relative percentages.
    //  <li> Any component that declares a +link{canvas.minWidth} or +link{canvas.minHeight}
    //  will never be sized smaller than that size
    //  <li> Any component that declares a +link{canvas.maxWidth} or +link{canvas.maxHeight}
    //  will never be sized larger than that size
    //  </ul>
    //  In addition, components may declare that they have
    //  +link{canvas.canAdaptWidth,adaptive sizing}, and may coordinate with the Layout to render
    //  at different sizes according to the amount of available space.
    //
    // @see Layout.minBreadthMember
    // @visibility external
    //<

    //> @classAttr Layout.NONE (Constant : "none" : [R])
    // A declared value of the enum type
    // +link{type:LayoutPolicy,LayoutPolicy}.
    // @visibility external
    // @constant
    //<
    //NONE:"none", // NOTE: constant declared by Canvas

    //> @classAttr Layout.FILL (Constant : "fill" : [R])
    // A declared value of the enum type
    // +link{type:LayoutPolicy,LayoutPolicy}.
    // @visibility external
    // @constant
    //<
    FILL:"fill",


    _animateHSlideEffect: {
        effect:"slide", startFrom:"L", endAt:"L"
    },

    reflowOnTEA : function (layout, reason) {

        // remember in the current reflowCount so we don't do an extra reflow if reflowNow() is
        // called before the timer fires (happens every time with TEAs, since
        // EH._setThreadExitAction() sets up the TEA AND sets a timer in case
        // the TEA fails to fire, and can happen if reflowNow() is called
        // explicitly)
        var layoutInfo = {
                theLayout:layout,
                reflowCount:layout._reflowCount,
                reason:reason
        };
        if (this.reflowQueue == null) this.reflowQueue = [];
        var reflowQueue = this.reflowQueue;
        for (var i = 0; i < reflowQueue.length; i++) {
            // If we already have an entry in the queue, clear it - the more recent
            // reflow call takes precedence.

            if (reflowQueue[i] != null && reflowQueue[i].theLayout == layout) {
                reflowQueue[i] = null;
            }
        }
        this.reflowQueue.add(layoutInfo);

        if (!this.reflowTEASet) {
            isc.EH._setThreadExitAction(function () {
                isc.Layout.clearReflowQueue();
            });
            this.reflowTEASet = true;
        }
    },

    clearReflowQueue : function () {
        // Clear the flag before doing anything else. That way if below code actually
        // causes a new reflow() call on another layout we'll correctly set up a new TEA for it.
        this.reflowTEASet = false;

        var queue = this.reflowQueue;
        // Clear the reflowQueue attribute now (that way if code below trips a new reflow() call we
        // won't modify the array we're currently working our way through!)
        this.reflowQueue = null;

        if (queue == null) return;

        for (var i = 0; i < queue.length; i++) {
            if (queue[i] == null) continue; // may have been cleared above
            var theLayout = queue[i].theLayout,
                reflowCount = queue[i].reflowCount,
                reason = queue[i].reason;

            //isc.logWarn("reflowing " + theLayout + " at end of thread");
            if (!theLayout.destroyed) {
                // reflowNow would no-op anyway in this condition,
                // but let's avoid the unnecessary function call
                if (reflowCount != null && reflowCount < theLayout._reflowCount) continue;
                theLayout.reflowNow(reason, reflowCount);
            }
        }
    }
});

isc.Layout.addProperties({
    //> @attr layout.members    (Array of Canvas : null : [IRW])
    // An array of canvases that will be contained within this layout. You can set the
    // following properties on these canvases (in addition to the standard component
    // properties):
    // <ul>
    //  <li>+link{canvas.layoutAlign,layoutAlign} -- specifies the member's alignment along the
    //      breadth axis; valid values are "top", "center" and "bottom" for a horizontal layout
    //      and "left", "center" and "right" for a vertical layout (see
    //      +link{layout.defaultLayoutAlign} for default implementation.)
    //  <li>+link{canvas.showResizeBar,showResizeBar} -- set to true to show a resize bar
    //      (default is false)
    // </ul>
    // Height and width settings found on members are interpreted by the Layout according to
    // the +link{layout.vPolicy,layout policy}.
    // <p>
    // Note that it is valid to have null slots in the provided <code>members</code> Array,
    // and the Layout will ignore those slots. This can be useful to keep code compact, for
    // example, when constructing the <code>members</code> Array, you might use an expression
    // that either returns a component or null depending on whether the component should be
    // present. If the expression returns null, the null slot will be ignored by the Layout.
    //
    // @visibility external
    //<

    // Policy
    // ---------------------------------------------------------------------------------------

    //> @attr layout.overflow   (Overflow : "visible" : IRW)
    // A Layout may overflow if it has one or more members with a fixed width or height, or that
    // themselves overflow.  For details on member sizing see +link{layoutPolicy}.
    // <P>
    // Note that for overflow: "auto", "scroll", or "visible", members exceeding the Layout's
    // specified breadth but falling short of its overflow breadth will keep the alignment set
    // via +link{defaultLayoutAlign} or +link{canvas.layoutAlign}.
    //
    // @see canvas.overflow
    // @see minBreadthMember
    // @group layoutPolicy
    // @visibility external
    //<

    //> @attr layout.orientation    (Orientation : "horizontal" : AIRW)
    // Orientation of this layout.
    // @group layoutPolicy
    // @visibility external
    // @deprecated in favor of +link{layout.vertical,this.vertical}, which, if specified takes
    //  precedence over this setting
    //<
    orientation:"horizontal",

    //> @attr layout.vertical (boolean : null : IRW)
    // Should this layout appear with members stacked vertically or horizontally. Defaults to
    // <code>false</code> if unspecified.
    // @group layoutPolicy
    // @visibility external
    //<
    // Not specified by default as this would change behavior of subclasses that make use of
    // the orientation setting instead.
    // Actually 'defaults to false if unspecified' isn't quite true -- it defaults to the
    // orientation setting but that's deprecated.

    //> @attr layout.vPolicy    (LayoutPolicy : "fill" : IRWA)
    // Sizing policy applied to members on vertical axis
    // @group layoutPolicy
    // @visibility external
    //<
    vPolicy:isc.Layout.FILL,

    //> @attr layout.hPolicy    (LayoutPolicy : "fill" : IRWA)
    // Sizing policy applied to members on horizontal axis
    // @group layoutPolicy
    // @visibility external
    //<
    hPolicy:isc.Layout.FILL,

    //> @attr layout.minMemberSize (int : 1 : IRW)
    // See +link{minMemberLength}.
    //
    // @group layoutPolicy
    // @deprecated use the more intuitively named +link{minMemberLength}
    // @visibility external
    //<
    minMemberSize: 1,

    //> @attr layout.minMemberLength (int : 1 : IRW)
    // Minimum size, in pixels, below which flexible-sized members should never be shrunk, even
    // if this requires the Layout to overflow.  Note that this property only applies along
    // the <i>length</i> axis of the Layout, and has no affect on <i>breadth</i>.
    // <p>
    // Does not apply to members given a fixed size in pixels - such members will never be
    // shrunk below their specified size in general.
    //
    // @see Canvas.minWidth
    // @group layoutPolicy
    // @visibility external
    //<
    minMemberLength: 1,

    //> @attr layout.minMemberBreadth (int : null : IRW)
    // Minimum size, in pixels, below which members being managed on the breadth axis should
    // never be shrunk, even if this results in overflow or clipping.  (If +{LayoutPolicy}
    // for an axis is "none" the members are not managed along that axis.)
    // <p>
    // Does not apply to members given a fixed size in pixels - such members will never be
    // shrunk below their specified size in general.
    //
    // @see Layout.overflow
    // @see defaultLayoutAlign
    // @group layoutPolicy
    //<
    minMemberBreadth: null, // null allows simpler handling than leaving it undefined

    //> @attr layout.minBreadthMember (String | int | Canvas : null : IRWA)
    // Set this property to cause the layout to assign the breadths of other members as if the
    // available breadth is actually wide enough to accommodate the
    // <code>minBreadthMember</code> (even though the Layout might <i>not</i> actually be that
    // wide, and may overflow its assigned size along the breadth axis due to the breadth of the
    // <code>minBreadthMember</code>.
    // <P>
    // Without this property set, members of a layout aren't ever expanded in breadth (by the
    // layout) to fit an overflow of the layout along the breadth axis.  Setting this property
    // will make sure all members (other than the one specified) get expanded to fill the full
    // visual breadth of the layout (assuming they are configured to use 100% layout breadth).
    //
    // @see type:LayoutPolicy
    // @visibility external
    //<

    //> @attr layout.enforcePolicy (Boolean : true : IRWA)
    // Whether the layout policy is continuously enforced as new members are added or removed
    // and as members are resized.
    // <p>
    // This setting implies that any member that resizes larger, or any added member, will take
    // space from other members in order to allow the overall layout to stay the same size.
    // @group layoutPolicy
    // @visibility external
    //<
    enforcePolicy:true,

    //> @attr layout.defaultLayoutAlign (Alignment | VerticalAlignment : null : IRW)
    // Specifies the default alignment for layout members on the breadth axis (horizontal axis
    // for a VLayout, vertical axis for an HLayout).  Can be overridden on a per-member basis
    // by setting +link{canvas.layoutAlign}.
    // <P>
    // If unset, default member layout alignment will be "top" for a horizontal layout, and
    // "left" for a vertical layout, or "right" if in +link{Page.isRTL(),RTL} mode.
    // <P>
    // When attempting to center components be sure that you have set a specific size on the
    // component(s) involved.  If components fill all available space in the layout, centering
    // looks the same as not centering.
    // <P>
    // Similarly, if a component has no visible boundary (like a border), it can appear similar
    // to when it's not centered if the component is larger than you expect - use the Watch tab
    // in the Developer Console to see the component's extents visually.
    //
    // @group layoutMember
    // @group layoutPolicy
    // @see Layout.overflow
    // @visibility external
    // @example layoutCenterAlign
    //<

    //> @attr layout.align (Alignment | VerticalAlignment : null : IRW)
    // Alignment of all members in this Layout on the length axis (vertical for a VLayout,
    // horizontal for an HLayout).  Defaults to "top" for vertical Layouts, and "left" for
    // horizontal Layouts.
    // <p>
    // Horizontal layouts should only be set to +link{Alignment}, and vertical layouts to
    // +link{VerticalAlignment}, otherwise they will be considered invalid values, and assigning an
    // invalid value here will log a warning to the Developer Console.
    // <P>
    // For alignment on the breadth axis, see +link{defaultLayoutAlign} and
    // +link{canvas.layoutAlign}.
    // <P>
    // When attempting to center components be sure that you have set a specific size on the
    // component(s) involved.  If components fill all available space in the layout, centering
    // looks the same as not centering.
    // <P>
    // Similarly, if a component has no visible boundary (like a border), it can appear similar
    // to when it's not centered if the component is larger than you expect - use the Watch tab
    // in the Developer Console to see the component's extents visually.
    //
    // @group layoutPolicy
    // @visibility external
        // @example layoutCenterAlign
    //<
    //align:null,
    // NB: you can achieve the same effect with a LayoutSpacer in the first slot, but that
    // throws off member numbering

    //> @attr layout.reverseOrder   (Boolean : false : IRW)
    // Reverse the order of stacking for this Layout, so that the last member is shown first.
    // <P>
    // Requires a manual call to <code>reflow()</code> if changed on the fly.
    // <P>
    // In RTL mode, for horizontal Layouts the value of this flag will be flipped during
    // initialization.
    // @group layoutPolicy
    // @visibility external
    //<

    // Margins and Spacing
    // ---------------------------------------------------------------------------------------

    //> @attr layout.paddingAsLayoutMargin (Boolean : true : IRWA)
    // If this widget has padding specified (as +link{canvas.padding, this.padding} or in the
    // CSS style applied to this layout), should it show up as space outside the members,
    // similar to layoutMargin?
    // <P>
    // If this setting is false, padding will not affect member positioning (as CSS padding
    // normally does not affect absolutely positioned children).  Leaving this setting true
    // allows a designer to more effectively control layout purely from CSS.
    // <P>
    // Note that +link{layout.layoutMargin} if specified, takes precedence over this value.
    // @group layoutMargin
    // @visibility external
    //<
    paddingAsLayoutMargin:true,



    //> @attr layout.layoutMargin (Integer : null : [IRW])
    // Space outside of all members. This attribute, along with +link{layout.layoutLeftMargin}
    // and related properties do not have a true setter method.
    // <smartclient>
    // It may be assigned directly at runtime.  After setting the property,
    // +link{layout.setLayoutMargin()} may be called with no arguments to reflow the layout.
    // </smartclient><smartgwt>
    // If this method is called after the layout instance has been created, it will force a
    // reflow of the layout and pick up changes to all of the layout*Margin properties.
    // </smartgwt>
    // @see layoutLeftMargin
    // @see layoutRightMargin
    // @see layoutBottomMargin
    // @see layoutTopMargin
    // @see paddingAsLayoutMargin
    // @setter noauto
    // @group layoutMargin
    // @visibility external
    // @example userSizing
    //<
//    layoutMargin:null,

    //> @attr layout.layoutLeftMargin (Integer : null : [IRW])
    // Space outside of all members, on the left-hand side.  Defaults to +link{layoutMargin}.
    // <P>
    // Requires a manual call to <code>setLayoutMargin()</code> if changed on the fly.
    // @group layoutMargin
    // @visibility external
    //<

    //> @attr layout.layoutRightMargin (Integer : null : [IRW])
    // Space outside of all members, on the right-hand side.  Defaults to +link{layoutMargin}.
    // <P>
    // Requires a manual call to <code>setLayoutMargin()</code> if changed on the fly.
    // @group layoutMargin
    // @visibility external
    //<

    //> @attr layout.layoutTopMargin (Integer : null : [IRW])
    // Space outside of all members, on the top side.  Defaults to +link{layoutMargin}.
    // <P>
    // Requires a manual call to <code>setLayoutMargin()</code> if changed on the fly.
    // @group layoutMargin
    // @visibility external
    //<

    //> @attr layout.layoutBottomMargin (Integer : null : [IRW])
    // Space outside of all members, on the bottom side.  Defaults to +link{layoutMargin}.
    // <P>
    // Requires a manual call to <code>setLayoutMargin()</code> if changed on the fly.
    // @group layoutMargin
    // @visibility external
    //<

    //> @attr layout.membersMargin (int : 0 : [IRW])
    // Space between each member of the layout.
    // <P>
    // Requires a manual call to <code>reflow()</code> if changed on the fly.
    // @group layoutMargin
    // @visibility external
    // @example userSizing
    //<
    membersMargin:0,

    //> @attr layout.leaveScrollbarGap (Boolean : false : IR)
    // Whether to leave a gap for a vertical scrollbar even when one is not actually present.
    // <P>
    // This setting avoids the layout resizing all members when the vertical scrollbar is
    // introduced or removed, which can avoid unnecessary screen shifting and improve
    // performance.
    //
    // @visibility external
    //<

    //> @attr layout.memberOverlap (PositiveInteger : 0 : IR)
    // Number of pixels by which each member should overlap the preceding member, used for
    // creating an "stack of cards" appearance for the members of a Layout.
    // <P>
    // <code>memberOverlap</code> can be used in conjunction with +link{stackZIndex} to create
    // a particular visual stacking order.
    // <P>
    // Note that overlap of individual members can be accomplished with a negative setting for
    // +link{canvas.extraSpace}.
    //
    // @group layoutMember
    // @visibility external
    //<

    //> @attr layout.layoutStartMargin (Integer : null : [IRW])
    // Equivalent to +link{layoutLeftMargin} for a horizontal layout, or +link{layoutTopMargin}
    // for a vertical layout.
    // <p>
    // If both <code>layoutStartMargin</code> and the more specific properties (top/left margin)
    // are both set, the more specific properties win.
    // @visibility external
    //<

    //> @attr layout.layoutEndMargin (Integer : null : [IRW])
    // Equivalent to +link{layoutRightMargin} for a horizontal layout, or +link{layoutBottomMargin}
    // for a vertical  layout.
    // <p>
    // If both <code>layoutEndMargin</code> and the more specific properties (right/bottom margin)
    // are both set, the more specific properties win.
    // @visibility external
    //<

    // ResizeBars
    // ---------------------------------------------------------------------------------------

    //> @type LayoutResizeBarPolicy
    // Policy for whether resize bars are shown on members by default.
    //
    // @value "marked" resize bars are only shown on members marked
    //                 +link{canvas.showResizeBar,showResizeBar:true}
    // @value "middle" resize bars are shown on all resizable members that are not explicitly marked
    //              showResizeBar:false, except the last member.  Appropriate for a
    //              +link{LayoutPolicy} of "fill" (VLayout, HLayout) since the overall space will
    //              always be filled.
    // @value "all" resize bars are shown on all resizable members that are not explicitly marked
    //              showResizeBar:false, including the last member.  Can be appropriate for a
    //              +link{LayoutPolicy} of "none" (VStack, HStack) since the overall size of the
    //              layout is dictated by it's member's sizes.
    // @value "none" resize bars are not shown even if members are marked with
    //                 +link{canvas.showResizeBar,showResizeBar:true}
    //
    // @visibility external
    //<

    //> @attr layout.defaultResizeBars (LayoutResizeBarPolicy : "marked" : IRW)
    // Policy for whether resize bars are shown on members by default. Note that this setting
    // changes the effect of +link{canvas.showResizeBar} for members of this layout.
    //
    // @see canvas.showResizeBar
    // @visibility external
    //<
    defaultResizeBars: "marked",

    setDefaultResizeBars : function (resizeBars) {
        if (this.defaultResizeBars == resizeBars) return;
        this.defaultResizeBars = resizeBars;
        this._computeShowResizeBarsForMembers();
    },

    //> @attr layout.resizeBar (MultiAutoChild Splitbar : see below : A)
    // A MultiAutoChild created to resize members of this <code>Layout</code>.
    // <p>
    // A resize bar will be created for any member of this <code>Layout</code> that has
    // +link{Canvas.showResizeBar,showResizeBar} set to <code>true</code>. Resize bars will be
    // instances of the class specified by +link{Layout.resizeBarClass} by default, and will
    // automatically be sized to the member's breadth, and to the thickness specified by
    // +link{Layout.resizeBarSize}.
    // <p>
    // To customize the appearance or behavior of resizeBars within some layout a custom
    // resize bar class can be created by subclassing +link{Splitbar} or +link{ImgSplitbar} and
    // setting +link{Layout.resizeBarClass} or <code>resizeBarConstructor</code> to this custom class.
    // <smartclient>
    // Alternatively, <code>resizeBarProperties</code> may be specified. See +link{group:autoChildUsage}
    // for more information.
    // </smartclient>
    // <smartgwt>
    // Alternatively, {@link com.smartgwt.client.widgets.Canvas#setAutoChildProperties(java.lang.String, com.smartgwt.client.widgets.Canvas)}
    // may be called to set resizeBar properties:
    // <pre>
    //     final Splitbar resizeBarProperties = new Splitbar();
    //     //...
    //     layout.setAutoChildProperties("resizeBar", resizeBarProperties);
    // </pre>
    // See +link{group:autoChildUsage} for more information.
    // <p>
    // If you create a custom resize bar class in Java, enable +link{group:reflection} to
    // allow it to be used.
    // <p>
    // Alternatively, you can use the &#83;martClient class system to create a simple
    // &#83;martClient subclass of either <code>Splitbar</code> or <code>ImgSplitbar</code>
    // for use with this API - see the +link{group:skinning,Skinning Guide} for details.
    // </smartgwt>
    // <p>
    // The built-in <code>Splitbar</code> class supports drag resizing of its target member,
    // and clicking on the bar with a mouse to collapse/uncollapse the target member.
    // @visibility external
    //<

    resizeBarDefaults: {
        dragScrollType: "parentsOnly"
    },

    //> @attr layout.resizeBarClass (String : "Splitbar" : AIRW)
    // Default class to use for creating +link{Layout.resizeBar,resizeBars}. This may be
    // overridden by <code>resizeBarConstructor</code>.
    // <p>
    // Classes that are valid by default are +link{Splitbar}, +link{ImgSplitbar}, and
    // +link{Snapbar}.
    //
    // @see class:Splitbar
    // @see class:ImgSplitbar
    // @visibility external
    //<
    resizeBarClass:"Splitbar",


    //> @attr layout.resizeBarSize (int : 7 : AIRW)
    // Thickness of the resizeBar in pixels.
    // @visibility external
    //<
    resizeBarSize:7,

    //>Animation
    // ---------------------------------------------------------------------------------------

    //> @attr layout.animateMembers (boolean : null : IRW)
    // If true when members are added / removed, they should be animated as they are shown
    // or hidden in position
    // @group animation
    // @visibility animation
    // @example animateLayout
    //<

    //> @attr layout.animateMemberEffect (String : "slide" : IRW)
    // Animation effect for hiding and showing members when animateMembers is true.
    // @group animation
    // @visibility internal
    //<
    animateMemberEffect:"slide",

    //> @method canvas.setAnimateMemberEffect()
    // Setter for +link{animateMemberEffect}.
    //<
    setAnimateMemberEffect : function (effect) {
        // override "slide" for HLayouts to perform horizontal rather than vertical animation
        this.animateMemberEffect = !this.vertical && effect == "slide" ?
                                   isc.Layout._animateHSlideEffect : effect;
    },

    //> @attr layout.animateMemberTime (number : null : IRWA)
    // If specified this is the duration of show/hide animations when members are being shown
    // or hidden due to being added / removed from this layout.
    // @group animation
    // @visibility animation
    //<

    //> @attr layout.suppressMemberAnimations (boolean : null : IRWA)
    // If true, when a member starts to perform an animated resize, instantly finish the
    // animation rather than reflowing the Layout on each step of the animation.
    // @group animation
    //<

    //<Animation

    // Drag and Drop
    // ---------------------------------------------------------------------------------------

    //> @attr layout.canDropComponents (Boolean : true : IRA)
    // Layouts provide a default implementation of a drag and drop interaction.  If you set
    // +link{Canvas.canAcceptDrop,canAcceptDrop}:true and <code>canDropComponents:true</code>
    // on a Layout, when a droppable Canvas (+link{canvas.canDrop,canDrop:true} is dragged over
    // the layout, it will show a dropLine (a simple insertion line) at the drop location.
    // <P>
    // When the drop occurs, +link{getDropComponent()} is invoked to determine which
    // component should be added to the layout as a member at the location calculated
    // by +link{Layout.getDropPosition()}. By default this method will return
    // the current drag target. This default
    // behavior allows existing members to be reordered or external components that have
    // +link{Canvas.canDragReposition} (or +link{Canvas.canDrag}) and +link{Canvas.canDrop} set
    // to <code>true</code> to be added to the Layout.
    // <P>
    // You can control the thickness of the dropLine via +link{Layout.dropLineThickness} and
    // you can customize the style using css styling in the skin file (look for .layoutDropLine
    // in skin_styles.css for your skin).
    // <P>
    // If you want to dynamically create a component to be added to the Layout in response to a
    // drop event you can override +link{getDropComponent()}, or for entirely custom behavior
    // override the +link{drop(),drop event handler} as follows:
    // <smartclient>
    // <pre>
    // isc.VLayout.create({
    //   ...various layout properties...
    //   canDropComponents: true,
    //   drop : function () {
    //     // create the new component
    //     var newMember = isc.Canvas.create();
    //     // add to the layout at the current drop position
    //     // (the dropLine will be showing here)
    //     this.addMember(newMember, this.getDropPosition());
    //     // hide the dropLine that was automatically shown
    //     // by builtin SmartClient methods
    //     this.hideDropLine();
    //   }
    // });
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //  final VLayout vLayout = new VLayout();
    //  //...various layout properties...
    //  vLayout.setCanDropComponents(true);
    //  vLayout.addDropHandler(new DropHandler() {
    //      &#64;Override
    //      public void onDrop(DropEvent event) {
    //          // create the new component
    //          Canvas newMember = new Canvas();
    //          // add to the layout at the current drop position
    //          // (the dropLine will be showing here)
    //          vLayout.addMember(newMember, vLayout.getDropPosition());
    //          // hide the dropLine that was automatically shown
    //          // by builtin SmartGWT methods
    //          vLayout.hideDropLine();
    //      }
    //  });
    // </pre>
    // </smartgwt>
    // If you want to completely suppress the builtin drag and drop logic, but still receive drag
    // and drop events for your own custom implementation, set +link{Canvas.canAcceptDrop} to
    // <code>true</code> and <code>canDropComponents</code> to <code>false</code> on your Layout.
    //
    // @group dragdrop
    // @visibility external
    //<
    canDropComponents: true,

    //> @attr layout.dropLineThickness (number : 2 : IRA)
    //
    // Thickness, in pixels of the dropLine shown during drag and drop when
    // +link{Layout.canDropComponents} is set to <code>true</code>.  See the discussion in
    // +link{Layout} for more info.
    //
    // @see Layout
    // @group dragdrop
    // @visibility external
    // @example dragMove
    //<
    dropLineThickness : 2,

    //> @attr layout.showDropLines (boolean : null : IRW)
    // Controls whether to show a drop-indicator during a drag and drop operation.  Set to
    // false if you either don't want to show drop-lines, or plan to create your own.
    //
    // @group dragdrop
    // @visibility external
    //<
    //showDropLines : true,

    //> @attr layout.showDragPlaceHolder (boolean : null : IRW)
    // If set to true, when a member is dragged out of layout, a visible placeholder canvas
    // will be displayed in place of the dragged widget for the duration of the drag and drop
    // interaction.
    // @group dragdrop
    // @visibility external
    // @example dragMove
    //<

    //> @attr layout.placeHolderProperties (Canvas Properties: null : IR)
    // If +link{layout.showDragPlaceHolder, this.showDragPlaceHolder} is true, this
    // properties object can be used to customize the appearance of the placeholder displayed
    // when the user drags a widget out of this layout.
    // @group dragdrop
    // @visibility external
    // @example dragMove
    //<

    membersAreChildren:true

    //> @attr layout.stackZIndex (String: null : IR)
    // For use in conjunction with +link{memberOverlap}, controls the z-stacking order of
    // members.
    // <P>
    // If set to "lastOnTop", members stack from the first member at bottom to the last member
    // at top. If set to "firstOnTop", members stack from the last member at bottom to the
    // first member at top.
    //
    // @visibility external
    //<
});

//> @groupDef layoutMember
// Properties that can be set on members of a layout to control how the layout is done
// @visibility external
//<

//> @attr canvas.layoutAlign (Alignment | VerticalAlignment : null : IRW)
// When this Canvas is included as a member in a Layout, layoutAlign controls alignment on the
// breadth axis of the layout.  Default is "left" for a VLayout, "top" for an HLayout.
// @group layoutMember
// @visibility external
// @example layoutCenterAlign
//<

//> @attr canvas.showResizeBar (Boolean : false : IRW)
// When this Canvas is included as a member in a +link{Layout}, whether a resizeBar should be shown
// after this member in the layout, to allow it to be resized.
// <p>
// Whether a resizeBar is actually shown also depends on the
// +link{layout.defaultResizeBars,defaultResizeBars} attribute of the layout, and whether this
// Canvas is the last layout member.
// <p>
// By default the resize bar acts on the Canvas that it is declared on.  If you want the resize
// bar to instead act on the next member of the Layout (e.g. to collapse down or to the right),
// set +link{canvas.resizeBarTarget} as well.
//
// @group layoutMember
// @see canvas.resizeBarTarget
// @see layout.defaultResizeBars
// @visibility external
// @example layoutNesting
//<

//> @attr canvas.resizeBarTarget (String : null : IR)
// When this Canvas is included as a member in a Layout, and +link{showResizeBar} is set to
// <code>true</code> so that a resizeBar is created, <code>resizeBarTarget:"next"</code> can be
// set to indicate that the resizeBar should resize the next member of the layout rather than
// this one.  For resizeBars that support hiding their target member when clicked on,
// <code>resizeBarTarget:"next"</code> also means that the next member will be the one hidden.
// <P>
// This is typically used to create a 3-way split pane, where left and right-hand sections can
// be resized or hidden to allow a center section to expand.
// <P>
// <b>NOTE:</b> as with any Layout, to ensure all available space is used, one or more members
// must maintain a flexible size (eg 75%, or *).  In a two pane Layout with a normal resize
// bar, to fill all space after a user resizes, the member on the <b>right</b> should have
// flexible size.  With resizeBarTarget:"next", the member on the <b>left</b> should have
// flexible size.
//
// @group layoutMember
// @see canvas.showResizeBar
// @visibility external
//<

//> @attr canvas.extraSpace (PositiveInteger : 0 : IR)
// When this Canvas is included as a member in a Layout, extra blank space that should be left
// after this member in a Layout.
// @see class:LayoutSpacer for more control
// @group layoutMember
// @visibility external
//<

isc.Canvas.addMethods({

    //> @method canvas.setLayoutAlign()
    // Setter for +link{canvas.layoutAlign}
    //<
    setLayoutAlign : function (layoutAlign) {
        this.layoutAlign = layoutAlign;
        if (this.parentElement && isc.isA.Layout(this.parentElement) &&
            this.parentElement.isDrawn())
        {
            this.parentElement.reflow();
        }
    },

    //> @method canvas.setShowResizeBar()
    // When this Canvas is included as a member in a +link{Layout}, dynamically updates whether a
    // resizeBar should be shown after this member in the layout, to allow it to be resized.
    // <p>
    // Whether a resizeBar is actually shown also depends on the
    // +link{layout.defaultResizeBars,defaultResizeBars} attribute of the layout, and whether this
    // Canvas is the last layout member.
    // @param show (boolean) setting for this.showResizeBar
    // @group layoutMember
    // @see layout.defaultResizeBars
    // @visibility external
    //<
    setShowResizeBar : function (show) {
        if (this.showResizeBar == show) return;
        this.showResizeBar = show;

        var layout = this.parentElement;
        if (layout == null || !isc.isA.Layout(layout)) return;
        layout._computeShowResizeBarsForMembers();
    }
});


// Length/Breadth sizing functions
// --------------------------------------------------------------------------------------------
// NOTE: To generalize layouts to either dimension we use the following terms:
//
// - length: size along the axis on which the layout stacks the members (the "length axis")
// - breadth: size on the other axis (the "breadth axis")

isc.Layout.addMethods({

//> @method layout.getMemberOffset() [A]
// Override point for changing the offset on the breadth axis for members, that is, the offset
// relative to the left edge for a vertical layout, or the offset relative to the top edge for
// a horizontal layout.
// <P>
// The method is passed the default offset that would be used for the member if
// getMemberOffset() were not implemented.  This default offset already takes into account
// +link{layoutMargin}, as well as the +link{defaultLayoutAlign,alignment on the breadth axis},
// which is also passed to getMemberOffset().
// <P>
// This method is an override point only; it does not exist by default and cannot be called.
//
// @param member (Canvas) Component to be positioned
// @param defaultOffset (Number) Value of the currently calculated member offset.  If this
//      value is returned unchanged the layout will have its default behavior
// @param alignment (String) alignment of the enclosing layout, on the breadth axis
// @group layoutMember
// @visibility external
//<

getMemberLength : function (member) {
    return this.vertical ? member.getVisibleHeight() : member.getVisibleWidth()
},
getMemberBreadth : function (member) {
    return this.vertical ? member.getVisibleWidth() : member.getVisibleHeight()
},

setMemberBreadth : function (member, breadth) {
    if (this.logIsDebugEnabled(this._$layout)) this._reportResize(member, breadth);
    this.vertical ? member.setWidth(breadth) : member.setHeight(breadth);
},

getMemberMaxBreadth : function (member) {
    return this.vertical ? member.maxWidth : member.maxHeight;
},
getMemberMinBreadth : function (member) {
    return Math.max(this.vertical ? member.minWidth : member.minHeight, this.minMemberBreadth);
},

getMemberMaxLength : function (member) {
    return this.vertical ? member.maxHeight : member.maxWidth;
},
getMemberMinLength : function (member) {
    return Math.max(this.vertical ? member.minHeight : member.minWidth,
                    this.minMemberSize, this.minMemberLength);
},


// NOTE: these return the space available to lay out components, not the specified size
getLength : function () {
    if (this.vertical) return this.getInnerHeight();
    var width = this.getInnerWidth();
    if (this.leaveScrollbarGap && !this.vscrollOn) width -= this.getRequiredScrollbarSpace();
    return width;
},
getBreadth : function () {
    if (!this.vertical) return this.getInnerHeight();
    var width = this.getInnerWidth();
    if (this.leaveScrollbarGap && !this.vscrollOn) width -= this.getRequiredScrollbarSpace();
    return width;
},

getLengthPolicy : function () {
    return this.vertical ? this.vPolicy : this.hPolicy;
},

getBreadthPolicy : function () {
    return this.vertical ? this.hPolicy : this.vPolicy;
},


memberHasInherentLength : function (member) {

    if (!(this.vertical ? member.hasInherentHeight() : member.hasInherentWidth())) {
        return false;
    }
    // adaptive-length members are not considered to have an "inherent length"
    if (this.vertical ? member.canAdaptHeight : member.canAdaptWidth) {
        return false;
    }
    // if a percent size or "*" is set on a member that supposedly has inherent length, take
    // this as a sign that the member should actually be sized normally.  Note that if we allow
    // a percent-size member to size itself, a stack of such members would not perfectly fill
    // space, because they can't coordinate on rounding to the nearest pixel!
    var explicitLength = this._explicitLength(member);
    if (isc.isA.String(explicitLength) &&
        (explicitLength.endsWith(this._$percent) || explicitLength == this._$star))
    {
        return false;
    }
    return true;
},

memberHasInherentBreadth : function (member) {
    return (this.vertical ? member.hasInherentWidth() : member.hasInherentHeight());
},

_overflowsLength : function (member) {
    return ((this.vertical && member.canOverflowHeight()) ||
            (!this.vertical && member.canOverflowWidth()));
},

_canAdaptLength : function (member) {
    return this.vertical ? member.canAdaptHeight : member.canAdaptWidth
},

// NOTE: specified width/height will be defined if width/height were set on construction.
_explicitLength : function (member) {
    return this.vertical ? member._userHeight : member._userWidth;
},

_explicitBreadth : function (member) {
    return this.vertical ? member._userWidth : member._userHeight;
},

_memberPercentLength : function (member) {
    return this.vertical ? member._percent_height : member._percent_width;
},

scrollingOnLength : function () { return this.vertical ? this.vscrollOn : this.hscrollOn },

getMemberGap : function (member) {
    return (member.extraSpace  || 0)  - (this.memberOverlap || 0)
        + (member._internalExtraSpace || 0);
},





// Creation/Drawing
// --------------------------------------------------------------------------------------------

//>    @method    Layout.initWidget()
//        sets up the layout for various management duties (various observations of member canvases,
//        initialization of sizes, array, etc.)
//<
initWidget : function () {
    if (isc._traceMarkers) arguments.__this = this;
    // initialize "vertical" for "orientation", or vice versa
    var Layout = isc.Layout;
    if (this.vertical == null) {
        this.vertical = (this.orientation == Layout.VERTICAL);
    } else {
        this.orientation = (this.vertical ? Layout.VERTICAL : Layout.HORIZONTAL);
    }

    // For horizontal Layouts perform a horizontal animation effect when showing / hiding
    if (!this.vertical && this.animateMemberEffect == "slide") {
        this.animateMemberEffect = isc.Layout._animateHSlideEffect;
    }

    // for horizontal layouts in RTL, set (or flip) the reverseOrder flag
    if (this.isRTL() && !this.vertical) this.reverseOrder = !this.reverseOrder;

    if (this.members == null) this.members = [];
    else if (!isc.isA.Array(this.members)) this.members = [this.members];

    // NOTE: trickiness with timing of creating members/children/peers:
    // Once we add the "members" as children or peers, Canvas code will auto-create any members
    // specified as instantiation blocks rather than live widgets.  Therefore, we make sure all
    // members have been instantiated here, because if we allow Canvas code to do the
    // instantiation, our "members" array will contain pointers to instantiation blocks instead
    // of the live Canvii.
    if (this.membersAreChildren) {
        if (!this._dontCopyChildrenToMembers && this.members.length == 0 && this.children != null &&
            !this._allGeneratedChildren())
        {
            // since no members were specified, but children were specified, and this is a
            // Layout, assume all children are members.  NOTE: don't be fooled by having a
            // children Array that contains only generated components, which doesn't indicate
            // old-style usage, rather it indicates a Layout subclass that creates
            // non-member children.

            // NOTE: ensure this.members contains live Canvii
            this.members = this.children = this.createMemberCanvii(this.children);
        } else {
            // explicit list of members: create them and add them to the children array
            // NOTE: ensure this.members contains live Canvii
            this.members = this.createMemberCanvii(this.members);
            if (this.children == null) this.children = [];
            // Add to the children array if they're not already added.

            for (var i = 0; i < this.members.length; i++) {
                if (!this.children.contains(this.members[i])) {
                    this.children.add(this.members[i]);
                }
            }
        }

    } else {
        this.logInfo("members are peers", "layout");

        // we override drawPeers() to do our special drawing.  The Layout itself *will not draw*
        // since there's no need.

        // override draw() to avoid actually drawing this Canvas.

        this.addMethods({draw:this._drawOverride});

        // explicit list of members: create them and add them to the peers array
        // NOTE: ensure this.members contains live Canvii
        this.members = this.createMemberCanvii(this.members);
        if (this.peers == null) this.peers = [];
        this.peers.addList(this.members);
    }
    // Run 'getUserSizes' to ensure we store out specified percent etc sizes
    // For dynamically added members this is handled in addMembers()
    for (var i = 0; i < this.members.length; i++) {
        this._getUserSizes(this.members[i]);
    }

    // set up per-side margin properties based on settings
    this.setLayoutMargin();
     // fire membersChanged() if we have members
    if (this.members && this.members.length > 0) {
        this._membersChanged();
    }

    // Warn if align is useless for current orientation
    this.checkAlign(this.align);
},

//> @method layout.setAlign()
// Changes the +link{layout.align} for this Layout.
// <p>
// Horizontal layouts should only be changed to +link{Alignment}, and vertical layouts to
// +link{VerticalAlignment}, otherwise they will be considered invalid values, and assigning an
// invalid value here will log a warning to the Developer Console.
// <p>
// For alignment on the breadth axis, see +link{defaultLayoutAlign} and
// +link{canvas.layoutAlign}.
//
// @param align (Alignment | VerticalAlignment)
// @visibility external
//<
setAlign : function (align) {
    this.checkAlign(align);
    this.align = align;
},

// checks if the requested align makes sense for the current orientation, and warns if it is invalid
checkAlign : function (align) {
    if (this.vertical) {
        if (align == isc.Canvas.LEFT || align == isc.Canvas.RIGHT) {
            this.logWarn("Layout.align set to " + align + ", which is invalid for vertical layouts");
        }
    } else {
        if (align == isc.Canvas.TOP || align == isc.Canvas.BOTTOM) {
            this.logWarn("Layout.align set to " + align + ", which is invalid for horizontal layouts");
        }
    }

},

// createMemberCanvii - resolves specified members / children to actual canvas instances, and
// unlike createCanvii, clears out anything that didn't resolve to a Canvas with a warning
createMemberCanvii : function (members) {
    // initialize any (manually-created) LayoutResizeBars
    for (var i = members.length-1; i >= 0; i--) {
        if (isc.isA.LayoutResizeBar(members[i])) {
            this.initResizeBarMember(members[i]);
        }
    }
    members = this.createCanvii(members);


    // If a member is included multiple times in the array, remove the dup's and warn
    // For LayoutSpacers we can go a step further and just create a second LS that matches
    // the size and position (not best practice but should actually work)
    for (var i = members.length-1; i >= 0; i--) {
        // Skip null entries - we handle these separately
        if (members[i] == null) continue;
        if (!isc.isA.Canvas(members[i])) {
            this.logWarn("Layout unable to resolve member:" + this.echo(members[i]) +
                         " to a Canvas - ignoring this member");
            members.removeAt(i);
        }
    }
    var dups = this._checkMembersForDuplicates(members);
    if (dups.length != 0) {
        this.logWarn("Specified members array contains the following component(s) multiple times:" +
            dups + ". This is unsupported. Duplicate Canvas entries will be removed. " +
            "Duplicate LayoutSpacer entries will be replaced with new LayoutSpacers with the same dimensions.");
    }

    return members;
},

_checkMembersForDuplicates : function (members) {
    // Loop through the members checking for duplicates

    var duplicates = [];
    for (var i = 0; i < members.length; i++) {
        var member = members[i],
        nextIndex = members.indexOf(member, i+1);
        if (nextIndex != -1) duplicates.add(member);
        while (nextIndex != -1) {
            if (isc.isA.LayoutSpacer(member)) {
                members[nextIndex] = isc.LayoutSpacer.create({
                    height:member.height,
                    width:member.width,
                    minHeight:member.minHeight,
                    minWidth:member.minWidth
                });
                nextIndex = members.indexOf(member, nextIndex+1);
            } else {
                members.removeAt(nextIndex);
                nextIndex = members.indexOf(member, nextIndex);
            }
        }
    }
    // return whatever we removed/replaced
    return duplicates;
},

_allGeneratedChildren : function () {
    for (var i = 0; i < this.children.length; i++) {
        var child = this.children[i];
        if (child != null && !child._generated) return false;
    }
    return true;
},

// Margins handling
// ---------------------------------------------------------------------------------------

setPadding : function () {
    this.Super("setPadding", arguments);
    if (this.paddingAsLayoutMargin) {
        this.setLayoutMargin();
    }
},

//> @method layout.setLayoutMargin()
// Method to force a reflow of the layout after directly assigning a value to any of the
// layout*Margin properties. Takes no arguments.
//
// @param [newMargin] (Integer) optional new setting for layout.layoutMargin.  Regardless of whether a new
//                          layout margin is passed, the layout reflows according to the current settings
//                          for layoutStartMargin et al
//
// @group layoutMargin
// @visibility external
//<

setLayoutMargin : function (newMargin) {

    if (newMargin != null) this.layoutMargin = newMargin;

    var lhm = this.layoutHMargin,
        lvm = this.layoutVMargin,
        lm = this.layoutMargin,
        // if we are reversed and eg horizontal, the start margin should be on the right, etc
        sm = this.reverseOrder ? this.layoutEndMargin : this.layoutStartMargin,
        em = this.reverseOrder ? this.layoutStartMargin : this.layoutEndMargin;

    var lpm, rpm, tpm, bpm;
    if (this.paddingAsLayoutMargin) {
        var padding = this._calculatePadding();
        lpm = padding.left; rpm = padding.right;
        tpm = padding.top; bpm = padding.bottom;
    }



    this._leftMargin = this._firstNonNull(this.layoutLeftMargin,
                                          (!this.vertical ? sm : null),
                                          lhm, lm, lpm, 0);
    this._rightMargin = this._firstNonNull(this.layoutRightMargin,
                                           (!this.vertical ? em : null),
                                           lhm, lm, rpm, 0);
    this._topMargin = this._firstNonNull(this.layoutTopMargin,
                                          (this.vertical ? sm : null),
                                          lvm, lm, tpm, 0);
    this._bottomMargin = this._firstNonNull(this.layoutBottomMargin,
                                           (this.vertical ? em : null),
                                           lvm, lm, bpm, 0);

    this._breadthChanged = true;
    this.reflow();
},

_getSideMargin : function (vertical) {
    if (this._leftMargin == null) this.setLayoutMargin();

    if (vertical) return this._leftMargin + this._rightMargin;
    else return this._topMargin + this._bottomMargin;
},
_getBreadthMargin : function () { return this._getSideMargin(this.vertical); },
_getLengthMargin : function () { return this._getSideMargin(!this.vertical); },

// ---------------------------------------------------------------------------------------

// draw() override for members-aren't-children mode.
_drawOverride : function () {
    //!DONTCOMBINE
    if (isc._traceMarkers) arguments.__this = this;
    if (!this.membersAreChildren) {
        // we draw the members now, and never draw the Layout as such

        this._setupMembers();

        // draw all the other members.
        this.layoutChildren(this._$initial_draw);

        this.drawPeers();
        this._drawn = true;
        return;
    }
    //StackDepth do a manual Super to avoid stack depth (and its faster)
    isc.Canvas._instancePrototype.draw.apply(this, arguments);
    //this.Super("draw", arguments);
},

// override to ensure padding gets updated for CSS changes
setStyleName : function (newStyle) {
    // Avoid marking the layout as dirty if the new and current styleNames are the same.

    if (this.styleName != newStyle) {
        this.Super("setStyleName", arguments);
        this.setLayoutMargin(this.layoutMargin);
    }
},

// if our members are peers, suppress the normal behavior of resizing peers with the parent
resizePeersBy : function (a,b,c) {
    if (!this.membersAreChildren) return;

    isc.Canvas._instancePrototype.resizePeersBy.call(this, a,b,c);
    //this.Super("resizePeersBy", arguments);
},

markForRedraw : function () {
    if (this.membersAreChildren) return this.Super("markForRedraw", arguments);
    // if members aren't children, we don't draw, so ignore the redraw and just treat it as
    // dirtying the layout
    this.reflow("markedForRedraw");
},

// NOTE: we need to override drawChildren because if we don't, we will have to run the layout
// policy after the children have already been drawn, hence resizing them all and causing them
// to redraw.
drawChildren : function () {
    if (this.membersAreChildren) {
        // members are all children: handle drawing them specially
        this._setupMembers();

        this._setupMembersRuleScope();

        this.updateChildTabPositions();

        // draw all the members.
        // NOTE: odd behavior of Layouts: because layoutChildren() skips hidden members, members
        // which are initially hidden DO NOT DRAW.  This is unlike any other Canvas
        // parent-child relationship, where it is guaranteed that all children have been drawn
        // if the parent has been drawn.  The primary reason not to draw hidden members is
        // performance.
        this.layoutChildren(this._$initial_draw);

        // if there are any children who are not members, call draw on them.  NOTE: a typical
        // case is the *peers of our members*.  This also implies that we must draw members
        // before non-member children, since peers must draw after their masters.
        this._drawNonMemberChildren();

        // Fix the zIndex / tab-index of masked children if we're showing the component mask
        // Normally this happens when 'showComponentMask' is called, so this handles the case where a
        // developer clears and re-draws the parent while the mask is still up.
        if (this.componentMaskShowing) {
            this._updateChildrenForComponentMask();
        }
    }
    // if members aren't children, we don't draw ourselves, so we can't draw children
    return;
},


//>    @method    layout._setupMembers()
// Do one time setup of members.
// Sets initial breadth for all members.
// Returns the set of members that should be predrawn.
//<
_setupMembers : function () {
    if (!this.members) return;
    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i];
        if (member == null) {
            this.logWarn("members array: " + this.members + " includes null entry at position "
                         + i + ". Removing");
            this.members.removeAt(i);
            i-=1;
            continue;
        }

        // set each member's breadth
        this.autoSetBreadth(member);
    }
},

// Normally ruleScope is assigned on first draw as are canvas *When rules, however,
// visibleWhen rules in a canvas need to be processed prior to layout because those
// that are not visible should not initially be shown nor should the potential space
// be allocated within the layout. In other words, an initially hidden component
// should show initially just like it would if hidden later without the transition.
_setupMembersRuleScope : function () {
    // Assign ruleScope and *When rules if needed
    if (this.members) {
        for (var i = 0; i < this.members.length; i++) {
            var member = this.members[i];
            // A hidden component may be assigned a ruleScope when added as a child but it could
            // be wrong (see where flag is set in this file). Recompute the ruleScope to pick up
            // the correct ruleScope.
            if (member._recomputeRuleScopeOnDraw) {
                member._removeCanvasWhenRules();
                member._removeDynamicPropertyRules();
                member._removeFromRuleScope();
                delete member._recomputeRuleScopeOnDraw;
            }
            // Determine ruleScope on first draw if needed.
            // Must be done before children are drawn.
            member.computeRuleScope();
            member._createCanvasWhenRules(true, true);
        }
    }
},

// _drawNonMemberChildren
// Iterate through the children array, and for any children that are not members, draw them without
// managing their layout
// (Duplicates some code to achieve this from Canvas.drawChildren())
_drawNonMemberChildren : function () {

    // bail for the case where members are not children for now
    if (!this.membersAreChildren || !this.children) return;

    for (var i = 0; i < this.children.length; i++) {
        var child = this.children[i];
        if (this.members.contains(child)) continue;

        if (!isc.isA.Canvas(child)) {
            child.autoDraw = false;
            child = isc.Canvas.create(child);
        }
        // Skip any children that shouldn't draw automatically along with the parent
        // EG: componentMask
       if (!this.drawChildWithParent(child)) continue;

        if (!child.isDrawn()) child.draw();
    }
},

//> @method layout.revealChild()
// Reveals the child or member Canvas passed in by showing it if it is currently hidden
//
// @param child (GlobalId | Canvas) the child Canvas to reveal, or its global ID
// @visibility external
//<
revealChild : function (child) {
    if (isc.isA.String(child)) child = window[child];
    if (child) {
        if (this.children && this.children.contains(child) && !child.isVisible()) {
            child.show();
        } else {
            // Members are not necessarily children
            if (this.members && this.members.contains(child) && !child.isVisible()) {
                child.show();
            }
        }
    }
},


// Setting member sizes
// --------------------------------------------------------------------------------------------

//> @attr layout.managePercentBreadth (Boolean : true : IR)
// If set, a Layout with breadthPolicy:"fill" will specially interpret a percentage breadth on
// a member as a percentage of available space excluding the +link{layoutMargin}.  If false,
// percentages work exactly as for a non-member, with layoutMargins, if any, ignored.
// @visibility external
//<
managePercentBreadth:true,

//> @method layout.getMemberDefaultBreadth() [A]
// Return the breadth for a member of this layout which either didn't specify a breadth or
// specified a percent breadth with +link{managePercentBreadth}:true.
// <P>
// Called only for Layouts which have a +link{type:LayoutPolicy,layout policy} for the breadth
// axis of "fill", since Layouts with a breadth policy of "none" leave all member breadths alone.
//
// @param member (Canvas) Component to be sized
// @param defaultBreadth (Number) Value of the currently calculated member breadth. This
//      may be returned verbatim or manipulated in this method.
// @group layoutMember
// @visibility external
//<
getMemberDefaultBreadth : function (member, defaultBreadth) {
    return defaultBreadth;
},

_getMemberDefaultBreadth : function (member) {
    var explicitBreadth = this._explicitBreadth(member),
        percentBreadth = isc.isA.String(explicitBreadth) && isc.endsWith(explicitBreadth,this._$percent)
                    ? explicitBreadth : null,
        availableBreadth = Math.max(this.getBreadth() - this._getBreadthMargin(), 1);



    var minBreadthMember = this._minBreadthMember;
    if (minBreadthMember && minBreadthMember != member) {
        var minMemberBreadth = this.getMemberBreadth(minBreadthMember);
        if (minMemberBreadth > availableBreadth) availableBreadth = minMemberBreadth;
    }




    if (!this.leaveScrollbarGap) {
        if (this._willScrollLength != null) {
            // this.logWarn("resizeMembers adjusting breath for scrolling (" + this._willScrollLength + ")");
            availableBreadth += ((this._willScrollLength ? -1 : 1) * this.getRequiredScrollbarSpace());
        }
    }

    var breadth = (percentBreadth == null ? availableBreadth :
                   Math.floor(availableBreadth * (parseInt(percentBreadth)/100)));

    // call user-specified override, if any
    if (this.getMemberDefaultBreadth != null) {
        breadth = this.getMemberDefaultBreadth(member, breadth);
    }

    // clamp to member min/max in breadth direction
    var minBreadth = this.getMemberMinBreadth(member),
        maxBreadth = this.getMemberMaxBreadth(member);
    if      (breadth < minBreadth) breadth = minBreadth;
    else if (breadth > maxBreadth) breadth = maxBreadth;

    return breadth;
},

// sets the member's breadth if the member does not have an explicitly specified breadth and
// this layout alters member breadths.  Returns true if the member's breadth was changed, false
// otherwise
autoSetBreadth : function (member) {
    if (!this.shouldAlterBreadth(member)) return false;

    // set layoutInProgress, otherwise, we'll think the resize we're about to do was done by the
    // user and treat it as an explicit size
    var wasInProgress = this._layoutInProgress;
    this._layoutInProgress = true;

    this.setMemberBreadth(member, this._getMemberDefaultBreadth(member));

    this._layoutInProgress = wasInProgress;


    return true;
},

// return whether this member should be resized on the perpendicular axis.
shouldAlterBreadth : function (member) {
    // any member with an explicit breadth setting is left alone (hence will stick out or be
    // smaller than the breadth of the layout)
    var explicitBreadth = this._explicitBreadth(member);
    if (explicitBreadth != null) {
        // managePercentBreadths if so configured.  For any other explicit breath, let the
        // member size itself.
        return (this.managePercentBreadth &&
                this.getBreadthPolicy() == isc.Layout.FILL &&
                isc.isA.String(explicitBreadth) &&
                isc.endsWith(explicitBreadth,this._$percent));

    }

    // NOTE: overflow:visible members: if the policy indicates that we change their breadth,
    // what we're basically setting is a minimum, and also advising the browser as to the optimal
    // point to wrap their content if it's wrappable.  Once such a member is drawn, it may exceed
    // the layout's breadth, similar to a member with an explicit size.


    if ((this.vertical && member.neverExpandWidth) ||
        (!this.vertical && member.neverExpandHeight)) return false;


    // members will be set to the breadth of the layout if they have no explicit size of their own
    if (this.getBreadthPolicy() == isc.Layout.FILL) return true;

    // with no breadth policy, don't change member breadth
    return false;
},

// move these canvases offscreen so that we can find out their size
_moveOffscreen : function (member) {
    return isc.Canvas.moveOffscreen(member);
},

// return the total space dedicated to margins or resizeBars

getMarginSpace : function () {
    var lastMemberWasHidden,
        lastMemberWasResizeBar,
        lastMemberHadResizeBar,
        membersMarginPending,
        marginSpace = this._getLengthMargin()
    ;
    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i],
            isResizeBar = isc.isA.LayoutResizeBar(member),
            showResizeBar = member._computedShowResizeBar,
            shouldIgnore = this._shouldIgnoreMember(member)
        ;

        if (showResizeBar) {
            // leave room for resizeBar
            marginSpace += this.resizeBarSize;
        }


        if (i > 0 && !lastMemberHadResizeBar) {
            if (!lastMemberWasHidden && !lastMemberWasResizeBar && !isResizeBar) {
                if (shouldIgnore) membersMarginPending = true;
                else marginSpace += this.membersMargin;
            } else if (lastMemberWasHidden && !isResizeBar && membersMarginPending) {
                marginSpace += this.membersMargin;
                membersMarginPending = false;
            }
        }

        lastMemberWasResizeBar = isResizeBar;
        lastMemberHadResizeBar = showResizeBar;
        lastMemberWasHidden = shouldIgnore;

        if (shouldIgnore) {
            // hidden member with a resizeBar; clear any pending margin
            if (showResizeBar) membersMarginPending = false;
        } else {
            // leave extra space on a member-by-member basis
            marginSpace += this.getMemberGap(member);
        }
    }

    // re add 1 * this.memberOverlap so we don't clip the member closest to our edge
    if (this.memberOverlap != null) marginSpace += this.memberOverlap;
    return marginSpace;
},

// return the total space to be allocated among members by the layout policy: the specified
// size minus space taken up by margins and resizeBars
getTotalMemberSpace : function () {
    return this.getLength() - this.getMarginSpace();
},

// get the total length of all members including margins and resizeBars, which may exceed the
// specified size of the layout if the layout as a whole overflowed
_getTotalMemberLength : function () {
    var totalMemberLength = 0;
    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i];
        if (this._shouldIgnoreMember(member)) continue;
        totalMemberLength += this.getMemberLength(member);
    }
    return totalMemberLength + this.getMarginSpace();
},

// This method prevents the member from being repositioned / resized when we reflow, even
// if it's visible
ignoreMember : function (member) {
    // don't require `member' to be a member of this Layout in case we want the member to be
    // ignored before it's added as a member.

    member._isIgnoringLayout = true;
},

// Allow a member that was previously being ignored to respond to reflow.
stopIgnoringMember : function (member) {
    if (!this.hasMember(member)) return;
    var wasIgnoringMember = this._shouldIgnoreMember(member);
    member._isIgnoringLayout = false;
    // If we were ignoring the member, and now we are not, reflow() to reposition / resize the
    // member.
    if (wasIgnoringMember && !this._shouldIgnoreMember(member)) this.reflow();
},

isIgnoringMember : function (member) {
    return !!member._isIgnoringLayout;
},

// Helper method to determine whether the specified member should be resized / relayed out when
// layoutChildren / reflow
// Returns true if we're ignoring the member, or its hidden.
_shouldIgnoreMember : function (member) {

    if (member.visibility == isc.Canvas.HIDDEN
        && !(member._edgedCanvas && member._edgedCanvas.isVisible())) return true;
    if (this.isIgnoringMember(member)) return true;
    return false;
},

// Allow a member with a managed Z order (via stackZIndex) to be unmanaged.
// DO NOT MANIPULATE _isIgnoringZIndex DIRECTLY! Side effects may be necessary (notably
// when one stops ignoring the member).
ignoreMemberZIndex : function (member) {
    if (!member || !this.members || this.members.indexOf(member) == -1) return;
    member._isIgnoringZIndex = true;
    this.reflow();
},

stopIgnoringMemberZIndex : function (member) {
    member._isIgnoringZIndex = false;
    this.reflow();
},

_isIgnoringMemberZIndex : function (member) {
    if (this.isIgnoringMember(member))
        return true;
    else if (member._isIgnoringZIndex)
        return member._isIgnoringZIndex;
    return false;
},

_$layout : "layout",
// gather the sizes settings that should be passed to the layout policy
// two modes: normal mode, or mode where members that can overflow are treated as being fixed
// size at their drawn size
gatherSizes : function (overflowAsFixed, layoutInfo, sizes) {
    if (!layoutInfo) {
        // re-use a per-instance array for storing layoutInfo
        layoutInfo = this._layoutInfo;
        if (layoutInfo == null) {
            layoutInfo = this._layoutInfo = [];
        } else {
            layoutInfo.length = 0;
        }
    }

    var policy = this.getLengthPolicy();

    // whether to put together info for a big layout report at the end of the resizing/policy run
    var report = this.logIsInfoEnabled(this._$layout);

    // detect sizes that should be regarded as fixed
    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i];

        var memberInfo = layoutInfo[i];
        if (memberInfo == null) {
            memberInfo = layoutInfo[i] = {};
        }

        // skip hidden members
        if (this._shouldIgnoreMember(member)
            //>Animation
            // If we're about to animateShow() a new member, it's visibility will be hidden,
            // but we need to determine its initial size anyway
            && !member._prefetchingSize //<Animation
           ) {
            memberInfo._policyLength = 0;
            if (report) memberInfo._lengthReason = "hidden";
            continue;
        }

        // If a member has an inherent length, we always respect it as a fixed size.  If we have
        // no sizing policy, in effect everything is "inherent length": we just ask it for it's
        // size; if it has a percent size or other non-numeric size, it interprets it itself.
        if (this.memberHasInherentLength(member) || policy == isc.Layout.NONE) {
            memberInfo._policyLength = this.getMemberLength(member);
            // we never want to set a length for inherent size members
            if (report) {
                memberInfo._lengthReason = (policy == isc.Layout.NONE ? "no length policy" :
                                           "inherent size");
            }
            continue;
        }

        // Limit the number of times we can resize each individual member in a layoutChildren flow
        if (this.resizeMembersLimit != null && this.resizeMembersLimit != 0 &&
            memberInfo._resizeCount != null && memberInfo._resizeCount == this.resizeMembersLimit)
        {
                memberInfo._policyLength = this.getMemberLength(member);
                if (report) {
                    memberInfo._lengthReason = "Hit maximum resize attempts (" + memberInfo._resizeCount + ")";
                }
                continue;
        }

        var canOverflow = this._overflowsLength(member),
            specifiedLength = this.vertical ? member.getHeight() : member.getWidth(),
            overflowLength = canOverflow ? this.getMemberLength(member) : specifiedLength
        ;


        if (this._canAdaptLength(member)) {

            memberInfo._policyLength = overflowAsFixed && !canOverflow ? sizes[i] :
                                                                    overflowLength;
            memberInfo._overflowed = overflowLength > specifiedLength;

            if (report) {
                memberInfo._lengthReason = "adaptive length";
            }
            continue;
        }

        if (canOverflow) {

            // If a member is drawn and overflows its specified size we can make an assertion
            // that this is a minimum length for the member
            // This means
            // - The current size should be treated as a minimum for stretch size values ("*", etc)
            // - Use the overflowed length rather than specified length of this member when calculating
            //   the space available for other members
            // This is achieved via the overflowedNaturalSizes parameter of applyNewStretchResizePolicy
            //

            if (specifiedLength < overflowLength) {
                memberInfo._overflowedLength = overflowLength;
            }

            // Second pass through resizeMembers() - overflowAsFixed is true:
            // _isSizesValidForMember() will tell us if we attempted to assign a size from the
            // sizes array and failed, indicating that the member overflowed.
            // In this case we'll treat the drawn size as fixed.
            if (overflowAsFixed) {

                var drawnLength = overflowLength;

                if (drawnLength != sizes[i] && this._isSizesValidForMember(sizes, i)) {
                    if (report) {
                        this.logInfo("member: " + member + " overflowed.  set length: " + sizes[i] +
                                    " got length: " + drawnLength, "layout");
                        memberInfo._lengthReason = "length overflowed";
                    }
                    var policyLength = memberInfo._policyLength;
                    // mark overflowed stretch-size-policy members with policy to limit reversion

                    memberInfo._overflowed =isc.Canvas.isStretchResizePolicy(policyLength) ?
                                                                            policyLength : true;

                    memberInfo._policyLength = drawnLength;
                }
                continue;
            }
        }

        // respect any explicitly specified size (this includes percent)
        if (this._explicitLength(member) != null) {
            memberInfo._policyLength = this.vertical ? member._userHeight : member._userWidth;
            if (report) memberInfo._lengthReason = "explicit size";
            continue;
        }
        // no size specified; ask for as much space as is available
        if (memberInfo._policyLength == null) {
            memberInfo._policyLength = this._$star;
            if (report) memberInfo._lengthReason = "no length specified";
        }
    }
    return layoutInfo;
},

// resize the members to the sizes given in the sizes[] array.  If overflowersOnly is true, only
// resize members that can overflow.
//>Animation
_resizeAnimations:["show", "hide", "rect"],
//<Animation


_hasCosmeticOverflowOnly : function () {
    var members = this.members,
        pageRight,
        pageBottom;
    for (var i = 0; i < members.length; ++i) {
        var member = members[i];
        if (!member) continue; //support sparse arrays

        var memberPeers = member.peers;
        if (memberPeers) {
            for (var j = 0; j < memberPeers.length; ++j) {
                var peer = memberPeers[j];
                if (peer._cosmetic) {
                    if (pageRight == null) {
                        var clipHandle = this.getClipHandle();
                        pageRight = this.getPageRight() - isc.Element.getRightBorderSize(clipHandle);
                        pageBottom = this.getPageBottom() - isc.Element.getBottomBorderSize(clipHandle);
                    }

                    var peerRect = peer.getPeerRect();
                    if ((peerRect[0] + peerRect[2]) >= pageRight ||
                        (peerRect[1] + peerRect[3]) >= pageBottom)
                    {
                        // Proceed on to checking whether any other non-cosmetic child has
                        // a right/bottom coordinate outside of the specified size.
                        for (var k = 0; k < members.length; ++k) {
                            member = members[k];
                            if (member.getPageRight() >= pageRight ||
                                member.getPageBottom() >= pageBottom)
                            {
                                // One of the members is causing overflow, so this layout does
                                // not have purely cosmetic elements causing overflow.
                                return false;
                            }
                        }
                        return true;
                    }
                }
            }
        }
    }
    return false;
},

// resize a single member of the layout; called during layoutChildren()
resizeMember : function (member, size, memberInfo, overflowers)
{
    var report = this.logIsInfoEnabled(this._$layout);

    // ignore hidden members and explicitly ignored members
    if (this._shouldIgnoreMember(member)) return;


    var isMinBreadthMember = member == this._minBreadthMember;
    if (overflowers != null && overflowers != this._overflowsLength(member)
        && !(isMinBreadthMember && this.shouldAlterBreadth(member))
       )
    {
        return;
    }



    // get the breadth this member should be set to, or null if it shouldn't be changed
    var breadth = null;
    if (this.shouldAlterBreadth(member)) {
        if (report) memberInfo._breadthReason = "breadth policy: " + this.getBreadthPolicy();
        breadth = memberInfo._breadth = this._getMemberDefaultBreadth(member);
    } else {
        // don't set breadth
        memberInfo._breadth = this.getMemberBreadth(member);
        if (report) {
            memberInfo._breadthReason = this.getBreadthPolicy() == isc.Layout.NONE ?
                "no breadth policy" : "explicit size";
        }
    }

    var canAdaptLength = this._canAdaptLength(member);

    // get the length we should set the member to

    var length = null;
    if (this.getLengthPolicy() != isc.Layout.NONE && !this.memberHasInherentLength(member)) {
        if (canAdaptLength && this._overflowsLength(member)) {
            var specifiedLength = this.vertical ? member.getHeight() : member.getWidth();
            if (size < specifiedLength) {
                length = memberInfo._resizeLength = size;
                if (report) {
                    this.logInfo("size-adaptive member: " + member + " had to be resized " +
                        "narrower to ensure that adaptWidthBy()/adaptHeightBy() can assume " +
                        "its size is overflow-driven", this._$adaptMembers);
                }
            }
        } else if (!memberInfo._overflowed) {
            length = memberInfo._resizeLength = size;
        }
    }

    // avoid trying to resize an overflowed member to less than its overflowed size
    // (if the width is not also changing, and the member isn't dirty for another reason)

    if (length != null && !canAdaptLength && this._overflowsLength(member) &&
        !member.isDirty() &&
        (!member._hasCosmeticOverflowOnly || !member._hasCosmeticOverflowOnly()))
    {
        var specifiedLength = (this.vertical ? member.getHeight() : member.getWidth()),
            visibleLength = this.getMemberLength(member);
        // member has overflowed length
        if (visibleLength > specifiedLength &&
            // specified length doesn't violate minimum for that member
            this.getMemberMinLength(member) <= specifiedLength &&
            // the new length is less than or equal to the member's overflowed size
            length <= visibleLength &&
            // breadth won't change or isn't increasing
            (breadth == null || breadth <= this.getMemberBreadth(member)))
        {
            if (report) this.logInfo("not applying " + this.getLengthAxis() + ": " + length +
                                     " to overflowed member: " + member + " w/" +
                                     this.getLengthAxis() + ": " + visibleLength, "layout");
            length = null;
        }
    }

    //>Animation
    // Don't resize a member that's in the process of animate-resizing
    if (!member.isAnimating(this._resizeAnimations)) {//<Animation
        var width  = this.vertical ? breadth : length,
            height = this.vertical ? length : breadth;


        if (((width != null) || (height != null)) && !member._equalsCurrentSize(width, height)) {

            // Optimization: No need to resize if this widget overflows and current drawn size == desired size

            if (!(overflowers && (member.getVisibleHeight() == height) && (member.getVisibleWidth() == width)))
            {

                // Track how many times each member was actually resized
                if (memberInfo._resizeCount == null) memberInfo._resizeCount = 0;
                memberInfo._resizeCount++;

                if (this.logIsDebugEnabled(this._$layout)) this._reportResize(member, breadth, length, memberInfo);

                member.resizeTo(width, height);
            }
        }
        //>Animation
    }//<Animation

    // redraw the member if it changed size, so we can get the right size for stacking
    // purposes (or draw the member if it's never been drawn)

    if (member.isDrawn()) {
        if (member.isDirty()) member.redrawForNewSize("Layout getting new size");
    } else {
        // cause undrawn members to draw (drawOffscreen because we haven't positioned them
        // yet and don't want them to momentarily appear stacked on top of each other)
        member._needsDraw = true;
    }

    if (this._overflowsLength(member) && !canAdaptLength) {
        var drawnLength = this.getMemberLength(member);

        // if the member's drawn size exceeds the size we assigned it, return true to
        // indicate that it has overflowed

        if (drawnLength > size) {
            if (report) {
                this.logInfo("resizeMembers(): member: " + member + " overflowed.  Set " +
                             "length: " + size + ", got length: " +
                             drawnLength + "; skipping resize of remaining members", "layout");
            }
            return true;
        }
    }
},

resizeMembers : function (sizes, layoutInfo, overflowers) {


    if (this.overflow == isc.Canvas.AUTO) {
        var lengthOverflows = sizes.sum() > this.getTotalMemberSpace(),
            scrollingOnLength = this.scrollingOnLength();

        this._willScrollLength = null;
        if (lengthOverflows) {
            if (!scrollingOnLength) {
                this.logInfo("scrolling will be required on length axis, after overflow",
                    this._$layout);

                this._willScrollLength = true;
            }
        } else {
            if (scrollingOnLength) {
                this.logInfo("scrolling will no longer be required on length axis, after overflow",
                    this._$layout);
                this._willScrollLength = false;
            }
        }
    }


    var stretchSizeOverflowIndex,
        minBreadthIndex = this._minBreadthIndex,
        minBreadthMember = this._minBreadthMember;
    if (minBreadthMember) {
        if (this.resizeMember(minBreadthMember, sizes[minBreadthIndex],
                              layoutInfo[minBreadthIndex], overflowers))
        {
            stretchSizeOverflowIndex = minBreadthIndex;
        }
    }
    if (stretchSizeOverflowIndex == null) {

        // resize each member (skipping the minBreadthMember if any)
        var members = this.members;
        for (var i = 0; i < members.length; i++) {
            if (i == minBreadthIndex) continue;

            if (this.resizeMember(members[i], sizes[i], layoutInfo[i], overflowers))
            {
                stretchSizeOverflowIndex = i;
                break; // we don't want to resize remaining members - we need to recalculate the sizes
            }
        }
    }


    return (sizes.maxResizedIndex = stretchSizeOverflowIndex) == null;
},

// if stackZIndex is "firstOnTop" or "lastOnTop", ensure all managed members have
// consistently increasing or decreasing Z-order, except members which should be ignored
// (such as selected tabs in a TabBar which must be at the top).
_enforceStackZIndex : function () {

    if (!this.stackZIndex || this.members.length < 2) return;

    // advance to the first non-ignored member
    for (var firstStacked=0; firstStacked<this.members.length; firstStacked++)
        if (!this._isIgnoringMemberZIndex(this.members[firstStacked])) break;

    var thisMember=this.members[firstStacked], thisZ=thisMember.getZIndex();
    var lastMember, lastZ;

    // compare the Z-order of each stackable member to the last stackable member before
    // it. Adjust the Z-order if it does not match the stack ordering.
    for (var i = firstStacked+1; i < this.members.length; i++) {
        if (this._isIgnoringMemberZIndex(this.members[i])) continue;
        lastMember = thisMember;
        lastZ = lastMember.getZIndex();
        thisMember = this.members[i];
        thisZ = thisMember.getZIndex();

        if ((thisZ <= lastZ) && this.stackZIndex == "lastOnTop")
            thisMember.moveAbove(lastMember);
        else if ((thisZ >= lastZ) && this.stackZIndex == "firstOnTop")
            thisMember.moveBelow(lastMember);
    }
},

//>Animation When the member is in the middle of an animated move, avoid attempting to move as
// part of layout.
_moveAnimations:["rect", "move"], //<Animation


stackMembers : function (members, layoutInfo, updateSizes) {

    if (updateSizes == null) updateSizes = true;

    // top/left coordinate of layout: if members are children, placing a member at 0,0
    // places it in the top left corner of the Layout, since child coordinates are relative
    // to the parent.  Otherwise, if members are peers, the top/left corner is the
    // offsetLeft/Top with respect to the Layout's parent
    var layoutLeft = (this.membersAreChildren ? 0 : this.getOffsetLeft()),
        layoutTop  = (this.membersAreChildren ? 0 : this.getOffsetTop()),
        // support reversing the order members appear in
        reverse = this.reverseOrder,
        direction = (reverse ? -1 : 1);



    // breadth to use for centering based on specified size, which we'll use as is
    // for the clipping/scrolling case, and acts as a minimum for the overflow case.
    // Note getInner* takes into account native margin/border
    var vertical = this.vertical,
        specifiedBreadth = (vertical ? this.getInnerWidth() :
                                       this.getInnerHeight()) - this._getBreadthMargin()
    ;

    var Canvas = isc.Canvas, centerBreadth = specifiedBreadth,
        overflow = this._$suppressedOverflowDuringAnimation || this.overflow;
    if (overflow != Canvas.HIDDEN && (vertical ? (overflow != Canvas.CLIP_H) :
                                                 (overflow != Canvas.CLIP_V)))
    {
        // overflow case.  Note we can't just call getScrollWidth() and subtract off synthetic
        // margins because members have not been placed yet.
        for (var i = 0; i < this.members.length; i++) {
            var member = this.members[i];
            // ignore hidden members and explicitly ignored members
            if (this._shouldIgnoreMember(member)) continue;
            var value = this.getMemberBreadth(member);
            if (value > centerBreadth) centerBreadth = value;
        }
    }
    if (this.logIsDebugEnabled(this._$layout)) {
        this.logDebug("centering wrt visible breadth: " + centerBreadth, this._$layout);
    }


    var totalLength;
    if (reverse) {

        var allowNegative = this.isRTL() && this.overflow != isc.Canvas.VISIBLE;
        if (allowNegative) {


            totalLength = this.getLength();
        } else {
            totalLength = Math.max(this.getLength(), this._getTotalMemberLength());
        }
    }

    // start position of the next member on length axis.
    // if reversing, start stacking at end coordinate and work backwards.  Note that this
    // effectively creates right/bottom alignment by default.
    var nextMemberPosition = vertical ? (!reverse ? layoutTop  : layoutTop  + totalLength) :
                                        (!reverse ? layoutLeft : layoutLeft + totalLength)
    ;
    // if align has been set to non-default,
    if (this.align != null) {
        var totalMemberLength = this._getTotalMemberLength(),
            visibleLength = Math.max(this.getLength(), totalMemberLength),
            remainingSpace = visibleLength - totalMemberLength;


        if (((!reverse && (this.align == Canvas.BOTTOM || this.align == Canvas.RIGHT)) ||
              (reverse && (this.align == Canvas.LEFT   || this.align == Canvas.TOP))))
        {
            // leave the space that would have been at the end at the beginning instead.
            // if reversed, hence normally right/bottom aligned, and align has been set to
            // left/top, subtract off remaining space instead.  NOTE: can't simplify reversal to
            // just mean right/bottom align: reverse stacking starts from endpoint and subtracts
            // off sizes during stacking.
            nextMemberPosition += (direction * remainingSpace);
        } else if (this.align == isc.Canvas.CENTER) {
            nextMemberPosition += (direction * Math.round(remainingSpace/2));
        }
    }

    // start position of all members on breadth axis
    var defaultOffset = vertical ? layoutLeft + this._leftMargin :
                                   layoutTop  + this._topMargin,
        lastMemberHadResizeBar = false,
        lastMemberWasResizeBar = false,
        lastMemberWasHidden = false,
        membersMarginPending = false,
        numHiddenMembers = 0;

    for (var i = 0; i < members.length; i++) {
        var member = members[i],
            isResizeBar = isc.isA.LayoutResizeBar(member),
            shouldIgnore = this._shouldIgnoreMember(member),
            // NOTE: layoutInfo is optional, only used for reporting purposes when stackMembers is
            // called as part of a full layoutChildren run
            memberInfo = layoutInfo ? layoutInfo[i] : null;
        // margin before the member / room for resizeBar
        if (i == 0) {
            // first element is preceded by the outer margin of the layout as a whole.
            // NOTE: the last element is implicitly followed by the outer margin because space
            // for it is subtracted before we determine sizes.
            var startMargin;
            if (vertical) startMargin = (reverse ? this._bottomMargin : this._topMargin);
            else          startMargin = (reverse ? this._rightMargin  : this._leftMargin);
            nextMemberPosition += (direction * startMargin);
        } else {
            // if the last member showed a resizeBar, leave room for it
            if (lastMemberHadResizeBar) {
                nextMemberPosition += (direction * this.resizeBarSize);

            // otherwise leave membersMargin (avoid stacking margins if a member is hidden)

            } else if (!lastMemberWasHidden && !lastMemberWasResizeBar && !isResizeBar) {
                if (shouldIgnore) membersMarginPending = true;
                else nextMemberPosition += (direction * this.membersMargin);

            // convert membersMarginPending, if still set, into a membersMargin
            } else if (lastMemberWasHidden && !isResizeBar && membersMarginPending) {
                nextMemberPosition += (direction * this.membersMargin);
                membersMarginPending = false;
            }
        }

        //>Animation
        // Avoid interrupting animations in progress with any kind of move
        var animating = member.isAnimating(this._moveAnimations); //<Animation

        // skip hidden members
        if (shouldIgnore) {

            if (!this.isIgnoringMember(member)
                //>Animation
                && !animating   //<Animation
               ) {
                member.moveTo(layoutLeft + this._leftMargin, layoutTop + this._topMargin);
            }
            // if a hidden member has a resizeBar (it was previously visible) leave the
            // resizeBar showing, and place it properly
            if (member._computedShowResizeBar) {
                var breadth = this.getBreadth() - this._getBreadthMargin();
                this.makeResizeBar(member, defaultOffset, nextMemberPosition, breadth);
                lastMemberHadResizeBar = true;
                membersMarginPending = false;
            } else {
                if (member._resizeBar != null) member._resizeBar.hide();
                lastMemberHadResizeBar = false;
            }
            lastMemberWasResizeBar = isResizeBar;
            lastMemberWasHidden = true;
            numHiddenMembers++;
            continue;
        } else {
            lastMemberWasHidden = false;
        }

        // handle alignment (default is left/top)
        var offset = defaultOffset,
            layoutAlign = this.getLayoutAlign(member)
        ;
        // if RTL mode is active with scrolling overflow, shift the breadth alignment baseline
        if (this.isRTL() && vertical && (overflow == Canvas.AUTO || overflow == Canvas.SCROLL))
        {
            var breadthOverflow = centerBreadth - specifiedBreadth;
            if (breadthOverflow > 0) offset -= breadthOverflow;
        }

        // NOTE: the centerBreadth properly subtracts out layoutMargins
        if (layoutAlign == Canvas.RIGHT || layoutAlign == Canvas.BOTTOM) {
            offset += centerBreadth - this.getMemberBreadth(member);
        } else if (layoutAlign == Canvas.CENTER) {
            offset += Math.floor((centerBreadth - this.getMemberBreadth(member)) / 2);
        }
        if (this.getMemberOffset != null) {
            offset = this.getMemberOffset(member, offset, layoutAlign);
        }

        var memberLength = this.getMemberLength(member);
        //>Animation
        if (!animating) {//<Animation
        // move the member into position
        if (vertical) {
            if (!reverse) member.moveTo(offset, nextMemberPosition);
            else member.moveTo(offset, nextMemberPosition-memberLength);
        } else {
            if (!reverse) member.moveTo(nextMemberPosition, offset);
            else member.moveTo(nextMemberPosition-memberLength, offset);
        }

        //>Animation
        } //<Animation

        // next member will be placed after this one
        nextMemberPosition += (direction * memberLength);
        // leave extra space on a member-by-member basis
        nextMemberPosition += (direction * this.getMemberGap(member));

        // show a resize bar for members that request it
        if (member._computedShowResizeBar) {
            var breadth = this.getBreadth() - this._getBreadthMargin();
            this.makeResizeBar(member, defaultOffset, nextMemberPosition, breadth);
        } else {
            // ensure we hide the resizebar for any hidden members.
            if (member._resizeBar != null) member._resizeBar.hide();
        }
        lastMemberHadResizeBar = member._computedShowResizeBar;
        lastMemberWasResizeBar = isResizeBar;

        // update memberSizes.  NOTE: this is only necessary when we have turned off the sizing
        // policy are doing stackMembers() only
        if (updateSizes) this.memberSizes[i - numHiddenMembers] = memberLength;

        // record length for reporting if being called as part of layoutChildren
        if (layoutInfo) memberInfo._visibleLength = memberLength;
    }
    // trim memberSizes to the currently visible members.  NOTE: this is only necessary when we have
    // turned off the sizing policy are doing stackMembers() only
    if (updateSizes) this.memberSizes.length = (i - numHiddenMembers);

    // Ensure that the reported scroll-size matches the scrollable area of this layout.
    if (overflow != isc.Canvas.VISIBLE) this._enforceScrollSize();

    this._enforceStackZIndex();
},

// determine the breadth axis alignment per member.
getLayoutAlign : function (member) {
    if (member.layoutAlign != null) return member.layoutAlign;
    if (this.defaultLayoutAlign != null) return this.defaultLayoutAlign;
    return this.vertical ? (this.isRTL() ? isc.Canvas.RIGHT : isc.Canvas.LEFT)
                          : isc.Canvas.TOP;
},


_enforceScrollSize : function () {

    var breadthLayoutMargin,
        lengthLayoutMargin,
        hasMargin = false, spacerForcesOverflow = false,

        lastMember,
        member,
        scrollBottom, scrollRight, vertical = this.vertical;

    // convert null margins to zero so we don't need to worry about doing math with them
    if (vertical) {
        lengthLayoutMargin = this._bottomMargin || 0;
        breadthLayoutMargin = this._rightMargin || 0;
    } else {
        lengthLayoutMargin = this._rightMargin || 0;
        breadthLayoutMargin = this._bottomMargin || 0;
    }

    if (lengthLayoutMargin > 0 || breadthLayoutMargin > 0) hasMargin = true;

    var innerWidth = this.getInnerWidth(),
        innerHeight = this.getInnerHeight();

    // If we have layout margins that cause scrolling, we need to find the bottom (or right)
    // of the last member, and the right (or bottom) of the broadest member to enforce scroll
    // size.
    // In this case just iterate through every member to find our broadest member.
    if (hasMargin) {
        for (var i = this.members.length-1 ; i >= 0; i--) {
            member = this.members[i];
            if (!member.isVisible()) continue;

            if (vertical) {
                if (lastMember == null) {
                    lastMember = member;
                    scrollBottom = member.getTop() + member.getVisibleHeight();
                }

                var right = member.getLeft() + member.getVisibleWidth();
                if (scrollRight == null || scrollRight < right) scrollRight = right;

            } else {
                if (lastMember == null) {
                    lastMember = member;
                    scrollRight = member.getLeft() + member.getVisibleWidth();
                }

                var bottom = member.getTop() + member.getVisibleHeight();
                if (scrollBottom == null || scrollBottom < bottom) scrollBottom = bottom;
            }
        }

        // If we had no visible members we still need a valid scrollBottom/scrollLeft
        // to enforce, or we'll end up trying to math on null values
        if (scrollBottom == null) scrollBottom = 0;
        if (scrollRight == null) scrollRight = 0;

    // if we have no layout margins, we will only need to enforce scrollSize if our last member
    // is a layout spacer and/or our broadest member is a layout spacer (and is wider than
    // this.innerWidth
    // In this case, for efficiency, iterate through our members array checking for a layout
    // spacer at the end, or one that effects the broadness of the content.
    // Then, iff we found a layoutSpacer that effects the broadness of the content, iterate
    // through all the other members to determine whether it's the broadest member in the
    // layout - as we may be able to avoid enforcing scroll size.
    } else {
        var spacerBreadthOverflow = false;
        for (var i = this.members.length-1 ; i >= 0; i--) {
            var member = this.members[i];
            if (isc.isA.LayoutSpacer(member) && member.isVisible()) {
                var width = member.getWidth(), height = member.getHeight();

                // spacer at end - always have to enforce overflow
                if (i == this.members.length-1) {
                    spacerForcesOverflow = true;
                    if (vertical) scrollBottom = member.getTop() + height;
                    else scrollRight = member.getLeft() + width;
                }
                // Otherwise only if we have a layout spacer member that is the widest member
                // and exceeds the available space
                if (vertical) {
                    if(width > innerWidth && (scrollRight == null || width > scrollRight)) {
                        spacerBreadthOverflow = true;
                        scrollRight = width;
                    }
                } else if (height > innerHeight &&
                          (scrollBottom == null || height > scrollBottom)) {
                    spacerBreadthOverflow = true;
                    scrollBottom = height;
                }
            }
        }

        // if spacerBreadthOveflow is true, we have a spacer that may be the widest member of
        // this layout.
        // If our last member is a layout spacer we know we have to enforce scroll size
        // - otherwise iterate through the members array again checking the widths of all
        //   non-layoutSpacer members to determine whether this is the widest member.

        if (spacerBreadthOverflow && !spacerForcesOverflow) {
            for (var i = this.members.length-1 ; i >= 0; i--) {
                var member = this.members[i];
                if (isc.isA.LayoutSpacer(member)) continue;

                if (this.vertical) {
                    var width = member.getVisibleWidth();
                    if (width >= scrollRight) {
                        spacerBreadthOverflow = false;
                        break;
                    }
                } else {
                    var height = member.getVisibleHeight();
                    if (height >= scrollBottom) {
                        spacerBreadthOverflow = false;
                        break;
                    }
                }
            }

            // at this point if spacerBreadthOverflow is true we need to enforce scroll breadth
            if (spacerBreadthOverflow) spacerForcesOverflow = true;
        }

        if (spacerForcesOverflow) {
            // Ensure we have a non-null position on both axes.
            // May not be the case if spacers only cause overflow in one direction.
            if (scrollRight == null) scrollRight = 1;
            if (scrollBottom == null) scrollBottom = 1;
        }

    }

    if (spacerForcesOverflow || hasMargin) {
        if (this.vertical) {
            scrollRight += breadthLayoutMargin;
            scrollBottom += lengthLayoutMargin;
        } else {
            scrollRight += lengthLayoutMargin;
            scrollBottom += breadthLayoutMargin;
        }
        this.enforceScrollSize(scrollRight, scrollBottom);
    }
    else this.stopEnforcingScrollSize();

},


// Override setOverflow:
// we only need to write out scroll-sizing divs iff we're not overflow visible (so need to be
// able to natively scroll to the bottom right even if we have no true HTML content there).
setOverflow : function (newOverflow, a, b, c, d) {
    var oldOverflow = this.overflow;
    if (oldOverflow == isc.Canvas.VISIBLE && newOverflow != isc.Canvas.VISIBLE) {
        this._enforceScrollSize();
    } else if (oldOverflow != isc.Canvas.VISIBLE && newOverflow == isc.Canvas.VISIBLE) {
        this.stopEnforcingScrollSize();
    }
    return this.invokeSuper(isc.Layout, "setOverflow", newOverflow, a, b, c, d);
},

// resizeMembersLimit: Our sizing algorithm may require multiple resizes of
// overflow:"visible" members. This value is a maximum for how many times we
// can resize any individual member during a reflow

resizeMembersLimit:3,

//>    @method    layout.layoutChildren() [A]
// Size and place members according to the layout policy.
//<
layoutChildren : function (reason, deltaX, deltaY) {
    if (isc._traceMarkers) arguments.__this = this;

    // avoid doing a bunch of Layout runs as we blow away our members during a destroy()
    if (this.destroying) return;

    if (this._reflowCount == null) this._reflowCount = 1;
    else this._reflowCount++;


    if (!this.members) this.members = [];

    // mimic the superclass Canvas.layoutChildren() by resolving percentage sizes, but only for
    // percent sizes the layout doesn't specially manage.
    // Non-member children always interpret percents themselves.
    // However, if we have length policy:"fill", percentages specified for the length axis on
    // members have special meaning, and the member should not interpret them itself.
    // Likewise breadth-axis percentages when breadthPolicy is "fill" (handled in
    // shouldAlterBreadth()
    if (this.children && this.children.length) {
        for (var i = 0; i < this.children.length; i++) {
            this._resolvePercentageSizeForChild(this.children[i]);
        }
    }

    // don't layoutChildren() before draw() unless layoutChildren() is being called as part of
    // draw()
    if (!this.isDrawn() && reason != this._$initial_draw) return;

    // set a flag that we are doing layout stuff, so that we can ignore when we're notified that a
    // member has been resized
    var layoutAlreadyInProgress = this._layoutInProgress;
    this._layoutInProgress = true;

    if (deltaX != null || deltaY != null) {
        // since deltaX or deltaY was passed, we're being called from Canvas.resizeBy()

        // if we are resized on the breadth axis, set a marker so we know that we may have to
        // resize members on the breadth axis
        if ((this.vertical && isc.isA.Number(deltaX)) ||
            (!this.vertical && isc.isA.Number(deltaY)))
        {
            this._breadthChanged = true;
        }
    }

    if (this.isDrawn() && this.getLengthPolicy() == isc.Layout.NONE && !this._breadthChanged) {
        if (this.logIsInfoEnabled(this._$layout)) {
            this.logInfo("Restacking, reason: " + reason, this._$layout);
        }


        this.stackMembers(this.members);

        this._breadthChanged = false;
        this._layoutChildrenDone(reason, layoutAlreadyInProgress);
        return;
    //} else {
    //    this.logWarn("couldn't take shortcut, policy: " + this.getLengthPolicy() +
    //                 ", breadthChanged: " + this._breadthChanged);
    }
    this._breadthChanged = false;





    // get the amount the total amount of space available for members (eg, margins and room for
    // resizeBars is subtracted off)
    var totalSpace = this.getTotalMemberSpace()

    if (this.manageChildOverflow) this._suppressOverflow = true;

    //StackDepth draw() from here instead of having resizeMembers do it, to avoid stack

    var drawnInline = [];

    var minBreadthMember = this.getMember(this.minBreadthMember);
    if (minBreadthMember) {
        if (!minBreadthMember.isDrawn()) {
            this._moveOffscreen(minBreadthMember);
            minBreadthMember.draw();
            drawnInline[0] = minBreadthMember;
        }
        // cache minBreadthMember and its index for efficiency
        this._minBreadthIndex = this.members.indexOf(minBreadthMember);
        this._minBreadthMember = minBreadthMember;
    } else {
        delete this._minBreadthIndex;
        delete this._minBreadthMember;
    }

    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i];

        if (this._canAdaptLength(member) && !member.allowAdaptSizeBeforeDraw &&
            !member.isDrawn())
        {
            this._moveOffscreen(member);
            member.draw();
            drawnInline[drawnInline.length] = member;
        }
        // default member minHeight that hasn't been set explicitly
        if (member.minHeight == null && member._getDefaultMinHeight) {
            member.minHeight = member._getDefaultMinHeight();
        }
    }


    if (this.manageChildOverflow && drawnInline.length > 0) {
        this._completeChildOverflow(drawnInline);
    }
    // reset the drawnInline array
    drawnInline = [];

    // Determine the sizes for the members
    var sizes = this._getMemberSizes(totalSpace),

        layoutInfo = this._layoutInfo;

    var resizeMembersCount = 0;
    var seenSizes = [];
    do {
        // size any members that can overflow
        var memberOverflowed = !this.resizeMembers(sizes, layoutInfo, true);

        // resizeMembers() may have set _needsDraw on some (undrawn) members
        // We take care of drawing these now
        if (this.manageChildOverflow) this._suppressOverflow = true;

        //StackDepth draw() from here instead of having resizeMembers do it, to avoid stack



        for (var i = 0; i < this.members.length; i++) {
            var member = this.members[i];


            if (member._needsDraw) {
                member._needsDraw = null;
                this._moveOffscreen(member);
                member.draw();
                drawnInline[drawnInline.length] = member;
            }
        }
        if (this.manageChildOverflow && drawnInline.length > 0) {
            this._completeChildOverflow(drawnInline);
        }

        // Special case - it's possible that a previously undrawn member
        // sized during resizeMembers() only now overflows its specified height.
        // Catch this case and set the flag so we resize again
        if (!memberOverflowed) {
            for (var i = 0; i < drawnInline.length; i++) {
                if (drawnInline[i] == null) continue;
                var member = drawnInline[i];
                if (this._overflowsLength(member) && this.getMemberLength(member) > sizes[i]) {
                    // set the maxResizedIndex flag so we know how many members were successfully
                    // sized
                    if (sizes.maxResizedIndex == null) sizes.maxResizedIndex = i;
                    memberOverflowed = true;
                    break;
                }
            }
        }
        drawnInline = [];

        resizeMembersCount++;

        // Gather sizes again taking into account members that overflowed

        this._getMemberSizes(totalSpace, true, sizes, layoutInfo);


        var serializedSizes = sizes.join(",");
        if (memberOverflowed && seenSizes.contains(serializedSizes)) {

            break;
        } else {
            seenSizes.push(serializedSizes);
        }

    } while (memberOverflowed);



    // Now we have a definitive set of sizes, size any members that can't overflow
    this.resizeMembers(this.memberSizes = sizes, layoutInfo, false);

    if (this.manageChildOverflow) this._suppressOverflow = true;

    //StackDepth draw() from here instead of having resizeMembers do it, to avoid stack
    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i];
        if (member._needsDraw) {
            member._needsDraw = null;
            this._moveOffscreen(member);
            member.draw();

            drawnInline[drawnInline.length] = member;
        }
    }
    // At this point the only newly drawn members would be ones that were overflow
    // hidden.
    // Complete their 'adjustOverflow' now.

    if (this.manageChildOverflow && drawnInline.length > 0) {
        this._completeChildOverflow(this.members);
    }

    // stack the members
    this.stackMembers(this.members, layoutInfo);

    // report what happened
    this.reportSizes(layoutInfo, reason);

    this._layoutChildrenDone(reason, layoutAlreadyInProgress);
},

// Helper broken out from HTMLInit to call '_completeChildOverflow()' on this.children
// if appropriate.

_completeChildrenOverflowOnHTMLInit : function () {
    if (this.manageChildOverflow && this.children != null &&
        (this.parentElement == null || !this.parentElement._suppressOverflow))
    {
        // We only care about non-member children here - we already adjusted overflow
        // for members during layoutChildren.
        var nonMemberChildren = [];
        if (this.members && (this.members.length < this.children.length)) {
            for (var i = 0; i < this.children.length; i++) {
                if (this.members.indexOf(this.children[i]) == -1) {
                    nonMemberChildren.add(this.children[i]);
                }
            }
        }
        this._completeChildOverflow(nonMemberChildren);
    }
},

_resolvePercentageSizeForChild : function (child) {
    var childManaged = this.members.contains(child) && !this._shouldIgnoreMember(child);


    if (childManaged && this.snapTo == null) {
        var percentWidth, percentHeight,
            fillLength  = this.getLengthPolicy()  == isc.Layout.FILL,
            fillBreadth = this.getBreadthPolicy() == isc.Layout.FILL
        ;
        if (this.vertical) {
            percentWidth  = fillBreadth ? null : child._percent_width;
            percentHeight = fillLength  ? null : child._percent_height;
        } else {
            percentWidth  = fillLength  ? null : child._percent_width;
            percentHeight = fillBreadth ? null : child._percent_height;
        }
        // call setRect() if if we've still got percentages to apply the member
        if (child._percent_left || child._percent_top || percentHeight || percentWidth) {
            child.setRect(child._percent_left, child._percent_top, percentWidth, percentHeight);
        }
    }
    // run snapTo/percent resolution on unmanaged layout children

    if (isc.isA.Canvas(child)) child.parentResized(childManaged);
},

// get list of "canAdapt" members, ordered by priority
_getCanAdaptLengthMembers : function (surplus) {
    var list = [];

    for (var i = 0; i < this.members.length; i++) {
        var member = this.members[i];
        if (this._canAdaptLength(member)) {
            list.add(member);
            member._memberIndex = i;
        }
    }

    // numerically higher priorities get offered surplus space first,
    // and asked last to surrender space in the event of an overflow
    list.sortByProperty(this.vertical ? "adaptiveHeightPriority" :
                                        "adaptiveWidthPriority", !surplus);

    if (this.logIsInfoEnabled(this._$adaptMembers)) {
        var direction = surplus ? "descending" : "ascending";
        this.logInfo("found " + list.length + " size-adaptable members (" + direction + "): " +
            list.map(function(member) { return member.getID(); }), this._$adaptMembers);
    }
    return list;
},

// calculate the initial amount of remaining space to offer to "canAdapt" members
_getRemainingSpace : function (sizes, totalSize, commonMinSize, layoutInfo) {
    var results = this.getClass()._calculateStaticSize(sizes, sizes, totalSize, this),
        vertical = this.vertical,
        staticSize = results.staticSize,
        stretchCount = results.starCount + results.percentCount;

    // minimum stretch-member sizes
    if (this.useOriginalStretchResizePolicy || this.ignoreStretchResizeMemberSizeLimits) {
        // if we're not enforcing per-member minimums, then the minimum size for each stretch-
        // member is just the single common value passed in, so it's scaled by the # of members
        staticSize += stretchCount * commonMinSize;
    } else {
        // add per-member minimum for each stretch member still present in the size policy array
        for (var i = 0; i < sizes.length; i++) {
            if (isc.Canvas.isStretchResizePolicy(sizes[i])) {
                var member = this.members[i],
                    minSize = vertical ? member.minHeight : member.minWidth;
                // If the member overflowed its specified size, treat its
                // natural size as a minimum
                if (layoutInfo && layoutInfo[i]._overflowedLength) {
                    minSize = Math.max(minSize, layoutInfo[i]._overflowedLength);
                }
                staticSize += Math.max(minSize, commonMinSize);
            }
        }
    }

    var remainingSpace = totalSize - staticSize;

    if (this.logIsInfoEnabled(this._$adaptMembers)) {
        this.logInfo("Layout._getRemainingSpace(): remaining space is " + remainingSpace +
                     " after reserving minimums for " + stretchCount + " stretch members",
                     this._$adaptMembers);
    }
    return remainingSpace;
},


_revertOverflowedStretchSizedPolicyLengths : function (layoutInfo, sizes) {
    for (var i = 0; i < this.members.length; i++) {
        var memberInfo = layoutInfo[i];
        if (isc.isA.String(memberInfo._overflowed)) {
            sizes[i] = memberInfo._policyLength = memberInfo._overflowed;
            delete memberInfo._overflowed;
        }
    }
    delete sizes.maxResizedIndex;

    if (this.logIsInfoEnabled(this._$adaptMembers)) {
        this.logInfo("Layout._revertOverflowedStretchSizedPolicyLengths(): " +
                     "overflowAsFixed processing has been reset for all affected members",
                     this._$adaptMembers);
    }
},

adaptMembersToSpace : function (sizes, totalSpace, overflowAsFixed, layoutInfo) {
    var adapted = false,
        vertical = this.vertical,
        commonMinLength = Math.max(this.minMemberSize, this.minMemberLength),
        remainingSpace = this._getRemainingSpace(sizes, totalSpace, commonMinLength, layoutInfo)
    ;

    var adaptiveMembers = this._getCanAdaptLengthMembers(remainingSpace > 0);
    for (var i = 0; i < adaptiveMembers.length; i++) {
        // bail out if nothing to offer
        if (remainingSpace == 0) break;

        var member = adaptiveMembers[i],
            adaptLengthBy = vertical ? member.adaptHeightBy : member.adaptWidthBy
        ;
        // just skip the member if no function is present
        if (!isc.isA.Function(adaptLengthBy)) {
            this.logWarn("adaptMembersToSpace(): member " + member.getID() +
                " specified as canAdaptWidth/canAdaptHeight: true, but no " +
                "corresponding adaptWidthBy/adaptHeightBy() function is present",
                this._$adaptMembers);
            continue;
        }


        delete member._acceptedAdaptOffer;

        // query and react to current canAdaptWidth/Height member


        var index = member._memberIndex,
            deltaLength, length = sizes[index],
            canOverflow = this._overflowsLength(member),
            lastAdaptedLength = member._lastAdaptedLength,
            passAdaptedLength = !canOverflow &&
                isc.Canvas._isStretchSize(this._explicitLength(member))
        ;
        if (passAdaptedLength && lastAdaptedLength) {
            deltaLength = adaptLengthBy.call(member, remainingSpace +
                              length - lastAdaptedLength, lastAdaptedLength, !overflowAsFixed);
        } else {
            deltaLength = adaptLengthBy.call(member, remainingSpace, length, !overflowAsFixed,
                                             layoutInfo[index]._overflowed);
        }

        // only numerical results are valid
        if (!isc.isA.Number(deltaLength)) {
            this.logWarn("adaptMembersToSpace(): ignoring nonsense value " + deltaLength +
                         " returned from adaptWidthBy/adaptHeightBy() by member " +
                         member.getID(), this._$adaptMembers);
            continue;
        }

        // translate user's requested deltaLength back to an offset from the current length
        if (passAdaptedLength && lastAdaptedLength) deltaLength += lastAdaptedLength - length;

        // member rejects proposal; nothing to do
        if (deltaLength == 0) {
            if (passAdaptedLength) member._lastAdaptedLength = length;
            if (this.logIsInfoEnabled(this._$adaptMembers)) {
                this.logInfo("adaptMembersToSpace(): member " + member.getID() +
                    " has rejected offer of " + remainingSpace, this._$adaptMembers);
            }
            continue;
        }

        // don't allow an increase in length if there's no remaining space
        if (remainingSpace < 0 && deltaLength > 0) {
            this.logWarn("adaptMembersToSpace(): ignoring request for " + deltaLength + " px " +
                "returned from adaptWidthBy/adaptHeightBy() by member " + member.getID() +
                " since no remaining space is available; no length increase is allowed",
                this._$adaptMembers);
            continue;
        }

        // for increases, don't let the response exceed the offer
        if (remainingSpace > 0 && deltaLength > remainingSpace) {
            this.logWarn("adaptMembersToSpace(): ignoring request for " + deltaLength + " px " +
                "returned from adaptWidthBy/adaptHeightBy() by member " + member.getID() +
                " since it exceeds offer of " + remainingSpace,
                this._$adaptMembers);
            continue;
        }

        // enforce minimum member length
        var minLength = Math.max(commonMinLength, vertical ? member.minHeight :
                                                             member.minWidth);
        if (length + deltaLength < minLength) {
            this.logWarn("adaptMembersToSpace(): ignoring request for " + deltaLength + " px " +
                         "returned from adaptWidthBy/adaptHeightBy() by member " +
                         member.getID() + " since it would reduce member length below " +
                         "minimum of " + minLength, this._$adaptMembers);
            continue;
        }

        // enforce maximum member length
        var maxLength = vertical ?  member.maxHeight : member.maxWidth;
        if (length + deltaLength > maxLength) {
            this.logWarn("adaptMembersToSpace(): ignoring request for " + deltaLength + " px " +
                         "returned from adaptWidthBy/adaptHeightBy() by member " +
                         member.getID() + " since it would increase member length above " +
                         "maximum of " + maxLength, this._$adaptMembers);
            continue;
        }

        var originalRemainingSpace = remainingSpace;

        if (this.logIsInfoEnabled(this._$adaptMembers)) {
            this.logInfo("adaptMembersToSpace(): member " + member.getID() + " has accepted " +
                         "offer of " + deltaLength + "(" + remainingSpace + " offered) pixels",
                         this._$adaptMembers);
        }
        member._acceptedAdaptOffer = deltaLength;
        sizes[index]              += deltaLength;
        remainingSpace            -= deltaLength;
        adapted = true;

        // user's length change granted - update cached adapted length
        if (passAdaptedLength) member._lastAdaptedLength = sizes[index];
        else if (canOverflow) delete member._lastAdaptedLength;


        if (originalRemainingSpace < 0 && remainingSpace > 0) return remainingSpace;
    }

    return null;
},

// get target sizes for members, by gathering current sizes and applying stretchResizePolicy
_getMemberSizes : function (totalSpace, overflowAsFixed, sizes, layoutInfo) {

    // re-use an Array for storing gathered and calculate sizes.  Note this must be
    // per-instance as child widgets may be Layouts
    if (!sizes) {
        sizes = this._sizesArray;
        if (sizes == null) sizes = this._sizesArray = [];
        else sizes.length = this.members.length;
    }

    // gatherSizes() will set up the layoutInfo array

    layoutInfo = this.gatherSizes(overflowAsFixed, layoutInfo, sizes);

    // Populate the sizes array with the policy-length values
    this._getPolicyLengths(sizes, layoutInfo);

    // fit the adaptive-size members to the available space

    var additionalSpaceAvailable = this.adaptMembersToSpace(sizes, totalSpace, overflowAsFixed, layoutInfo);
    if (overflowAsFixed && additionalSpaceAvailable) {
        this._revertOverflowedStretchSizedPolicyLengths(layoutInfo, sizes);
    }

    // for members that overflowed their specified lengths, treat the overflowed
    // (natural) size as a minimum in stretchResizePolicy
    var overflowedNaturalSizes = layoutInfo.getProperty("_overflowedLength");

    return this.applyStretchResizePolicy(
        sizes, totalSpace,
        Math.max(this.minMemberSize, this.minMemberLength),

        true,
        overflowedNaturalSizes);
},

//StackDepth this strange factoring is to avoid a stack frame
_layoutChildrenDone : function (reason, layoutAlreadyInProgress) {

    this._willScrollLength = null;

    // the layout is now up to date and any changes we see from here on, we need to respond to
    this._layoutIsDirty = false;
    this._layoutInProgress = layoutAlreadyInProgress;


    // if moving and resizing of children has marked us as needing an adjustOverflow, run it
    // now.  Otherwise, it will run after a timer, and if we change size our parent will only
    // react to it after yet another timer, and the browser may repaint in the meantime,
    // creating too much visual churn.
    // However, we shouldn't attempt to adjustOverflow() now if the _suppressAdjustOverflow
    // flag is set because the _overflowQueued flag will be cleared, but adjustOverflow() will
    // no-op.
    if (this._overflowQueued && !this._suppressAdjustOverflow && this.isDrawn() &&
        // NOTE: adjustOverflow can call layoutChildren for eg scroll state changes, don't call
        // it recursively.
        !this._inAdjustOverflow &&
        // Also don't call it when we're resized, because resizing does an immediate
        // adjustOverflow anyway (unless we're redrawOnResize, in which it will be delayed and
        // *we* should do an immediate adjustOverflow)
        (reason != "resized" || this.shouldRedrawOnResize()))
    {
        if (this.notifyAncestorsOnReflow && this.parentElement != null) {
            this.notifyAncestorsAboutToReflow();
        }
        //this.logWarn("calling adjustOverflow, reason: " + reason);
        this.adjustOverflow();
        if (this.notifyAncestorsOnReflow && this.parentElement != null) {
            this.notifyAncestorsReflowComplete();
        }
    }

    // if we're not continuously enforcing the layout policy, set the policy to none
    if (!this.enforcePolicy) {
        this.vertical ? this.vPolicy = isc.Layout.NONE : this.hPolicy = isc.Layout.NONE;
    }
},

_getPolicyLengths : function (sizes, layoutInfo) {
    for (var i = 0; i < layoutInfo.length; i++) {
        sizes[i] = layoutInfo[i]._policyLength;
    }
},


_isSizesValidForMember : function (sizes, index) {
    var maxResizedIndex = sizes.maxResizedIndex;
    if (maxResizedIndex == null) return true;
    var minBreadthIndex = this._minBreadthIndex;
    return index == minBreadthIndex ? true : index <= maxResizedIndex;
},

//> @method layout.getMemberSizes()
//
// @return (Array) array of member sizes
// @visibility external
//<
getMemberSizes : function () {
    // callable publicly, so we clone
    if (this.memberSizes) return this.memberSizes.duplicate();
    return this.memberSizes;
},


getScrollWidth : function (calcNewValue) {
    if (isc._traceMarkers) arguments.__this = this;

    // handle deferred adjustOverflow
    if (this._deferredOverflow) {
        this._deferredOverflow = null;
        this.adjustOverflow("widthCheckWhileDeferred");
    }

    // size caching: adjustOverflow needs the old value of scrollWidth/scrollHeight in order to
    // correctly fire resized(), which is cached by the default
    // getScrollHeight()/getScrollWidth() methods, hence anyone who overrides those methods
    // needs to leave a cached value around.
    if (!calcNewValue && this._scrollWidth != null) return this._scrollWidth;

    // NOTE: we can have non-member children, but if so the margin isn't added to them, so we
    // need to calculate member and non-member size separately
    var childrenSize = this.children ? this._getWidthSpan(this.children, true) : 0,
        membersSize = this.members ? this._getWidthSpan(this.members, true) : 0,
        rightMargin = isc.isA.Number(this._rightMargin) ? this._rightMargin : 0,
    // NOTE: tacking margins onto the furthest right/bottom member implies that we are willing
    // to overflow specified size in order to maintain the right/bottom margin, which is the
    // intent.

        scrollSize = this.isRTL() && this.overflow != isc.Canvas.VISIBLE
                        ? Math.max(childrenSize, membersSize)
                        : Math.max(childrenSize, membersSize + rightMargin);

    if (this.overflow == isc.Canvas.VISIBLE &&
        this.useClipDiv && !this._willSuppressOuterDivPadding(false, true))
    {
        scrollSize += isc.Element._getHPadding(this.styleName);

    }

//     this.logWarn("childrenSize: " + childrenSize + ", memberSize: " + membersSize +
//                  ", _rightMargin: " + this._rightMargin + this.getStackTrace());

    return (this._scrollWidth = scrollSize);
},

getScrollHeight : function (calcNewValue) {
    if (isc._traceMarkers) arguments.__this = this;

    if (this._deferredOverflow) {
        this._deferredOverflow = null;
        this.adjustOverflow("heightCheckWhileDeferred");
    }

    if (!calcNewValue && this._scrollHeight != null) return this._scrollHeight;

    var childrenSize = this.children ? this._getHeightSpan(this.children, true) : 0,
        membersSize = this.children ? this._getHeightSpan(this.members, true) : 0,
        bottomMargin = isc.isA.Number(this._bottomMargin) ? this._bottomMargin : 0,
        scrollSize = Math.max(childrenSize, membersSize + bottomMargin);

    return (this._scrollHeight = scrollSize);
},

// Rerunning layout
// --------------------------------------------------------------------------------------------

//> @method layout.layoutIsDirty() [A]
// Returns whether there is a pending reflow of the members of the layout.
// <P>
// Modifying the set of members, resizing members or changing layout settings will cause a
// recalculation of member sizes to be scheduled.  The recalculation is delayed
// so that it is not performed redundantly if multiple changes are made in a row.
// <P>
// To force immediate recalculation of new member sizes and resizing of members, call
// +link{reflowNow()}.
//
// @return (boolean) whether the layout is currently dirty
// @visibility external
//<
layoutIsDirty : function () {
    return this._layoutIsDirty == true;
},


//>    @method    layout.reflow() [A]
// Layout members according to current settings.
// <P>
// Members will reflow automatically when the layout is resized, members resize, the list of
// members changes or members change visibility.  It is only necessary to manually call
// <code>reflow()</code> after changing settings on the layout, for example,
// <code>layout.reverseOrder</code>.
//
// @param [reason] (String) reason reflow() had to be called (appear in logs if enabled)
//
// @visibility external
//<
reflow : function (reason) {
    // if we're already dirty, we've already set a timer to re-layout
    if (this._layoutIsDirty) return;

    if (this.isDrawn()) {
        this._layoutIsDirty = true;
        if (this.instantRelayout) {
            //isc.logWarn("reflowing NOW");
            this.layoutChildren(reason);
        } else {
            isc.Layout.reflowOnTEA(this, reason);
        }
    }
},

//> @method layout.reflowNow() [A]
// Layout members according to current settings, immediately.
// <br>
// Generally, when changes occur that require a layout to reflow (such as members being shown
// or hidden), the Layout will reflow only after a delay, so that multiple changes cause only
// one reflow.  To remove this delay for cases where it is not helpful, reflowNow() can be
// called.
// @visibility external
//<
reflowNow : function (reason, reflowCount) {

    // No need to reflow if we're undrawn

    if (!this.isDrawn()) return;

    if (reflowCount != null && reflowCount < this._reflowCount) return;
    this.layoutChildren(reason);
},

// If a user is resizing a widget via a drag (or a drag on resizeBar, etc), we want to
// allow the dragged edge to resize to the expected mouse position and keep the other
// edge still. This means fixing (freezing) the sizes of any prior members that previously had
// percent/"*" sizes.
fixLayoutOnMemberResize:true,
// This notification is fired from a canDragResize:true member, or from a target
// resize (drag from resizeBar / sectionStack section header)
_childResizingOnDragStart : function (child, resizeEdge) {
    if (!this.fixLayoutOnMemberResize) return this.Super("_childResizingOnDragStart", arguments);
    if (this.members.contains(child)) {
        var forward = this.vertical ? resizeEdge.contains("B") : resizeEdge.contains("R");

        // If we're dragging from the leading edge (bottom or right), we want to fix sizes
        // of prior members so the top edge stays still and the bottom edge ends up whereever
        // the user releases the mouse

        if (forward) {
            for (var i = 0; i < this.members.indexOf(child); i++) {
                var priorMember = this.members[i];

                if (this._memberWillResizeOnReflow(priorMember)) {
                    priorMember.updateUserSize(
                        this.vertical ? priorMember.getHeight() : priorMember.getWidth(),
                        this.vertical ? "height" : "width",
                        "Fixing other member sizes for drag resize"
                    );

                }
            }

        }
    }

},


// Helper to determine whether a member will resize to fill the available space on
// reflow when gatherSizes runs
// Returns true if size was set to an explicitly variable value ("*" / percentage), or
// if our layout-policy should impact the member in question.

_memberWillResizeOnReflow : function (member) {

    if (this._memberPercentLength(member) != null) return true;
    var length = this._explicitLength(member);
    if (length != null) {
        return length == "*";
    } else {
        var policy = this.getLengthPolicy();
        return (policy == "fill" ? !this.memberHasInherentLength(member) : false);
    }

},



// when a member resizes, rerun layout.
childResized : function (child, deltaX, deltaY, reason) {
    if (isc._traceMarkers) arguments.__this = this;

    // Ignore resize on the component mask
    if (this.componentMask == child) return;

    //>Animation
    var animatingShow = child.isAnimating(this._$show),
        animatingHide = child.isAnimating(this._$hide),
        animatingRect = child.isAnimating(this._$rect),
        animatingResize = child.isAnimating(this._$resize),
        animating = (animatingShow || animatingHide || animatingRect || animatingResize);

    // If this is an animated resize, and we have the flag to suppress member animation, just
    // finish the animation as it's too expensive to respond to every step.
    if (this.suppressMemberAnimations && animating) {
        child.finishAnimation(animatingShow ? this._$show :
                                (animatingHide ? this._$hide :
                                    (animatingRect ? this._$rect : this._$resize)));
        return;
    }
    //<Animation

    this._markForAdjustOverflow("child resize");

    if (this._layoutInProgress) {
        return;
    }

    /*
    this.logWarn("child resize for: " + child + ", reason: " + reason +
                 ", deltas: " + [deltaX, deltaY] +
                 ", percent sizes: " + [child._percent_width, child._percent_height] +
                 ", userSizes: " + [child._userWidth, child._userHeight] +
                 ", isMember: " + this.members.contains(child));
    */


    if (child._canvas_initializing) return;

    // non-member child, ignore
    if (!this.members.contains(child)) return;

    var member = child;


    if (reason != "overflow" && reason != "overflow changed" &&
        reason != "Overflow on initial draw") {

        if (deltaX != null && deltaX != 0) {
            member.updateUserSize(member._percent_width || member.getWidth(),
                                  this._$width, reason);
        }
        if (deltaY != null && deltaY != 0) {
            member.updateUserSize(member._percent_height || member.getHeight(),
                                  this._$height, reason);
        }
    }

    // If we're undrawn, no need to proceed

    if (this.getDrawnState() == isc.Canvas.UNDRAWN) {
        return;
    }

    var reflowReason = isc.SB.concat("memberResized: (", deltaX, ",", deltaY, "): ", member.getID());
    //>Animation
    if (animating) this.reflowNow(reflowReason);
    else //<Animation
        this.reflow(reflowReason);
},

_reportNewSize : function (oldSize, member, reason, isWidth) {
    if (!this.logIsDebugEnabled(this._$layout)) return;
    var newSize = isWidth ? member._userWidth : member._userHeight;
    if (newSize != oldSize) {
        this.logDebug("new user " + (isWidth ? "width: " : "height: ") + newSize +
                      " for member " + member + ", oldSize: " + oldSize +
                      " reason: " + reason +
                      (this.logIsDebugEnabled("userSize") ? this.getStackTrace() : ""),
                      "layout");

    }
},

// immediately handle change to user size - called from Canvas.updateUserSize()
childUserSizeChanged : function (member, name) {
    if (!this.hasMember(member)) return false;

    var isWidth = name == this._$width;
    if (this.isDrawn() && this.vertical != isWidth) {
        this.reflow(member.getID() + " set " + name + " to '*'");
    }
    return true;
},

// when a member changes visibility, rerun layout.
// XXX reacting to childVisibilityChanged isn't adequate when members aren't children
childVisibilityChanged : function (child, newVisibility, c,d,e) {
    if (!this.members.contains(child)) return;

    //this.logWarn("childVisChange: child: " + child + this.getStackTrace());

    // an undrawn hidden member that gets show()n needs to be drawn on the next reflow, so we
    // can't take the stacking-only shortcut in layoutChildren()
    if (!child.isDrawn()) this._breadthChanged = true;

    // NOTE: With our default strategy reflowing on a timer, members made visible this way will
    // appear briefly at the wrong location before reflow occurs.  However, we don't want to
    // fix this by always calling reflowNow(), because it means that several show()s in the
    // same thread would reflow multiple times unnecessarily.  Ideally, we could set a special
    // kind of action to reflow() at the end of the current thread rather than on a timer.
    // Code that does a series of show()s can work around this problem by calling reflowNow()
    // at the end.
    this.reflow("member changed visibility: " + child);
    // If the child was showing a resize bar, and the resizeBy shows closed/open state,
    // update it's state
    var resizeBar = child._resizeBar;
    if (resizeBar == null || resizeBar.target != child) {
        resizeBar = null;
        var prevChild = this.members[this.members.indexOf(child)-1];
        if (prevChild && prevChild._resizeBar != null && prevChild._resizeBar.target == child) {
            resizeBar = prevChild._resizeBar;
        }

    }
    if (resizeBar != null && resizeBar.showGrip && resizeBar.showClosedGrip && resizeBar.label) {

        resizeBar.label.stateChanged();
    }
    this.invokeSuper(isc.Layout, "childVisibilityChanged", child, newVisibility, c,d,e);
},

pageResize : function () {

    var reflowCount = this._reflowCount;
    this.Super("pageResize", arguments);
    // If the default 'pageResize' implementation resized this canvas it will already have
    // reflowed our members - if this didn't occur explicitly reflow now.
    if (this.isDrawn() &&
        (this._reflowCount == null || reflowCount == this._reflowCount))
    {
        this.reflow("pageResize");
    }
},


_$uiSummaryProps: isc.Layout._addToSuperClassSummaryProps([
    "canDropComponents"
]),
getUISummary : function (hierarchyExcluded, thisCanvasExcluded) {
    thisCanvasExcluded = thisCanvasExcluded || [];
    thisCanvasExcluded.add("children");

    var summary = this.Super("getUISummary", [hierarchyExcluded, thisCanvasExcluded]);

    var excluded = [];
    excluded.addList(hierarchyExcluded);
    excluded.addList(thisCanvasExcluded);

    // recursively add summary for member canvii to the summary for this canvas
    if (!excluded.contains("members")) {
        this._addChildrenToUISummary(summary, "members", excluded, hierarchyExcluded);
    }

    return summary;
},


// Sections
// ---------------------------------------------------------------------------------------
// Full declarative section support (including mutex visibility), is provided by the SectionStack
// subclass of Layout, but Layout supports manual instantiation of SectionHeaders
sectionHeaderClick : function (sectionHeader) {
    var section = sectionHeader.section;
    if (section == null) return;

    if (!isc.isAn.Array(section)) section = [section];

    var anyVisible = false;
    for (var i = 0; i < section.length; i++) {
        if (isc.isA.String(section[i])) section[i] = window[section[i]];
        // NOTE: individual members of the group may be hidden, eg by clicking on resizeBars.
        // Assume if any members of the group are visible, the group should be considered
        // visible and hence be hidden.
        if (section[i].visibility != "hidden") anyVisible = true;
    }
    if (anyVisible) {
        section.callMethod("hide");
        sectionHeader.setExpanded(false);
    } else {
        section.callMethod("show");
        sectionHeader.setExpanded(true);
    }
},

// Retrieving Members
// --------------------------------------------------------------------------------------------

//>    @method    layout.getMember()
// Given a numerical index or a member +link{canvas.name,name} or member +link{canvas.ID,ID},
// return a pointer to the appropriate member.  If passed a member Canvas, just returns it.
// <p>
// Note that if more than one member has the same <code>name</code>, passing in a
// <code>name</code> has an undefined result.
//
// @param memberID (String | int | Canvas) identifier for the required member
// @return (Canvas)  member widget
// @see getMemberNumber()
// @visibility external
//<
getMember : function (member) {
    var index = this.getMemberNumber(member);
    if (index == -1) return null;
    return this.members[index];
},

//>    @method    layout.getMemberNumber()
// Given a member Canvas or member +link{canvas.ID,ID} or +link{canvas.name,name}, return the
// index of that member within this layout's members array.  If passed a number, just returns it.
// <p>
// Note that if more than one member has the same <code>name</code>, passing in a
// <code>name</code> has an undefined result.
//
// @param memberID (String | Canvas | int) identifier for the required member
// @return (int) index of the member canvas (or -1 if not found)
// @see getMember()
// @visibility external
//<
getMemberNumber : function (member) {
    // String: assume global ID of widget
    if (isc.isA.String(member)) {
        var index = this.members.findIndex("name", member);
        if (index != -1) return index;

        member = window[member];
        return this.members.indexOf(member);

    // Widget: check members array
    } else if (isc.isA.Canvas(member)) {
        return this.members.indexOf(member);
    }
    // Number: return unchanged
    if (isc.isA.Number(member)) return member;

    // otherwise invalid
    return -1;
},

//>    @method    layout.hasMember()
// Returns true if the layout includes the specified canvas.
// @param canvas (Canvas) the canvas to check for
// @return (Boolean) true if the layout includes the specified canvas
// @visibility external
//<
hasMember : function (canvas) {

    var retValue = this.members.contains(canvas);

    return retValue;
},

//>    @method    layout.getMembers()  ([])
// Get the Array of members.
// <smartclient>
// <p>
// <b>NOTE</b>: the returned array should not be modified directly.  Use +link{addMember()} /
// +link{removeMember()} to add or remove members from the Layout.  Call
// +link{List.duplicate(),duplicate()} on the returned Array if you need a copy of the members
// array for some other purpose.
// </smartclient>
// @return (Array of Canvas) the Array of members
// @visibility external
//<
getMembers : function (memberNum) {
    return this.members;
},

//>    @method    layout.getMembersLength()  ([])
// Convenience method to return the number of members this Layout has
// @return (Integer) the number of members this Layout has
// @visibility external
//<
getMembersLength : function (memberNum) {
    if (!this.members) return 0;
    return this.members.length;
},

// Print HTML - ensure we print in member order
getPrintChildren : function () {
    var children = this.members;
    if (!children || children.length == 0) return;
    var printChildren = [];
    for (var i = 0; i < children.length; i++) {
        if (this.shouldPrintChild(children[i])) printChildren.add(children[i]);
    }
    return (printChildren.length > 0) ? printChildren : null;
},

// For HLayouts, render children inside a table so they're
// in a horizontal row.

_joinChildrenPrintHTML : function (childrenHTML) {
    if (childrenHTML != null && !this.vertical) {
        if (!isc.isAn.Array(childrenHTML)) childrenHTML = [childrenHTML];
        return "<table><tr><td>" + childrenHTML.join("</td><td>") + "</td></tr></table>";
    } else {
        return this.Super("_joinChildrenPrintHTML", arguments);
    }
},

// modify the getCompletePrintHTML function to write table-tags around the children HTML if
// appropriate
printFillWidth:true,
getCompletePrintHTMLFunction : function (HTML, callback) {
    // The HTML / callback params will be available due to JS closure
    var self = this;
    return function (childrenHTML) {
        self.isPrinting = false;
        var vertical = self.vertical || self.printVertical;
        if (isc.isAn.Array(childrenHTML) && childrenHTML.length > 0) {
            if (vertical) childrenHTML = childrenHTML.join(isc.emptyString);
            else {
                childrenHTML = "<TABLE" +
                                (self.printFillWidth ? " WIDTH=100%>" : ">") +
                                "<TR><TD valign=top>" +
                                childrenHTML.join("</TD><TD valign=top>") + "</TD></TR></TABLE>";
            }
        }
        if (childrenHTML) HTML[2] = childrenHTML;
        HTML = HTML.join(isc.emptyString);
        delete self.currentPrintProperties;
        if (callback) {
            self.fireCallback(callback, "html, callback", [HTML, callback]);
            return null;
        } else {
            //self.logWarn("completePrintHTML() - no callback, returning HTML");
            return HTML;
        }
    }
},

// Adding/Removing members
// --------------------------------------------------------------------------------------------

//>    @method    layout.addMember()  ([])
// Add a canvas to the layout, optionally at a specific position.
// <P>
// Depending on the layout policy, adding a new member may cause existing members to
// resize.
// <P>
// When adding a member to a drawn Layout, the layout will not immediately reflow, that is, the
// member will not immediately draw and existing members will not immediately resize.  This is
// to allow multiple new members to be added and multiple manual resizes to take place without
// requiring layout members to redraw and resize multiple times.
// <P>
// To force an immediate reflow in order to, for example, find out what size a newly added
// member has been assigned, call +link{reflowNow()}.
// <P>
// The <code>position</code> parameter specifies where the member (or members for +link{addMembers()})
// should be inserted within the existing members of this layout. You can think of this
// as the index of a gap between existing members. If <code>addMember()</code> is called
// with an existing member this may not be the same as the final index for the member after
// the method completes. If the member is being moved forwards, it will be removed and
// reinserted at the specified insertion position, meaning the final index will be <code>position-1</code>.
// <P>
// For example, if a layout has a member <code><i>myMember</i></code> at index
// <code>n</code> within the members array,<br>
// <code>&nbsp;&nbsp;layout.addMember(<i>myMember</i>, n+1);</code><br>
// would attempt to insert the member directly after itself (which is a no-op) and<br>
// <code>&nbsp;&nbsp;layout.addMember(<i>myMember</i>, n+2);</code><br>
// places the member after the component that
// currently follows it in the members array. This will ultimately put <code>myMember</code> at index
// <code>n+1</code>.
//
// @param newMember (Canvas) the canvas object to be added to the layout
// @param [position] (Integer) If passed, this specifies the insertion position between
//  the existing members of the layout. If omitted, the canvas will be added at the last position
// @see addMembers()
// @visibility external
//<
addMember : function (newMember, position, dontAnimate, callback) {
    this.addMembers(newMember, position, dontAnimate, callback);
    return this;
},

//>    @method    layout.addMembers() ([])
// Add one or more canvases to the layout, optionally at a specific position.  See
// +link{addMember()} for details.
//
// @param newMembers (Array of Canvas | Canvas) array of canvases to be added or single Canvas
// @param [position] (Integer) If passed, this specifies the insertion position between
//  the existing members of the layout. If omitted, the canvas will be added at the last position
// @visibility external
//<
_singleArray : [],
_$membersAdded : "membersAdded",
addMembers : function (newMembers, position, dontAnimate, callback) {
    if (!newMembers) return;

    if (isc._traceMarkers) arguments.__this = this;

    //>Animation If we're in the process of a drag/drop animation, finish it up before
    // proceeding to remove members
    this._finishDropAnimation(); //<Animation

    if (this.logIsInfoEnabled(this._$layout)) {
        this.logInfo("adding newMembers: " + newMembers +
                     (position != null ? " at position: " + position : ""),
                     "layout");
    }

    if (!isc.isAn.Array(newMembers)) {
        this._singleArray[0] = newMembers;
        newMembers = this._singleArray;
    }

    if (this.members == null) this.members = [];

    // if the position is beyond the end of the layout, clamp it to the last index.
    // This is an incorrect call, but happens easily if the calling code removes members before
    // adding.
    if (position > this.members.length) position = this.members.length;

    var layoutDrawn = this.isDrawn(),
        numSkipped = 0;
    var dups = this._checkMembersForDuplicates(newMembers);
    if (dups.length != 0) {
        this.logWarn("addMembers(): new members array contained the following component(s) multiple times:" +
            dups + ". This is unsupported. Duplicate Canvas entries will be removed. " +
            "Duplicate LayoutSpacer entries will be replaced with new LayoutSpacers with the same dimensions.");

    }
    for (var i = 0; i < newMembers.length; i++) {

        var newMember = newMembers[i];

        // support sparse array
        if (!newMember) {
            ++numSkipped;
            continue;
        }

        // if the member is a (manually-created) LayoutResizeBar, initialize it now
        if (isc.isA.LayoutResizeBar(newMember)) this.initResizeBarMember(newMember);

        if (!isc.isAn.Instance(newMember)) {
            newMember = this.createCanvas(newMember);
        }
        if (!isc.isA.Canvas(newMember)) {
            this.logWarn("addMembers() unable to resolve member:" + this.echo(newMember) +
                         " to a Canvas - ignoring");
            ++numSkipped;
            continue;
        }

        if (this.members.contains(newMember)) {
            // already a member; if a position was specified, move to that position
            if (position != null) {
                var d = i - numSkipped,
                    currentPos = this.members.indexOf(newMember),
                    newPos = position + d;

                if (currentPos < newPos) {
                    ++numSkipped;
                    --newPos;
                }
                this.members.slide(currentPos, newPos);

                // Shift the member in the page's tab order
                if (this.isDrawn()) this.updateMemberTabPosition(newMember);

            }
            continue; // but don't do anything else
        }
        // if the new member has snapTo set or is a peer, add it and continue

        if (newMember.addAsPeer || newMember.snapEdge) {
            this.addPeer(newMember, null, false);
            ++numSkipped;
            continue;
        } else if (newMember.addAsChild || newMember.snapTo) {
            this.addChild(newMember, null, false);
            ++numSkipped;
            continue;
        }
        // really a new member (not just changing positions)

        // deparent the member if it has a parent and clear() it if it's drawn.  This is key to
        // do before we begin resizing the member for this new Layout, otherwise:
        // - the old parent would receive childResized() notifications and may react
        // - if the member was drawn, we would pointlessly resize a DOM representation we are
        //   about to clear()

        if (newMember.parentElement !== this) {
            if (newMember.parentElement) newMember.deparent();
            if (newMember.isDrawn()) newMember.clear();
        }

        if (position != null) {
            // add the new member
            this.members.addAt(newMember, position + i - numSkipped);
        } else {
            this.members.add(newMember);
        }

        // note: no call to 'updateMemberTabPosition' here - we'll rely on addChild to
        // pick up the desired position from our overridden getChildTabPosition method.

        // pick up explicit size specifications, if any
        this._getUserSizes(newMember);

        // set breadth according to sizing policy
        this.autoSetBreadth(newMember);

        //>Animation    If animating we want the member to be hidden so we can do an animateShow()
        // once it's in place
        var shouldAnimateShow = layoutDrawn && this.animateMembers &&
                                !dontAnimate &&
                                newMembers.length == 1 &&
                                newMember.visibility != isc.Canvas.HIDDEN;
        if (shouldAnimateShow) newMember.hide();
        //<Animation

        // add the member as a child or peer, suppressing the behavior of automatically drawing a
        // child or peer as it gets added, because we don't want this member to draw until the
        // sizing policy gets run and gives it a size.
        var drawNow = (layoutDrawn && this.getLengthPolicy() == isc.Layout.NONE);
        if (this.membersAreChildren) {
            this.addChild(newMember, null, drawNow);
        } else {
            this.addPeer(newMember, null, drawNow);
        }

        // move to 0,0 to avoid any getScrollHeight/Width() calls that happen before reflow
        // picking up this newMember at a large left/top coordinate.  In particular this can
        // happen if centering wrt visible breadth.
        newMember.moveTo(0,0);

        // if the member has inherent length, make sure it gets drawn before the policy runs
        if (this.isDrawn() && this.memberHasInherentLength(newMember)) {
            this._moveOffscreen(newMember);
            if (!newMember.isDrawn()) newMember.draw();
        }
    }
    //>EditMode
    // If this layout is hidden, resolve the new members' ruleScope now that parentElement is assigned
    // allowing it to contribute to ruleContext before being drawn.
    if (this.editingOn && this.visibility == isc.Canvas.HIDDEN && !this.isDrawn()) {
        for (var i = 0; i < newMembers.length; i++) {
            var newMember = newMembers[i];
            // support sparse array
            if (!newMember) continue;
            newMember.computeRuleScope();

            newMember._recomputeRuleScopeOnDraw = true;
        }
    }
    //<EditMode

    // avoid leaking an added member
    this._singleArray[0] = null;

    //>Animation
    // We're relying on the fact that we have a single member in the array - newMember will
    // always be the member newMembers[0] refers to.
    if (shouldAnimateShow) {
        this._animateMemberShow(newMember, callback);
    } else    //<Animation
        this.reflow(this._$membersAdded);

    // fire _membersChanged()
    this._membersChanged();
},

// pick up explicit size specifications, if any
_getUserSizes : function (newMember) {

    // support sparce members array
    if (newMember == null) return;


    if (newMember._percent_width) {
        newMember.updateUserSize(newMember._percent_width, this._$width);
    }
    //else if (newMember._widthSetAfterInit) {
    //    this.logWarn("picked up width for member: " + newMember +
    //                 ", width: " + newMember.getWidth());
    //    newMember.updateUserSize(newMember.getWidth(), this._$width);
    //}
    if (newMember._percent_height) {
        newMember.updateUserSize(newMember._percent_height, this._$height);
    }
    //else if (newMember._heightSetAfterInit) {
    //    this.logWarn("picked up height for member: " + newMember +
    //                 ", height: " + newMember.getHeight());
    //    newMember.updateUserSize(newMember.getHeight(), this._$height);
    //}


    if (this.memberHasInherentLength(newMember)) {
        if (!newMember._userHeight && !newMember._heightSetAfterInit) {
            //this.logWarn("restoring default height on add");
            newMember.restoreDefaultSize(true);
        }
        if (!newMember._userWidth && !newMember._widthSetAfterInit) {
            //this.logWarn("restoring default width on add");
            newMember.restoreDefaultSize();
        }
    }
},

// to cleanly animate additions and removals of members, we have to animate the membersMargin
// as well
_animateMargin : function (member, added) {
    var layout = this;

    // if the last member is being added or removed, animate the preceding member's margin
    // instead
    var addRemoveMember = member;
    var memberNum = this.getMemberNumber(member);
    if (memberNum == this.members.length - 1) member = this.getMember(--memberNum);
    if (!member) return;


    var nextMember = this.getMember(memberNum + 1),
        membersMargin = isc.isA.LayoutResizeBar(member) ||
                        isc.isA.LayoutResizeBar(nextMember) ? 0 : this.membersMargin
    ;

    // when animating simultaneous addition and removal of same-size members (eg D&D reorder),
    // it's important that the Layout not change overall size.  This is only possible if both
    // members have the same size, their animations start simulteanously and fire on the same
    // frame, and have the same accelleration.
    // The first reflow will be triggered by addition/removal of members with the added member
    // at 1px height and the removed member still at full height.
    var margin = membersMargin + this.getMemberGap(member);
    if (added) member._internalExtraSpace = -(margin+1);
    //if (added) member._internalExtraSpace = -margin; // alternative margin placement
    //else member._internalExtraSpace = -1;

    this.registerAnimation(
        function (ratio) {
            // round, then subtract to ensure the margin adjustments for simultaneous
            // add/remove add to one whole membersMargin exactly.
            // NOTE: simultaneous show/hide animations will have matching deltas because they
            // apply the same ratio to the same total size difference (fullSize to/from 1px)
            var fraction = Math.floor(ratio * margin);
            if (added) fraction = margin - fraction;

            member._internalExtraSpace = -fraction;
            //isc.Log.logWarn("set extraSpace on member: " + member +
            //                " to: " + member._internalExtraSpace + " on ratio: " + ratio);

            if (ratio == 1) member._internalExtraSpace = null;
        },
        this.animateMemberTime
    );
},

// override removeChild to properly remove children which are also members
removeChild : function (child, name) {

    isc.Canvas._instancePrototype.removeChild.call(this, child, name);
    //this.Super("removeChild", arguments);

    if (this.membersAreChildren && this.members.contains(child)) {
        this.removeMember(child);
    }
},

//>    @method    layout.removeMember()  ([])
// Removes the specified member from the layout.  If it has a resize bar, the bar will be
// destroyed.
//
// @param member (Canvas) the canvas to be removed from the layout
// @visibility external
//<
removeMember : function (member, dontAnimate, callback) {
    this.removeMembers(member, dontAnimate, callback);
},


//>    @method    layout.removeMembers()  ([])
//
//  Removes the specified members from the layout. If any of the removed members have resize
//  bars, the bars will be destroyed.
//
//     @param members (Array of Canvas | Canvas) array of members to be removed, or single member
//    @visibility external
//<
removeMembers : function (members, dontAnimate, callback) {
    if (members == null || (isc.isAn.Array(members) && members.length == 0)) return;

    //>Animation If we're in the process of a drag/drop animation, finish it up before
    // proceeding to remove members
    this._finishDropAnimation(); //<Animation

    if (!isc.isAn.Array(members)) {
        this._singleArray[0] = members;
        members = this._singleArray;
    }
    // if we were passed our own members array, copy it, because otherwise we'll get confused
    // when iterating through it, and simultaneously removing members from it!
    if (members === this.members) members = members.duplicate();

    // Resolve all member IDs to actual members
    // Note: do this before we start removing members, so if we're passed an index, the removal
    // of other members won't modify it.
    for (var i = 0; i < members.length; i++) {
        var memberId = members[i];
        if (isc.isA.Canvas(animatingMember)) continue;
        members[i] = this.getMember(memberId);
        if (members[i] == null) {
            this.logWarn("couldn't find member to remove: " + this.echoLeaf(memberId));
            members.removeAt(i);
            i -=1;
        }
    }

    //>Animation
    // If we have a single member, and we're animating member change, animate hide() it before
    // removing it.
    var shouldAnimate = (this.animateMembers && members.length == 1 && !dontAnimate),
        animatingMember = (shouldAnimate ? members[0] : null);

    if (shouldAnimate) {
        // don't try to animate something deparenting or destroying, or invisible
        if (animatingMember.parentElement != this ||
            animatingMember.destroying || !animatingMember.isVisible())
        {
            shouldAnimate = false;
        }
    }
    if (shouldAnimate) {
        // NOTE: copy the Array of members to remove to avoid changes during the animation.
        // Note this avoids changes to the passed in Array as well as incorrect reuse of the
        // singleton this._singleArray during the animation.
        var layout = this,
            removeMembers = members.duplicate();
        this._animateMemberHide(animatingMember, function () {
            layout._completeRemoveMembers(removeMembers);
            if (callback) callback.apply(animatingMember, arguments);
        });
    // If we're not animating fall through to _completeRemoveMembers() synchronously
    } else {
    //<Animation

        this._completeRemoveMembers(members);
    //>Animation
    }   //<Animation

    // clear the singleton Array
    this._singleArray[0] = null;
    // fire _membersChanged()
    this._membersChanged();
},

// internal method fired to complete removing members
_$membersRemoved : "membersRemoved",
_completeRemoveMembers : function (members) {
    if (!members) return;

    for (var i = 0; i < members.length; i++) {
        var member = members[i];
        this.members.remove(member);

        // NOTE: the member.parentElement check avoids a loop when removeMembers is called from
        // removeChild
        if (this.membersAreChildren && member.parentElement == this) member.deparent();

        member._heightSetAfterInit = member._widthSetAfterInit = null;

        // if we created a resizeBar for this member, destroy it
        if (member._resizeBar) {
            member._resizeBar.destroy();
            member._resizeBar = null;
        }
        // the member should no longer show us when it gets shown
        if (member.showTarget == this) delete member.showTarget;

        // clean up most important LayoutResizeBar state
        if (isc.isA.LayoutResizeBar(member)) {
            delete member.vertical;
            delete member.layout;
        }

        if (member._isPlaceHolder) member.destroy();
    }

    this.reflow(this._$membersRemoved);
},

//> @method layout.setMembers()
// Display a new set of members in this layout. Equivalent to calling removeMembers() then
// addMembers(). Note that the new members may include members already present, in which case
// they will be reordered / integrated with any other new members passed into this method.
// @param members (Array of Canvas)
// @visibility external
//<
setMembers : function (members) {
    if (members == this.members || !isc.isAn.Array(members)) return;
    var removeMembers = [];

    if (this.members != null) {
        for (var i = 0; i < this.members.length; i++) {
            if (!members.contains(this.members[i])) removeMembers.add(this.members[i]);
        }
    }
    var instantRelayout = this.instantRelayout;
    this.instantRelayout = false;
    this.removeMembers(removeMembers, true);
    // Note members may contain some members we already have (and shuffle order etc)
    // addMembers should handle this.

    this.addMembers(members, 0, true);
    this.instantRelayout = instantRelayout;
    if (instantRelayout) this.reflow("set members");

},


// Methods to show/hide members, with animation if appropraite

//> @method layout.showMember()
// Show the specified member, firing the specified callback when the show is complete.
// <P>
// Members can always be directly shown via <code>member.show()</code>, but if
// +link{animateMembers,animation} is enabled, animation will only occur if showMember() is
// called to show the member.
//
// @param member (Canvas) Member to show
// @param [callback] (Function) action to fire when the member has been shown
// @visibility external
//<
showMember : function (member, callback) {
    return this.showMembers([member], callback);
},

//> @method layout.showMembers()
// Show the specified array of members, and then fire the callback passed in.
// @param members (Array of Canvas) Members to show
// @param [callback] (Callback) action to fire when the members are showing.
//<
//>Animation  If <code>this.animateMembers</code> is true, the show will be performed as an
// animation in the case where a single, animate clip-able member was passed.   //<Animation
showMembers : function (members, callback) {
    //>Animation
    if (this.isDrawn() && this.animateMembers && members.length == 1) {
        this._animateMemberShow(members[0], callback);
    } else {    //<Animation
        for (var i = 0; i < members.length; i++) {
            var member = this.getMember(members[i]);
            member.show();
        }
        this.fireCallback(callback);
    //>Animation
    }   //<Animation
},

// shared between showMembers and addMembers
_animateMemberShow : function (member, callback) {
    member = this.getMember(member);
    this.setNewMemberLength(member);
    member.animateShow(this.animateMemberEffect, callback, this.animateMemberTime);
    if (member.isAnimating()) this._animateMargin(member, true);
},


setNewMemberLength : function (newMember) {
    // resize the new member to the desired size
    newMember._prefetchingSize = true;
    var sizes = this._getMemberSizes(this.getTotalMemberSpace());
    delete newMember._prefetchingSize;
    var size = sizes[this.members.indexOf(newMember)];

    // apply the height; avoid it being regarded as a new user size
    var oldSetting = this._layoutInProgress;
    this._layoutInProgress = true;

    this.vertical ? newMember.setHeight(size) : newMember.setWidth(size);
    this._layoutInProgress = oldSetting;

},

//> @method layout.hideMember()
// Hide the specified member, firing the specified callback when the hide is complete.
// <P>
// Members can always be directly hidden via <code>member.hide()</code>, but if
// +link{animateMembers,animation} is enabled, animation will only occur if hideMember() is
// called to hide the member.
//
// @param member (Canvas) Member to hide
// @param [callback] (Function) callback to fire when the member is hidden.
// @visibility external
//<
hideMember : function (member, callback) {
    return this.hideMembers([member], callback);
},

//> @method layout.hideMembers()
// Hide the specified array of members, and then fire the callback passed in.
// @param members (Array of Canvas) Members to hide
// @param [callback] (Callback) action to fire when the members are hidden.
//<
//>Animation  If <code>this.animateMembers</code> is true, the hide will be performed as an
// animation in the case where a single, animate clip-able member was passed.   //<Animation
hideMembers : function (members, callback) {
    this._hideMembersCallback = callback;
    //>Animation
    if (this.animateMembers && members.length == 1) {
        this._animateMemberHide(members[0], callback);
    } else {//<Animation
        for (var i = 0; i < members.length; i++) {
            var member = this.getMember(members[i]);
            member.hide();
        }
        this.fireCallback(callback);
    //>Animation
    } //<Animation
},


// shared between hideMembers and removeMembers
_animateMemberHide : function (member, callback) {
    // resolve index to actual member
    member = this.getMember(member);
    member.animateHide(this.animateMemberEffect, callback, this.animateMemberTime);
    if (member.isAnimating()) this._animateMargin(member);
},

//> @method layout.setVisibleMember()
// Hide all other members and make the single parameter member visible.
//
// @param member (Canvas) member to show
//
// @visibility external
//<
setVisibleMember : function (member) {
    var theMem = this.getMember(member);
    if (theMem == null) return;
    this.hideMembers(this.members);
    this.showMember(theMem);
},

// Reordering Members
// --------------------------------------------------------------------------------------------

//>    @method    layout.reorderMember()  ([])
// Shift a member of the layout to a new position
//
// @param memberNum   (number)  current position of the member to move to a new position
// @param newPosition (number)  new position to move the member to
//
// @visibility external
//<
reorderMember : function (memberNum, newPosition) {
    this.reorderMembers(memberNum, memberNum+1, newPosition)
},

//>    @method    layout.reorderMembers()  ([])
// Move a range of members to a new position
//
// @param start       (number)  beginning of range of members to move
// @param end         (number)  end of range of members to move, non-inclusive
// @param newPosition (number)  new position to move the members to
//
// @visibility external
//<
reorderMembers : function (start, end, newPosition) {
    this.members.slideRange(start, end, newPosition);
    // update tab index
    for (var i = newPosition; i < newPosition + (end-start); i++) {
        this.updateMemberTabPosition(this.members[i]);
    }
    this._membersReordered("membersReordered");
},

// Helper method to update the UI after the members array has been reworked.

_membersReordered : function (reason) {
    this.layoutChildren(reason);
     // fire _membersChanged()
    this._membersChanged();
},

// replace one member with another, without an intervening relayout, and without animation
_replaceMember : function (oldMember, newMember) {
    var oldSetting = this.instantRelayout;
    this.instantRelayout = false;
    var oldMemberPos = this.getMemberNumber(oldMember);
    if (oldMemberPos < 0) {
        this.logWarn("_replaceMember(): " + oldMember.getID() + " is not a member");
        oldMemberPos = 0;
    } else {
        this.removeMember(oldMember, true);
    }
    this.addMember(newMember, oldMemberPos, true);
    this.instantRelayout = oldSetting;
    if (oldSetting) this.reflowNow();
},

//>    @method    layout.replaceMember()
// Replaces an existing member of the layout with a different widget.  The new member will be
// assigned the width and height of the existing member (including sizes configured via end
// user resize), so no reflow will occur unless the new component has visible overflow and it
// differs from that of the widget it replaced.
//
// @param oldMember (Canvas) an existing member of the layout to be replaced
// @param newMember (Canvas) a different widget that should replace <code>oldMember</code>
// @see RPCManager.createScreen()
// @visibility external
//<
replaceMember : function (oldMember, newMember) {
    // just bail if it would be a no-op
    if (oldMember == newMember) return;

    // non-sensical case; oldMember isn't a member
    if (!this.hasMember(oldMember)) {
        this.logWarn("replaceMember(): the first argument must already be a member widget");
        return;
    }


    var alreadyMember = this.hasMember(newMember);


    var dirty = this.layoutIsDirty();
    this._layoutIsDirty = true;

    // remember the overflow and user sizing of the old member
    var userWidth  = oldMember._userWidth,
        userHeight = oldMember._userHeight,
        visibleWidth  = oldMember.getVisibleWidth(),
        visibleHeight = oldMember.getVisibleHeight()
    ;
    // remember the placement of the old member
    var oldLeft = oldMember.getLeft(),
        oldTop  = oldMember.getTop()
    ;

    // apply the old member's width and height to new member

    var memberPos;
    if (isc.isA.Canvas(newMember)) {
        newMember.resizeTo(oldMember.width, oldMember.height);
    } else {
        memberPos = this.getMemberNumber(oldMember);
        newMember.width = oldMember.width;
        newMember.height = oldMember.height;
    }

    // do actual replacement of members now
    this._replaceMember(oldMember, newMember);

    // if new member was properties object, replace it with widget
    if (memberPos != null) newMember = this.getMember(memberPos);

    // apply user sizing present before resizeTo() above
    newMember.updateUserSize(userWidth,  this._$width);
    newMember.updateUserSize(userHeight, this._$height);

    // place the new member in same spot as the old member
    newMember.moveTo(oldLeft, oldTop);

    // if the new member is still undrawn, draw it now
    if (!newMember.isDrawn()) newMember.draw();


    this._layoutIsDirty = dirty;
    if (!dirty && this.isDrawn()) {
        if (newMember.getVisibleHeight() != visibleHeight || alreadyMember ||
            newMember.getVisibleWidth()  != visibleWidth)
        {
            this.reflow();
        }
    }
},

//> @method layout.membersChanged()
// Fires once at initialization if the layout has any initial members, and then fires whenever
// members are added, removed or reordered.
//
// @visibility external
//<

// internal membersChanged
_membersChanged : function () {
    if (!this.destroying) { // skip if happening during destroy()
        this._computeShowResizeBarsForMembers();
    }

    // fire membersChanged event
    if (this.membersChanged) this.membersChanged();
},

// We keep track of whether the resizeBar should actually be shown in _computedShowResizeBar
// because it depends on showResizeBar, defaultResizeBars and the position of the member
// within the layout. By caching the computed value, we can keep track of changes without
// interfering with the desired setting in showResizeBar itself.
_computeShowResizeBarsForMembers : function () {
    var member, lastMember,
        defResize = this.defaultResizeBars;
    for (var i = this.members.length - 1; i >= 0; i--, lastMember = member) {
        member = this.members[i];

        // handle sparse array
        if (member == null) continue;
        var showResize = false; // Covers defResize == isc.Canvas.NONE
        if (defResize == isc.Canvas.MARKED) {
            showResize = member.showResizeBar;
        } else if (defResize == isc.Canvas.MIDDLE) {
            // Note that we need the explicit comparison to false here and below due to the
            // semantics of defaultResizeBars
            showResize = (i < this.members.length - 1) && (member.showResizeBar != false);
        } else if (defResize == isc.Canvas.ALL) {
            showResize = member.showResizeBar != false;
        }
        if (this.neverShowResizeBars) {
            showResize = false;
        }

        // if a manually-created LayoutResizeBar is present, defer to it

        if (showResize && isc.isA.LayoutResizeBar(lastMember)) {
            if (!lastMember.hasOwnProperty("resizeDirection")) {
                this._applyAutoChildSettingsToResizeBar(member, lastMember, i + 1);
            }
            showResize = false;
        }

        var currentComputedResizeBar = member._computedShowResizeBar;
        member._computedShowResizeBar = showResize;
        if (currentComputedResizeBar != showResize) this.reflow("_computedShowResizeBar changed");
    }

    // members have changed; update LayoutResizeBar's target
    for (var i = this.members.length - 1; i >= 0; i--) {
        var member = this.members[i];
        if (isc.isA.LayoutResizeBar(member)) member._updateTarget(i);
    }
},

// LayoutResizeBars
// --------------------------------------------------------------------------------------------

_applyAutoChildSettingsToResizeBar : function (prevMember, resizeBar, resizeBarPos) {


    // set LayoutResizeBar.target based on resizeBarTarget of member before it
    var targetAfter, target;
    if (prevMember.resizeBarTarget == "next") {
        target = this.getMember(resizeBarPos + 1);
        if (target) targetAfter = true;
    }
    if (!target) target = prevMember;

    // set LayoutResizeBar.hideTarget based on resizeBarHideTarget of member before it
    var hideTarget = target;
    if (prevMember.resizeBarHideTarget != null) {
        hideTarget = prevMember.resizeBarHideTarget == "next" ?
            this.getMember(resizeBarPos + 1) : null;
        if (!hideTarget) hideTarget = prevMember;
    }

    resizeBar.setResizeDirection(targetAfter ? isc.Splitbar.AFTER : isc.Splitbar.BEFORE);

    // provide support for the undoc'd member property resizeBarHideTarget
    if (target != hideTarget) resizeBar.setProperty("hideTarget", hideTarget);
},

initResizeBarMember : function (resizeBar) {
    if (resizeBar.layout == this) return;
    else resizeBar.layout = this;

    // orientation of resizeBar is opposite layout
    var vertical = !this.vertical;
    if (vertical != resizeBar.vertical) {
        resizeBar.setVertical(vertical, true);
    }


    if (vertical) {
        resizeBar.setProperties({
            dragScrollDirection: isc.Canvas.HORIZONTAL,
            width: this.resizeBarSize, inherentWidth: true
        });
    } else {
        resizeBar.setProperties({
            dragScrollDirection: isc.Canvas.VERTICAL,
            height: this.resizeBarSize, inherentHeight: true
        });
    }
},


// Tabbing
// --------------------------------------------------------------------------------------------

//> @method layout.getChildTabPosition()
// Layouts ensure children are ordered
// in the tab-sequence with members being reachable first (in member order), then any
// non-member children.
// <P>
// As with +link{canvas.getChildTabPosition()} if +link{canvas.setRelativeTabPosition()}
// was called explicitly called for some child, it will be respected over member order.
//
// @param child (Canvas) The child for which the tab position should be returned
// @return (Integer) tab position of the child within this layout.
// @visibility external
//<


_getChildrenInDefaultTabOrder : function () {
    var memberOrderedChildren = [];
    if (!this.members || !this.children) return memberOrderedChildren;
    for (var i = 0; i < this.members.length; i++) {
        if (!this.members[i].updateTabPositionOnReparent) continue;
        memberOrderedChildren.add(this.members[i]);
    }
    if (this.members.length != this.children.length) {
        for (var i = 0; i < this.children.length; i++) {
            if (!this.children[i].updateTabPositionOnReparent ||
                this.members.contains(this.children[i]))
            {
                continue;
            }
            memberOrderedChildren.add(this.children[i]);
        }
    }
    return memberOrderedChildren;
},

// Method to update the tab position of some member
// Called from reorderMembers() [or addMember if passed and existing member and we're already drawn, so
// essentially a reorder]
updateMemberTabPosition : function (member) {

    this.logDebug("Update member tab position:" + member +
                  ", index in this.members?:" + this.members.indexOf(member), "TabIndexManager");
    // the override to getChildTabPosition() ensures that standard 'updateChildTabPosition()'
    // will put the member in the right slot.
    return this.updateChildTabPosition(member);
},

// Dragging members out
// --------------------------------------------------------------------------------------------

// if a member is dragged with "target" dragAppearance, put a placeholder into the layout to
// prevent reflow and restacking during the drag

//> @attr layout.placeHolderDefaults (Canvas Properties: null : IR)
// If +link{layout.showDragPlaceHolder, this.showDragPlaceHolder} is true, this
// defaults object determines the default appearance of the placeholder displayed
// when the user drags a widget out of this layout.<br>
// Default value for this property sets the placeholder +link{canvas.styleName, styleName} to
// <code>"layoutPlaceHolder"</code><br>
// To modify this object, use +link{Class.changeDefaults()}
// @group dragdrop
// @visibility external
//<
placeHolderDefaults : {
    styleName:"layoutPlaceHolder",
    overflow:isc.Canvas.HIDDEN
},
dragRepositionStart : function () {

    var dragTarget = isc.EH.dragTarget;

    // only take over the drag interaction if an immediate member is being dragged with target
    // drag animation.
    if (!this.hasMember(dragTarget) || dragTarget.getDragAppearance(isc.EH.DRAG_REPOSITION) != "target") return;

    // record page-level coordinates before reparent
    var left = dragTarget.getPageLeft(),
        top = dragTarget.getPageTop();

    this._popOutDraggingMember(dragTarget, left, top);
},

// This helper method is called when dragging a member out of a layout.
// It will deparent the member and move it to the appropriate position (so it can be dragged
// and/or animated around outside the parent).
// It also adds a spacer to the layout where the member was taken from so we don't get an
// unexpected reflow.

_popOutDraggingMember : function (member, left, top) {

    this._draggingMember = member;

    // make a visible placeHolder if showDragPlaceHolder is set
    var placeHolder = this._createSpacer(member, "_dragOutPlaceHolder", this.showDragPlaceHolder)
    member._dragPlaceHolder = placeHolder;

    // prevent relayout while we deparent and swap a placeholder in.  Also, prevent
    // animation of the placeholder we add
    var oldSetting = this.instantRelayout;
    this.instantRelayout = false;


    this._doPopOutDragMember(placeHolder, member);

    if (!member.isDrawn() || member.readyToRedraw()) {
        // deparent, but keep us in the event processing chain by setting eventParent
        member.deparent();
        member.eventParent = this;

        this.instantRelayout = oldSetting;

        member.moveTo(left,top);
        member.draw();


    } else {
        var memberClipHandle = member.getClipHandle();
        member.getDocumentBody(true).appendChild(memberClipHandle);

        // Prepare a list of the member and all descendants. Visit each one, setting the _drawn
        // flag to false and decrementing the hide using display none counters (as we're moving
        // this whole widget tree to top-level).
        var drawnMemberAndDescendants = [];
        var visit = function (node) {
            if (node._drawn) {
                drawnMemberAndDescendants.add(node);

                if (node._needHideUsingDisplayNone()) {
                    var parent = node.parentElement;
                    while (parent != null) {
                        parent._decrementHideUsingDisplayNoneCounter();
                        parent = parent.parentElement;
                    }
                }

                node._drawn = false;
            }
        };
        var node = member;
        var parentStack = [];
        var top = node;
        while (top != null) {
            visit(top);
            if (top.children != null) parentStack.push.apply(parentStack, top.children);
            top = parentStack.pop();
        }


        member.deparent();
        for (var ri = drawnMemberAndDescendants.length; ri > 0; --ri) {
            var node = drawnMemberAndDescendants[ri - 1];
            node._drawn = true;
            node._completeHTMLInit();
        }


        member.eventParent = this;

        this.instantRelayout = oldSetting;

        member.moveTo(left,top);
    }
},

_doPopOutDragMember : function (placeHolder, member) {
    this.addMember(placeHolder, this.getMemberNumber(member), true);
},

// dragRepositionStop will be bubbled up to the Layout from drag-repositoned members.
// The only supported drag reposition of members is drag reordering / dragging out to
// another layout.  We override this method to
// - suppress the default EventHandler behavior for members (which will directly call 'moveTo()'
//   on the dragTarget in some cases).

// - If dragAppearance on the member being dragged is "Target", on dragRepositionStart() we
//   removed the member from the Layout and put a placeholder in instead.
//   - if a successful drop occurred on this or another layout, that method takes care of
//     removing this placeholder
//   - otherwise remove the placeholder here, and if no drop occurred, put the widget back
//     into our members' array

dragRepositionStop : function () {

    var dragTarget = isc.EH.dragTarget;

    // We may be getting this event bubbled up from a child of a member.
    // in this case allow normal drag repo behavior on the target

    if (!this.members.contains(dragTarget) && dragTarget != this._draggingMember) return;

    // In this case we were drag repositioning a member.
    var appearance = dragTarget.getDragAppearance(isc.EH.DRAG_REPOSITION),
        isTarget = appearance == isc.EH.TARGET;
    // If the appearance is neither OUTLINE nor TARGET - just kill the event
    if (!isTarget && (appearance != isc.EH.OUTLINE)) return false;

    // Default EH.dragRepositionStop() behavior:
    // - if dragAppearance is target, and target.dragRepositionStop() returns false, call
    //   'moveTo' to reset the position of the member to whatever it was before dragging started
    // - if dragAppearance is outline or tracker, and target.dragRepositionStop() does not
    //   return false, call 'moveTo' on the target to move it to the drop position.
    // To suppress both these behaviors we therefore return false if dragAppearance is outline,
    // or STOP_BUBBLING if dragAppearance is target.
    var returnVal = isTarget ? isc.EH.STOP_BUBBLING : false;

    // Clear out the draggingMember
    this._draggingMember = null;
    // no longer act as the event parent
    if (dragTarget.eventParent == this) dragTarget.eventParent = null;

    // If we set up a placeHolder in the dragTarget on dragRepositionStart() we may need to clear
    // it now

    if (dragTarget.dropSucceeded) return returnVal;

    var placeHolder = dragTarget._dragPlaceHolder;
    if (placeHolder != null) {

        // If the member has been reparented or destroyed, it's no longer under our management.
        // Simply remove the placeholder.
        if (dragTarget.parentElement != null || dragTarget.destroyed) {
            this._cleanUpPlaceHolder(dragTarget);

        // otherwise, drop failed, put member back into layout at placeholder

        } else {
            // clear the pointer to the placeholder
            dragTarget._dragPlaceHolder = null;

            var oldPosition = this.getMemberNumber(placeHolder),
                oldRect = placeHolder.getPageRect(),

                layout = this,
                replaceMember = function () {
                    if (dragTarget._canDrag != null) {
                        dragTarget.canDrag = dragTarget._canDrag;
                        delete dragTarget._canDrag;
                    }
                    if (dragTarget._canDragReposition != null) {
                        dragTarget.canDragReposition = dragTarget._canDragReposition;
                        delete dragTarget._canDragReposition;
                    }
                    layout._replaceMember(placeHolder, dragTarget);
                }
            ;

            //>Animation
            // do this via an animation if we are animating member changes
            if (this.animateMembers) {
                // prevent more drags from being initiated on the dragTarget while
                // its animating back to its placeholder position
                dragTarget._canDrag = dragTarget.canDrag;
                dragTarget.canDrag = false;

                dragTarget._canDragReposition = dragTarget.canDragReposition;
                dragTarget.canDragReposition = false;

                dragTarget.animateRect(oldRect[0], oldRect[1], oldRect[2], oldRect[3],
                                       replaceMember);
            } else
            //<Animation
                replaceMember(true);
        }
    }
    return returnVal;
},

_createSpacer : function (member, suffix, visible) {
    var spacer, props;


    if (visible) {
        spacer = this.createAutoChild("placeHolder", props, isc.Canvas);
    } else {
        spacer = isc.LayoutSpacer.create(props);
    }
    spacer.setRect(member.getRect());

    // HACK: since the spacer gets sized outside of the Layout, if we don't do this, the Layout
    // will resize the spacer when it's added
    spacer.updateUserSize(spacer.getWidth(), this._$width);
    spacer.updateUserSize(spacer.getHeight(), this._$height);

    spacer.layoutAlign = member.layoutAlign;

    // Ignore *both*:
    // - memberOverlap (it's already included with the margin of the moved item)
    // - _internalExtraSpace (spacer is placed on fixed locations in the layout)
    spacer.extraSpace = (member.extraSpace || 0);

    spacer._isPlaceHolder = true; // HACK see addMember()

    return spacer;
},

// Helper method to remove the placeHolder set up when a member gets dragged out of this Layout
removePlaceHolder : function (placeHolder) {
    // if the placeHolder wasn't a LayoutSpacer, ie it was something visible, and we're going
    // to animate it's remove, switch to an invisible placeHolder for the animation (the idea
    // is that the placeHolder stands in for the member, and the member isn't actually
    // shrinking)
    if (this.animateMembers && !isc.isA.LayoutSpacer(placeHolder)) {
        var newPlaceHolder = this._createSpacer(placeHolder);
        this._replaceMember(placeHolder, newPlaceHolder);
        placeHolder.destroy();
        placeHolder = newPlaceHolder;
    }
    // this will animate if enabled.  When the remove is complete, the placeholder will also be
    // destroyed
    this.removeMember(placeHolder);
},


// Dropping members in
// --------------------------------------------------------------------------------------------

willAcceptDrop : function () {
    // Allow drop() to bubble by returning null
    if (!this.canDropComponents) {
        return this.canAcceptDrop ? true : null;
    } else if (!this.canAcceptDrop) {
        return null;
    }
    return this.invokeSuper(isc.Layout, "willAcceptDrop");
},

// create and place the dropLine
dropOver : function () {
    // note: allow bubbling
    //>EditMode
    if (this.editingOn && this.editProxy && !this.editProxy.willAcceptDrop()) return;
    //<EditMode
    if (!this.willAcceptDrop()) return;
    this.showDropLine();

    isc.EventHandler.dragTarget.bringToFront();
    return true;
},

// place the dropLine
dropMove : function () {
    //>EditMode
    if (this.editingOn && this.editProxy && !this.editProxy.willAcceptDrop()) return;
    //<EditMode
    if (!this.willAcceptDrop()) return;
    this.showDropLine();
},

dropOut : function () { this.hideDropLine(); },

dropStop : function () { this.hideDropLine(); },

//> @method layout.getDropComponent()
// When +link{canDropComponents} is true, this method will be called when a component is
// dropped onto the layout to determine what component to add as a new layout member.
// <P>
// By default, the actual component being dragged (isc.EventHandler.getDragTarget()) will be
// added to the layout.  For a different behavior, such as wrapping dropped components in
// Windows, or creating components on the fly from dropped data, override this method.
// <P>
// You can also return null to cancel the drop.
//
// @param dragTarget (Canvas) current drag target
// @param dropPosition (int) index of the drop in the list of current members
// @return (Canvas) the component to add to the layout, or null to cancel the drop
//
// @visibility external
//<
getDropComponent : function (dragTarget, dropPosition) {

    // portlet moved
    if (!isc.isA.Palette(dragTarget)) return dragTarget;

    // other, drag and drop from palette, create new portlet
    var data = dragTarget.transferDragData(),
        component = (isc.isAn.Array(data) ? data[0] : data);

    return component.liveObject;
},

//>    @method    layout.drop() (A)
// Layouts have built-in handling of component drag and drop.  See the discussion in
// +link{Layout.canDropComponents} on how it works. If you override this builtin implementation of drop() and
// you're using the built-in dropLine via +link{Layout.canDropComponents}:true, be sure to call
// +link{Layout.hideDropLine()} to hide the dropLine after doing your custom drop() handling.
//
// @return (boolean) Returning false will cancel the drop entirely
// @visibility external
//<
drop : function () {

    if (!this.willAcceptDrop() || this._suppressLayoutDrag) return;

    var dropPosition = this.getDropPosition();
    var newMember = this.getDropComponent(isc.EventHandler.getDragTarget(), dropPosition);
    // allow cancelation of the drop from getDropComponent
    // we pass through the value to distinguish between null (cancel but continuing bubbling) and
    // false (cancel and stop bubbling)
    if (!newMember) return newMember;
    // If we contain the member (or its placeholder) and the new position matches the old one
    // we can just bail since there will be no movement
    var newMemberIndex = this.members.indexOf(newMember);
    if (newMemberIndex == -1 && newMember._dragPlaceHolder)
        newMemberIndex = this.members.indexOf(newMember._dragPlaceHolder)
    if (newMemberIndex != -1 &&
        (newMemberIndex == dropPosition || newMemberIndex + 1== dropPosition))
    {
        return false;
    }


    newMember.dropSucceeded = true;


    if (isc.Browser.isMoz) {
        this.delayCall("_completeDrop", [newMember, dropPosition]);
    } else {
        this._completeDrop(newMember, dropPosition);
    }
    return isc.EH.STOP_BUBBLING;
},

// Helper to complete a drop operation
_completeDrop : function (newMember, dropPosition) {

    this.hideDropLine();

    //>Animation

    var memberParent = newMember.parentElement;
    if (memberParent && newMember.getDragAppearance(isc.EH.dragOperation) == isc.EH.OUTLINE &&
        this.animateMembers && isc.isA.Layout(memberParent) &&
        memberParent.hasMember(newMember))
    {
        memberParent._popOutDraggingMember(newMember, isc.EH.dragOutline.getPageLeft(),
                                            isc.EH.dragOutline.getPageTop());
    }
    //<Animation

    // if this member was really reordered (dragged from this same layout), it's new position
    // is one less if it was dropped past it's old position
    var dropAfterSelf = false;
    // Because we deparent a member that has dragAppearance:"target" or that will animate into
    // place, this will only occur if:
    // - reordering something with dragAppearance 'tracker'
    // - reordering something with dragAppearance 'outline' if we're not animating into place
    if (this.members.contains(newMember)) {
        var memberPos = this.members.indexOf(newMember);

        if (memberPos < dropPosition) dropAfterSelf = true;
        this.removeMember(newMember, true);

    // If we don't contain the member:
    // - the member currently resides in another layout (will get pulled out when we do
    //   addMember())
    // - there is a placeHolder wherever the member was (could be in this layout or
    //   another layout)
    // Handle Drag target or outline / drag reposition case (placeholder is in the members array)
    } else {

        var placeHolder = newMember._dragPlaceHolder;
        if (placeHolder != null) {
            var placeHolderIndex = this.getMemberNumber(placeHolder)
            if ((placeHolderIndex >= 0) && (placeHolderIndex < dropPosition)) {
                dropAfterSelf = true;
            }
            placeHolder.parentElement._cleanUpPlaceHolder(newMember);
        }
    }

    // if we're dropping a member after itself (reorder), the insertionPosition is reduced by
    // one (assuming the member is removed before being re-added)
    var insertionPosition = dropPosition - (dropAfterSelf ? 1 : 0);

    //>Animation
    // If we're doing a drag-reposition of the new member with dragAppearance 'target' our
    // outline, and animateMembers is true, we want to animate the new member into place
    // by moving it from the drop position to the final position in the layout.
    // If the drag-appearance is tracker it's not clear what an appropriate animation
    // would be - we could have the dragged widget float from either it's current position or
    // from the drag-outline position into the slot, but just have it do the normal 'addMember'
    // animation for now.
    if (!this.animateMembers ||
        (newMember.dragAppearance != "target" && newMember.dragAppearance != "outline" )) {
    //<Animation
        this.addMember(newMember, insertionPosition);
        // Clear the dropSucceeded method so it doesn't effect subsequent drag-reorderings
        delete newMember.dropSucceeded;
        return;
    //>Animation
    }


    // make a spacer to take the place of the member while we animate it into place.  Note that
    // we will automatically animateShow() on this spacer so the amount of space will grow as
    // the member moves towards it.
    // NOTE: the prospective member may be resized on the width axis when finally added to the
    // Layout, which could cause the member to be extended on the length axis.  Changing the
    // member's size before starting the move animation would be odd looking, so we instead
    // live with the possibility of other members being pushed down at the end of the
    // animation.  The only other alternative would be to resize the member to the Layout's
    // breadth, redraw if necessary to check the extents, and resize back, which would probably
    // be too slow even if we could avoid flashing.
    var spacer = this._createSpacer(newMember, "_slideInTarget");
    this.addMember(spacer, dropPosition); // automatically animates, pushing other members down

    this.reflowNow();

    //this.logWarn("hDistance: " + hDistance + ", vDistance: " + vDistance +
    //             ", distance: " + distance);
    // Hang onto a pointer to the member being animated so we can finish this animation early
    // if required.
    this._animatingDrag = newMember;

    var layout = this,
        targetLeft = spacer.getPageLeft(),
        targetTop = spacer.getPageTop();

    if (dropAfterSelf) {
        // shift the target position by the amount of space the reordered member is vacating.
        // NOTE: if being dropped in the last position, the margin due to this member
        // disappears
        var margin = this.membersMargin + this.getMemberGap(newMember);
        if (this.vertical) targetTop -= (newMember.getVisibleHeight() + margin);
        else targetLeft -= (newMember.getVisibleWidth() + margin);
    }

    // XXX HACK very special case for margin animation
    // When we add a member we use _internalExtraSpace to animate the addition of it's
    // margin as well.  In every case but adding in the last position, the animated
    // margin is the margin *after* the added member (the spacer), and hence wouldn't
    // affect positioning.  But for the case of adding at the end, we have to compensate
    // for the fact that the second to last member has _internalExtraSpace set,
    // representing a temporary reduction in margin that affects the spacer placement right
    // now but won't be there when the animation completes
    if (spacer == this.members.last() && this.members.length > 1) {
        var internalSpace = (this.members[this.members.length-2]._internalExtraSpace || 0);
        //this.logWarn("internalSpace: " + internalSpace);
        if (this.vertical) targetTop -= internalSpace;
        else targetLeft -= internalSpace;
    }
    newMember.animateMove(
        targetLeft, targetTop,
        function () {
            // clear the flag that indicates we're in mid-drag
            layout._animatingDrag = null;

            // suppress instantRelayout while destroying the placeholder to avoid restack
            // before we add the new member
            var oldSetting = layout.instantRelayout;
            layout.instantRelayout = false;
            spacer.destroy();
            newMember.dropSucceeded = null;
            layout.addMember(newMember, insertionPosition, true);
            layout.instantRelayout = oldSetting;
            if (oldSetting) layout.reflowNow();
        },
        this.animateMemberTime
    );
    //<Animation
},


_cleanUpPlaceHolder : function (newMember) {

    var placeHolder = newMember._dragPlaceHolder;

    if (this.hasMember(placeHolder)) {
        newMember._dragPlaceHolder = null;
        this.removePlaceHolder(placeHolder)
   }
},

//>Animation Helper method to finish up a drag/drop animation if one is currently in progress.
_finishDropAnimation : function () {

    if (this._animatingDrag != null) {
        this._animatingDrag.finishAnimation("move");
    }
},
//<Animation

//>    @method    layout.getDropPosition() (A)
//
// Get the position a new member would be dropped.  This drop position switches in the
// middle of each member, and both edges (before beginning, after end) are legal drop positions
// <p>
// Use this method to obtain the drop position for e.g. a custom drop handler.
//
// @return (int) the position a new member would be dropped
//
// @visibility external
//<
getDropPosition : function () {
    var coord = this.vertical ? this.getOffsetY() : this.getOffsetX();

    // before beginning
    if (coord < 0) return 0;

    var totalSize = this.vertical ? this._topMargin : this._leftMargin;
    for (var i = 0; i < this.memberSizes.length; i++) {
        var size = this.memberSizes[i],
            member = this.members[i];
        if (!member) continue;
        if (coord < (totalSize + (size/2))) {
            // respect an explicit canDropBefore setting, which prevents dropping before a
            // member
            if (member.canDropBefore === false) return false;
            return i;
        }
        totalSize += size + this.membersMargin + this.getMemberGap(member);
    }
    // last position: past halfway mark on last member
    return this.members.length;
},

// Drop line
// --------------------------------------------------------------------------------------------

_getChildInset : function (topEdge) {
    return (topEdge ? this.getTopMargin() + this.getTopBorderSize() :
                      this.getLeftMargin() + this.getLeftBorderSize())
},

getPositionOffset : function (position) {
    if (this.members.length == 0) {
        // empty layout
        return this.vertical ? this.getPageTop() + this._getChildInset(true) + this._topMargin :
                               this.getPageLeft() + this._getChildInset() + this._leftMargin;
    }
    if (position < this.members.length) {
        // get near side of member
        var member = this.members[position];

        return (this.vertical ? member.getPageTop() : member.getPageLeft());
    } else {
        // last position: get far side of last member (not end of Layout, since Layout may be
        // larger than last member)
        var member = this.members[position - 1];
        return (this.vertical ? member.getPageBottom() : member.getPageRight());
    }
},

// show a drop line in the middle of the margin at that drop position
showDropLine : function () {


    if (this._suppressLayoutDrag) return;

    if (this.showDropLines == false) {
        // just bail
        return;
    }

    var position = this.getDropPosition();
    if (!isc.isA.Number(position)) {
        this.hideDropLine();
        return;
    }

    // before or after list
    if (position < 0) return;


    if (this._layoutIsDirty) this.reflowNow();

    if (!this._dropLine) this._dropLine = this.makeDropLine();

    var thickness = this.dropLineThickness,
        lengthOffset = this.getPositionOffset(position);

    // place the dropLine in the middle of the margin between members, or in the middle of the
    // layoutMargin at the ends of the layout
    // note use _leftMargin / _rightMargin rather than this.layoutMargin. Handles
    // explicit layoutLeftMargin or paddingAsLayoutMargin as well as explicit layoutMargin.
    var margin;
    // this is just a sanity check - the widget should be drawn at this point so we'd expect
    // the layout margins to have been set up already
    if (this._leftMargin == null) this.setLayoutMargin();

    if (position == 0) {
        margin = this.vertical ? this._topMargin : this._leftMargin;
    } else if (position == this.members.length) {
        // when placing at the end, add to the offset instead of subtracting
        margin = - (this.vertical ? this._bottomMargin : this._rightMargin);
    } else {
        margin = this.membersMargin;
    }
    lengthOffset = lengthOffset - Math.round((margin+thickness)/2);

    var breadthOffset = this.vertical ?
            this._leftMargin + this._getChildInset() :
            this._topMargin + this._getChildInset(true);

    var breadth = this.vertical ?
        this.getVisibleWidth() - this.getVMarginBorder() - this._getBreadthMargin() :
        this.getVisibleHeight() - this.getHMarginBorder() - this._getLengthMargin();

    this._dropLine.setPageRect(
        (this.vertical ? this.getPageLeft() + breadthOffset : lengthOffset),
        (this.vertical ? lengthOffset : this.getPageTop() + breadthOffset),
        (this.vertical ? breadth : thickness),
        (this.vertical ? thickness : breadth)
    );

    var topParent = this.topElement || this;
    if (this._dropLine.getZIndex() < topParent.getZIndex()) this._dropLine.moveAbove(topParent);

    //this.logWarn("showDropLine, relative top of layout: " +
    //             (this.getPageTop() - this._dropLine.getPageTop()) + " for pos: " + position);
    this._dropLine.show();
},


//>    @method    layout.hideDropLine() (A)
// Calling this method hides the dropLine shown during a drag and drop interaction with a
// Layout that has +link{Layout.canDropComponents} set to true.  This method is only useful for
// custom implementations of +link{Layout.drop()} as the default implementation calls this
// method automatically.
//
// @visibility external
//<
hideDropLine : function () {
    if (this._dropLine) this._dropLine.hide();
},

//> @attr layout.dropLine (AutoChild Canvas : null : R)
// Line showed to mark the drop position when components are being dragged onto this Layout.
// A simple Canvas typically styled via CSS.  The default dropLine.styleName is
// "layoutDropLine".
// @visibility external
// @example dragMove
//<

dropLineDefaults : {
    styleName:"layoutDropLine",
    overflow:"hidden",
    isMouseTransparent:true // to prevent dropline occlusion of drop events
},
makeDropLine : function () {
    var dropLine = this.createAutoChild("dropLine", null, isc.Canvas);
    dropLine.dropTarget = this; // delegate dropTarget
    return dropLine;
},

// ResizeBar handling
// --------------------------------------------------------------------------------------------

createResizeBar : function (member, position, targetAfter, hideTarget) {
    var bar = this.createAutoChild("resizeBar", {
        target: member,
        targetAfter: targetAfter,
        hideTarget: hideTarget,
        layout: this,
        vertical: !this.vertical,
        dragScrollDirection: this.vertical ? isc.Canvas.VERTICAL : isc.Canvas.HORIZONTAL
    }, this.resizeBarClass);

    return isc.SGWTFactory.extractFromConfigBlock(bar);
},

makeResizeBar : function (member, offset, position, length) {

    // create a resizerBar for this member
    var bar = member._resizeBar;
    var nextMember = this.getMember(this.getMemberNumber(member)+1) || member;

    if (bar == null) {
        var target = member,
            targetAfter,
            hideTarget;

        if (member.resizeBarTarget == "next") {
            target = nextMember;
            targetAfter = true;
        }

        // by default a resizeBar will target the same member for both resizing and hiding.
        // This flag allows us to resize one member but hide another.  Not documented until we
        // see an actual request for this; just covering all the cases

        if (member.resizeBarHideTarget != null) {
            if (member.resizeBarHideTarget == "next") hideTarget = nextMember;
            else hideTarget = member;
        } else {
            hideTarget = target;
        }

        bar = this.createResizeBar(target, position, targetAfter, hideTarget);
        member._resizeBar = bar;
    }

    // for handling resizeBar joints in nested layouts
    //this._handleJoints(bar);
    // position bar as top-level widget
    //offset += (this.vertical ? this.getPageLeft() : this.getPageTop());
    //position += (this.vertical ? this.getPageTop() : this.getPageLeft());

    // place the bar after the member
    if (this.vertical) {
        bar.setRect(offset, position,
                    length, this.resizeBarSize);
    } else {
        if (this.isRTL()) position -= this.resizeBarSize;
        bar.setRect(position, offset,
                    this.resizeBarSize, length);
    }
    // add the bar as a child/peer (will no-op second time around)
    if (this.membersAreChildren) {
        this.addChild(bar);
    } else {
        this.addPeer(bar);
    }

    // draw the bar (this won't happen automatically)
    if (!bar.isDrawn()) bar.draw();
    // May have been hidden by a previous stackMembers call
    if (!bar.isVisible()) bar.show();

    // Always float the resizeBar above the 2 members it is attached to

    if (nextMember != member && nextMember.getZIndex() > member.getZIndex()) {
        bar.moveAbove(nextMember);
    } else {
        bar.moveAbove(member);
    }

    return bar;
},



_reflowOnChangeProperties:{
    align:true,
    defaultLayoutAlign:true,
    reverseOrder:true,
    vertical:true,
    orientation:true,
    vPolicy:true,
    minMemberSize:true,
    minMemberLength:true,
    minMemberBreadth:true,
    hPolicy:true,
    membersMargin:true
},
propertyChanged : function (propertyName, value) {
    this.invokeSuper(isc.Layout, "propertyChanged", propertyName, value);
    if (this._reflowOnChangeProperties[propertyName]) {

        // layoutChildren will skip resizing members if the breadth is unchanged and
        // the length policy is "none". Explicitly set the "_breadthChanged" flag to
        // force a resize of members if we hit this case but we changed a property which
        // requires a resize
        if (propertyName == "minMemberSize" ||
            propertyName == "minMemberLength" ||
            propertyName == "minMemberBreadth" ||
            propertyName == "hPolicy" ||
            propertyName == "vPolicy")
        {
            this._breadthChanged = true;
        }

        this.reflow("Reflow for change to " + propertyName);
    } else if (isc.endsWith(propertyName, "Margin")) this.setLayoutMargin();
},

// Debug output
// --------------------------------------------------------------------------------------------

getLengthAxis : function () { return this.vertical ? "height" : "width" },

_reportResize : function (member, breadth, length, memberInfo) {
    // report this size change if it's non a no-op.  We go through some contortions here in
    // order to report the resize before we actually do it, because it makes the logs much
    // easier to read
    var width = this.vertical ? breadth : length,
        height = this.vertical ? length : breadth,
        deltaX = member.getDelta("width", width, member.getWidth()),
        deltaY = member.getDelta("height", height, member.getHeight());
    if ((deltaX != null && deltaX != 0) || (deltaY != null && deltaY != 0)) {

        var resizeCount = memberInfo ? memberInfo._resizeCount : 1;
        if (resizeCount == null) {
            resizeCount = 1;
        }

        this.logDebug("resizing " + member +
            (member.isDrawn() ? " (drawn): " : ": ") +
            (breadth != null ? breadth + (this.vertical ? "w " : "h ") : "") +
            (length != null ? length + (this.vertical ? "h" : "w") : "") +
            // If resizeCount > 1 this implies that
            // some sibling member overflowed its specified size after our initial
            // size was set, requiring a resize
            (resizeCount != 1 ? " (" + resizeCount + " resizes due to sibling overflow)" : ""),
            "layout"
        );
    }
},

reportSizes : function (layoutInfo, reason) {
    if (!this.logIsInfoEnabled(this._$layout)) return;

    var output = "layoutChildren (reason: " + reason +
        "):\nlayout specified size: " + this.getWidth() + "w x " + this.getHeight() + "h\n" +
        "drawn size: " + this.getVisibleWidth(true) + "w x " + this.getVisibleHeight(true) + "h\n" +
        "available size: " +
        this.getInnerWidth() + (!this.vertical ? "w (length) x " : "w x ") +
        this.getInnerHeight() + (this.vertical ? "h (length)\n" : "h\n");

    // report the length and breadth each member was sized to and why
    for (var i = 0; i < layoutInfo.length; i++) {
        var memberInfo = layoutInfo[i];
        output += "   " + this.members[i] + "\n";
        output += "      " + memberInfo._visibleLength + " drawn length" +
            (memberInfo._resizeLength ? " (resizeLength: " + memberInfo._resizeLength + ")" : "") +
            " (policyLength: " + memberInfo._policyLength + ")" +
            " (" + memberInfo._lengthReason + ")\n";
        output += "      " + memberInfo._breadth + " drawn breadth (" + memberInfo._breadthReason + ")\n";
    }

    if (layoutInfo.length == 0) output += "[No members]";

    this.logInfo(output, "layout");
}

});

// Preconfigured Layout classes
// --------------------------------------------------------------------------------------------

//>    @class    HLayout
//
//  A subclass of Layout that applies a sizing policy along the horizontal axis, interpreting
//  percent and "*" sizes as proportions of the width of the layout. HLayouts will set any members
//  that do not have explicit heights to match the layout.
//
// @inheritsFrom Layout
// @see Layout.hPolicy
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("HLayout","Layout").addProperties({
    orientation:"horizontal"
});

//>    @class    VLayout
//
//  A subclass of Layout that applies a sizing policy along the vertical axis, interpreting
//  percent and "*" sizes as proportions of the height of the layout. VLayouts will set any
//  members that do not have explicit widths to match the layout.
//
// @see Layout.vPolicy
// @inheritsFrom Layout
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("VLayout","Layout").addProperties({
    orientation:"vertical"
});


//>    @class    HStack
//
// A subclass of Layout that simply stacks members on the horizontal axis without trying to
// manage their width.  On the vertical axis, any members that do not have explicit heights will
// be sized to match the height of the stack.
//
// @inheritsFrom Layout
// @see Layout.hPolicy
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("HStack","Layout").addProperties({
    orientation:"horizontal",
    hPolicy:isc.Layout.NONE,
    // NOTE: set a small defaultWidth since typical use is auto-sizing to contents on the
    // length axis, in order to avoid a mysterious 100px minimum length.  Since this is just a
    // defaultWidth, this really only affects HStacks which are not nested inside other
    // Layouts/Stacks
    defaultWidth:20
});

//>    @class    VStack
//
// A subclass of Layout that simply stacks members on the vertical axis without trying to
// manage their height.  On the horizontal axis, any members that do not have explicit widths
// will be sized to match the width of the stack.
//
// @see Layout.vPolicy
// @inheritsFrom Layout
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("VStack","Layout").addProperties({
    orientation:"vertical",
    vPolicy:isc.Layout.NONE,
    defaultHeight:20 // see defaultWidth setting for HStack above
});

// LayoutSpacer
// --------------------------------------------------------------------------------------------

//> @class LayoutSpacer
// Add a spacer to a +link{Layout} that takes up space just like a normal member, without actually
// drawing anything. A <code>LayoutSpacer</code> is semantically equivalent to using an empty canvas,
// but higher performance for this particular use case.
//
// @inheritsFrom Canvas
// @treeLocation Client Reference/Layout
// @visibility external
//<
// NOTE: LayoutSpacer is a Canvas so that it can respond to all sizing, etc, methods, however, it
// never actually draws.
isc.defineClass("LayoutSpacer", "Canvas").addMethods({
    overflow:"hidden",
    draw : isc.Canvas.NO_OP,
    redraw : isc.Canvas.NO_OP,
    _hasUndrawnSize:true
});

//> @class FixedSpacer
// This class is a synonym for LayoutSpacer that can be used to make intent clearer.
// It is used by some development tools for that purpose.
//
// @inheritsFrom LayoutSpacer
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("FixedSpacer", "LayoutSpacer").addMethods({
    height: 5
});

//> @class FlexSpacer
// This class is a synonym for LayoutSpacer that can be used to make intent clearer.
// It is used by some development tools for that purpose.
//
// @inheritsFrom LayoutSpacer
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("FlexSpacer", "LayoutSpacer").addMethods({
    height: 5
});

// register 'members' as a dup-property. This means if a layout subclass instance prototype
// has 'members' assigned it'll be duplicated (and shallow cloned) on instances.
isc.Layout.registerDupProperties("members");








//>    @class    Button
//
// The Button widget class implements interactive, style-based button widgets.
//
// @inheritsFrom StatefulCanvas
// @treeLocation Client Reference/Control
// @visibility external
//<

//> @groupDef buttonIcon
// Control over optional icons shown in Buttons, Labels and other contexts
// @title Button Icon
// @visibility external
//<

isc.ClassFactory.defineClass("Button", "StatefulCanvas");

isc.defer("if (isc.Button._instancePrototype.showFocused == null) isc.Button.addProperties({ showFocused: !isc.Browser.isTouch });");

isc.Button.addProperties({


    // Various properties documented on StatefulCanvas that affect all buttons
    // NOTE: This block is included in Button, ImgButton, and StrechlImgButton.
    //       If you make changes here, make sure you duplicate it to the other
    //       classes.
    //
    // End of this block is marked with: END StatefulCanvas @include block
    // ========================================================================

    // Title
    //------
    //> @attr button.title (HTMLString : "Untitled Button" : IRW)
    // @include statefulCanvas.title
    // @visibility external
    // @group basics
    // @group i18nMessages
    // @example buttonStates
    //<
    title:"Untitled Button",

    //> @attr button.clipTitle (Boolean : true : IR)
    // If this.overflow is "hidden" and the title for this button is too large for the available
    // space, should the title be clipped by an ellipsis?
    // <p>
    // This feature is supported only in browsers that support the CSS UI text-overflow
    // property (IE6+, Firefox 7+, Safari, Chrome, Opera 9+).
    //<
    clipTitle: true,

    //> @attr button.hiliteAccessKey    (boolean : null : IRW)
    // @include statefulCanvas.hiliteAccessKey
    // @visibility external
    //<

    //>    @method    button.getTitle()    (A)
    // @include statefulCanvas.getTitle
    // @visibility external
    //<
    //>    @method    button.setTitle()
    // @include statefulCanvas.setTitle
    // @visibility external
    //<

    //> @attr button.showClippedTitleOnHover (Boolean : false : IRW)
    // If true and the title is clipped, then a hover containing the full title of this button
    // is enabled.
    // @group hovers
    // @visibility external
    //<
    showClippedTitleOnHover:false,

    _canHover:true,

    // don't set className on the widget's handle, because we apply styling to another element
    suppressClassName:true,

    // Icon
    //------

    // set useEventParts to true so we can handle an icon click separately from a
    // normal button click if we want
    useEventParts:true,

    //> @attr button.icon
    // @include statefulCanvas.icon
    // @visibility external
    // @example buttonIcons
    //<
    //> @attr button.iconSize
    // @include statefulCanvas.iconSize
    // @visibility external
    //<
    //> @attr button.iconWidth
    // @include statefulCanvas.iconWidth
    // @visibility external
    //<
    //> @attr button.iconHeight
    // @include statefulCanvas.iconHeight
    // @visibility external
    //<
    //> @attr button.iconStyle
    // @include StatefulCanvas.iconStyle
    // @visibility external
    //<
    //> @attr button.iconOrientation
    // @include statefulCanvas.iconOrientation
    // @visibility external
    // @example buttonIcons
    //<
    //> @attr button.iconAlign
    // @include statefulCanvas.iconAlign
    // @visibility external
    //<
    //> @attr button.iconSpacing
    // @include statefulCanvas.iconSpacing
    // @visibility external
    //<
    //> @attr button.showDisabledIcon
    // @include statefulCanvas.showDisabledIcon
    // @visibility external
    //<
    //> @attr button.showRollOverIcon
    // @include statefulCanvas.showRollOverIcon
    // @visibility external
    //<
    //> @attr button.iconCursor
    // @include StatefulCanvas.iconCursor
    // @visibility external
    //<
    //> @attr button.disabledIconCursor
    // @include StatefulCanvas.disabledIconCursor
    // @visibility external
    //<

    //> @attr button.showFocusedIcon
    // @include statefulCanvas.showFocusedIcon
    // @visibility external
    //<
    //> @attr button.showDownIcon
    // @include statefulCanvas.showDownIcon
    // @visibility external
    // @example buttonIcons
    //<
    //> @attr button.showSelectedIcon
    // @include statefulCanvas.showSelectedIcon
    // @visibility external
    //<
    //> @method button.setIconOrientation()
    // @include statefulCanvas.setIconOrientation
    // @visibility external
    //<
    //> @method button.setIcon()
    // @include statefulCanvas.setIcon
    // @visibility external
    //<

    // AutoFit
    //--------
    //> @attr button.autoFit
    // @include statefulCanvas.autoFit
    // @group sizing
    // @visibility external
    // @example buttonAutoFit
    //<
    //> @method button.setAutoFit()
    // @include statefulCanvas.setAutoFit
    // @visibility external
    //<
    setAutoFit : function () {

        var drawn = this.isDrawn(),
            pushBorderToDiv = this.shouldPushTableBorderStyleToDiv();

        this.Super("setAutoFit", arguments);
        // Remember the requested autoFit (used by adaptWidthBy)
        this._specifiedAutoFit = !!this.autoFit;


        if (drawn) {
            var newPushBorderToDiv = this.shouldPushTableBorderStyleToDiv();
            if (pushBorderToDiv != newPushBorderToDiv) {
                this._pushTableBorderToDivChanged(newPushBorderToDiv);
            }
        }
    },

    _pushTableBorderToDivChanged : function (pushBorderToDiv) {
        // If we're undrawn, prepareToDraw() handles updating the various flags
        if (!this.isDrawn()) return;

        var border = pushBorderToDiv ? this._buttonBorder : this.border;
        // this will handle updating the appropriate property (_buttonBorder or border)
        if (border != null) this.setBorder(border);



        var bgColor = pushBorderToDiv ? this._buttonBGColor : this.backgroundColor;
        this.setBackgroundColor(bgColor);
    },


    //> @attr button.width
    // @include statefulCanvas.width
    // @group sizing
    // @visibility external
    //<

    //> @attr button.height
    // @include statefulCanvas.height
    // @group sizing
    // @visibility external
    //<

    // only autoFit horizontally by default
    autoFitDirection:"horizontal",

    // baseStyle
    //----------

    // Include styleName docs just to make it obvious this property will not have an impact
    // on Buttons
    //> @attr button.styleName (CSSStyleName : "normal" : IRW)
    // @include statefulCanvas.styleName
    // @visibility external
    //<

    //> @attr button.baseStyle (CSSStyleName : "button" : IRW)
    // @include statefulCanvas.baseStyle
    // @see iconOnlyBaseStyle
    // @visibility external
    //<
    baseStyle:"button",

    //> @attr button.iconOnlyBaseStyle (CSSStyleName : null : [IRW])
    // if defined, <code>iconOnlyBaseStyle</code> is used as the base CSS style className,
    // instead of +link{baseStyle}, if +link{canAdaptWidth} is set and the
    // +link{button.adaptWidthShowIconOnly,title is not being shown}.
    // @see canvas.canAdaptWidth
    // @see tabSet.simpleTabIconOnlyBaseStyle
    // @visibility external
    //<

    // If +link{useSimpleTabs} is true, <code>simpleTabBaseStyle</code> will be the base style
    // used to determine the css style to apply to the tabs.<P>
    // This property will be suffixed with the side on which the tab-bar will appear, followed
    // by with the tab's state (selected, over, etc), resolving to a className like
    // "tabButtonTopOver".
    // @see Button.baseStyle
    // @see simpleTabIconOnlyBaseStyle
    // @visibility external
    //<

    //> @method button.setBaseStyle()
    // @include statefulCanvas.setBaseStyle
    // @visibility external
    //<

    // selection
    //----------
    //> @attr button.selected
    // @include statefulCanvas.selected
    // @visibility external
    //<
    //> @method button.select()
    // @include statefulCanvas.select
    // @visibility external
    //<
    //> @method button.deselect()
    // @include statefulCanvas.select
    // @visibility external
    //<
    //> @method button.isSelected()
    // @include statefulCanvas.isSelected
    // @visibility external
    //<
    //> @method button.setSelected()
    // @include statefulCanvas.select
    // @visibility external
    //<

    // radioGroup
    //-----------
    //> @attr button.radioGroup
    // @include statefulCanvas.radioGroup
    // @visibility external
    // @example buttonRadioToggle
    //<
    //> @method button.addToRadioGroup()
    // @include statefulCanvas.addToRadioGroup
    // @visibility external
    //<
    //> @method button.removeFromRadioGroup()
    // @include statefulCanvas.removeFromRadioGroup
    // @visibility external
    //<
    //> @attr button.actionType
    // @include statefulCanvas.actionType
    // @visibility external
    // @example buttonRadioToggle
    //<
    //> @method button.setActionType()
    // @include statefulCanvas.setActionType
    // @visibility external
    //<
    //> @method button.getActionType()
    // @include statefulCanvas.getActionType
    // @visibility external
    //<

    // state
    //------
    //> @attr button.state
    // @include statefulCanvas.state
    // @visibility external
    //<
    //> @method button.setState()
    // @include statefulCanvas.setState
    // @visibility external
    //<
    //> @method button.setDisabled()
    // @include statefulCanvas.setDisabled
    // @visibility external
    //<
    //> @method button.getState()
    // @include statefulCanvas.getState
    // @visibility external
    //<
    //> @attr button.showDisabled
    // @include statefulCanvas.showDisabled
    // @visibility external
    // @example buttonStates
    //<
    //> @attr button.showDown
    // @include statefulCanvas.showDown
    // @visibility external
    // @example buttonStates
    //<
    //> @attr button.showFocused
    // @include statefulCanvas.showFocused
    // @visibility external
    //<
    showDown:true,

    showFocused:null, // !isc.Browser.isTouch
    //> @attr button.showRollOver
    // @include statefulCanvas.showRollOver
    // @visibility external
    // @example buttonStates
    //<
    showRollOver:true,


    mozOutlineOffset: "0px",

    // alignment
    //----------
    //> @attr button.align
    // @include statefulCanvas.align
    // @visibility external
    //<
    //> @attr button.valign
    // @include statefulCanvas.valign
    // @visibility external
    //<


    // Button.action
    //> @method button.action()
    // @include statefulCanvas.action
    // @visibility external
    //<

    // ================= END StatefulCanvas @include block =============== //


    //>    @attr    button.wrap        (Boolean : false : [IRW])
    // A boolean indicating whether the button's title should word-wrap, if necessary.
    // @group basics
    //      @visibility external
    //<
    wrap:false,

    // NOTE: by setting "height" rather than "defaultHeight", we make this into an explicit
    // setting which will be respected by a Layout
    height:20,
    width:100,

    //> @attr button.canAdaptWidth (Boolean : false : IR)
    // This flag enables +link{canvas.canAdaptWidth,adaptive width} for the button.
    // <P>
    // If enabled the button will support rendering in a 'collapsed' view if there isn't enough
    // space in a layout to render it at normal size. There are a couple of ways this can be achieved.
    // <ul>
    // <li>If +link{button.adaptWidthShowIconOnly} is true and this button shows an icon, the title
    //     will be hidden if there isn't enough space to render it, allowing it to shrink to either
    //     the rendered icon width, or any specified +link{canvas.minWidth,minWidth}, whichever is larger.</li>
    // <li>Otherwise, if the button has a specified +link{canvas.minWidth,minWidth}, and
    //     +link{button.autoFit} is true, autoFit will be temporarily disabled, if there isn't enough
    //     room, allowing the title to be clipped</li>
    // </ul>
    // In either case the title will show on hover unless an explicit hover has been
    // specified such as by overriding +link{titleHoverHTML()}.
    //
    // @see canvas.canAdaptWidth
    // @example buttonAdaptiveWidth
    // @visibility external
    //<

    //> @attr button.overflow (Overflow : Canvas.HIDDEN : IRWA)
    // Clip the contents of the button if necessary.
    // @see canvas.overflow
    // @visibility external
    //<
    overflow:isc.Canvas.HIDDEN,

    //>    @attr    button.redrawOnDisable        (boolean : true : IRWA)
    // true == redraw the button when it's enabled/disabled
    //<
    redrawOnDisable:false,

    //>    @attr    button.redrawOnStateChange        (boolean : true : IRWA)
    // true == redraw the button when it's state changes
    //        @group    state
    //<
    redrawOnStateChange:false,

    //>    @attr    button.cursor        (Cursor : isc.Canvas.HAND : IRW)
    // Hand cursor since these items are clickable
    //<
    cursor:isc.Canvas.HAND,

    // Style of the button is set via baseStyle, etc. above
    // NOTE: the button applies its CSS style to a contained cell, not the Canvas itself.
    className:null,

    // If true, add a space to left or right-aligned titles so that they are not flush with
    // the edge of the widget.
    // NOTE: FIXME: this should really be done via CSS padding, hence not external doc'd
    //padTitle:false,

    //> @attr statefulCanvas.titleStyle        (CSSStyleName : "normal" : [IR])
    // For buttons with icons only, optional style to be applied to title text only.  This
    // style should contain text-related properties only (such as font size); border, padding
    // and background color should be specified in the style used as the "baseStyle".
    //
    // This property applied only to icon buttons rendered with a subtable, and currently only
    // works if redrawOnStateChange is true.  Internal for now.
    //<

    //titleStyle:"buttonTitle",

    canFocus:true
});

// add instance methods
isc.Button.addMethods({

_aboutToDraw : function () {

    this.Super("_aboutToDraw", arguments);



    var pushBorderToDiv = this.shouldPushTableBorderStyleToDiv();
    if (this.border != null && !pushBorderToDiv) {
        this._buttonBorder = this.border;
        this._clearBorder();
    }
    if (this.padding != null) {
        this._buttonPadding = this.padding;
        this.padding = null;
    }
    // If the style's border will be applied to the handle (div) rather than the table,
    // we'll also apply the bg-color to the border, and suppress any bg-color on the
    // handle. This ensures the inner curve of any border-radius isn't clipped by the
    // bg-color applied to the table cell [which doesn't have the same corner radii]
    if (pushBorderToDiv) {
        // don't set this to transparent - it breaks CSS-transitions on background-color
        this._buttonBGColor = null;
    } else {
        // Otherwise we apply the background color to the table cell along with other styling,
        // not to the div
        if (this.backgroundColor != null) {
            this._buttonBGColor = this.backgroundColor;
            this.backgroundColor = null;
        }
    }


    this.forceHandleOverflowHidden = pushBorderToDiv;
},

// setHandleRect() handles resizing the widget handle.
// After adjusting size, it falls through to _assignRectToHandle (with sizes adjusted for
// custom scrollbars, etc).
// If we're writing out an explicitly sized inner table override this method to also
// resize the inner table's handle.
_assignRectToHandle : function (left,top,width,height,styleHandle) {
    // Resize the handle
    this.invokeSuper(isc.Button, "_assignRectToHandle", left,top,width,height,styleHandle);


    if (this.redrawOnResize && !this.isPrinting && this._explicitlySizeTable()) return;
    var tableElem = this._getTableElement();
    if (tableElem != null) {
        // If provided a width, and this button's markup requires a width attribute to be set
        // on the <table>, then update the attribute.
        if (width != null && isc.isA.Number(width) &&
            (this.overflow !== isc.Canvas.VISIBLE ||
             (!this._explicitlySizeTable() && this.redrawOnResize != false)))
        {
            var tableWidth = width;
            if (this.isBorderBox) tableWidth -= this.getHBorderPad();
            this._assignSize(tableElem, this._$width, tableWidth);
        }

        if (height != null && isc.isA.Number(height)) {
            var tableHeight = height;
            if (this.isBorderBox) tableHeight -= this.getVBorderPad();
            this._assignSize(tableElem, this._$height, tableHeight);
        }
    }
},


shouldRedrawOnResize : (isc.Browser.isIPhone ?
    function (deltaX, deltaY) {
        return (this !== this.ns.EH.dragTarget);
    }
: // !isc.Browser.isIPhone
    isc.Button.getSuperClass()._instancePrototype.shouldRedrawOnResize
),

getCanHover : function (a, b, c) {
    return this._canHover || this.invokeSuper(isc.Button, "getCanHover", a, b, c);
},

shouldClipTitle : function () {
    return this.getOverflow() == isc.Canvas.HIDDEN && !!this.clipTitle;
},

_$titleClipper:"titleClipper",
_getTitleClipperID : function () {
    return this._getDOMID(this._$titleClipper);
},

//> @method button.titleClipped() (A)
// Is the title of this button clipped?
// @return (boolean) whether the title is clipped.
// @visibility external
//<
titleClipped : function (startAfterNode) {
    var titleClipperHandle = this.getDocument().getElementById(this._getTitleClipperID());
    if (titleClipperHandle == null) return false;


    if (this.getScrollHeight() > this.getViewportHeight()) {
        return true;
    }


    if (isc.Browser.isChrome ||
        (isc.Browser.isMoz && isc.Browser.version >= 7))
    {
        var range = this.getDocument().createRange();
        range.selectNodeContents(titleClipperHandle);


        if (startAfterNode && titleClipperHandle.contains(startAfterNode)) {
            range.setStartAfter(startAfterNode);
        }

        var contentsBCR = range.getBoundingClientRect();
        var bcr = titleClipperHandle.getBoundingClientRect();


        return bcr.width < contentsBCR.width && (contentsBCR.width - bcr.width > 1);
    } else {
        return (isc.Element.getClientWidth(titleClipperHandle) < titleClipperHandle.scrollWidth);
    }
},

defaultTitleHoverHTML : function () {
    return this.getTitleHTML();
},

// helper used by handleHover() in canAdaptWidth: true case
hiddenTitleHoverHTML : function () {
    var title = this.getTitle(true);
    return this.formatTitle(this, title);
},

//> @method button.titleHoverHTML()
// Returns the HTML that is displayed by the default +link{Button.titleHover(),titleHover}
// handler. Return null or an empty string to cancel the hover.
// <smartgwt><p>Use <code>setTitleHoverFormatter()</code> to provide a custom
// implementation.</smartgwt>
// @param defaultHTML (HTMLString) the HTML that would have been displayed by default
// @return (HTMLString) HTML to be displayed in the hover. If null or an empty string, then the hover
// is canceled.
// @visibility external
//<
titleHoverHTML : function (defaultHTML) {
    return defaultHTML;
},

handleHover : function (a, b, c) {
    if (this.canHover == false) return;
    // If there is a prompt, prefer the standard hover handling.
    if (this.canHover == null && this.prompt) return this.invokeSuper(isc.Button, "handleHover", a, b, c);

    if (!this._adaptedToSmallerSize && (!this.showClippedTitleOnHover || !this.titleClipped())) {
        if (this.canHover) return this.invokeSuper(isc.Button, "handleHover", a, b, c);
        else return;
    }

    if (this.titleHover && this.titleHover() == false) return;

    // always return the title HTML here, even if it's hidden due to button width adaptation

    var defaultHTML = this._hideTitle ? this.hiddenTitleHoverHTML() :
                                       this.defaultTitleHoverHTML();

    var HTML = this.titleHoverHTML(defaultHTML);
    if (HTML != null && !isc.isAn.emptyString(HTML)) {
        var hoverProperties = this._getHoverProperties();
        isc.Hover.show(HTML, hoverProperties, null, this);
    }
},

_getLogicalIconOrientation : function () {
    var isRTL = this.isRTL(),
        opposite = ((!isRTL && this.iconOrientation == isc.Canvas.RIGHT) ||
                    (isRTL && ((this.ignoreRTL && this.iconOrientation == isc.Canvas.LEFT) ||
                               (!this.ignoreRTL && this.iconOrientation == isc.Canvas.RIGHT))));
    return (isRTL || opposite) && !(isRTL && opposite) ? isc.Canvas.RIGHT : isc.Canvas.LEFT;
},

_explicitlySizeTable : function (iconAtEdge, clipTitle) {
    if (iconAtEdge == null) iconAtEdge = this._iconAtEdge();
    if (clipTitle == null) clipTitle = this.shouldClipTitle();

    return !(
        // This expression is negated, so this is the case where we want to write
        // a table with size natively set to "100%" in both directions.
        iconAtEdge || !clipTitle ||
         (isc.Browser.isIE && ((!isc.Browser.isStrict && isc.Browser.version < 10) ||
                              isc.Browser.version <= 7))
    );
},
_usesSubtable : function (ignoreIsPrinting) {
    var iconAtEdge = this._iconAtEdge(),
        clipTitle = this.shouldClipTitle(),
        isTitleClipper = !iconAtEdge && clipTitle;
    return (((!ignoreIsPrinting && this.isPrinting) || !this._explicitlySizeTable(iconAtEdge, clipTitle)) &&
            this.icon && !isTitleClipper && !this.noIconSubtable);
},
_getTextAlign : function (isRTL) {

    var align = this.align;
    if (align == null) {
        return isc.Canvas.CENTER;
    } else if (!isRTL || this.ignoreRTL) {
        return align;
    } else {

        return isc.StatefulCanvas._mirroredAlign[align];
    }
},

// default for the start of the table in isc.Button._buttonHTML[0]
_tableStart: "<table role='presentation' cellspacing='0' cellpadding='0'",


//> @method button.getInnerHTML() (A)
// Return the HTML for this button
// @return (HTMLString) HTML output for the button
// @group drawing
//<
getInnerHTML : function () {
    var iconAtEdge = this._iconAtEdge(),
        clipTitle = this.shouldClipTitle(),
        isRTL = this.isRTL();
    if (this.isPrinting || !this._explicitlySizeTable(iconAtEdge, clipTitle)) {


        var button = isc.Button;
        if (!button._buttonHTML) {

            button._100Size = " width='100%' height='100%";
            button._100Width = " width='100%";
            button._widthEquals = "width='";
            button._heightEquals = "' height='";
            button._hiddenOverflow = "' style='table-layout:fixed;overflow:hidden;";

            var cellStartHTML = button._cellStartHTML = [];
            button._gt = ">";
            button._nowrapTrue = " nowrap='true'";
            button._classEquals = " class='";
            button._colWidthEquals = "<col width='";
            button._pxEndCol = "px'/>";
            button._emptyCol = "<col/>";
            cellStartHTML[0] = "'><colgroup>";
            // [1] _emptyCol or _colWidthEquals
            // [2] null or afterPadding or _colWidthEquals
            // [3] null or afterPadding or _pxEndCol
            // [4] null or _pxEndCol or _emptyCol
            cellStartHTML[5] = "</colgroup><tbody><tr><td";
            // [6] null or _nowrapTrue
            // [7] _classEquals

            button._cellStartWrap = "'><tbody><tr><td class='";
            button._cellStartNoWrap = "'><tbody><tr><td nowrap='true' class='";

            // cache the opening <table> tag - it may or may not have this.tableStyle to
            // it below - used by LG to apply a tableStyle with a floating right-border
            button._tableStart = "<table role='presentation' cellspacing='0' cellpadding='0'";

            var buttonHTML = button._buttonHTML = [];
            // NOTE: for DOM platforms, padding should be achieved by CSS padding and spacing
            // by CSS margins

            // this is set on a per-call basis and may include a class setting for this.tableStyle
            //buttonHTML[0] = "<table role='presentation' cellspacing='0' cellpadding='0' ";

            // [1] 100% width and height, or width=
            // [2] null or this.getWidth()
            // [3] null or height=
            // [4] null or this.getHeight();

            // [5] overflow setting
            // [6] cell start (wrap/nowrap variants)
            // [7] CSS class

            // [8] optional cssText

            buttonHTML[9] = "' align='";
            // [10] align
            // [11] valign
            button._valignMiddle = "' valign='middle";
            button._valignTop = "' valign='top";
            button._valignBottom = "' valign='bottom";

            // [12-13] titleClipper ID
            button._id = "' id='";

            // [14-16] tabIndex and focus

            button._tabIndexStart = "' " + (isc.Browser.isChrome ? "" : "tabindex='-1'")
                                    + " onfocus='";
            button._callFocus = "._cellFocus()'>";
            button._closeQuoteRightAngle = "'>";

            // IE
            // [17] title

            // Moz
            // [17] Moz start DIV
            // [18] title
            // [19] Moz end DIV

            // end table (see _endTemplate)
        }

        var buttonHTML = button._buttonHTML;

        // insert tableStart HTML and potentially a class setting for this.tableStyle
        buttonHTML[0] = this._tableStart +
            (this.tableStyle ? " class='" + this.tableStyle + "'" : "");

        // if we're printing the button, make it fit its parent element
        // If we're not redrawing on resize, use 100% sizing - will reflow on resize of parent
        // element
        if (this.isPrinting || this.redrawOnResize == false) {
            // if we're not going to redraw on resize, write HTML that reflows automatically.  Not
            // yet possible in every browser.

            buttonHTML[1] = (this.isPrinting ? button._100Width : button._100Size);
            buttonHTML[2] = null; buttonHTML[3] = null; buttonHTML[4] = null;
        } else {
            buttonHTML[1] = button._widthEquals;

            var willDrawClipDiv = this._shouldWriteClipDiv()
            buttonHTML[2] = this.getInnerWidth();
            buttonHTML[3] = button._heightEquals;
            buttonHTML[4] = this.getInnerHeight();

        }


        if (this.overflow == isc.Canvas.VISIBLE) {
            buttonHTML[5] = null;
        } else {
            buttonHTML[5] = button._hiddenOverflow;
        }

        // Inside the cell:


        var afterPadding;
        if (isc.Browser.isIE && !isc.Browser.isStrict && isc.Browser.version < 10 &&
            this._isStatefulCanvasLabel &&
            (afterPadding = this._getAfterPadding == null ? null : this._getAfterPadding()) > 0)
        {
            var cellStartHTML = button._cellStartHTML;
            cellStartHTML[1] = button._emptyCol;
            cellStartHTML[2] = button._colWidthEquals;
            cellStartHTML[3] = afterPadding;
            cellStartHTML[4] = button._pxEndCol;

            cellStartHTML[6] = (this.wrap ? null : button._nowrapTrue);
            cellStartHTML[7] = button._classEquals;

            buttonHTML[6] = cellStartHTML.join(isc.emptyString);
        } else {
            buttonHTML[6] = (this.wrap ? button._cellStartWrap : button._cellStartNoWrap);
        }

        buttonHTML[7] = this.isPrinting ? this.getPrintStyleName() : this.getStateName();

        var isTitleClipper = !iconAtEdge && clipTitle;


        var writeStyle =
            isTitleClipper || this.cssText ||
            this._buttonBorder != null || this._buttonPadding != null ||
            this._buttonBGColor || this.margin != null || this._writeZeroVPadding() ||
            this.shouldPushTableBorderStyleToDiv() || this.shouldPushTableShadowStyleToDiv() ||
            (this._getAfterPadding != null) || (this._getTopPadding != null);

        if (writeStyle) buttonHTML[8] = this._getCellStyleHTML(null, isTitleClipper);
        else buttonHTML[8] = null;

        // If the iconOrientation and iconAlign are set such that the icon is pinned to the
        // edge of the table rather than showing up next to the title, ensure we center the
        // inner table - alignment of the title will be written directly into its cell.
        buttonHTML[10] = iconAtEdge ? isc.Canvas.CENTER : this._getTextAlign(isRTL);

        buttonHTML[11] = (this.valign == isc.Canvas.TOP ? button._valignTop :
                            (this.valign == isc.Canvas.BOTTOM ? button._valignBottom
                                                              : button._valignMiddle) );

        if (isTitleClipper) {
            buttonHTML[12] = button._id;
            buttonHTML[13] = this._getTitleClipperID();
        } else {
            buttonHTML[13] = buttonHTML[12] = null;
        }


        if (this._canFocus() && this._useNativeTabIndex) {
            buttonHTML[14] = button._tabIndexStart;
            buttonHTML[15] = this.getID();
            buttonHTML[16] = button._callFocus;
        } else {
            buttonHTML[14] = button._closeQuoteRightAngle;
            buttonHTML[15] = buttonHTML[16] = null;
        }
        this.fillInCell(buttonHTML, 17, isTitleClipper);
        return buttonHTML.join(isc.emptyString);
    } else {

        var sb = isc.SB.create(),
            valign = (this.valign == isc.Canvas.TOP || this.valign == isc.Canvas.BOTTOM
                      ? this.valign
                      : "middle");
        var textAlign = this._getTextAlign(isRTL);

        // apply tableStart HTML and potentially a class setting for this.tableStyle
        var tableStart = this._tableStart +
            (this.tableStyle ? " class='" + this.tableStyle + "'" : "");

        sb.append(tableStart,
                  (this.overflow !== isc.Canvas.VISIBLE
                         ? " width='" + this.getInnerWidth() + "' style='table-layout:fixed'" : null),
                  " height='", this.getInnerHeight(), "'><tbody><tr><td class='",
                  this.getStateName(),
                  "' style='", this._getCellStyleHTML([]), "text-align:", textAlign,
                  ";vertical-align:", valign, (!this.wrap ? ";white-space:nowrap" : ""), "'>");
        var titleClipperID = this._getTitleClipperID(),
            iconSpacing = this.getIconSpacing(),
            iconWidth = (this.iconWidth || this.iconSize),
            extraWidth = iconSpacing + iconWidth,
            opposite = ((!isRTL && this.iconOrientation == isc.Canvas.RIGHT) ||
                        (isRTL && ((this.ignoreRTL && this.iconOrientation == isc.Canvas.LEFT) ||
                                   (!this.ignoreRTL && this.iconOrientation == isc.Canvas.RIGHT)))),
            b = (isRTL || opposite) && !(isRTL && opposite);
        var beforePadding = 0,
            afterPadding = 0,
            iconHTML = null;
        if (this.icon != null && !this._ignoreIcon) {
            beforePadding = extraWidth;


            iconHTML = this._generateIconImgHTML({
                align: "absmiddle",
                extraCSSText: (b ? "margin-left:" : "margin-right:") +
                              iconSpacing + "px;vertical-align:middle",
                eventStuff: this._$defaultImgEventStuff
            });
        }
        sb.append((!opposite ? iconHTML : null),
                  "<div id='",
                  titleClipperID,

                  this.canSelectText ? null : "' unselectable='on",
                  "' style='display:inline-block;",
                  (this.icon && !this._ignoreIcon ? (b ? "margin-right:" : "margin-left:") + (-extraWidth) + "px;" : null),
                  isc.Element._boxSizingCSSName, ":border-box;max-width:100%;",
                  (beforePadding ? ((b ? "padding-right:" : "padding-left:") + beforePadding + "px;") : null),
                  (afterPadding ? ((b ? "padding-left:" : "padding-right:") + afterPadding + "px;") : null),
                  "vertical-align:middle;overflow:hidden;",
                  isc.Browser._textOverflowPropertyName, ":ellipsis'>",


                  isc.Browser.isSafari ? "<div></div>" : "",

                  this.getTitleHTML(), "</div>",
                  (opposite ? iconHTML : null));

        sb.append("</td></tr></tbody></table>");
        return sb.release(false);
    }
},

// _getSizeTestHTML()
// Helper method to get an HTML structure which mimics the innerHTML of this button
// but will size naturally to fit the title/icon

_sizeTestHTMLTemplate:[
    '<table cellspacing="0" cellpadding="0"><tbody><tr><td ',   // [0] open table/cell tag
    null,                                                       // [1] 'nowrap="true" ' [or null]
    'class="',                                                  // [2] class start
    null,                                                       // [3] class name
    '" style="',                                                // [4] style start (for padding)
    null,                                                       // [5] possibly padding left/right
    '">',                                                       // [6] close cell tag
    null,                                                       // [7] title + icon
    "</td></tr></tbody></table>"                                // [8] end tag
],

_getSizeTestHTML : function (title, wrap) {
    var template = this._sizeTestHTMLTemplate;
    var isRTL = this.isRTL();

    // padding on the left / as a whole...
    var beforePadding = this._buttonPadding;
    var afterPadding = this._getAfterPadding ? this._getAfterPadding() : beforePadding;
    if (beforePadding != null || afterPadding != null) {
        if (beforePadding != null) {
            template[5] = (isRTL ? "padding-right:" : "padding-left:") + beforePadding + "px;"
        } else {
            template[5] = null;
        }
        if (afterPadding != null) {
            var afterPaddingString = (isRTL ? "padding-left:" : "padding-right:")
                                         + afterPadding + "px;";
            if (template[5] == null) {
                template[5] = afterPaddingString;
            } else {
                template[5] += afterPaddingString;
            }
        }

    } else {
        template[5] = null;
    }

    if (wrap == null) wrap = this.wrap;

    template[1] = wrap ? null : 'nowrap="true" ';
    template[3] = (this.titleStyle
                      ? this.getTitleStateName()
                      : this.getStateName(title)
                    );

    var icon = this.icon;
    if (icon != null) {
        // Stolen from getInnerHTML - determine icon orientation / spacing:
        var iconSpacing = this.getIconSpacing(title),
            iconWidth = (this.iconWidth || this.iconSize),
            extraWidth = iconSpacing + iconWidth,
            opposite = ((!isRTL && this.iconOrientation == isc.Canvas.RIGHT) ||
                        (isRTL && ((this.ignoreRTL && this.iconOrientation == isc.Canvas.LEFT) ||
                                   (!this.ignoreRTL && this.iconOrientation == isc.Canvas.RIGHT)))),
            b = (isRTL || opposite) && !(isRTL && opposite);

        var iconHTML = this._generateIconImgHTML({
                align: "absmiddle",
                extraCSSText: (b ? "margin-left:" : "margin-right:") +
                              iconSpacing + "px;vertical-align:middle",
                eventStuff: this._$defaultImgEventStuff
            });
        if (opposite) {
            template[7] = title == null ? iconHTML : title + iconHTML;
        } else {
            template[7] = title == null ? iconHTML : iconHTML + title;
        }
    } else {
        template[7] = title;
    }
    return template.join("");
},

_getTableElement : function () {
    var handle = this.getHandle();
    return handle && handle.firstChild;
},

_getCellElement : function () {
    var tableElem = this._getTableElement();
    if (tableElem == null) return null;


    return tableElem.rows[0].childNodes[0];
},

redraw : function (a,b,c,d) {
    var borderOnDiv = this.shouldPushTableBorderStyleToDiv();
    // If we were pushing the table border to div and no longer are
    // (or vice versa), drop the cached border size so getHBorderSize et al don't
    // return stale values.

    if (this._currentBorderOnDiv !== borderOnDiv) {
        this._cachedBorderSize = null;
        this._currentBorderOnDiv  = borderOnDiv;
    }
    return this.invokeSuper(isc.Button, "redraw", a, b, c, d);
},

// force a redraw on setOverflow()
// This is required since we write out clipping HTML for our title table if our overflow
// is hidden (otherwise we don't), so we need to regenerate this.
setOverflow : function () {
    var wasDirty = this.isDirty(),
        oldOverflow = this.overflow;
    this.Super("setOverflow", arguments);

    if (!wasDirty && (oldOverflow != this.overflow ||
                      (this.shouldPushTableShadowStyleToDiv())))
    {
        this.redraw();
    }
},

__adjustOverflow : function (reason) {
    this.Super("__adjustOverflow", arguments);


    if (isc.Browser.isSafari && !isc.Browser.isChrome && !isc.Browser.isEdge &&
        this.icon != null &&
        !(this.isPrinting || !this._explicitlySizeTable()))
    {
        var isRTL = this.isRTL(),
            opposite = ((!isRTL && this.iconOrientation == isc.Canvas.RIGHT) ||
                        (isRTL && ((this.ignoreRTL && this.iconOrientation == isc.Canvas.LEFT) ||
                                   (!this.ignoreRTL && this.iconOrientation == isc.Canvas.RIGHT))));

        if (!opposite) {
            var textAlign = this._getTextAlign(isRTL),
                titleClipperHandle = this.getDocument().getElementById(this._getTitleClipperID());
            if (!titleClipperHandle) return;

            var titleClipperStyle = titleClipperHandle.style,
                iconSpacing = this.getIconSpacing(),
                iconWidth = (this.iconWidth || this.iconSize),
                extraWidth = iconSpacing + iconWidth;

            var beforePadding = extraWidth,
                afterPadding = 0;
            // Reset the title clipper's left and right padding to "normal" before checking whether
            // the title is clipped.
            titleClipperStyle[isRTL ? "paddingRight" : "paddingLeft"] = beforePadding + "px";
            titleClipperStyle[isRTL ? "paddingLeft" : "paddingRight"] = "";
            if (this.titleClipped()) {

                if (textAlign === isc.Canvas.CENTER) {
                    beforePadding = ((beforePadding + iconSpacing) / 2) << 0;
                    afterPadding = (iconSpacing / 2) << 0;
                } else if ((!isRTL && textAlign === isc.Canvas.RIGHT) ||
                           (isRTL && textAlign === isc.Canvas.LEFT))
                {
                    beforePadding -= (beforePadding / 2) << 0;
                    afterPadding = iconWidth;
                }
                titleClipperStyle[isRTL ? "paddingRight" : "paddingLeft"] = beforePadding + "px";
                titleClipperStyle[isRTL ? "paddingLeft" : "paddingRight"] = afterPadding + "px";
            }
        }
    }
},

// override getPrintTagStart to avoid writing out the printClassName on the outer div
getPrintTagStart : function (absPos) {
    var props = this.currentPrintProperties,
        topLevel = props.topLevelCanvas == this,
        inline = !absPos && !topLevel && props.inline;

    return [((this.wrap == false) ? "<div style='white-space:nowrap' " : inline ? "<span " : "<div "),
            // could add borders etc here
            this.getPrintTagStartAttributes(absPos),
            ">"].join(isc.emptyString);
},


_$pxSemi:"px;", _$semi:";",
_$borderColon:"border:",
_$zeroVPad:"padding-top:0px;padding-bottom:0px;",
_$paddingColon:"padding:",
_$paddingRightColon:"padding-right:",
_$paddingLeftColon:"padding-left:",
_$bgColorColon:"background-color:",
_$zeroMargin:"margin:0px;",
_$filterNone:"filter:none;",
_$textOverflowEllipsis:isc.Browser._textOverflowPropertyName + ":ellipsis;overflow:hidden;",
_$cellStyleTemplate:[
    "' style='", // [0]
    ,           // [1] explicit css text applied to the button

    ,           // [2] null or "border:" (button border)
    ,           // [3] null or this._buttonBorder (button border)
    ,           // [4] null or ";" (button border)

    ,           // [5] null or "padding:" (button padding)
    ,           // [6] null or this._buttonPadding (button padding)
    ,           // [7] null or ";"  (button padding)

    ,           // [8] null or backgroundColor (button bg color)
    ,           // [9] null or this._buttonBGColor (button bg color)
    ,           // [10] null or ";" (button bg color)

    ,           // [11] null or "margin:0px" (avoid margin doubling)
    ,           // [12] null or "filter:none" (avoid IE8 filter issues)

    ,           // [13] null or "text-overflow:ellipsis;overflow:hidden;"

    ,           // [14] null or "padding-right:"/"padding-left:" (after padding)
    ,           // [15] null or this._getAfterPadding() (after padding)
    null       // [16] null or "px;" (after padding)
               // [17] null or "box-shadow:none;"
               // [18] null or "background-image:none;"

    // No need to close the quote - the button HTML template handles this.
],


_getCellStyleHTML : function (template, isTitleClipper) {
    template = template || this._$cellStyleTemplate;
    template[1] = (this.cssText ? this.cssText : null);


    if (this.forceWrap) {
        template[1] = (template[1] || "") + "word-break:break-word;";
    }

    var pushBorderToDiv = this.shouldPushTableBorderStyleToDiv(),
        border = pushBorderToDiv ? "none;border-radius:inherit" : this._buttonBorder;
    if (border != null) {
        template[2] = this._$borderColon;
        template[3] = border;
        template[4] = this._$semi;
    } else {
        template[2] = null;
        template[3] = null;
        template[4] = null;
    }

    var padding = this._buttonPadding;
    if (padding != null) {
        template[5] = this._$paddingColon;
        template[6] = padding;
        template[7] = this._$pxSemi;
    } else {
        template[5] = null;
        template[6] = null;
        template[7] = null;
    }


    var vPadding = this._getTopPadding ?
            "padding-top:" + this._getTopPadding() + "px;padding-bottom:0px;" :
            (this._writeZeroVPadding() ? this._$zeroVPad : null);
    if (vPadding) {
        if (template[7]) template[7] += vPadding;
        else             template[7]  = vPadding;
    }

    if (this._buttonBGColor != null) {
        template[8] = this._$bgColorColon;
        template[9] = this._buttonBGColor;
        template[10] = this._$semi;
    } else {
        template[8] = null;
        template[9] = null;
        template[10] = null;
    }

    if (this.margin != null) template[11] = this._$zeroMargin;
    else template[11] = null;

    if (isc.Browser.useCSSFilters) template[12] = null;
    else template[12] = this._$filterNone;

    if (isTitleClipper) template[13] = this._$textOverflowEllipsis;
    else template[13] = null;

    var afterPadding;
    if ((!isc.Browser.isIE || isc.Browser.isStrict || isc.Browser.version >= 10 ||
         !this._isStatefulCanvasLabel) &&
        (afterPadding = (this._getAfterPadding == null ? null : this._getAfterPadding())) > 0)
    {
        template[14] = (this.isRTL() ? this._$paddingLeftColon : this._$paddingRightColon);
        template[15] = afterPadding;
        template[16] = this._$pxSemi;
    } else {
        template[16] = template[15] = template[14] = null;
    }


    if (isc.Browser.isChrome && isc.Browser.version == 61 &&
        this.shouldPushTableShadowStyleToDiv())
    {
        // if pushing the shadow styles to the outer div, clear the table styles here
        // - in _applyShadowStyle(), assign inset shadows to the table and others to the div
        template[17] = "box-shadow:none;";
    } else template[17] = null;

    // If a background image was specified it'll be rendered on our clip-handle - suppress
    // any background-image from the className applied to the table cell

    if (this.backgroundImage != null) {
        template[18] = "background-image:none;";
    } else {
        template[18] = null;
    }

    return template.join(isc.emptyString);
},


_writeZeroVPadding : function () {
    return this.overflow == isc.Canvas.HIDDEN && !this.rotateTitle &&
           // don't remove padding during animations or text may reflow
           !this.isAnimating() &&
            (isc.Browser.isMoz || isc.Browser.isSafari || isc.Browser.isIE);
},


setBorder : function (border) {
    var pushStyle = this.shouldPushTableBorderStyleToDiv(),
        handleBorder = this.border,
        buttonBorder = this._buttonBorder,
        newHandleBorder = pushStyle ? border : null,
        newButtonBorder = pushStyle ? null : border;

    if (buttonBorder != newButtonBorder) {
        this._buttonBorder = newButtonBorder;
        this.markForRedraw("Button border changed");
    }
    if (handleBorder != newHandleBorder) {
        this.Super("setBorder", [newHandleBorder], arguments);
    }
},

setPadding : function (padding) {
    this._buttonPadding = padding;
    this.markForRedraw();
},


setBackgroundColor : function (color) {

    var pushToDiv = this.shouldPushTableBorderStyleToDiv(),
        buttonBGColor = this._buttonBGColor,
        handleBGColor = this.backgroundColor,

        newButtonBGColor = pushToDiv ? null : color,
        newHandleBGColor = pushToDiv ? color : null;
    if (buttonBGColor != newButtonBGColor) {
        this._buttonBGColor = newButtonBGColor;
        var cellElem;
        if (!this.destroyed) cellElem = this._getCellElement();
        if (cellElem != null) cellElem.style.backgroundColor = (newButtonBGColor == null ? "" : newButtonBGColor);
    }
    if (handleBGColor != newHandleBGColor) {
        // updates both the handle and the backgroundColor property
        return this.Super("setBackgroundColor", [newHandleBGColor], arguments);
    }

},

// If we're pushing the border style to the div, also push the background color.
// This is required for the case where we have a border-radius to ensure the color
// correctly fills the curved inner edges of the border
_getHandleBackgroundColor : function () {
    if (this.backgroundColor == null && this.shouldPushTableBorderStyleToDiv()) {
        return isc.Button._getStateBackgroundColor(this.isPrinting ? this.getPrintStyleName()
                                                : this.getStateName());
    }
    return this.Super("_getHandleBackgroundColor", arguments);
},
_getHandleOpacity : function () {
    if (this.opacity == null && this.shouldPushTableBorderStyleToDiv()) {
        return isc.Button._getStateOpacity(this.isPrinting ? this.getPrintStyleName()
                                                : this.getStateName());
    }
    return this.Super("_getHandleOpacity", arguments);
},

_$endTable :"</td></tr></tbody></table>",
_endTemplate : function (template, slot) {
    template[slot] = this._$endTable;
    template.length = slot+1;
    return template;
},

_$innerTableStart : "<table role='presentation' cellspacing='0' cellpadding='0'><tbody><tr><td ",
_$fillInnerTableStart : "<table role='presentation' width='100%' cellspacing='0' cellpadding='0'><tbody><tr><td ",
_$fillInnerFixedTableStart : "<table role='presentation' width='100%' cellspacing='0' cellpadding='0' style='table-layout:fixed'><tbody><tr><td ",


_$leftIconCellStyleStart : "font-size:" +
                            (isc.Browser.isFirefox && isc.Browser.isStrict ? 0 : 1) +
                            "px;padding-right:",
_$rightIconCellStyleStart : "font-size:" +
                            (isc.Browser.isFirefox && isc.Browser.isStrict ? 0 : 1) +
                            "px;padding-left:",
_$pxClose : "px'>",
_$newInnerCell : "</td><td ",

_$classEquals : "class='",

_$closeInnerTag : "'>",
_$closeInnerTagNoWrap : "' nowrap='true'>",

_$innerTableEnd : "</td></tr></tbody></table>",

// used to check alignment for the icon
_$right:"right",

// Helper - is the icon pinned to the left / right edge, rather than floated next to the title?
_iconAtEdge : function () {
    return this.icon != null && this.iconAlign != null &&
                (this.iconAlign == this.iconOrientation) &&
                (this.iconAlign != this.align);
},

getIconSpacing : function (otherTitle) {

    var undef;
    if (this.icon == null || this._ignoreIcon ||
        (otherTitle === undef ? this.getTitle() : otherTitle) == null) return 0;
    return this.iconSpacing;
},

fillInCell : function (template, slot, cellIsTitleClipper) {
    var isRTL = this.isRTL();

    var title = this.getTitleHTML();

    if (!this.icon) {

        if (isc.Browser.isMoz) {
            var minHeight = this.reliableMinHeight;
            template[slot] = (minHeight ? "<div>" : null);
            template[slot+1] = title;
            template[slot+2] = (minHeight ? "</div>" : null);
            this._endTemplate(template, slot+3)
        } else {
            template[slot] = title;
            this._endTemplate(template, slot+1)
        }
        return;
    }

    var iconLeft = (!isRTL && this.iconOrientation != isc.Canvas.RIGHT) ||
                    (isRTL && ((this.ignoreRTL && this.iconOrientation != isc.Canvas.LEFT) ||
                               (!this.ignoreRTL && this.iconOrientation != isc.Canvas.RIGHT))),
        iconImg = this._generateIconImgHTML();



    // draw icon and text with spacing w/o a table.
    if (cellIsTitleClipper || this.noIconSubtable) {

        var spacer = isc.Canvas.spacerHTML(this.getIconSpacing(),1);
        template[slot] = (iconLeft ? isc.SB.concat(iconImg, spacer, title)
                                   : isc.SB.concat(title, spacer, iconImg));
        this._endTemplate(template, slot+1)
        return;
    }



    // Should we have the icon show up at the edge of the button, rather than being
    // adjacent to the title text?


    var iconAtEdge = this._iconAtEdge(),
        iconCellSpace;
    if (iconAtEdge) {
        iconCellSpace = (this.iconWidth ? this.iconWidth : this.iconSize) +

            (isc.Browser.isBorderBox ? this.getIconSpacing() : 0)
    }

    var clipTitle = this.shouldClipTitle();

    // if the icon is showing at one edge (and the text is separated from it), draw the
    // table 100% wide
    template[slot] = (iconAtEdge
                      ? (clipTitle
                         ? this._$fillInnerFixedTableStart
                         : this._$fillInnerTableStart)
                      : this._$innerTableStart);

    var styleName = this.isPrinting ? this.getPrintStyleName() :
                    (this.titleStyle
                      ? this.getTitleStateName()
                      : this.getStateName()
                    );
    // this._$tableNoStyleDoubling : defined in Canvas.js
    var tableNoStyleDoubling = this._$tableNoStyleDoubling;
    if (!isc.Browser.useCSSFilters) tableNoStyleDoubling += this._$filterNone;
    var align = this._getTextAlign(isRTL);

    if (iconLeft) {
        // icon cell
        template[++slot] = this._$classEquals;
        template[++slot] = styleName;
        template[++slot] = tableNoStyleDoubling;

        template[++slot] = !isRTL ? this._$leftIconCellStyleStart :
                                    this._$rightIconCellStyleStart;

        template[++slot] = this.getIconSpacing();
        if (iconAtEdge) {
            template[++slot] = "px;width:";
            template[++slot] = iconCellSpace;
        }
        template[++slot] = this._$pxClose;
        template[++slot] = iconImg;
        // title cell
        template[++slot] = this._$newInnerCell;
        template[++slot] = this._$classEquals;

        template[++slot] = styleName;
        template[++slot] = tableNoStyleDoubling;

        if (clipTitle) template[++slot] = this._$textOverflowEllipsis;

        template[++slot] = "' align='";
        template[++slot] = align;

        if (clipTitle) {
            template[++slot] = isc.Button._id;
            template[++slot] = this._getTitleClipperID();
        }
        template[++slot] = (this.wrap ? this._$closeInnerTag : this._$closeInnerTagNoWrap)
        template[++slot] = title;

    } else {
        // title cell:
        template[++slot] = this._$classEquals;
        template[++slot] = styleName;
        template[++slot] = tableNoStyleDoubling;
        if (clipTitle) template[++slot] = this._$textOverflowEllipsis;

        template[++slot] = "' align='";
        template[++slot] = align;

        if (clipTitle) {
            template[++slot] = isc.Button._id;
            template[++slot] = this._getTitleClipperID();
        }
        template[++slot] = (this.wrap ? this._$closeInnerTag : this._$closeInnerTagNoWrap)
        template[++slot] = title;

        // icon cell
        template[++slot] = this._$newInnerCell;

        template[++slot] = this._$classEquals;
        template[++slot] = styleName;
        template[++slot] = tableNoStyleDoubling;

        template[++slot] = !isRTL ? this._$rightIconCellStyleStart :
                                    this._$leftIconCellStyleStart;
        template[++slot] = this.getIconSpacing();
        if (iconAtEdge) {
            template[++slot] = "px;width:";
            template[++slot] = iconCellSpace;
        }
        template[++slot] = this._$pxClose;
        template[++slot] = iconImg;

    }
    template[++slot] = this._$innerTableEnd;
    this._endTemplate(template, slot+1)
},





_imgParams : {
    align: "absmiddle" // just prevents default "texttop" from kicking in
},
_$icon:"icon",
_$defaultImgExtraCSSText: "vertical-align:middle",
_$defaultImgEventStuff: " eventpart='icon'",
_generateIconImgHTML : function (imgParams) {

    var isFontIcon = this.isFontIconConfig(this.icon);

    // NOTE: we reuse a single global imgParams structure, so we must set every field we ever
    // use every time.
    if (imgParams == null) {
        imgParams = this._imgParams;
        imgParams.extraCSSText = this._$defaultImgExtraCSSText;
        imgParams.eventStuff = this._$defaultImgEventStuff;
        imgParams.extraStuff = null;
        // set self as the instance so downstream code can check imgDir settings
        imgParams.instance = this;
    }
    if (this.iconStyle != null) {
        var classText = " class='" + this.iconStyle + this._getIconStyleSuffix() + this._$singleQuote;
        if (imgParams.extraStuff == null) imgParams.extraStuff = classText;
        else imgParams.extraStuff += classText;
    }

    imgParams.name = this._$icon;
    imgParams.width = this.iconWidth || this.iconSize;
    imgParams.height = this.iconHeight || this.iconSize;
    // set self as the instance so downstream code can check imgDir settings
    imgParams.instance = this;

    // for font-icons, just apply the src - the URL isn't stateful at the moment
    if (isFontIcon) imgParams.src = this.icon;
    else imgParams.src = this._getIconURL();

    if (this.iconCursor != null) {
        var cursor = this._getIconCursor();
        var cursorCSSText = "cursor:" + cursor;
        if (imgParams.extraCSSText == null) {
            imgParams.extraCSSText = cursorCSSText;
        } else {
            imgParams.extraCSSText += ";" + cursorCSSText;
        }
    }

    return this.imgHTML(imgParams);
},

_getIconURL : function () {
    var icon = this.Super("_getIconURL", arguments);
    return this._getStatefulIconURL(icon);
},

_getStatefulIconURL : function (icon) {
    // Special exception: If the icon is isc.Canvas._blankImgURL, then simply return the _blankImgURL.
    if (icon === isc.Canvas._blankImgURL || icon == isc.Canvas._$blank) return icon;

    var state = this.state,
        selected = this.selected,
        customState = this.getCustomState(),
        sc = isc.StatefulCanvas;

    // ignore states we don't care about

    if (state == sc.STATE_DISABLED && (!this.showDisabled || !this.showDisabledIcon)) state = null;
    else if (state == sc.STATE_DOWN && (!this.showDown || !this.showDownIcon)) state = null;
    else if (state == sc.STATE_OVER && (!this.showRollOver || !this.showRollOverIcon)) state = null;
    if (!this.showIconState) {
        state = null;
        customState = null;


    } else if (this.showIconCustomState == false) {
        customState = null;
    }

    if (selected && !this.showSelectedIcon) selected = false;
    var focused = this.showFocusedIcon ? this.getFocusedState() : null;

    if (focused && this.showFocusedAsOver) {
        // Don't clobber any other state [Selected or Down, say]
        if (this.showRollOverIcon &&
            (!state || state == isc.StatefulCanvas.STATE_UP))
        {
            state = isc.StatefulCanvas.STATE_OVER;
        }
        focused = false;
    }

    // map to current stockIcon src as necessary, so that a stockIcon name like
    // "Edit" is resolved to an actual URL or sprite-string
    var key = isc.Media.getStockIconKeyForSrc(icon, this.skinImgDir, this);
    if (key) icon = isc.Media.getStockIconSrc(key);

    // see if the src-string can now be decoded as a sprite-config
    var spriteConfig = isc.Canvas._getSpriteConfig(icon);
    if (spriteConfig) {
        // if it's a sprite without a cssClass, apply this button's iconStyle if set
        // - cssClass is stateful but urlForState() does need to know the base style
        if (!spriteConfig.cssClass && this.iconStyle) spriteConfig.cssClass = this.iconStyle;
        // re-encode as a sprite-string
        icon = isc.Canvas._encodeSpriteConfig(spriteConfig);
    }

    return isc.Img.urlForState(icon, selected, focused, state, (this.showRTLIcon && this.isRTL() ? "rtl" : null), customState);
},

// Get the suffix to append to the iconStyle.
// This is similar to StatefulCanvas.getStateSuffix(), but instead of being configured by
// show showRollOver, showDown, showDisabled, etc., this is configured by showRollOverIcon,
// showDownIcon, showDisabledIcon, etc.
_$RTL: "RTL",
_getIconStyleSuffix : function () {
    var state = this.state,
        selected = this.selected ? isc.StatefulCanvas.SELECTED : null,
        customState = this.getCustomState(),
        sc = isc.StatefulCanvas;

    // Ignore states we don't care about
    if (state == sc.STATE_DISABLED && !this.showDisabledIcon) state = isc.emptyString;
    else if (state == sc.STATE_DOWN && !this.showDownIcon) state = isc.emptyString;
    else if (state == sc.STATE_OVER && !this.showRollOverIcon) state = isc.emptyString;

    if (!this.showIconState) {
        state = isc.emptyString;
        customState = null;


    } else if (this.showIconCustomState == false) {
        customState = null;
    }

    if (selected != null && !this.showSelectedIcon) selected = null;
    // Note that getFocusedState() will return false if showFocusedAsOver is true, which is
    // appropriate.
    var focused = this.showFocusedIcon ? (this.getFocusedState() ? isc.StatefulCanvas.FOCUSED : null) : null;
    if (focused && this.showFocusedAsOver) {
        focused = false;
        if (this.showRollOverIcon && (!state || state == sc.STATE_UP)) state = sc.STATE_OVER;
    }
    var suffix = this._getStateSuffix(state, selected, focused, customState);
    if (this.showRTLIcon && this.isRTL()) suffix += this._$RTL;
    return suffix;
},

getTitleHTML : function (ignoreHide, b, c, d) {
    // This will call getTitle() so return contents if appropriate, and will hilite accessKeys
    var title = this.invokeSuper(isc.Button, "getTitleHTML", ignoreHide, b, c, d);

    // support adaptive-width buttons hiding title HTML
    if (!ignoreHide && this._hideTitle) return null;

    // FIXME: title padding should be accomplished with CSS
    if (!this.padTitle || this.align == isc.Canvas.CENTER) return title;

    if      (this.align == isc.Canvas.RIGHT) return title + isc.nbsp;
    else if (this.align == isc.Canvas.LEFT)  return isc.nbsp + title;
},


//> @method Button.setWrap()
// Set whether the title of this button should be allowed to wrap if too long for the button's
// specified width.
//
// @param newWrap (boolean) whether to wrap the title
// @visibility external
//<
setWrap : function (newWrap) {
    if (this.wrap != newWrap) {
        // NOTE: wrap can almost certainly be changed on the fly w/o redraw, at least on modern
        // browsers
        this.wrap = newWrap;
        this.markForRedraw("wrapChanged");
    }
},

// get the cell holding the title text.  DOM only.
getTitleCell : function () {
    if (!this.getHandle()) return null;
    var table = this.getHandle().firstChild,
        row = table && table.rows != null ? table.rows[0] : null,
        cell = row && row.cells != null ? row.cells[0] : null;
    return cell;
},

// get the minimum height of this button which would not clip the title text as it is currently
// wrapped.  Only available after drawing.  For Moz, must set "reliableMinHeight" for
// this to be reliable.
getButtonMinHeight : function () {


    var titleCell = this.getTitleCell();
    // In IE, and probably other DOM browsers, the cell's scrollHeight is reliable
    if (!isc.Browser.isMoz) {
        return titleCell.scrollHeight + isc.Element._getVBorderSize(this.getStateName());
    }


    return titleCell.firstChild.offsetHeight +
        isc.Element._getVBorderSize(this.getStateName());
},

// get the width this button would need to be in order to show all text without wrapping
// XXX move deeper, to Canvas?
getPreferredWidth : function () {



    var oldWrap = this.wrap,
        oldOverflow = this.overflow,
        oldWidth = this.width;

    // set overflow visible with no minimum width in order to get the minimum width that won't
    // wrap or clip the title text
    // XXX because wrapping is controlled by a <NOBR> tag in the generated HTML, we can't detect
    // preferred width without a redraw, even if we could resize without a redraw
    this.setWrap(false);
    this.overflow = isc.Canvas.VISIBLE;
    this.setWidth(1);
    this.redrawIfDirty("getPreferredWidth");

    var width = this.getScrollWidth();

    // reset text wrapping and overflow setting
    this.setWrap(oldWrap);
    this.overflow = oldOverflow;
    // NOTE: if this button needs to redraw on resize, this will queue up a redraw, but if you
    // are trying to set the button to it's preferred size you will avoid a redraw if you set
    // the new size right away.
    this.setWidth(oldWidth);

    return width;
},

// measure button width by writing the "width test" HTML into a test canvas

_measureWidth : function (title) {
    // create common test canvas shared by isc.Button
    var buttonWidthTester = isc.Button._buttonWidthTester;
    if (buttonWidthTester == null || buttonWidthTester.destroyed) {
        buttonWidthTester = isc.Button._buttonWidthTester = isc.Canvas.create({
            autoDraw: false,
            top: -1000,
            width: 1,
            overflow: "hidden",
            ariaState: {
                hidden: true
            }
        });
    }
    // get "width test" HTML for supplied title, and if it matches cache, use cached width
    var testHTML = this._getSizeTestHTML(title);
    if (title != null) {
        if (this._showTitleHTML && this._showTitleHTML == testHTML) return this._showTitleWidth;
    } else {
        if (this._hideTitleHTML && this._hideTitleHTML == testHTML) return this._hideTitleWidth;
    }

    // changed HTML - install it in test canvas and (re)draw it
    buttonWidthTester.setContents(testHTML);
    if (!buttonWidthTester.isDrawn()) buttonWidthTester.draw();
    else buttonWidthTester.redrawIfDirty("measuring button width");

    // cache and report test canvas width
    if (title != null) {
        this._showTitleHTML = testHTML;
        return this._showTitleWidth = buttonWidthTester.getScrollWidth();
    } else {
        this._hideTitleHTML = testHTML;
        return this._hideTitleWidth = buttonWidthTester.getScrollWidth();
    }
},



//> @attr Button.adaptWidthShowIconOnly (boolean : true : IRW)
// If +link{button.canAdaptWidth} is true, and this button has a specified +link{button.icon}, should
// the title be hidden, allowing the button to shrink down to just show the icon when there isn't
// enough horizontal space in a layout to show the default sized button?
// @see button.canAdaptWidth
// @see button.iconOnlyBaseStyle
// @visibility external
//<
adaptWidthShowIconOnly:true,
adaptWidthShouldHideTitle : function () {
    return this.adaptWidthShowIconOnly && this.icon != null;
},

// implements canAdaptWidth: true behavior for button
// We support shrinking in two ways:
// - if adaptWidthShowIconOnly is true, (and there is an icon), hide the title and fit to the icon width
//   [or minWidth if specified and > icon width]
// - otherwise if minWidth is specified and we're currently autoFitWidth:true, allow the content
//   to clip down to minWidth


adaptWidthBy : function (pixelDifference, unadaptedWidth, firstOffer, overflowed) {


    var mayHideTitle = this.adaptWidthShouldHideTitle(),
        mayToggleAutoFit = (this.minWidth != null) && (this._specifiedAutoFit || this.autoFit);
    // We can't meaningfully "adapt width" unless
    // - we are toggling title visibility
    // - we are toggling autoFit settings
    if (!mayHideTitle && !mayToggleAutoFit) {
        return 0;
    }


    var canOverflow = mayToggleAutoFit ||
                    (this.overflow != isc.Canvas.HIDDEN && this.overflow != isc.Canvas.CLIP_H);

    // consider whether to show or hide the button's title, based on the pixel offer

    var adaptToSmallerSize = this._adaptedToSmallerSize;
    if ((pixelDifference > 0 && adaptToSmallerSize) ||
         (pixelDifference < 0 && !adaptToSmallerSize))
    {
        // desired state is opposite title visibility / clipping
        adaptToSmallerSize = !adaptToSmallerSize;
    } else {
        // keep current title visibility/clipping, but possibly still adapt
        if (overflowed || !firstOffer) return 0;
    }

    // calculate the desired width (in the new state)

    var desiredWidth;
    if (!adaptToSmallerSize && !canOverflow && isc.isA.Number(this._userWidth)) {
        desiredWidth = this._userWidth;
    } else {
        if (adaptToSmallerSize) {
            desiredWidth = this.minWidth || 1;
            if (mayHideTitle) desiredWidth = Math.max(desiredWidth, this._measureWidth(null));
        } else {
            desiredWidth = this._measureWidth(this.getTitleHTML(true));
        }
    }
    // we want to render smaller than normal
    if (adaptToSmallerSize) {

        if (desiredWidth < unadaptedWidth) {
            this._adaptedToSmallerSize = true;

            this._hideTitle = mayHideTitle;
            if (mayToggleAutoFit) {
                this.setAutoFit(false);
                // Remember that the user requested autoFit:true for next time this method runs
                this._specifiedAutoFit = true;
            }

            this.markForRedraw();

            return desiredWidth - unadaptedWidth;
        }

    // we want to show the title
    } else {

        var availableWidth = unadaptedWidth + pixelDifference;
        if (desiredWidth <= availableWidth) {
            this._adaptedToSmallerSize = false;

            this._hideTitle = false;
            if (mayToggleAutoFit) {
                this.setAutoFit(true);
            }
            this.markForRedraw();
            return desiredWidth - unadaptedWidth;
        }
    }

    // reject the offer - maintain currently adapted width
    return 0;
},

getTitle : function (ignoreHide) {
    if (!ignoreHide && this._hideTitle) return null;
    if (this.useContents) return this.getContents();
    return this.title;
},

getStateName : function (title) {
    var undef,
        modifier = this.getStateSuffix(),
        hideTitle = title !== undef ? !title : this._hideTitle,
        baseStyle = hideTitle && this.iconOnlyBaseStyle || this.baseStyle;
    return modifier ? baseStyle + modifier : baseStyle;
},

//>    @method    button.stateChanged()    (A)
//        @group    appearance
//            overrides the StatefulCanvas implementation to update the contents TD className
//<
stateChanged : function () {

    var src, url, isSprite, spriteConfig, isFontIcon, fontConfig;
    if (this.icon) {
        if (isc.isA.String(this.icon)) {
            // for strings, check if they map to a stockIcon (by URL or name)
            var stockIconKey = isc.Media.getStockIconKeyForSrc(this.icon, this.skinImgDir, this);
            if (stockIconKey) {
                // if there's a apping, use it
                src = isc.Media.getStockIconSrc(stockIconKey);
            }
        }

        // no mapping, get the default from _getIconURL()
        if (!src) src = this._getIconURL();
        // see if the src is a sprite-config
        spriteConfig = isc.Canvas._getSpriteConfig(src);
        isSprite = spriteConfig != null;

        if (!isSprite) {
            // if not, see if it's a fontIcon-config
            isFontIcon = isc.Media.isFontIconConfig(src);
            if (isFontIcon) fontConfig = isc.Media.getFontIconConfig(src);
        }
    }

    if (src) {
        var url = src;
        // if the src is a sprite, expand its URL only
        if (spriteConfig) url = spriteConfig.svg || spriteConfig.src;
        url = isc.Page.getImgURL(url, this.skinImgDir, this);

        // pass in this as the instance, to get at skinDir
        var stockIconKey = isc.Media.getStockIconKeyForSrc(url, null, this);

        // the path was mapped to a stockIcon, so get the current src for that stockIcon and then
        // check whether it's a spriteObject
        if (stockIconKey && src) {
            src = isc.Media.getStockIconSrc(stockIconKey);
            // see if the mapped src is a sprite-config
            spriteConfig = isc.Canvas._getSpriteConfig(src);
            isSprite = spriteConfig != null;

            if (!isSprite) {
                // if not, see if it's a fontIcon-config
                isFontIcon = isc.Media.isFontIconConfig(src);
                if (isFontIcon) fontConfig = isc.Media.getFontIconConfig(src);
            }
        }
    }


    if (this._shouldRedrawOnStateChange() || !this.isDrawn() ||
        this.icon && !this._canSetImage(this._$icon, src, isSprite))
    {
        // pass the param to force superclass method to redraw
        return this.invokeSuper(isc.Button, "stateChanged", true);

    } else {
        var stateName = this.isPrinting ? this.getPrintStyleName() : this.getStateName();

        // if the border properties are on the DIV, apply them to the element's handle now
        if (this.shouldPushTableBorderStyleToDiv()) {
            this._applyBorderStyle(stateName);
            // Also apply the bg-color to the div. This is required to ensure
            // the background butts up agains the inner edge of any curved borders properly
            var styleHandle = this.getStyleHandle();
            if (styleHandle != null) {
                var newColor = this._getHandleBackgroundColor();
                styleHandle.backgroundColor = newColor;
                // push opacity after background-color
                var newOpacity = this._getHandleOpacity();
                styleHandle.opacity = newOpacity;
            }
        }
        if (this.shouldPushTableShadowStyleToDiv()) {
            this._applyShadowStyle(stateName);
        }


        if (!this.suppressClassName) this.setClassName(this.getStyleList(stateName));
        else this.setTableClassName(stateName);

        // if _igoreIcon is set, ignore the icon - RibbonButton, see check in StatefulCanvas
        if (src && !this._ignoreIcon && this.getImage(this._$icon, isSprite)) {
            // NOTE: the icon may or may not actually change to reflect states or selected-ness,
            // but either state or selected-ness or both may have just changed, and we may be
            // transitioning from a state we do show to a state we don't, so no-oping is
            // tricky; we don't both for now.
            this.setImage(this._$icon, src, null, isSprite);

            if (this.iconStyle != null) {
                this.getImage(this._$icon).className =
                    this.iconStyle + this._getIconStyleSuffix();
            } else if (fontConfig && fontConfig.cssClass) {
                // if it's a font-icon, append the state-suffix to the cssClass from the src
                //this.getImage(this._$icon).className =
                //    fontConfig.cssClass + this._getIconStyleSuffix();
            }
        }

        // If we have a titleStyle and we are using a subtable, then update the styles of the
        // subtable's cells.
        var TD;
        if (this.titleStyle && (TD = this.getTitleCell()) != null) {
            var firstChild = TD.firstChild;
            if (firstChild != null && firstChild.tagName == this._$TABLE) {
                var titleStyleName = this.isPrinting ? this.getPrintStyleName() : this.getTitleStateName();


                var cells = firstChild.rows[0].childNodes;
                for (var i = 0; i < cells.length; i++) {
                    cells[i].className = titleStyleName;
                }
            }
        }
    }
},

// Set the css className of the table cell
_$TABLE: "TABLE",
setTableClassName : function (newClass){
    // If we're pushing the border style to the div, we can't assume the
    // border thickness for the widget won't change with the new style name
    if (this.shouldPushTableBorderStyleToDiv()) {
        this._cachedBorderSize = null;
    }

    var TD = this.getTitleCell();
    if (!TD) return;

    if (this.pendingMarkerVisible) {
        // if pendingMarkerVisible is set, include the pendingMarker in the TD
        var styleList = this.getStyleList(newClass);
        TD.className = styleList;
    } else {
        if (TD.className != newClass) TD.className = newClass;
    }


    if (this._usesSubtable(true) && !this.titleStyle) {
        // if we're using a subtable, update the style on the title cell too (it won't
        // cascade).

        var firstChild = TD.firstChild;
        if (firstChild != null && firstChild.tagName == this._$TABLE) {

            var cells = firstChild.rows[0].children;
            if (cells != null) {
                for (var i = 0; i < cells.length; i++) {
                    if (cells[i] && cells[i].className != newClass) cells[i].className = newClass;
                }
            }
        }
    }


    if (this.overflow == isc.Canvas.VISIBLE) {

        this._resetHandleOnAdjustOverflow = true;
        this.adjustOverflow("table style changed");
    }
},


getScrollWidth : function (recalculate,a,b,c) {
    var reportedScrollWidth = this.invokeSuper(isc.Button, "getScrollWidth", recalculate,a,b,c);
    if (!recalculate || !this.isDrawn()) return reportedScrollWidth;
    if (isc.Browser.isIE9 && this._usesSubtable(true)) {
        var titleClipperHandle = this.getDocument().getElementById(this._getTitleClipperID());
        if (titleClipperHandle != null) {
            var scrollWidth;
            if (isc.Browser.isMoz) {

                var range = this.getDocument().createRange();
                range.selectNodeContents(titleClipperHandle);
                var contentsBCR = range.getBoundingClientRect();
                scrollWidth = contentsBCR.width;
            } else {

                scrollWidth = titleClipperHandle.scrollWidth;
            }

            if (this.icon != null) {
                var iconSpacing = this.getIconSpacing(),
                    iconWidth = (this.iconWidth || this.iconSize),
                    extraWidth = iconSpacing + iconWidth;
                scrollWidth += extraWidth;
            }

            scrollWidth += isc.Element._getHBorderPad(this.getStateName());

            return Math.ceil(scrollWidth);
        }

    } else if ((isc.Browser.isMoz && isc.Browser.isMac && isc.Browser.version >= 4) ||
               isc.Browser.isIE9)
    {
        var tableElem = this._getTableElement();
        var position = tableElem.style.position;
        var range = tableElem.ownerDocument.createRange();
        range.selectNode(tableElem);
        var contentsBCR = range.getBoundingClientRect();

        var bcrScrollWidth;

        if (isc.Browser.isIE9 && !isc.Browser.isIE10) {
            bcrScrollWidth = (contentsBCR.width + 1) << 0;
        } else {
            bcrScrollWidth = Math.ceil(contentsBCR.width);
        }

        if (bcrScrollWidth > reportedScrollWidth) {
             this._scrollWidth = bcrScrollWidth;
             return bcrScrollWidth;
        }
    }

    return reportedScrollWidth;

},

setIcon : function (icon) {
    var hadIcon = this.icon != null;
    this.icon = icon;

    // Make sure that we're drawn before trying to set the image src or redraw().
    if (this.isDrawn()) {
        var src = this._getIconURL(),
            isSprite = this._iconIsSprite()
        ;
        if (hadIcon && (icon != null) && this._canSetImage(this._$icon, src, isSprite)) {
            this.setImage(this._$icon, src, null, isSprite);
        } else {
            this.redraw();
        }
    }
},

setIconStyle : function (iconStyle) {
    this.iconStyle = iconStyle;

    var hadIcon = this.icon != null;
    if (this.isDrawn() && hadIcon) {
        var image = this.getImage(this._$icon);
        if (image != null) {
            image.className = (iconStyle == null ? isc.emptyString
                                                 : iconStyle + this._getIconStyleSuffix());
        }
    }
},

_cellFocus : function () {
    isc.EH._setThread("cFCS");
    this.focus();
    isc.EH._clearThread();
},

// override _updateCanFocus() to redraw the button.  If the focusability of the button is changed
// and we're making use of native HTML focus / tabIndex behavior, we'll need to regenerate the
// inner HTML.
_updateCanFocus : function () {
    this.Super("_updateCanFocus", arguments);
    if (this._useNativeTabIndex) this.markForRedraw();
},

_getShadowCSSHTML : function (stateName) {
    // explicit 'showShadow' overrides settings on the css class
    var cssText;
    if (this.showShadow && this.shouldUseCSSShadow()) {
        cssText = this._getShadowCSSText(true);
        if (cssText == null) cssText = "";
    } else {
        var cssText = isc.StatefulCanvas._getShadowCSSHTML(stateName);
        if (cssText != isc.emptyString) cssText = ";" + cssText;
    }
    return cssText;
},


// return the border HTML used by getTagStart
_getBorderHTML : function () {

    if (this.shouldPushTableBorderStyleToDiv()) {
        var stateName = this.isPrinting ? this.getPrintStyleName() : this.getStateName();

        var borderHTML = this.border != null ? ";BORDER:" + this.border : "";
        borderHTML += isc.StatefulCanvas._getBorderCSSHTML(this.border != null, stateName);
        // Also apply box-shadow CSS text. Not technically part of the border but
        // this also needs to be shifted from the Table element to the
        // widget handle
        if (this.shouldPushTableShadowStyleToDiv()) {
            borderHTML += this._getShadowCSSHTML(stateName);
        }
        return borderHTML;
    }

    var borderHTML = this.Super("_getBorderHTML", arguments);
    if (this.shouldPushTableShadowStyleToDiv()) {
        var stateName = this.isPrinting ? this.getPrintStyleName() : this.getStateName(),
            shadowCSS = this._getShadowCSSHTML(stateName);
        if (shadowCSS != isc.emptyString) {
            borderHTML = borderHTML == null ? shadowCSS : borderHTML + shadowCSS;
        }
    }

    return borderHTML;
},

_applyBorderStyle : function (className) {
    var styleHandle = this.getClipHandle().style,
        properties = isc.StatefulCanvas._buildBorderStyle(this.border != null, className);

    // if this.border is set, we don't want the CSS style to clobber it - the first param in
    // the call to _buildBorderStyle() above will cause it to return only border-radius styles
    // - in that case, don't clear the border setting on the styleHandle.
    if (!this.border) styleHandle.border = isc.emptyString;
    styleHandle.borderRadius = isc.emptyString;
    isc.addProperties(styleHandle, properties);
},

_applyShadowStyle : function (className) {

    var styleHandle = this.getClipHandle().style;
    if (this.showShadow && this.shouldUseCSSShadow()) {
        styleHandle.boxShadow = this._getShadowCSSText();
        return;
    }

    // get the outset shadows
    var properties = isc.StatefulCanvas._buildShadowStyle(className);

    // reset all shadow styling on the outer div
    styleHandle.boxShadow = isc.emptyString;
    // apply just the outset shadows to the outer div
    isc.addProperties(styleHandle, properties);

    // in Chrome, we want to apply inset shadows to the table element, to avoid missizing
    // - in other browsers, assign them to the cell, so inset shadows show
    var elem = (isc.Browser.isChrome) ? this._getTableElement() : this._getCellElement();

    if (elem != null) {
        var style = elem.style;
        // get the inset shadows
        properties = isc.StatefulCanvas._buildShadowStyle(className, null, true);

        // reset all shadow styling on the inner table
        style.boxShadow = isc.emptyString;
        // apply just the inset shadows to the inner table
        isc.addProperties(style, properties);
    }
},

// CSS class that actually governs what borders appear on the handle.
// This is overridden in Button.js where we apply the baseStyle + modifier to the
// handle directly.
_getBorderClassName : function () {
    if (this.shouldPushTableBorderStyleToDiv()) {
        return this.getStateName();
    }
    return this.Super("_getBorderClassName", arguments);
},

//>    @method    button.setAlign()
// Sets the (horizontal) alignment of this buttons content.
//  @group positioning
//  @visibility external
//<
// defined in StatefulCanvas

//>    @method    button.setVAlign()
// Sets the vertical alignment of this buttons content.
//  @group positioning
//  @visibility external
//<
// defined in StatefulCanvas

// In IE a click on a TD element can cause native focus to go to that element, which
// means if you click on a button you can end up at the wrong spot in the page's tab order
// Use handleFocusIn (bubbled up from the TD element) to catch this and reset focus
// to the widget handle.

handleFocusIn : function (element, event) {

    if (isc.Browser.isIE && this._canFocus() && isc.EH.leftButtonDown()) {
        var nodeName = element && element.nodeName;
        if (nodeName == "TD") {
            this.logWarn(
                "Button: Intercepting native focus from mouseDown on table cell and resetting to handle.",
                "nativeFocus");
            this.focus();
            return;
        }
    }
    // This will fire the standard focus notification
    return this.Super("handleFocusIn", arguments);

}

});    // END    isc.Button.addMethods()



isc.Button.addClassProperties({
    _stateBGColorCache:{},
    _getStateBackgroundColor : function (className) {
        var nullMarker = "**null**";
        if (this._stateBGColorCache[className] == null) {
            var computedStyle = isc.Element._deriveStyleProperties(className, ["backgroundColor"]);
            this._stateBGColorCache[className] = computedStyle.backgroundColor == null ?
                                                nullMarker : computedStyle.backgroundColor;
        }
        return this._stateBGColorCache[className] == nullMarker ? null :
                this._stateBGColorCache[className];
    },
    _stateOpacityCache:{},
    _getStateOpacity : function (className) {
        var nullMarker = "**null**";
        if (this._stateOpacityCache[className] == null) {
            var computedStyle = isc.Element._deriveStyleProperties(className, ["opacity"]);
            this._stateOpacityCache[className] = computedStyle.opacity == null ?
                                                nullMarker : computedStyle.opacity;
        }
        return this._stateOpacityCache[className] == nullMarker ? null :
                this._stateOpacityCache[className];
    }
});

isc.Button.registerStringMethods({
    getTitle:null
});


// AutoFitButton
// --------------------------------------------------------------------------------------------
// Button that automatically sizes to the title text.

//> @class AutoFitButton
//
// A button that automatically sizes to the length of its title.  Implemented via the
// +link{StatefulCanvas.autoFit} property.
//
// @deprecated As of Isomorphic SmartClient version 5.5, autoFit behavior can be achieved using
// the Button class instead by setting the property +link{Button.autoFit} to true.
//
// @see Button
// @inheritsFrom Button
// @treeLocation Client Reference/Control/Button
// @visibility external
//<

isc.ClassFactory.defineClass("AutoFitButton", "Button");

isc.AutoFitButton.addProperties({
    autoFit:true
});




isc.Button.registerStringMethods({
    //>@method Button.iconClick()
    // If this button is showing an +link{Button.icon, icon}, a separate click handler for the
    // icon may be defined as <code>this.iconClick</code>.
    // Returning false will suppress the standard button click handling code.
    // @return (boolean) false to suppress the standard button click event
    // @group buttonIcon
    // @visibility external
    //<
    // don't expose the parameters - they're not really useful to the developer
    iconClick:"element,ID,event",

    //> @method button.titleHover()
    // Optional stringMethod to fire when the user hovers over this button and the title is
    // clipped. If +link{Button.showClippedTitleOnHover} is true, the default behavior is to
    // show a hover canvas containing the HTML returned by +link{Button.titleHoverHTML()}.
    // Return false to suppress this default behavior.
    // @return (boolean) false to suppress the standard hover
    // @see Button.titleClipped()
    // @group hovers
    // @visibility external
    //<
    titleHover:""
});


// Make "IButton" a synonym of Button by default.

//>    @class    IButton
//
// The IButton widget class is a class that implements the same APIs as the
// +link{class:Button} class.  Depending on the current skin, <code>IButton</code>s may be
// on the +link{StretchImgButton} component, which renders via images, or may be based on the
// +link{Button} component, which renders via CSS styles.
//
// @inheritsFrom Button
// @treeLocation Client Reference/Control
// @visibility external
//<

isc.addGlobal("IButton", isc.Button);

//> @class SecondaryButton
// A simple +link{class:Button} subclass with a de-emphasized appearance,
// applied by a separate +link{statefulCanvas.baseStyle, CSS style-series}
// named "secondaryButton".
// <p>
// <code>SecondaryButton</code> is mostly intended for skinning purposes and the framework
// doesn't automatically use it anywhere - you should create instances directly if you want a
// secondary, de-emphasized appearance for buttons.
// @inheritsFrom Button
// @treeLocation Client Reference/Control
// @visibility external
//<
isc.ClassFactory.defineClass("SecondaryButton", "IButton").addProperties({
    baseStyle:"secondaryButton",
    height: 22,
    showFocusedAsOver:false,
    showFocusOutline:false
});







//>    @class    Img
//
//    The Img widget class implements a simple widget that displays a single image.
//
//  @inheritsFrom StatefulCanvas
//  @treeLocation Client Reference/Foundation
//  @visibility external
//  @example img
//<

isc.defineClass("Img", "StatefulCanvas").addClassMethods({
    _buffer : [],
    urlForState : function (baseURL, selected, focused, state, pieceName, customState) {
        if (!baseURL) return baseURL;

        // if the baseURL is a string, check if it's a stockIcon and map it - this means
        // a src-string can be just a stockIcon name like "Chevron_Right"
        if (isc.isA.String(baseURL)) {
            var stockIconKey = isc.Media.getStockIconKeyForSrc(baseURL, null, this);
            if (stockIconKey) {
                baseURL = isc.Media.getStockIconSrc(stockIconKey);
            }
        }

        // Stateful sprited images:
        // if passed a single sprited image config like
        //  sprite:someSprite.png;offset:100,100;size:25,25
        // or
        //  sprite:cssClass:someClassName;size:25,25
        // apply statefulness via the following steps:
        // - if there's an image URL, append the stateful suffix to it
        // - if there's a css class, append the stateful suffix to that (without any "_" chars)
        // (If both are specified, do both)

        var spriteConfig;
        if (baseURL.isSprite) spriteConfig = baseURL;
        else spriteConfig = isc.Canvas._getSpriteConfig(baseURL);
        if (spriteConfig != null) {
            var url = spriteConfig.src,
                cssClass = spriteConfig.cssClass
            ;

            // this is a regular sprite-string, with the URL in a "src" attribute
            if (url != null) {
                // Go recursive to append statefulness to URL
                spriteConfig.src = this.urlForState(url, selected, focused, state, pieceName, customState);
            }
            // this is an SVG-symbol sprite-string, with the URL in an "svg" attribute
            // - the "statefulId" attribute isn't doc'd and may be changed, the idea is just to
            // force a dev to choose stateful symbold-id's, since it won't be a common usage
            if (spriteConfig.svg != null && spriteConfig.statefulId) {
                // an svg sprite looks like "sprite:svg:file.svg#symbol-id;size:w,h;" - we want
                // to append _State to the end of the "svg" element, which modifies the
                // symbol-id (the fragment after the #), so you get symbol-id_Over, for example
                var combinedState = isc.StatefulCanvas._getStateSuffix(state, selected, focused, customState) || "";
                spriteConfig.svg = spriteConfig.svg + (combinedState == "" ? "" : "_" + combinedState);
            }

            // both types support "cssClass", but may set statefulClass: false
            if (cssClass != null) {
                var statefulClass = true;
                if (spriteConfig.statefulId && !spriteConfig.statefulClass) {
                    statefulClass = false;
                } else {
                    statefulClass = spriteConfig.statefulClass != false;
                }
                // if statefulClass is set to false or there's a statefulId
                if (statefulClass) {
                    var suffix = isc.StatefulCanvas._getStateSuffix(state, selected, focused, customState);
                    if (suffix && suffix.length > 0 && !spriteConfig.cssClass.endsWith(suffix)) {
                        spriteConfig.cssClass = spriteConfig.cssClass + suffix;
                    }
                }
            }


            return isc.Canvas._encodeSpriteConfig(spriteConfig);
        } else if (isc.isA.String(baseURL)) {
            // see if it's a font-icon
            var config = isc.Media.getFontIconConfig(baseURL);
            if (config) {
                if (config.cssClass != null) {
                    config.cssClass += (isc.StatefulCanvas._getStateSuffix(
                        state, selected, focused, customState) || ""
                    );
                }
                return isc.Media._encodeFontIconConfig(config);
            }
        }

        // Handle being passed a SCStatefulImgConfig object
        // This is an object which contains image URL for multiple states
        // States in this object are optional - if we can't find exactly the requested
        // state we back off to an equivalent that is present
        // (So if an object is Selected + Focused, but SelectedFocused is not defined, we
        // back off to Focused, or Selected if present). Details below.
        if (isc.isAn.Object(baseURL)) {
            // a config with no "_base" is likely, though not necessarily, invalid.
            // Warn if we encounter this.
            if (baseURL._base == null) {
                // the baseURL only really *needs* a _base setting if it has other settings
                // that make use of the #modifier or #state prefixes, which specifically
                // expand on the _base setting (in most cases)
                var shouldWarn = false,
                    firstValid = null
                ;
                for (var key in baseURL) {
                    if (!firstValid && !key.contains("#")) firstValid = key;
                    if (isc.isA.String(baseURL[key]) && baseURL[key].contains("#")) {
                        shouldWarn = true;
                        break;
                    }
                }
                if (shouldWarn) {
                    this.logWarn("Attempt to derive stateful URL for object:" + this.echo(baseURL) +
                        " using the #modifier or #state prefixes when the object has no explicit " +
                        "'_base' attribute.  Setting _base to match the first " +
                        "valid key in the object to avoid downstrem issues.", "StatefulImgConfig");

                    baseURL._base = baseURL[firstValid];
                }
            }


            // short circuit to just return baseURL for the simple case
            if (!state && !pieceName && !selected && !focused && !customState) return baseURL._base;


            // If passed arguments for a combination of 'selected', 'focused', 'state', 'pieceName'
            // and 'customState', we want to find a corresponding attribute by combining
            // these into a single attribute name
            //
            // selected+focused+"over"+"RTL"+"Opened" = baseURL.selectedFocusedOverRTLOpened
            //
            // If this is un-populated we want to gracefully back off to whatever alternative
            // state makes sense.
            //


            var hasState = !(state == null && pieceName == null && customState == null);
            if (hasState && (selected || focused)) {
                // Full attribute
                if (selected && focused) {
                    var combinedAttribute = this._getCombinedStatefulImgAttribute([
                        "Selected",
                        "Focused",
                        state,
                        pieceName,
                        customState
                    ]);
                    if (baseURL[combinedAttribute]) {
                        return this.resolveStatefulImgConfigEntry(combinedAttribute, baseURL);
                    }
                }
                if (selected) {
                    var combinedAttribute = this._getCombinedStatefulImgAttribute([
                        "Selected",
                        state,
                        pieceName,
                        customState
                    ]);
                    if (baseURL[combinedAttribute]) {
                        return this.resolveStatefulImgConfigEntry(combinedAttribute, baseURL);
                    }

                }
                if (focused) {
                    var combinedAttribute = this._getCombinedStatefulImgAttribute([
                        "Focused",
                        state,
                        pieceName,
                        customState
                    ]);
                    if (baseURL[combinedAttribute]) {
                        return this.resolveStatefulImgConfigEntry(combinedAttribute, baseURL);
                    }
                }
            }

            // At this state we know we don't have a combination of state + selected/focused
            // Either use the state with no selected/focused modifier, or the
            // selected/focused status with no state modifier

            var modifiersAttr;
            if (selected && focused && baseURL.SelectedFocused) {
                modifiersAttr = "SelectedFocused";
            }
            if (!modifiersAttr && selected && baseURL.Selected) {
                modifiersAttr = "Selected";
            }
            if (!modifiersAttr && focused && baseURL.Focused) {
                modifiersAttr = "Focused";
            }

            // If no state was passed in, or we prefer the modifiers to the state,
            // use the modifiers attribute by default ("SelectedFocused" or whatever)
            if (modifiersAttr && (!hasState || this.preferModifiersToState[state])) {
                return this.resolveStatefulImgConfigEntry(modifiersAttr, baseURL);
            }

            // If we have a state and we should prefer the state to the modifiers [the default]
            // *or* the config didn't include any Selected/Focused entries, look for
            // a simple state entry
            if (hasState) {
                var stateAttribute = this._getCombinedStatefulImgAttribute([
                    state,
                    pieceName,
                    customState
                ]);
                if (baseURL[stateAttribute]) {
                    return this.resolveStatefulImgConfigEntry(stateAttribute, baseURL);
                }
            }

            // At this stage if we have a Selected/Focused entry we had a specified state
            // but couldn't find an entry for it in the config object.
            // Just use the Selected/Focused entry, or back off to the _base URL
            if (modifiersAttr) {
                return this.resolveStatefulImgConfigEntry(modifiersAttr, baseURL);
            }

            return baseURL._base;

        } // End of the SCStatefulImgConfig handling

        // Below here will assume baseURL is a string and assemble a new stateful URL
        // by modifying it

        // short circuit to just return baseURL for the simple case
        if (!state && !pieceName && !selected && !focused && !customState) return baseURL;

        // break baseURL up into name and extension
        var period = baseURL.lastIndexOf(isc.dot),
            name = baseURL.substring(0, period),
            extension = baseURL.substring(period),
            buffer = this._buffer;
        buffer.length = 1;
        buffer[0] = name;
        // add selected
        if (selected) {
            buffer[1] = isc._underscore;
            buffer[2] = isc.StatefulCanvas.SELECTED;
        }
        // add focused
        if (focused) {
            buffer[3] = isc._underscore;
            buffer[4] = isc.StatefulCanvas.FOCUSED;
        }
        // add state
        if (state) {
            buffer[5] = isc._underscore;
            buffer[6] = state;
        }
        if (customState) {
            buffer[7] = isc._underscore;
            buffer[8] = customState;
        }
        // add pieceName
        if (pieceName) {
            buffer[9] = isc._underscore;
            buffer[10] = pieceName;
        }
        buffer[11] = extension;
        var result = buffer.join(isc._emptyString);
        return result;
    },
    // Helper to combine a sparse array of state names into a single attribute name
    _getCombinedStatefulImgAttribute : function (stateNames) {
        stateNames.removeEmpty();
        var combinedAttr;
        for (var i = 0; i < stateNames.length; i++) {
            if (stateNames[i] == "") continue;
            if (combinedAttr == null) {
                combinedAttr = stateNames[i];
            } else {
                combinedAttr += stateNames[i].substring(0,1).toUpperCase() + stateNames[i].substring(1);
            }
        }
        return combinedAttr;
    },

    // This is a list of states for which if we're looking for as stateful image
    // representing a modifier with the state ("Selected" + "Over") say, and we can't
    // find an entry in a statefulImgConfig for this combined state, we should
    // back off to the modifier(s) ("Selected") rather than backing off to the state ("Over")
    preferModifiersToState : [
        "Over", "Down"
    ],

    // Helper to resolve the special meta value naming pattern for entries in a
    // statefulImgConfigEntry.
    // If #modifier:<xxx> is specified, apply the modifier as a suffix to the base img URL
    // If #state:<xxx> is specified, pick up the value of the other specified state
    // Third parameter is used when the method calls recursively to resolve #state:... entries
    // to detect circular references in the config object.
    // For example:
    // {state1:"#state:state2",
    //  state2:"#state:state1"}
    resolveStatefulImgConfigEntry : function (entry, config, previousValues) {
        var value = config[entry];
        if (value == null) return null;
        if (value.startsWith("#")) {
            var splitVal = value.split(":");
            switch (splitVal[0]) {
                case "#modifier" :
                    var finalValue = config._base,
                        suffixIndex = finalValue.lastIndexOf(".");
                    finalValue = finalValue.substring(0,suffixIndex) +
                            splitVal[1] +
                            finalValue.substring(suffixIndex);
                    return finalValue;
                case "#state" :
                    if (previousValues != null) {
                        if (previousValues.contains(splitVal[1]) && !config._warnedOnCircularRef) {
                            // Avoid spamming this warning repeatedly
                            config._warnedOnCircularRef = true;
                            this.logWarn("Stateful image Configuration contains a circular reference:" +
                                this.echo(config) + ". Unable to resolve " + previousValues[0] + " to an image");
                            return null;
                        }

                        previousValues.add(entry);
                    } else {
                        previousValues = [entry];
                    }
                    return this.resolveStatefulImgConfigEntry(splitVal[1], config, previousValues);
                default :
                    // it's unlikely that the file name starts with a hash tag.
                    // If it does, log a warning but use it anyway.
                    this.logWarn("stateful image configuration value:"
                            + entry + " from configutation object:" + this.echo(config) +
                            " has hash prefix but does not conform to expected naming" +
                            " pattern for meta value. Returning as is.");
            }
        }
        return value;
    },

    measureImage : function (source, callback, scaleRect) {
        var src = isc.Page.getURL(isc.isAn.Img(source) ? source.src : source);

        // load the image in an img tag, scale its dimensions and pass the result to the callback
        var img = new Image();
        img.onload = function () {
            var result = { width: img.width, height: img.height };
            if (scaleRect) {
                var scaled = isc.Img.scaleDimensions(img.width, img.height, scaleRect.width, scaleRect.height);
                result.maxWidth = scaleRect.width;
                result.maxHeight = scaleRect.height;
                result.scaledWidth = scaled.width;
                result.scaledHeight = scaled.height;
                result.ratio = scaled.ratio;
            }
            callback(result);
        }
        img.src = src;
    },

    scaleDimensions : function (width, height, maxWidth, maxHeight) {
        var ratio = Math.min(maxWidth / width, maxHeight / height);
        return { width: width*ratio, height: height*ratio, ratio: ratio };
    }
});

// add default properties
isc.Img.addProperties( {
    //> @attr    img.name    (String : "main" : IA)
    // The value of this attribute is specified as the value of the 'name' attribute in the
    // resulting HTML.
    // <p>
    // Note: this attribute is ignored if the imageType is set to "tile"
    //
    // @visibility external
    //<
    name:"main",

    //> @object SCStatefulImgConfig
    //
    // A configuration object containing image URLs for a set of possible
    // images to display based on the +link{StatefulCanvas.state,state} of some components.
    // See the +link{group:statefulImages,stateful images overview} for more information.
    // <P>
    // Each attribute in this configuration object maps a state to a target URL.<br>
    // Each URL may be specified in one of three ways
    // <ul><li>a standard +link{SCImgURL} may be used to refer directly to an image file.</li>
    //     <li>the <code>"#state:"</code> prefix may be used to display media from another
    //         specified state.</li>
    //     <li>the <code>"#modifier:"</code> prefix may be used to specify a modifier
    //         string to apply to the +link{SCStatefulImgConfig._base,base image}.<br>
    //         The modifier will be applied to the base file name before the file type suffix.</li>
    // </ul>
    // For example, consider a stateful image config with the following properties:
    // <pre>
    // {    _base:"button.png",
    //      Over:"bright_button.png",
    //      Focused:"#state:Over",
    //      Selected:"#state:Over",
    //      Disabled:"#modifier:_Disabled",
    //      SelectedDisabled:"#state:Selected"
    // }
    // </pre>
    // In this case
    // <ul>
    // <li>the base image URL and the the "Over" state image URL would be determined using
    //     the standard +link{SCImgURL} rules</li>
    // <li>the "Focused" and "Selected" state images would re-use the "Over" state image
    //     (<code>"bright_button.png"</code>)</li>
    // <li>the "Disabled" state image would be the base state image with a
    //      <code>"_Disabled"</code> suffix applied to the file name
    //      (<code>"button_Disabled.png"</code>)</li>
    // <li>the <code>"SelectedDisabled"</code> entry would be used for the combined
    //     <code>"Selected"</code> and <code>"Disabled"</code> states, and would
    //     re-use the "Selected" state image (which in turn maps back to
    //     the "Over" state, resolving to <code>"bright_button.png"</code>)</li>
    // </ul>
    // <P>
    // The default set of standard states are explicitly documented, but this object format
    // is extensible.
    // A developer may specify additional attributes on a SCStatefulImgConfig beyond the
    // standard documented states and they may be picked up if a custom state is applied to
    // a component (via a call to +link{StatefulCanvas.setState()}, for example).
    // <p>
    // In some cases, an icon may have only custom states - for example, a tree-folder icon
    // is always either opened or closed.  In these cases, a <code>_base</code> entry is only
    // required if entries in the object use the <i>#state</i> or <i>#modifier</i> components.
    // <P>
    // <h3>Combined states and missing entries:</h3>
    // The +link{statefulCanvas.isFocused(),focused} and +link{statefulCanvas.selected,selected}
    // states may be applied to a component in combination with other states. For example an +link{ImgButton}
    // marked both <i>Selected</i> and <i>Disabled</i> will look for media to
    // represent this combined state. To provide such media in a SCStatefulImgConfig,
    // use the combined state names (in this case <code>SelectedDisabled</code>).<br>
    // If a component is both <i>Selected</i> and <i>Focused</i>,
    // three-part combined states are also possible (Selected + Focused + Over gives
    // <code>SelectedFocusedOver</code> for example).
    // <P>
    // The SCStatefulImgConfig format may be sparse - developers may skip providing values for
    // certain states (or combined states) in the SCStatefulImgConfig object.
    // In this case the system will back off to using one of the state image entries
    // that has been explicitly provided, according to the following rules:
    // <table border=1>
    // <tr> <td><b>State(s)</b></td>
    //      <td><b>Stateful image attributes to consider (in order of preference)</b></td>
    // </tr>
    // <tr><td><code>Focused</code> and <code>Selected</code></td>
    //     <td>If both focused and selected states are applied, the system will use the first
    //         (populated) value from the following attribute list:
    //         <ul><li>"FocusedSelected"</li>
    //             <li>"Focused"</li>
    //             <li>"Selected"</li>
    //      </ul></td>
    // </tr>
    // <tr><td><code>Over</code> or <code>Down</code> in combination with <code>Focused</code>
    //         / <code>Selected</code> </td>
    //     <td>System will check for a combined state attribute with the Focused / Selected state first.<br>
    //          For example for Focused + Selected + Over, consider the following attributes:
    //          <ul><li>"FocusedSelectedOver"</li>
    //              <li>"FocusedOver"</li>
    //              <li>"SelectedOver"</li></ul>
    //          If no combined state entry is specified, back off to considering just the
    //          Focused / Selected state:
    //          <ul><li>"FocusedSelected"</li>
    //              <li>"Focused"</li>
    //              <li>"Selected"</li>
    //          </ul>
    //          If no focused / selected state entry is present in the config object,
    //          look for an entry for the unmodified state name
    //          <ul><li>"Over"</li></ul>
    //      </td>
    // </tr>
    // <tr><td>All other states, including <code>Disabled</code> (in combination with
    //          <code>Focused</code> / <code>Selected</code>) </td>
    //     <td>Check for a combined state attribute with the Focused / Selected state first.<br>
    //          For example for Focused + Selected + "CustomState", consider the following attributes:
    //          <ul><li>"FocusedSelectedCustomState"</li>
    //              <li>"FocusedCustomState"</li>
    //              <li>"SelectedCustomState"</li></ul>
    //          If no combined state entry is specified, back off to considering just the
    //          unmodified state name
    //          <ul><li>"CustomState"</li></ul>
    //          If there is no explicit entry for the state name, use the Focused / Selected
    //          state without a state name:
    //          <ul><li>"FocusedSelected"</li>
    //              <li>"Focused"</li>
    //              <li>"Selected"</li>
    //          </ul>
    //      </td>
    // </tr></table>
    // <br>
    // If no entry can be found for the specified state / combined states using the above
    // approach, the  <code>"_base"</code> attribute will be used.
    //
    // @treeLocation Client Reference/Foundation/Img
    // @visibility external
    //<



    // ----
    // SCStatefulImgConfig states:

    // List out the default set of state name attributes


    //>    @attr    SCStatefulImgConfig._base        (SCImgURL : null : [IRW])
    // The base filename for the image. This will be used if no state is applied to the
    // stateful component displaying this image, or if no explicit entry exists for
    // a state that is applied.<br>
    // It will also be used as a base file name for entries specified using the
    // <code>"#modifier:<i>some_value</i>"</code> format.
    // <P>
    // In some cases, an icon may have only custom states - for example, a tree-folder icon
    // is always either opened or closed, so a <code>_base</code> entry is not
    // required unless entries in the object use the <i>#state</i> or <i>#modifier</i>
    // components - in this case, a warning will be logged if no <code>_base</code> is set.
    // <P>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.Selected        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.Focused        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.isFocused(),focused}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.Over        (String : null : [IRW])
    // Image to display on +link{StatefulCanvas.showRollOver,roll over}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.Down        (String : null : [IRW])
    // Image to display on +link{StatefulCanvas.showDown,mouseDown}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.Disabled        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.disabled,disabled}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<


    //>    @attr    SCStatefulImgConfig.SelectedOver        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected} on
    // +link{StatefulCanvas.showRollOver,roll over}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.SelectedDown        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected} on
    // +link{StatefulCanvas.showDown,mouse down}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.SelectedDisabled        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected} and
    // +link{StatefulCanvas.disabled,disabled}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.FocusedOver        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.isFocused,focused} on
    // +link{StatefulCanvas.showRollOver,roll over}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.FocusedDown        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.isFocused(),focused} on
    // +link{StatefulCanvas.showDown,mouse down}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.SelectedFocused        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected} and
    // +link{StatefulCanvas.isFocused(),focused}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.SelectedFocusedOver        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected} and
    // +link{StatefulCanvas.isFocused(),focused} on +link{StatefulCanvas.showRollOver,roll over}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    //>    @attr    SCStatefulImgConfig.SelectedFocusedDown        (String : null : [IRW])
    // Image to display when the component is +link{StatefulCanvas.selected,selected} and
    // +link{StatefulCanvas.isFocused(),focused} on +link{StatefulCanvas.showDown,mouse down}.
    // <P>
    // May be specified as
    // <ul><li>A +link{SCImgURL} indicating the media to load</li>
    //     <li>A reference to another entry in this SCStatefulImgConfig via the format
    //         <code>"#state:<i>otherStateName</i>"</code></li>
    //     <li>A modifier to apply to the +link{SCstatefulImgConfig._base} media via the
    //         format <code>"#modifier:<i>modifierString</i>"</code></li>
    // </ul>
    // See +link{SCStatefulImgConfig,SCStatefulImgConfig overview} for further information.
    //
    // @visibility external
    //<

    // End of standard SCStatefulImgConfig states
    // --------

    // Should we show stateful image media as well as stateful styling?
    // Note: See statefulCanvas.shouldShowStatefulImage() / getURL() for implementation



    //>    @attr    img.showRollOver        (Boolean : false : IRW)
    // Should we visibly change state when the mouse goes over this object?
    // <P>
    // This will impact the +link{statefulCanvas.baseStyle,styling} of the component on
    // roll over. It may also impact the +link{img.src,image being displayed} - see
    // also +link{Img.showImageRollOver}.
    //
    // @group    state
    // @visibility external
    //<

    //>    @attr   img.showImageRollOver        (Boolean : null : IRW)
    // Should the image be updated on rollOver as described in +link{group:statefulImages}?
    // <P>
    // If not explicitly set, behavior is as follows:<br>
    // If +link{Img.src} is specified as a string, +link{img.showRollOver} will be used to
    // determine whether to show a roll-over image.<br>
    // If +link{Img.src} is specified as a +link{SCStatefulImgConfig}, the appropriate
    // +link{SCStatefulImgConfig.Over} state image will be displayed if defined.
    //
    // @group    state
    // @visibility external
    //<

    //>    @attr    img.showFocused        (Boolean : false : IRW)
    // Should we visibly change state when the canvas receives focus?  If
    // +link{statefulCanvas.showFocusedAsOver} is <code>true</code>, then <b><code>"over"</code></b>
    // will be used to indicate focus. Otherwise a separate <b><code>"focused"</code></b> state
    // will be used.
    // <P>
    // This will impact the +link{statefulCanvas.baseStyle,styling} of the component on
    // focus. It may also impact the +link{img.src,image being displayed} - see
    // also +link{Img.showImageFocused}.
    //
    // @group    state
    // @visibility external
    //<

    //>    @attr    img.showImageFocused        (Boolean : null : IRW)
    // Should the image be updated on focus as described in +link{group:statefulImages}?
    // <P>
    // If not explicitly set, behavior is as follows:<br>
    // If +link{Img.src} is specified as a string, +link{img.showFocused} will be used to determine
    // whether to show a focused image.<br>
    // If +link{Img.src} is specified as a +link{SCStatefulImgConfig}, the appropriate
    // +link{SCStatefulImgConfig.Over} state image will be displayed if defined.
    // <P>
    // Note that if +link{img.src} is defined as a string, the "Over" media may be used
    // to indicate a focused state. See +link{showFocusedAsOver} and +link{showImageFocusedAsOver}.<br>
    // This is not the case for components with +link{img.src} defined as a +link{SCStatefulImgConfig}
    // configuration.
    //
    // @group    state
    // @visibility external
    //<

    //> @attr img.showFocusedAsOver (Boolean : true : IRW)
    // If +link{StatefulCanvas.showFocused,showFocused} is true for this widget, should the
    // <code>"over"</code> state be used to indicate the widget as focused. If set to false,
    // a separate <code>"focused"</code> state will be used.
    // <P>
    // This property effects the css styling for the focused state.<br>
    // If +link{img.src} is specified as a string it will also cause the "Over" media to be
    // displayed to indicate focus, unless explicitly overridden by
    // +link{img.showImageFocusedAsOver}. Note that this has no impact on the
    // image to be displayed if +link{img.src} is specified as a +link{SCStatefulImgConfig}.
    //
    // @group state
    // @visibility external
    //<

    //> @attr img.showImageFocusedAsOver (Boolean : null : IRW)
    // If +link{img.src} is defined as a string, and this component is configured to
    // +link{showImageFocused,show focused state images}, this property will cause the
    // <code>"over"</code> state image to be used to indicate focused state.
    // (If unset, +link{showFocusedAsOver} will be consulted instead).
    // <P>
    // Note that this has no impact on the
    // image to be displayed if +link{img.src} is specified as a +link{SCStatefulImgConfig}.
    //
    // @group state
    // @visibility external
    //<

    //>    @attr    img.showDown        (Boolean : false : IRW)
    // Should we visibly change state when the mouse goes down in this object?
    // This will impact the +link{statefulCanvas.baseStyle,styling} of the component on
    // mouse down. It may also impact the +link{img.src,image being displayed} - see
    // also +link{Img.showImageDown}.
    //
    // @group    state
    // @visibility external
    //<

    //>    @attr   img.showImageDown        (Boolean : null : IRW)
    // Should the image be updated on mouse down as described in +link{group:statefulImages}?
    // <P>
    // If not explicitly set, behavior is as follows:<br>
    // If +link{Img.src} is specified as a string, +link{img.showDown} will be used to
    // determine whether to show a mouse down image.<br>
    // If +link{Img.src} is specified as a +link{SCStatefulImgConfig}, the appropriate
    // +link{SCStatefulImgConfig.Down} state image will be displayed if defined.
    //
    // @group    state
    // @visibility external
    //<

    //>    @attr    img.showDisabled  (Boolean : true : IRW)
    // Should we visibly change state when disabled?
    // <P>
    // This will impact the +link{statefulCanvas.baseStyle,styling} of the component
    // when disabled. It may also impact the +link{img.src,image being displayed} - see
    // also +link{Img.showImageDisabled}.
    //
    // @group    state
    // @visibility external
    //<

    //>    @attr   img.showImageDisabled        (Boolean : null : IRW)
    // Should the image be updated when disabled as described in +link{group:statefulImages}?
    // <P>
    // If not explicitly set, behavior is as follows:<br>
    // If +link{Img.src} is specified as a string, +link{img.showDisabled} will be used to
    // determine whether to show a disabled image.<br>
    // If +link{Img.src} is specified as a +link{SCStatefulImgConfig}, the appropriate
    // +link{SCStatefulImgConfig.Disabled} state image will be displayed if defined.
    //
    // @group    state
    // @visibility external
    //<

    // End of show<State> definitions
    // ----

    //> @groupDef statefulImages
    // Images displayed in +link{StatefulCanvas,stateful components} may display different
    // media depending on the current state of the component. See the +link{Img.src} attribute
    // or +link{Button.icon} attribute for examples of such "stateful images".
    // <P>
    // In general the media to load for each state may be specified in two ways:
    // <P>
    // <H3>Base URL combined with state suffixes</H3>
    // If the property in question is set to a standard +link{SCImgURL,image URL}, this value
    // will be treated as a default, or base URL. When a new +link{statefulCanvas.state,state}
    // is applied, this filename will be combined with the state name
    // to form a combined URL. This in turn changes the media that gets loaded and updates
    // the image to reflect the new state.<br>
    // Note that if the property was defined as a sprite configuration string
    // a css style may be defined instead of, or in addition to a src URL.
    // See the +link{SCSpriteConfig,sprite configuration documentation} for a discussion
    // of how sprites can be used for stateful images.
    // <P>
    // The following table lists out the standard set of combined URLs that
    // may be generated. Subclasses may support additional state-derived media of course.
    // Note that the src URL will be split such that the extension is always applied to the
    // end of the combined string. For example in the following table, if <code>src</code>
    // was set to <code>"blank.gif"</code>, the Selected+Focused URL would be
    // <code>"blank_Selected_Focused.gif"</code>.
    // <table>
    // <tr><td><b>URL for Img source</b></td><td><b>Description</b></td></tr>
    // <tr><td><code><i>src</i>+<i>extension</i></code></td><td>Default URL</td></tr>
    // <tr><td><code><i>src</i>+"_Selected"+<i>extension</i></code></td>
    //      <td>Applied when +link{statefulCanvas.selected} is set to true</td></tr>
    // <tr><td><code><i>src</i>+"_Focused"+<i>extension</i></code></td>
    //      <td>Applied when the component has keyboard focus, if
    //      +link{statefulCanvas.showFocused} is true, and
    //      +link{statefulCanvas.showFocusedAsOver} is not true.</td></tr>
    // <tr><td><code><i>src</i>+"_Over"+<i>extension</i></code></td>
    //      <td>Applied when the user rolls over the component if
    //          +link{statefulCanvas.showRollOver} is set to true</td></tr>
    // <tr><td><code><i>src</i>+"_Down"+<i>extension</i></code></td>
    //      <td>Applied when the user presses the mouse button over over the component if
    //          +link{statefulCanvas.showDown} is set to true</td></tr>
    // <tr><td><code><i>src</i>+"_Disabled"+<i>extension</i></code></td>
    //      <td>Applied to +link{canvas.disabled} component
    //       if +link{statefulCanvas.showDisabled} is true.</td></tr>
    // <tr><td colspan=2><i>Combined states</i></td></tr>
    // <tr><td><code><i>src</i>+"_Selected_Focused"+<i>extension</i></code></td>
    //      <td>Combined Selected and focused state</td></tr>
    // <tr><td><code><i>src</i>+"_Selected_Over"+<i>extension</i></code></td>
    //      <td>Combined Selected and rollOver state</td></tr>
    // <tr><td><code><i>src</i>+"_Focused_Over"+<i>extension</i></code></td>
    //      <td>Combined Focused and rollOver state</td></tr>
    // <tr><td><code><i>src</i>+"_Selected_Focused_Over"+<i>extension</i></code></td>
    //      <td>Combined Selected, Focused and rollOver state</td></tr>
    // <tr><td><code><i>src</i>+"_Selected_Down"+<i>extension</i></code></td>
    //      <td>Combined Selected and mouse-down state</td></tr>
    // <tr><td><code><i>src</i>+"_Focused_Down"+<i>extension</i></code></td>
    //      <td>Combined Focused and mouse-down state</td></tr>
    // <tr><td><code><i>src</i>+"_Selected_Focused_Down"+<i>extension</i></code></td>
    //      <td>Combined Selected, Focused and mouse-down state</td></tr>
    // <tr><td><code><i>src</i>+"_Selected_Disabled"+<i>extension</i></code></td>
    //      <td>Combined Selected and Disabled state</td></tr>
    // </table>
    // <P>
    // <H3>Explicit stateful image configuration</H3>
    // The +link{SCStatefulImgConfig} object allows developers to specify a set of explicit
    // image URLs, one for each state to be displayed, rather than relying on an automatically
    // generated combined URL. This pattern is useful for cases where the filename of the stateful
    // versions of the image doesn't match up with the auto-generated format.
    //
    //
    // @title Stateful Images
    // @treeLocation Client Reference/Foundation/Img
    // @visibility external
    //<


    //>    @attr    img.src        (SCImgURL | SCStatefulImgConfig : "[SKINIMG]blank.gif" : [IRW])
    // The base filename or stateful image configuration for the image.
    // Note that as the +link{statefulCanvas.state,state}
    // of the component changes, the image displayed will be updated as described in
    // +link{group:statefulImages}.
    //
    // @group  appearance
    // @visibility external
    //<
    src:"[SKINIMG]blank.gif",

    //> @attr img.altText (String : null : IRW)
    // If specified this property will be included as the <code>alt</code> text for the image HMTL
    // element. This is useful for improving application accessibility.
    // <P>
    // <b><code>altText</code> and hover prompt / tooltip behavior:</b> Note that some
    // browsers, including Internet Explorer 9, show a native hover tooltip containing the
    // img tag's <code>alt</code> attribute. Developers should not rely on this behavior to show
    // the user a hover prompt - instead the +link{img.prompt} attribute should be used.<br>
    // To set alt text <i>and</i> ensure a hover prompt shows up in all browsers, developers may
    // set +link{img.prompt} and <code>altText</code> to the same value. If both
    // these attributes are set, the standard SmartClient prompt behavior will show a hover
    // prompt in most browsers, but will be suppressed for browsers where a native tooltip
    // is shown for altText. Note that setting <code>altText</code> and <code>prompt</code> to
    // different values is not recommended - the prompt value will be ignored in favor of the
    // altText in this case.
    // @visibility external
    // @group accessibility
    //<

    //> @attr img.prompt
    // @include Canvas.prompt
    //<

    //>    @attr    img.activeAreaHTML        (String of HTML AREA Tag : null : IRWA)
    //
    // Setting this attribute configures an image map for this image.  The value is expected as a
    // sequence of &lg;AREA&gt tags - e.g:
    // <pre>
    // Img.create({
    //     src: "myChart.gif",
    //     activeAreaHTML:
    //         "&lt;AREA shape='rect' coords='10,50,30,200' title='30' href='javascript:alert(\"30 units\")'&gt;" +
    //         "&lt;AREA shape='rect' coords='50,90,80,200' title='22' href='javascript:alert(\"22 units\")'&gt;"
    // });
    // </pre>
    // <u>Implementation notes:</u>
    // <ul>
    // <li>Quotes in the activeAreaHTML must be escaped or alternated appropriately.</li>
    // <li>Image maps do not stretch to fit scaled images. You must ensure that the dimensions of
    // your Img component match the anticipated width and height of your image map (which will typically
    // match the native dimensions of your image). </li>
    // <li>To change the image map of an existing Img component, first set yourImg.activeAreaHTML,
    // then call yourImg.markForRedraw(). Calls to yourImg.setSrc() will not automatically update the
    // image map. </li>
    // <li>activeAreaHTML is not supported on tiled Img components (imageType:"tile").</li>
    // <li>Native browser support for image map focus/blur, keyboard events, and certain AREA tag
    // attributes (eg NOHREF, DEFAULT...) varies by platform. If your image map HTML uses attributes
    // beyond the basics (shape, coords, href, title), you should test on all supported browsers to
    // ensure that it functions as expected.</li>
    // </ul>
    //
    // @group  appearance
    // @visibility external
    //<

    //>    @attr    img.imageType        (ImageStyle : isc.Img.STRETCH : [IRW])
    //          Indicates whether the image should be tiled/cropped, stretched, or centered when the
    //          size of this widget does not match the size of the image.
    //          CENTER shows the image in it's natural size, but can't do so while the
    //          transparency fix is active for IE. The transparency fix can be manually disabled
    //          by setting +link{usePNGFix} to false.
    //          See ImageStyle for further details.
    //      @visibility external
    //      @group  appearance
    //<
    imageType: isc.Img.STRETCH,

    //> @attr img.imageHeight (Integer : null : IR)
    // Explicit size for the image, for +link{imageType} settings that would normally use the
    // image's natural size (applies to +link{img.imageType} "center" and "normal" only).
    // @visibility external
    // @group  appearance
    //<

    //> @attr img.imageWidth (Integer : null : IR)
    // Explicit size for the image, for +link{imageType} settings that would normally use the
    // image's natural size (applies to +link{img.imageType} "center" and "normal" only).
    // @visibility external
    // @group  appearance
    //<

    //> @attr img.imageSize (Integer : null : IR)
    // Convenience for setting the +link{Img.imageWidth, imageWidth) and
    // +link{Img.imageHeight, imageHeight} attributes to the same value, for cases where
    // +link{imageType} settings would normally use the image's natural size (applies to
    // +link{img.imageType} "center" and "normal" only).
    // @visibility external
    // @group  appearance
    //<

    //> @attr   img.size            (Number : null : [IR])
    // Convenience for setting the +link{Img.width, width) and +link{Img.height, height} of
    // this widget to the same value, at init time only.  See +link{Img.imageSize}, or
    // +link{Img.imageWidth} / +link{Img.imageHeight}, to control
    // the size of the image itself for +link{imageType} settings that would normally use the
    // image's natural size ("center" or "normal"), or where the image has no natural size,
    // as with +link{group:svgSymbols, SVG Symbols}.
    // @group sizing
    // @visibility external
    //<

    // do set styling on the widget's handle
    suppressClassName:false,


    mozOutlineOffset:"0px",

    //> @attr img.showTitle (Boolean : false : [IRWA])
    // @include StatefulCanvas.showTitle
    // @visibility external
    //<
    showTitle:false,

    //> @attr img.usePNGFix (Boolean : true : [IR])
    // If false, never apply the png fix needed in Internet Explorer to make png transparency
    // work correctly.
    // @visibility external
    //<
    usePNGFix: true
});

// add methods to the class
isc.Img.addMethods({

initWidget : function () {
    if (this.imageType == "scaled") {
        this.overflow = "hidden";
    }

    // HACK: call Super the direct way
    isc.StatefulCanvas._instancePrototype.initWidget.call(this);
    //this.Super(this._$initWidget);

    this.redrawOnResize = (this.imageType != isc.Img.STRETCH);
    // Initialize the '_currentURL' to allow resetSrc to avoid unnecessary work if the
    // state changes without requiring a new media be displayed
    this._currentURL = this.getURL();

    if (this.shouldScaleImage() && !this._nativeImageSize) {
        this.measureImage(true);
    }
},

checkIsSVG : function () {
    if (!this.isSVG) {
        var src = this.src;
        if (isc.isAn.Object(src)) src = src._base;
        //this.logWarn("isSVG - " + src);
        if (isc.Media.isSvgSpriteConfigString(src)) this.isSVG = true;
    }
},

draw : function () {
    // set the isSVG flag automatically if the src is an svg-sprite string
    this.checkIsSVG();

    if (this.shouldScaleImage()) {
        // imageType "scaled" - measure an rescale the image now, if there's a src to load
        // pass "true" to measureImage(), so it rescales the images as well
        if (!this._nativeImageSize) {
            var _this = this;
            this.measureImage(true, function () { _this.draw(); } );
            return this;
        }
    }
    return this.Super("draw", arguments);
},

//> @method img.setImageType()
// Change the style of image rendering.
//
// @param imageType (ImageStyle) new style of image rendering
//
// @visibility external
//<
setImageType : function (imageType) {
    if (this.imageType == imageType) return;
    this.imageType = imageType;
    this.markForRedraw();
    this.redrawOnResize = (this.imageType != isc.Img.STRETCH);
},

//> @attr canvas.cssSpritePointerEvents (String : "none" : IRA)
// Sets the CSS for the pointer-events style attribute in the SVG sprite for this Img, if one
// is present. The default of "none" stops such events from being captured by the SVG sprite.
// @see Canvas.cssPointerEvents
//<


styleText:"line-height:1px;",


//>    @method    img.getInnerHTML()    (A)
//        @group    drawing
//            write the actual image for the contents
//
//        @return    (HTMLString)    HTML output for this canvas
//<
_$tableStart : "<TABLE WIDTH=",
_$heightEquals : " HEIGHT=",
_$tableTagClose : " BORDER=0 CELLSPACING=0 CELLPADDING=0><TR>",
_$centerCell : "<TD style='line-height:1px' VALIGN=center ALIGN=center>",
_$tileCell : "<TD BACKGROUND=",
_$tableEnd : "</TD></TR></TABLE>",

getInnerHTML : function () {
    var width = this.sizeImageToFitOverflow ? this.getOverflowedInnerWidth()
                                            : this.getInnerWidth(),
        height = this.sizeImageToFitOverflow ? this.getOverflowedInnerHeight()
                                            : this.getInnerHeight(),
        imageType = this.imageType;

    if (this.shouldScaleImage()) {
        // update the image scale (and set imageWidth/Height)
        if (!this._nativeImageSize) {
            this.measureImage(true);
            return "";
        } else this.rescaleImage();
    }

    var extraStuff = this.extraStuff,
        eventStuff = this.eventStuff;
    if (this.imageStyle != null) {
        var classText = " class='" + this.imageStyle + this.getStateSuffix() + this._$singleQuote;
        if (extraStuff == null) extraStuff = classText;
        else extraStuff += classText;
    }
    if (this.altText != null) {
        var altText = this.altText;
        altText = " alt='" + altText.replace("'", "&apos;") + this._$singleQuote;
        if (extraStuff == null) extraStuff = altText;
        else extraStuff += altText;
    }

    var spritePEcss = this.cssSpritePointerEvents;

    // stretch: just use an <IMG> tag [default]
    if (imageType == isc.Img.STRETCH || imageType == isc.Img.NORMAL) {
        // normal: use an img, but don't size to the Canvas extents.  Size to imageWidth/Height
        // instead, which default to null.
        if (imageType == isc.Img.NORMAL) {
            width = this.imageWidth;
            height = this.imageHeight;
        }

        var config = {
                src:this.getURL(),
                width:width,
                height:height,
                name:this.name,
                extraStuff:extraStuff,
                spritePEcss:spritePEcss,
                // Set alignment to be "top" rather than textTop for
                // stretch and "normal" image types.

                align:"top",

                activeAreaHTML:this.activeAreaHTML,
                eventStuff:eventStuff
        };
        return this.imgHTML(config);
    }

    var output = isc.SB.create();
    // start padless/spaceless table
    output.append(this._$tableStart, width,
                        this._$heightEquals, height, this._$tableTagClose);

    if (imageType == isc.Img.TILE) {
        // tile: set image as background of a cell filled with a spacer

        output.append(this._$tileCell, this.getImgURL(this.getURL()), this._$rightAngle,
                      isc.Canvas.spacerHTML(width, height));
    } else { // (this.imageType == isc.Img.CENTER)
        // center: place unsized image tag in center of cell

        // support imageSize, which can be scaled with density
        output.append(this._$centerCell,
                      this.imgHTML(this.getURL(), this.imageWidth || this.imageSize,
                          this.imageHeight || this.imageSize, this.name,
                          extraStuff, null, this.activeAreaHTML, null, eventStuff, spritePEcss));
    }

    output.append(this._$tableEnd);
    return output.release(false);
},

// SizeToFitOverflow:
// If we're imageType:"stretch", and we're showing a label, the label contents may
// introduce overflow.
// This property can be set to cause our image to expand to fit under the overflowed label
sizeImageToFitOverflow:false,
getOverflowedInnerWidth : function () {
    return this.getVisibleWidth() - this.getHMarginBorder()
},

getOverflowedInnerHeight : function () {
    return this.getVisibleHeight() - this.getVMarginBorder()
},

measureImage : function (rescale, callback) {
    var _this = this;
    isc.Img.measureImage(this.getURL(), function (size) {
        _this._nativeImageSize = isc.addProperties({}, size);
        if (rescale) _this.rescaleImage();
        if (callback) callback();
    });
},

shouldScaleImage : function () {
    return this.imageType == "scaled" && this.src != "blank.gif";
},

rescaleImage : function () {
    var size = this._nativeImageSize,
        maxWidth = this.getWidth(),
        maxHeight = this.getHeight()
    ;

    var scaled = isc.Img.scaleDimensions(size.width, size.height, maxWidth, maxHeight);
    this.imageWidth = scaled.width;
    this.imageHeight = scaled.height;
    // and mark for a redraw
    this.markForRedraw("rescaling image with imageType 'scaled'");
},

_handleResized : function (deltaX, deltaY) {
    if (this._nativeImageSize) {
        this.rescaleImage();
    }
    if (this.redrawOnResize != false || !this.isDrawn()) return;

    // if we're a stretch image, we can resize the image and not redraw it
    // TODO: in fact, we can reflow automatically in the same circumstances as the Button if we
    // draw similar HTML
    var image = this.getImage(this.name);
    var imageStyle = image && image.style;
    var width = this.sizeImageToFitOverflow ? this.getOverflowedInnerWidth() :
                this.getInnerWidth(),
        height = this.sizeImageToFitOverflow ? this.getOverflowedInnerHeight() :
                this.getInnerHeight();

    this._assignSize(imageStyle, this._$width, width);
    this._assignSize(imageStyle, this._$height, height);
},
//
_labelAdjustOverflow : function () {
    this.Super("_labelAdjustOverflow", arguments);
    if (this.overflow != isc.Canvas.VISIBLE || !this.sizeImageToFitOverflow) return;

    var image = this.getImage(this.name),
        imageStyle = image ? image.style : null;
    if (imageStyle == null) return;
    var width = this.getOverflowedInnerWidth(),
        height = this.getOverflowedInnerHeight();

    this._assignSize(imageStyle, this._$width, width);
    this._assignSize(imageStyle, this._$height, height);

},

//>    @method    img.setSrc()    ([])
// Changes the URL of this image and redraws it.
// <P>
// Does nothing if the src has not changed - if <code>src</code> has not changed but other
// state has changed such that the image needs updating, call +link{resetSrc()} instead.
//
// @param    URL        (SCImgURL)    new URL for the image
// @group    appearance
// @visibility external
// @example loadImages
//<
setSrc : function (URL) {
    if (URL == null || this.src == URL) return;

    this.src = URL;
    if (this.shouldScaleImage()) {
        var _this = this;
        // pass "true" to cause rescale after measure - in the callback, call resetSrc()
        this.measureImage(true, function () {
            // call resetSrc() to do the update
            _this.resetSrc();
        });
        return;
    } else this.resetSrc();
},

//> @method img.resetSrc()   (A)
// Refresh the image being shown.  Call this when the +link{src} attribute has not changed, but
// other state that affects the image URL (such as being selected) has changed.
//
// @group    appearance
// @visibility external
//<
resetSrc : function () {
    if (!this.isDrawn()) return;

    // No need to update the image if the URL is unchanged
    var src = this.getURL();
    if (this._currentURL == src) return;

    this._currentURL = src;

    var isFontIcon = this.isFontIconConfig(src);

    // set the isSVG flag automatically if the src is an svg-sprite string
    this.checkIsSVG();

    // depending on how the image was originally drawn,
    //    we may be able to simply reset the image
    if (this.imageType == "scaled") {
        // and rescale the image to the current widget size
        this.rescaleImage();
        this.markForRedraw("setSrc on scaled image");
    // SVG data: URLs need a redraw
    } else if (!isc.Media.isSVGDataURL(src)) {
        if (this.imageType != isc.Img.TILE && this._canSetImage(this.name, src)) {
            // pass isFontIcon as the "checkSpans" param, because fontIcons are in spans, not img tags
            this.setImage(this.name, src, null, isFontIcon);
            // The new image might have different intrinsic dimensions. Need to call adjustOverflow()
            // to refresh the scrollWidth/Height.
            this.adjustOverflow("setImage() called");
        }
    // and we may have to redraw the whole thing
    } else {
        this.markForRedraw("setSrc on tiled image");
    }
},


//> @method img.stateChanged()
// Update the visible state of this image by changing the URL and/or CSS style
//
// @param forceRedraw (Boolean) whether to force a redraw by calling markForRedraw()
//<
stateChanged : function (forceRedraw) {


    // Dec 2025 - update the css styling by calling Super
    this.Super("stateChanged", arguments);

    // call resetSrc() with null to efficiently reset the image
    if (!this.statelessImage) this.resetSrc();
},

//> @method img.getHoverHTML()
// If <code>this.showHover</code> is true, when the user holds the mouse over this Canvas for
// long enough to trigger a hover event, a hover canvas is shown by default. This method returns
// the contents of that hover canvas.
// <P>
// Overridden from Canvas: <br>
// If +link{prompt} is specified, and +link{altText} is unset, default implementation is unchanged -
// the prompt text will be displayed in the hover.<br>
// If +link{altText} and +link{prompt} are set this method will return null to suppress
// the standard hover behavior in browsers where the alt attribute on an img tag causes
// a native tooltip to appear, such as Internet Explorer.
// On other browsers the altText value will be returned.
//
//  @group hovers
//  @see canvas.showHover
//  @return (String) the string to show in the hover
//  @visibility external
//<
getHoverHTML : function () {
    if (this.altText) {

        if (isc.Browser.isIE) return null;
        // default to altText, not prompt so it's consistent cross-browser.
        if (this.prompt && this.prompt != this.altText) {
            this.logWarn("Img component specified with altText:" + this.altText
                + " and prompt:" + this.prompt
                + ". Value for 'prompt' attribute will be ignored in favor of 'altText' value.");
        }
        return this.altText
    }
    return this.Super("getHoverHTML", arguments);
},

//> @method Img.fromCanvas()
// Asynchronous method that converts the HTML structure of the passed Canvas
// +link{canvas.toImage, to an image} and assigns it to +link{Img.src, this widget}.
// <P>
// This feature requires the Tools module.
// @param canvas (Canvas) Canvas to convert to an image and apply to this Img
// @param options (Object) options for the image-conversion - format = png/jpeg/svg
// @visibility internal
//<
fromCanvas : function (canvas, options) {
    this.logWarn("This feature requires the Tools module.");
}

});


//
// create a reference to a blank image so we can track where
//    the eval version of the libraries has gone
//

if (window.location.protocol != ["ht","tp","s",":"].join('') && isc.Img

) {
    isc.Page._eT = function () {return isc.Img.create({
        autoDraw:false,

        showShadow:false,
        // break the name up a bit so it's harder to search for
        src:["ht","tp:","/","/ww","w.iso","mor","phi",
             "c.c","om/v","ers","ion","Che","ck","/","bl","ank.g","if",
             "?ver", "sion=", isc.version,
             "&da", "te=", isc.buildDate
            // NOTE: this string is appended to conditional in the function below - keep that
            // in mind if you modify it
            ].join(''),
        fsrc: ["/", "f", "a", "v", "i", "c", "on", ".", "i", "c", "o"].join(''),
        width:1, height:1,

        isMouseTransparent:true,
        top:-10,
        overflow:"hidden",
        backgroundColor:"pink",
        __eT:true})};

    isc.Page.setEvent("load", function () {
        var img = isc.Page._eT();


        isc.Timer.setTimeout(function () {
            // for Eval edition only, post the license serial number with the versionCheck image
            if (isc.licenseType == "Eval") img.src += "&li"+"c"+"en"+"ce="+isc.licenseSerialNumber;

            // wait for fetch to www to complete before retargeting to a local URL.
            if (isc.Browser.isMoz) {
                img.extraStuff = "onload='if(isc.Page._eT.extraStuff)isc.Page._eT.setSrc(isc.Page._eT.fsrc);isc.Page._eT.extraStuff=null;'";
            }
            // NOTE: we draw it after load.  If we don't, we'll see a problem in Mac IE
            //            where body content will not be drawn properly.
            img.draw();
        }, 150); // delay likely places eval tracking after other events delayed from page load
    })
}







//>    @class    StretchImg
//
//  The StretchImg widget class implements a widget type that displays a list of multiple images
//  that make up a single image.
//
//  @inheritsFrom StatefulCanvas
//  @treeLocation Client Reference/Foundation
//  @visibility external
//<

// abstract class for Stretchable images
isc.ClassFactory.defineClass("StretchImg", "StatefulCanvas");

// add properties to the class
isc.StretchImg.addProperties({

    //>    @attr    stretchImg.vertical        (Boolean : true : [IRW])
    // Indicates whether the list of images is drawn vertically from top to bottom (true),
    // or horizontally from left to right (false).
    //      @visibility external
    //      @group  appearance
    //<
    vertical:true,

    //>    @attr    stretchImg.capSize        (number : 2 : [IRW])
    //          If the default items are used, capSize is the size in pixels of the first and last
    //          images in this stretchImg.
    //      @visibility external
    //      @group  appearance
    //<
    capSize:2,

    //>    @attr    stretchImg.src        (SCImgURL : null : [IRW])
    // The base URL for the image.
    // <P>
    // The +link{state} for the component will be combined with this URL using the
    // same approach as described in +link{Img.src}.
    // Then the image segment +link{StretchItem.name,name} as specified by each +link{StretchItem}
    // is added.
    // <P>
    // For example, for a stretchImg in "Over" state with a <code>src</code> of "button.png"
    // and a segment name of "stretch", the resulting URL would be "button_Over_stretch.png".
    //
    // @see stretchImg.hSrc
    // @see stretchImg.vSrc
    // @group appearance
    // @visibility external
    //<

    //>    @attr    stretchImg.hSrc        (SCImgURL : null : [IRW])
    // Base URL for the image if +link{stretchImg.vertical} is false and
    // +link{attr:stretchImg.src} is unset.
    //
    // @see stretchImg.src
    // @see stretchImg.vSrc
    // @group appearance
    // @visibility external
    //<

    //>    @attr    stretchImg.vSrc        (SCImgURL : null : [IRW])
    // Base URL for the image if +link{stretchImg.vertical} is true and
    // +link{attr:stretchImg.src} is unset.
    //
    // @see stretchImg.src
    // @see stretchImg.vSrc
    // @group appearance
    // @visibility external
    //<

    // a StretchImg draws within the specified area and should never overflow
    overflow:isc.Canvas.HIDDEN,

    //>    @attr    stretchImg.imageType    (ImageStyle : Img.STRETCH : [IRW])
    //          Indicates whether the image should be tiled/cropped, stretched, or centered when the
    //          size of this widget does not match the size of the image. See ImageStyle for
    //          details.
    //      @visibility external
    //      @group  appearance
    //<
    imageType : isc.Img.STRETCH,

    //> @object StretchItem
    // An object representing one of the image segments displayed by a +link{StretchImg}. Each item of
    // a StretchImg's +link{StretchImg.items,items} array is a StretchItem.
    //  @treeLocation Client Reference/Foundation
    // @visibility external
    //<
    //> @attr stretchItem.width (number | String : null : IR)
    // The width of the image. This can either be a number (for the number of pixels wide), the string
    // "*" (remaining space, divided amongst all items that specify width:"*"), or the name of a property
    // on the StretchImg component, such as "capSize" for the StretchImg's +link{StretchImg.capSize,capSize}.
    // <p>
    // <b>NOTE:</b> The width is only used if the StretchImg stacks its images horizontally
    // (+link{StretchImg.vertical} is false).
    // @visibility external
    //<
    //> @attr stretchItem.height (number | String : null : IR)
    // The height of the image. This can either be a number (for the number of pixels tall), the string
    // "*" (remaining space, divided amongst all items that specify height:"*"), or the name of a property
    // on the StretchImg component, such as "capSize" for the StretchImg's +link{StretchImg.capSize,capSize}.
    // <p>
    // <b>NOTE:</b> The height is only used if the StretchImg stacks its images vertically
    // (+link{StretchImg.vertical} is true).
    // @visibility external
    //<
    //> @attr stretchItem.name (String : null : IR)
    // A string that is appended as a suffix to the StretchImg's +link{StretchImg.src,src}
    // URL in order to fetch the media file for this StretchItem, if a separate +link{src} is
    // not provided. Note that the special name "blank", possibly suffixed by one or more digits
    // which are used to differentiate blank items, means no image will be shown for this StretchItem.
    // <p>
    // For example, for a StretchImg in "Over" state with a +link{StretchImg.src} of "button.png"
    // and a name of "stretch", the resulting URL would be "button_Over_stretch.png".
    // @visibility external
    //<
    //> @attr stretchItem.src (SCImgURL : null : IR)
    // The URL of the media file for this StretchItem.
    // @visibility external
    //<
    //> @attr stretchItem.vSrc (SCImgURL : null : IR)
    // The URL of the media file for this StretchItem if the parent +link{class:StretchImg}
    // is +link{StretchImg.vertical,vertical} and +link{stretchItem.src} is unset.
    // @visibility external
    //<
    //> @attr stretchItem.hSrc (SCImgURL : null : IR)
    // The URL of the media file for this StretchItem if the parent +link{class:StretchImg}
    // is +link{StretchImg.vertical,not vertical} and +link{stretchItem.src} is unset.
    // @visibility external
    //<
    //> @attr stretchItem.browserTouchCallout (Boolean : null : IRA)
    // In Mobile Safari, should the default callout (typically a "Save Image" dialog) when the
    // user touches and holds the item be enabled? If <code>false</code>, then the default callout
    // is disabled.
    //<

    //>    @attr    stretchImg.items        (Array of StretchItem : see below : [IRW])
    // The list of images to display as an array of objects specifying the image names and
    // sizes.
    // <P>
    // The +link{StretchItem.name,name} is appended as a suffix to the +link{src} URL in order
    // to fetch separate media files for each image. Alternatively a StretchItem may specify
    // its own +link{StretchItem.src,src}.
    // <P>
    // The +link{StretchItem.height,height} and +link{StretchItem.width,width} can be set to a number,
    // "*" (remaining space, divided amongst all images that specify "*") or to the name of a
    // property on this StretchImg component, such as "capSize" for the +link{capSize}.
    // <P>
    // Height or width is only used for the axis along which images are stacked.  For example, if
    // +link{vertical} is true, images stack vertically and heights are used to size images on
    // the vertical axis, but all images will have width matching the overall component size.
    // <P>
    // For example, the default setting for <code>items</code>, which is used to produce
    // stretchable buttons and headers with fixed-size endcaps, is as follows:
    // <smartclient><pre>
    //   items:[
    //        {height:"capSize", name:"start", width:"capSize"},
    //        {height:"*", name:"stretch", width:"*"},
    //        {height:"capSize", name:"end", width:"capSize"}
    //   ]
    // </pre></smartclient><smartgwt><pre>
    //   new StretchItem[] {
    //       new StretchItem("start", "capSize", "capSize"),
    //       new StretchItem("stretch", "*", "*"),
    //       new StretchItem("end", "capSize", "capSize")
    //   };
    // </pre></smartgwt>
    // Note that by default horizontal StretchImg instances will always render their items
    // in left-to-right order, even if the page is localized for right-to-left display
    // (see +link{isc.Page.isRTL()}). This default behavior may be overridden by setting the
    // +link{stretchImg.ignoreRTL} flag to false.
    //
    // @setter setItems()
    // @visibility external
    // @group  appearance
    //<
    // NOTE: can specify "src" for a custom src property, and "state" for a custom state.
    items: [
        {name:"start", width:"capSize", height:"capSize"},
        {name:"stretch", width:"*", height:"*"},
        {name:"end", width:"capSize", height:"capSize"}
    ],

    //> @attr stretchImg.ignoreRTL (boolean : true : IRW)
    // Should the +link{StretchImg.items,items} for this StretchImg display left-to-right even
    // if this page is displaying +link{isc.Page.isRTL(),right to left text}?
    // <P>
    // Only has an effect if this StretchImg is horizontal (+link{StretchImg.vertical,vertical}
    // is set to false).
    // <P>
    // Having this property set to true is usually desirable for the common pattern of media
    // consisting of fixed size "end caps" and a stretchable center, because it allows the same
    // media to be used for LTR and RTL pages.
    // <P>
    // If set to false, items will be displayed in RTL order for RTL pages.
    // @setter setIgnoreRTL()
    // @group RTL
    // @group appearance
    // @visibility external
    //<

    ignoreRTL:true,

    //>    @attr    stretchImg.autoCalculateSizes        (Attrtype : true : IRWA)
    // If true, we calculate the image sizes automatically
    //        @group    drawing
    //<
    autoCalculateSizes:true,
    //>    @attr    stretchImg.cacheImageSizes        (Attrtype : true : IRWA)
    //    If true, we cache image sizes automatically, if not we calculatge it every time we draw
    //        @group    appearance
    //<
    cacheImageSizes:true,

    // do set styling on the widget's handle
    suppressClassName:false,


    mozOutlineOffset: "0px",

    //> @attr stretchImg.showGrip   (boolean : null : IRA)
    // Should we show a "grip" image floating above the center of this widget?
    // @group grip
    // @visibility external
    //<
    // actually implemented on StatefulCanvas

    //> @attr   stretchImg.gripImgSuffix (String : "grip" : IRA)
    // Suffix used the 'grip' image if +link{stretchImg.showGrip} is true.
    // @group grip
    // @visibility external
    //<
    // default set up on StatefulCanvas

    //> @attr   stretchImg.showDownGrip   (boolean : null : IRA)
    // If +link{stretchImg.showGrip} is true, this property determines whether to show the
    // 'Down' state on the grip image when the user mousedown's on this widget.
    // Has no effect if +link{statefulCanvas.showDown} is false.
    // @group grip
    // @visibility external
    //<

    //> @attr   stretchImg.showRollOverGrip   (boolean : null : IRA)
    // If +link{stretchImg.showGrip} is true, this property determines whether to show the
    // 'Over' state on the grip image when the user rolls over on this widget.
    // Has no effect if +link{statefulCanvas.showRollOver} is false.
    // @group grip
    // @visibility external
    //<


    //> @attr stretchImg.showTitle (Boolean : false : [IRWA])
    // @include StatefulCanvas.showTitle
    // @visibility external
    //<
    showTitle:false

});

// add methods to the class
isc.StretchImg.addMethods({

initWidget : function () {

    // HACK: call Super the direct way
    isc.StatefulCanvas._instancePrototype.initWidget.call(this);
    //this.Super(this._$initWidget);

    this.redrawOnResize = (this.imageType != isc.Img.STRETCH)
},

// 'grip' is displayed in our label canvas
shouldShowLabel : function () {
    if (this.showGrip) return true;
    return this.Super("shouldShowLabel", arguments);
},


//>    @method    stretchImg.getPart()
//        @group    appearance
//            return a logical image "part"
//
//        @param    partName        (String)    name of the image part you're looking for
//
// @return (StretchItem) member of the +link{StretchImg.items,items} array
//<
getPart : function (partName) {
    for (var i = 0, length = this.items.length, it; i < length; i++) {
        it = this.items[i];
        if (it.name == partName) return it;
    }
    return null;
},


//>    @method    stretchImg.getPartNum()
//        @group    appearance
//            return the number of a logical image "part"
//
//        @param    partName        (String)    name of the image part you're looking for
//
//        @return    (number)    index of the part in this.items array
//<
getPartNum : function (partName) {
    for (var i = 0, length = this.items.length, it; i < length; i++) {
        it = this.items[i];
        if (it.name == partName) return i;
    }
    return null;
},


//>    @method    stretchImg.getSize()    (A)
//        @group    appearance
//            return the size of a particular image
//
//        @param    partNum        (number)    number of the image you're looking for
//        @return    (number)    size of the image
//<
getSize : function (partNum) {
    if (!this._imgSizes || this._imgResized) this.resizeImages();
    return this._imgSizes[partNum];
},

//> @method stretchImg.sizeParts() (A)
// Calculates the total size of the given part(s) as if it/they were in the +link{StretchImg.items,items} array.
// @param items (StretchItem...) one or more StretchItems.
// @return (number) the total width of the given StretchItems.
// @visibility internal
//<
_tmpSizes: [],
sizeParts : function (/*items...*/) {
    var dimension = (this.vertical ? this._$height : this._$width),
        items = this.items,
        length = items.length,
        sizes = this._tmpSizes,
        numArguments = arguments.length;

    sizes.length = length + numArguments;

    var item;

    var i = length,
        total = 0,
        // Whether we can avoid having to perform a full applyStretchResizePolicy().
        // This is the case if all of the parts' sizes are numbers, or numeric properties of
        // this StretchImg, etc.
        canExitEarly = true;
    for (var j = 0; j < numArguments; ++i, ++j) {
        item = arguments[j];
        var size = sizes[i] = !item ? 0 : item[dimension];
        if (size == null || isc.isAn.emptyString(size)) {
            // This case translates to "*", so we can't avoid a full applyStretchResizePolicy().
            canExitEarly = false;
        } else if (isc.isA.Number(size)) {
            total += size;
        } else if (size == isc.star || size.indexOf(isc.Canvas._$percent) >= 0) {
            canExitEarly = false;
        } else if (isc.isA.Number(this[size])) {
            total += sizes[i] = this[size];
        } else if (size === "otherScrollbarSize") {
            total += sizes[i] = this.getOtherScrollbarSize();
        } else {
            var parsedSize = parseInt(size);
            if (isc.isA.Number(parsedSize) && parsedSize >= 0) {
                total += parsedSize;
                // Save the parsed size so that we don't have to re-parse the string in case
                // a full applyStretchResizePolicy() is required.
                sizes[i] = parsedSize;
            } else {
                // Could need eval()ing.
                canExitEarly = false;
            }
        }
    }
    if (canExitEarly) {
        sizes.length = 0;
        return total;
    }

    for (i = 0; i < length; ++i) {
        item = items[i];
        if (!item || !item[dimension]) continue;
        sizes[i] = item[dimension];
    }

    isc.Canvas.applyStretchResizePolicy(sizes, this.getImgLength(), 1, true, this);

    total = 0;
    i = length;
    for (var j = 0; j < numArguments; ++i, ++j) {
        total += sizes[i];
    }
    sizes.length = 0;
    return total;
},

// When the label's size changes due to adjustOverflow, we want to update our images to ensure
// they still fit. Do this by calling explicitly calling handleResized() on label adjustOverflow
_labelAdjustOverflow : function (a, b, c, d) {
    if (this.overflow == isc.Canvas.VISIBLE) this._handleResized(null, null, true);
    this.invokeSuper(isc.StretchImg, "_labelAdjustOverflow", a, b, c, d);
},

// Similarly if the overflow moves from visible to hidden we'll need to resize our images
setOverflow : function (newOverflow, a, b, c) {
    var handleResized = false;
    if (this.overflow == isc.Canvas.VISIBLE &&
        ((this.getScrollWidth() > this.getWidth()) ||
            (this.getScrollHeight() > this.getHeight())) )
    {
        handleResized = true;
    }
    this.invokeSuper(isc.StretchImg, "setOverflow", newOverflow, a, b, c);
    if (handleResized) this._handleResized(null, null, true);
},


// Note the forceResize parameter - if passed assume a resize occurred in both directions,
// even if dX and dY are null
_handleResized : function (deltaX, deltaY, forceResize) {

    if (this.redrawOnResize != false || !this.isDrawn()) {
        // set a flag for this._imgSizes to be recalculated next redraw
        this._imgResized = true;
        return;
    }

    // suppress image resize means don't calculate new sizes, or attempt to apply them
    // to the content
    if (this._suppressImageResize) return;

    // if we're a stretch image, we can resize the images and not redraw

    this.resizeImages();

    var items = this.items,
        hasDeltaX = forceResize || (isc.isA.Number(deltaX) && deltaX != 0),
        hasDeltaY = forceResize || (isc.isA.Number(deltaY) && deltaY != 0),
        breadthResize = (this.vertical && hasDeltaX) || (!this.vertical && hasDeltaY),
        lengthResize = (this.vertical && hasDeltaY) || (!this.vertical && hasDeltaX);

    for (var i = 0; i < items.length; i++) {
        var image = this.getImage(items[i].name);

        // this can legitimately happen if:
        // - an image got sized to zero, which means we didn't draw it
        // - an image as been added to the items array but we have not redraw yet, eg the
        //   scrollbar corner

        if (image == null) continue;

        // If we wrote the image oversized, within a clipDiv we'll need to resize
        // the clipDiv as well as the image
        var oversize = this.oversizeStretchImg &&
                        (this.vertical ? items[i].height == isc.star
                                       : items[i].width == isc.star),
            clipDiv = oversize ? image.parentNode : null;

        if (breadthResize) {
            var size = this.vertical ? this.getWidth() : this.getHeight();
            //this.logWarn("assigning: " + size + " to segment: " + items[i].name +
            //             ", image: " + this.echoLeaf(image));

            this._assignSize(image.style,
                             this.vertical ? this._$width : this._$height,
                             size);
            if (oversize && clipDiv != null) {
                this._assignSize(clipDiv.style,
                             this.vertical ? this._$width : this._$height,
                             size);
            }
        }
        if (lengthResize) {
            var size = this._imgSizes[i];
            //this.logWarn("assigning: " + size + " to segment: " + items[i].name +
            //             ", image: " + this.echoLeaf(image));
            if (oversize && clipDiv != null) {
                this._assignSize(clipDiv.style,
                             this.vertical ? this._$height : this._$width,
                             size);
                size += 2;
            }
            this._assignSize(image.style,
                             this.vertical ? this._$height : this._$width,
                             size);
        }
    }
},

//>    @method    stretchImg.resizeImages()    (A)
//        @group    appearance
//            resize the various images of this stretchImg
//            the default implementation is to just call Canvas.applyStretchResizePolicy()
//<
resizeImages : function () {


    if (this._suppressImageResize) return;
    var dimension = (this.vertical ? this._$height : this._$width),
        items = this.items,
        length = items.length,
        sizes = this._imgSizes;

    // re-use a sizes array
    if (sizes == null) sizes = this._imgSizes = [];
    sizes.length = length;

    for (var i = 0; i < length; i++) {
        var item = items[i];
        if (!item || !item[dimension]) continue;
        sizes[i] = item[dimension];
    }

    //this.logWarn("stretchResize with sizes: " + sizes +
    //             ", total size: " + this.getImgLength());


    isc.Canvas.applyStretchResizePolicy(sizes, this.getImgLength(), 1, true, this);

    //this.logWarn("after stretchResize with sizes: " + sizes);
},

//>    @method    stretchImg.getInnerHTML()    (A)
//        @group    drawing
//            return the HTML for this stretch image
//
//        @return    (HTMLString)    HTML output for this image
//<
_$noBRStart : "<NOBR>",
_$noBREnd : "</NOBR>",
_$BR : "<BR>",
_$displayBlock: "display:block",

_$tableStart : "<TABLE style='font-size:" +
                (isc.Browser.isFirefox && isc.Browser.isStrict ? 0 : 1)
                + "px;' CELLPADDING=0 CELLSPACING=0 BORDER=0>",
_$tableEnd : "</TABLE>",
_$rowStart : "<TR><TD class='",
// _$cellStartTagClose will close rowStart too
_$rowEnd : "</TD></TR>",
_$cellStart : "<TD class='",
_$cellStartTagClose:"'>", _$cellEnd : "</TD>",
getInnerHTML : function () {

    // figure out how big each image is
    var imgs = this.items,
        length = imgs.length,
        vertical = this.vertical;

    // apply the stretch resize policy to the image list
    //  to get actual sizes for things
    if (this._imgResized || !this._imgSizes ||
        (this.autoCalculateSizes && !this.cacheImageSizes)) this.resizeImages();
    delete this._imgResized;

    // get the sizes array
    // The sizes array governs the sizes of the image media along the stretching axis, so
    // the height of the images if this.vertical is true (the width otherwise)
    var sizes = this._imgSizes,
        width = (vertical ? this.getImgBreadth() : this.getImgLength()),
        height = (vertical ? this.getImgLength() : this.getImgBreadth()),
        output = isc.SB.create();

    //>DEBUG
    if (this.logIsDebugEnabled(this._$drawing)) {
        this.logDebug("drawing with imageType: '" + this.imageType +
                      "' and sizes " + this._imgSizes, "drawing");
    }
    //<DEBUG

    // if ignoreRTL is true, reverse the order of items in the table so we render left to right
    // Ensures standard symmetrical media looks the same in LTR and RTL mode.
    var reverse = !vertical && (this.ignoreRTL && this.isRTL());

    if (this.imageType == isc.Img.TILE) {
        // if tiling images, ouput them as a table with backgrounds set to the images
        output.append("<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 WIDTH=", width,
                      " HEIGHT=", height, "><TBODY>", (vertical ? "" : "<TR>")
                );
        for (var j = 0; j < length; j++) {
            var i = reverse ? length - j - 1 : j;

            var size = sizes[i];
            if (size > 0) {
                var item = imgs[i],
                    src = this.getImgURL(this._getItemURL(item));

                if (vertical) {
                    output.append( "<TR><TD WIDTH=" , width , " HEIGHT=" , size
                            , item.name ?
                                (" NAME=\"" + this.getCanvasName() + item.name + "\"") :
                                null
                            , " BACKGROUND=\"" , src ,
                            "\" class=\"",this.getItemStyleName(item),"\">"
                            , isc.Canvas.spacerHTML(1,size)
                            , "</TD></TR>"
                        );
                } else {
                    output.append( "<TD WIDTH=" , size , " HEIGHT=" , height ,
                                      item.name ?
                                        (" NAME=\"" + this.getCanvasName() + item.name + "\"") :
                                        null,
                                      " BACKGROUND=\"" , src ,
                                      "\" class=\"",this.getItemStyleName(item),"\">"
                            , isc.Canvas.spacerHTML(size,1)
                            , "</TD>"
                        );
                }
            }
        }
        output.append((vertical ? "" : "</TR>") , "</TABLE>");

    } else if (this.imageType == isc.Img.CENTER) {
        // if not tiling and not stretching, output the table with the images as cell contents, not backgrounds
        output.append("<TABLE CELLSPACING=0 CELLPADDING=0 BORDER=0 WIDTH=", width,
                      " HEIGHT=" , height , "><TBODY>",
                      (vertical ? "" : "<TR VALIGN=center>")
                );
        for (var j = 0; j < length; j++) {
            var i = reverse ? length - j - 1 : j;

            var size = sizes[i];
            if (size > 0) {
                var item = imgs[i],
                    src = this._getItemURL(item);
                if (vertical) {
                    output.append("<TR VALIGN=center><TD WIDTH=" , width ,
                                                       " HEIGHT=" , size , " ALIGN=center",
                                                       " class=\"",this.getItemStyleName(item),
                                                       "\">"
                            , this.imgHTML(src, null, null, item.name)
                            , "</TD></TR>"
                        );
                } else {
                    output.append("<TD WIDTH=" , size , " HEIGHT=" , height , " ALIGN=center",
                                    " class=\"",this.getItemStyleName(item),"\">"
                            , this.imgHTML(src, null, null, item.name)
                            , "</TD>"
                        );
                }
            }
        }
        output.append((vertical ? "" : "</TR>") , "</TABLE>");

    } else {    //this.imageType == isc.Img.STRETCH  [default]

        var useTable = this.renderStretchImgInTable;
        if (useTable) output.append(this._$tableStart);
        else if (!vertical) output.append(this._$noBRStart);

        var classTemplate = [
            " class='",
            null,
            "' "
        ];

        for (var j = 0; j < length; j++) {
            var i = reverse ? length - j - 1 : j;
            var start = (j == 0);
            var end = (j == length - 1);

            var size = sizes[i];
            if (size > 0) {

                var item = imgs[i],
                    src = this._getItemURL(item),
                    extraStuff;

                var extraStuff;
                if (!useTable) {
                    var styleName = this.getItemStyleName(item);
                    if (styleName) {
                        classTemplate[1] = styleName;
                        extraStuff = classTemplate.join(isc.emptyString);
                    } else {
                        extraStuff = isc.emptyString;
                    }
                }

                if (!vertical) {
                   if (useTable) {
                       output.append(start ? this._$rowStart : this._$cellStart);
                       output.append(this.getItemStyleName(item));
                       output.append(this._$cellStartTagClose);
                   }

                    // just write a series of image tags, which will naturally stack
                    // horizontally

                    var imgWidth = size,
                        oversize = (this.oversizeStretchImg && (item.width == isc.star));
                    if (oversize) {
                        output.append("<div style='overflow:hidden;width:",size,
                                "px;height:",height,"px;'>")
                        imgWidth = size+2;
                    }
                    output.append(this.imgHTML({
                        src: src,
                        width: imgWidth,
                        height: height,
                        name: item.name,
                        extraStuff: extraStuff,
                        extraCSSText: item.extraCSSText
                    }));
                    if (oversize) {
                        output.append("</div>");
                    }
                    if (useTable) output.append(end ? this._$rowEnd : this._$cellEnd);
                } else {
                    if (useTable) {
                        output.append(this._$rowStart);
                        output.append(this.getItemStyleName(item));
                        output.append(this._$cellStartTagClose);
                    }



                    var imgHeight = size,
                        oversize = (this.oversizeStretchImg && (item.width == isc.star));
                    if (oversize) {
                        output.append("<div style='overflow:hidden;height:",size,
                                "px;width:",width,"px;'>")
                        imgHeight = size+2;
                    }

                    var extraCSSText = isc.Browser.isDOM ? this._$displayBlock : null;
                    if (isc.Browser.isMobileSafari && item.browserTouchCallout == false) {
                        extraCSSText = ((extraCSSText == null ? "" : extraCSSText + ";") +
                                         "-webkit-touch-callout:none");
                    }
                    if (item.extraCSSText) {
                        extraCSSText = ((extraCSSText == null ? "" : extraCSSText + ";") + item.extraCSSText);
                    }
                    output.append(this.imgHTML({
                        src: src,
                        width: width,
                        height: imgHeight,
                        name: item.name,
                        extraStuff: extraStuff,
                        extraCSSText: extraCSSText
                    }));
                    if (oversize) {
                        output.append("</div>");
                    }
                    if (useTable) output.append(this._$rowEnd);
                    else if (!isc.Browser.isDOM && i < length - 1) output.append(this._$BR);
                }
            }
        }
        if (useTable) output.append(this._$tableEnd)
        else if (!vertical) output.append(this._$noBREnd);

    }
    return output.release(false);
},

// if stretching, in Moz pre FF 3.0, output the images in a table

renderStretchImgInTable:isc.Browser.isMoz || isc.Browser.isIE8Strict,



oversizeStretchImg:isc.Browser.isMoz && isc.Browser.isUnix,

//> @attr StretchImg.itemBaseStyle (CSSStyleName : null : IRW)
// If specified this css class will be applied to the individual item images within this StretchImg.
// May be overridden by specifying item-specific base styles to each object in the
// +link{StretchImg.items,items array}. This base style will have standard stateful suffixes
// appended to indicate the state of this component (as described in
// +link{StatefulCanvas.baseStyle}).
// @visibility external
//<
getItemStyleName : function (item) {
    var baseStyle;
    if (isc.isA.String(item.baseStyleKey) && isc.isAn.Object(item.baseStyleMap)) {
        baseStyle = item.baseStyleMap[this[item.baseStyleKey]];
    }
    if (baseStyle == null) baseStyle = item.baseStyle || this.itemBaseStyle;
    if (!baseStyle) return null;

    var state = item.state ? item.state : this.getState(),
        showStateProp = this._showStateProps[state];

    // If we're in state "Over" [say], and showRollOver is false, ignore this state
    if (state && showStateProp && this[showStateProp] === false) {
        state = "";
    }

    var selected = item.selected != null ? item.selected : this.selected,
        focused = this.showFocused && !this.showFocusedAsOver && !this.isDisabled() ?
                    (item.focused != null ? item.focused : this.focused) : false;

    return baseStyle + this._getStateSuffix(state,
        selected ? isc.StatefulCanvas.SELECTED : null,
        focused ? isc.StatefulCanvas.FOCUSED : null);
},

_$blankRE: /^blank[0-9]*$/,
_getItemURL : function (item) {
    // if the stretchItem has no src but does have a vSrc or hSrc, use one of them
    // according to the StretchImg's vertical setting
    if (this.vertical && !item.src && item.vSrc) return item.vSrc;
    if (!this.vertical && !item.src && item.hSrc) return item.hSrc;
    if (item.src) return item.src;
    // useful if you want the spacing for layout purposes, but no image
    if (this._$blankRE.test(item.name)) return isc.Canvas._blankImgURL;
    return this.getURL(item.name,
                       (item.state ? item.state : this.getState()),
                       (item.selected != null ? item.selected : this.selected),
                       (this.showFocused && !this.showFocusedAsOver && !this.isDisabled() ?
                            (item.focused != null ? item.focused : this.focused) :
                            false)
                      );
},


//>    @method    stretchImg.setState()    ([])
// Set the specified image's state to newState and update the displayed image given by
// whichPart, or set the state for all images to newState and update the displayed images
// if whichPart is not provided.
//      @visibility external
//        @group    appearance
//
//        @param    newState    (String)        name for the new state ("off", "down", etc)
//        @param    [whichPart]    (String)        name of the piece to set ("start", "stretch" or "end")
//                                            if not specified, sets them all
//<
setState : function (newState, whichPart) {
    // if a particular item was not set the state of the entire stretchImg
    if (whichPart == null) {
        // clear the states of all of the individual pieces, so they pick up the new state applied
        // to the widget as a whole.
        var itemChanged = this.items.clearProperty("state"),
            componentChanged = this.state != newState;

        this.Super("setState", [newState], arguments);
        // Super implementation won't fire stateChanged if the component level state is unchanged
        // so force it if appropriate
        if (itemChanged && !componentChanged) this.stateChanged();
    } else {


        // just set the state of that particular part
        var it = this.getPart(whichPart);
        if (it) {
            if (it.state == newState) return;
            it.state = newState;
        }
        this.stateChanged();
    }
},

stateChanged : function (whichPart) {

    // if we haven't been drawn already, no need to try to update HTML
    if (!this.isDrawn()) return;
    // Ditto if we're already dirty.

    if (this.isDirty()) return;

    // if we're tiling images, we have to redraw the whole thing... :-(
    if (this.imageType == isc.Img.TILE || this._imgSizes == null) {
        this.markForRedraw("setState (tiled images)");
    } else {

        if (isc.Browser.isWin2k && isc.Browser.isIE) {
            this.markForRedraw("Win2k IE image state change");
            return;
        }
        // iterate through all images, resetting their src
        var skip = 0;
        for (var i = 0; i < this.items.length; i++) {
            if (this._imgSizes[i] > 0) {
                var item = this.items[i];
                // if a specific items was not specified or this is the specified item

                if (!whichPart || item.name == whichPart) {
                    // set the image to the new state image

                    if (!item.src && !this._$blankRE.test(item.name)) {
                        this.setImage(item.name, this._getItemURL(item));
                    }

                    // fix stateful styling too
                    var handle = this.getImage(item.name);
                    if (handle) {
                        // in certain browsers we apply styles to table cells containing the images (see
                        // 'useTable' logic in getInnerHTML)
                        if (this.renderStretchImgInTable) {
                            handle = handle.parentNode;
                        }

                        handle.className = this.getItemStyleName(item);
                    }
                }
            } else {
                skip++;
            }
        }
    }

},


//>    @method    stretchImg.setSrc()    ([])
// Changes the base +link{stretchImg.src} for this stretchImg, redrawing if necessary.
//
// @param    src        (SCImgURL)    new URL for the image
// @group    appearance
// @visibility external
// @example loadImages
//<
setSrc : function (URL) {
    if (URL == null || this.src == URL) return;

    this.src = URL;
    this.markForRedraw();
},

//> @method stretchImg.setItems() (A)
// Setter for +link{StretchImg.items}.
// @param items (Array of StretchItem) the new array of items.
// @visibility external
//<
setItems : function (items) {
    this.items = items == null ? [] : items.duplicate();
    this.markForRedraw();
},

//> @method stretchImg.setIgnoreRTL() (A)
// Setter for +link{StretchImg.ignoreRTL}.
// @param ignoreRTL (boolean) new value for ignoreRTL.
// @visibility external
//<
setIgnoreRTL : function (ignoreRTL) {
    this.ignoreRTL = !!ignoreRTL;
    this.markForRedraw();
},

//>    @method    stretchImg.inWhichPart()    (A)
//        @group    event handling
//        Which part of the stretchImg was the last mouse event in?
//
//<

inWhichPart : function () {
    if (this.vertical) {
        var num = this.inWhichPosition(this._imgSizes, this.getOffsetY());
    } else {
        var direction = (this.ignoreRTL || !this.isRTL()) ? isc.Canvas.LTR : isc.Canvas.RTL;
        var num = this.inWhichPosition(this._imgSizes, this.getOffsetX(), direction);
    }

    var item = this.items[num];
    // If the TabSet includes an "emptyButton" between the ScrollerForwardImg and the
    // ScrollerBackImg we need to take it into account, as the emptyButton is not a valid
    // target for inWhichPart(). So, if the cursor is in the emptyButton, we will return the
    // next item in the scroller, that will be the ScrollerBackImg.
    if (item && item.name == "emptyButton") item = this.items[num+1];
    return (item ? item.name : null);
}

});










//>    @class    Label
// Labels display a small amount of +link{label.align,alignable} +link{label.contents,text}
// with optional +link{label.icon,icon} and +link{label.autoFit,autoFit}.
// <P>
// For a general-purpose container for HTML content, use +link{HTMLFlow} or +link{HTMLPane}
// instead.
//
//  @inheritsFrom Button
//  @treeLocation Client Reference/Foundation
//  @visibility external
//  @example label
//<

isc.defineClass("Label", "Button").addMethods({
    //>    @attr label.contents        (HTMLString : "&nbsp;" : [IRW])
    // @include canvas.contents
    //<

    //> @attr label.dynamicContents (Boolean : false : IRWA)
    //    @include canvas.dynamicContents
    //<

    //>    @attr    label.align        (Alignment : isc.Canvas.LEFT : [IRW])
    //          Horizontal alignment of label text. See Alignment type for details.
    //      @visibility external
    //      @group    positioning
    //<
    align:isc.Canvas.LEFT,

    //>    @attr    label.valign        (VerticalAlignment : isc.Canvas.CENTER : [IRW])
    //          Vertical alignment of label text. See VerticalAlignment type for details.
    //      @visibility external
    //      @group    positioning
    //<
    // defaulted in StatefulCanvas

    //>    @attr    label.wrap        (Boolean : true : [IRW])
    // If false, the label text will not be wrapped to the next line.
    // @visibility external
    // @group sizing
    //<
    wrap:true,

    //> @attr label.autoFit    (boolean : null : [IRW])
    // @include StatefulCanvas.autoFit
    // @visibility external
    //<

    //> @attr label.width
    // @include statefulCanvas.width
    // @group sizing
    // @visibility external
    //<

    //> @attr label.height
    // @include statefulCanvas.height
    // @group sizing
    // @visibility external
    //<

    // showTitle must be false
    // If this property gets set to true on the Label class we'd be likely to have infinite
    // recursion of labels being created for labels.
    showTitle:false,

    // Icon handling
    // ---------------------------------------------------------------------------------------

    //> @attr label.icon
    // @include statefulCanvas.icon
    // @visibility external
    //<
    //> @attr label.iconSize
    // @include statefulCanvas.iconSize
    // @visibility external
    //<
    //> @attr label.iconWidth
    // @include statefulCanvas.iconWidth
    // @visibility external
    //<
    //> @attr label.iconHeight
    // @include statefulCanvas.iconHeight
    // @visibility external
    //<
    //> @attr label.iconOrientation
    // @include statefulCanvas.iconOrientation
    // @visibility external
    //<
    //> @attr label.iconAlign
    // @include statefulCanvas.iconAlign
    // @visibility external
    //<
    //> @attr label.iconSpacing
    // @include statefulCanvas.iconSpacing
    // @visibility external
    //<
    //> @attr label.showDisabledIcon
    // @include statefulCanvas.showDisabledIcon
    // @visibility external
    //<
    //> @attr label.showRollOverIcon
    // @include statefulCanvas.showRollOverIcon
    // @visibility external
    //<
    //> @attr label.showFocusedIcon
    // @include statefulCanvas.showFocusedIcon
    // @visibility external
    //<
    //> @attr label.showDownIcon
    // @include statefulCanvas.showDownIcon
    // @visibility external
    //<
    //> @attr label.showSelectedIcon
    // @include statefulCanvas.showSelectedIcon
    // @visibility external
    //<
    //> @method label.setIconOrientation()
    // @include statefulCanvas.setIconOrientation
    // @visibility external
    //<
    //> @method label.setIcon()
    // @include statefulCanvas.setIcon
    // @visibility external
    //<

    // -------------------------------------------------------------------------


    // reversions of Button's changes relative to Canvas
    height:null,
    width:null,
    overflow:"visible",
    canFocus:false,



    //> @attr label.styleName (CSSStyleName : "normal" : IRW)
    // Set the CSS class for this widget.  For a Label, this is equivalent to
    // setting +link{button.baseStyle}.
    //
    // @visibility external
    //<
    styleName:"normal",
    // NOTE: the Button class configures styleName as null, and sets baseStyle to "button",
    // which we reverse.
    baseStyle:null,

    //> @method label.setStyleName()
    // Dynamically change the CSS class for this widget.  For a Label, this is equivalent to
    // +link{StatefulCanvas.setBaseStyle(), setBaseStyle()}.
    //
    // @param newStyle (CSSStyleName) new CSS style name
    // @visibility external
    //<
    setStyleName : function (newStyle) {
        this.setBaseStyle(newStyle);
    },

    // reversions of StatefulCanvas
    cursor:"default",
    // suppress state changes
    showRollOver:false, showFocus:false, showDown:false, showDisabled:false,

    // hack to have Button rendering code use getContents() instead of this.title
    useContents:true
});
//>    @method    label.setContents()
// @include canvas.setContents()
//<








//> @class Progressbar
//
// The Progressbar widget class extends the StretchImg class to implement image-based progress
// bars (graphical bars whose lengths represent percentages, typically of task completion).
//
// @inheritsFrom StretchImg
// @treeLocation Client Reference/Control
// @visibility external
//<

// declare the class itself
isc.ClassFactory.defineClass("Progressbar", "StretchImg");

// add default properties
isc.Progressbar.addProperties( {
    //> @attr progressbar.percentDone (number : 0 : [IRW])
    // Number from 0 to 100, inclusive, for the percentage to be displayed graphically in
    // this progressbar.
    // @group appearance
    // @visibility external
    //<
    percentDone:0,

    //> @attr progressbar.length (Number | String : 100 : IRW)
    // Length of the progressbar in pixels. This is effectively height for a vertical
    // progressbar, or width for a horizontal progressbar.
    // <P>
    // This property must be set instead of setting <code>width</code> or <code>height</code>.
    // @group appearance
    // @visibility external
    // @setter setLength
    // @getter getLength
    //<
    length: 100,

    //> @attr progressbar.breadth (number : 20 : IRW)
    // Thickness of the progressbar in pixels. This is effectively width for a vertical
    // progressbar, or height for a horizontal progressbar.
    // <P>
    // This property must be set instead of setting <code>width</code> or <code>height</code>.
    // @group appearance
    // @visibility external
    //<
    breadth: 20,

    //> @attr progressbar.vertical (Boolean : false : IRW)
    // Indicates whether this is a vertical or horizontal progressbar.
    // @group appearance
    // @visibility external
    //<
    vertical:false,

    //> @attr progressbar.imgDir (String : isc.Canvas.USE_WIDGET_IMG_DIR : IRW)
    // Where progress bar images come from
    // @group appearance
    //<
    //imgDir:isc.Canvas.USE_WIDGET_IMG_DIR,

    //> @attr progressbar.skinImgDir (SCImgURL : "images/Progressbar/" : IRWA)
    // Where do 'skin' images (those provided with the class) live?
    // This is local to the Page.skinDir
    // @group appearance, images
    //<
    skinImgDir:"images/Progressbar/",

    //> @attr progressbar.src (SCImgURL : "[SKIN]progressbar.gif" : IRW)
    // The base file name for the progressbar image.
    // @group appearance
    // @visibility external
    //<
    src:"[SKIN]progressbar.gif",

    //> @attr progressbar.cacheImageSizes (boolean : false : IRWA)
    // don't cache image sizes automatically
    // @group appearance
    //<
    cacheImageSizes:false,

    valign: "center",

    backgroundColor:"CCCCCC",

    // Items arrays for the images, so we don't make them over and over
    verticalItems: [
        {name:"v_empty_end",size:3},
        {name:"v_empty_stretch",size:0},
        {name:"v_empty_start",size:3},
        {name:"v_end",size:3},
        {name:"v_stretch",size:0},
        {name:"v_start",size:3}
    ],
    horizontalItems: [
        {name:"h_start",size:3},
        {name:"h_stretch",size:0},
        {name:"h_end",size:3},
        {name:"h_empty_start",size:3},
        {name:"h_empty_stretch",size:0},
        {name:"h_empty_end",size:3}
    ],

    //> @attr progressbar.useCssStyles (boolean : false : [IR])
    // When set to true, styles the Progressbar via the +link{progressbar.baseStyle, base} and
    // +link{progressbar.progressStyle, progress} CSS styles.
    // @visibility external
    //<
    useCssStyles: false,

    //> @attr progressbar.baseStyle (CSSStyleName : "progressbar" : [IR])
    // +link{stretchImg.baseStyle,Base style} for this Progressbar.  Only used when
    // +link{progressbar.useCssStyles, useCssStyles} is true.
    // @visibility external
    //<
    baseStyle: "progressbar",

    //> @attr progressbar.progressStyle (CSSStyleName : "progressbarProgress" : [IR])
    // +link{stretchImg.baseStyle,Base style} used to style the percentage-done portion of this
    // Progressbar.  Only used when +link{progressbar.useCssStyles, useCssStyles} is true.
    // @visibility external
    //<
    progressStyle: "progressbarProgress"

});

isc.Progressbar.addMethods({

init : function () {
    if (this.vertical) {
        this.width = this.breadth;
        this.height = this.length;
        this.items = this.verticalItems;
    } else {
        this.width = this.length
        this.height = this.breadth
        this.items = this.horizontalItems;
    }
    if (this.useCssStyles) {
        // create two items, styled by baseStyle and progressStyleName

        this.items = this.defaultItems ? this.defaultItems.duplicate() : [
            { name: "blank1", size: 0, baseStyle: this.progressStyle },
            { name: "blank2", size: 0, baseStyle: this.baseStyle }
        ];
    }
    this.Super("init", arguments);
},

//> @method progressbar.resizeImages() (A)
// Resize the images according to the percentDone, called automatically during rendering.
// <P>
// Sets this.sizes array to the new sizes
//<
resizeImages : function() {
    var totalSize = this.getLength(),
        imgs = this.items,
        sizes = this._imgSizes = [],
        percentDone = this.percentDone
    ;

    if (this.useCssStyles) {
        sizes[0] = Math.ceil(totalSize * percentDone/100);
        sizes[1] = Math.floor(totalSize * (100-percentDone)/100);
    } else {
        if (this.vertical) {
            // size the 'empty' cap images (3,5)
            sizes[0] = (percentDone < 100 ? imgs[0].size : 0);
            sizes[2] = (percentDone < 100 ? imgs[2].size : 0);

            // size the 'bar' cap images (0,2)
            sizes[3] = (percentDone > 0 ? imgs[3].size : 0);
            sizes[5] = (percentDone > 0 ? imgs[5].size : 0);
        } else {
            // size the 'bar' cap images (0,2)
            sizes[0] = (percentDone > 0 ? imgs[0].size : 0);
            sizes[2]   = (percentDone > 0 ? imgs[2].size : 0);

            // size the 'empty' cap images (3,5)
            sizes[3] = (percentDone < 100 ? imgs[3].size : 0);
            sizes[5]   = (percentDone < 100 ? imgs[5].size : 0);
        }

        // adjust the totalsize by the amounts allocated to the cap images
        totalSize -= sizes[0] + sizes[2] + sizes[3] + sizes[5];

        // size the stretch images
        if (this.vertical) {
            sizes[4] = Math.ceil(totalSize * percentDone/100);
            sizes[1] = Math.floor(totalSize * (100-percentDone)/100);
        } else {
            sizes[1] = Math.ceil(totalSize * percentDone/100);
            sizes[4] = Math.floor(totalSize * (100-percentDone)/100);
        }
    }
},

//> @method progressbar.setPercentDone() ([])
// Sets percentDone to newPercent.
//
// @visibility external
// @param newPercent (number) percent to show as done (0-100)
//<
setPercentDone : function (newPercent) {
    if (this.percentDone == newPercent) return;

    newPercent = Math.min(100,(Math.max(0,newPercent)));

    this.percentDone = newPercent;
    if (this.isDrawn()) {
        if (isc.Canvas.ariaEnabled()) this.setAriaState("valuenow", newPercent);
        this.markForRedraw("percentDone updated");
    }
    this.percentChanged();
},

//> @method progressbar.percentChanged() ([A])
// This method is called when the percentDone value changes. <smartclient>Observe</smartclient>
// <smartgwt>Call</smartgwt> this method to be notified upon
// a change to the percentDone value.
//
// @see method:class.observe
// @visibility external
//<
percentChanged : function () { },

//> @method progressbar.getLength() ([])
// Returns the current width of a horizontal progressbar, or height of a vertical progressbar.
//
// @visibility external
// @return (Number) the length of the progressbar
//<
getLength : function () {
    return this.vertical ? this.getHeight() : this.getWidth();
},

//> @method progressbar.getBreadth() ([])
// Returns the current height of a horizontal progressbar, or width of a vertical progressbar.
//
// @visibility external
// @return (number) the breadth of the progressbar
//<
getBreadth : function () {
    return this.vertical ? this.getWidth() : this.getHeight();
},

//> @method progressbar.setLength()
// Sets the length of the progressbar to newLength. This is the width of a horizontal progressbar,
// or the height of a vertical progressbar.
//
// @param newLength (Number) the new length of the progressbar
// @visibility external
//<
setLength : function (newLength) {
    this.length = newLength;
    this.vertical ? this.setHeight(newLength) : this.setWidth(newLength);
},

//> @method progressbar.setBreadth()
// Sets the breadth of the progressbar to newLength. This is the height of a horizontal progressbar,
// or the width of a vertical progressbar.
//
// @param newBreadth (number) the new breadth of the progressbar
// @visibility external
//<
setBreadth : function (newBreadth) {
    this.breadth = newBreadth;
    this.vertical ? this.setWidth(newBreadth) : this.setHeight(newBreadth);
}

});



//> @class Rangebar
//
//  @treeLocation Client Reference/Control
//<
isc.ClassFactory.defineClass("Rangebar", "Progressbar");

//----------  Define instance properties  ----------\\
isc.Rangebar.addProperties({

    value:0,
    minValue:0,
    maxValue:99,

    title:"",                    // title.............optional display title

    vertical:true,                // vertical.........vertical rangebar if true; horizontal rangebar if false

    showTitle:true,                // showTitle........if true, display the bar's title

    showRange:true,                // showRange........if true, display the min and max values of the bar;

    showValue:true,                // showValue........if true, display the bar's value

    allLabelDefaults : {
        width : 50,
        height : 20,
        spacing : 5          // space between the label and the bar - this is used by Rangebar only
    },

    titleLabelDefaults : {
        width : 100,
        className : "rangebarTitle"
    },

    rangeLabelDefaults : {
        className:"rangebarRange"
    },

    valueLabelDefaults : {
        className:"rangebarValue"
    },

    forceOverrides : {
        _resizeWithMaster: false,
        autoDraw: false
    },

    // text to use for range label instead of minValue
    //minValueLabel:null,

    // text to use for range label instead of maxValue
    //maxValueLabel:null,

    flipValues: false             //XXX NOT TESTED
});

//!>Deferred

//----------  Define instance methods  ----------\\
isc.Rangebar.addMethods({

initWidget : function () {
    this.Super(this._$initWidget, arguments);

    this.titleLabelDefaults = isc.addProperties({}, this.allLabelDefaults,
                                                this.titleLabelDefaults);
    this.valueLabelDefaults = isc.addProperties({}, this.allLabelDefaults,
                                                this.valueLabelDefaults);
    this.rangeLabelDefaults = isc.addProperties({}, this.allLabelDefaults,
                                                this.rangeLabelDefaults);
    if (this.showRange) {
        this._minLabel = this.addPeer(this._createRangeLabel("min"));
        this._maxLabel = this.addPeer(this._createRangeLabel("max"));
    }
    if (this.showValue) this._valueLabel = this.addPeer(this._createValueLabel());
    if (this.showTitle) this._titleLabel = this.addPeer(this._createTitleLabel());
    this.setValue(this.value);
},

resized : function(deltaX, deltaY) {
    this._adjustPeerPositions();
},

_adjustPeerPositions : function() {
    if(this.showRange && this._minLabel && this._maxLabel) {
        var minProps = this._computeRangeLabelProperties("min");
        var maxProps = this._computeRangeLabelProperties("max");
        this._minLabel.moveTo(minProps.left, minProps.top);
        this._maxLabel.moveTo(maxProps.left, maxProps.top);
    }

    if(this.showValue && this._valueLabel) {
        var props = this._computeValueLabelProperties();
        this._valueLabel.moveTo(props.left, props.top);
    }

    if(this.showTitle && this._titleLabel) {
        var props = this._computeTitleLabelProperties();
        this._titleLabel.moveTo(props.left, props.top);
    }
},

//------  _createRangeLabel(minOrMax)
// Creates, initializes, and returns a new Label widget to be the rangebar's mix or max value
// label. minOrMax must be the string "min" or "max".
_createRangeLabel : function (minOrMax) {
    var props = this._computeRangeLabelProperties(minOrMax);

    return isc.Label.newInstance({
        ID:this.getID()+"_"+minOrMax+"Label",
        contents:(minOrMax == "min" ?
            (this.minValueLabel ? this.minValueLabel : this.minValue) :
            (this.maxValueLabel ? this.maxValueLabel : this.maxValue) )
    }, this.rangeLabelDefaults, props, this.forceOverrides);
},

_computeRangeLabelProperties : function (minOrMax) {
    var props = {},
        defs = this.rangeLabelDefaults,
        shouldFlip = ((minOrMax == "min" && !this.flipValues) ||
                      (minOrMax = "max" && this.flipValues));

    if (this.vertical) {
        props.left = this.left + this.width + defs.spacing,
        props.align = isc.Canvas.LEFT;
        if (shouldFlip) {
            props.top = this.getTop() + this.getHeight() - defs.height;
            props.valign = isc.Canvas.BOTTOM;
        } else {
            props.top = this.getTop();
            props.valign = isc.Canvas.TOP;
        }
    } else { // this.horizontal
        props.top = this.getTop() + this.getHeight() + defs.spacing,
        props.valign = isc.Canvas.TOP;
        if (shouldFlip) {
            props.left = this.getLeft();
            props.align = isc.Canvas.LEFT;
        } else {
            props.left = this.getLeft() + this.getWidth() - defs.width;
            props.align = isc.Canvas.RIGHT;
        }
    }
    return props;
},


//------  _createTitleLabel()
// Creates, initializes, and returns a new Label widget to be the reangebar's title label.
_createTitleLabel : function () {
    var props = this._computeTitleLabelProperties();

    return isc.Label.newInstance({
        ID:this.getID()+"_titleLabel",
        contents:this.title
    }, this.titleLabelDefaults, props, this.forceOverrides);
},

_computeTitleLabelProperties : function () {
    var props = {};
    var defs = this.titleLabelDefaults;

    if (this.vertical) {
        props.left = this.left + this.width/2 - defs.width/2;
        props.top = this.top - defs.height - defs.spacing;
        props.align = isc.Canvas.CENTER;
    } else {
        props.left = this.left - defs.width - defs.spacing;
        props.top = this.top + this.getHeight()/2 - defs.height/2;
        props.align = isc.Canvas.RIGHT;
    }

    return props;
},


//------  _createValueLabel()
// Creates, initializes, and returns a new Label widget to be the rangebar's dynamic value
// label.
_createValueLabel : function () {
    var props = this._computeValueLabelProperties();

    return isc.Label.newInstance({
        ID:this.getID()+"_valueLabel",
        contents:this.value,
        mouseUp:"return false;",
        observes:[{source:this, message:"valueChanged", action:"observer.setContents(this.getValue())"}]
    }, this.valueLabelDefaults, props, this.forceOverrides);
},

_computeValueLabelProperties : function () {
    var props = {};
    var defs = this.valueLabelDefaults;

    if (this.vertical) {
        props.left = this.left - defs.width - defs.spacing;
        props.top = this.top + this.getHeight()/2 - defs.height/2;
        props.align = isc.Canvas.RIGHT;
        props.valign = isc.Canvas.CENTER;
    } else {
        props.left = this.left + this.width/2 - defs.width/2;
        props.top = this.top - defs.height - defs.spacing;
        props.align = isc.Canvas.CENTER;
        props.valign = isc.Canvas.BOTTOM;
    }
    return props;
},

getValue : function () {
    return this.value;
},

// Sets this.value to the new value, moves the rangebar to the appropriate position
// for this value, and calls valueChanged() which you can observe
setValue : function (newValue) {
    // do nothing if the value hasn't actually changed
    if (this.value == newValue) return;

    // make sure the new value falls in the range allowed by this instance.
    // If the value provided is outside the range, it clamps to the appropriate
    // boundary (min/max)
    if (newValue > this.maxValue) newValue = this.maxValue;
    else if (newValue < this.minValue) newValue = this.minValue;
    this.value = newValue;
    this.percentDone = 100 * (this.value - this.minValue) / (this.maxValue - this.minValue);
    this.markForRedraw();
    this.valueChanged();    // observable method
},

valueChanged : function () {

}

});
//!<Deferred







//>    @class    Toolbar
//
// A Toolbar creates a vertical or horizontal strip of similar components (typically Buttons)
// and provides managed resizing and reordering behavior over those components.
// <p>
// If you are creating a bar with a mixture of different elements (eg some MenuButtons, some
// Labels, some Buttons, some custom components), you want to use a +link{ToolStrip}.  A
// Toolbar is better suited for managing a set of highly similar, interchangeable components,
// such as ListGrid headers.
//
// @inheritsFrom Layout
// @treeLocation Client Reference/Layout
// @visibility external
//<

// declare the class itself
isc.ClassFactory.defineClass("Toolbar", "Layout");

// add default properties to the class
isc.Toolbar.addProperties( {
    //>    @attr    toolbar.buttons        (Array of Button Properties : null : [IRW])
    // An array of button object initializers. See the Button Widget Class for standard
    // button properties. The following additional properties can also be specified for
    // button sizing and positioning on the toolbar itself:<br><br>
    // <ul><li>width--Specifies the width of this button as an absolute number of pixels, a
    // named property of the toolbar that specifies an absolute number of pixels, a
    // percentage of the remaining space (e.g. '60%'), or "*" (default) to allocate an
    // equal portion of the remaining space.
    // <li>height--Specifies the height of this button.
    // <li>extraSpace--Specifies an optional amount of extra space, in pixels, to separate
    // this button from the next button in the toolbar.</ul>
    //
    // @setter setButtons()
    // @see toolbar.addButtons()
    // @see toolbar.removeButtons()
    // @see class:Button
    // @visibility external
    //<

    //>    @attr    toolbar.vertical        (Boolean : false : [IRW])
    // Indicates whether the buttons are drawn horizontally from left to right (false), or
    // vertically from top to bottom (true).
    //        @group    appearance
    //      @visibility external
    //<
    vertical:false,

    //>    @attr    toolbar.overflow        (Overflow : Canvas.HIDDEN : IRWA)
    // Clip stuff that doesn't fit
    //<
    overflow:isc.Canvas.HIDDEN,

    //>    @attr    toolbar.height        (number : 20 : IRW)
    // Default to a reasonable height
    //        @group    sizing
    //<
    height:20,

    //>    @attr    toolbar.buttonConstructor        (Class : Button : IRWA)
    // Default constructor for toolbar items.
    //        @group    appearance
    //    @visibility external
    //<
    buttonConstructor:"Button",

    //>    @attr    toolbar.canReorderItems        (Boolean : false : IRWA)
    //        If true, items can be reordered by dragging on them.
    //        @group    dragndrop
    //    @visibility external
    //<
    canReorderItems:false,

    //>    @attr    toolbar.canResizeItems        (Boolean : false : IRWA)
    //        If true, items (buttons) can be resized by dragging on them.
    //        @group    dragndrop
    //    @visibility external
    //<
    canResizeItems:false,

    //>    @attr    toolbar.canRemoveItems      (boolean : false : IRWA)
    // If true, items (buttons) can be dragged out of this toolbar to be dropped somewhere else
    //        @group    dragndrop
    //<
    canRemoveItems:false,

    //>    @attr    toolbar.canAcceptDrop (Boolean : false : IRWA)
    // If true, items (buttons) can be dropped into this toolbar, and the toolbar will
    // show a drop line at the drop location.  Override drop() to decide what happens when the
    // item is dropped.
    //
    //        @group    dragndrop
    //    @visibility external
    //<



    //>    @attr    toolbar.reorderOnDrop       (boolean : true : IRWA)
    //     On drop, should the Toolbar rearrange the buttons array?  Set to false by advanced
    //     classes that want to manage reordering themselves.
    //        @group    dragndrop
    //<
    reorderOnDrop:true,

    //>    @attr    toolbar.tabWithinToolbar   (boolean : true : IRWA)
    //      Should each button in the toolbar be included in the tab-order for the page, or
    //      should only one button in the toolbar show up in the tab-order, and arrow-keys be
    //      used to switch focus within the toolbar?
    //<
    tabWithinToolbar:true,




    //> @attr toolbar.allowButtonReselect (boolean : false : IRWA)
    // When a button is clicked but is already selected, should an additional
    // +link{buttonSelected} event be fired?
    //<
    allowButtonReselect:false,

    //> @attr toolbar.overrideDefaultButtonSizes (Boolean : false : IR)
    // Determines whether Toolbar tries to override Button length class default in
    // makeButton(), so that Toolbar sizing is not affected by the default.
    //<
    overrideDefaultButtonSizes: true,

    //>    @attr    toolbar.buttonDefaults        (Object : varies : [IRWA])
    // Settings to apply to all buttons of a toolbar. Properties that can be applied to
    // button objects can be applied to all buttons of a toolbar by specifying them in
    // buttonDefaults using the following syntax:<br>
    // <code>buttonDefaults:{property1:value1, property2:value2, ...}</code><br>
    // See the Button Widget Class for standard button properties.
    //        @group    appearance
    //      @see class:Button
    //      @visibility external
    //<
    //    The following are defaults for all toolbar buttons.
    //    To add properties to all buttons of ALL toolbars, change the below.
    //    To add properties to all buttons of a particular toolbar you're creating,
    //        add a "button" property to the toolbar constructor with the defaults
    //        you want applied to the buttons.  This will automatically be added to each button.
    buttonDefaults: {
        click : function() {
            this.Super("click", arguments);
            this.parentElement.itemClick(this, this.parentElement.getButtonNumber(this))
        },
        doubleClick : function () {
            this.Super("doubleClick", arguments);
            this.parentElement.itemDoubleClick(this, this.parentElement.getButtonNumber(this))
        },
        setSelected : function() {
            var oldState = this.isSelected();
            this.Super("setSelected", arguments);
            if (this.parentElement &&
                (this.parentElement.allowButtonReselect || oldState != this.isSelected()))
            {
                if (this.isSelected()) this.parentElement.buttonSelected(this);
                else this.parentElement.buttonDeselected(this);
            }
        },
        dragAppearance:isc.EventHandler.NONE,

        // Toolbars typically manipulate the tabIndex of their buttons.
        // If the user specifies a tabIndex on a toolbar button directly, assume they are
        // managing the tabIndex for the button - clear the flag that marks the button as having
        // it's tabIndex managed by the toolbar
        setTabIndex : function (index) {
            this.Super("setTabIndex", arguments);
            this._toolbarManagedTabIndex = false;
        },

        // Override setAccessKey to take a second parameter, indicating that the accessKey is
        // being set by the toolbar
        // If this parameter is not passed in, assume the user / developer is setting the
        // accessKey and clear the flag that marks the button's accessKey as being managed by
        // the toolbar
        setAccessKey : function (accessKey, managedByToolbar) {
            if (!managedByToolbar) this._toolbarManagedAccessKey = null;
            this.Super("setAccessKey", [accessKey]);
        },

        // When focus goes to a button, set the tabIndex of the button to the toolbars tabIndex.
        // This means when tabbing out of the button, the focus will go to the appropriate next
        // element - use the _updateFocusButton() method on the toolbar to achieve this.
        focusChanged : function (hasFocus) {

            if (this.parentElement == null) {
                return;
            }
            if (this.hasFocus && this.parentElement._updateFocusButton) {
                this.parentElement._updateFocusButton(this)
            }
        }
    }
});


isc.Toolbar.addMethods({

//> @attr toolbar.createButtonsOnInit (Boolean : null : [IR])
// If set to true, causes child buttons to be created during initialization, instead of waiting until
// draw().
// <p>
// This property principally exists for backwards compatibility; the default behavior of waiting
// until draw makes certain pre-draw operations more efficient (such as adding, removing or
// reordering buttons).  However, if you have code that assumes Buttons are created early
// and crashes if they are not, <code>createButtonsOnInit</code> will allow that code to
// continue working, with a minor performance penalty.
// @visibility external
//<
//createButtonsOnInit: null,

initWidget : function () {
    this.Super("initWidget", arguments);
    if (this.createButtonsOnInit) this.setButtons();
},

//>    @method    toolbar.draw()    (A)
//    Override the draw method to set up the buttons first
//        @group    drawing
//<
draw : function (a,b,c,d) {
    if (isc._traceMarkers) arguments.__this = this;

    if (!this.readyToDraw()) return this;

    // If we've never init'd our buttons, do so now by calling setButtons with no parameters
    if (!this._buttonsInitialized) this.setButtons();

    this.invokeSuper(isc.Toolbar, "draw", a,b,c,d);
},


//>    @method    toolbar.keyPress()
// Override keypress to allow navigation between the buttons on the toolbar
//        @group    events
//<
// Note - this is typically going to be bubbled up from the menu bar buttons
keyPress : function () {
    var keyName = this.ns.EH.lastEvent.keyName;
    // note - if we're allowing the user to tab between the buttons on the toolbar, we don't need
    // to give them the navigation via arrow keys.
    if (!this.tabWithinToolbar) {
        if ((this.vertical && keyName == "Arrow_Up") ||
            (!this.vertical && keyName == "Arrow_Left")) {

            this._focusInNextButton(false);
            return false;

        } else if ((this.vertical && keyName == "Arrow_Down") ||
                   (!this.vertical && keyName == "Arrow_Right")){
            this._focusInNextButton();
            return false;
        }
    }

    return this.Super("keyPress", arguments);
},

_focusInNextButton : function (forward, startingIndex) {

    // Note - this.buttons is the list of button init objects.  The live widgets are available
    // via this.getMembers()
    forward = (forward != false);
    var focusIndex = (startingIndex != null ? startingIndex : this.getFocusButtonIndex());
    if (focusIndex == null) focusIndex = (forward ?  -1 : this.buttons.length);

    // find the next focusable member in this direction, if any
    focusIndex += forward ? 1 : -1;
    while (focusIndex >=0 && focusIndex < this.buttons.length) {
        var button = this.getMembers()[focusIndex];
        if (button._canFocus()) {
            button.focus();
            // Returning true will indicate successful shift of focus
            return true;
        }
        focusIndex += forward ? 1 : -1;
    }
    return false;
},

//> @method toolbar.getFocusButtonIndex()  (A)
//  @return (number)    Index of whichever button currently has focus for keyboard input
//                      [On a mouse click, this will typically match the value returned by
//                      toolbar.getMouseOverButtonIndex(), but is likely to differ if the button
//                      was activated by keyboard interaction]
//<
getFocusButtonIndex : function () {

    var buttons = this.getButtons(),
        focusItemNum;
    for (var i = 0; i < buttons.length; i++) {
        if (buttons[i].hasFocus) {
            focusItemNum = i;
            break;
        }
    }
    return focusItemNum;
},

// Override focus() to put focus into the button(s) in the toolbar

// Override 'setFocus()' to update button focus only.

setFocus : function (hasFocus) {
    if (!this._readyToSetFocus()) return;
    var buttonIndex = this.getFocusButtonIndex();
    if (!hasFocus) {
        if (buttonIndex != null && this.members) this.members[buttonIndex].setFocus(false);
    } else {
        // If one of our buttons already has focus, just no op.
        if (buttonIndex != null) return;

        if (this._currentFocusButton) this._currentFocusButton.setFocus(true);
        else this._focusInNextButton();
    }
},

setButtonTabIndex : function (button, tabIndex) {
    button.setTabIndex(tabIndex);
    button._toolbarManagedTabIndex = true;
},

// _setButtonAccessKey()
// Internal method to set the accessKey for a button within this toolbar.
// Also sets the flag '_toolbarManagedAccessKey' on the button
_setButtonAccessKey : function (button, key) {
    button._toolbarManagedAccessKey = true;
    // see comment in the override for setAccessKey for why we're passing in this 2nd parameter
    button.setAccessKey(key, true);
},




// setupButtonFocusProperties()
// An internal method to set the tab indexes of any buttons in the toolbar without existing
// user-specified tab indexes
setupButtonFocusProperties : function () {
    // first update the 'currentFocusButton' if its out of date.
    // This will set the tabIndex and accessKey for the button (unless that would override an
    // explicitly specified property for the button).

    // Note - this.buttons is the list of button init objects.
    // The actual button objects are available via this.getButtons()

    var focusButton = this._currentFocusButton;

    if ( (!focusButton || !isc.isA.Canvas(focusButton) ||
          focusButton.visibility == isc.Canvas.HIDDEN ) && this.buttons.length > 0)
    {
        var newFocusButton;
        for (var i = 0; i < this.members.length; i++) {

            if (isc.isA.Canvas(this.members[i]) &&
                this.members[i].visibility != isc.Canvas.HIDDEN)
            {
                newFocusButton = this.members[i];
                break;
            }
        }
        this._updateFocusButton(newFocusButton)
        focusButton = this._currentFocusButton;
    }

    // update the tabIndex of any buttons who have no user-specified tab index, and
    // for which we haven't yet managed the tabIndex
    var buttons = this.getButtons();
    for (var i = 0; i < buttons.length; i++) {
        var button = buttons[i];
        if (button == focusButton) continue;
        if (!button._toolbarManagedTabIndex) continue;

        if (!this.tabWithinToolbar) {
            if (button._shouldManageTabPosition) {
                this.setButtonTabIndex(button, -1);
            }
        } else {
            if (button.tabIndex == -1) button.clearExplicitTabIndex();

        }
    }
},


_updateFocusButton : function (newFocusButton) {
    if (!newFocusButton) return;

    // Bail if the current focus button was passed in
    if (this._currentFocusButton == newFocusButton) {
        return;
    }

    // Update the accessKey for the current focus button unless it has / had an explicitly
    // specified accessKey
    if (newFocusButton.accessKey != this.accessKey &&
        (newFocusButton.accessKey == null || newFocusButton._toolbarManagedAccessKey))
    {
        this._setButtonAccessKey(newFocusButton, this.accessKey)
    }


    // If tabWithinToolbar is false, set the tabIndex of the old focus button to -1, and
    // allow the TabIndexManager to manage the tabIndex of the new focus button.
    if (newFocusButton._toolbarManagedTabIndex && newFocusButton.tabIndex == -1) {
        newFocusButton.clearExplicitTabIndex();
    }


    var oldFocusButton = this._currentFocusButton;
    // If appropriate, remove the previous focus button from the tab order
    if (oldFocusButton != null && oldFocusButton._toolbarManagedTabIndex) {
        // shouldManageTabPosition is basically a synonym for "picking up tabIndex from TabIndexManager"
        // IE: not currently -1.
        if (!this.tabWithinToolbar && oldFocusButton._shouldManageTabPosition) {
            this.setButtonTabIndex(oldFocusButton,-1);
        }

        // Clear the accessKey property if it was added by the toolbar
        if (oldFocusButton.accessKey != null &&
            oldFocusButton._toolbarManagedAccessKey)
        {
            this._setButtonAccessKey(oldFocusButton, null)
        }
    }
    this._currentFocusButton = newFocusButton;
},

// Override setAccessKey() to alo set the accessKey for the toolbar
setAccessKey : function (accessKey) {
    this.Super("setAccessKey", arguments);

    // use updateFocusButton to update the accessKey for the focus button
    var button = this._currentFocusButton;
    if (button != null) {
        this._currentFocusButton = null;
        this._updateFocusButton(button);
    }

},

getLength : function (a,b,c,d) {
    // the Toolbar allows overriding the area allocated to layout members, so that it may be
    // larger or smaller than the Layout's area.
    if (this.innerWidth != null) return this.innerWidth;
    return this.invokeSuper(isc.Toolbar, "getLength", a,b,c,d);
},

//>    @method    toolbar.setButtons()
// Apply a new set of buttons to render in this toolbar as +link{toolbar.buttons}.
//
// @param [newButtons] (Array of Button Properties) properties to create each button from
// @visibility external
//<
setButtons : function (newButtons) {

    // one time flag - allows us to set up our buttons on initial draw only.
    // If 'setButtons' is called before draw we won't unnecessarily remove and re-add them all.
    this._buttonsInitialized = true;

    //this.logWarn("setButtons at\n" + this.getStackTrace());

    // if buttons are passed in, use those
    // Otherwise we'll just make actual button instances from the current items in this.buttons
    if (newButtons) this.buttons = newButtons;

    if (this.members == null) this.members = [];

    // destroy any existing members, and create new buttons from scratch
    var _buttons = this.members.duplicate();
    for (var i = 0; i < _buttons.length ; i++) {
        var oldButton = _buttons[i];
        // destroy any members we automatically created from the buttons array
        if (!this.buttons.contains(oldButton)) {
            //this.logWarn("destroying old button " + i);
            // destroying it will automagically remove it from this as a member, so no
            // need to call this.removeMembers()
            _buttons[i].destroy();
        }
    }

    // now create actual button widgets
    if (this.buttons == null) this.buttons = [];

    var newMembers = [];
    for (var i = 0; i < this.buttons.length; i++) {
        var button = this.buttons[i];

        // allow widgets to be placed directly in the buttons array, which we simply add as
        // members and ignore.  These members will not have pick up buttonDefaults, hence won't
        // fire itemClick, have associated panes, allow managed resize, etc.
        if (!isc.isA.Canvas(button)) button = this.makeButton(button);

        newMembers[newMembers.length] = button;

        if (isc.isA.StatefulCanvas(button)) {
            var actionType = button.getActionType();

            if (actionType == isc.StatefulCanvas.RADIO) {

                // For actionType:radio buttons, remember initial selected button.
                // We update this on selection change.
                // This property will be returned on 'Toolbar.getSelectedButton()'
                // Note - no error checking for multiple selection within a toolbar
                // If each 'actionType' RADIO button has no specified radiogroup, the default
                // toolbar behavior is to put them into the same radioGroup. In this case default
                // radiogroup selection behavior inherited from StatefulCanvas will prevent
                // multiple selection within a toolbar.
                // If the user has specified a radiogroup for any actionType:RADIO buttons, we
                // can't guarantee there won't be multiple selection within a toolbar.
                // In this case 'getSelectedButton()' will return the most recently selected RADIO
                // button within this toolbar, rather than the only selected radio button.
                if (button.selected) this.lastSelectedButton = button;
            }
        }
    }
    this.addMembers(newMembers, 0);

    if (this.canResizeItems) this.setResizeRules();
    // Set up the tab indexes for the buttons, and the accessKey for the focus button
    this.setupButtonFocusProperties();

},

// shouldHiliteAccessKey implementation for buttons in this toolbar
buttonShouldHiliteAccessKey : function () {
    // If the accessKey comes from the toolbar itself, don't hilite
    // otherwise we will end up with underlining of the title on multiple buttons which
    // is likely to look odd.
    if (this._toolbarManagedAccessKey) return false;
    return this.hiliteAccessKey;
},

makeButton : function (button) {

    var override = this.overrideDefaultButtonSizes;
    if (override ||  this.vertical) button.width  = button.width  || null;
    if (override || !this.vertical) button.height = button.height || null;

    // set button properties to enable/disable dragging and dropping, so that dragging will
    // be allowed on members and will bubble to the Toolbar

    button.canDrag = this.canReorderItems || this.canDragSelectItems || this.canRemoveItems;

    // don't override canDragResize to true on the button if it's been explicitly turned off
    button.canDragResize = (button.canDragResize != null ?
        button.canDragResize && this.canResizeItems : this.canResizeItems);

    // toolbar allows things to be dropped on it (currently no default behavior for what happens
    // on drop)
    button.canAcceptDrop = this.canAcceptDrop;
    // if you can drag items out of the toolbar, make the buttons droppable
    button.canDrop = this.canRemoveItems;

    button.shouldHiliteAccessKey = this.buttonShouldHiliteAccessKey;

    // Allow a dev to suppress all tabIndex on the toolbar buttons by setting
    // tabIndex to -1 on the toolbar itself

    if (this.tabIndex == -1) button.tabIndex = -1;

    // If there's an explicit tabIndex - *never* attempt to manage the
    // tab index directly

    button._toolbarManagedTabIndex = (button.tabIndex == null);

    // create a new button widget
    //this.logWarn("creating new button " + i);
    return this._makeItem(button, null);
},

//>    @method    toolbar._makeItem()
// Creates and returns a widget for the toolbar
//        @group    drawing
//
//        @param    [buttonProperties]    (Object)    the button properties
//        @param    [rect]        (Object)    the rectangle for this widget, e.g. {top:50, left:100, ...}
//
//        @return    (Object)    the created widget
//<
_makeItem : function (buttonProperties, rect) {
    var cons = (buttonProperties.buttonConstructor
                        ? buttonProperties.buttonConstructor
                        : this.buttonConstructor
                      )
    ;
    cons = this.ns.ClassFactory.getClass(cons, true);

    var item = cons.newInstance(
                {autoDraw:false},
                this.buttonDefaults,    // isc.Toolbar class defaults
                this.buttonProperties,    // isc.Toolbar instance defaults
                buttonProperties,       // properties for this button
                rect                    // rectangle for the button
            );

    if (!isc.isA.StatefulCanvas(item)) return item;

    // if the button is of actionType 'radio' and the developer has not specified a
    // radioGroup, set radioGroup to the ID of this toolbar
    // Developer can override by setting 'radioGroup' property explicitly on the
    // item's properties.
    var unset;
    if ((item.getActionType() == isc.StatefulCanvas.RADIO && item.radioGroup === unset)
        || item.defaultRadioGroup != null) {
        var rg = item.defaultRadioGroup != null ? item.defaultRadioGroup : this.getID();
        item.addToRadioGroup(rg);
    }

    return item;
},

//>    @method    toolbar.addButtons()
// Add a list of buttons to the toolbar
// @param [buttons]    (Array of Object) list of button object initializers.
// @param [position] (number) position to add the new buttons at
// @visibility external
//<
addButtons : function (buttons, position) {

    if (buttons == null) return;
    if (!isc.isAn.Array(buttons)) buttons = [buttons];

    if (!this._buttonsInitialized) this.setButtons();
    buttons.removeEvery(null);

    // (currently undocumented) feature - support passing in position for each
    // button being added - in this case the 2nd argument will be an array of the
    // same length as the buttons array.
    // Break into discrete blocks of adjacent buttons so we can use standard list manipulation
    // APIs rather than having to iterate through every button and add as a member individually,
    // rerunning layout.
    var discreteBlocks;
    if (isc.isAn.Array(position)) {
        if (position.length != buttons.length) {
            this.logWarn("addButtons passed " + buttons.length + " buttons with " + position.length
                + " discrete positions specified. Ignoring.");
            return;
        }
        var mapping = {};
        for (var i = 0; i < position.length; i++) {
            mapping[position[i]] = buttons[i];
        }


        position.sort(function (a, b) {return a - b;});

        discreteBlocks = [];
        var currentBlock = {buttons:[], position:position[0]},
            currentIndex = 0;
        for (var i = 0; i < position.length; i++) {
            var pos = position[i],
                button = mapping[pos];

            currentBlock.buttons.add(button);

            var nextPos = position[i+1]
            if (nextPos == null || nextPos != pos+1) {

                discreteBlocks[currentIndex] = currentBlock;
                currentIndex++

                // New discrete block for the next time through this loop
                if (nextPos != null) currentBlock = {buttons:[], position:nextPos};
            }
        }
        for (var i = 0; i < discreteBlocks.length; i++) {
            this.buttons.addListAt(discreteBlocks[i].buttons, discreteBlocks[i].position);
        }
    } else {
        // Update this.buttons to include the new buttons:
        this.buttons.addListAt(buttons, position);
    }

    // if instantRelayout is true, delay the relayout until we've added the full
    // set of members
    var forceReflow = this.instantRelayout;
    this.instantRelayout = false;

    // Add as members to the right position, and let layout handle spacing and stuff
    var buttonWidgets;
    if (discreteBlocks == null) {
        buttonWidgets = this._createButtonInstances(buttons);
        this.addMembers(buttonWidgets, position)
    } else {
        for (var i = 0; i < discreteBlocks.length; i++) {
            var currentButtons = this._createButtonInstances(discreteBlocks[i].buttons);
            this.addMembers(currentButtons, discreteBlocks[i].position);

            if (buttonWidgets == null) buttonWidgets = currentButtons;
            else buttonWidgets.addList(currentButtons);
        }
    }
    if (forceReflow) {
        this.instantRelayout = true;
        if (this._layoutIsDirty) this._layoutIsDirty = false;
        this.reflow("addButtons");
    }

    // setResizeRules to update dragResizing, etc.
    if (this.canResizeItems) this.setResizeRules();

    buttonWidgets.callMethod("show");  // auto-show the new members
},

_createButtonInstances : function (buttons) {
    var buttonWidgets = [];
    for (var i = 0; i < buttons.length; i++) {
           var button = buttons[i],
        // call makeButton() to convert the init block to a widget with the appropriate
        // propoerties (canDrag, buttonDefaults, etc)
        // Note that canvases are just integrated into the buttons block without
        // attempting to modify properties, as with setButtons()
        buttonWidget = isc.isA.Canvas(button) ? button : this.makeButton(button);
        buttonWidgets[i] = buttonWidget;
    }
    return buttonWidgets;
},


//>    @method    toolbar.removeButtons()
//    Remove a list of buttons from the toolbar
//
// @param [buttons]    (Array) Array of buttons to remove. Buttons may be specified as pointers to
// the button instances contained in this toolbar, or numbers indicating the index of the buttons
// in <code>this.buttons</code>.
// @visibility external
//<
removeButtons : function (buttons) {
    if (buttons == null) return;
    if (!isc.isAn.Array(buttons)) buttons = [buttons];

    // We're going to manipulate the this.buttons array (button description objects), and
    // the actual buttons in this.members - so will need pointers to both the
    // button descriptor objects and the button instances.
    var buttonWidgets = [];

    // The buttons to remove can be specified as:
    // a) Index in this.buttons
    // b) Button widget
    // c) Button instantiation block
    // d) ID of button
    for (var i =0; i < buttons.length; i ++) {

        // resolve whatever object was passed in to a button instantiation block
        buttons[i] = this.buttons[this.getButtonNumber(buttons[i])];

        if (buttons[i] == null)  {
            this.logWarn("removeButtons(): unable to find button for item number " + i +
                        " in the array passed in.  Skipping this item.");
            buttons.removeItem(i);
            i -= 1;
            continue;
        }
        // get a pointer to the Canvas as well
        buttonWidgets[i] = this.getButton(this.buttons.indexOf(buttons[i]))
    }

    var completeButtons = this.buttons;
    // if (any of) the buttons aren't in this.buttons, this has no effect
    completeButtons.removeList(buttons);

    this.removeMembers(buttonWidgets);
// should we destroy them?

},

//>    @method    toolbar.getButton() ([])
//          Retrieves a button widget instance (within this toolbar) from the name / ID / index /
//          descriptor object for the button (as with the getButtonNumber() method)
//          This provides a way to access a toolbar button's properties and methods directly.
//      @see    getButtonNumber()
//      @visibility external
//        @group    buttons
//        @param    index        (number | String | Object)    identifier for the button to retrieve
//
//      @return (Button)    the button, or null if the button wasn't found
//<
getButton : function (index) {
    index = this.getButtonNumber(index);
    return this.getMember(index);
},

//>    @method    toolbar.getButtonNumber()    (A)
//            get the index of a button in the buttons array<p>
//          The button can be specified as -
//          <ul>
//          <li>an index within this.buttons (just returned)
//          <li>the ID property of a button
//          <li>a pointer to the button descriptor object in this.buttons
//          <li>the actual button widget in this.members
//          </ul><p>
//            returns -1 if not found
//
//        @param    button        (number | String  | Button Object | Button Widget)
//
//        @return    (number)    index of the button in question
// @visibility external
//<
getButtonNumber : function (button) {
    // if we're passed an Object that isn't a Canvas, it might be a button configuration object
    if (isc.isAn.Object(button) && !isc.isA.Canvas(button)) return this.buttons.indexOf(button);
    // otherwise use normal member lookup
    return this.getMemberNumber(button);
},

//>    @method    toolbar.getButtons()
//        @group    buttons
//        @return (Array) array of all buttons in the Toolbar
//<
getButtons : function () {
    return this.members;
},

//> @method toolbar.setCanResizeItems()
// Setter for updating +link{toolbar.canResizeItems} at runtime.
// @param canResizeItems (boolean) New value for this.canResizeItems
// @visibility external
//<
setCanResizeItems : function (canResizeItems) {
    if (this.canResizeItems == canResizeItems) return;
    this.canResizeItems = canResizeItems;
    var buttons = this.getButtons();
    if (!buttons) return;
    for (var i = 0; i < buttons.length; i++) {
        var item = buttons[i];
        if (!item.origDragResize) {
            // store the item's original canDragResize
            item.origDragResize = item.canDragResize;
        }
        // can resize if canResizeItems is true *and* the item itself was not specifically
        // set to canDragResize: false originally
        item.canDragResize = canResizeItems && (item.origDragResize != false);
    }
    this.setResizeRules();
},

// update which edges a button can be resized from.
//
// When you dragResize buttons, it always effects the button on the left (or top), regardless
// of which side of the boundary between the buttons you click on (this is pulled off by
// switching the dragTarget on the fly).  This means the sides that each button can be resized
// from is affected by whether the adjacent buttons can be resized.  setResizeRules updates
// this; it needs to be called on any reorder, addition or removal of buttons.
setResizeRules : function () {
    if (!this.members) return;

    var rtl = this.isRTL();

    // buttons can resize along the long axis of the toolbar.
    var edgeCursorMap, resizeFrom, resizeFromOneSide;
    if (this.vertical) {
        edgeCursorMap = {"T":isc.Canvas.ROW_RESIZE, "B":isc.Canvas.ROW_RESIZE };
        resizeFrom = ["T","B"];
        resizeFromOneSide = ["B"];
    } else {
        var colResizeCursor = rtl ? isc.Canvas.RTL_COL_RESIZE : isc.Canvas.COL_RESIZE;
        edgeCursorMap = {"L":colResizeCursor, "R":colResizeCursor };
        resizeFrom = ["L","R"];
        if (!rtl) {
            resizeFromOneSide = ["R"];
        } else {
            resizeFromOneSide = ["L"];
        }
    }

    var previousCantResize = false;
    for (var i = 0; i < this.members.length; i++) {
        var button = this.members[i];
        if (!button.canDragResize) {
            button.resizeFrom = null;
            button.edgeCursorMap = {};
            previousCantResize = true;
        } else {
            if (previousCantResize || i == 0)
            {
                // the first button, or any button next to a button that can't resize, is not
                // allowed to resize from it's left/top.
                button.resizeFrom = resizeFromOneSide;
            } else {
                button.resizeFrom = resizeFrom;
            }
            button.edgeCursorMap = edgeCursorMap || {};
            previousCantResize = false;
        }
    }
},

//>    @method    toolbar.getSelectedButton()    (A)
// Get the button currently selected.
//        @return (Object) button
//<
getSelectedButton : function () {
    return this.lastSelectedButton;
},

//>    @method    toolbar.selectButton()  ([])
// Given an identifier for a button, select it.
// The button identifier can be a number (index), string (id), or object (widget or init block),
// as with the getButtonNumber() method.
//
//      @see    getButtonNumber()
//        @group    selection
//        @param    buttonID        (number | String | Object | Canvas)    Button / Button identifier
//      @visibility external
//<
selectButton : function (buttonID) {

    if (!this.members) return;
    var btn = this.getButton(buttonID);
    if (btn && isc.isA.StatefulCanvas(btn)) btn.select();
},


//>    @method    toolbar.deselectButton()    ([])
//    Deselects the specified button from the toolbar, where buttonID is the index of
//  the button's object initializer. The button will be redrawn if necessary.
//  The button identifier can be a number (index), string (id), or object (widget or init block),
// as with the getButtonNumber() method.
//      @see    getButtonNumber()
//      @visibility external
//        @group    selection
//        @param    buttonID        (number | String | Object | Canvas)    Button / Button identifier
//<
deselectButton : function (buttonID) {
    var btn = this.getButton(buttonID);
    if (btn) btn.deselect();
},


//>    @method    toolbar.buttonSelected()    (A)
// One of the toolbar button was just selected -- update other buttons as necessary
//        @group    selection
//
//        @param    button        (Button Object)        a member of this.buttons
//<
buttonSelected : function (button) {
    if (button.getActionType() == isc.Button.RADIO) {
        this.lastSelectedButton = button;
    }
},


//>    @method    toolbar.buttonDeselected()    (A)
// Notification that one of the toolbar buttons was just DEselected
//        @group    selection
//
//        @param    button        (Button Object)        a member of this.buttons
//<
buttonDeselected : function (button) {
},


//> @method toolbar.itemClick() ([A])
//  Called when one of the buttons receives a click event.
// @param  item     (StatefulCanvas)  button in question
// @param  itemNum  (number)          number of the button in question
// @group  event handling
// @visibility smartclient
//<
itemClick : function (item, itemNum) {
},

//> @method toolbar.sgwtItemClick() ([A])
// @include itemClick
// @param  targetCanvas  (StatefulCanvas)  button in question
// @param  itemNum       (number)          number of the button in question
// @group  event handling
// @visibility sgwt
//<

//>    @method    toolbar.itemDoubleClick() ([A])
//    Called when one of the buttons receives a double-click event
//        @group    event handling
//        @param    item        (Button)        pointer to the button in question
//        @param    itemNum        (number)        number of the button in question
// @visibility external
//<
itemDoubleClick : function (item, itemNum) {
},

//>    @method    toolbar.getMouesOverButtonIndex()    (A)
//  @return (number) the number of the button the mouse is currently over,
//                   or -1 for before all buttons, -2 for after all buttons
//                  See also getFocusButtonIndex()
//<
getMouseOverButtonIndex : function () {
    var offset = this.vertical ? this.getOffsetY() : this.getOffsetX();

    if (this.isRTL() || this.align == isc.Canvas.RIGHT) {
        var leftGap = this.getInnerWidth() - this.memberSizes.sum();
        if (leftGap > 0) offset-= leftGap;

    }
    return this.inWhichPosition(this.memberSizes, offset, this.getTextDirection());
},


// Override prepareForDragging to handle dragResize / dragReorder of items in the toolbar.
prepareForDragging : function () {
    // NOTE: we currently set a canDrag, canDragResize, etc flags on our children.  However, we
    // could manage everything from this function instead, eg, pick dragResize if there is a
    // resize edge hit on the child, otherwise dragReorder.

    var EH = this.ns.EH;
    // This custom handling is for events bubbled from a member being drag repositioned
    // (drag reorder) or drag resized.
    //

    var lastTarget = EH.lastEvent.target;
    while (lastTarget.dragTarget) {
        lastTarget = lastTarget.dragTarget;
    }
    var operation = EH.dragOperation;


    if (( (this.canResizeItems && operation == "dragResize")
          || (this.canReorderItems && operation == "drag")
         ) && this.members.contains(lastTarget))
    {

        // If we hit a valid resize edge on a member, the member will have set the dragOperation to
        // dragResize
        if (operation == "dragResize") {
            // for drag resizes on the length axis, do specially managed resizing.  Don't interfere
            // with breadth-axis resize, if enabled
            if ((this.vertical && ["T","B"].contains(EH.resizeEdge)) ||
                (!this.vertical && ["L","R"].contains(EH.resizeEdge)))
            {
                EH.dragOperation = "dragResizeMember";
                // We can just return - prepareForDragging() is bubbled so was already fired
                // on the member and set up EH.dragTarget in this case
                return;
            }
        // otherwise, starting a drag on a button means dragReordering the members.
        } else if (operation == "drag") {
            EH.dragOperation = "dragReorder";
            return;
        }
    }

    return this.Super("prepareForDragging", arguments);
},

// Drag Reordering
// --------------------------------------------------------------------------------------------

// get the position where the button being reordered would be dropped, if dragging stopped at the
// current mouse coordinates
getDropPosition : function () {
    var position = this.getMouseOverButtonIndex();


    var EH = this.ns.EH,
        switchInMiddle = (this.reorderStyle == "explorer" ||
                        (EH.dropTarget && EH.dropTarget.parentElement == this));
    if (switchInMiddle && position >= 0) {
        // if we are over a member, check whether we should switch to the next member or final
        // coordinate
        var buttonSize = this.memberSizes[position],
            offset = (this.vertical ? this.getOffsetY() : this.getOffsetX());


        offset -= this.memberSizes.slice(0, position).sum();
        var oldPosition = position;
        // switch to next coordinate in the middle of the button
        if (offset > buttonSize/2) position++;

        //this.logWarn("oldPosition: " + oldPosition +
        //             ", size: " + buttonSize +
        //             ", offset: " + offset +
        //             ", position: " + position);
    }

    var numMembers = this.members.length,
        maxIndex = (switchInMiddle ? numMembers : numMembers - 1);

    // for reorder/self-drop interactions, when we drag out of the Layout, we revert to the
    // original position.  For external drops, the only remaining case is a coordinate within
    // the Layout, but before all members.
    var revertPosition = this.dragStartPosition || 0,
        selfDrag = EH.dragTarget && EH.dragTarget.parentElement == this;

    // if beyond the last member, but still within the layout rect, convert to last member
    if (position == -2 && this.containsEvent()) {
        position = maxIndex;
    }

    if (position < 0 || position > maxIndex) position = revertPosition;

    // for reorder/self-drop, check canReorder flag, and override API (used by headers)
    else if (selfDrag && this.members[position] && this.members[position].canReorder == false &&
             (!this._canReorderDrop || !this._canReorderDrop(position, revertPosition)))
    {
        position = revertPosition;
    }
    return position;
},

// sent when button dragging for reordering begins
dragReorderStart : function () {
    var EH = this.ns.EH,
        startButton = EH.dragTarget
    ;

    // if the button's canReorder property is false, it can't be reordered so forget it!
    if (startButton.canReorder == false) return false;



    startButton.setState(isc.StatefulCanvas.STATE_DOWN);

    // get the item number that reordering started in (NOTE: depended on by observers like LV)
    this.dragStartPosition = this.getButtonNumber(startButton);
    return EH.STOP_BUBBLING;
},

// sent when button moves during drag-reorder
dragReorderMove : function () {
    var EH = this.ns.EH,
        startButton = EH.dragTarget,
        startPosition = this.dragStartPosition,
        currentPosition = Math.min(this.getDropPosition(), this.members.length-1);

    //this.logWarn("dragReorderMove: position: " + this.getMouseOverButtonIndex() +
    //             ", drop position: " + this.getDropPosition());

    // remember the current position (NOTE: depended on by observers like LV)
    this.dragCurrentPosition = currentPosition;



    // create a temporary order for the members and lay them out in that order
    var members = this.members.duplicate();
    members.slide(startPosition, currentPosition);
    //this.logWarn("startPos: " + startPosition + ", currentPos: " + currentPosition +
    //             "members: " + this.members + ", reordered: " + members);
    // NOTE: tell stackMembers() not to update sizes, since this is a temporary order
    this.stackMembers(members, null, false);

    return EH.STOP_BUBBLING;
},

// sent when button dragging for reordering ends
dragReorderStop : function () {
    var EH = this.ns.EH,
        startButton = EH.dragTarget,
        startPosition = this.dragStartPosition,
        currentPosition = this.dragCurrentPosition;

    startButton.setState(isc.StatefulCanvas.STATE_UP);



    if (currentPosition == startPosition) return false;

    // if we're supposed to actually reorder on drop, reorder now
    if (this.reorderOnDrop) this.reorderItem(currentPosition, startPosition);

    // notify observers
    if (this.itemDragReordered) this.itemDragReordered(startPosition, currentPosition);

    return EH.STOP_BUBBLING;
},

//>    @method    toolbar.dragStop()    (A)
//        @group    events, dragging
//            handle a dragStop event
//<
dragStop : function () {
    // NOTE: called at the end of an inter-toolbar move iteraction, not a dragReorder
    var EH = this.ns.EH,
        startButton = EH.dragTarget,
        startPosition = this.dragStartPosition;

    startButton.setState(isc.StatefulCanvas.STATE_UP);
    this.hideDropLine();

    return EH.STOP_BUBBLING;
},

// reorder an item programmatically
reorderItem : function (itemNum, newPosition) {
    this.reorderItems(itemNum, itemNum+1, newPosition);
},

// reorder multiple items programmatically
reorderItems : function (start, end, newPosition) {
    // reorder the button config
    this.buttons.slideRange(start, end, newPosition);
    // and array of button widgets
    this.reorderMembers(start, end, newPosition);
    // update which buttons can resize
    this.setResizeRules();
},



// Drag Resizing (of buttons)
// --------------------------------------------------------------------------------------------

// sent whem button dragging for resizing begins
dragResizeMemberStart : function () {
    var EH = this.ns.EH,
        item = EH.dragTarget,
        itemNum = this.getButtonNumber(item),
        rtl = this.isRTL();

    // if dragging from the left edge, switch to the previous item and drag resize from its right
    var offsetDrag = false;
    if ((!rtl && EH.resizeEdge == "L") || (rtl && EH.resizeEdge == "R")) {
        offsetDrag = true;
        itemNum--;
        EH.resizeEdge = (rtl ? "L" : "R");
    } else if (EH.resizeEdge == "T") {
        offsetDrag = true;
        itemNum--;
        EH.resizeEdge = "B";
    }
    // if not in a valid item, forget it
    if (itemNum < 0 || itemNum >= this.members.length || item == null) return false;
    EH.dragTarget = item = this.members[itemNum];


    item._oldCanDrop = item.canDrop;
    item.canDrop = false;

    // NOTE: depended upon by observers (ListGrid)
    this._resizePosition = itemNum;

    item.setState(isc.StatefulCanvas.STATE_DOWN);
    if (offsetDrag) {
        var mouseDownItem = this.members[itemNum+1];
        if (mouseDownItem) mouseDownItem.setState(isc.StatefulCanvas.STATE_UP);
    }
    return EH.STOP_BUBBLING;
},

// sent whem item moves during drag-resizing
dragResizeMemberMove : function () {
    var EH = this.ns.EH,
        item = EH.dragTarget;

    // resize the item
    item.resizeToEvent();
    // do an immediate redraw for responsiveness
    item.redrawIfDirty("dragResize");
    return EH.STOP_BUBBLING;
},

// sent whem item dragging for resizing ends
dragResizeMemberStop : function () {
    var EH = this.ns.EH,
        item = EH.dragTarget;

    // restore old canDrop setting
    item.canDrop = item._oldCanDrop;

    // change appearance back
    item.setState(isc.StatefulCanvas.STATE_UP);

    // resize
    item.resizeToEvent();

    // record the new size
    var newSize = (this.vertical ? item.getHeight() : item.getWidth());
    this.resizeItem(this._resizePosition, newSize);

    if (this.itemDragResized) this.itemDragResized(this._resizePosition, newSize); // for observers
    return EH.STOP_BUBBLING;
},

// resize an item programmatically
resizeItem : function (itemNum, newSize) {
    // resize the item
    var item = this.members[itemNum];
    if (this.vertical) item.setHeight(newSize);
    else item.setWidth(newSize);
}

});

isc.Toolbar.registerStringMethods({
// itemClick handler for when an item is clicked
// (JSDoc comment next to default implementation)
itemClick : "item,itemNum",

//> @method toolbar.itemDragResized
// <smartclient>Observable, overrideable method - called</smartclient><smartgwt>Called</smartgwt>
// when one of the Toolbar buttons is drag resized.
//
// @param itemNum (number) the index of the item that was resized
// @param newSize (number) the new size of the item
//
// @visibility external
//<
itemDragResized : "itemNum,newSize",

// Sent when an item is drag reordered.  This can be observed to have a related widget
// rearrange itself.
itemDragReordered : "itemNum,newPosition"
});











//>    @class    ImgButton
// A Img that behaves like a button, going through up/down/over state transitions in response to
// user events.  Supports an optional title, and will auto-size to accommodate the title text if
// <code>overflow</code> is set to "visible".
// <P>
// Example uses are Window minimize/close buttons.
//
// @inheritsFrom Img
// @treeLocation Client Reference/Control
// @visibility external
//<

// class for Stretchable image buttons
isc.defineClass("ImgButton", "Img").addProperties({

    // Various properties documented on StatefulCanvas that affect all buttons
    // NOTE: This block is included in Button, ImgButton, and StrechlImgButton.
    //       If you make changes here, make sure you duplicate it to the other
    //       classes.
    //
    // End of this block is marked with: END StatefulCanvas @include block
    // =========================================================================

    // Title
    //------
    //> @attr imgButton.title
    // @include statefulCanvas.title
    // @visibility external
    //<
    //> @attr imgButton.clipTitle
    // @include Button.clipTitle
    // @group appearance
    //<
    clipTitle:true,
    //> @attr imgButton.hiliteAccessKey (boolean : null : IRW)
    // @include statefulCanvas.hiliteAccessKey
    // @visibility external
    //<

    //>    @method    imgButton.getTitle()    (A)
    // @include statefulCanvas.getTitle
    // @visibility external
    //<
    //>    @method    imgButton.setTitle()
    // @include statefulCanvas.setTitle
    // @visibility external
    //<

    //> @attr imgButton.showClippedTitleOnHover
    // @include Button.showClippedTitleOnHover
    // @group hovers
    // @visibility external
    //<
    showClippedTitleOnHover:false,
    _canHover:true,

    // Icon
    //------
    //> @attr imgButton.icon
    // @include statefulCanvas.icon
    // @visibility external
    //<
    //> @attr imgButton.iconSize
    // @include statefulCanvas.iconSize
    // @visibility external
    //<
    //> @attr imgButton.iconWidth
    // @include statefulCanvas.iconWidth
    // @visibility external
    //<
    //> @attr imgButton.iconHeight
    // @include statefulCanvas.iconHeight
    // @visibility external
    //<
    //> @attr imgButton.iconOrientation
    // @include statefulCanvas.iconOrientation
    // @visibility external
    //<
    //> @attr imgButton.iconAlign
    // @include statefulCanvas.iconAlign
    // @visibility external
    //<
    //> @attr imgButton.iconSpacing
    // @include statefulCanvas.iconSpacing
    // @visibility external
    //<
    //> @attr imgButton.showDisabledIcon
    // @include statefulCanvas.showDisabledIcon
    // @visibility external
    //<
    //> @attr imgButton.showRollOverIcon
    // @include statefulCanvas.showRollOverIcon
    // @visibility external
    //<
    //> @attr imgButton.showFocusedIcon
    // @include statefulCanvas.showFocusedIcon
    // @visibility external
    //<
    //> @attr imgButton.showDownIcon
    // @include statefulCanvas.showDownIcon
    // @visibility external
    //<
    //> @attr imgButton.showSelectedIcon
    // @include statefulCanvas.showSelectedIcon
    // @visibility external
    //<
    //> @method imgButton.setIconOrientation()
    // @include statefulCanvas.setIconOrientation
    // @visibility external
    //<
    //> @method imgButton.setIcon()
    // @include statefulCanvas.setIcon
    // @visibility external
    //<

    // AutoFit
    //--------
    //> @attr imgButton.autoFit
    // @include statefulCanvas.autoFit
    // @visibility external
    //<
    //> @method imgButton.setAutoFit()
    // @include statefulCanvas.setAutoFit
    // @visibility external
    //<

    //> @attr imgButton.width
    // @include statefulCanvas.width
    // @group sizing
    // @visibility external
    //<

    //> @attr imgButton.height
    // @include statefulCanvas.height
    // @group sizing
    // @visibility external
    //<

    // baseStyle
    //----------
    //> @attr imgButton.baseStyle (CSSStyleName : "imgButton" : IRW)
    // @include statefulCanvas.baseStyle
    // @visibility external
    //<
    baseStyle:"imgButton",
    //> @method imgButton.setBaseStyle()
    // @include statefulCanvas.setBaseStyle
    // @visibility external
    //<

    // selection
    //----------
    //> @attr imgButton.selected
    // @include statefulCanvas.selected
    // @visibility external
    //<
    //> @method imgButton.select()
    // @include statefulCanvas.select
    // @visibility external
    //<
    //> @method imgButton.deselect()
    // @include statefulCanvas.select
    // @visibility external
    //<
    //> @method imgButton.isSelected()
    // @include statefulCanvas.isSelected
    // @visibility external
    //<
    //> @method imgButton.setSelected()
    // @include statefulCanvas.select
    // @visibility external
    //<

    // radioGroup
    //-----------
    //> @attr imgButton.radioGroup
    // @include statefulCanvas.radioGroup
    // @visibility external
    // @example buttonRadioToggle
    //<
    //> @method imgButton.addToRadioGroup()
    // @include statefulCanvas.addToRadioGroup
    // @visibility external
    //<
    //> @method imgButton.removeFromRadioGroup()
    // @include statefulCanvas.removeFromRadioGroup
    // @visibility external
    //<
    //> @attr imgButton.actionType
    // @include statefulCanvas.actionType
    // @visibility external
    // @example buttonRadioToggle
    //<
    //> @method imgButton.setActionType()
    // @include statefulCanvas.setActionType
    // @visibility external
    //<
    //> @method imgButton.getActionType()
    // @include statefulCanvas.getActionType
    // @visibility external
    //<

    // state
    //------
    //> @attr imgButton.state
    // @include statefulCanvas.state
    // @visibility external
    //<
    //> @method imgButton.setState()
    // @include statefulCanvas.setState
    // @visibility external
    //<
    //> @method imgButton.setDisabled()
    // @include statefulCanvas.setDisabled
    // @visibility external
    //<

    //> @method imgButton.getState()
    // @include statefulCanvas.getState
    // @visibility external
    //<
    //> @attr imgButton.showDisabled
    // @include statefulCanvas.showDisabled
    // @visibility external
    //<
    //> @attr imgButton.showDown
    // @include statefulCanvas.showDown
    // @visibility external
    //<
    showDown:true,
    //> @attr imgButton.showFocus
    // @include statefulCanvas.showFocus
    // @visibility external
    //<
    //> @attr imgButton.showFocused
    // @include statefulCanvas.showFocused
    // @visibility external
    //<
    showFocused:true,
    //> @attr imgButton.showRollOver
    // @include statefulCanvas.showRollOver
    // @visibility external
    //<
    showRollOver:true,


    // alignment
    //----------
    //> @attr ImgButton.align
    // @include statefulCanvas.align
    // @visibility external
    //<
    //> @attr ImgButton.valign
    // @include statefulCanvas.valign
    // @visibility external
    //<


    // Button.action
    //> @method ImgButton.action()
    // @include statefulCanvas.action
    // @visibility external
    //<

    // ================= END StatefulCanvas @include block =============== //


    // Label
    // ---------------------------------------------------------------------------------------


    //> @attr ImgButton.showTitle (Boolean : false : [IRWA])
    // @include StatefulCanvas.showTitle
    // @visibility external
    //<
    showTitle:false,

    // Match the standard button's cursor
    cursor:isc.Button._instancePrototype.cursor,

    //>    @attr    ImgButton.labelHPad  (number : null : IRW)
    // Horizontal padding to be applied to this widget's label. If this value is null,
    // the label will be given a horizontal padding of zero.
    // <p>
    // The specified amount of padding is applied to the left and right edges of the button, so
    // the total amount of padding is 2x the specified value.
    //
    // @visibility external
    //<

    //>    @attr    ImgButton.labelVPad  (number : null : IRW)
    // Vertical padding to be applied to this widget's label. If this value is null,
    // the label will be given a vertial padding of zero.
    // <p>
    // The specified amount of padding is applied to the top and bottom edges of the button, so
    // the total amount of padding is 2x the specified value.
    //
    // @visibility external
    //<
    // Note: the labelHPad / vPad are inherited from the StatefulCanvas implementation - this will
    // actually check for labelLengthPad / labelBreadthPad and then be either zero or the
    // specified capSize for the widget.
    // However labelLengthPad / BreadthPad are not anticipated to be set for this class and
    // the capSize is defaulted to zero in StatefulCanvas.js so we can accurately doc the padding
    // as just defaulting to zero.

    // States
    // ---------------------------------------------------------------------------------------
    //> @attr ImgButton.src (SCImgURL | SCStatefulImgConfig : "[SKIN]/ImgButton/button.png" : IRW)
    // @include Img.src
    // @visibility external
    // @example buttonAppearance
    //<
    src:"[SKIN]/ImgButton/button.png",

    canFocus:true,

    //>    @attr ImgButton.overflow      (String : "hidden" : IRW)
    // Clip by default, because expanding to the label (if present) is likely to distort image
    //<
    overflow:isc.Canvas.HIDDEN
});

isc.ImgButton.addMethods({

getCanHover : function (a, b, c) {
    return this._canHover || this.invokeSuper(isc.ImgButton, "getCanHover", a, b, c);
},

//> @method imgButton.titleClipped() (A)
// Is the title of this button clipped?
// @return (boolean) whether the title is clipped.
// @visibility external
//<
titleClipped : function () {
    return (this.label == null ? false : this.label.titleClipped());
},

defaultTitleHoverHTML : function () {
    return (this.label == null ? null : this.label.defaultTitleHoverHTML());
},

//> @method imgButton.titleHoverHTML()
// Returns the HTML that is displayed by the default +link{ImgButton.titleHover(),titleHover}
// handler. Return null or an empty string to cancel the hover.
// <smartgwt><p>Use <code>setTitleHoverFormatter()</code> to provide a custom
// implementation.</smartgwt>
// @param defaultHTML (HTMLString) the HTML that would have been displayed by default
// @return (HTMLString) HTML to be displayed in the hover. If null or an empty string, then the hover
// is canceled.
// @visibility external
//<
titleHoverHTML : function (defaultHTML) {
    return defaultHTML;
},

handleHover : function (a, b, c) {
    // If there is a prompt, prefer the standard hover handling.
    if (this.canHover == null && this.prompt) return this.invokeSuper(isc.ImgButton, "handleHover", a, b, c);

    if (!this.showClippedTitleOnHover || !this.titleClipped()) {
        if (this.canHover) return this.invokeSuper(isc.ImgButton, "handleHover", a, b, c);
        else return;
    }

    if (this.titleHover && this.titleHover() == false) return;

    var HTML = this.titleHoverHTML(this.defaultTitleHoverHTML());
    if (HTML != null && !isc.isAn.emptyString(HTML)) {
        var hoverProperties = this._getHoverProperties();
        isc.Hover.show(HTML, hoverProperties, null, this);
    }
}

});

isc.ImgButton.registerStringMethods({
    //> @method imgButton.titleHover()
    // Optional stringMethod to fire when the user hovers over this button and the title is
    // clipped. If +link{ImgButton.showClippedTitleOnHover} is true, the default behavior is to
    // show a hover canvas containing the HTML returned by +link{ImgButton.titleHoverHTML()}.
    // Return false to suppress this default behavior.
    // @return (boolean) false to suppress the standard hover
    // @see ImgButton.titleClipped()
    // @group hovers
    // @visibility external
    //<
    titleHover:""
});









//>    @class    StretchImgButton
// A StretchImg that behaves like a button, going through up/down/over state transitions in response
// to user events.  Supports an optional title, and will auto-size to accommodate the title text if
// <code>overflow</code> is set to "visible".
// <P>
// Examples of use include fancy buttons, poplist headers, and tabs.
//
// @inheritsFrom StretchImg
// @treeLocation Client Reference/Control
// @visibility external
//<

isc.defineClass("StretchImgButton", "StretchImg").addProperties({

    // Various properties documented on StatefulCanvas that affect all buttons
    // NOTE: This block is included in Button, ImgButton, and StretchImgButton.
    //       If you make changes here, make sure you duplicate it to the other
    //       classes.
    //
    // End of this block is marked with: END StatefulCanvas @include block
    // =========================================================================

    // Title
    //------
    //> @attr stretchImgButton.title
    // @include statefulCanvas.title
    // @visibility external
    //<
    //> @attr stretchImgButton.clipTitle
    // @include Button.clipTitle
    // @group appearance
    //<
    clipTitle:true,
    //>    @method    stretchImgButton.getTitle()    (A)
    // @include statefulCanvas.getTitle
    // @visibility external
    //<
    //>    @method    stretchImgButton.setTitle()
    // @include statefulCanvas.setTitle
    // @visibility external
    //<
    //> @attr stretchImgButton.showClippedTitleOnHover
    // @include Button.showClippedTitleOnHover
    // @group hovers
    // @visibility external
    //<
    showClippedTitleOnHover:false,
    _canHover:true,

    //> @attr   stretchImgButton.wrap   (boolean : null : IRW)
    // Should the title for this button wrap? If unset, default behavior is to allow wrapping
    // if this.vertical is true, otherwise disallow wrapping
    // @visibility external
    //<


    // Icon
    //------

    // set useEventParts to true so we can have a separate iconClick method
    useEventParts:true,

    //> @attr stretchImgButton.icon
    // @include statefulCanvas.icon
    // @visibility external
    //<
    //> @attr stretchImgButton.iconSize
    // @include statefulCanvas.iconSize
    // @visibility external
    //<
    //> @attr stretchImgButton.iconWidth
    // @include statefulCanvas.iconWidth
    // @visibility external
    //<
    //> @attr stretchImgButton.iconHeight
    // @include statefulCanvas.iconHeight
    // @visibility external
    //<
    //> @attr stretchImgButton.iconOrientation
    // @include statefulCanvas.iconOrientation
    // @visibility external
    //<
    //> @attr stretchImgButton.iconAlign
    // @include statefulCanvas.iconAlign
    // @visibility external
    //<
    //> @attr stretchImgButton.iconSpacing
    // @include statefulCanvas.iconSpacing
    // @visibility external
    //<
    //> @attr stretchImgButton.showDisabledIcon
    // @include statefulCanvas.showDisabledIcon
    // @visibility external
    //<
    //> @attr stretchImgButton.showRollOverIcon
    // @include statefulCanvas.showRollOverIcon
    // @visibility external
    //<
    //> @attr stretchImgButton.showFocusedIcon
    // @include statefulCanvas.showFocusedIcon
    // @visibility external
    //<
    //> @attr stretchImgButton.showDownIcon
    // @include statefulCanvas.showDownIcon
    // @visibility external
    //<
    //> @attr stretchImgButton.showSelectedIcon
    // @include statefulCanvas.showSelectedIcon
    // @visibility external
    //<
    //> @method stretchImgButton.setIconOrientation()
    // @include statefulCanvas.setIconOrientation
    // @visibility external
    //<
    //> @method stretchImgButton.setIcon()
    // @include statefulCanvas.setIcon
    // @visibility external
    //<

    // AutoFit
    //--------
    //> @attr stretchImgButton.autoFit
    // @include statefulCanvas.autoFit
    // @visibility external
    //<
    //> @method stretchImgButton.setAutoFit()
    // @include statefulCanvas.setAutoFit
    // @visibility external
    //<

    //> @attr stretchImgButton.width
    // @include statefulCanvas.width
    // @group sizing
    // @visibility external
    //<

    //> @attr stretchImgButton.height
    // @include statefulCanvas.height
    // @group sizing
    // @visibility external
    //<

    // baseStyle
    //----------
    //> @attr stretchImgButton.baseStyle (CSSStyleName : "stretchImgButton" : IRW)
    // @include statefulCanvas.baseStyle
    // @visibility external
    //<
    baseStyle:"stretchImgButton",
    //> @method stretchImgButton.setBaseStyle()
    // @include statefulCanvas.setBaseStyle
    // @visibility external
    //<

    //>    @attr stretchImgButton.titleStyle (CSSStyleName : null : IRW)
    // CSS style applied to the title text only.  Defaults to +link{baseStyle} when unset.
    // <P>
    // With a separate <code>titleStyle</code> and +link{baseStyle} set, you can provide a
    // backgroundColor via <code>baseStyle</code> that will allow translucent .png media to be
    // "tinted" by the underlying background color, so that a single set of media can provide
    // range of color options.  In this usage, the <code>titleStyle</code> should generally not
    // specify a background color as this would block out the media that appears behind the
    // title.
    //
    // @visibility external
    //<

    //>    @method stretchImgButton.setTitleStyle()
    // Sets the +link{titleStyle}, which is applied to the title text.
    // @param style (CSSStyleName) new title style
    // @visibility external
    //<

    //> @attr stretchImgButton.labelSkinImgDir (URL : null : IRWA)
    // Specifies a skinImgDir to apply to the label containing the title of this
    // StretchImgButton. May be null in which case <code>this.skinImgDir</code>
    // will be applied to the label as well.
    // <P>
    // Note that icons displayed in the title may make use of the skin img dir set here
    // @visibility external
    //<

    //> @method stretchImgButton.setLabelSkinImgDir()
    // setter for +link{stretchImgButton.labelSkinImgDir}.
    // @param URL (URL) new skin img dir to apply to the label holding title text for
    //   this widget.
    // @visibility external
    //<

    // selection
    //----------
    //> @attr stretchImgButton.selected
    // @include statefulCanvas.selected
    // @visibility external
    //<
    //> @method stretchImgButton.select()
    // @include statefulCanvas.select
    // @visibility external
    //<
    //> @method stretchImgButton.deselect()
    // @include statefulCanvas.select
    // @visibility external
    //<
    //> @method stretchImgButton.isSelected()
    // @include statefulCanvas.isSelected
    // @visibility external
    //<
    //> @method stretchImgButton.setSelected()
    // @include statefulCanvas.select
    // @visibility external
    //<

    // radioGroup
    //-----------
    //> @attr stretchImgButton.radioGroup
    // @include statefulCanvas.radioGroup
    // @visibility external
    //<
    //> @method stretchImgButton.addToRadioGroup()
    // @include statefulCanvas.addToRadioGroup
    // @visibility external
    //<
    //> @method stretchImgButton.removeFromRadioGroup()
    // @include statefulCanvas.removeFromRadioGroup
    // @visibility external
    //<
    //> @attr stretchImgButton.actionType
    // @include statefulCanvas.actionType
    // @visibility external
    //<
    //> @method stretchImgButton.setActionType()
    // @include statefulCanvas.setActionType
    // @visibility external
    //<
    //> @method stretchImgButton.getActionType()
    // @include statefulCanvas.getActionType
    // @visibility external
    //<

    // state
    //------
    //> @attr stretchImgButton.state
    // @include statefulCanvas.state
    // @visibility external
    //<
    //> @method stretchImgButton.setState()
    // @include statefulCanvas.setState
    // @visibility external
    //<
    //> @method stretchImgButton.setDisabled()
    // @include statefulCanvas.setDisabled
    // @visibility external
    //<
    //> @method stretchImgButton.getState()
    // @include statefulCanvas.getState
    // @visibility external
    //<
    //> @attr stretchImgButton.showDisabled
    // @include statefulCanvas.showDisabled
    // @visibility external
    //<
    //> @attr stretchImgButton.showDown
    // @include statefulCanvas.showDown
    // @visibility external
    //<
    showDown:true,
    //> @attr stretchImgButton.showFocus
    // @include statefulCanvas.showFocus
    // @visibility external
    //<
    //> @attr stretchImgButton.showFocused
    // @include statefulCanvas.showFocused
    // @visibility external
    //<
    showFocused:true,
    //> @attr stretchImgButton.showRollOver
    // @include statefulCanvas.showRollOver
    // @visibility external
    //<
    showRollOver:true,

    // alignment
    //----------
    //> @attr stretchImgButton.align
    // @include statefulCanvas.align
    // @visibility external
    //<
    //> @attr stretchImgButton.valign
    // @include statefulCanvas.valign
    // @visibility external
    //<


    // Button.action
    //> @method StretchImgButton.action()
    // @include statefulCanvas.action
    // @visibility external
    //<

    // ================= END StatefulCanvas @include block =============== //


    // Label
    // ---------------------------------------------------------------------------------------

    //> @attr StretchImgButton.showTitle (Boolean : true : IRW)
    // @include StatefulCanvas.showTitle
    // @visibility external
    //<
    showTitle:true,

    //>    @attr    StretchImgButton.labelHPad  (number : null : IRW)
    // The padding for a StretchImgButton's label is determined as follows.
    // <P>
    // If <code>labelHPad</code> is set it will specify the horizontal padding applied to the
    // label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding
    // for the label, regardless of the button's +link{StretchImgButton.vertical,vertical} setting.
    // <P>
    // Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the
    // length axis (ie: horizontal padding if +link{StretchImgButton.vertical} is false,
    // otherwise vertical padding), and
    // <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.
    // <P>
    // Otherwise the padding on the length axis will match the +link{StretchImgButton.capSize} and
    // will be set to zero on the breadth axis.
    // <P>
    // So by default the label will be sized to match the center image of the StretchImgButton, but
    // these settings allow the label to partially or wholly overlap the caps.
    // @visibility external
    //<


    //>    @attr    StretchImgButton.labelVPad  (number : null : IRW)
    // @include StretchImgButton.labelHPad
    // @visibility external
    //<

    //>    @attr    StretchImgButton.labelLengthPad  (number : null : IRW)
    // @include StretchImgButton.labelHPad
    // @visibility external
    //<

    //>    @attr    StretchImgButton.labelBreadthPad  (number : null : IRW)
    // @include StretchImgButton.labelHPad
    // @visibility external
    //<

    //> @attr stretchImgButton.hiliteAccessKey (Boolean : true: IRW)
    // @include statefulCanvas.hiliteAccessKey
    // @visibility external
    //<
    hiliteAccessKey:true,

    // States
    // ---------------------------------------------------------------------------------------

    //>    @attr    StretchImgButton.src        (SCImgURL : "button.gif" : IRW)
    // Base URL for the image.  By default, StretchImgButtons consist of three image parts: A
    // start image (displayed at the top or left), a scalable central image and an end image
    // displayed at the bottom or right.
    // <P>
    // The images displayed in the stretchImgButton are derived from this property in the
    // following way:
    // <P>
    // <ul>
    // <li> When the button is in its standard state the suffixes "_start", "_end" and
    //      "_stretch" are applied to the src (before the file extension), so by default
    //      the images displayed will be "button_start.gif" (sized to be
    //      <code>this.capSize</code> by the specified width of the stretchImgButton),
    //      "button_stretch.gif" (stretched to the necessary width) and "button_end.gif"
    //      (sized the same as the start image).
    // <li> As the button's state changes, the images will have suffixes appended <b>before</b>
    //      the "_start" / "_end" / "_stretch" to represent the button state.
    //      See +link{Img.src} for an overview of how states are combined into a compound
    //      URL.
    // </ul>
    // For example the center piece of a selected stretchImgButton with the mouse hovering
    // over it might have the URL: <code>"button_Selected_Down_stretch.gif"</code>.
    // <P>
    // Media should be present for each possible state of the _start, _end and _stretch images.
    //
    // @visibility external
    //<
    src:"[SKIN]/button/button.png",

    //>    @attr    StretchImgButton.vertical        (Boolean : false : IRW)
    // Default is a horizontal button.  Vertical StretchImgButtons are allowed, but title text,
    // if any, will not be automatically rotated.
    //
    // @group appearance
    // @visibility external
    //<
    vertical:false,

    //>    @attr    StretchImgButton.capSize        (number : 12 : IRW)
    // How big are the end pieces by default
    // @group appearance
    // @visibility external
    //<
    capSize:12,

    // Override autoFitDirection - we only want the button to resize horizontally since
    // otherwise the media gets stretched.
    autoFitDirection:"horizontal",

    // ---------------------------------------------------------------------------------------
    // Match the standard button's cursor
    cursor:isc.Button._instancePrototype.cursor,

    canFocus:true

});

isc.StretchImgButton.addMethods({

getCanHover : function (a, b, c) {
    return this._canHover || this.invokeSuper(isc.StretchImgButton, "getCanHover", a, b, c);
},

//> @method stretchImgButton.titleClipped() (A)
// Is the title of this button clipped?
// @return (boolean) whether the title is clipped.
// @visibility external
//<
titleClipped : function () {
    return (this.label == null ? false : this.label.titleClipped());
},

defaultTitleHoverHTML : function () {
    return (this.label == null ? null : this.label.defaultTitleHoverHTML());
},

//> @method stretchImgButton.titleHoverHTML()
// Returns the HTML that is displayed by the default +link{StretchImgButton.titleHover(),titleHover}
// handler. Return null or an empty string to cancel the hover.
// <smartgwt><p>Use <code>setTitleHoverFormatter()</code> to provide a custom
// implementation.</smartgwt>
// @param defaultHTML (HTMLString) the HTML that would have been displayed by default
// @return (HTMLString) HTML to be displayed in the hover. If null or an empty string, then the hover
// is canceled.
// @visibility external
//<
titleHoverHTML : function (defaultHTML) {
    return defaultHTML;
},

handleHover : function (a, b, c) {
    // If there is a prompt, prefer the standard hover handling.
    if (this.canHover == null && this.prompt) return this.invokeSuper(isc.StretchImgButton, "handleHover", a, b, c);

    if (!this.showClippedTitleOnHover || !this.titleClipped()) {
        if (this.canHover) return this.invokeSuper(isc.StretchImgButton, "handleHover", a, b, c);
        else return;
    }

    if (this.titleHover && this.titleHover() == false) return;

    var HTML = this.titleHoverHTML(this.defaultTitleHoverHTML());
    if (HTML != null && !isc.isAn.emptyString(HTML)) {
        var hoverProperties = this._getHoverProperties();
        isc.Hover.show(HTML, hoverProperties, null, this);
    }
}

});

isc.StretchImgButton.registerStringMethods({
    //> @method stretchImgButton.iconClick()
    // If this button is showing an +link{StretchImgButton.icon, icon}, a separate click
    // handler for the icon may be defined as <code>this.iconClick</code>.
    // Returning false will suppress the standard button click handling code.
    // @return (boolean) false to suppress the standard button click event
    // @group buttonIcon
    // @visibility external
    //<
    iconClick:"",

    //> @method stretchImgButton.titleHover()
    // Optional stringMethod to fire when the user hovers over this button and the title is
    // clipped. If +link{StretchImgButton.showClippedTitleOnHover} is true, the default behavior is to
    // show a hover canvas containing the HTML returned by +link{StretchImgButton.titleHoverHTML()}.
    // Return false to suppress this default behavior.
    // @return (boolean) false to suppress the standard hover
    // @see StretchImgButton.titleClipped()
    // @group hovers
    // @visibility external
    //<
    titleHover:""
})




//>    @class Notify
// Notify provides a means to display on-screen messages that are automatically dismissed after
// a configurable amount of time, as an alternative to +link{isc.confirm(),modal notification}
// dialogs that can lower end user productivity.  Messages may be shown at a particular
// location, specified either with viewport-relative coordinates, or as an edge or center
// location relative to the viewport or a canvas.  Messages can be configured to appear and
// disappear instantly, by sliding into (or out of) view, or by fading in (or out).
// <P>
// One or more +link{NotifyAction,actions} can be provided when +link{Notify.addMessage(),
// addMessage()} is called to display a message.  They will be rendered as links on which to
// click to execute the action.
// <P>
// The behavior and appearance of messages are configured per +link{NotifyType}, which is simply
// a string that identifies that message group, similar to +link{class.logWarn(),log category}.
// By calling +link{Notify.configureMessages(),configureMessages()} with the
// <code>NotifyType</code>, it can be assigned a +link{NotifySettings} configuration to control
// message animation, placement, and the the +link{Label} used to render each message, allowing
// styling and autofit behavior to be configured.
// <P>
// Messages of the same <code>NotifyType</code> may be stacked to provide a visible
// history, with a configurable stacking direction and maximum stacking depth.  Details on how
// to configure messages are provided in the documentation for +link{NotifySettings}.
// <P>
// Messages for different <code>NotifyType</code>s are stacked separately and animated by
// independent Framework pipelines.  It's up to you to configure the placement of supported
// <code>NotifyType</code>s in your app so that they don't overlap, as the Framework doesn't
// manage it.  For example, separate <code>NotifyType</code>s could be assigned separate screen
// edges, or assigned a different +link{notifySettings.positionCanvas}.
// <P>
// To dismiss a message manually before its scheduled duration expires, you may call
// +link{Notify.dismissMessage(),dismissMessage()} with a <code>NotifyType</code> (to dismiss
// all such messages) or an ID previously returned by +link{Notify.addMessage(),addMessage()}
// (to dismiss that single message).
// <P>
// <B>Warnings and Errors</B>
// <P>
// Each notification may be assigned a +link{NotifySettings.messagePriority,messagePriority} in
// the settings passed to +link{notify.addMessage(),addMessage()}.  By default, all
// <code>NotifyType</code>s are configured to have priority +link{Notify.MESSAGE}, except for
// "error" and "warn" <code>NotifyType</code>s, which are configured with priority
// +link{Notify.ERROR} and +link{Notify.WARN}, respectively.
// <P>
// The +link{NotifySettings.messagePriority,messagePriority} determines the default styling of a
// message, and which message to remove if a new message is sent while the message stack is
// already at its limit.  We recommended applying a +link{NotifySettings.messagePriority,
// messagePriority} as the best approach for showing pre-styled warnings and errors, since that
// allows you to interleave them with ordinary messages in a single <code>NotifyType</code>.
// <P>
// Alternatively, you can display pre-styled warnings and errors by calling
// +link{notify.addMessage(),addMessage()} with the separate <code>NotifyType</code>s
// "warning" and "error", respectively, but then you must take care to
// +link{notify.configureMessages(),assign each NotifyType} used to a separate screen
// location to avoid one rendering on top of the other.
// <P>
// <B>Viewport Considerations</B>
// <P>
// Messages are edge or corner-aligned based on the +link{page.getScrollWidth(),viewport width}
// and +link{page.getScrollHeight(),viewport height} of the current page rather than screen, so
// you may need to scroll to see the targeted corner or edge.  Note that widgets placed
// offscreen below or to the right of a page may cause the browser to report a larger viewport,
// and prevent messages from being visible, even if no scrollbars are present.  If you need to
// stage widgets offscreen for measurement or other reasons, place them above or to the left.
// <P>
// <B>Modal Windows and Click Masks</B>
// <P>
// Messages are always shown above all other widgets, including +link{window.isModal,
// modal windows} and +link{canvas.showClickMask(),click masks}.  This is because it's expected
// that messages are "out of band" and logically indepedent of the widget hierarchy being shown.
// We apply this layering policy even for windows and widgets created by +link{notifyAction}s.
// If there may a scenario where a message can block a window created by an action, set
// +link{notifySettings.canDismiss} to true so that an unobstructed view of the underlying
// widgets can be restored.
// <P>
// In the linked sample, note how we take care to reuse the existing modal window, if any, if
// the "Launch..." link is clicked, so that repeated clicks never stack windows over each other.
//
// @see isc.say()
// @see isc.confirm()
// @treeLocation Client Reference/Control
// @example notifications
// @visibility external
//<

isc.Notify.addClassMethods({
    _$message: "message",
    _$warn:    "warn",
    _$error:   "error",

    settings: {},
    typeState: {},

    _initializeSettings : function () {
        this._settingsInitialized = true;
        this.configureMessages(this._$message, this._initNotifySettings(this._$message));
        this.configureMessages(this._$warn,    this._initNotifySettings(this._$warn));
        this.configureMessages(this._$error,   this._initNotifySettings(this._$error));
    },

    //> @object MessageID
    // Opaque message identifier for messages shown by the +link{Notify} class
    // @treeLocation Client Reference/Control/Notify
    // @visibility external
    //<


    ////////////////////////////////////////////////////////////////////////////////
    // New Message

    //> @classMethod Notify.addMessage()
    // Displays a new message, subject to the +link{configureMessages(),stored configuration}
    // for the passed <code>notifyType</code>, overridden by any passed <code>settings</code>.
    // Returns an opaque <code>MessageID</code> that can be passed to +link{dismissMessage()}
    // to clear it.
    // <P>
    // Note that an empty string may be passed for <code>contents</code> if <code>actions</code>
    // have been provided, so you may have the message consist only of your specified actions.
    // <P>
    // Most users should do all configuration up front via a call to +link{configureMessages()}.
    // The <code>settings</code> argument in this method is provided to allow adjustment of
    // properties that affect only one message, such as +link{NotifySettings.autoFitWidth,
    // autoFitWidth}, +link{NotifySettings.styleName,styleName}, or
    // +link{NotifySettings.labelProperties,labelProperties}.  Making changes to
    // +link{multiMessageMode,stacking}-related properties via this argument isn't supported,
    // unless specifically documented on the property.
    //
    // @param  contents     (HTMLString)             message to be displayed
    // @param  [actions]    (Array of NotifyAction)  actions (if any) for this message
    // @param  [notifyType] (NotifyType)             category of message; default "message"
    // @param  [settings]   (NotifySettings)         display and behavior settings for
    //                                               this message that override the
    //                                               +link{configureMessages(),configured}
    //                                               settings for the <code>notifyType</code>
    // @return  (MessageID)  opaque identifier for message
    // @see isc.say()
    // @see isc.confirm()
    // @see isc.notify()
    // @visibility external
    //<
    addMessage : function (contents, actions, notifyType, settings) {
        // sanity check - we require contents or at least one titled NotifyAction
        if (!contents && !this._hasTitledActions(actions)) {
            this.logWarn("addMessage(): you must either provide valid contents for " +
                         "the message, or at least one NotifyAction with a title", "notify");
            return;
        }

        if (!notifyType) notifyType = this._$message;

        // create default NotifySettings for NotifyType if needed
        var typeSettings = this.settings[notifyType];
        if (!typeSettings) {
            this.configureMessages(notifyType);
            typeSettings = this.settings[notifyType];
        }


        // passed settings override configured settings for notifyType
        settings = this._filterCustomSettings(settings, typeSettings);

        // create a new typeState for this notifyType if needed
        var typeState = this.typeState[notifyType];
        if (!typeState) {
            typeState = this.typeState[notifyType] = {
                notifyType: notifyType,
                pendingQueue: [],
                liveMessages: [],
                dismissQueue: [],
                replaceQueue: []
            };
        }

        // message state/config
        var messageState = {
            contents: contents,
            actions:  actions,
            settings: settings
        };


        var ready = this._prepareForNewMessage(typeState, settings);
        if (ready) {
            this._addMessage(typeState, messageState);
            if (this.logIsDebugEnabled("notify")) {
                this.logDebug("addMessage(): showing message with notifyType: " +
                              notifyType + " and contents: '" + contents + "'", "notify");
            }
        } else {
            typeState.pendingQueue.add(messageState);
            if (this.logIsInfoEnabled("notify")) {
                this.logInfo("addMessage(): queuing message with notifyType: " +
                             notifyType + " and contents: '" + contents + "'", "notify");
            }
        }

        return {notifyType: notifyType, messageState: messageState};
    },

    _addMessage : function (typeState, messageState) {


        typeState.liveMessages.add(messageState);

        this._createMessageLabel(typeState, messageState);



        var stackCoords, settings = messageState.settings,
            messageCoords = this._getMessageCoords(typeState, messageState)
        ;

        // create stack if stacking messages and compute its position
        if (settings.multiMessageMode == "stack") {
            if (typeState.stack == null) {
                var direction = settings.stackDirection,
                    vertical = direction == "up" || direction == "down",
                    stackClass = vertical ? isc.VStack : isc.HStack
                ;
                typeState.stack = stackClass.create({
                    left: messageCoords[0],
                    top: messageCoords[1],
                    width: 1, height: 1,
                    _zLayerName:"_notify",

                    instantRelayout: true, autoDraw: true,
                    membersMargin: settings.stackSpacing,


                    _setAnimation : function (effect, time) {
                        this.setProperties({
                            animateMembers: true,
                            animateMemberTime: time,
                            animateMemberEffect: effect
                        });
                    },
                    _clearAnimation : function () {
                        this.setProperty("animateMembers", false);
                    }
                });
                // If the stack is not drawn (for example, `isc.noAutoDraw` was set), then
                // explicitly draw it.
                if (!typeState.stack.isDrawn()) typeState.stack.draw();
                typeState.stack.bringToFront();


                typeState.placeholder = isc.Canvas.create({
                    opacity: 0, top: -1000,
                    _zLayerName: "_notify"
                });
            } else {
                var stack = typeState.stack;
                if (!stack.members.length) {
                    stack.moveTo(messageCoords[0], messageCoords[1]);
                }
            }
            // message coords are affected by stacking, so (re)compute message and stack coords
            stackCoords = this._getStackCoords(typeState, messageState, false);
            messageCoords = this._getStackedMessageCoords(typeState, messageState, stackCoords);
        }

        var stack = typeState.stack,
            label = messageState.label,
            liveMessages = typeState.liveMessages;


        var appearMethod = settings.appearMethod;
        if (this.logIsDebugEnabled("notify")) {
            this.logDebug("addMessage(): starting message animation: " + appearMethod +
                " to/at coordinates: " + messageCoords + " and stack slide to coordinates: " +
                stackCoords + " for notifyType: " + typeState.notifyType + " with contents: '" +
                messageState.contents + "'", "notify");
        }
        switch (appearMethod) {
        case "fade":

            if (liveMessages.length > 1) {
                this._prepSlideStack(typeState, messageState, messageCoords, stackCoords);
            } else {
                this._fadeInMessage(typeState, messageState, messageCoords, stackCoords);
            }
            break;
        case "slide":
            this._slideInMessage(typeState, messageState, messageCoords, stackCoords);
            break;
        case "instant":
        default:
            if (stack) this._addLabelToStack(typeState, messageState, stackCoords);
            else label.moveTo(messageCoords[0], messageCoords[1]);
            break;
        }

        // if a non-zero duration was supplied, the message will auto-dismiss after it elapses
        if (settings.duration) this._scheduleMessageDismissal(typeState, messageState);
    },


    _crossMessageProps : [
        "multiMessageMode", "stackDirection", "maxStackSize", "maxStackDismissMode",
        "stackSpacing", "repositionMethod"
    ],

    // return new NotifySettings representing only allowed overrides of the configured settings
    _filterCustomSettings : function (changedSettings, configuredSettings) {
        // return configured settings if no settings changed
        if (!changedSettings) return configuredSettings;

        var violation,
            propsToRemove = this._crossMessageProps,
            filtered = isc.addProperties({}, changedSettings)
        ;
        // remove setting and warn for props that we can't customize
        for (var i = 0; i < propsToRemove.length; i++) {
            var prop = propsToRemove[i];
            if (prop in filtered) {
                delete filtered[prop];
                violation = true;
            }
        }
        if (violation) {
            this.logWarn("addMessage(): you cannot change stack properties in a call to " +
                "addMessage() - they can only be set through configureMessages()", "notify");
        }

        // apply priority-related defaults if appropriate (requires messagePriority, etc.)
        if (this._shouldApplyPriorityToAppearance(filtered, configuredSettings)) {
            var messagePriority = filtered.messagePriority,
                prioritySettings = this._getConfigSettingsByPriority(messagePriority);
            for (var prop in this._messageDefaults) {
                if (!(prop in filtered)) filtered[prop] = prioritySettings[prop];
            }
        }

        return isc.addDefaults(filtered, configuredSettings);
    },

    _hasTitledActions : function (actions) {
        if (!actions) return false;
        for (var i = 0; i < actions.length; i++) {
            if (actions[i].title) return true;
        }
        return false;
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Message Dismissal

    //> @classMethod Notify.dismissMessage()
    // Dismisses one or more messages currently being shown, subject to the existing settings
    // for their +link{NotifyType}.  You may either pass the opaque message identifier returned
    // from the call to +link{addMessage()} to dismiss a single message, or a
    // <code>NotifyType</code> to dismiss all such messages.
    // @param messageID  (MessageID | NotifyType)  message identifier or category to dismiss
    // @see notifySettings.duration
    // @see notifyAction.wholeMessage
    // @visibility external
    //<
    dismissMessage : function (messageID) {
        if (this._isValidMessageID(messageID)) {
            var typeState = this.typeState[messageID.notifyType];
            this._dismissMessage(typeState, messageID.messageState);

        } else if (isc.isA.String(messageID)) {
            var typeState = this.typeState[messageID];
            if (typeState) {
                if (this.logIsInfoEnabled("notify")) {
                    this.logInfo("dismissMessage(): dismissing all messages for " +
                                 "notifyType: " + typeState.notifyType, "notify");
                }

                var pendingQueue = typeState.pendingQueue.duplicate();
                for (var i = 0; i < pendingQueue.length; i++) {
                    this._dismissMessage(typeState, pendingQueue[i]);
                }
                var liveMessages = typeState.liveMessages.duplicate();
                for (var i = 0; i < liveMessages.length; i++) {
                    this._dismissMessage(typeState, liveMessages[i]);
                }
            }
        } else {
            this.logWarn("dismissMessage(): " + messageID + " is neither a valid " +
                         "messageID nor a valid notifyType", "notify");
        }
    },

    _dismissMessage : function (typeState, messageState) {


        var notifyType = typeState.notifyType,
            pendingQueue = typeState.pendingQueue,
            liveMessages = typeState.liveMessages,
            dismissQueue = typeState.dismissQueue,
            contents = messageState.contents
        ;

        if (!this._canDismissMessage(typeState, messageState)) {
            this.logWarn("dismissMessage(): can't dismiss messageID with notifyType: " +
                notifyType + "and contents: ;" + contents + "' as it can't be found", "notify");
            return;
        }

        // if the message hasn't yet been shown, we can just remove it instantly
        if (pendingQueue.contains(messageState)) {
            if (this.logIsDebugEnabled("notify")) {
                this.logDebug("dismissMessage(): removing message with notifyType: " +
                              notifyType + " and contents: '" + contents +
                              "' from the 'pending add' message queue", "notify");
            }
            pendingQueue.remove(messageState);
            return true;
        }

        // if the message has already been dismissed, then there's nothing to do
        if (dismissQueue.contains(messageState) ||
            typeState.opMessage == messageState && messageState.dismissed)
        {
            if (this.logIsInfoEnabled("notify")) {
                this.logInfo("dismissMessage(): message with notifyType: " +
                             notifyType + " and contents: '" + contents +
                             "' has already been dismissed or queued for dismissal", "notify");
            }
            return false;
        }

        // if we're busy with some other animation, then we've got to queue the dismiss
        if (typeState.op != null) {
            if (this.logIsInfoEnabled("notify")) {
                this.logInfo("dismissMessage(): queuing message with notifyType: " +
                    notifyType + " and contents: '" + contents + "' for dismissal", "notify");
            }
            dismissQueue.add(messageState);
            return false;
        }



        // clear the timer for the message, if any
        if (messageState.dismissEvent) {
            isc.Timer.clear(messageState.dismissEvent);
            messageState.dismissEvent = null;
        }
        messageState.dismissed = true;

        var stackCoords,
            stack = typeState.stack,
            label = messageState.label,
            settings = messageState.settings
        ;
        if (stack) stackCoords = this._getStackCoords(typeState, messageState, true);

        var disappearMethod = settings.disappearMethod;
        if (this.logIsDebugEnabled("notify")) {
            var messageCoords = [label.getPageLeft(), label.getPageTop()];
            this.logDebug("dismissMessage(): starting message animation: " +
                disappearMethod + " from/at coordinates: " + messageCoords + " and stack " +
                "slide to coordinates: " + stackCoords + " for notifyType: " + notifyType +
                " with contents: '" + contents + "'", "notify");
        }
        switch (disappearMethod) {
        case "fade":
            this._fadeOutMessage(typeState, messageState, stackCoords);
            return false;
        case "slide":
            this._slideOutMessage(typeState, messageState, stackCoords);
            return false;
        case "instant":
        default:

            typeState.liveMessages.remove(messageState);
            if (stack) {
                stack.moveTo(stackCoords[0], stackCoords[1]);
                stack.removeMember(label);
            }
            if (label) label.destroy();
            return true;
        }
    },

    _scheduleMessageDismissal : function (typeState, messageState) {
        var settings = messageState.settings,
            duration = settings.duration
        ;


        if (settings.stackPersistence == "reset") {
            var messages = typeState.liveMessages,
                dismissed = typeState.dismissQueue,
                resetCutoff = isc.timeStamp() + duration
            ;
            for (var i = 0; i < messages.length - 1; i++) {

                var dismissEvent = messages[i].dismissEvent;
                if (dismissEvent && !dismissed.contains(messages[i]) &&
                    isc.Timer.getTimeoutFireTime(dismissEvent) < resetCutoff)
                {
                    isc.Timer.clear(dismissEvent);


                    var messageToReset = messages[i]; // fix message for closure!
                    messageToReset.dismissEvent = isc.Timer.setTimeout(
                        function () {
                            isc.Notify._dismissMessage(typeState, messageToReset);
                        },
                        duration - messages.length + i + 1,
                        null, null,
                        // mark as backgroundRepeatTimer - this is not a blocking UI
                        true
                    );

                    if (this.logIsInfoEnabled("notify")) {
                        this.logInfo("addMessage(): reset message with notifyType: " +
                                     typeState.notifyType + " and contents: '" +
                                     messageToReset.contents + "' to auto-dismiss after " +
                                     duration + "ms to match new message's duration", "notify");
                    }
                }
            }
        }

        // Mark as background timer event - this is not a blocking UI
        messageState.dismissEvent = isc.Timer.setTimeout(function () {
            isc.Notify._dismissMessage(typeState, messageState);
        }, duration, null, null, true);
    },

    _isValidMessageID : function (messageID) {
        if (messageID == null) return false;
        var notifyType = messageID.notifyType;
        return notifyType != null && this.typeState[notifyType] && messageID.messageState;
    },

    //> @classMethod Notify.canDismissMessage()
    // Can the message corresponding to the <code>messageID</code> be dismissed?  Returns false
    // if the message is no longer being shown.  The <code>messageID</code> must have been
    // previously returned by +link{addMessage}.
    // @param messageID  (MessageID)  message identifier to dismiss
    // @return (boolean) whether message can be dismissed
    // @see dismissMessage
    // @visibility external
    //<
    canDismissMessage : function (messageID) {
        if (this._isValidMessageID(messageID)) {
            var typeState = this.typeState[messageID.notifyType];
            return this._canDismissMessage(typeState, messageID.messageState);

        }
        isc.logWarn("canDismissMessage(): " + messageID + " isn't a valid messageID",
                    "notify");
        return false;
    },

    _canDismissMessage : function (typeState, messageState) {
        return typeState.pendingQueue.contains(messageState) ||
               typeState.liveMessages.contains(messageState) ||
               typeState.dismissQueue.contains(messageState);
    },

    _destroyMessages : function (notifyType) {
        var settings = this.settings[notifyType],
            typeState = this.typeState[notifyType];


        // destroy messages and cancel timeouts
        var messages = typeState.liveMessages;
        for (var i = 0; i < messages.length; i++) {
            var messageState = messages[i],
                label = messageState.label;
            if (label) label.destroy();

            var dismissEvent = messageState.dismissEvent;
            if (dismissEvent) isc.Timer.clear(dismissEvent);
        }

        // destroy stack widget (if any)
        var stack = typeState.stack;
        if (stack) stack.destroy();

        // wipe out notifyType's typeState
        delete this.typeState[notifyType];
    },

    _destroyAllMessages : function () {
        for (var typeState in this.typeState) {
            this._destroyMessages(typeState);
        }
    },

    ////////////////////////////////////////////////////////////////////////////////
    // Message Configuration

    //> @classMethod Notify.configureMessages()
    // Sets the default +link{NotifySettings} for the specified +link{NotifyType}.  This
    // may be overridden by passing settings to +link{addMessage()} when the message
    // is shown, but changing +link{multiMessageMode,stacking}-related properties via
    // +link{addMessage()} isn't supported,
    // <P>
    // By default, the +link{NotifyType}s "message", "warn", and "error" are predefined, each
    // with their own +link{NotifySettings} with different +link{NotifySettings.styleName,
    // styleName}s.  When configuring a new (non-predefined) NotifyType with this method, any
    // +link{NotifySettings} left unset will default to those for NotifyType "message".
    //
    // @param  notifyType  (NotifyType)      category of message; null defaults to "message"
    // @param  settings    (NotifySettings)  settings to store for the <code>notifyType</code>
    // @see configureDefaultSettings
    // @visibility external
    //<
    configureMessages : function (notifyType, settings) {
        // initialize the default notifyType categories lazily now
        if (!this._settingsInitialized) this._initializeSettings();

        // if needed, default notifyType to "message"
        if (!notifyType) notifyType = this._$message;

        // if the previous configuration has already been used, we must clear out all state
        if (this.typeState[notifyType]) {
            if (this.logIsInfoEnabled("notify")) {
                this.logInfo("configureMessages(): destroying all state and widgets " +
                    "associated with the current configuration of notifyType: " + notifyType,
                    "notify");
            }
            this._destroyMessages(notifyType);
        }

        // initialize new NotifySettings with defaults, or update existing NotifySettings
        var typeSettings = this.settings[notifyType];
        if (typeSettings) isc.addProperties(typeSettings, settings);
        else this.settings[notifyType] = this._initNotifySettings(notifyType, settings);

        this.logInfo("configureMessages(): Changed settings for NotifyType: " + notifyType,
                     "notify");
    },

    //> @classMethod Notify.configureDefaultSettings()
    // Changes the default settings that are applied when you create a new +link{NotifyType}
    // with +link{configureMessages()}.  If you want to change the defaults for the built-in
    // NotifyTypes "message", "warn", and "error", with this method, it must be called before
    // the first call to +link{configureMessages()} or +link{addMessage()}.  Once a NotifyType
    // has been created, you must use +link{configureMessages()} to change its settings.
    // <P>
    // Note that for defaults that depend on priority (and thus differ between the built-in
    // NotifyTypes), this method only sets the defaults for the "message" NotifyType.
    //
    // @param  settings  (NotifySettings)  changes to NotifyType defaults
    // @see configureMessages
    // @visibility external
    //<
    configureDefaultSettings : function (settings) {
        var commonDefaults = this.commonDefaults,
            priorityDefaults = this._messageDefaults;
        // update global NotifyType defaults or priority-related "message" notifyType defaults
        for (var prop in settings) {
            var targetDefaults = prop in priorityDefaults ? priorityDefaults : commonDefaults;
            targetDefaults[prop] = settings[prop];
        }
        this.logInfo("configureDefaultSettings(): Changed global defaults for new NotifyTypes",
                     "notify");
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Message Content Update

    //> @classMethod Notify.setMessageContents() [A]
    // Updates the contents of the message from what was passed originally to
    // +link{addMessage()}, while preserving any existing +link{NotifyAction,actions}.
    // <P>
    // The purpose of this method is to support messages that contain timer countdowns or other
    // data that perhaps need refreshing during display.  If you find yourself replacing the
    // entire content with something new, you should probably just add it as a new message.
    // <P>
    // Note that this method has minimal animation support.  The change in message content and
    // corresponding resizing are instant, but the repositioning of the message or stack (if
    // stacked) to keep your requested +link{notifySettings.position,alignment} is controlled
    // by +link{notifySettings.repositionMethod}, allowing slide animation.  However, that
    // setting is ignored and the repositioning is instant if you've chosen
    // +link{notifySettings.positionCanvas,viewport alignment} to a border or corner along
    // the +link{notifySettings.position,bottom or right} viewport edge, or if an animation is
    // already in progress, in which case the instant repositioning will happen after it
    // completes.
    // @param  messageID  (MessageID)   message identifier from +link{addMessage()}
    // @param  contents   (HTMLString)  updated message
    // @visibility external
    //<

    setMessageContents : function (messageID, contents, actions) {
        if (!this._isValidMessageID(messageID)) {
            this.logWarn("setMessageContents(): can't set contents - invalid messageID",
                         "notify");
            return;
        }
        var messageState = messageID.messageState,
            typeState = this.typeState[messageID.notifyType]
        ;


        if (!this._canDismissMessage(typeState, messageState)) {
            this.logInfo("setMessageContents(): that message was dismissed - nothing to do",
                         "notify");
            return;
        }

        var undef;

        // default method arguments from existing message state
        if (contents == null) contents = messageState.contents;
        if (actions === undef) actions = messageState.actions;

        // sanity check - we require contents or at least one titled NotifyAction
        if (!contents & !this._hasTitledActions(actions)) {
            this.logWarn("setMessageContents(): you must either provide valid contents for " +
                         "the message, or at least one NotifyAction with a title", "notify");
            return;
        }
        // save changes to message state
        messageState.contents = contents;
        messageState.actions  = actions;

        if (this.logIsDebugEnabled("notify")) {
            this.logDebug("setMessageContents(): updating message with notifyType: " +
                messageID.notifyType + " to have contents: '" + contents + "'", "notify");
        }

        // if the message is queued, the label may not yet exist; we're done in that case
        if (!messageState.label) {
            if (this.logIsDebugEnabled("notify")) {
                this.logDebug("setMessageContents(): no label found - skipping widget update",
                              "notify");
            }
            return;
        }

        // update the message contents
        if (actions && actions.length) {
            var actionHTML = this._getActionHTML(messageState);
            if (actionHTML) contents = contents ? contents + actionHTML : actionHTML;
        }

        // if an animation is in progress, then queue the contents update

        if (typeState.op != null) {
            var replaceQueue = typeState.replaceQueue;
            if (!replaceQueue.contains(messageState)) {
                replaceQueue.add(messageState);
            }
            messageState._labelContents = contents;
            return;
        }


        this._setMessageContents(typeState, messageState, contents);
    },

    _setMessageContents : function (typeState, messageState, contents) {
        if (!this._canDismissMessage(typeState, messageState)) {
            this.logInfo("setMessageContents(): that message was dismissed - nothing to do",
                         "notify");
            return;
        }

        var label = messageState.label,
            settings = messageState.settings;


        // cache viewport size so we can restore bottom or right alignment
        var fixViewport = this._hasViewportDependentAlignment(settings);
        if (fixViewport) {
            this._pageWidth  = isc.Page.getScrollWidth();
            this._pageHeight = isc.Page.getScrollHeight();
        }




        label.setContents(contents);

        // recalculate the autofit based on new contents
        this._autoFitMessageContents(settings, label);

        // update cached message width and height

        label.redraw("contents changed");
        messageState.width  = label.getVisibleWidth();
        messageState.height = label.getVisibleHeight();

        // reposition stack or message now, instantly if on the bottom or right edge or delayed
        this._fixStackOrMessagePosition(typeState, fixViewport || messageState._labelContents);
        if (fixViewport) delete this._pageWidth, delete this._pageHeight;
    },


    _applyContentsToMessages : function (typeState) {
        var replaceQueue = typeState.replaceQueue;
        for (var i = 0; i < replaceQueue.length; i++) {
            var message = replaceQueue[i];
            this._setMessageContents(typeState, message, message._labelContents);
            delete message._labelContents;
        }
        replaceQueue.length = 0;
    },

    // along the bottom or right viweport edge, overflowed messages can expand the viewport
    _hasViewportDependentAlignment : function (settings) {
        if (settings.positionCanvas) return false;
        // we have viewport-based alignment; check for alignment along bottom or right
        var position = settings.position;
        return position ? position.indexOf("B") >= 0 || position.indexOf("R") >= 0 : false;
    },

    //> @classMethod Notify.setMessageActions()
    // Updates the actions of the message from those, if any, passed originally to
    // +link{addMessage()}, while preserving any existing +link{addMessage(),contents}.
    // <P>
    // See +link{setMessageContents()} for further guidance and animation details.
    // @param  messageID  (MessageID)  message identifier from +link{addMessage()}
    // @param  actions    (Array of NotifyAction)  updated actions for this message
    // @visibility external
    //<
    setMessageActions : function (messageID, actions) {
        this.setMessageContents(messageID, null, actions);
    },

    //> @classMethod Notify.messageHasActions()
    // @param   messageID  (MessageID)  message identifier to check
    // @return  (boolean)  whether message has any actions
    // @see addMessage()
    // @see setMessageActions()
    // @visibility external
    //<
    messageHasActions : function (messageID) {
        if (this._isValidMessageID(messageID)) {
            var messageState = messageID.messageState,
                actions = messageState ? messageState.actions : null;
            return actions && actions.length > 0;
        }
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Message Queue


    _prepareForNewMessage : function (typeState, settings) {
        var messages = typeState.liveMessages;
        if (messages.length == 0 ||
            settings.multiMessageMode == "stack" && messages.length < settings.maxStackSize)
        {
            return typeState.op == null;
        }
        var message = typeState.opMessage,
            dismiss = typeState.dismissQueue
        ;
        if (dismiss.length > 0 || message && message.dismissed) return false;

        // dismiss the least important message to make room for the new message
        var doomedMessage = this._getLeastImportantMessage(typeState, settings);
        return this._dismissMessage(typeState, doomedMessage);
    },


    _getLeastImportantMessage : function (typeState, settings) {
        var messages = typeState.liveMessages;

        if (messages.length == 1) return messages[0];

        // calculate the lowest priority (highest number) of any message
        var lowestPriority = 0;
        for (var i = 0; i < messages.length; i++) {
            var messageSettings = messages[i].settings;
            if (lowestPriority < messageSettings.messagePriority) {
                lowestPriority = messageSettings.messagePriority;
            }
        }
        // now trim to that priority the available candidates to dismiss
        messages = messages.filter(function (message) {
            return message.settings.messagePriority == lowestPriority;
        });

        // in "countdown" mode, pick the message with the least time left to live
        if (settings.maxStackDismissMode == "countdown" && messages.length > 1) {
            var lowestFireTime, dismissIndex;
            for (var i = messages.length - 1; i >= 0; i--) {
                var dismissEvent = messages[i].dismissEvent;
                if (!dismissEvent) continue;

                var fireTime = isc.Timer.getTimeoutFireTime(dismissEvent);
                if (lowestFireTime == null || fireTime < lowestFireTime) {
                    lowestFireTime = fireTime;
                    dismissIndex = i;
                }
            }
            // if any message had a timeout, we should have a dismissIndex
            if (dismissIndex != null) return messages[dismissIndex];
        }


        return messages[0];
    },

    // process pending dismiss requests and added messages

    _processMessageQueue : function (typeState) {
        var dismiss = typeState.dismissQueue;
        while (dismiss.length > 0 && typeState.op == null) {
            this._dismissMessage(typeState, dismiss.removeAt(0));
        }
        var pending = typeState.pendingQueue;
        while (pending.length > 0 && this._prepareForNewMessage(typeState, pending[0].settings))
        {
            this._addMessage(typeState, pending.removeAt(0));
        }
    },

    // for dismissals, we want to remove the message before procesing pending messages
    _completeMessageHandling : function (typeState, messageState, stackCoords, dismiss) {
        if (dismiss) {
            var stack = typeState.stack,
                label = messageState.label,
                messages = typeState.liveMessages
            ;

            if (label) label.destroy();
            messages.remove(messageState);

            if (stack && !messages.length) {
                //stack.moveTo(stackCoords[0], stackCoords[1]);
            }
        }
        this._processMessageQueue(typeState);
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Label/Action Creation


    _createMessageLabel : function (typeState, messageState) {
        var actions = messageState.actions,
            settings = messageState.settings,
            contents = messageState.contents,
            notifyType = typeState.notifyType
        ;
        // required label-related settings
        var styleName       = settings.styleName,
            messageIcon     = settings.messageIcon,
            iconOrientation = settings.messageIconOrientation
        ;

        var label = messageState.label = isc.NotifyLabel.create(settings.labelProperties,
            {
                contents: contents,
                notifyType: notifyType,
                messageState: messageState,
                styleName: styleName,

                animateShowTime: settings.fadeInDuration,
                animateHideTime: settings.fadeOutDuration
            },
            settings.zIndex ? {zIndex: settings.zIndex} : null,

            messageIcon                 ? {icon:               messageIcon} : null,
            iconOrientation             ? {iconAlign:      iconOrientation,
                                          iconOrientation: iconOrientation} : null,
            settings.messageIconSpacing ? {iconSpacing: settings.messageIconSpacing} : null,
            settings.messageIconWidth   ? {iconWidth:   settings.messageIconWidth}   : null,
            settings.messageIconHeight  ? {iconHeight:  settings.messageIconHeight}  : null);

        if (actions && actions.length) {
            var actionHTML = this._getActionHTML(messageState);
            if (actionHTML) contents = contents ? contents + actionHTML : actionHTML;
            label.setContents(contents);
        }
        label.bringToFront();


        label._origWidth = label.getWidth();
        this._autoFitMessageContents(settings, label);
        label.draw();

        // cache this message's width and height

        messageState.width  = label.getVisibleWidth();
        messageState.height = label.getVisibleHeight();
    },

    _autoFitMessageContents : function (settings, label) {
        if (!settings.autoFitWidth) return;

        // warn of potentially unintentional and suboptimal autoFitWidth: true + wrap: false
        if (label.wrap == false) {
            this.logWarn("addMessage(): autoFitWidth:true specified in " +
                "conjunction with wrap:false.  These settings are usually not intended " +
                "to be used in conjunction as autoFitWidth is specifically intended to " +
                "allow text to wrap when autoFitMaxWidth would otherwise be exceeded.",
                "notify");
        }

        var contents = label.contents,
            origWidth = label._origWidth,
            wrapWidth = isc.Hover._getAutoFitWidth(settings, label, contents)
        ;

        // if the computed autofit width exceeds the original label width, apply it
        if (wrapWidth > origWidth) {
            if (this.logIsDebugEnabled("notify")) {
                this.logDebug("addMessage(): message shown with autoFitWidth enabled. " +
                    "It will expand from specified width:" + origWidth + " to content width:" +
                    wrapWidth, "notify");
            }
            label.setWidth(wrapWidth);
        }
    },

    _getActionHTML : function (messageState) {
        var label = messageState.label,
            actions = messageState.actions,
            settings = messageState.settings,
            separate = !!messageState.contents,
            styleName = settings.actionStyleName
        ;
        var actionHTML = isc.StringBuffer.create();
        for (var i = 0; i < actions.length; i++) {
            var action = actions[i],
                title = action.title;
            if (title) {
                if (separate) actionHTML.append(action.separator || settings.actionSeparator);
                if (action.wholeMessage) actionHTML.append(title);
                else {
                    actionHTML.append("<span eventpart='action' id='", label.getID(),
                        "_action_", i, "' class='", styleName, "'>", title, "</span>");
                }
                separate = true;
            }
        }
        return actionHTML.toString();
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Coordinates and Positioning

    // resolve the desired location of the message into x, y coordinates
    _getMessageCoords : function (typeState, messageState) {
        var settings = messageState.settings;
        if (settings.x != null && settings.y != null) return [settings.x, settings.y];

        var label = messageState.label,
            container = settings.positionCanvas
        ;


        var position = settings.position;
        if (!position) {
            if (container) position = "C";
            else {
                position = settings.slideInOrigin || settings.slideOutOrigin;
                if (!position || !position.match(/[TBRLC]/)) position = "L";
            }
        }

        return this._getPositionCoords(typeState, messageState, position, container);
    },

    // resolve the desired location of the stack into x, y coordinates;
    // includes messageState's label unless isDismiss has been set
    _getStackCoords : function (typeState, messageState, isDismiss) {
        var latestMessage = typeState.liveMessages.last(),
            latestSettings = latestMessage.settings;
        if (latestSettings.x != null && latestSettings.y != null) {
            return [latestSettings.x, latestSettings.y];
        }
        var container = latestSettings.positionCanvas;



        var position = latestSettings.position;
        if (!position) {
            if (container) position = "C";
            else {
                var settings = messageState.settings;
                position = settings.slideInOrigin || settings.slideOutOrigin;
                if (!position || !position.match(/[TBRLC]/)) position = "L";
            }
        }

        return this._getPositionCoords(typeState, messageState, position, container, isDismiss);
    },

    // get the slide start/end coordinates of the message - these should be just _off screen_
    _getSlideOriginCoords : function (typeState, messageState, configCoords, isSlideIn) {
        var label = messageState.label,
            settings = messageState.settings,
            origin = isSlideIn ? settings.slideInOrigin : settings.slideOutOrigin
        ;



        var left = configCoords ? configCoords[0] : label.getPageLeft(),
            top  = configCoords ? configCoords[1] : label.getPageTop()
        ;

        var nearest = messageState.nearest ||
                this._getNearestEdge(typeState, messageState, left, top)
        ;
        if (!origin || !origin.match(/[TBRL]/)) {
            if (isSlideIn && !settings.defaultSlideOutToNearest) {
                messageState.nearest = nearest;
            }
            origin = nearest;
        }

        return this._getPositionCoords(typeState, messageState, origin, null, null, left, top);
    },

    _getPositionCoords : function (typeState, messageState, position, container, isDismiss,
                                   left, top)
    {
        var containerLeft, containerTop,
            containerWidth, containerHeight
        ;
        if (container) {
            containerLeft = container.getPageLeft();
            containerTop = container.getPageTop();
            containerWidth = container.getVisibleWidth();
            containerHeight = container.getVisibleHeight();
        } else {
            containerLeft = containerTop = 0;
            // use cached viewport size when repositioning due to content change

            containerWidth  = this._pageWidth  || isc.Page.getScrollWidth();
            containerHeight = this._pageHeight || isc.Page.getScrollHeight();
        }

        var isStack = isDismiss != null,
            isSlide = left != null && top != null
        ;


        var firstMessage = isDismiss ? typeState.liveMessages.last() : messageState,
            firstSettings = firstMessage.settings,
            width = firstMessage.width,
            height = firstMessage.height,
            xOffset = 0, yOffset = 0
        ;

        // when stacking messages, adjust width and height based on stack size
        if (isStack) {
            var stackSize = this._getPostEffectsStackSize(typeState, isDismiss ?
                                                          messageState : null);
            switch (firstSettings.stackDirection) {
            case "down": case "right":
                switch (position) {
                case "BR":
                    height = stackSize[1];
                    width = stackSize[0];
                case "B": case "BL":
                    height = stackSize[1];
                    break;
                case "R": case "TR":
                    width = stackSize[0];
                    break;
                default:
                case "T": case "L": case "C": case "TL":
                    break;
                }
                break;
            case "up":
                switch (position) {
                case "R": case "BR":
                    width = stackSize[0];
                    // fall through
                case "B": case "L": case "C": case "BL":
                    yOffset = height - stackSize[1];
                    break;
                case "TR":
                    width = stackSize[0];
                    // fall through
                case "T": case "TL":
                    height = stackSize[1];
                    break;
                }
                break;
            case "left":
                switch (position) {
                case "B": case "BR":
                    height = stackSize[1];
                    // fall through
                case "R": case "C": case "T": case "TR":
                    xOffset = width - stackSize[0];
                    break;
                case "BL":
                    height = stackSize[1];
                    // fall through
                case "L": case "TL":
                    width = stackSize[0];
                    break;
                }
                break;
            }
        }



        switch (position) { // left/x coordinate
        case "L": case "TL": case "BL":
            left = containerLeft;
            if (isSlide) left -= width;
            break;
        case "R": case "TR": case "BR":
            left = containerLeft + containerWidth;
            if (!isSlide) left -= width;
            break;
        default:
        //case "T": case "B": case "C":
            if (!isSlide) left = Math.floor(containerLeft + containerWidth / 2 - width / 2);
            break;
        }
        switch (position) { // top/y coordinate
        case "T": case "TL": case "TR":
            top = containerTop;
            if (isSlide) top -= height;
            break;
        case "B": case "BL": case "BR":
            top = containerTop + containerHeight;
            if (!isSlide) top -= height;
            break;
        default:
        //case "L": case "R": case "C":
            if (!isSlide) top = Math.floor(containerTop + containerHeight / 2 - height / 2);
            break;
        }

        // apply an offset from the message stack position if leftOffset/topOffset
        if (firstSettings.leftOffset != null) xOffset += firstSettings.leftOffset;
        if (firstSettings.topOffset  != null) yOffset += firstSettings.topOffset;

        return [left + xOffset, top + yOffset];
    },

    // calculate the viewport edge nearest to the provided x, y coordinates
    _getNearestEdge : function (typeState, messageState, left, top) {
        var viewportWidth = isc.Page.getScrollWidth(),
            viewportHeight = isc.Page.getScrollHeight()
        ;
        var rightOffset  = viewportWidth - left - messageState.width,
            bottomOffset = viewportHeight - top - messageState.height
        ;
        // Added explicit handling for full-width notifies (messageState.width === viewportWidth)
        // to prevent notifications positioned at the "top edge" incorrectly slide in from the left
        // instead of from the top.
        if (messageState.width === viewportWidth) {
            if (messageState.settings.position === 'TL') return 'L';
            else if (messageState.settings.position === 'TR') return 'R';
            else if (messageState.settings.position === 'BL') return 'L';
            else if (messageState.settings.position === 'BR') return 'R';

            if (top === 0) return "T";

            if (bottomOffset === 0) return "B";

            if (left === 0 && messageState.settings.position === 'L') return "L";

            if (rightOffset === 0 && messageState.settings.position === 'R') return "R";

        } else if (left <= rightOffset) {
            // Maintained fallback logic for intermediate positions to preserve default behavior.
            if (top <= bottomOffset) return left <= top          ? "L" : "T";
            else                     return left <= bottomOffset ? "L" : "B";
        } else {
            if (top <= bottomOffset) return rightOffset <= top          ? "R" : "T";
            else                     return rightOffset <= bottomOffset ? "R" : "B";
        }
    },

    _getStackedMessageCoords : function (typeState, messageState, stackCoords) {
        var direction = messageState.settings.stackDirection,
            messageLeft = stackCoords[0], messageTop = stackCoords[1];
        if (direction == "up" || direction == "left") {
            var stackSize = this._getPostEffectsStackSize(typeState);
            if (direction == "up") messageTop += stackSize[1] - messageState.height;
            else                  messageLeft += stackSize[0] - messageState.width;
        }
        return [messageLeft, messageTop];
    },

    _getPostEffectsStackSize : function (typeState, excludedMessage) {
        var liveMessages = typeState.liveMessages;
        if (!liveMessages.length) return [1, 1];

        var width = 0, height = 0,
            stack = typeState.stack,
            vertical = stack.vertical
        ;
        for (var i = 0; i < liveMessages.length; i++) {
            var messageState = liveMessages[i];
            if (messageState == excludedMessage) continue;

            var messageWidth = messageState.width,
                messageHeight = messageState.height
            ;
            if (vertical) {
                if (height > 0) height += stack.membersMargin;
                if (messageWidth > width) width = messageWidth;
                height += messageHeight;
            } else {
                if (width > 0) width += stack.membersMargin;
                if (messageHeight > height) height = messageHeight;
                width += messageWidth;
            };
        }
        return [width, height];
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Animation/Stack Mechanics - Common

    // compute a duration given two points and a slideSpeed in pixels/second
    _getSlideDuration : function (startX, startY, endX, endY, slideSpeed) {
        if (slideSpeed < 1) slideSpeed = 1;

        var deltaX = endX - startX, deltaY = endY - startY,
            distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY)
        ;
        return Math.ceil(1000 * distance / slideSpeed);
    },

    _addLabelToStack : function (typeState, messageState, stackCoords, callback) {
        var stack = typeState.stack,
            label = messageState.label,
            direction = messageState.settings.stackDirection,
            addFirst = direction == "down" || direction == "right"
        ;
        stack.addMember(label, addFirst ? 0 : null, null, callback);
        if (stackCoords) stack.moveTo(stackCoords[0], stackCoords[1]);
    },

    // run appropriate animation for the stack during dismissal of a message

    _moveStackForDismiss : function (typeState, messageState, stackCoords, callback, duration) {
        var animations = 0,
            stack = typeState.stack;
        if (stack.getLeft() != stackCoords[0] || stack.getTop() != stackCoords[1]) {
            var liveMessages = typeState.liveMessages,
                pendingQueue = typeState.pendingQueue;
            if (liveMessages.length > 1 && pendingQueue.length == 0) {
                stack.animateMove(stackCoords[0], stackCoords[1], callback, duration);
                animations++;
            }
        }
        return animations;
    },

    _moveStackForAdd : function (typeState, messageState, stackCoords, callback, duration) {
        var animations = 0,
            stack = typeState.stack,
            stackLeft = stackCoords[0],
            stackTop = stackCoords[1],
            settings = messageState.settings,
            membersMargin = stack.membersMargin
        ;
        switch (settings.stackDirection) {
        case "right":
            stackLeft += messageState.width + membersMargin;
            break;
        case "down":
            stackTop += messageState.height + membersMargin;
            break;
        }
        if (stack.getLeft() != stackLeft || stack.getTop() != stackTop) {
            stack.animateMove(stackLeft, stackTop, callback, duration);
            animations++;
        }
        return animations;
    },

    // clear tracking of the in-progress animation and then clean up and check message queues
    _completeAnimation : function (typeState, messageState, stackCoords, dismiss) {
        delete typeState.op;
        delete typeState.opCount;
        delete typeState.opMessage;

        if (typeState.stack) {
            typeState.stack._clearAnimation();
        }

        // reposition the stack (or message if not stacking) if contents have changed
        if (typeState.replaceQueue.length > 0) this._applyContentsToMessages(typeState);

        this._completeMessageHandling(typeState, messageState, stackCoords, dismiss);
    },

    // reposition the stack or message to account for contents changing in setMessageContents()

    _fixStackOrMessagePosition : function (typeState, forceInstant) {
        var stack = typeState.stack,
            messages = typeState.liveMessages,
            first = messages[0];
        if (!first) return;

        // resolve which target to reposition, and get its message state
        var target, messageState;
        if (stack) {
            messageState = messages.find("label", stack.getMember(0));
            target = stack;
        } else {
            messageState = first;
            target = first.label;
        }
        if (!messageState) return;



        // calculate the desired new stack or message coordinates for proper alignment
        var coords = stack ? this._getStackCoords(typeState, messageState, false) :
                             this._getMessageCoords(typeState, messageState);

        // reposition the animation target; skip animation unless possible and configured
        var settings = messageState.settings,
            effect = settings.repositionMethod,
            left = target.left, top = target.top;
        if (effect == "instant"  || coords[0] == left && coords[1] == top || forceInstant) {
            target.moveTo(coords[0], coords[1]);
            return;
        }

        // slide the target to its new coordinates, using slideSpeed setting
        var duration = this._getSlideDuration(left, top, coords[0], coords[1],
                                              settings.slideSpeed);
        target.animateMove(coords[0], coords[1], null, duration);
    },


    ////////////////////////////////////////////////////////////////////////////////
    // "Slide In" Animation



    _slideInMessage : function (typeState, messageState, messageCoords, stackCoords) {
        var Notify = this,
            stack = typeState.stack,
            label = messageState.label,
            settings = messageState.settings,
            callback = function () {
                Notify._slideInComplete(typeState, messageState, stackCoords);
            },
            startCoords = this._getSlideOriginCoords(typeState, messageState, messageCoords,
                                                     true)
        ;
        label.moveTo(startCoords[0], startCoords[1]);

        var animations = 1,
            duration = this._getSlideDuration(startCoords[0], startCoords[1],
                           messageCoords[0], messageCoords[1], settings.slideSpeed)
        ;
        label.animateMove(messageCoords[0], messageCoords[1], callback, duration);

        if (stack) {
            animations += this._moveStackForAdd(typeState, messageState, stackCoords, callback,
                                                duration);
        }


        typeState.op        = "slideIn";
        typeState.opCount   = animations;
        typeState.opMessage = messageState;
    },

    _slideInComplete : function (typeState, messageState, stackCoords) {
        if (--typeState.opCount > 0) return;

        if (typeState.stack) {
            this._addLabelToStack(typeState, messageState, stackCoords);
        }

        this._completeAnimation(typeState, messageState);
    },


    ////////////////////////////////////////////////////////////////////////////////
    // "Fade In" Animation



    _prepSlideStack : function (typeState, messageState, messageCoords, stackCoords) {
        var stack = typeState.stack,
            vertical = stack.vertical,
            label = messageState.label,
            settings = messageState.settings,
            duration = settings.fadeInDuration
        ;



        var animate = this._moveStackForAdd(typeState, messageState, stackCoords, function () {
            isc.Notify._prepSlideComplete(typeState, messageState, messageCoords, stackCoords);
        }, duration);

        if (animate) {

            typeState.op        = "slideStack";
            typeState.opMessage = messageState;

        } else {
            this._fadeInMessage(typeState, messageState, messageCoords, stackCoords);
        }
    },

    _prepSlideComplete : function (typeState, messageState, messageCoords, stackCoords) {
        delete typeState.op;
        delete typeState.opMessage;

        this._fadeInMessage(typeState, messageState, messageCoords, stackCoords);
    },

    _fadeInMessage : function (typeState, messageState, messageCoords, stackCoords) {
        var Notify = this,
            stack = typeState.stack,
            label = messageState.label,
            settings = messageState.settings,
            callback = function () {
                Notify._fadeInComplete(typeState, messageState);
            }
        ;
        if (stack) {
            var duration = settings.fadeInDuration;
            stack._setAnimation("fade", duration);
            this._addLabelToStack(typeState, messageState, stackCoords, callback);
        } else {
            label.hide();
            label.moveTo(messageCoords[0], messageCoords[1]);
            label.animateShow(null, callback);
        }


        typeState.op        = "fadeIn";
        typeState.opMessage = messageState;
    },

    _fadeInComplete : function (typeState, messageState) {
        if (--typeState.opCount > 0) return;
        this._completeAnimation(typeState, messageState);
    },


    ////////////////////////////////////////////////////////////////////////////////
    // "Slide Out" Animation



    _slideOutMessage : function (typeState, messageState, stackCoords) {
        var Notify = this,
            stack = typeState.stack,
            label = messageState.label,
            settings = messageState.settings,
            startLeft = label.getPageLeft(),
            startTop = label.getPageTop()
        ;

        var animations = 1,
            callback = function () {
                Notify._slideOutComplete(typeState, messageState, stackCoords);
            },
            endCoords = this._getSlideOriginCoords(typeState, messageState),
            duration = this._getSlideDuration(startLeft, startTop, endCoords[0], endCoords[1],
                                              settings.slideSpeed)
        ;

        if (stack) {
            // size the placeholder to match the label, and make sure it's visible
            var placeholder = typeState.placeholder;
            placeholder.resizeTo(label.getVisibleWidth(), label.getVisibleHeight());
            placeholder.show();

            // replace label with placeholder, but then draw the label right where it was before
            stack._replaceMember(label, placeholder);
            label.moveTo(startLeft, startTop);
            label.moveAbove(stack);
            label.draw();

            // slide the stack's placeholder slot closed
            stack._setAnimation("slide", duration);
            stack.removeMember(placeholder, null, callback);
            animations++;

            // slide the stack into its new desired position (if it's changed)
            animations += this._moveStackForDismiss(typeState, messageState, stackCoords,
                                                    callback, duration);
        }

        // slide the label off screen to the configured or nearest screen edge
        label.animateMove(endCoords[0], endCoords[1], callback, duration, duration);


        typeState.op        = "slideOut";
        typeState.opCount   = animations;
        typeState.opMessage = messageState;
    },

    _slideOutComplete : function (typeState, messageState, stackCoords) {
        if (--typeState.opCount > 0) return;
        this._completeAnimation(typeState, messageState, stackCoords, true);
    },


    ////////////////////////////////////////////////////////////////////////////////
    // "Fade Out" Animation



    _fadeOutMessage : function (typeState, messageState, stackCoords) {
        var Notify = this,
            animations = 1,
            stack = typeState.stack,
            label = messageState.label,
            settings = messageState.settings,
            callback = function () {
                Notify._fadeOutComplete(typeState, messageState, stackCoords, slideStack);
            }
        ;

        if (stack) {
            var duration = settings.fadeOutDuration,
                slideStack = stack.members.last() != messageState.label
            ;
            // fade out dismissed member; stack will be "slid closed" later
            if (slideStack) {
                label.animateFade(0, callback, duration);

            // optimized case - no separate stack "slide closed" is required
            } else {
                stack._setAnimation("fade", duration);
                stack.removeMember(label, null, callback);

                animations += this._moveStackForDismiss(typeState, messageState, stackCoords,
                                                        callback, duration);
            }
        } else {
            label.animateHide(null, callback);
        }


        typeState.op        = "fadeOut";
        typeState.opCount   = animations;
        typeState.opMessage = messageState;
    },

    _fadeOutComplete : function (typeState, messageState, stackCoords, slideStack) {
        if (--typeState.opCount > 0) return;

        delete typeState.op;
        delete typeState.opCount;
        delete typeState.opMessage;

        if (slideStack) {
            this._slideClosedStack(typeState, messageState, stackCoords);
        } else {
            this._completeAnimation(typeState, messageState, stackCoords, true);
        }
    },

    _slideClosedStack : function (typeState, messageState, stackCoords) {
        var animations = 1,
            stack = typeState.stack,
            vertical = stack.vertical,
            label = messageState.label,
            settings = messageState.settings,
            duration = settings.fadeOutDuration,
            callback = function () {
                isc.Notify._slideClosedComplete(typeState, messageState, stackCoords);
            };
        ;


        if (this._canUpdateStackInstantly(typeState, messageState, stackCoords)) {
            stack.removeMember(label);
            stack.moveTo(stackCoords[0], stackCoords[1]);
            this._completeMessageHandling(typeState, messageState, stackCoords, true);
            return;
        }



        stack._setAnimation("slide", duration);
        stack.removeMember(label, null, callback);

        animations += this._moveStackForDismiss(typeState, messageState, stackCoords, callback,
                                                duration);


        typeState.op        = "slideClosed";
        typeState.opCount   = animations;
        typeState.opMessage = messageState;
    },

    _slideClosedComplete : function (typeState, messageState, stackCoords) {
        if (--typeState.opCount > 0) return;
        this._completeAnimation(typeState, messageState, stackCoords, true);
    },

     _canUpdateStackInstantly : function (typeState, messageState, stackCoords) {
         var settings = messageState.settings,
             direction = settings.stackDirection,
             pendingQueue = typeState.pendingQueue,
             liveMessages = typeState.liveMessages
         ;
         if (liveMessages.length < 2 || pendingQueue.length ||
             direction == "down" || direction == "right")
         {
             return;
         }
         var stack = typeState.stack,
             label = messageState.label;
         if (label != stack.members.first()) return;

         var second = stack.members[1];
         if (second.getPageLeft() == stackCoords[0] &&
             second.getPageTop()  == stackCoords[1])
         {
             return true;
         }
         return false;
     }

});

// define a default static label config for notification labels
isc.defineClass("NotifyLabel", "Label").addProperties({

    width: 1, height: 1,
    animateHideEffect: "fade",
    animateShowEffect: "fade",
    left: 0, top: -1000,
    autoDraw: false,


    _getAfterPadding : function () {
        return this._afterPadding ? this._afterPadding : null;
    },

    _zLayerName:"_notify",


    ID: null,

    closeButtonConstructor: "ImgButton",
    closeButtonDefaults: {
        snapTo:         isc.Page.isRTL() ? "L" : "R",
        snapOffsetLeft: isc.Page.isRTL() ?   8 :  -8,
        imageType: "center",
        padding: 0,
        showDown: false,
        showRollOver: false,

        src: "[SKINIMG]/Notify/close.png",
        click : function () {
            var label = this.creator,
                typeState = isc.Notify.typeState[label.notifyType];
            isc.Notify._dismissMessage(typeState, label.messageState);
        }
    },

    closeButtonSize: 12,

    // default these sizes here - the legacy value (messageIconWidth/Height) was 17px
    // and was presumably intended to be the Spacious size - messageIconWidth/Height are
    // not unset by default and will inherit iconWidth/Height, which can be scaled in
    // load_skin
    iconWidth: 17,
    iconHeight: 17,

    initWidget : function () {
        this.Super("initWidget", arguments);

        // configure the closeButton if canDismiss is set
        var size = this.closeButtonSize,
            settings = this.messageState.settings,
            canDismiss = settings.canDismiss;
        if (canDismiss || canDismiss != false && !settings.duration) {
            this.addAutoChild("closeButton", {
                size: size, imageWidth: size, imageHeight: size,
                // set the icon's baseStyle to whatever the outer widget has - it will be one
                // of "notifyMessage", "notifyError" or "notifyWarn", which each have the same
                // text-color but different background-colors
                baseStyle: this.baseStyle
            });
            // padding may be needed depending on the applied style
            var controlPadding = settings.messageControlPadding;
            if (controlPadding) this._afterPadding = controlPadding;
        }
    },
    click : function () {
        var messageState = this.messageState,
            actions = messageState.actions;
        if (!actions) return;

        for (var i = 0; i < actions.length; i++) {
            var action = actions[i];
            if (action.wholeMessage) {
                this.fireAction(action);
            }
        }
    },
    actionClick : function (element, ID, event) {


        var messageState = this.messageState,
            action = messageState.actions[ID];
        if (action) {
            this.fireAction(action);
            return false;
        }
    },
    fireAction : function (action) {
        // fire target[methodName] if defined (or method for SGWT)
        if (action.target && action.methodName || action.method) {
            isc.Class.fireCallback(action);
        }
        if (action.dismissMessage) {
            var typeState = isc.Notify.typeState[this.notifyType];
            isc.Notify._dismissMessage(typeState, this.messageState);
        }
    }

});

//> @type NotifyType
// An identifier passed to +link{Notify} APIs to group related messages together so that they
// all use the same behavior and display settings.
// @baseType Identifier
// @see Notify.addMessage()
// @see Notify.configureMessages()
// @see Notify.dismissMessage()
// @visibility external
//<


////////////////////////////////////////////////////////////////////////////////
// NotifySettings

//> @object NotifySettings
// An object used to configure how messages shown by +link{Notify.addMessage()} are drawn and
// behave.
// @see Notify.addMessage()
// @see Notify.configureMessages()
// @treeLocation Client Reference/System
// @visibility external
//<

isc.Notify.addClassMethods({

    commonDefaults: {
        //> @attr notifySettings.duration (int : 5000 : IR)
        // Length of time a message is shown before being auto-dismissed, in milliseconds.
        // A value of 0 means that the message will not be dismissed automatically.
        // Messages can always be dismissed by calling +link{Notify.dismissMessage()} or,
        // if +link{canDismiss} is set, by performing a "close click".
        // @visibility external
        //<
        duration: 5000,

        //> @attr notifySettings.stayIfHovered (boolean : false : IR)
        // If true, pauses the auto-dismiss countdown timer when the mouse is over the
        // messasge.
        // @visibility external
        //<

        //> @attr notifySettings.x (Integer : null : IR)
        // Where to show the message, as a viewport-relative x coordinate offset to the
        // left edge of the +link{Label} rendering the message.  Properties +link{position}
        // and +link{positionCanvas} will only be used to place messages if coordinates
        // aren't provided.
        // @see y
        // @see position
        // @visibility external
        //<

        //> @attr notifySettings.y (Integer : null : IR)
        // Where to show the message, as a viewport-relative y coordinate offset to the top
        // edge of the +link{Label} rendering the message.
        // @see x
        // @see position
        // @visibility external
        //<

        //> @attr notifySettings.position (EdgeName : varies : IR)
        // Where to show the message, specified as an edge ("T", "B", "R", "L"), a corner
        // ("TL", "TR", "BL", "BR), or "C" for center,  similar to +link{canvas.snapTo}.
        // If an edge is specified, the message will be shown at its center (or the very
        // center for "C").  Only used if +link{x,coordinates} haven't been provided.
        // <P>
        // If a +link{positionCanvas} has been specified, the <code>position</code> is
        // interpreted relative to it instead of the viewport, and this property defaults
        // to "C".  Otherwise, if no <code>positionCanvas</code> is present, the default is
        // to use +link{slideInOrigin} or +link{slideOutOrigin}, or "L" if neither property
        // is defined.
        // <P>
        // To place the message at an offset from the specified position, use +link{leftOffset}
        // or +link{topOffset}.
        // @see x
        // @see y
        // @see positionCanvas
        // @visibility external
        //<

        //> @attr notifySettings.positionCanvas (Canvas : null : IR)
        // Canvas over which to position the message, available as an alternative means of
        // placement if viewport-relative +link{x,coordinates} aren't provided.  Note that
        // the canvas is only used to compute where to the place message, and will not be
        // altered.
        // @see leftOffset
        // @see topOffset
        // @see position
        // @visibility external
        //<

        //> @attr notifySettings.leftOffset (Integer : null : IR)
        // Specifies a left offset from the position specified by +link{position} or
        // +link{positionCanvas} where the message should be shown.  Ignored if
        // +link{x,coordinates} are provided to position the message.
        // @see position
        // @see topOffset
        // @visibility external
        //<

        //> @attr notifySettings.topOffset (Integer : null : IR)
        // Specifies a top offset from the position specified by +link{position} or
        // +link{positionCanvas} where the message should be shown.  Ignored if
        // +link{y,coordinates} are provided to position the message.
        // @see position
        // @see leftOffset
        // @visibility external
        //<

        //>@type NotifyTransition
        // @value  "slide"    message slide-animates onto or off of the screen
        // @value  "fade"     message appears or disappears via a fade effect
        // @value  "instant"  message instantly appears or disappears
        // @visibility external
        //<

        //> @attr notifySettings.appearMethod (NotifyTransition : "slide" : IR)
        // Controls how messages appear at or reach their requested location.  The default
        // of "slide" is recommended because the motion will draw the user's attention to
        // the notification.
        // @visibility external
        //<
        appearMethod: "slide",

        //> @attr notifySettings.disappearMethod (NotifyTransition : "fade" : IR)
        // Controls how messages disappear from or leave their requested location.  The
        // default of "fade" is recommended because a slide animation would draw too much
        // attention to a notification that is no longer current, whereas a subtle fade
        // should draw a minimum of attention (less even than instantaneously
        // disappearing).
        // @visibility external
        //<
        disappearMethod: "fade",

        //> @attr notifySettings.repositionMethod (NotifyTransition : "slide" : IR)
        // Controls how the stack or message is repositioned, if required, after
        // +link{notify.setMessageContents()} has been called.  Valid values are "slide" and
        // "instant".
        // @visibility external
        //<
        repositionMethod: "slide",

        //> @attr notifySettings.canDismiss (Boolean : false : IR)
        // Displays an icon to allow a message to be dismissed through the UI.  Messages
        // can always be dismissed programmatically by calling
        // +link{Notify.dismissMessage()}.
        // @visibility external
        //<

        //> @attr notifySettings.slideInOrigin (String : null : IR)
        // Determines where messages originate when they appear for +link{appearMethod}:
        // "slide".  Possible values are "L", "R", "T", and "B".
        // <P>
        // If not specified, the edge nearest the message's requested coordinates or
        // position is used.
        // @visibility external
        //<

        //> @attr notifySettings.slideOutOrigin (String : null : IR)
        // Determines where messages go when they disappear for +link{disappearMethod}:
        // "slide".  Possible values are "L", "R", "T", and "B".  <P> If not specified, the
        // edge nearest the message's requested coordinates or position is used.
        // @visibility external
        //<

        //> @attr notifySettings.defaultSlideOutToNearest (boolean : false : IR)
        // If +link{disappearMethod} is "slide", should we default +link{slideOutOrigin} to
        // the edge nearest to the location of a message at the moment it's dismissed?  The
        // default value of false means that if +link{appearMethod} is "slide" and
        // +link{slideInOrigin} isn't set, we'll reuse the edge nearest to the initial
        // location of the message to default +link{slideOutOrigin}, if needed, so that the
        // message slides in from, and out to, the same edge.
        //<

        //> @attr notifySettings.slideSpeed (int : 300 : IR)
        // Animation speed for +link{NotifyTransition}: "slide", in pixels/second.
        // @visibility external
        //<
        slideSpeed: 300,

        //> @attr notifySettings.fadeInDuration (int : 500 : IR)
        // Time over which the fade-in effect runs for +link{NotifyTransition}: "fade", in
        // milliseconds.
        // @visibility external
        //<
        fadeInDuration: 500,

        //> @attr notifySettings.fadeOutDuration (int : 500 : IR)
        // Time over which the fade-out effect runs for +link{NotifyTransition}: "fade", in
        // milliseconds.
        // @visibility external
        //<
        fadeOutDuration: 500,

        //> @type MultiMessageMode
        // @value  "stack"  messages of the same +link{NotifyType} are arranged in a stack
        // @value  "replace"  messages of the same +link{NotifyType} replace each other
        // @visibility external
        //<

        //> @attr notifySettings.multiMessageMode (MultiMessageMode : "stack": IR)
        // Determines what happens if a message appears while there's still another one of
        // the same +link{NotifyType} being shown.  Such messages are either stacked or
        // replace one another,
        // @visibility external
        //<
        multiMessageMode: "stack",

        //> @type StackDirection
        // @value  "up"     older messages move up
        // @value  "down"   older messages move down
        // @value  "right"  older messages move right
        // @value  "left"   older messages move left
        // @visibility external
        //<

        //> @attr notifySettings.stackDirection (StackDirection : "down" : IR)
        // Determines how messages are stacked if +link{multiMessageMode} is "stack".  For
        // example, "down" means that older messages move down when a new message of the
        // same +link{NotifyType} appears.
        // @visibility external
        //<
        stackDirection: "down",

        //> @attr notifySettings.stackSpacing (int : 2 : IR)
        // Space between each message when +link{multiMessageMode} is "stack".
        // @visibility external
        //<
        stackSpacing: 2,

        //> @attr notifySettings.maxStackSize (int : 3 : IR)
        // Sets a limit on how many messages may be stacked if +link{multiMessageMode} is
        // "stack".  The oldest message of the affected +link{NotifyType} will be dismissed
        // to enforce this limit.
        // @visibility external
        //<
        maxStackSize: 3,

        //> @type StackPersistence
        // @value  "none"   older messages disappear as if unrelated
        // @value  "reset"  older messages have their duration timers reset so they stick
        //                  around as long as the new message if they've got less time left
        //                  than that message
        // @visibility external
        //<

        //> @attr notifySettings.stackPersistence (StackPersistence : "none" : IRA)
        // Controls how older messages' +link{duration} countdowns are affected when a new
        // message of the same +link{NotifyType} appears.  We either continue the
        // countdowns on the older messages as if they are unrelated, or we reset any
        // countdowns that are less than the new message's <code>duration</code>.
        // <P>
        // Note that you can set this property in a call to +link{NOtify.addMessage()} even
        // though it has "stack" in its name, since it governs the logic run on behalf of
        // this message.
        // @visibility external
        //<
        stackPersistence: "none",

        //> @type MaxStackDismissMode
        // @value  "oldest"     dismiss the oldest message
        // @value  "countdown"  dismiss the message with least time left
        // @visibility external
        //<

        //> @attr notifySettings.maxStackDismissMode (MaxStackDismissMode : "oldest" : IR)
        // Specifies how to pick which message to dismiss when the +link{maxStackSize} is
        // reached, and the lowest priority value (highest numerical
        // +link{notifySettings.messagePriority,messagePriority}) is shared by more than one
        // message.
        // <P>
        // We can simply dismiss the oldest message of that
        // +link{notifySettings.messagePriority,messagePriority}, or we can pick the message
        // with the least time left until it's auto-dismissed.
        // @see duration
        // @see Notify.dismissMessage
        // @visibility external
        //<
        maxStackDismissMode: "oldest",

        //> @attr notifySettings.actionSeparator (HTMLString : " " : IR)
        // HTML to be added before each action to separate it from the previous action.
        // For the first action, it will only be added if the message contents aren't
        // empty.
        // <P>
        // You may override this on a per action basis using +link{notifyAction.separator}.
        // <P>
        // Besides the default, some other known useful values are "&amp;emsp;" and "&amp;nbsp;".
        // @visibility external
        //<
        actionSeparator: " ",

        //> @attr notifySettings.messageIcon (SCImgURL : varies : IR)
        // Optional icon to be shown in the +link{Label} drawn for this message.  Default is
        // <ul>
        // <li>"[SKIN]/Notify/error.png" for +link{NotifyType}: "error",
        // <li>"[SKIN]/Notify/warning.png" for +link{NotifyType}: "warn", and
        // <li>"[SKIN]/Notify/checkmark.png" for all other +link{NotifyType}s.
        // </ul>
        // However, if you specify a +link{notifySettings.messagePriority,messagePriority},
        // it will determine the default rather than the actual <code>NotifyType</code>, if
        // +link{applyPriorityToAppearance} is true.
        // @see NotifySettings.messagePriority
        // @visibility external
        //<

        //> @attr notifySettings.messageIconWidth (int : 17 : IR)
        // Width in pixels of the icon image.
        // @see label.iconWidth
        // @visibility external
        //<
        //messageIconWidth: 17,

        //> @attr notifySettings.messageIconHeight (int : 17 : IR)
        // Height in pixels of the icon image.
        // @see label.iconHeight
        // @visibility external
        //<
        //messageIconHeight: 17,

        //> @attr notifySettings.messageIconSpacing (int : 20 : IR)
        // Pixels between icon and title text.
        // @see label.iconSpacing
        // @visibility external
        //<
        messageIconSpacing: 20,

        //> @attr notifySettings.messageControlPadding (int : null : IR)
        // Optional specified padding to apply after the message content when showing a
        // +link{canDismiss,dismiss button} so that the button doesn't occlude any content.
        // Only needed if the message +link{styleName,styling} doesn't already provide
        // enough padding.
        // @visibility external
        //<

        //> @attr notifySettings.messagePriority (MessagePriority : varies : IRA)
        // Sets the priority of the message.  Priority is used to determine which message to
        // dismiss if +link{maxStackSize} is hit.  Lower numerical values have higher
        // priority.
        // <p>The default is:
        // <ul>
        // <li>+link{Notify.ERROR} for +link{NotifyType}: "error",
        // <li>+link{Notify.WARN} for +link{NotifyType}: "warn", and
        // <li>+link{Notify.MESSAGE} for all other +link{NotifyType}s
        // </ul>
        // <b>Impact on Appearance</b>
        // <p>
        // If you specify <code>messagePriority</code>, and +link{applyPriorityToAppearance}
        // is set, the properties:
        // <ul>
        // <li> +link{messageIcon},
        // <li> +link{styleName}, and
        // <li> +link{actionStyleName}
        // </ul>
        // will be assigned, if not specified, to the default values from:<ul>
        // <li> +link{NotifyType}: "error" for priority +link{Notify.ERROR},
        // <li> +link{NotifyType}: "warn" for priority +link{Notify.WARN}, or
        // <li> +link{NotifyType}: "message" for priorities at or below
        //                         +link{Notify.MESSAGE} (greater or equal numerically)
        // </ul>
        // This allows you to automatically set "error" or "warn" styling, on a per-message
        // basis, for any non-"error" or "warn" <code>NotifyType</code> by simply supplying
        // a <code>messagePriority</code> for that message.
        // @see Notify.addMessage()
        // @see NotifySettings.maxStackDismissMode
        // @visibility external
        //<
        messagePriority: isc.Notify.MESSAGE,

        //> @attr notifySettings.applyPriorityToAppearance (boolean : varies : IRA)
        // Whether to default properties affecting the message appearance to those of the
        // built-in +link{NotifyType} corresponding to the
        // +link{notifySettings.messagePriority,messagePriority}.  Default is true except
        // for +link{NotifyType}s "error" and "warn", which default to false.
        // @see NotifySettings.messagePriority
        // @visibility external
        //<
        applyPriorityToAppearance: true,

        //> @attr notifySettings.messageIconOrientation (String : varies : IR)
        // If an icon is present, should it appear to the left or right of the title?
        // valid options are <code>"left"</code> and <code>"right"</code>.  If unset,
        // default is "left" unless +link{page.isRTL(),RTL} is active, in which case it's
        // "right".
        // <P>
        // Note that the icon will automatically be given an alignment matching its
        // orientation, so "left" for <code>messageIconOrientation</code> "left", and vice
        // versa.
        // @see label.iconAlign
        // @see label.iconOrientation
        // @visibility external
        //<
        messageIconOrientation: isc.Page.isRTL() ? "right" : "left",

        //> @attr notifySettings.styleName (CSSStyleName : varies : IR)
        // The CSS class to apply to the +link{Label} drawn for this message.  Default is:
        // <ul>
        // <li>"notifyError" for +link{NotifyType}: "error",
        // <li>"notifyWarn" for +link{NotifyType}: "warn", and
        // <li>"notifyMessage" for all other +link{NotifyType}s.
        // </ul>
        // However, if you specify a +link{notifySettings.messagePriority,messagePriority},
        // it will determine the default rather than the actual <code>NotifyType</code>, if
        // +link{applyPriorityToAppearance} is true.
        // <P>
        // Note that if +link{page.isRTL(),RTL} is active, the default will be as above, but
        // with an "RTL" suffix added.
        // @see NotifySettings.messagePriority
        // @visibility external
        //<

        //> @attr notifySettings.actionStyleName (CSSStyleName : varies : IR)
        // The CSS class to apply to action text in this message.  default is:
        // <ul>
        // <li>"notifyErrorActionLink" for +link{NotifyType}: "error",
        // <li>"notifyWarnActionLink" for +link{NotifyType}: "warn", and
        // <li>"notifyMessageActionLink" for all other +link{NotifyType}s.
        // </ul>
        // However, if you specify a +link{notifySettings.messagePriority,messagePriority},
        // it will determine the default rather than the actual <code>NotifyType</code>, if
        // +link{applyPriorityToAppearance} is true.
        // @see NotifySettings.messagePriority
        // @visibility external
        //<

        //> @attr notifySettings.zIndex (Integer : null : IRA)
        // Provides control over which message occludes the other if messages of different
        // +link{NotifyType}s overlap.  (By design, messages of the same
        // <code>NotifyType</code> are guaranteed not to overlap.)
        // <P>
        // Generally, you should avoid overlapping messages.  The default behavior is that
        // more recent messages will occlude older ones.
        //<


        //> @attr notifySettings.autoFitWidth (Boolean : null : IRA)
        // If true, the specified width of the +link{Label} drawn for this message will be
        // treated as a minimum width.  If the message content string exceeds this, the
        // +link{Label} will expand to accommodate it up to +link{autoFitMaxWidth} (without
        // the text wrapping).
        // <P>
        // Using this setting differs from simply disabling wrapping via
        // +link{label.wrap,wrap:false} as the content will wrap if the
        // +link{autoFitMaxWidth} is exceeded.
        // @visibility external
        //<
        autoFitWidth: true,

        //> @attr notifySettings.autoFitMaxWidth (Integer | String : 300 : IR)
        // Maximum auto-fit width for a message if +link{autoFitWidth} is enabled. May be
        // specified as a pixel value, or a percentage of page width.
        // @see autoFitWidth
        // @visibility external
        //<
        autoFitMaxWidth: 300

        //> @attr notifySettings.labelProperties (Label Properties : null : IR)
        // Configures the properties, such as +link{label.autoFit}, +link{label.align}, and
        // +link{label.width}. of the +link{Label} autochildren that will be used to draw messages,
        // where not already determined by message layout or other <code>NotifySettings</code>
        // properties such as +link{styleName}.
        // <P>
        // Not all label properties are guaranteed to work here, as the Notify system is
        // assumed to layout message content and manage positioning messages.  In particular,
        // the following properties should be avoided:
        //
        // <table border=1 class="normal">
        // <tr bgcolor="#D0D0D0"><td>Property Name</td><td>Issue</td><td>Guidance</td></tr>
        // <tr>
        // <td>margin</td>
        // <td>Layout and positioning of the messages is handled by the Notify system.</td>
        // <td>Use +link{stackSpacing} to configure the separation between messages, and
        // +link{leftOffset} and +link{topOffset} to fine-tine stack
        // +link{position,positioning}.
        // </td>
        // </tr>
        // <tr>
        // <td>padding</td>
        // <td>Padding is set by notification CSS so that children are positioned corrected
        // relative to content.</td>
        // <td>You can apply your own +link{styleName,styling} to messages via CSS.  Or you can
        // use HTML as the message contents to create whatever sort of interior layout you
        // like.</td>
        // </tr>
        // <tr>
        // <td>wrap</td>
        // <td>Autowrap behavior is managed by the Notify system.</td>
        // <td>To have +link{autoFitWidth,autofitted} content not wrap, set
        // +link{autoFitMaxWidth} higher than your expected message widths.  You can set it to
        // "100%" if needed to allow the message to expand across the entire page.</td>
        // </tr>
        // </table>
        // @visibility external
        //<
    },

    // get the default messagePriority for the notifyType
    _getDefaultPriority : function(notifyType) {
        switch (notifyType) {
        case this._$error: return isc.Notify.ERROR;
        case this._$warn:  return isc.Notify.WARN;
        case this._$message:
        default:
            return isc.Notify.MESSAGE;
        }
    },

    _initNotifySettings : function(notifyType, settings) {
        // duplicate settings to avoid ever sharing them
        settings = isc.addProperties({}, settings);

        // don't default the appearance from priority for notifyTypes "error" and "warn"
        var messagePriority = this._getDefaultPriority(notifyType);
        if (messagePriority < isc.Notify.MESSAGE) isc.addDefaults(settings, {
            applyPriorityToAppearance: false, messagePriority: messagePriority
        });
        settings._defaultPriority = messagePriority;

        // default priority-related styling properties according to the notifyType
        isc.addDefaults(settings, this._getPriorityRelatedDefaults(messagePriority));
        // now default the remaining common message properties
        isc.addDefaults(settings, this.commonDefaults);

        return settings;
    },


    ////////////////////////////////////////////////////////////////////////////////
    // Priority-related Defaults

    _errorDefaults : { // notifyType: "error"
        messageIcon: "[SKIN]/Notify/error.png",
        actionStyleName: "notifyErrorActionLink",
        styleName: isc.Page.isRTL() ? "notifyErrorRTL" : "notifyError"
    },

    _warnDefaults : { // notifyType: "warn"
        messageIcon: "[SKIN]/Notify/warning.png",
        actionStyleName: "notifyWarnActionLink",
        styleName: isc.Page.isRTL() ? "notifyWarnRTL" : "notifyWarn"
    },

    _messageDefaults : { // notifyType: "message"
        messageIcon: "[SKIN]/Notify/checkmark.png",
        actionStyleName: "notifyMessageActionLink",
        styleName: isc.Page.isRTL() ? "notifyMessageRTL" : "notifyMessage",
        messageControlPadding: null // declares it "priority-related"
    },

    _getPriorityRelatedDefaults : function (priority) {
        switch (priority) {
        case isc.Notify.ERROR:
            return this._errorDefaults;
        case isc.Notify.WARN:
            return this._warnDefaults;
        default:
        case isc.Notify.MESSAGE:
            return this._messageDefaults;
        }
    },

    _getConfigSettingsByPriority : function (priority) {
        var settings = this.settings;
        switch (priority) {
        case isc.Notify.ERROR: return settings[this._$error];
        case isc.Notify.WARN:  return settings[this._$warn];
        default:
        case isc.Notify.MESSAGE:
            return settings[this._$message];
        }
    },

    _shouldApplyPriorityToAppearance : function (changedSettings, configuredSettings) {
        if (changedSettings.messagePriority == null) return false;
        // allow applyPriorityToAppearance to be specified per-message
        return changedSettings.applyPriorityToAppearance != null ?
               changedSettings.applyPriorityToAppearance :
            configuredSettings.applyPriorityToAppearance;
    }

});


////////////////////////////////////////////////////////////////////////////////
// NotifyAction

//> @object NotifyAction
// Represents an action that's associated with a message.  Similar to the object form of
// +link{Callback}, except a title must also be specified, which is rendered as a clickable
// link in the message (unless +link{notifyAction.wholeMessage,wholeMessage} is set).
// @see Notify.configureMessages()
// @treeLocation Client Reference/System
// @visibility external
//<

//> @attr notifyAction.title (HTMLString : null : IR)
// The title of the action to render into the message.
// @visibility external
//<

//> @attr notifyAction.separator (HTMLString : null : IR)
// Overrides +link{NotifySettings.actionSeparator} for this action.
// @visibility external
//<

//> @attr notifyAction.target (Object : null : IR)
// The object that will be passed as <code>this</code> when the action is executed.
// @visibility external
//<

//> @attr notifyAction.methodName (String : null : IR)
// The method to invoke on the +link{target} when the action is executed.
// @visibility external
//<

//> @attr notifyAction.wholeMessage (Boolean : null : IR)
// Allows a click anywhere on the notification to execute the action.  If true, the action won't
// be rendered as a link.
// @visibility external
//<

//> @attr notifyAction.dismissMessage (Boolean : null : IR)
// Should a click on this action automatically dismiss the associated message?
// @visibility external
//<

//> @method Callbacks.NotifyActionCallback
// A +link{type:Callback} called when +link{NotifyAction} fires.
// @visibility sgwt
//<

//>    @staticMethod isc.notify()
// Displays a new message that's automatically dismissed after a configurable amount of time,
// as an alternative to +link{isc.confirm(),modal notification} dialogs that can lower end user
// productivity.
// <P>
// This method is simply a shorthand way to call +link{Notify.addMessage()}.  For further study,
// see the +link{Notify} class overview, and the class methods +link{Notify.dismissMessage(),
// dismissMessage()} and +link{Notify.configureMessages(),configureMessages()}.
// @param  contents     (HTMLString)             message to be displayed
// @param  [actions]    (Array of NotifyAction)  actions (if any) for this message
// @param  [notifyType] (NotifyType)             category of message
// @param  [settings]   (NotifySettings)         display and behavior settings for this message,
//                                               overriding any stored settings for this
//                                               <code>NotifyType</code>
// @return  (MessageID)  opaque identifier for message
// @see isc.say()
// @see isc.confirm()
// @visibility external
//<
isc.addGlobal("notify", function (contents, actions, notifyType, settings) {
    return isc.Notify.addMessage(contents, actions, notifyType, settings);
});






//>    @class    ToolStrip
//
// Base class for creating toolstrips like those found in browsers and office applications: a
// mixed set of controls including +link{ImgButton,icon buttons},
// +link{button.radioGroup,radio button groups}, +link{MenuButton,menus},
// +link{ComboBoxItem,comboBoxes}, +link{LayoutSpacer,spacers}, +link{Label,status displays} and
// +link{SelectItem,drop-down selects}.
// <P>
// All of the above components are placed in the +link{ToolStrip.members,members array} to form
// a ToolStrip.  Note that the +link{FormItem,FormItems} mentioned above (ComboBox and
// drop-down selects) need to be placed within a +link{DynamicForm} as usual.
// <P>
// <smartclient>
// The following strings can be used to add special behaviors:
// <ul>
// <li>the String "separator" will cause a separator to be created (instance of
// +link{toolStrip.separatorClass})
// <li>the String "resizer" will cause a resizer to be created (instance of
// +link{toolStrip.resizeBarClass}).  This is equivalent to setting
// +link{canvas.showResizeBar,showResizeBar:true} on the preceding member.
// <li>the String "starSpacer" will cause a spacer to be created (instance of
// +link{class:LayoutSpacer}).
// </ul>
// </smartclient>
// <smartgwt>
// Instances of the following classes can be used to add special behaviors:
// <ul>
// <li>the +link{class:ToolStripSeparator} class will show a separator.
// <li>the +link{class:ToolStripResizer} class will show a resizer. This is equivalent to setting
// +link{canvas.showResizeBar,showResizeBar:true} on the preceding member.
// <li>the +link{class:ToolStripSpacer} class will show a spacer.
// </ul>
// See the +explorerExample{toolstrip} example.
// </smartgwt>
//
// @inheritsFrom Layout
// @treeLocation Client Reference/Layout
// @visibility external
// @example toolstrip
//<

isc.defineClass("ToolStrip", "Layout").addProperties({

    //> @attr toolStrip.members (Array of Canvas : null : IR)
    // Array of components that will be contained within this Toolstrip, like
    // +link{Layout.members}. Built-in special behaviors can be indicated as
    // describe +link{class:ToolStrip,here}.
    //
    // @visibility external
    // @example toolstrip
    //<


    //> @attr toolStrip.height (Number : 20 : IRW)
    // ToolStrips set a default +link{Canvas.height,height} to avoid being stretched by
    // containing layouts.
    // @group sizing
    // @visibility external
    //<
    height: 20,

    defaultWidth: 250,

    //> @attr toolStrip.styleName (CSSStyleName : "toolStrip" : IRW)
    // CSS class applied to this toolstrip.
    // <P>
    // Note that if +link{toolStrip.vertical} is true for this toolStrip,
    // +link{toolStrip.verticalStyleName} will be used instead of this value if it is non-null.
    //
    // @group appearance
    // @visibility external
    //<
    styleName: "toolStrip",

    //> @attr toolStrip.verticalStyleName (CSSStyleName : null : IR)
    // Default stylename to use if +link{toolStrip.vertical,this.vertical} is true.
    // If unset, the standard +link{styleName} will be used for both vertical and horizontal
    // toolstrips.
    // <P>
    // Note that this property only applies to the widget at init time. To modify the
    // styleName after this widget has been initialized, you should
    // simply call +link{canvas.setStyleName(),setStyleName()} rather than updating this
    // property.
    // @group appearance
    // @visibility external
    //<

    //>    @attr    toolStrip.vertical        (Boolean : false : IR)
    // Indicates whether the components are drawn horizontally from left to right (false), or
    // vertically from top to bottom (true).
    //        @group    appearance
    //      @visibility external
    //<
    vertical:false,

    //> @attr toolStrip.resizeBarClass (String : "ToolStripResizer" : IR)
    // Customized resizeBar with typical appearance for a ToolStrip.
    // @visibility external
    //<
    // NOTE: class definition in Splitbar.js
    resizeBarClass: "ToolStripResizer",

    //> @attr toolStrip.resizeBarSize (int : 14 : IRA)
    // Thickness of the resizeBars in pixels.
    // @visibility external
    //<
    resizeBarSize: 14,

    //> @attr toolStrip.separatorClass (String : "ToolStripSeparator" : IR)
    // Class to create when the string "separator" appears in +link{toolStrip.members}.
    // @visibility external
    //<
    separatorClass : "ToolStripSeparator",

    //> @attr toolStrip.separatorSize (int : 8 : IR)
    // Separator thickness in pixels
    // @visibility external
    //<
    separatorSize : 8,

    //> @attr toolStrip.separatorBreadth (int : 22 : IR)
    // Separator height, when vertical is true, or width otherwise.
    // @visibility external
    //<
    // this is the same size as toolStripButton size
    separatorBreadth: 22,

    init : function () {
        // if there's no fixed width, set a flag to reflow on draw() - see comment there
        if (!isc.isA.Number(this.width)) this.reflowOnDraw = true;
        return this.Super("init", arguments);
    },

    initWidget : function (a,b,c,d,e,f) {
        this.members = this._convertMembers(this.members);
        this.invokeSuper(isc.ToolStrip, this._$initWidget, a,b,c,d,e,f);

        if (this.vertical && this.verticalStyleName != null) {
            this.setStyleName(this.verticalStyleName);
        }
    },

    draw : function () {
        var result = this.Super("draw", arguments);

        if (this.reflowOnDraw) this.reflow(true);
        return result;
    },

    // support special "separator" and "resizer" strings
    _convertMembers : function (members) {
        if (members == null) return null;
        var separatorClass = isc.ClassFactory.getClass(this.separatorClass, true),
            newMembers = [];
        for (var i = 0; i < members.length; i++) {
            var m = members[i];
            if (m == "separator") {
                var separator = separatorClass.createRaw();
                separator.autoDraw = false;
                separator.vertical = !this.vertical;
                if (this.vertical) {
                    separator.height = this.separatorSize;
                    separator.width = this.separatorBreadth;
                } else {
                    separator.width = this.separatorSize;
                    separator.height = this.separatorBreadth;
                }
                separator.completeCreation();
                newMembers.add(isc.SGWTFactory.extractFromConfigBlock(separator));
            } else if (m == "resizer" && i > 0) {
                members[i-1].showResizeBar = true;
            } else if (m == "starSpacer") {

                var params = (this.vertical ? { height: "*" } : { width: "*" });
                newMembers.add(isc.LayoutSpacer.create(params));

            // handle being passed an explicitly created ToolStripResizer instance.
            // This is normal usage from Component XML or SGWT

            } else if (isc.isA.ToolStripResizer(m) && i > 0) {
                members[i-1].showResizeBar = true;
                m.destroy();
            } else {
                // handle being passed an explicitly created ToolStripSeparator instance.
                // This is normal usage from Component XML or SGWT
                if (!isc.isA.ToolStripSeparator(m) && !isc.isA.ToolStripSpacer(m) && !isc.isA.RibbonGroup(m)) {
                    // punt to Canvas heuristics
                    m = this.createCanvas(m);
                }
                if (isc.isA.ToolStripSeparator(m)) {
                    var separator = m;
                    separator.vertical = !this.vertical;
                    separator.setSrc(this.vertical ? separator.hSrc : separator.vSrc);
                    if (this.vertical) {
                        separator.setHeight(this.separatorSize);
                        separator.setWidth(this.separatorBreadth);
                    } else {
                        separator.setWidth(this.separatorSize);
                        separator.setHeight(this.separatorBreadth);
                    }
                    separator.markForRedraw();
                } else if (isc.isA.ToolStripSpacer(m)) {
                    // Apply size from the spacer "space" property according to orientation
                    var size = m.space >> 0 || "*";

                    if (this.vertical) {
                        m.height = size;
                        m.setHeight(size);
                    } else {
                        m.width = size;
                        m.setWidth(size);
                    }
                } else if (isc.isA.RibbonGroup(m)) {
                    // apply some overrides here
                    if (!m.showTitle) m.setShowTitle(this.showGroupTitle);
                    if (!m.titleAlign) m.setTitleAlign(this.groupTitleAlign);
                    if (!m.titleOrientation) m.setTitleOrientation(this.groupTitleOrientation);
                }

                newMembers.add(m);
            }
        }
        return newMembers;
    },
    addMembers : function (newMembers, position, dontAnimate, d, e) {
        if (!newMembers) return;
        if (!isc.isAn.Array(newMembers)) newMembers = [newMembers];

        var firstMember = newMembers[0],
            isResizerWidget = isc.isA.ToolStripResizer(firstMember);
        if (firstMember == "resizer" || isResizerWidget) {
            if (position == null) position = this.members.length;
            var precedingPosition = Math.min(position, this.members.length) -1;
            if (precedingPosition >= 0) {
                var precedingMember = this.getMember(precedingPosition);
                if (precedingMember != null) {
                    precedingMember.showResizeBar = true;
                    this.reflow();
                }
            }
            var resizer = newMembers.shift();
            if (isResizerWidget) resizer.destroy();
        }

        newMembers = this._convertMembers(newMembers);
        return this.invokeSuper(isc.ToolStrip, "addMembers", newMembers, position, dontAnimate,
                                d, e);
    },

    //> @method toolStrip.addFormItem()
    // Add a form item to this toolStrip. This method will create a DynamicForm autoChild with the
    // item passed in as a single item, based on the
    // +link{formWrapper,formWrapper config}, and add it to the toolstrip
    // as a member.
    // <P>
    // Returns a pointer to the generated formWrapper component.
    // @param formItem (FormItem Properties) properties for the form item to add to this
    //  toolStrip.
    // @param [formProperties] (DynamicForm Properties) properties to apply to the generated
    //  formWrapper component. If passed, specified properties will be overlaid onto the
    //  properties derived from +link{toolStrip.formWrapperDefaults} and
    //  +link{toolStrip.formWrapperProperties}.
    // @param [position] (Integer) desired position for the form item in the tools
    // @return (DynamicForm) generated wrapper containing the form item.
    // @visibility external
    //<
    addFormItem : function (formItem, formProperties, position) {
        // Sanity check - if passed a canvas, add it and return.
        if (isc.isA.Canvas(formItem)) {
            this.addMember(formItem, position);
            return formItem;
        }

        var wrapper = this.createAutoChild("formWrapper", formProperties);
        wrapper.setItems([formItem]);
        this.addMember(wrapper, position);
        return wrapper;

    },

    //> @attr toolStrip.formWrapper (MultiAutoChild DynamicForm : null : IR)
    // DynamicForm instance created by +link{addFormItem()} to contain form items for
    // display in this toolStrip. Each time addFormItem() is run, a new formWrapper
    // autoChild will be created, picking up properties according to the standard
    // +link{type:AutoChild} pattern.
    // @visibility external
    //<

    //> @attr toolStrip.formWrapperConstructor (String : "DynamicForm" : IRA)
    // SmartClient class for generated +link{toolStrip.formWrapper} components.
    // @visibility external
    //<
    formWrapperConstructor:"DynamicForm",

    //> @attr toolStrip.formWrapperDefaults (DynamicForm Properties : ... : IR)
    // Default properties to apply to +link{formWrapper} components.
    // <P>
    // The default configuration will has the following settings:
    // <ul>
    // <li>+link{dynamicForm.numCols} set to <code>2</code></li>
    // <li>+link{dynamicForm.overflow} set to <code>"visible"</code></li>
    // <li>+link{dynamicForm.width} and +link{dynamicForm.height} set to <code>1</code></li>
    // </ul>
    // To customize the wrapper form for an individual item, use the <code>formProperties</code> argument
    // of +link{toolStrip.addFormItem()}.
    //
    // @visibility external
    //<
    formWrapperDefaults:{
        numCols:2,
        overflow:"visible",
        width:1, height:1
    }

    //> @attr toolStrip.formWrapperProperties (DynamicForm Properties : null : IR)
    // Properties to apply to +link{formWrapper} components.
    // @visibility external
    //<

});

//> @class ToolStripSeparator
// Simple subclass of Img with appearance appropriate for a ToolStrip separator
// @inheritsFrom Img
// @treeLocation Client Reference/Layout/ToolStrip
//
// @visibility external
//<
isc.defineClass("ToolStripSeparator", "Img").addProperties({
    //> @attr toolStripSeparator.skinImgDir (SCImgURL : "images/ToolStrip/" : IR)
    // Path to separator image.
    // @visibility external
    //<
    skinImgDir:"images/ToolStrip/",

    //> @attr toolStripSeparator.vSrc (SCImgURL : "[SKIN]separator.png" : IR)
    // Image for vertically oriented separator (for horizontal toolstrips).
    // @visibility external
    //<
    vSrc:"[SKIN]separator.png",

    //> @attr toolStripSeparator.hSrc (SCImgURL : "[SKIN]hseparator.png" : IR)
    // Image for horizontally oriented separator (for vertical toolstrips).
    // @visibility external
    //<
    hSrc:"[SKIN]hseparator.png",

    // NOTE: we keep the default imageType:"stretch", which looks fine for the default image,
    // which is just two vertical lines.

    // prevents misalignment if ToolStrip is stretched vertically by members
    layoutAlign:"center",

    initWidget : function () {
        // vertical switch of hSrc/vSrc is handled by StretchImg, but not by Img
        if (isc.isA.Img(this)) this.src = this.vertical ? this.vSrc : this.hSrc;

        this.Super("initWidget", arguments);
    },

    // center the image because the container's height changes with density
    imageType: "center",

    _markerName: "separator",

    // Don't write Component XML as separate entity
    _generated: true,
    // Don't write anything but constructor in Component XML
    updateEditNode : function (editContext, editNode) {
        editContext.removeNodeProperties(editNode, ["autoDraw", "ID", "autoID", "title"]);
    }
});

//> @class ToolStripSpacer
// Simple subclass of LayoutSpacer with appearance appropriate for a ToolStrip spacer
// @inheritsFrom LayoutSpacer
// @treeLocation Client Reference/Layout/ToolStrip
//
// @visibility external
//<
isc.defineClass("ToolStripSpacer", "LayoutSpacer").addProperties({

    //> @attr toolStripSpacer.space (Number : null : IR)
    // Size of spacer. If not specified, spacer fills remaining space.
    // @visibility external
    //<

    propertyChanged : function (propName, value) {
        // If "space" changes, update the spacer to the new, matching size
        if (propName == "space") {
            var size = this.space >> 0 || "*";
            if (this.parentElement.vertical) {
                this.setHeight(size);
            } else {
                this.setWidth(size);
            }
        }
    },

    _markerName: "starSpacer",

    // Don't write Component XML as separate entity
    _generated: true,
    // Don't write anything but constructor in Component XML
    updateEditNode : function (editContext, editNode) {
        editContext.removeNodeProperties(editNode, ["autoDraw", "ID", "autoID", "title"]);
    }
});

//> @class ToolStripButton
// Simple subclass of Button with appearance appropriate for a ToolStrip button.
// Can be used to create an icon-only button, and icon with text, or a text only button by setting the
// icon and title attributes as required.
// @inheritsFrom Button
// @visibility external
// @treeLocation Client Reference/Layout/ToolStrip
//<

isc.defineClass("ToolStripButton", "Button").addProperties({

    //showTitle:true,
    showRollOver:true,
    showDown:true,


    labelHPad:6,
    labelVPad:0,
    autoFit:true,


    initWidget : function () {
        if (!this.title) this.iconSpacing = 0;
        this.Super("initWidget", arguments);
    },
    setTitle : function (newTitle) {
        if (!newTitle) {
            this.iconSpacing = 0;
            if (this.label) this.label.iconSpacing = 0;
        }
        this.Super("setTitle", arguments);
    },

    src:"[SKIN]/ToolStrip/button/button.png",
    capSize:3,
    height:22
});

//> @class Header
// Component for showing a header with an optional +link{header.title,title}. Styling matches
// a +link{headerItem}.
// <p>
// This header is a special type of ToolStrip, so any ToolStrip controls can
// be added to the Header.  Consider also the SectionStack and
// SectionHeader if you want expand/collapse behavior or multiple sections.
// @inheritsFrom ToolStrip
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("Header", "ToolStrip").addProperties({

    // Styling to match HeaderItem
    styleName: "headerItem",

    //> @attr header.title (HTMLString : null : IWR)
    // Title to show for the header. If configured, a Label is automatically created
    // as the first member using the style <code>headerItem</code> to match the styling of
    // the header itself and a +link{headerItem}.
    //
    // @see header.titleLabel
    // @visibility external
    // @setter setTitle
    //<

    //> @attr header.titleLabel (AutoChild Label : null : IR)
    // Label autoChild for +link{title,title} display.
    // <P>
    // This can be customized via the standard +link{type:AutoChild} pattern.
    // @visibility external
    //<
    titleLabelDefaults: {
        _constructor: "Label",
        _isTitleLabel: true,
        baseStyle:"headerItem",
        padding: 2,
        autoFit: true,
        wrap: false
    }
});

isc.Header.addMethods({

    initWidget : function () {

        // Create the title label if the title property is provided. It always goes first.
        if (this.title) {
            if (!this.members || this.members.length == 0) {
                this.members = [this.createTitleLabel(this.title)];
            } else if(this.members && !this.members[0]._isTitleLabel) {
                this.members.addAt(this.createTitleLabel(this.title), 0);
            }
        }

        this.Super(this._$initWidget);
    },

    // adjust position leaving title in position 0 always
    addMembers : function (newMembers, position, dontAnimate,d,e) {
        position = (position != null ? position+1 : null);
        return this.Super("addMembers", [newMembers, position, dontAnimate,d,e]);
    },

    createTitleLabel : function (title) {
        this._titleLabel = this.createAutoChild("titleLabel", { contents: title });
        return this._titleLabel;
    },

    //> @method header.setTitle()
    // Setter for the +link{header.title,title}.
    // @param newTitle (HTMLString) the new title HTML.
    // @visibility external
    //<
    setTitle : function (newTitle) {
        // remember the contents
        this.title = newTitle;
        // For performance, don't force a redraw / setContents, etc if the
        // title is unchanged
        if (this._titleHTML != null && this._titleHTML == newTitle) {
            return;
        } else {
            this._titleHTML = newTitle;
        }
        if (!this._titleLabel) {
            this.addMember(this.createTitleLabel(this.title));
        }
        this._titleLabel.setContents(newTitle);
    }
});






//> @class RibbonBar
// A +link{class:ToolStrip, ToolStrip-based} class for showing
// +link{class:RibbonGroup, groups} of +link{class:RibbonButton, RibbonButtons}s.
//
// @inheritsFrom ToolStrip
// @treeLocation Client Reference/Layout
// @visibility external
//<
isc.defineClass("RibbonBar", "ToolStrip").addProperties({
    //> @attr ribbonBar.showGroupTitle (Boolean : true : IR)
    // If set, this attribute affects whether +link{class:RibbonGroup, RibbonGroups}
    // in this <code>RibbonBar</code> show their header control.  You can override this at the
    // +link{ribbonGroup.setShowTitle, individual RibbonGroup} level.
    // @group ribbonGroup
    // @visibility external
    //<
    showGroupTitle : true,

    //> @attr ribbonBar.groupTitleAlign (Alignment : "center" : IR)
    // If set, this attribute affects the alignment of the titles in
    // +link{class:RibbonGroup, RibbonGroups} in this <code>RibbonBar</code>.  You can
    // override this at the +link{RibbonGroup.titleAlign, individual RibbonGroup} level.
    // @group ribbonGroup
    // @visibility external
    //<
    groupTitleAlign : "center",

    //> @attr ribbonBar.groupTitleOrientation (VerticalAlignment : "top" : IR)
    // If set, this attribute affects the orientation of the titles in
    // +link{class:RibbonGroup, RibbonGroups} in this <code>RibbonBar</code>.  You can
    // override this at the +link{RibbonGroup.titleOrientation, individual RibbonGroup} level.
    // @group ribbonGroup
    // @visibility external
    //<
    groupTitleOrientation : "top",

    membersMargin: 2,
    layoutMargin: 2,

    groupConstructor: "RibbonGroup",

    //> @method ribbonBar.addGroup()
    // Add a new group to this RibbonBar. You can either create your group externally and pass
    // it in, or you can pass a properties block from which to automatically construct it.
    //
    // @param group (RibbonGroup) the new group to add to this ribbon
    // @param [position] (Integer) the index at which to insert the new group
    // @group ribbonGroup
    // @visibility external
    //<
    addGroup : function (group, position) {
        if (!group) return null;

        if (!isc.isA.Class(group)) {
            var cons = this.groupConstructor;
            if (isc.isA.String(cons)) {
                cons = isc.ClassFactory.getClass(this.groupConstructor, true);
            }
            group = cons.create(group);
        }

        if (!group || !isc.isA.RibbonGroup(group)) return null;

        // apply some overrides here
        if (group.showTitle == null) group.setShowTitle(this.showGroupTitle);
        if (!group.titleAlign) group.setTitleAlign(this.groupTitleAlign);
        if (!group.titleOrientation) group.setTitleOrientation(this.groupTitleOrientation);

        this.addMember(group, position);
        return group;
    },

    destroy : function () {
        // destroy all the children
        if (this.members) {
            for (var i=0; i<this.members.length; i++) {
                var m = this.members[i];
                if (m && !m.destroying && !m.destroyed) m.destroy();
                this.members[i] = null;
                m = null;
            }
        }
        return this.Super("destroy", arguments);
    },

    // if Reify has a size-lock on the passed widget, release the lock and store a flag
    // indicating it needs to be restored later - returns true if the lock was released
    releaseReifySizeLock : function (widget) {
        widget = widget || this;

        // not editing or already released
        if (!widget.editingOn || widget._reifySizeLockReleased) return false;

        if (widget.editContext.isEditNodeSelected(widget.editNode)) {
            //this.logWarn("releasing " + widget.ID + " size-lock");
            widget._reifySizeLockReleased = true;
            widget.editProxy.showSelectedAppearance(false)
            return true;
        }

        return false;
    },
    // if Reify has the passed widget selected but does not have a size-lock on it, restore
    // the lock and clear the flag - returns true if the lock was restored
    restoreReifySizeLock : function (widget) {
        widget = widget || this;

        // not editing or not previously released
        if (!widget.editingOn || !widget._reifySizeLockReleased) return false;

        //this.logWarn("restoring " + widget.ID + " size-lock");

        if (widget != this) this.redraw();

        delete widget._reifySizeLockReleased;
        widget.editProxy.showSelectedAppearance(true)

        return true;
    }

});

//> @class RibbonGroup
//
// A widget that groups +link{class:RibbonButton, RibbonButtons}s for use in
// +link{class:RibbonBar, RibbonBars}.
//
// @inheritsFrom VLayout
// @treeLocation Client Reference/Layout/RibbonBar
// @visibility external
//<
isc.defineClass("RibbonGroup", "VLayout").addProperties({
    //> @attr ribbonGroup.newControlConstructor (Class : "RibbonButton" : IR)
    // Widget class for controls +link{createControl, created automatically} by this
    // RibbonGroup.  Since +link{newControlConstructor, such controls} are created via the
    // autoChild system, they can be further customized via the newControlProperties property.
    // @group ribbonGroup
    // @visibility external
    //<
    newControlConstructor: "RibbonButton",
    //> @attr ribbonGroup.newControlDefaults (MultiAutoChild RibbonButton : null : IR)
    // Properties used by +link{ribbonGroup.createControl, createControl} when creating new
    // controls.
    // @group ribbonGroup
    // @visibility external
    //<
    newControlDefaults: {
    },

    //> @method ribbonGroup.createControl()
    // Creates a new control and adds it to this RibbonGroup.  The control is created using the
    // autoChild system, according to the specified
    // +link{ribbonGroup.newControlConstructor, constructor} and the passed properties are
    // applied to it.
    //
    // @param properties (Canvas Properties) properties to apply to the new control
    // @param [position] (Integer) the index at which to insert the new control
    //
    // @visibility external
    //<
    createControl : function (properties, position) {
        var newControl = this.createAutoChild("newControl", properties);

        return this.addControl(newControl, position);
    },

    groupConstructor: "RibbonGroup",
    //> @attr ribbonGroup.styleName (CSSStyleName : "ribbonGroup" : IRW)
    // CSS class applied to this RibbonGroup.
    // @group appearance
    // @setter setStyleName()
    // @visibility external
    //<
    styleName: "ribbonGroup",

    canAcceptDrop: true,
    canDropComponents: false,

    drop : function (event, eventInfo) {
        var control = isc.EventHandler.getDragTarget();
        if (control) {
            this.addControl(control);
        }
        return false;
    },

    membersMargin: 1,

    layoutAlign: "top",

    autoDraw: false,

    height: 1,
    width: 1,
    overflow: "visible",

    //> @attr ribbonGroup.controls (Array of Canvas : null : IRW)
    // The array of controls to show in this group.
    //
    // @group ribbonGroup
    // @visibility external
    //<

    //> @attr ribbonGroup.labelLayout (AutoChild HLayout : null : IR)
    // HLayout autoChild that houses the +link{RibbonGroup.label, label}
    // in which the +link{RibbonGroup.title, title text} is displayed.
    // <P>
    // This can be customized via the standard +link{type:AutoChild} pattern.
    // @visibility external
    //<

    labelLayoutDefaults: {
        _constructor: "HLayout",
        width: "100%",
        autoDraw: false,
        height: 22
    },

    //> @attr ribbonGroup.labelConstructor (String : "Label" : IRA)
    // SmartClient class for the +link{RibbonGroup.label, title label} AutoChild.
    // @visibility external
    //<
    labelConstructor: "Label",

    //> @attr ribbonGroup.label (AutoChild Label : null : IR)
    // AutoChild +link{class:Label, Label} used to display the
    // +link{RibbonGroup.title, title text} for this group.
    // <P>
    // Can be customized via the standard +link{type:AutoChild} pattern, and various
    // convenience APIs exist for configuring it after initial draw: see
    // +link{RibbonGroup.setShowTitle, setShowTitle},
    // +link{RibbonGroup.setTitle, setTitle},
    // +link{RibbonGroup.setTitleAlign, setTitleAlign},
    // +link{RibbonGroup.setTitleHeight, setTitleHeight},
    // +link{RibbonGroup.setTitleOrientation, setTitleOrientation} and
    // +link{RibbonGroup.setTitleStyle, setTitleStyle}.
    // @visibility external
    //<
    labelDefaults: {
        width: "100%",
        height: 18,
        autoDraw: false,
        wrap: false,
        overflow: "visible",
        canAcceptDrop: false
    },

    //> @attr ribbonGroup.titleAlign (Alignment : "center" : IRW)
    // Controls the horizontal alignment of the group's
    // +link{RibbonGroup.title, title-text}, within its
    // +link{RibbonGroup.label, label}.  Setting this
    // attribute overrides the default specified by
    // +link{ribbonBar.groupTitleAlign, groupTitleAlign} on the containing
    // +link{class:RibbonBar, RibbonBar}.
    // @setter RibbonGroup.setTitleAlign
    // @group ribbonGroup
    // @visibility external
    //<
    titleAlign: "center",

    //> @attr ribbonGroup.titleStyle (CSSStyleName : "ribbonGroupTitle" : IRW)
    // CSS class applied to the +link{RibbonGroup.label, title label} in this group.
    // @setter RibbonGroup.setTitleStyle
    // @visibility external
    //<
    titleStyle: "ribbonGroupTitle",

    //> @attr ribbonGroup.autoSizeToTitle (Boolean : true : IR)
    // By default, <code>RibbonGroups</code> are assigned a minimum width that allows the
    // entire title to be visible.  To prevent this behavior and have group-titles cut off
    // when they're wider than the buttons they contain, set this attribute to false
    // @group title
    // @visibility external
    //<
    autoSizeToTitle: true,

    //> @attr ribbonGroup.titleOrientation (VerticalAlignment : "top" : IRW)
    // Controls the +link{RibbonGroup.titleOrientation, vertical orientation} of
    // this group's +link{RibbonGroup.label, title label}.  Setting this
    // attribute overrides the default specified by
    // +link{ribbonBar.groupTitleOrientation, groupTitleOrientation} on the containing
    // +link{class:RibbonBar, RibbonBar}.
    // @setter RibbonGroup.setTitleOrientation
    // @group ribbonGroup
    // @visibility external
    //<
    titleOrientation: "top",

    //> @attr ribbonGroup.titleProperties (AutoChild Label : null : IRW)
    // AutoChild properties for fine customization of the
    // +link{RibbonGroup.label, title label}.
    // @visibility external
    // @deprecated set these properties directly via the +link{RibbonGroup.label, label autoChild}
    //<

    //> @attr ribbonGroup.titleHeight (int : 18 : IRW)
    // Controls the height of the +link{RibbonGroup.label, title label} in this group.
    // @setter RibbonGroup.setTitleHeight
    // @visibility external
    //<
    titleHeight: 18,

    //> @attr ribbonGroup.body (AutoChild HLayout : null : IR)
    // HLayout autoChild that manages multiple +link{RibbonGroup.columnLayout, VLayouts}
    // containing controls.
    // @visibility external
    //<

    //> @attr ribbonGroup.bodyConstructor (String : "HLayout" : IRA)
    // SmartClient class for the body.
    // @visibility external
    //<
    bodyConstructor:"HLayout",

    bodyDefaults: {
        width: "100%",
        height: "*",
        overflow: "visible",
        membersMargin: 2,
        autoDraw: false,
        canAcceptDrop: false
    },

    // default mmembersMargin for columnLayouts - factored out of the defaults block so it
    // can be used in height calculations in RibbonButton code
    columnLayoutMembersMargin: 2,

    //> @attr ribbonGroup.columnLayout (MultiAutoChild VLayout : null : IR)
    // AutoChild VLayouts created automatically by groups.  Each manages a single column of
    // child controls in the group.  Child controls that support <code>rowSpan</code> may
    // specify it in order to occupy more than one row in a single column.  See
    // +link{RibbonGroup.numRows, numRows} for related information.
    // @visibility external
    //<
    // some autochild defaults for the individual VLayouts that represent columns
    columnLayoutDefaults: {
        _constructor: "VLayout",
        width: 1,
        height: "100%",
        overflow: "visible",
        autoDraw: false,
        numRows: 0,
        canAcceptDrop: false,
        setActive : function (makeActive) {
            if (makeActive == null) makeActive = true;
            this.active = makeActive;
            if (this.active && !this.isDrawn() && this.parentElement &&
                this.parentElement.isDrawn && this.parentElement.isDrawn()) this.draw();
            if (!makeActive && this.isDrawn()) this.clear();
        },
        addMember : function (member, position) {
            this.Super("addMember", arguments);

            //isc.logWarn(this.ID + "::addMember - " + member.ID + " with rowSpan " + member.rowSpan +
            //        (position != null ? ", " + position : "") + " -- numRows: " + this.numRows +
            //        ", maxRows: " + this.maxRows);

            if (member.rowSpan == null) member.rowSpan = 1;
            var height = member.rowSpan * this.creator.rowHeight +
                ((member.rowSpan-1) * this.membersMargin);

            if (member.vertical) {
                height = (this.maxRows * this.creator.rowHeight) +
                    ((this.maxRows-1) * this.membersMargin);

                // use all slots in the column
                this.numRows = this.maxRows;
            } else {
                this.numRows += member.rowSpan;
            }

            //isc.logWarn("    height is now " + member.getHeight() + " || numRows is now " + this.numRows);

            // set the height of the button - then, if in editMode, push the height to the
            // liveObject, so that reify doesn't restore an old height when you unselect the
            // button
            var ribbon = this.creator.getRibbon();
            var released = ribbon ? ribbon.releaseReifySizeLock(member) : false;
            member.setHeight(height);
            if (member.editingOn && member.editNode && member.editNode.liveObject) {
                member.editNode.liveObject.setHeight(height);
            }
            var restored = ribbon ? ribbon.restoreReifySizeLock(member) : false;

            this.reflow();

            // this layout is now in use
            this.setActive(true);
        },
        removeMember : function (member) {
            this.Super("removeMember", arguments);

            delete member._currentColumn;
            if (member._dragPlaceHolder) return;

            if (member.rowSpan == null) member.rowSpan = 1;
            this.numRows -= member.rowSpan;

            if (this.numRows < 0) this.numRows = 0;

            // layout is no longer in use
            if (this.numRows == 0) this.setActive(false);

            // don't destroy members
        }

    },

    //> @attr ribbonGroup.numRows (Number : 1 : IRW)
    // The number of rows of controls to display in each column.  Each control will take one
    // row in a +link{RibbonGroup.columnLayout, columnLayout} by default, but those that
    // support the feature may specify <code>rowSpan</code> to override that.
    // <P>
    // Note that settings like this, which affect the group's layout, are not applied directly
    // if changed at runtime - a call to +link{RibbonGroup.reflowControls, reflowControls}
    // will force the group to reflow.
    // @visibility external
    //<
    numRows: 1,

    setNumRows : function (numRows) {
        this.numRows = numRows;
        this.delayCall("delayedUpdateControls");
    },

    delayedUpdateControls : function () {
        this.resizeTo(1,1);
        this.getRibbon() && this.getRibbon().releaseReifySizeLock(this);
        this._updateControls(true);
        this.getRibbon() && this.getRibbon().restoreReifySizeLock(this);
    },

    //> @attr ribbonGroup.rowHeight (Number : 26 : IRW)
    // The height of rows in each column.
    // @visibility external
    //<
    rowHeight: 26,

    defaultColWidth: "*",

    initWidget : function () {
        //init the columnLayouts array
        this.columnLayouts = [];

        this.Super("initWidget", arguments);

        var showLabel = this.showTitle != false && this.showLabel != false;

        if (showLabel) {
            this.addAutoChild("labelLayout", { height: this.titleHeight });

            var labelProps = isc.addProperties({}, this.titleProperties || {}, {
                styleName: this.titleStyle,
                height: this.titleHeight,
                maxHeight: this.titleHeight,
                align: this.titleAlign,
                contents: this.title,
                autoDraw: false,
                // proxy events like click to the RibbonGroup
                eventProxy: this
            });

            if (this.autoSizeToTitle == false) labelProps.overflow = "hidden";

            this.addAutoChild("label", labelProps);

            this.labelLayout.addMember(this.label);

            if (this.showTitle == false) this.labelLayout.hide();
            this.addMember(this.labelLayout);
        }

        this.addAutoChild("body", {
            _constructor: this.bodyConstructor,
            height: this.numRows * this.rowHeight,
            parentResized : function () {
                var newWidth = this.getVisibleWidth();
                if (this.parentElement.label) this.parentElement.label.setWidth(newWidth);
            }
        });

        this.addMember(this.body, showLabel ? (this.titleOrientation == "bottom" ? 0 : 1) : 0);

        // observe body-resize
        this.observe(this.body, "resized", "observer.bodyResized(observed);");

        // add an initial column
        this.addColumn();

        var controls = this.controls || [];
        this.controls = [];
        if (!this.editingOn && controls.length > 0) {
            // if not in editMode, add the controls - editMode adds them with separate calls to
            // addControl()
            this.setControls(controls);
        }
    },

    // resize the title labelLayout when the body overflows, so it always fills width
    bodyResized : function (body) {
        var newWidth = this.body.getVisibleWidth();
        // if the group isn't withing a few px of the body width, resize the group to the body
        if (Math.abs(this.getVisibleWidth() - newWidth) > 5) this.setWidth(newWidth);
        if (this.labelLayout) this.labelLayout.setWidth(newWidth);
    },

    destroy : function () {
        // ignore body-resize
        this.ignore(this.body, "resized");
        for (var i=0; i<this.controls.length; i++) {
            // ignore visibilityChanged observation
            this.ignoreControl(this.controls[i]);
            this.controls[i].destroy();
            this.controls[i] = null;
        }
        if (this.members) {
            for (var i=0; i<this.members.length; i++) {
                var m = this.members[i];
                if (m && !m.destroying && !m.destroyed) m.destroy();
                this.members[i] = null;
                m = null
            }
        }
        return this.Super("destroy", arguments);
    },

    //> @attr ribbonGroup.title (String : null : IRW)
    // The title text to display in this group's
    // +link{RibbonGroup.label, title label}.
    // @setter RibbonGroup.setTitle
    // @group ribbonGroup
    // @visibility external
    //<

    //> @method ribbonGroup.setTitle()
    // Sets the +link{RibbonGroup.title, text} to display in this group's
    // +link{RibbonGroup.label, title label} after initial draw.
    //
    // @param title (String) The new title for this group
    // @visibility external
    //<
    setTitle : function (title) {
        this.title = title;
        if (this.label) this.label.setContents(this.title);
    },

    //> @method ribbonGroup.setShowTitle()
    // This method forcibly shows or hides this group's
    // +link{RibbonGroup.label, title label} after initial draw.
    // @param showTitle (boolean) should the title be shown or hidden?
    // @visibility external
    //<
    setShowTitle : function (showTitle) {
        this.showTitle = showTitle;
        if (!showTitle && this.labelLayout && this.labelLayout.isVisible()) this.labelLayout.hide();
        else if (showTitle && this.labelLayout && !this.labelLayout.isVisible()) this.labelLayout.show();
    },

    //> @method ribbonGroup.setTitleAlign()
    // This method forcibly sets the horizontal alignment of the
    // +link{RibbonGroup.title, title-text}, within the
    // +link{RibbonGroup.label, title label}, after initial draw.
    // @param align (Alignment) the new alignment for the text, left or right
    // @group ribbonGroup
    // @visibility external
    //<
    setTitleAlign : function (align) {
        this.titleAlign = align;
        if (this.label) this.label.setAlign(this.titleAlign);
    },

    //> @method ribbonGroup.setTitleStyle()
    // This method forcibly sets the +link{RibbonGroup.titleStyle, CSS class name}
    // for this group's +link{RibbonGroup.label, title label} after initial draw.
    //
    // @param styleName (CSSStyleName) the CSS class to apply to the
    //                                 +link{RibbonGroup.label, title label}.
    // @visibility external
    //<
    setTitleStyle : function (styleName) {
        this.titleStyle = styleName;
        if (this.label) {
            this.label.setStyleName(this.titleStyle);
            if (this.label.isDrawn()) this.label.redraw();
        }
    },

    //> @method ribbonGroup.setTitleOrientation()
    // This method forcibly sets the
    // +link{RibbonGroup.titleOrientation, vertical orientation} of this group's
    // +link{RibbonGroup.label, title label} after initial draw.
    // @param orientation (VerticalAlignment) the new orientation for the title, either bottom or top
    // @group ribbonGroup
    // @visibility external
    //<
    setTitleOrientation : function (orientation) {
        this.titleOrientation = orientation;
        if (this.label && this.labelLayout) {
            if (this.titleOrientation == "top") {
                this.removeMember(this.labelLayout);
                this.addMember(this.labelLayout, 0);
            } else if (this.titleOrientation == "bottom") {
                this.removeMember(this.labelLayout);
                this.addMember(this.labelLayout, 1);
            }
        }
    },

    //> @method ribbonGroup.setTitleHeight()
    // This method forcibly sets the height of this group's
    // +link{RibbonGroup.label, title label} after initial draw.
    //
    // @param titleHeight (int) the new height for the +link{RibbonGroup.label, title label}
    // @visibility external
    //<
    setTitleHeight : function (titleHeight) {
        this.titleHeight = titleHeight;
        if (this.label) this.label.setHeight(this.titleHeight);
    },

    addColumn : function (index, controls) {
        if (!index && index != 0) index = this.columnLayouts.length;

        var colWidth = this.defaultColWidth;
        if (this.colWidths && this.colWidths[index] != null) colWidth = this.colWidths[index];

        var props = { maxRows: this.numRows, numRows: 0, width: colWidth,
            height: this.body.getInnerHeight()
        };

        props.membersMargin = this.columnLayoutMembersMargin;

        var newColumn = this.createAutoChild("columnLayout", props);

        // cache the column
        this.columnLayouts.add(newColumn);

        this.body.addMember(newColumn, index);

        if (controls) newColumn.addMembers(controls);

        return newColumn;
    },

    autoFillColumns: false,

    getAvailableColumn : function (createIfUnavailable, item) {
        var layouts = this.columnLayouts || [];

        //this.logWarn("in getAvailableColumn(" + !!createIfUnavailable + ", " + item.ID + ")");

        if (item.vertical) {
            // if the item is vertical: true, it always needs its own column - this can either
            // be an existing column where "active" is false (it's been created in the past but
            // isn't used by the current UI), or a new column
            for (var i=0; i<layouts.length; i++) {
                if (layouts[i].active) {
                    // layout in use already - if numRows is 0, we can use it
                    if (layouts[i].numRows == 0) {
                        //this.logWarn("    vertical item using ACTIVE layout: '" + layouts[i].ID + "'");
                        return layouts[i];
                    }
                } else {
                    layouts[i].setActive(true);
                    //this.logWarn("    vertical item re-using INACTIVE layout: '" + layouts[i].ID + "'");
                    return layouts[i];
                }
            }
        } else if (layouts && layouts.length > 0) {
            for (var i=0; i<layouts.length; i++) {
                var layout = layouts[i];

                // if the layout is already in use
                if (layout.active) {
                    var slots = layout.maxRows - layout.numRows;
                    if (slots > 0 && slots >= item.rowSpan) {
                        // if there are enough slots left in the layout
                        if (i == layouts.length - 1 || (!layouts[i+1] || !layouts[i+1].active)) {
                            // if it's the last entry, or last active one, use it
                            //this.logWarn("    horizontal item using LAST " +
                            //    (i != layouts.length - 1 ? "ACTIVE" : "") + " layout: " +
                            //    "'" + layout.ID + "'");
                            return layout;
                        } else if (this.autoFillColumns) {
                            // us it if we're allowing buttons to fill empty space (not at the end)
                            //this.logWarn("    horizontal item and autoFillColumns, using " +
                            //    "ACTIVE layout: '" + layout.ID + "'");
                            return layout;
                        }
                    }
                } else {
                    layout.setActive(true);
                    //this.logWarn("    horizontal item re-using INACTIVE layout: " + layout.ID);
                    return layout;
                }
            }
        }

        if (createIfUnavailable != false) {
            var col = this.addColumn();
            col.setActive(true);
            //this.logWarn("    " + (item.vertical ? "vertical" : "horizontal") + " item " +
            //    "creating NEW layout: " + col.ID);
            return col;
        }

        return null;
    },


    //> @method ribbonGroup.getControlColumn()
    // Return the +link{RibbonGroup.columnLayout, column widget} that contains the passed
    // control.
    //
    // @param control (Canvas) the control to find in this group
    // @return (Layout) the column widget containing the passed control
    // @visibility external
    //<
    getControlColumn : function (control) {
        var members = this.body.members;

        if (members && members.length > 0) {
            for (var i=members.length-1; i>=0; i--) {
                if (members[i].members.contains(control)) return members[i];
            }
        }

        return null;
    },

    //> @method ribbonGroup.setControls()
    // Clears the array of controls and then adds the passed array to this group,
    // creating new +link{RibbonGroup.columnLayout, columns} as necessary, according to each
    // control's <code>rowSpan</code> attribute and the group's
    // +link{RibbonGroup.numRows, numRows} attribute.
    //
    // @param controls (Array of Canvas) an array of widgets to add to this group
    // @visibility external
    //<
    setControls : function (controls, store) {
        this._settingControls = true;
        if (this.controls) {
            // don't remove all the controls if not drawn - not clear we ever
            // need to do this, in fact, since _updateControls() does it...
            if (this.isDrawn()) this.removeAllControls();
        }
        this.controls = controls;
        this._updateControls();
        // observe visibilityChanged on each control, to reflow at runtime
        for (var i=0; i<this.controls.length; i++) {
            this.observeControl(this.controls[i]);
        }
        delete this._settingControls;
    },

    //> @method ribbonGroup.reflowControls()
    // Forces this group to reflow following changes to attributes that affect layout, like
    // +link{RibbonGroup.numRows, numRows}.
    //
    // @visibility external
    //<
    reflowControls : function () {
        this._updateControls();
    },

    //> @method ribbonGroup.addControls()
    // Adds an array of controls to this group, creating new
    // +link{RibbonGroup.columnLayout, columns} as necessary, according to each control's
    // <code>rowSpan</code> value and the group's
    // +link{RibbonGroup.numRows, numRows} value.
    //
    // @param controls (Array of Canvas) an array of widgets to add to this group
    // @visibility external
    //<
    addControls : function (controls, store) {
        if (!controls) return;
        if (!isc.isAn.Array(controls)) controls = [controls];

        for (var i=0; i<controls.length; i++) {
            this.addControl(controls[i], null, store);
        }
    },

    //> @method ribbonGroup.addControl()
    // Adds a control to this <code>RibbonGroup</code>, creating a new
    // +link{RibbonGroup.columnLayout, column} as necessary, according to the control's
    // <code>rowSpan</code> value and the group's
    // +link{RibbonGroup.numRows, numRows} value.
    //
    // @param control (Canvas) a widget to add to this group
    // @param [index] (Integer) optional insertion index for this control
    // @visibility external
    //<
    addControl : function (control, index, skipUpdate) {
        if (!control) return null;
        if (this.controls.contains(control)) this.controls.remove(control);
        if (index == null) index = this.controls.length;
        control._ribbonGroup = this;
        // observe visibility changed on the control
        this.observeControl(control);
        this.controls.addAt(control, index);
        if (!skipUpdate) this._updateControls();
    },
    _addControl : function (control) {
        var column = this.getAvailableColumn(true, control);

        control._ribbonGroup = this;
        control._currentColumn = column.getID();
        // draw the column if it's not drawn
        if (this.isDrawn() && !column.isDrawn()) column.draw();
        if (!column.isVisible()) column.show();
        column.addMember(control);
        column.reflowNow();
    },

    // destroy and remove all the child VLayouts - this is more expensive, but might
    // assist with Reify drawing/sizing issues
    recreateChildLayouts: false,
    _updateControls : function (skipRestoreSize) {
        this._updatingControls = true;
        if (!skipRestoreSize && this.getRibbon()) this.getRibbon().releaseReifySizeLock(this);
        for (var i=0; i<this.controls.length; i++) {
            var control = this.controls[i];
            if (control._currentColumn) {
                var canvas = isc.Canvas.getById(control._currentColumn);
                //if (canvas && !canvas.destroyed) canvas.members.remove(control);
                if (canvas && !canvas.destroyed) canvas.removeMember(control);
            }
            control.clear();
            this.addChild(control, null, false);
            delete control._currentColumn;
        }

        // hide all the child VLayouts
        var _this = this;
        this.columnLayouts.map(function (item) {
            item.numRows = 0;
            item.maxRows = _this.numRows;
            item.active = false;
        });

        if (this.recreateChildLayouts) {
            // destroy and remove all the child VLayouts - this is more expensive, but might
            // assist with Reify drawing/sizing issues
            this.body.members.callMethod("destroy");
            this.body.members.clear();
        }

        // resize the body layout 10 1,1 - it will expand with overflow as columns are added
        this.body.resizeTo(1,1);

        if (!this.isDrawn() && this.parentElement && this.parentElement.isDrawn()) this.draw();

        for (var i=0; i<this.controls.length; i++) {
            var control = this.controls[i];
            if (!control.isVisible()) continue;
            this._addControl(control);
        }
        this.layoutChildren();
        this.redraw();

        if (!skipRestoreSize && this.getRibbon()) this.getRibbon().restoreReifySizeLock(this);
        delete this._updatingControls;
    },

    //> @method ribbonGroup.removeControl()
    // Removes a control from this <code>RibbonGroup</code>, destroying an existing
    // +link{RibbonGroup.columnLayout, column} if this is the last widget in that column.
    //
    // @param control (Canvas) a widget to remove from this group
    // @visibility external
    //<
    autoHideOnLastRemove: false,
    removeControl : function (control) {
        control = isc.isAn.Object(control) ? control : this.getMember(control);
        if (!control) return null;

        if (this.controls.contains(control)) this.controls.remove(control);
        this.getControlColumn(control).removeMember(control);
        control._ribbonGroup = null;
        this.ignoreControl(control);
        this._updateControls();
        if (this.body.members.length == 0 && this.autoHideOnLastRemove) {
            // hide ourselves
            this.hide();
        }
    },
    // observe _visibilityChanged on child controls to enable runtime reflow -
    // visibilityChanged() doesn't run before draw() and setVisibility() doesn't
    // imply that visibility actually changed
    observeControl : function (control) {
        if (!this.isObserving(control, "_visibilityChanged")) {
            this.observe(control, "_visibilityChanged", "observer.controlVisibilityChanged(observed);");
        }
    },
    // clear _visibilityChanged observation on child controls
    ignoreControl : function (control) {
        if (this.isObserving(control, "_visibilityChanged")) {
            this.ignore(control, "_visibilityChanged");
        }
    },
    controlVisibilityChanged : function (control) {
        if (this._settingControls || this._updatingControls) {
            return;
        }
        if (!this.isDrawn()) {
            this.logInfo("Delaying _updateControls() until draw()");
            this._updateControlsOnDraw = true;
            return;
        }
        this.logInfo(control.ID + " - visibility changed - Updating controls");
        this._updateControls();
    },

    removeAllControls : function () {
        if (!this.controls || this.controls.length == 0) return null;

        for (var i=0; i<this.controls.length; i++) {
            var control = this.controls[i];
            control.hide();
            if (control._currentColumn) {
                var canvas = isc.Canvas.getById(control._currentColumn);
                //if (canvas && !canvas.destroyed) canvas.members.remove(control);
                if (canvas && !canvas.destroyed && canvas.members.contains(control)) {
                    canvas.removeMember(control);
                }
            }
            this.controls[i] = null;
        }

        // clear out nulls - that is, any controls that got destroyed
        this.controls = [];

        this._updateControls();

        // shrink the group's body layout, so it can overflow properly when new controls arrive
        this.body.height = 1;
        this.height = 1;
        //this.redraw();
    },

    resized : function () {
        if (this.destroyed || this.destroying) return;
        this._updateLabel();
    },

    draw : function () {
        if (this.destroyed || this.destroying) return;
        this.Super("draw", arguments);
        this._updateLabel();
        if (this._updateControlsOnDraw) {
            delete this._updateControlsOnDraw;
            this._updateControls();
        }
    },

    redraw : function () {
        if (this.destroyed || this.destroying) return;
        this.Super("redraw", arguments);
        this._updateLabel();
    },

    _updateLabel : function () {
        //this.logWarn("in _updateLabel")


        var innerWidth = this.getInnerWidth(),
            newWidth = innerWidth
        ;
        if (newWidth < 0) {
            newWidth =  this.body ? this.body.getVisibleWidth() : this.getVisibleWidth();
        }

        if (this.label) this.label.setWidth(newWidth);
    },

getRibbon : function () {
    if (isc.isA.RibbonBar(this.parentElement)) return this.parentElement;
    return null;
},

// properties that when changed should trigger a redraw
_$updateControlsProperties : {
    //numRows:true
},

// propertyChanged - fired by setProperties for each modified property.
propertyChanged : function (propName, value) {
    this.invokeSuper(isc.RibbonGroup, "propertyChanged", propName, value);
    if (this._$updateControlsProperties[propName]) {
        this.getRibbon() && this.getRibbon().releaseReifySizeLock(this);
        this.resizeTo(1,1);
        this._updateControls(true);
        this.getRibbon() && this.getRibbon().restoreReifySizeLock(this);

        //this.logWarn("RibbonGroup: propertyChanged for " + propName + ":  " + value);
    }
    //>EditMode
    if (this.editingOn && this.editProxy) {
        //switch (propName) {
        //    break;
        //}
    }
    //<EditMode
}

});


//> @class RibbonButton
// A Button subclass that displays an +link{ribbonButton.icon, icon},
// +link{ribbonButton.showButtonTitle, title} and optional +link{ribbonButton.menuIconSrc, menuIcon}
// and is capable of +link{ribbonButton.vertical, horizontal and vertical} orientation.
//
// @inheritsFrom Button
// @treeLocation Client Reference/Layout/RibbonBar
// @visibility external
//<
isc.defineClass("RibbonButton", "Button").addProperties({
    // have the super-class ignore it's icon - this widget puts the icon in titleHTML
    _ignoreIcon: true,

// get the ribbonBar
getRibbon : function () {
    return this._ribbonGroup && this._ribbonGroup.getRibbon();
},
getRibbonGroup : function () {
    return this._ribbonGroup;
},


width: 1,
overflow: "visible",
height: 1,

autoDraw: false,

usePartEvents: true,

//> @attr ribbonButton.orientation (String : "vertical" : IRW)
// The orientation of this RibbonButton.  The default value, "vertical", renders
// +link{ribbonButton.icon, icon}, +link{ribbonButton.showButtonTitle, title} and potentially
// +link{ribbonButton.menuIconSrc, menuIcon}, from top to bottom: "horizontal" does the same
// from top to bottom.
// @group layout
// @visibility external
// @deprecated in favor of +link{ribbonButton.vertical} which, if set, takes precendence over this setting
//<
orientation: "vertical",

//> @attr ribbonButton.vertical (boolean : false : IRW)
// Whether this button renders vertically.  Renders the
// +link{ribbonButton.icon, icon}, +link{ribbonButton.showButtonTitle, title} and potentially
// +link{ribbonButton.menuIconSrc, menuIcon} from top to bottom, when true, and from left to right
// when false.
// @group layout
// @visibility external
//<
vertical: false,
setVertical : function (vertical) {
    this.getRibbon() && this.getRibbon().releaseReifySizeLock(this);
    if (this.vertical != vertical) {
        this.vertical = vertical;
    }

    var ribbonGroup = this.getRibbonGroup();


    if (ribbonGroup) {
        var height;
        if (this.vertical) {
            // vertical - use maxRows * rowHeight
            height = (this.maxRows * ribbonGroup.rowHeight) +
                    ((this.maxRows-1) * ribbonGroup.columnLayoutMembersMargin);
        } else {
            // not vertical - use button.rowSpan * rowHeight
            height = this.rowSpan * ribbonGroup.rowHeight +
                ((this.rowSpan-1) * ribbonGroup.columnLayoutMembersMargin);
        }
        this.setHeight(height);
    }

    this.setTitle(this.title);
    this.redraw();
    this.getRibbon() && this.getRibbon().restoreReifySizeLock(this);
    this.markForRedraw();
    this.forceGroupUpdate();
},

//> @attr ribbonButton.rowSpan (Number : 1 : IRW)
// When used in a +link{class:RibbonBar}, the number of rows this button should occupy in a
// single +link{RibbonGroup.columnLayout, column}.
// @group layout
// @visibility external
//<
rowSpan: 1,

setRowSpan : function (rowSpan) {
    this.getRibbon() && this.getRibbon().releaseReifySizeLock(this);
    // default to 1 if passed null or < 1
    if (!rowSpan || rowSpan < 1) rowSpan = 1;

    // clamp to group.numRows if rowSpan is more than that
    var ribbonGroup = this.getRibbonGroup();
    if (ribbonGroup){
        var maxRows = ribbonGroup.numRows;

        if (rowSpan > maxRows) {
            this.logWarn("setRowSpan() passed " + rowSpan + " but RibbonGroup.numRows is only " +
                maxRows + ".  Reducing to " + maxRows + ".");
            rowSpan = ribbonGroup.numRows;
        }


        this.setHeight(rowSpan * ribbonGroup.rowHeight);
    }
    this.rowSpan = rowSpan;
    this.redraw();
    this.getRibbon() && this.getRibbon().restoreReifySizeLock(this);
    this.forceGroupUpdate();
},

forceGroupUpdate : function () {
    if (!this._ribbonGroup) return;

    this.getRibbon() && this.getRibbon().releaseReifySizeLock(this);
    this._ribbonGroup._updateControls(true);
    this.getRibbon() && this.getRibbon().restoreReifySizeLock(this);
},

//> @attr ribbonButton.baseStyle (CSSStyleName : "ribbonButton" : IRW)
// Default stateful CSS class for this button.  When +link{iconStyle} or
// +link{ribbonButton.menuIconStyle} are unset, they will default to the value of this
// attribute, suffixed with <code>H/VIcon</code> or <code>H/VMenuIcon</code> respectively,
// depending on the value of +link{ribbonButton.vertical}.
// @group appearance
// @visibility external
//<
baseStyle: "ribbonButton",

//> @attr ribbonButton.iconStyle (CSSStyleName : null : IRW)
// Default CSS class for this button's +link{ribbonButton.icon}.  If unset, defaults to
// +link{ribbonButton.baseStyle} suffixed with <code>VIcon</code> or <code>HIcon</code>
// depending on the value of +link{ribbonButton.vertical}.
// @group appearance
// @visibility external
//<

//> @attr ribbonButton.menuIconStyle (CSSStyleName : null : IRW)
// Default CSS class to apply to the element showing this button's
// +link{ribbonButton.menuIconSrc, menu-icon}.  If unset, defaults to
// +link{ribbonButton.baseStyle} suffixed with <code>VMenuIcon</code> or <code>HMenuIcon</code>
// depending on the value of +link{ribbonButton.vertical}.
// @group appearance
// @visibility external
//<

//> @attr ribbonButton.showMenuIcon (Boolean : null : IRW)
// Whether to show the +link{menuIconSrc, menu-icon} which fires the +link{menuIconClick}
// notification method when clicked.
// @group menu
// @visibility external
//<
showMenuIcon: null,

//> @attr ribbonButton.menuIconSrc (SCImgURL : "[SKINIMG]/Menu/submenu_down.png" : IRW)
// Base URL for an Image that shows a +link{class:Menu, menu} when clicked.  See also
// +link{ribbonButton.showMenuIconDisabled} and +link{ribbonButton.showMenuIconOver}.
// @group menu
// @visibility external
//<
menuIconSrc: "[SKINIMG]/Menu/submenu_down.png",

//> @attr ribbonButton.menuIconWidth (Number : 14 : IRW)
// The width of the icon for this button.
// @group menu
// @visibility external
//<
menuIconWidth: 14,

//> @attr ribbonButton.menuIconHeight (Number : 13 : IRW)
// The height of the icon for this button.
// @group menu
// @visibility external
//<
menuIconHeight: 13,

menuConstructor: isc.Menu,

//> @attr ribbonButton.iconOrientation (String : null : IRW)
// This attribute is not supported in this subclass.  However, RTL mode is still supported.
//
// @visibility external
//<

//> @attr ribbonButton.iconAlign (String : null : IRW)
// This attribute is not supported in this subclass.  However, RTL mode is still supported.
//
// @visibility external
//<

//> @attr ribbonButton.align (Alignment : null : IRW)
// Horizontal alignment of this button's content.  If unset,
// +link{ribbonButton.vertical, vertical buttons} are center-aligned and horizontal
// buttons left-aligned by default.
// @group appearance
// @visibility external
//<
align: null,

//> @attr ribbonButton.valign (VerticalAlignment : null : IRW)
// Vertical alignment of this button's content.  If unset,
// +link{ribbonButton.vertical, vertical buttons} are top-aligned and horizontal
// buttons center-aligned by default.
// @group appearance
// @visibility external
//<
valign: null,

init : function () {
    // map deprecated "orientation" property to vertical, if that setting has been cleared
    if (this.vertical == null) {
        this.vertical = this.orientation == "vertical" ? true : false;
    }
    if (this.vertical) {
        this.align = this.align || "center";
        this.valign = this.valign || "top";
    } else {
        this.align = this.align || "left";
        this.valign = this.valign || "center";
    }
    this._originalAlign = this.align;
    this._originalVAlign = this.valign;

    // if showMenuIcon is not specifically turned off, turn it on if this.menu is set
    if (this.showMenuIcon != false && this.menu) this.showMenuIcon = true;

    return this.Super("init", arguments);
},
initWidget : function () {
    this.Super("initWidget", arguments);
},

//> @attr ribbonButton.showTitle (Boolean : null : IRW)
// showTitle is not applicable to this class - use +link{ribbonButton.showButtonTitle}
// instead.
//
// @visibility external
//<

//> @attr ribbonButton.showButtonTitle (Boolean : true : IRW)
// Whether to show the title-text for this RibbonButton.  If set to false, title-text is omitted
// altogether and just the icon is displayed.
// @group button
// @visibility external
//<
showButtonTitle: true,

//> @attr ribbonButton.showIcon (Boolean : null : IRW)
// Whether to show an Icon in this RibbonButton.  Set to false to render a text-only button.
// @group icon
// @visibility external
//<

//> @attr ribbonButton.icon (SCImgURL : null : IRW)
// Icon to show to the left of or above the title, according to the button's
// +link{ribbonButton.vertical, orientation}.
// <P>
// When specifying <code>vertical = true</code>, this icon will be stretched to
// the +link{largeIconSize} unless a +link{largeIcon} is specified.
// @group icon
// @visibility external
//<
icon: "[SKINIMG]actions/edit.png",

//> @attr ribbonButton.iconSize (Number : 16 : IRW)
// The size of the normal icon for this button.
// @group icon
// @visibility external
//<
iconSize: 16,

//> @method ribbonButton.setIcon()
// Sets a new Icon for this button after initialization.
// @param icon (SCImgURL) URL of new icon
// @group icon
// @visibility external
//<
setIcon : function (icon) {
    // this class sets Button._ignoreIcon on the super class, which prevents is from writing
    // button.icon into the DOM - instead, RibbonButton.getTitleHTML() includes this.icon in
    // the title HTML
    this.icon = icon;
    this.setTitle(this.title);
},
//> @method ribbonButton.getIcon()
// Returns the URL for the current icon.
// @return (SCImgURL) URL of current icon
// @group icon
// @visibility external
//<
getIcon : function () {
    return this.icon;
},

stateChanged : function () {
    if (this.destroyed || this.destroying) return;
    var result = this.Super("stateChanged", arguments);
    // rebuild the title, to include stateful icons for example
    //this.logWarn("in StateChanged")
    //this.redraw();
    //this.setTitle(this.title);
    return result;
},

//> @attr ribbonButton.largeIcon (SCImgURL : null : IRW)
// Icon to show above the title when +link{orientation} is "vertical".
// <P>
// If a largeIcon is not specified, the +link{icon, normal icon} will be stretched to
// the +link{largeIconSize}.
// @group icon
// @visibility external
//<

//> @method ribbonButton.setLargeIcon()
// Sets a new Large-Icon for vertical buttons after initialization - synonymous with
// +link{ribbonButton.setIcon, setIcon} for normal horizontal buttons.
// @group icon
// @visibility external
//<
setLargeIcon : function (icon) {
    // set the largeIcon and rebuild the title to incorporate it.
    this.largeIcon = icon;
    this.setTitle(this.title);
},

//> @attr ribbonButton.largeIconSize (Number : 32 : IRW)
// The size of the large icon for this button.  If +link{largeIcon} is not specified, the
// +link{icon, normal icon} will be stretched to this size.
// @group icon
// @visibility external
//<
largeIconSize: 32,

setTitle : function (title) {
    this.title = title;
    this.align = this._originalAlign;
    this.valign = this._originalVAlign;
    this.Super("setTitle", arguments);
},

titleSeparator: "&nbsp;",
getTitle : function () {
    return this.title;
},
getTitleHTML : function () {
    var isLarge = this.vertical,
        icon = this.showIcon == false ? null :
            (isLarge ? this.largeIcon || this.icon : this.icon),
        iconSize = (isLarge ? this.largeIconSize : this.iconSize),
        title = this.showButtonTitle ? this.title : ""
    ;

    if (icon == "") icon = null;

    // pick up disabled, over etc state if appropriate
    icon = this._getStatefulIconURL(icon);
    var img = icon ? this.imgHTML({
            src: icon,
            width: iconSize,
            height: iconSize,
            eventStuff: " eventpart='icon'",
            cssClass: this.iconStyle ||
                (isLarge ? this.baseStyle + "VIcon" : this.baseStyle + "HIcon")
        }) : null
    ;

    var menuIcon = null;
    if (this.showMenuIcon) {
        var menuIconUrl = this._getMenuIconURL();

        menuIcon = this.menuIcon = (this.showMenuIcon ?
            this.imgHTML({
                src: menuIconUrl,
                width: this.menuIconWidth,
                height: this.menuIconHeight,
                name: "menuIcon",
                eventStuff: " eventpart='menuIcon'",
                cssClass: this.menuIconStyle ||
                    (isLarge ? this.baseStyle + "VMenuIcon" : this.baseStyle + "HMenuIcon")
            }) : null);
        ;
    }

    //this.icon = null;

    var tempTitle = title;
    title = img || "";

    if (this.vertical) {
        if (this.showButtonTitle) {
            if (title != "") title += "<br>";
            title += tempTitle;
        }
        if (this.showMenuIcon && menuIcon) {
            title += "<br>";
            title += menuIcon;
        }
    } else {
        var titleSeparator = this.titleSeparator;

        if (isc.Browser.isChrome && isc.Browser.version == 78 && titleSeparator == "&nbsp;") {
            titleSeparator = " ";
        }

        this.valign = "center";
        if (this.showButtonTitle) {
            if (title != "") {
                title += titleSeparator;
            }
            title += "<span style='vertical-align:middle;align-content:center;'>" + tempTitle + "</span>";
        }
        if (this.showMenuIcon && menuIcon) {
            if (title != "") title += titleSeparator;
            title += menuIcon;
        }
    }

    return title;
},

_getMenuIconURL : function () {
    var state = this.state,
        selected = this.selected,
        customState = this.getCustomState(),
        sc = isc.StatefulCanvas
    ;

    //this.logWarn(isc.echoFull("state is " + state));

    // ignore states we don't care about
    if (state == sc.STATE_DOWN && !this.showMenuIconDown) state = null;
    else if (state == sc.STATE_DISABLED && !this.showMenuIconDisabled) state = null;
    else if (state == sc.STATE_OVER && (!this.showMenuIconOver || !this.showingMenuButtonOver))
        state = null;

    var focused = null; //this.showFocusedMenuIcon ? this.getFocusedState() : null;
    var icon = this.menuIconSrc;
    return isc.Img.urlForState(icon, selected, focused, state, null, customState);
},

setHandleDisabled : function () {
    this.Super("setHandleDisabled", arguments);
    if (this.isDrawn()) this.setTitle(this.title);
},

mouseOut : function () {
    this.Super("mouseOut", arguments);

    if (this.showingMenuButtonOver) this.menuIconMouseOut();
},

//> @method ribbonButton.menuIconClick()
// Notification method fired when a user clicks on the menuIcon on this RibbonButton.
// <smartclient>Return false to suppress the standard click handling code.</smartclient>
// <smartgwt>call <code>event.cancel()</code> to suppress the standard
// click handling code.</smartgwt>
//
// @return (Boolean) return false to cancel event-bubbling
// @visibility external
//<
//menuIconClick : function () { return true; },
menuIconClick : function () {
    this.showMenu();
    return false;
},


//> @method ribbonButton.iconClick()
// Notification method fired when a user clicks on the +link{ribbonButton.icon, icon} in this
// RibbonButton.
// <smartclient>Return false to suppress the standard click handling code.</smartclient>
// <smartgwt>call <code>event.cancel()</code> to suppress the standard
// click handling code.</smartgwt>
//
// @return (Boolean) return false to cancel event-bubbling
// @visibility external
//<
iconClick : function () { return true; },

//> @method ribbonButton.click()
// Notification method fired when a user clicks anywhere on this button.  If the click occurred
// directly on the +link{button.icon, icon} or the +link{ribbonButton.menuIconSrc, menuIcon},
// the related notifications +link{ribbonButton.iconClick, iconClick} and
// +link{ribbonButton.menuIconClick, menuIconClick} are fired first and must return false to
// prevent this notification from firing.
// <P>
// If a +link{class:Menu, menu} is installed then, by default, it is only displayed when a
// user clicks on the +link{ribbonButton.menuIconSrc, menuIcon}.  This can be altered via
// +link{ribbonButton.showMenuOnClick, showMenuOnClick}.
//
// @return (Boolean) return false to cancel event-bubbling
// @visibility external
//<
click : function () {
    //this.logWarn("in ribbonButton.click")
    if (this.showMenuOnClick && this.showMenu) this.showMenu();
},

//> @attr ribbonButton.showMenuOnClick (Boolean : false : IRW)
// If set to true, shows this button's +link{class:Menu, menu} when a user clicks anywhere
// in the button, rather than specifically on the +link{ribbonButton.menuIconSrc, menuIcon}.
// <P>
// Note that this property has a different meaning than +link{statefulCanvas.showMenuOnClick,
// showMenuOnClick} in the ancestor class +link{StatefulCanvas}.
// @group menu
// @visibility external
//<
showMenuOnClick: false,

//> @attr ribbonButton.showMenuIconOver (Boolean : true : IRW)
// Whether to show an Over version of the +link{menuIconSrc, menuIcon}.
// @group menu
// @visibility external
//<
showMenuIconOver: true,

//> @attr ribbonButton.showMenuIconDown (Boolean : false : IRW)
// Whether to show a Down version of the +link{menuIconSrc, menuIcon}.
// @group menu
// @visibility external
//<
showMenuIconDown: false,

//> @attr ribbonButton.showMenuIconDisabled (Boolean : true : IRW)
// Whether to show a Disabled version of the +link{menuIconSrc, menuIcon}.
// @group menu
// @visibility external
//<
showMenuIconDisabled: true,

menuIconMouseMove : function () {
    if (!this.showMenuIconOver || this.showingMenuButtonOver) return;

    var element = this.getImage("menuIcon");

    if (element) {
        this.showingMenuButtonOver = true;
        this.setTitle(this.title);
    }
},

menuIconMouseOut : function () {
    if (!this.showMenuIconOver) return;

    var element = this.getImage("menuIcon");

    if (element) {
        this.showingMenuButtonOver = false;
        this.setTitle(this.title);
    }
},

_shouldRedrawOnStateChange : function () {
    if (this.Super("_shouldRedrawOnStateChange", arguments)) return true;
    var icon = this.showIcon != false ?
                (this.vertical ?  this.largeIcon || this.icon : this.icon) : null;
    if (icon === isc.Canvas._blankImgURL) return icon;

    // If we have an icon and it changes with states, we need to reset the title
    // (IE redraw) on state change.
    if (icon && this.showIconState &&
         (this.showDisabledIcon || this.showSelectedIcon || this.showRollOverIcon ||
            this.showFocusedIcon || this.showDownIcon)) return true;

    return false;
},

//>    @attr ribbonButton.menu (Menu : null : IRW)
// The menu to show when the +link{ribbonButton.menuIconSrc, menu-icon} is clicked.
// <P>
// For a menu button with no menu (menu: null) the up/down arrow image can
// be suppressed by setting
// +link{ribbonButton.showMenuIcon, showMenuIcon}: <code>false</code>.
// @group menu
// @visibility external
// @setter ribbonButton.setMenu
//<
menu:null,

//>    @method ribbonButton.setMenu ()
// The menu to show when the +link{ribbonButton.menuIconSrc, menu-icon} is clicked.
// <P>
// For a menu button with no menu (menu: null) the up/down arrow image can
// be suppressed by setting
// +link{ribbonButton.showMenuIcon, showMenuIcon}: <code>false</code>.  Note that
// <code>showMenuIcon</code> is updated automatically by calls to
// +link{ribbonButton.setMenu}.
// @param menu (Menu) a menu to assign to this button
// @group menu
// @visibility external
//<
setMenu : function (menu) {
    this.menu = menu;
    this.showMenuIcon = (this.menu != null);
    this.markForRedraw();
    //this.setTitle(this.title);
},
getMenu : function () {
    return this.menu;
},

//> @attr ribbonButton.menuAnimationEffect (String : null : IRWA)
// Allows you to specify an animation effect to apply to the menu when it is being shown.
// Valid options are "none" (no animation), "fade", "slide" and "wipe".
// If unspecified falls through to <code>menu.showAnimationEffect</code>
// @group menu
// @visibility animation
//<

//> @attr ribbonButton.menuAlign (Alignment : null : IR)
// The horizontal alignment of this button's menu, in relation to the button.  When unset,
// default behavior is to align the right edges of button and menu if the page is in RTL
// mode, and the left edges otherwise.
// @group menu
// @visibility external
//<
//menuAlign: null,

//>    @attr ribbonButton.showMenuBelow (Boolean : true : IRW)
// The menu drops down below the menu button.
// Set to false if the menu should appear above the menu button.
// @group menu
// @visibility external
//<
showMenuBelow: true,

//> @method ribbonButton.showMenu()
// Shows this button's +link{ribbonButton.menu}.  Called automatically when a user clicks the
// +link{ribbonButton.menuIconSrc, menuIcon}.
// @return (Boolean) true if a menu was shown
// @group menu
// @visibility external
//<
showMenu : function () {
    // lazily create the menu if necessary, so we can init with, or set menu to, an object
    // properties block
    if (isc.isA.String(this.menu)) this.menu = window[this.menu];
    if (!isc.isA.Menu(this.menu)) this._createMenu(this.menu);
    if (!isc.isA.Menu(this.menu)) return false;

    var menu = this.menu;

    // draw offscreen so that we can figure out what size the menu is
    // Note that we use _showOffscreen which handles figuring out the size, and
    // applying scrollbars if necessary.
    menu._showOffscreen();
    this.positionMenu(menu);
    menu.show(this.menuAnimationEffect);
},

positionMenu : function (menu) {
    if (!menu) return;
    // figure out the left coordinate of the drop-down menu
    var left = this.getPageLeft();

    if (this.menuAlign == isc.Canvas.CENTER) {
        // center-align the menu to the menuButton
        left = left - ((menu.getVisibleWidth() - this.getVisibleWidth()) / 2);
    } else if (this.menuAlign == isc.Canvas.RIGHT) {
        // align the right-edge of the menu to the right edge of the menuButton
        left -= (menu.getVisibleWidth() - this.getVisibleWidth());
    }

    var top = this.showMenuBelow ? this.getPageTop()+this.getVisibleHeight()+1 :
                                   this.getPageTop()-menu.getVisibleHeight()+2;
    // don't allow the menu to show up off-screen
    menu.placeNear(left, top);
},

_createMenu : function (menu) {
    if (!menu) return;
    menu.autoDraw = false;

    var cons = this.menuConstructor || isc.Menu;
    this.menu = cons.create(menu);
},

// properties that when changed should trigger a redraw
_$updateControlsProperties : {
    //rowSpan:true,
    //vertical:true
},

// propertyChanged - fired by setProperties for each modified property.
propertyChanged : function (propName, value) {
    this.invokeSuper(isc.RibbonButton, "propertyChanged", propName, value);
    if (this._$updateControlsProperties[propName]) {
        this.getRibbon() && this.getRibbon().releaseReifySizeLock(this);
        //this.redraw();
        if (this._ribbonGroup) {
            this._ribbonGroup.resizeTo(1,1);
            this._ribbonGroup._updateControls();
            //this._ribbonGroup.getParentElement().redraw();
        }
        //this.logWarn("RibbonButton: propertyChanged for " + propName + ":  " + value);
        this.getRibbon() && this.getRibbon().restoreReifySizeLock(this);
    }
    //>EditMode
    if (this.editingOn && this.editProxy) {
        //switch (propName) {
        //    break;
        //}
    }
    //<EditMode
}

});

//> @class RibbonMenuButton
// A simple subclass of +link{RibbonButton} that shows a menuIcon by default and implements
// showMenu().
// <P>
// This class has +link{ribbonButton.showMenuIcon,showMenuIcon} set to <code>true</code> by
// default, and has a +link{ribbonButton.menuIconClick} handler which will show the specified
// +link{ribbonButton.menu} via a call to +link{ribbonButton.showMenu()}.
// This menuIconClick handler cancels default click behavior, so, if a user clicks the menu
// icon, any specified +link{canvas.click,click handler} for the button as a whole will not fire.
//
// @inheritsFrom RibbonButton
// @treeLocation Client Reference/Layout/RibbonBar
// @visibility external
//<
isc.defineClass("RibbonMenuButton", "RibbonButton").addProperties({

    usePartEvents: true,

    //> @attr ribbonMenuButton.showMenuIcon (Boolean : true : IRW)
    // Whether to show the +link{menuIconSrc, menu-icon} which fires the
    // +link{ribbonButton.menuIconClick} notification method when clicked.
    // @group menu
    // @visibility external
    //<
    showMenuIcon: true

});



//> @class ToolStripGroup
// A simple subclass of +link{class:RibbonGroup}, which groups other controls for use in
// +link{class:RibbonBar, ribbon-bars}.
// @inheritsFrom RibbonGroup
// @treeLocation Client Reference/Layout
// @visibility external
// @deprecated this is an old synonym for +link{class:RibbonGroup, RibbonGroup}, scheduled for removal in the next release
//<
isc.defineClass("ToolStripGroup", "RibbonGroup");

//> @class IconButton
// A simple subclass of +link{class:RibbonButton, RibbonButton}.
// @inheritsFrom RibbonButton
// @treeLocation Client Reference/Layout/RibbonBar
// @visibility external
// @deprecated this is an old synonym for +link{RibbonButton}, scheduled for removal in the next release
//<
isc.defineClass("IconButton", "RibbonButton").addProperties({
    // default deprecated IconButton to horizontal - legacy behavior
    orientation: "horizontal",
    vertical: false,
    init : function () {
        var result = this.Super("init", arguments);
        if (!window.sessionStorage.iscSkipIconButtonWarning) {
            window.sessionStorage.iscSkipIconButtonWarning = true;
            this.logWarn("Note that IconButton is deprecated and will be removed in the " +
                "next major release.  Use RibbonButton instead,");
        }
        return result;
    }
});

//>    @class IconMenuButton
// A simple subclass of +link{class:RibbonMenuButton}.
// @inheritsFrom IconButton
// @treeLocation Client Reference/Layout/RibbonBar
// @visibility external
// @deprecated this is an old synonym for +link{class:RibbonMenuButton, RibbonMenuButton}, scheduled for removal in the next release
//<
isc.defineClass("IconMenuButton", "RibbonMenuButton").addProperties({
    // default deprecated IconMenuButton to horizontal - legacy behavior
    orientation: "horizontal",
    vertical: false,
    init : function () {
        var result = this.Super("init", arguments);
        if (!window.sessionStorage.iscSkipIconMenuButtonWarning) {
            window.sessionStorage.iscSkipIconMenuButtonWarning = true;
            this.logWarn("Note that IconMenuButton is deprecated and will be removed in the " +
                "next major release.  Use RibbonMenuButton instead,");
        }
        return result;
    }
});





//> @class SectionStack
// A container that manages a list of sections of widgets, each with a header.  Sometimes
// called an "Accordion".
// <P>
// SectionStack can be configured so that only one section is visible at a time (similar to MS
// Outlook's left-hand Nav), or to allow multiple sections to be visible and share the
// available space.  For further details, see +link{sectionStack.visibilityMode}.
// <P>
// To ensure all sections are accessible, you may need to set
// +link{SectionStack.overflow,overflow} to enable scrolling.
//
// @inheritsFrom VLayout
// @treeLocation Client Reference/Layout
// @visibility external
// @example sectionsExpandCollapse
//<
isc.defineClass("SectionStack", "VLayout");

//>!BackCompat 2005.6.15 old name: "ListBar"
isc.addGlobal("ListBar", isc.SectionStack);
//<!BackCompat

isc.SectionStack.addProperties({
    //> @attr sectionStack.overflow (Overflow : "hidden" : IRW)
    // Normal +link{type:Overflow} settings can be used on layouts, for example, an
    // overflow:auto Layout will scroll if sections are resized to exceed the specified size,
    // whereas an overflow:visible Layout will grow to accommodate the resized sections.
    // @visibility external
    //<
    overflow:"hidden",

    //> @attr sectionStack.styleName (CSSStyleName : "sectionStack" : IR)
    // Default CSS style for the SectionStack as a whole.
    // @visibility external
    //<
    styleName:"sectionStack",

    // Section Header Creation
    // ---------------------------------------------------------------------------------------

    //> @attr sectionStack.sectionHeaderClass (Classname : "SectionHeader" : IRA)
    // Widget to use for section headers.
    // <p>
    // Must be a subclass of either +link{ImgSectionHeader} or +link{SectionHeader}.  The
    // default class used depends on the skin; +link{SectionHeader} is the simpler and
    // lighter-weight class and uses CSS styling rather than image-based styling, and is
    // recommended for most use cases.
    // <p>
    // <smartgwt>
    // If you create a custom section header class in Java, enable +link{group:reflection} to
    // allow it to be used.
    // <p>
    // Alternatively, you can use the &#83;martClient class system to create a simple
    // &#83;martClient subclass of either SectionHeader or ImgSectionHeader for use with this
    // API - see the +link{group:skinning,Skinning Guide} for details.
    // </smartgwt>
    // <smartclient>
    // Very advanced developers can use the following information to create custom header
    // classes.
    // <P>
    // The SectionStack will instantiate this class, giving the following properties on init:
    // <ul>
    // <li><code>layout</code>: the SectionStack
    // <li><code>expanded</code>: true or false
    // <li><code>hidden</code>: true or false
    // <li><code>title</code>: section title
    // </ul>
    // Whenever the section is hidden or shown, sectionHeader.setExpanded(true|false) will be
    // called if implemented.
    // </smartclient>
    // <p>
    // If you override event handlers on your custom SectionHeader or radically change it's
    // structure such that the default event handling no longer works, you can call
    // +link{SectionStack.sectionHeaderClick()} to replicate the built-in expand/collapse
    // handling for clicking a section header.
    //
    // @visibility external
    //<
    sectionHeaderClass:"SectionHeader",

    //> @attr sectionStack.headerHeight (Number : 20 : IR)
    // Height of headers for sections.
    // @visibility external
    //<
    headerHeight:20,

    // sectionStack header styles for printing
    printHeaderStyleName:"printHeader",


    //> @attr sectionStack.tabPanel (MultiAutoChild Canvas : null : R)
    // In +link{isc.setScreenReaderMode(),screen reader mode}, a <code>tabPanel</code> component
    // is created for each section to own all of the section's +link{SectionStackSection.items,items}.
    // @group accessibility
    //<
    tabPanelDefaults: {
        _constructor: "Canvas",
        overflow: "hidden",
        visibility: "hidden",
        // Hide using display:none so as not to affect scrollHeight
        hideUsingDisplayNone: true

    },


    // All Sections
    // ---------------------------------------------------------------------------------------

    //> @attr SectionStack.sections (Array of SectionStackSection Properties : null : [IR])
    // List of sections of components managed by this SectionStack.
    //
    // @getter noauto
    // @see sectionStack.getSectionNames()
    // @example sectionsExpandCollapse
    // @visibility external
    //<


    //> @attr SectionStack.canResizeSections (Boolean : true : [IRA])
    // Whether sections can be drag resized by the user dragging the section header.
    // <P>
    // Note that, with <code>canResizeSections:true</code>, not all sections can be resized:
    // sections that contain only +link{Button.autoFit,autofitting} components or that are
    // marked with +link{SectionStackSection.resizeable,section.resizeable:false} will not be
    // resizeable.
    //
    // @visibility external
    //<
    canResizeSections:true,

    //> @attr sectionStack.canDropComponents (Boolean : true : IRA)
    // SectionStacks provide the same default implementation of drag and drop interactions as
    // +link{layout.canDropComponents, Layouts}, except that members are added as items into
    // the section over which they're dropped.
    // <P>
    // If you want to completely suppress the builtin drag and drop logic, but still receive drag
    // and drop events for your own custom implementation, set +link{Canvas.canAcceptDrop} to
    // <code>true</code> and <code>canDropComponents</code> to <code>false</code> on your
    // SectionStack.
    //
    // @group dragdrop
    // @visibility external
    //<

    // whether to allow the user to change the overall size of the SectionStack by resizing
    // sections

    canResizeStack:true,

    //> @attr SectionStack.canReorderSections (Boolean : false : [IRA])
    // Whether sections can be drag reordered by the user dragging the section header.
    // <P>
    // Note that, with <code>canReorderSections:true</code>, sections with
    // +link{SectionStackSection.canReorder,section.canReorder:false} will not be
    // able to be drag-reordered (though their index may still be changed by dropping other
    // sections above or below them in the section stack).
    //
    // @visibility external
    //<
    canReorderSections:false,

    //> @attr SectionStack.canTabToHeaders (boolean : null : [IRA])
    // If true, the headers for the sections (if shown) will be included in the page's tab
    // order for accessibility.
    // May be overridden at the Section level via +link{SectionStackSection.canTabToHeader}
    // <P>
    // If unset, section headers will be focusable if <smartclient>+link{isc.setScreenReaderMode}
    // </smartclient>
    // <smartgwt>{@link com.smartgwt.client.util.SC#setScreenReaderMode SC.setScreenReaderMode()}
    // </smartgwt> has been called.
    // See +link{group:accessibility}.
    // @visibility external
    //<

    //> @attr SectionStack.scrollSectionIntoView (Boolean : true : [IR])
    // If an expanded or shown section expands past the current viewport and this property is
    // true, then the viewport will auto-scroll to fit as much of the section content into the
    // viewport without scrolling the top of the section out of the viewport.
    //
    // @visibility external
    //<
    scrollSectionIntoView: true,

    // NOTE: vertical:false (horizontal stacks) does work, however the default SectionHeader
    // class has a height of 20 which needs to be wiped to allow vertical stretching.  And, you
    // have to have a strategy for vertical text labels.
    //     isc.defineClass("MyHeader", "SectionHeader").addProperties({height:null});
    //     isc.SectionStack.create({
    //         vertical:false,
    //         sectionHeaderClass:"MyHeader",
    //vertical:true,

    // Section Header Properties
    // ---------------------------------------------------------------------------------------

    //> @object SectionStackSection
    // Section descriptor used by a SectionStack to describe a section of items which are shown
    // or hidden together along with their associated header.
    // <P><smartclient>
    // A section header (see +link{sectionStack.sectionHeaderClass}) is created from this
    // descriptor when the SectionStack is created.  Any changes after creation  must be made to
    // the section header: +link{sectionStack.getSectionHeader}.
    // </smartclient><smartgwt>
    // A <code>SectionStackSection</code> can't be modified once it's been added to a
    // +link{SectionStack}, which creates its section header (by default a +link{SectionHeader},
    // but see +link{sectionStack.sectionHeaderClass}).  After that, you must call the
    // appropriate <code>SectionStack</code> method to modify a section property, or the
    // section header getter method to get the updated property value.  As a convenience, we
    // route several <code>SectionStackSection</code> setter methods to the +link{SectionStack}
    // for you after the <code>SectionStackSection</code> has been added to it, but with the
    // exception of +link{SectionStackSection.items}, you'll always get the original property
    // values when calling a getter directly on a <code>SectionStackSection</code>.
    // </smartgwt><P>
    // Additional SectionHeader properties set on the SectionStackSection not explicitly
    // documented, such as "iconAlign" or "prompt", are supported<smartgwt> - use
    // <code>setAttribute()</code></smartgwt>.
    // @treeLocation Client Reference/Layout/SectionStack
    // @visibility external
    //<

    //> @attr SectionStackSection.name (String : null : [IR])
    // Identifier for the section.  This can be used later in calls to +link{SectionStack} APIs such as
    // +link{sectionStack.expandSection} and +link{sectionStack.collapseSection}. Note that if no name
    // is specified for the section, one will be auto-generated when the section is created.
    // This property should be a string which may be used as a valid JavaScript identifier
    // (should start with a letter and not contain space or special characters such as "*").
    // @visibility external
    //<

    //> @attr SectionStackSection.ID (String : null : [IR])
    // Optional ID for the section. If +link{SectionStack.useGlobalSectionIDs} is true, this property will
    // be applied to the generated SectionStackHeader widget as a standard widget ID, meaning
    // it should be unique within a page.
    // <P>
    // <b>Backcompat Note</b>: Section stack sections may be uniquely identified within a stack
    // via the +link{SectionStackSection.name} attribute (introduced in Jan 2010). Prior to this,
    // the section ID attribute was used in this way (and would not be applied to the section header
    // as a widget ID). For backwards compatibility this is still supported: If
    // <code>section.name</code> is unspecified for a section but <code>section.ID</code> is set,
    // the ID will be used as a default name attribute for the section. For backwards compatibility
    // we also disable the standard behavior of having the <code>section.ID</code> being applied to the generated
    // section header (thereby avoiding the page-level uniqueness requirement) by defaulting
    // +link{SectionStack.useGlobalSectionIDs} to false.
    //
    // @visibility external
    //<

    //> @attr sectionStackSection.controls (Array of Canvas : null : IR)
    // Custom controls to be shown on top of this section header.
    // <P>
    // These controls are shown in the +link{sectionHeader.controlsLayout}.
    // <P>
    // Note that this is an init-time property. If you need to dynamically change what
    // controls are displayed to the user, we would recommend embedding the
    // controls in a Layout or similar container.
    // This will allow you to show/hide or add/remove members at runtime
    // by manipulating the existing control(s) set up at init time.
    // <P>
    // For +link{sectionStackSection.canClose,canClose:true} sections, a
    // +link{SectionStack.closeSectionButton,close icon} will be added to the section
    // controls automatically.
    //
    // @example sectionControls
    // @visibility external
    //<

    //> @attr SectionStack.useGlobalSectionIDs (Boolean : false : [IR])
    // Should any specified +link{SectionStackSection.ID} be applied to the generated SectionHeader widget
    // for the section as a widget ID? If set to false, SectionStackSection.ID will behave as a synonym for
    // SectionStackSection.name.
    //
    // @visibility external
    //<
    // Default to false for back-compat
    useGlobalSectionIDs:false,

    //> @attr SectionStackSection.title (HTMLString : null : IR)
    // Title to show for the section
    // @visibility external
    //<
    //> @attr sectionStackSection.clipTitle
    // @include sectionHeader.clipTitle
    // @visibility external
    //<
    //> @attr sectionStackSection.showClippedTitleOnHover
    // @include sectionHeader.showClippedTitleOnHover
    // @visibility external
    //<

    //> @attr SectionStackSection.items (Array of Canvas | Array of AutoChildShortcut : null : [I])
    // List of Canvases that constitute the section.  These Canvases will be shown and hidden
    // together.
    // <P>
    // Along with live Canvases, you may also pass special string autochild shortcuts of the
    // form "autoChild:<i>autoChildName</i>" as discussed at the bottom of help topic
    // +link{group:autoChildren}.
    // @visibility external
    //<

    //> @attr SectionStackSection.showHeader (Boolean : true : [I])
    // If true, a header will be shown for this section.  If false, no header will be shown.
    // @visibility external
    //<

    //> @attr sectionStackSection.canTabToHeader (boolean : null : IR)
    // If true, the header for this Section will be included in the page's tab
    // order for accessibility. May also be set at the +link{SectionStack} level via
    // +link{SectionStack.canTabToHeaders}.
    // <P>
    // See +link{group:accessibility}.
    //
    // @visibility external
    //<

    //> @attr sectionStackSection.icon   (SCImgURL : "[SKIN]SectionHeader/opener.gif" : [IR])
    // Base filename of the icon that represents open and closed states. The default settings
    // also change the icon for disabled sections, so a total of four images are required
    // (opened, closed, Disabled_opened, Disabled_closed).
    // <P>
    // Not shown if +link{sectionStackSection.canCollapse} is false.
    //
    // @visibility external
    //<


    //> @attr SectionStackSection.resizeable (boolean : null : [I])
    // If set to false, then the items in this section will not be resized by sectionHeader
    // repositioning.  You may also set this flag directly on any of the items in any section to
    // cause that item to not be resizeable.
    // @visibility external
    // @example resizeSections
    //<

    //> @attr SectionStackSection.canReorder (boolean : null : [I])
    // If set to false, then this sectionHeader will not be able to be dragged to perform a drag
    // reorder, if +link{SectionStack.canReorderSections} is true.
    // You can also disable dropping other sections before this one by setting
    // +link{canvas.canDropBefore,canDropBefore} to false.
    // @visibility external
    //<

    //> @attr SectionStackSection.canDropBefore (boolean : null : [I])
    // @include Canvas.canDropBefore
    // @visibility external
    //<

    //> @attr SectionStackSection.expanded (boolean : false : [I])
    // Sections default to the collapsed state unless +link{SectionStackSection.showHeader} is
    // set to <code>false</code> in which case they default to the expanded state.  This
    // attribute allows you to explicitly control the expand/collapse state of the
    // section by overriding the above default behavior.
    // @visibility external
    //<

    //> @attr SectionStackSection.hidden (boolean : false : [I])
    // Sections default to the visible state.  This
    // attribute allows you to explicitly control the visible/hidden state of the
    // section by overriding the above default behavior.
    // @visibility external
    //<

    //> @attr SectionStackSection.canCollapse (Boolean : true : [I])
    // This attribute controls whether or not the expand/collapse UI control is shown on the
    // header of this section.  Any section can still be expanded/collapsed programmatically,
    // regardless of this setting.
    // @visibility external
    // @example sectionsExpandCollapse
    //<

    //> @attr SectionStackSection.destroyOnRemove (Boolean : false : [I])
    // Should the +link{attr:items} be +link{canvas.destroy(),destroyed} if this section is
    // +link{sectionStack.removeSection(),removed}?  The section header itself and any controls
    // will always be destroyed.
    // @visibility external
    //<

    //> @attr SectionStackSection.headerProperties (SectionHeader Properties | ImgSectionHeader Properties : null : IR)
    // Allows properties for the header (a +link{SectionHeader} or +link{ImgSectionHeader} subclass) to
    // be set on the section before it's added to the +link{SectionStack}.
    // @see sectionStack.sectionHeaderClass
    // @visibility external
    //<

    //>Animation
    // ---------------------------------------------------------------------------------------
    //> @attr sectionStack.animateSections (boolean : null : IRW)
    // If true, sections are animated during expand/collapse and addition/removal of
    // SectionItems is likewise animated.
    // @group animation
    // @visibility animation
    // @example animateSections
    //<

    // change layout default effect for showing/hiding members; "slide" is appropriate for
    // eg Window minimize, but "wipe" is usually the best effect for SectionStacks
    animateMemberEffect:"wipe",
    //<Animation

    // Visibility of Sections
    // ---------------------------------------------------------------------------------------

    //> @type VisibilityMode
    // Settings for whether multiple sections can be in the expanded state simultaneously.
    //
    // @value "mutex"
    // Only one section can be expanded at a time.
    //
    // @value "multiple"
    // Multiple sections can be expanded at the same time, and will share space.
    //
    // @visibility external
    //<

    //> @attr SectionStack.visibilityMode (VisibilityMode : "mutex" : [IRW])
    // Whether multiple sections can be expanded.
    //
    // @see attr:canCollapseAll
    // @visibility external
    // @example sectionsExpandCollapse
    //<
    visibilityMode:"mutex",

    //> @attr SectionStack.canCollapseAll (Boolean : true : [IRW])
    // In +link{SectionStack.visibilityMode,visibilityMode}
    // <smartclient>"mutex"</smartclient><smartgwt>{@link com.smartgwt.client.types.VisibilityMode#MUTEX}</smartgwt>,
    // whether to allow the last remaining expanded section to be collapsed.  If false, collapsing the
    // last open section will open the next one (wrapping around at the end).
    // @visibility external
    //<
    canCollapseAll: true,

    // internal flag: if true, section stack will null out _userHeight on an eligible item when
    // hiding/collapsing sections to maintain the overall height of the SectionStack.  If
    // false, the SectionStack will grow/shrink instead.  This needs to be rolled up to Layout
    // as a policy instead.
    forceFill: true,

    //> @attr sectionStack.itemIndent (Number : 0 : [IRW])
    // Size, in pixels, of indentation of all member items. Items will be offset
    // and reduced in width by this amount. Overridden by
    // +link{itemStartIndent} or +link{itemEndIndent}.
    // Setting itemIndent is equivalent to setting itemStartIndent to the same amount
    // and itemEndIndent to 0.
    // @visibility external
    // @group layoutMember
    //<
    itemIndent: 0,

    //> @attr sectionStack.itemStartIndent (Number : undefined : [IRW])
    // Size, in pixels, of indentation of all member items relative to the start of
    // the alignment axis. For instance, for left-aligned members,
    // itemStartIndent specifies indentation for every item from the left side of the
    // section stack. Overrides +link{itemIndent}.
    // @visibility external
    // @group layoutMember
    //<

    //> @attr sectionStack.itemEndIndent (Number : undefined : [IRW])
    // Size, in pixels, of indentation of all member items relative to the end of
    // the alignment axis. For instance, for left-aligned members,
    // itemStartIndent specifies indentation for every item from the right side of the
    // section stack.
    // @visibility external
    // @group layoutMember
    //<

    //> @attr sectionStack.showExpandControls (Boolean : true : [IRW])
    // Whether to show the Expand/Collapse controls in the headers of sections.  If false, hides
    // the expand/collapse controls and, instead, treats a click anywhere on the header as if
    // it were a click on the expand control.
    // @visibility external
    //<
    showExpandControls: true
});

isc.SectionStack.addMethods({

    initWidget : function () {
        this.Super(this._$initWidget, arguments);

        if (this.canReorderSections) this.canAcceptDrop = true;

        //>Animation
        if (this.animateSections != null) this.animateMembers = this.animateSections;
        //<Animation

        //>!BackCompat 2005.6.15 old name: "ListBar" with "groups"
        if (this.groups != null && this.sections == null) this.sections = this.groups;
        //<!BackCompat

        var initSections = this.sections;
        this.sections = [];
        this.addSections(initSections, null, true);
    },

    //> @method sectionStack.setAnimateSections()
    // setter for +link{attr:animateSections}
    // @param shouldAnimate (boolean) Should expand/collapse of section be animated?
    // @visibility external
    //<
    setAnimateSections : function (shouldAnimate) {
        this.animateSections = this.animateMembers = shouldAnimate;
    },

    //> @method sectionStack.setVisibilityMode()
    // Setter for +link{attr:visibilityMode}.
    // @param newVisibilityMode (VisibilityMode) new <code>visibilityMode</code> setting.
    // If this is <smartclient>"mutex"</smartclient><smartgwt>{@link com.smartgwt.client.types.VisibilityMode#MUTEX}</smartgwt>
    // then all but the first expanded section is collapsed.
    // @visibility external
    //<
    setVisibilityMode : function (newVisibilityMode) {
        this.visibilityMode = newVisibilityMode;
        if (newVisibilityMode == "mutex") {
            var expandedSections = this.getExpandedSections();
            if (expandedSections != null && expandedSections.length >= 2) {
                this.collapseSection(expandedSections.slice(1));
            }
        }
        if (isc.Canvas.ariaEnabled()) {
            this.updateAriaState();
            var multiselectable = (newVisibilityMode != "mutex");
            this.setAriaState("multiselectable", multiselectable);
            var sections = this.sections;
            if (sections != null) {
                for (var i = 0, numSections = sections.length; i < numSections; ++i) {
                    var section = sections[i];
                    section.setAriaState((multiselectable ? "expanded" : "selected"), !!section.expanded);
                }
            }
        }
    },


    //>EditMode
    setShowExpandControls : function (state) {
        this.showExpandControls = state;
        for (var i = 0; i < this.sections.length; i++) {
            var section = this.getSectionHeader(this.sections[i]);
            section.markForRedraw("setShowExpandControls");
        }
    },
    //<EditMode

    _doPopOutDragMember : function (placeHolder, member) {
        var section = this.sectionForItem(member);

        if (section) {
            var index = this.getMemberNumber(member)-(this.getMemberNumber(section)+1);
            //this.logWarn("member index " + this.getMemberNumber(member) + "\n" +
            //    "header index " + this.getMemberNumber(section) + "\n" +
            //    "offset into section " + index
            //);
            this.addItem(section, placeHolder, index);
        } else {
            this.addMember(placeHolder, this.getMemberNumber(member), true);
        }
    },

    // replace one member with another, without an intervening relayout, and without animation
    _replaceMember : function (oldMember, newMember) {

        var oldMemberPos = this.getMemberNumber(oldMember),
            section = this.sectionForItem(oldMember)
        ;

        if (!section) {
            return this.Super("_replaceMember", arguments);
        }

        var oldSetting = this.instantRelayout;
        this.instantRelayout = false;

        this._finishDropAnimation();

        var sectionIndex = this.getMemberNumber(section);
        this.removeItem(section, oldMember);

        this.addItem(section, newMember, (oldMemberPos-sectionIndex)-1);

        this.instantRelayout = oldSetting;
        if (oldSetting) this.reflowNow();

    },

    _dragIsSectionReorder : function () {
        if (this.canReorderSections) {
            var target = this.ns.EH.dragTarget;
            return (this.sections != null && this.sections.contains(target));
        }
        return false;
    },

    willAcceptDrop : function () {
        if (this._dragIsSectionReorder()) {
            var target = this.ns.EH.dragTarget;
            return (target.canReorder != false);
        }
        // otherwise allow default implementation to continue - may allow some more
        // elaborate, unrelated customization
        return this.Super("willAcceptDrop", arguments);
    },

    getStackDropPosition : function () {
        var coord = this.vertical ? this.getOffsetY() : this.getOffsetX();

        // before beginning
        if (coord < 0) return 0;

        var totalSize = this.vertical ? this._topMargin : this._leftMargin,
            visibleMemberCount = 0
        ;

        for (var i = 0; i < this.members.length; i++) {
            var member = this.members[i];
            if (!member) continue;

            var section = member.isSectionHeader ? member : this.sectionForItem(member),
                sectionIsExpanded = this.sectionIsExpanded(section),
                memberIsVisible = member.isVisible() && sectionIsExpanded
            ;

            if (memberIsVisible || (member == section)) {
                if (coord < (totalSize + (size/2))) {
                    // respect an explicit canDropBefore setting, which prevents dropping before a
                    // member
                    if (member.canDropBefore === false) return false;
                    return i;
                }

                var size = this.memberSizes[visibleMemberCount];
                totalSize += size + this.membersMargin + this.getMemberGap(member);
                visibleMemberCount++;
            }
        }
        // last position: past halfway mark on last member
        return this.members.length;
    },

    getDropPosition : function (dropType, visibleOnly) {
        //>EditMode
        if (!this._dragIsSectionReorder()) {
            if (this.editingOn && this.editProxy) {
                return this.editProxy.getDropPosition(dropType);
            } else {
                return this.getStackDropPosition();
            }
        }
        //<EditMode

        var coord = this.vertical ? this.getOffsetY() : this.getOffsetX();
        // before beginning
        if (coord < 0) return 0;

        var totalSize = this.vertical ? this._topMargin : this._leftMargin,
            section = this.sections[0],
            sectionIndex = 0,
            // Note: hidden members have no entries in the this.memberSizes array so we need
            // to track both visible and hidden members as we iterate through
            visibleMemberIndex = 0,
            memberIndex = 0;
        while (memberIndex < this.members.length) {
            var sectionSize = 0,
                member = this.members[memberIndex],
                currentMemberMargin = 0
            ;

            // determine the size of the entire section (header + all expanded items)
            while (member != null &&
                (member == section || (section.items && section.items.contains(member)))) {
                if (member.isVisible()) {
                    sectionSize  += this.memberSizes[visibleMemberIndex];
                    currentMemberMargin = this.membersMargin + this.getMemberGap(member);
                    sectionSize += currentMemberMargin;
                    visibleMemberIndex++;
                }

                memberIndex += 1;
                member = this.members[memberIndex];

            }

            // At this point we know how tall the section is
            if (coord < (totalSize + ((sectionSize-currentMemberMargin)/2))) {
                // respect an explicit canDropBefore setting, which prevents dropping before a
                // section
                if (section && section.canDropBefore === false) return false;
                return this.members.indexOf(section);
            }

            // Otherwise, increase the total size and look at the next section
            totalSize += sectionSize;
            sectionIndex += 1;
            section = this.sections[sectionIndex];
       }
       // At this point we've gone through all members -- dropping at end
       return this.members.length;

    },

    drop : function () {
        if (!this.willAcceptDrop()) return;
        var dropPosition = this.getDropPosition(),
            dropComponent = this.getDropComponent(isc.EventHandler.getDragTarget(), dropPosition),
            isSection = this.sections && this.sections.contains(dropComponent),
            section = dropComponent
        ;

        if (!isSection) {
            if (this.canDropComponents) {
                // dropping some widget into the stack - add the widget into the items array of
                // the relevent section at an appropriate location
                section = this.sectionForMemberIndex(dropPosition);
                var indexInSection = dropPosition - (this.getMemberNumber(section) + 1);
                this.addItem(section, dropComponent, indexInSection);
            } else {
                // canDropComponents is false - just do a normal addMember()
                this.addMember(dropComponent, dropPosition);
            }
        } else if (isSection && this.canReorderSections) {
            // section-reorder
            var currentSectionIndex = this.sections.indexOf(section),
                newSectionIndex;

            var dropMember = this.members[dropPosition];
            if (dropMember == null) {
                newSectionIndex = this.sections.length;
            } else {
                for (var i = 0; i < this.sections.length; i++) {
                    if (dropMember == this.sections[i] ||
                        (this.sections[i].items && this.sections[i].items.contains(dropMember)))
                    {
                        newSectionIndex = i;
                    }
                }
            }
            // There's an offset to consider: if dropping *after* our current position we'll
            // be removing this section from the sections array (and all the members from the
            // members array) and re-adding in the new spot so
            // If a section is initially at index 2:
            // - Dropping at 0, or 1 will slot into those positions
            // - Dropping at 2 is a drop onto current position (no change)
            // - Dropping at 3 is a drop between self and next item - so also no change
            // - Dropping at 4 or 5 will remove us from slot 2, meaning we actually want to
            //   drop at 3 or 4.
            var dropAfter = newSectionIndex > currentSectionIndex;
            if (dropAfter) {
                newSectionIndex -=1;
            }

            if (newSectionIndex == currentSectionIndex) {
                return;
            }
            this.sections.slide(currentSectionIndex, newSectionIndex);

            var start = this.members.indexOf(section),
                end = start +1,
                items = section.items || [];
            for (var i = 0; i < items.length; i++) {
                if (this.members.contains(items[i])) end += 1;
            }
            if (dropAfter) dropPosition -= (end-start);

            this.logInfo("Drag reorder of sections - section:" +
                section + " moved to:" + newSectionIndex + " - reordering members from " + start +
                " to " + end + " target position:" + dropPosition);

            this.reorderMembers(start, end, dropPosition);
        }

    },


    shouldCreateCanvas : function (canvas) {
        if (isc.isA.String(canvas) && isc.startsWith(canvas, this._$autoChildPrefix)) {
            var childName = canvas.substring(this._$autoChildPrefix.length);
            var creator = this._getLazyAutoChildCreator(childName);
            if (creator) return creator.shouldCreateChild(childName);
        };
        return true;
    },

    //> @method sectionStack.addItem
    // Add a canvas as an item to a section.
    // @param section (String | Number) ID or index of the section to add item to
    // @param item (Canvas) Item to insert into the section
    // @param index (Number) Index into section to insert item
    // @visibility external
    //<
    addItem : function (section, item, index) {
        // skip create for show<AutoChildName>:false
        if (!this.shouldCreateCanvas(item)) return;

        var canvas = this.createCanvas(item);
        if (!isc.isA.Canvas(canvas)) {
            this.logWarn("addItem passed:" + this.echo(item) +
                    " cannot be resolved to a Canvas - ignoring");
            return;
        }
        var sectionHeader = this.getSection(section);
        if (index  == null) index = 0;
        if (index >= sectionHeader.items.length) index = sectionHeader.items.length;

        // make sure that items being added have their resizeable flag set appropriately
        if (canvas.resizeable == null) {
            if (!this.canResizeSections) canvas.resizeable = false;
            else if (section.resizeable != null) {
                // allow both an explicit true and explicit false value.
                // - false allows fixed-sized sections
                // - true forces inherent height members to be resizeable
                canvas.resizeable = section.resizeable;
            }
        }

        sectionHeader.items.addAt(canvas, index);

        if (this.isDrawn() && this.sectionIsExpanded(sectionHeader)) {
            var memberIndex = 1 + this.members.indexOf(sectionHeader) + index;
            this.addMember(canvas, memberIndex);

            if (isc.Canvas.ariaEnabled()) {
                section = this.getSectionHeader(section);
                if (isc.isA.Canvas(section)) {
                    var itemIDs = section.items.callMethod("getAriaHandleID");
                    section._tabPanel.setAriaState("owns", itemIDs.join(" "));
                }
            }
        } else if (canvas.isDrawn()) {
            canvas.clear();
            canvas.deparent();
            // we'll lazily add it as a member when the section gets expanded!
        }
    },

    //> @method sectionStack.removeItem
    // Remove an item from a section.
    // @param section (String | Number) ID or index of the section to remove item from
    // @param item (Canvas) Item to remove
    // @visibility external
    //<
    removeItem : function (section, item) {
        if (section == null) section = this.sectionForItem(item);
        if (section == null) return;

        var sectionHeader = this.getSection(section);
        sectionHeader.items.remove(item);

        if (this.members.contains(item)) this.removeMember(item, item._isPlaceHolder);

        if (isc.Canvas.ariaEnabled()) {
            section = this.getSectionHeader(section);
            if (isc.isA.Canvas(section)) {
                var itemIDs = section.items.callMethod("getAriaHandleID");
                section._tabPanel.setAriaState("owns", itemIDs.join(" "));
            }
        }
    },

    //> @method sectionStack.setItems()
    // Sets a new list of canvii as items into the specified section by removing the existing
    // items, then adding the new ones.  Initial items for a section should be specified using
    // the property +link{sectionStackSection.items}.
    // @param section (String | Number) ID or index of the section to set items on
    // @param items (Array of Canvas) new items to add
    // @visibility external
    //<
    setItems : function (section, items) {
        if (section == null) return;

        // delay reflow until we're done
        var oldSetting = this.instantRelayout;
        this.instantRelayout = false;

        // first remove all existing items from the section
        var sectionHeader = this.getSection(section);
        while (sectionHeader.items.length > 0) {
            this.removeItem(section, sectionHeader.items.last());
        }



        // now the new items must be added to the section
        if (!isc.isAn.Array(items)) items = [items];
        for (var i = 0; i < items.length; i++) {
            this.addItem(section, items[i], i);
        }



        // reflow now if so configured
        this.instantRelayout = oldSetting;
        if (oldSetting) this.reflowNow();
    },

    //> @method sectionStack.setSectionProperties()
    // Set arbitrary properties for a particular section in this SectionStack. Properties will
    // be applied to the sectionHeader for the section.
    // <P>
    // Note that where APIs exist to explicitly manipulate section properties these should be
    // used in preference to this method. For example, to add or remove items in a section use
    // +link{sectionStack.addItem()} or +link{sectionStack.removeItem()}. To change the title of
    // a section, use +link{sectionStack.setSectionTitle}.
    // <P>
    // Also note that to modify properties of items within a section, call
    // the appropriate setter methods directly on the item you want to modify.
    //
    // @param section (String | int) ID or index of the section to modify
    // @param properties (SectionStackSection Properties) properties to apply to the section.
    // @visibility external
    //<
    setSectionProperties : function (section, properties) {
        var section = this.getSection(section);
        if (section != null) {
            if (isc.isA.Canvas(section)) {
                section.setProperties(properties);
            } else {
                isc.addProperties(section, properties);
            }
        }
    },


    // override removeChild to properly remove items / sections
    removeChild : function (child, name) {


        isc.Layout._instancePrototype.removeChild.call(this, child, name);
        //this.Super("removeChild", arguments);

        var sections = this.sections;
        if (sections) {
            for (var i = 0; i < sections.length; i++) {
                var section = sections[i];
                if (child == section) {
                    this.removeSection(child);
                    break;
                } else if (section.items && section.items.contains(child)) {
                    this.removeItem(section, child);
                    break;
                }
            }
        }
    },

    //> @attr sectionStackSection.canClose (Boolean : null : IR)
    // Is this section closeable?
    // <P>
    // Closeable sections show a +link{sectionStack.closeSectionButton} which will invoke
    // +link{sectionStack.closeSection()} when clicked.
    // <P>
    // This property overrides the default +link{sectionStack.canCloseSections} setting.
    //
    // @visibility external
    //<


    //> @attr sectionStack.canCloseSections (boolean : false : IR)
    // Should sections be closeable if +link{sectionStackSection.canClose} is not
    // explicitly specified?
    // <P>
    // Closeable sections show a +link{sectionStack.closeSectionButton,close icon button}
    // which will invoke +link{sectionStack.closeSection()} when clicked.
    //
    // @visibility external
    //<
    canCloseSections:false,

    //> @method sectionStack.closeSection()
    // Close a section. This method is invoked from
    // +link{sectionStack.closeSectionButton,close button click}
    // and will +link{sectionStack.removeSection(),remove} the section by default.
    //
    // @param section (SectionStackSection) section to close
    // @visibility external
    //<
    closeSection : function (section) {
        this.removeSection(section);
    },

    //> @attr sectionStack.closeSectionIcon (SCImgURL : "[SKIN]/actions/close.png" : IR)
    // Default icon src for the +link{sectionStack.closeSectionButton,close button} for
    // +link{sectionStackSection.canClose,canClose:true} sections.
    // <P>
    // May be overridden by +link{sectionStackSection.closeIcon}.
    //
    // @visibility external
    //<
    closeSectionIcon:"[SKIN]/actions/close.png",

    //> @attr sectionStackSection.closeIcon (SCImgURL : null : IR)
    // Icon src for the +link{sectionStack.closeSectionButton,close button} if
    // +link{sectionStackSection.canClose,canClose} is true.
    // <P>
    // If specified this takes precedence over +link{sectionStack.closeSectionIcon}.
    //
    // @visibility external
    //<

    //> @attr sectionStack.closeSectionIconSize (Number : 16 : IR)
    // Pixel width/height for the +link{sectionStack.closeSectionIcon}.
    //
    // @visibility external
    //<
    closeSectionIconSize:16,

    //> @attr sectionStackSection.closeIconSize (Number : null : IR)
    // Pixel width/height for this sections +link{sectionStackSection.closeIcon}.<br>
    // If unset +link{SectionStack.closeSectionIconSize} will be used.
    //
    // @visibility external
    //<


    //> @attr sectionStack.closeSectionButton (MultiAutoChild ImgButton : null : R)
    // Automatically generated close icon button to show for
    // +link{sectionStackSection.canClose,canClose:true} sections.<br>
    // This component will be automatically added to the +link{sectionStackSection.controls,controls}
    // for +link{sectionStackSection.canClose,canClose:true} sections.
    // <P>
    // Icon source is derived from +link{sectionStack.closeSectionIcon} or
    // +link{sectionStackSection.closeIcon} and related properties.
    //
    // @visibility external
    //<

    //> @attr sectionStack.closeSectionButtonConstructor (String : "ImgButton" : IR)
    // Constructor class for +link{sectionStack.closeSectionButton} autochildren.
    //
    // @visibility external
    //<
    closeSectionButtonConstructor:"Img",

    //> @attr sectionStack.closeSectionButtonDefaults (ImgButton Properties : {...} : IR)
    // Default properties for the +link{sectionStack.closeSectionButton}.
    // <P>
    // The default configuration includes a click handler to invoke +link{sectionStack.closeSection()}
    //
    // @visibility external
    //<
    closeSectionButtonDefaults:{
        click : function () {
            this.creator.closeSection(this.section);
        }
    },

    // Helper to create the close button for a section
    createCloseSectionButton : function (section) {
        var src = section.closeIcon || this.closeSectionIcon,
            width = section.closeIconSize || this.closeSectionIconSize,
            height = width;
        return this.createAutoChild("closeSectionButton",
                {   section:section,
                    src:src,
                    width:width,
                    height:height });
    },

    // Helper to create live controls to add to the section controls layout
    createSectionControls : function (section) {

        var controls = section.controls || [];
        if (!isc.isAn.Array(controls)) controls = [controls];

        var canClose = section.canClose;
        if (canClose == null) canClose = this.canCloseSections;
        if (canClose) {
            var closeButton = this.createCloseSectionButton(section),
                index = controls.indexOf("closeButton");

            if (index == -1) index = controls.length;
            controls[index] = closeButton;
        }
        // use createCanvii such that the "autoChild:foo" instantiation
        // scheme can be used for controls just like for items
        if (controls.length > 0) {
            var liveControls = this.createCanvii(controls);
            // Remove any empty slots.
            // One case where this has an impact: if canClose is false but section.controls
            // contains 'closeButton', createCanvii would not understand this and leave an empty slot
            liveControls.removeEmpty();
            return liveControls;
        }
    },

    // sectionNameIndex, used for auto-generated section names per stack.
    sectionNameIndex:0,
    addSections : function (sections, position, expandOne) {
        if (sections == null) return;
        if (!isc.isAn.Array(sections)) sections = [sections];

        if (position == null || position > this.sections.length) {
            position = this.sections.length;
        }

        var ariaEnabled = isc.Canvas.ariaEnabled();

        for (var i = 0; i < sections.length; i++) {
            var section = sections[i];

            // support sparse arrays
            if (!section) continue;

            if (section.showHeader == null) section.showHeader = true;
            if (section.canHide == null) section.canHide = true;

            if (section.canClose == null) section.canClose = this.canCloseSections;

            // use section.expanded if explicitly set.  Otherwise default to collapsed
            // unless showHeader is false or autoShow is true (backcompat).
            var expanded = section.expanded != null ? section.expanded :
                    // previous logic was
                    // isOpen = section.autoShow || section.showHeader == false;
                    section.autoShow || section.showHeader == false;
            if (section.hidden == null) section.hidden = false;

            // normalize items to Arrays
            if (section.items == null) section.items = [];
            else if (!isc.isA.Array(section.items)) section.items = [section.items];
            else section.items = section.items.duplicate(); // don't share lists!

            // Explicitly marking the stack as the locatorParent ensures AutoTest locators
            // identify the section within the stack rather than searching across the
            // page by defining property (title)
            section.locatorParent = this;

            for (var j = 0; j < section.items.length; j++) {
                if (isc.isAn.Object(section.items[j])) {
                    isc.Canvas.setCanvasPanelContainer(section.items[j], this);
                }
            };

            // create a header for each section, which will also serve as the section itself.
            // NOTE: if showHeader is false, we still create a header object to represent the
            // section and track it's position in the members array, but it will never be
            // show()n, hence never drawn
            var headerClass = isc.ClassFactory.getClass(this.sectionHeaderClass, true),
                sectionHeader = headerClass.createRaw();
            if (this.sectionHeaderAriaRole != null) sectionHeader.ariaRole = this.sectionHeaderAriaRole;
            sectionHeader.autoDraw = false;
            sectionHeader._generated = true;
            sectionHeader.expanded = expanded;
            sectionHeader.isSectionHeader = true;

            // if you specify hidden:true and expanded: true, then expanded wins
            sectionHeader.visibility = (section.hidden || section.showHeader == false) ?
                isc.Canvas.HIDDEN : isc.Canvas.INHERIT;
            // a section header drag is an internal resize, never an external drop (until we
            // implement tear-offs)
            sectionHeader.dragScrollType = "parentsOnly";
            sectionHeader.dragScrollDirection =
                this.vertical ? isc.Canvas.VERTICAL : isc.Canvas.HORIZONTAL;

            sectionHeader.layout = this;
            if (this.vertical) sectionHeader.height = this.headerHeight;
            else sectionHeader.width = this.headerHeight;


            // Name vs ID
            // As of Jan 2010, sections within a section stack may be referenced by the "name"
            // property. This is a unique identifier for the section within the stack.
            // A developer may also specify an ID for the section, which will by default be
            // passed through to the generated SectionHeader widget
            // (meaning it must be unique within the page, not just within the sectionStack)

            // BackCompat: 20100115
            // Previous behavior was that the ID property behaved exactly like the "name"
            // property of a section -- it was an identifier that could be used to retrieve
            // a section and was not applied to the widget as the widget-ID so could be
            // unique within a section-stack but not within the page.
            // This proved tricky to work with especially in SmartGWT where it was hard to
            // retrieve this ID from a generated SectionHeader widget (as getID() returned the
            // widget ID).
            // For backwards compatibility:
            // - if a section has a specified ID but no name, the ID will be copied over to the
            //   name slot, so getSection() et al will continue to work with the specified ID
            // - if this.useGlobalSectionIDs is false, we will not apply the specified ID
            //   property to the generated widget (so it doesn't have to be page-unique).
            var name = null, resetID = null, resetAutoID = null, undef;
            if (section.name != null) name = section.name;
            if (section.ID != null || section.autoID != null) {
                if (name == null) name = section.ID || section.autoID;
                // If an ID was specified, support passing it through to the generated
                // widget (will do this by default)
                if (!this.useGlobalSectionIDs) {
                    resetID = section.ID;
                    resetAutoID = section.autoID;

                    if (isc.Browser.isSGWT) {
                        delete section.ID;
                        delete section.autoID;
                        delete section._autoAssignedID;
                    } else {
                        section.ID              = undef;
                        section.autoID          = undef;
                        section._autoAssignedID = undef;
                    }
                } else {
                    // detect anything with a matching global ID - this'll trip a collision
                    // which may be quite confusing in a live app.
                    var collision = window[section.ID || section.autoID];
                    if (collision != null) {
                        this.logWarn("Note: Section Stack Section has ID specified as '" +
                            (section.ID || section.autoID) + "'. This collides with an existing " +
                            (isc.isA.Canvas(collision) ? "SmartClient component ID." :
                                                        "object reference.") +
                            " The existing object will be replaced by the generated header" +
                            " for this section. To avoid applying section IDs to their" +
                            " corresponding section headers, you can set" +
                            " sectionStack.useGlobalSectionIDs to false");
                    }
                }
            }

            // If no name was specified, auto-generate one. This will allow methods like
            // getExpandedSections() to return something useful and reliable
            if (name == null) {
                name = "section" + this.sectionNameIndex++;
                //this.logWarn("name/sne:" + [name,this.sectionNameIndex]);
            }

            var oldName = name,
                collidingSection = this.sections.find("name", name);
            while (collidingSection != section && collidingSection != null) {
                name = "section" + this.sectionNameIndex++;
                collidingSection = this.sections.find("name", name);
            }
            if (oldName != name) {
                this.logWarn("Specified name for section:" + oldName + " collided with name for " +
                      "existing section in this stack. Replacing with auto-generated name:"+ name);
            }
            // actually hang onto the name (which may have changed)
            section.name = name;

            isc.addProperties(sectionHeader, section, this.sectionHeaderProperties,
                              section.headerProperties);


            sectionHeader.__ref = null;
            delete sectionHeader.__module;

            // store the section config object directly on the section header and vice versa
            sectionHeader._sectionConfig = section;

            // section header dragging - governable via canReorderSections
            if (this.canReorderSections && sectionHeader.canReorder != false) {
                sectionHeader.canDragReposition = true;
                sectionHeader.canDrop = true;
            }

            sectionHeader.completeCreation();

            // Check if we need to dereference
            sectionHeader = isc.SGWTFactory.extractFromConfigBlock(sectionHeader);

            section._sectionHeader = sectionHeader;

            // APIs to get from one to the other.
            sectionHeader.getSectionConfig=function () {
                return this._sectionConfig;
            };
            section.getSectionHeader = function () {
                return this._sectionHeader;
            };

            // if we cleared the ID so as not to effect the generated widget ID,
            // restore it now so the user can continue to reference the attribute on
            // the config object originally passed in if necessary.
            if (resetID != null) section.ID = resetID;
            if (resetAutoID != null) section.autoID = resetAutoID;

            section = sectionHeader;

            this.sections.addAt(section, position+i);

            if (ariaEnabled) {
                var tabPanel = section._tabPanel = this.createAutoChild("tabPanel", {
                    _tab: section
                });
                this.addChild(tabPanel);
            }

            this.addMember(section, this._getSectionPosition(section), true);

            // expand any non-collapsed sections.  This will add the section's items as members
            if (expanded && !section.hidden) {
                this.expandSection(section);
            // If it's not expanded - ensure any drawn section items are cleared since they may
            // have been drawn outside the sectionStack's scope
            } else {
                for (var ii = 0; ii < section.items.length; ii++) {
                    var item = section.items[ii];
                    if (item.parentElement && item.parentElement != this) item.deparent();
                    // note: item may not have yet been created
                    if (isc.isA.Canvas(item) && item.isDrawn()) item.clear();
                }
            }

            // apply resizeability flag to items
            if (section.items) {
                if (!this.canResizeSections) section.items.setProperty("resizeable", false);
                else if (section.resizeable != null) {
                    // allow both an explicit true and explicit false value.
                    // - false allows fixed-sized sections
                    // - true forces inherent height members to be resizeable
                    section.items.setProperty("resizeable", section.resizeable);
                }
            }
        }

        // if we were asked to make sure one section gets shown, show the first section if none
        // were marked expanded:true
        if (expandOne && this._lastExpandedSection == null) {
            var firstSectionConfig = sections.first();
            // NOTE: avoid forcing open the first section if it's config marked it explicitly
            // not expanded
            if (firstSectionConfig && !(firstSectionConfig.expanded == false)) {
                var firstSection = this.sections.first();
                this.expandSection(firstSection);
            }
        }
    },


    //> @method sectionStack.addSection()
    //
    // Add a section to the SectionStack.
    // <P>
    // You may want to apply +link{canvas.overflow,overflow}: "auto" to your stack if users can
    // add an unlimited/ number of sections, so that they're all accessible.
    //
    // @param sections  (SectionStackSection Properties | List of SectionStackSection Properties) Initialization block
    //                  for the section or a list of initialization blocks to add.
    // @param [position]    (number) index for the new section(s) (if not specified, the section
    //                      will be added at the end of the SectionStack).
    //
    // @visibility external
    // @example sectionsAddAndRemove
    //<
    addSection : function (sections, position) {
        this.addSections(sections, position);
    },
    //> @method sectionStack.removeSection()
    //
    // Remove a section or set of sections from the SectionStack.  The removed sections' header
    // and controls (if any) are automatically destroyed.  A section's
    // +link{sectionStackSection.items,items} will also be destroyed if
    // +link{sectionStackSection.destroyOnRemove,destroyOnRemove} is set on the section.
    //
    // @param sections  (int | String | Array of int | Array of String)  Section(s) to remove.
    //                  For this parameter, you can pass the position of the section in the
    //                  SectionStack, the <code>name</code> of the section, or a List of
    //                  section <code>name</code>s or indices.
    //
    // @visibility external
    // @example sectionsAddAndRemove
    //<
    removeSection : function (sections) {
        if (!isc.isAn.Array(sections)) sections = [sections];
        for (var i = 0; i < sections.length; i++) {
            var section = this.getSectionHeader(sections[i]);
            if (section != null) {
                // Remove the section from our sections array first so that the section's items
                // is not cleared.
                this.sections.remove(section);
                if (section._tabPanel != null) {
                    section._tabPanel.destroy();
                    section._tabPanel = null;
                }
                var destroyOnRemove = section.destroyOnRemove;
                for (var ii = section.items.length-1; ii >= 0; ii--) {
                    var item = section.items[ii];


                    if (this.members.contains(item)) this.removeMember(item);

                    // removing item from the layout won't destroy it; do it now if appropriate
                    if (destroyOnRemove && item && !item.destroying && !item.destroyed) {
                        item.destroy();
                    }
                }
                if (!section.destroying && !section.destroyed) section.destroy();
            }
        }
    },

    //> @method sectionStack.getSectionNames()
    //
    // Returns a list of all +link{SectionStackSection.name,section names} in the order in which
    // they appear in the SectionStack.
    //
    // @return (List) list of all section names in the order in which they appear in the SectionStack.
    // @visibility external
    //<
    getSectionNames : function () {
        return this.sections.getProperty("name");
    },

    //> @method sectionStack.getSections()
    // @include getSectionNames()
    // @deprecated in favor of +link{getSectionNames()}.
    // @visibility external
    //<
    getSections : function () {
        return this.getSectionNames();
    },

    //> @method sectionStack.reorderSection()
    //
    // Reorder the sections by shifting the specified section to a new position
    //
    // @param section  (Integer | String) Section to move.  You can pass the position
    //                      of the section in the SectionStack or the name of the section.
    // @param position   (number) new position index for the section.
    //
    // @deprecated As of SmartClient version 5.5, use +link{sectionStack.moveSection}.
    //
    // @visibility external
    //<
    reorderSection : function (section, newPosition) {
        this.moveSection(section, newPosition);
    },

    //> @method sectionStack.moveSection()
    //
    // Moves the specified section(s) to a new position in the SectionStack order.  If you pass
    // in multiple sections, then each section will be moved to <code>newPosition</code> in the
    // order specified by the <code>sections</code> argument.
    //
    // @param sections  (int | String | Array of int | Array of String) Section(s) to move.
    //                  For this parameter, you can pass the position of the section in the
    //                  SectionStack, the name of the section, or a List of section names/positions.
    //
    // @param position  (int) new position index for the section(s).
    //
    // @visibility external
    //<
    moveSection : function (sections, newPosition) {
        if (newPosition == null) return;



        if (!isc.isAn.Array(sections)) sections = [sections];

        // normalize initial positions to sections - indices will become
        // invalid as we go through the loop manipulating
        // this.sections.
        for (var i = 0; i < sections.length; i++) {
            var section = this.getSectionHeader(sections[i]);
            if (section == null) {
                this.logInfo("moveSection(): Unable to find header for specified section:" + sections[i] + ", skipping");
                i--;
                sections.removeAt(i);
            } else {
                sections[i] = section;
                // and pull it out from this.sections
                this.sections[this.sections.indexOf(section)] = null;
            }
        }
        this.sections.removeEmpty();
        this.sections.addListAt(sections, newPosition);

        // Now update the members array.
        var currentMemberIndex = 0;
        for (var i = 0; i < this.sections.length; i++) {
            var header = this.getSectionHeader(i),
                currentStart = this.members.indexOf(header),
                currentEnd = currentStart + 1;

            var items = header.items;
            if (items != null && items.length != 0 && this.members.contains(items[0])) {
                if (currentStart == -1) {
                    currentStart = this.members.indexOf(items[0]);
                    currentEnd = currentStart;
                }
                currentEnd += items.length;
            }

            if (currentStart == -1) continue;
            this.members.slideRange(currentStart,currentEnd, currentMemberIndex);
            // next slot will be after this header and any items.
            currentMemberIndex += (currentEnd-currentStart);

        }
        this._membersReordered("moveSection() called");
    },

    //> @method Callbacks.ShowSectionCallback
    // Callback to execute after the section has been shown.
    // @visibility external
    //<
    //> @method sectionStack.showSection()
    //
    // Shows a section or sections.  This includes the section header and its items.  If the
    // section is collapsed, only the header is shown.  If the section is expanded, the section
    // header and all items are shown.
    //
    // @param sections   (int | String | Array of int | Array of String)
    //                      Section(s) to show.  For this parameter, you can pass the position
    //                      of the section in the SectionStack, the name of the section, or a
    //                      List of section names / positions.
    // @param [callback] (ShowSectionCallback) callback to fire when the sections have been shown.
    //
    // @see sectionStack.expandSection
    // @see sectionStack.scrollSectionIntoView
    // @visibility external
    // @example sectionsShowAndHide
    //<
    showSection : function (sections, callback) {
        this._showSection(sections, true, false, callback);
    },

    //> @method Callbacks.ExpandSectionCallback
    // Callback to execute after the section has been expanded.
    // @visibility external
    //<
    //> @method sectionStack.expandSection()
    //
    // Expands a section or sections.  This action shows all the items assigned to the section.
    // If the section is currently hidden, it is shown first and then expanded.  Calling this
    // method is equivalent to the user clicking on the SectionHeader of a collapsed section.
    // <smartclient>This method is called when the user clicks on SectionHeaders
    // to expand / collapse sections and so may be overridden to act as a notification method
    // for the user expanding or collapsing sections.</smartclient>
    //
    // @param sections   (int | String | Array of int | Array of String)
    //                      Section(s) to expand.  For this parameter, you can pass the position
    //                      of the section in the SectionStack, the name of the section, or a
    //                      List of section names/positions.
    // @param [callback] (ExpandSectionCallback) callback to fire when the section has been expanded.
    //
    // @see sectionStack.showSection
    // @see sectionStack.scrollSectionIntoView
    // @visibility external
    // @example sectionsExpandCollapse
    //<
    expandSection : function (sections, callback) {
        if (!isc.isAn.Array(sections)) sections = [sections];
        if (this.visibilityMode == "mutex") {
            // catch case where multiple sections are requested for expansion in 'mutex' mode
            if (sections.length > 1) {
                this.logWarn("expandSection(): only one section can be expanded in " +
                             "'mutex' visibility mode. Dropping all but the last.");
                sections = [sections[sections.length - 1]];
            }
            // keep only one section visible: hide the currently visible section
            var lastExpanded = this._lastExpandedSection,
                section = this.getSectionHeader(sections[0]);
            if (lastExpanded && lastExpanded != section) this.collapseSection(lastExpanded);
        }
        this._showSection(sections, false, true, callback);
    },

    _showSection : function (sections, showSection, expandSection, callback) {
        if (sections == null) return;
        if (!isc.isAn.Array(sections)) sections = [sections];

        var ariaEnabled = isc.Canvas.ariaEnabled();

        var itemsToShow = [];
        for (var i = 0; i < sections.length; i++) {
            var section = this.getSectionHeader(sections[i]);
            // bad section specification
            if (section == null) {
                this.logWarn("showSection(): no such section [" + i + "]: " +
                              this.echo(sections[i]));
                continue;
            }

            // If section.showHeader is true and the section isn't visible, show it
            // (whether we're expanding or showing)
            if (section.showHeader && section.hidden && (showSection || expandSection)) {
                itemsToShow.add(section);
                section.hidden = false;
                if (ariaEnabled) section._tabPanel.setAriaState("hidden", section.hidden || !section.expanded);
            }

            if (expandSection || section.expanded) {
                // Backcompat: setOpen is deprecated, but we still want to call it if
                // there's a backcompat definition. Otoh it's possible that we just have
                // setExpanded, so try that first and then call setOpen
                if (section.setExpanded && !section.setOpen) section.setExpanded(true);
                else if (section.setOpen) section.setOpen(true);

                // store the last expanded section
                this._lastExpandedSection = section;

                // NOTE: a section with no items doesn't make much sense, but it occurs in tools
                if (section.items != null && section.items.length > 0) {
                    // normalize items specified as strings / uninstantiated objects etc
                    // to canvii
                    for (var ii = section.items.length-1; ii >= 0; ii--) {
                        // skip create for show<AutoChildName>:false
                        if (!this.shouldCreateCanvas(section.items[ii])) {
                            section.items.removeAt(ii);
                            continue;
                        }
                        var itemCanvas = this.createCanvas(section.items[ii]);
                        if (!isc.isA.Canvas(itemCanvas)) {
                            this.logWarn("Section with title:"+ section.title +
                                " contains invalid item:" + section.items[ii] +
                                " - ignoring this item.");
                            section.items.removeAt(ii);
                            continue;
                        }
                        section.items[ii] = itemCanvas;
                    }

                    // ensure the section's members are added, after the section header
                    var sectionPosition = this._getSectionPosition(section) + 1;
                    // NOTE: don't animate on add because we do the animation on showMembers
                    // instead
                    this.addMembers(section.items, sectionPosition, true);
                    itemsToShow.addList(section.items);

                    if (ariaEnabled) {
                        var itemIDs = section.items.callMethod("getAriaHandleID");
                        section._tabPanel.setAriaState("owns", itemIDs.join(" "));
                    }
                }
            }
        }

        var theStack = this;
        this.showMembers(itemsToShow,
                         function () { theStack._completeShowOrExpandSection(sections, callback); }
                         );
    },

    // fired as a callback to showMembers() from showSection() and expandSection()
    _completeShowOrExpandSection : function (sections, callback) {
        // sections is always an array here because this is an internal method and sections is
        // normalized by the caller
        if (sections.length == 0) return;

        // this method just scrolls things into view, but if we haven't been drawn yet, then
        // there's no need to do anything.
        if (this.isDrawn() && this.scrollSectionIntoView &&
            (this.overflow == isc.Canvas.SCROLL || this.overflow == isc.Canvas.AUTO))
        {
            // scroll the first passed section into view
            var section = this.getSectionHeader(sections[0]);
            this.delayCall("_scrollSectionIntoView", [section], 0);
        }

        if (callback != null) this.fireCallback(callback);
    },

    _scrollSectionIntoView : function (section) {
        if (!this.vscrollOn || !this.sectionIsVisible(section)) return;

        // first "item" in section is either the header or first items widget
        var firstItem = section.showHeader ? section : section.items.first();


        var lastItem = firstItem,
            items = section.items;
        for (var i