/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-02-03/EVAL Development Only (2026-02-03)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/


isc.loadingSystemSchema=true;
isc.DataSource.create({
    types:{
        FormItemType:{
            ID:"FormItemType",
            valueMap:[
                "text",
                "boolean",
                "integer",
                "float",
                "date",
                "time",
                "sequence",
                "link",
                "image",
                "imageFile",
                "binary"
            ]
        },
        OperatorId:{
            ID:"OperatorId",
            valueMap:[
                "equals",
                "notEqual",
                "iEquals",
                "iNotEqual",
                "greaterThan",
                "lessThan",
                "greaterOrEqual",
                "lessOrEqual",
                "contains",
                "startsWith",
                "endsWith",
                "iContains",
                "iStartsWith",
                "iEndsWith",
                "notContains",
                "notStartsWith",
                "notEndsWith",
                "iNotContains",
                "iNotStartsWith",
                "iNotEndsWith",
                "regexp",
                "iregexp",
                "isNull",
                "notNull",
                "inSet",
                "notInSet",
                "equalsField",
                "notEqualField",
                "greaterThanField",
                "lessThanField",
                "greaterOrEqualField",
                "lessOrEqualField",
                "containsField",
                "startsWithField",
                "endsWithField",
                "and",
                "not",
                "or",
                "between",
                "betweenInclusive"
            ]
        },
        errorOrientationEnum:{
            ID:"errorOrientationEnum",
            inheritsFrom:"enum",
            valueMap:[
                "left",
                "right",
                "top",
                "bottom"
            ]
        },
        readOnlyDisplayEnum:{
            ID:"readOnlyDisplayEnum",
            inheritsFrom:"enum",
            valueMap:[
                "readOnly",
                "disabled",
                "static"
            ]
        }
    },
    autoIdField:"name",
    componentSchema:true,
    Constructor:"FormItem",
    methods:[
        {
            action:false,
            basic:true,
            "default":true,
            name:"click",
            title:"Click"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "formLayout",
        "appearance",
        "formIcons"
    ],
    isServerDS:true,
    ID:"FormItem",
    createStandalone:false,
    fields:[
        {
            recreateOnChange:true,
            validators:[
            ],
            name:"type",
            readOnlyIfDataBound:"true",
            basic:true,
            title:"Data Type",
            type:"FormItemType",
            xmlAttribute:true,
            group:"databinding"
        },
        {
            validators:[
            ],
            name:"editorType",
            basic:true,
            editorType:"EditorTypeItem",
            title:"Editor Type",
            type:"className",
            xmlAttribute:true
        },
        {
            recreateOnChange:true,
            validators:[
            ],
            name:"name",
            basic:true,
            title:"Name",
            type:"fieldName",
            xmlAttribute:true
        },
        {
            name:"dataPath",
            hidden:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"ID",
            basic:false,
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            title:"Title",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"defaultValue",
            basic:true,
            title:"Default Value",
            type:"any",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"defaultDynamicValue",
            title:"Default Dynamic Value",
            type:"expression",
            prompt:"JS expression - evaluates to default value",
            validators:[
            ],
            hint:"JS expression to evaluate on redraw"
        },
        {
            name:"value",
            type:"any",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoName",
            hidden:true,
            type:"fieldName",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"builderAutoID",
            hidden:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"canEdit",
            showNullAsTrue:"true",
            title:"Can Edit",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"allowExpressions",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoComplete",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canSelectText",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"changeOnKeypress",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"clipTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disableIconsOnReadOnly",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"implicitSave",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"implicitSaveOnBlur",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"readOnlyDisplay",
            type:"readOnlyDisplayEnum",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"readOnlyCanSelectText",
            type:"readOnlyDisplayEnum",
            validators:[
            ]
        },
        {
            name:"saveOnEnter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"selectOnClick",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showClippedTitleOnHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showClippedValueOnHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showErrorIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showErrorText",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocusedPickerIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"validateOnExit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"errorOrientation",
            type:"errorOrientationEnum",
            validators:[
            ]
        },
        {
            name:"showTitle",
            title:"Show Title",
            type:"boolean",
            defaultValue:"true",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"icons",
            type:"FormItemIcon",
            validators:[
            ]
        },
        {
            name:"iconVAlign",
            type:"",
            defaultValue:"bottom",
            validators:[
            ]
        },
        {
            name:"iconHeight",
            type:"positiveInteger",
            defaultValue:"20",
            validators:[
            ]
        },
        {
            name:"iconWidth",
            type:"positiveInteger",
            defaultValue:"20",
            validators:[
            ]
        },
        {
            name:"defaultIconSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            defaultValue:"/DynamicForm/default_formItem_icon.gif",
            validators:[
            ]
        },
        {
            name:"showOverIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showIcons",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"titleOrientation",
            title:"Title Orientation",
            type:"directionEnum",
            prompt:"Position item title to the left or right of text",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            title:"Title Alignment",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"titleVAlign",
            title:"Title V Alignment",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"textAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"align",
            title:"Alignment",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"vAlign",
            title:"Vertical Alignment",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"wrapTitle",
            showNullAsTrue:"true",
            title:"Title Wrapping",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"width",
            editorType:"FormFieldMeasureItem",
            title:"Width",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"colSpan",
            basic:true,
            title:"Column Span",
            type:"positiveIntegerOrAsterisk",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"titleColSpan",
            basic:true,
            title:"Title Column Span",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"rowSpan",
            basic:true,
            title:"Row Span",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            validators:[
            ],
            name:"startRow",
            basic:true,
            title:"Start Row",
            type:"boolean",
            prompt:"Position this item on a new row",
            xmlAttribute:true
        },
        {
            validators:[
            ],
            name:"endRow",
            basic:true,
            title:"End Row",
            type:"boolean",
            prompt:"Start a new row after this item",
            xmlAttribute:true
        },
        {
            name:"cellHeight",
            title:"Cell Height",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"left",
            type:"integer",
            visibility:"absForm",
            validators:[
            ]
        },
        {
            name:"top",
            type:"integer",
            visibility:"absForm",
            validators:[
            ]
        },
        {
            name:"visible",
            title:"Visible",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"showIf",
            title:"Show If",
            type:"expression",
            prompt:"JS expression - item will be visible if this evaluates to true",
            validators:[
            ],
            hint:"JS expression"
        },
        {
            name:"shouldSaveValue",
            title:"Should Save Value",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"requiresDSField",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"readOnlyIfDataBound",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"readOnlyIfOptionDataSource",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"readOnlyInLayout",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"destroyOnReplace",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"disabled",
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"required",
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            editorType:"FieldValidatorsItem",
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"readOnlyWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            fieldDependencies:"readOnlyDisplay",
            validators:[
            ]
        },
        {
            name:"visibleWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"requiredWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"formula",
            basic:true,
            type:"UserFormula",
            validators:[
            ],
            useRuleScope:"true"
        },
        {
            name:"textFormula",
            basic:true,
            type:"UserSummary",
            validators:[
            ],
            useRuleScope:"true"
        },
        {
            name:"prompt",
            basic:true,
            title:"Prompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"hint",
            basic:true,
            title:"Hint",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"showHint",
            title:"Show Hint",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"wrapHintText",
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ],
            group:"appearance"
        },
        {
            name:"redrawOnChange",
            title:"Redraw On Change",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"changeOnBlur",
            title:"Change On Blur",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"accessKey",
            title:"Access Key",
            type:"char",
            validators:[
            ]
        },
        {
            name:"tabIndex",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"globalTabIndex",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"showErrorStyle",
            title:"Show Error Styling",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDisabled",
            title:"Show Disabled Styling",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocused",
            title:"Show Focused Styling",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"selectOnFocus",
            title:"Select On Focus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hintStyle",
            title:"Hint Style",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"cellStyle",
            title:"Cell Style",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"titleStyle",
            title:"Title Style",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"textBoxStyle",
            title:"TextBox Style",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"hintClassName",
            hidden:true,
            title:"Hint Class Name",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"cellClassName",
            hidden:true,
            title:"Cell Class Name",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"errorCellClassName",
            hidden:true,
            title:"Error Cell Class Name",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"titleClassName",
            hidden:true,
            title:"Title Class Name",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"titleErrorClassName",
            hidden:true,
            title:"Title Error Class Name",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"showPickerIcon",
            title:"Show a picker icon",
            type:"boolean",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"pickerIconSrc",
            editorType:"ImageChooserItem",
            title:"Src for PickerIcon",
            type:"SCImgURL",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"pickerIconWidth",
            title:"Width for PickerIcon",
            type:"string",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"pickerIconHeight",
            title:"Height for PickerIcon",
            type:"string",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"pickerIconProperties",
            title:"Properties for the picker icon",
            type:"icon",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"controlStyle",
            title:"CSS class for form item control box",
            type:"cssClass",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"pickerIconStyle",
            title:"CSS class for form item pickerIcon",
            type:"cssClass",
            visibility:"pickerIcon",
            validators:[
            ]
        },
        {
            name:"valueField",
            basic:true,
            editorType:"BoundDSFieldPicker",
            type:"fieldName",
            validators:[
            ],
            requiresDSField:"optionDataSource"
        },
        {
            name:"displayField",
            basic:true,
            editorType:"BoundDSFieldPicker",
            type:"fieldName",
            validators:[
            ],
            requiresDSField:"optionDataSource"
        },
        {
            idAllowed:true,
            validators:[
            ],
            name:"optionDataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource",
            group:"databinding"
        },
        {
            name:"optionOperationId",
            type:"string",
            validators:[
            ]
        },
        {
            name:"operator",
            type:"OperatorId",
            validators:[
            ]
        },
        {
            displayTitle:"Icon",
            visibility:"external",
            validators:[
            ],
            name:"valueIcons",
            editorType:"MappingItem",
            type:"ValueMap",
            valueTitle:"Value"
        },
        {
            name:"emptyValueIcon",
            type:"string",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"valueIconWidth",
            type:"number",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"valueIconHeight",
            type:"number",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"valueIconSize",
            type:"number",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"valueIconLeftPadding",
            type:"number",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"valueIconRightPadding",
            type:"number",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"showValueIconOnly",
            type:"boolean",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"suppressValueIcon",
            type:"boolean",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"imageURLPrefix",
            type:"string",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"imageURLSuffix",
            type:"string",
            visibility:"external",
            validators:[
            ]
        },
        {
            name:"hoverDelay",
            type:"int",
            validators:[
            ]
        },
        {
            name:"hoverWidth",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"hoverHeight",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"hoverAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"hoverVAlign",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"hoverStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"hoverOpacity",
            type:"int",
            validators:[
            ]
        },
        {
            name:"disabledHover",
            type:"string",
            validators:[
            ]
        },
        {
            name:"readOnlyHover",
            type:"string",
            validators:[
            ]
        },
        {
            name:"readOnlyTextBoxStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"dateFormatter",
            type:"string",
            validators:[
            ]
        },
        {
            name:"timeFormatter",
            type:"string",
            validators:[
            ]
        },
        {
            name:"format",
            editorType:"FormatEditorItem",
            type:"string",
            validators:[
            ]
        },
        {
            childTagName:"property",
            multiple:true,
            name:"dynamicProperties",
            type:"DynamicProperty",
            validators:[
            ]
        },
        {
            name:"length",
            hidden:true,
            title:"Length",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"decimalPad",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"decimalPrecision",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"multiple",
            hidden:true,
            title:"Select Multiple",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"buttons",
            hidden:true,
            type:"ButtonItem",
            validators:[
            ]
        },
        {
            name:"spacing",
            hidden:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"valueMap",
            hidden:true,
            title:"Value Map",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"disabledValues",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"vertical",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"itemHeight",
            title:"Item Height",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"itemIds",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"sectionVisible",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sectionExpanded",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            hidden:true,
            type:"FormItem",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"controlGroups",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"fetchMissingValues",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFetchData",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"filterLocally",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pickListProperties",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"buttonDefaults",
            hidden:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"loadDataOnDemand",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canSelectParentItems",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"useTextField",
            hidden:true,
            title:"Use Text Field",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"show24HourTime",
            hidden:true,
            title:"Show 24Hour Time",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"showSeconds",
            hidden:true,
            title:"Show Seconds",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"canvas",
            hidden:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"canvasConstructor",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"canvasProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"canvasDefaults",
            hidden:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"wrap",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"clipValue",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"outputAsHTML",
            hidden:true,
            title:"Output as HTML",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showFocusedIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"errorIconHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"errorIconWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"errorMessageWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"linearWidth",
            editorType:"FormFieldMeasureItem",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"linearColSpan",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"linearStartRow",
            type:"boolean",
            prompt:"Position this item on a new row",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"linearEndRow",
            type:"boolean",
            prompt:"Start a new row after this item",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"FormItem",
    Constructor:"ContainerItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ContainerItem",
    fields:[
        {
            multiple:true,
            name:"items",
            inapplicable:true,
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"cellSpacing",
            inapplicable:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"cellPadding",
            inapplicable:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"cellBorder",
            inapplicable:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"recalculateItemsOnRedraw",
            inapplicable:true,
            title:"Recalculate Items On Redraw",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"DateItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"ContainerItem",
    isServerDS:true,
    ID:"DateItem",
    fields:[
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            title:"Default Value",
            type:"date",
            useTextField:"true",
            validators:[
            ]
        },
        {
            name:"useTextField",
            basic:true,
            title:"Use Text Field",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"invalidDateStringMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"centuryThreshold",
            title:"Century Threshold",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"inputFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"displayFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"selectorFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showChooserFiscalYearPicker",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showChooserWeekPicker",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showPickerTimeItem",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHintInField",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"use24HourTime",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"startDate",
            title:"Start Date",
            type:"date",
            prompt:"First available date in date-range",
            useTextField:"true",
            validators:[
            ]
        },
        {
            name:"endDate",
            title:"End Date",
            type:"date",
            prompt:"Last available date in date-range",
            useTextField:"true",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            inapplicable:true,
            type:"FormItem",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"type",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DateItem",
    Constructor:"DateTimeItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DateTimeItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        measure:{
            ID:"measure",
            inheritsFrom:"integer"
        },
        integerOrAuto:{
            ID:"integerOrAuto",
            inheritsFrom:"integer"
        },
        positionEnum:{
            ID:"positionEnum",
            inheritsFrom:"enum",
            valueMap:[
                "absolute",
                "relative"
            ]
        },
        visibilityEnum:{
            ID:"visibilityEnum",
            inheritsFrom:"enum",
            valueMap:{
                hidden:"Hidden",
                inherit:"Match Parent"
            }
        },
        overflowEnum:{
            ID:"overflowEnum",
            inheritsFrom:"enum",
            valueMap:[
                "visible",
                "hidden",
                "scroll",
                "auto",
                "clip-h",
                "clip-v"
            ]
        },
        sortEnum:{
            ID:"sortEnum",
            inheritsFrom:"enum",
            valueMap:[
                "ascending",
                "descending"
            ]
        },
        alignEnum:{
            ID:"alignEnum",
            inheritsFrom:"enum",
            valueMap:[
                "left",
                "right",
                "center"
            ]
        },
        anyAlignEnum:{
            ID:"anyAlignEnum",
            inheritsFrom:"enum",
            valueMap:[
                "left",
                "right",
                "top",
                "bottom",
                "center"
            ]
        },
        valignEnum:{
            ID:"valignEnum",
            inheritsFrom:"enum",
            valueMap:[
                "top",
                "bottom",
                "center"
            ]
        },
        bkgndRepeatEnum:{
            ID:"bkgndRepeatEnum",
            inheritsFrom:"enum",
            valueMap:[
                "repeat",
                "no-repeat",
                "repeat-x",
                "repeat-y"
            ]
        },
        dragAppearanceEnum:{
            ID:"dragAppearanceEnum",
            inheritsFrom:"enum",
            valueMap:[
                "none",
                "tracker",
                "outline",
                "target"
            ]
        },
        cursorEnum:{
            ID:"cursorEnum",
            inheritsFrom:"enum",
            valueMap:[
                "default",
                "wait",
                "hand",
                "move",
                "help",
                "text",
                "crosshair",
                "n-resize",
                "w-resize",
                "s-resize",
                "e-resize",
                "nw-resize",
                "ne-resize",
                "sw-resize",
                "se-resize"
            ]
        },
        imageTypeEnum:{
            ID:"imageTypeEnum",
            type:"enum",
            valueMap:[
                "center",
                "tile",
                "stretch"
            ]
        },
        edgeCursorMap:{
            ID:"edgeCursorMap",
            type:"DataSource",
            fields:{
                T:{
                    name:"T",
                    type:"cursorEnum"
                },
                L:{
                    name:"L",
                    type:"cursorEnum"
                },
                R:{
                    name:"R",
                    type:"cursorEnum"
                },
                B:{
                    name:"B",
                    type:"cursorEnum"
                },
                TL:{
                    name:"TL",
                    type:"cursorEnum"
                },
                TR:{
                    name:"TR",
                    type:"cursorEnum"
                },
                BL:{
                    name:"BL",
                    type:"cursorEnum"
                },
                BR:{
                    name:"BR",
                    type:"cursorEnum"
                }
            }
        },
        imageProperty:{
            ID:"imageProperty",
            type:"DataSource",
            fields:{
                src:{
                    editorType:"ImageChooserItem",
                    name:"src",
                    type:"SCImgURL"
                },
                width:{
                    name:"width",
                    type:"measure"
                },
                height:{
                    name:"height",
                    type:"measure"
                },
                name:{
                    name:"name",
                    type:"string"
                },
                imgDir:{
                    name:"imgDir",
                    type:"URL"
                },
                extraStuff:{
                    name:"extraStuff",
                    type:"string"
                }
            }
        },
        textMatchStyleEnum:{
            ID:"textMatchStyleEnum",
            type:"enum",
            valueMap:[
                "exact",
                "exactCase",
                "substring",
                "startsWith"
            ]
        }
    },
    componentSchema:true,
    Constructor:"Canvas",
    methods:[
        {
            action:true,
            icon:"actions/show.png",
            name:"show",
            title:"Show"
        },
        {
            action:true,
            icon:"actions/hide.png",
            name:"hide",
            title:"Hide"
        },
        {
            action:true,
            icon:"actions/showNextTo.png",
            name:"showNextTo",
            title:"Show Next To"
        },
        {
            action:true,
            icon:"actions/print.png",
            name:"print",
            title:"Print"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "contents",
        "appearance",
        "sizing"
    ],
    isServerDS:true,
    ID:"Canvas",
    fields:[
        {
            name:"ID",
            basic:true,
            title:"Identifier",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"withID",
            hidden:true,
            title:"Identifier",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"ref",
            hidden:true,
            title:"Identifier",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoID",
            hidden:true,
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"builderAutoID",
            hidden:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"width",
            title:"Width",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"defaultWidth",
            title:"Default Width",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"defaultHeight",
            title:"Default Height",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"inherentHeight",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"inherentWidth",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"minWidth",
            title:"Min Width",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"maxWidth",
            title:"Max Width",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"minHeight",
            title:"Min Height",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"maxHeight",
            title:"Max Height",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"position",
            valueMap:[
                "absolute",
                "relative"
            ],
            title:"Position",
            type:"enum",
            validators:[
            ]
        },
        {
            readOnlyHover:"Offsets are only allowed in absolute containers. Add a Layout Spacer to a Horizontal Layout to achieve indents or add a Horizontal Layout with Layout Spacer to achieve indents inside a Vertical Layout.",
            validators:[
            ],
            name:"left",
            readOnlyInLayout:"true",
            title:"Left Offset",
            type:"measure",
            xmlAttribute:true
        },
        {
            readOnlyHover:"Offsets are only allowed in absolute containers. Use a Layout Spacer before the component in a Vertical Layout to create extra space or add a Vertical Layout with a Layout Spacer to create extra space in a Horizontal Layout.",
            validators:[
            ],
            name:"top",
            readOnlyInLayout:"true",
            title:"Top Offset",
            type:"measure",
            xmlAttribute:true
        },
        {
            name:"contents",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"dynamicContents",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"dynamicContentsVars",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"contentsURL",
            type:"URL",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"className",
            title:"CSS Style",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"styleName",
            title:"CSS Style",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"margin",
            title:"Margin",
            type:"positiveInteger",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"padding",
            title:"Padding / Margin",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"border",
            title:"Border",
            type:"string",
            validators:[
            ]
        },
        {
            name:"borderRadius",
            recreateOnChange:true,
            title:"Border Radius",
            type:"string",
            validators:[
            ]
        },
        {
            name:"backgroundColor",
            title:"Background Color",
            type:"color",
            validators:[
            ]
        },
        {
            name:"backgroundImage",
            editorType:"ImageChooserItem",
            title:"Background Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"backgroundRepeat",
            valueMap:[
                "repeat",
                "no-repeat",
                "repeat-x",
                "repeat-y"
            ],
            title:"Background Repeat",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"cursor",
            title:"Cursor",
            type:"cursorEnum",
            validators:[
            ]
        },
        {
            name:"disabledCursor",
            title:"Disabled Cursor",
            type:"cursorEnum",
            validators:[
            ]
        },
        {
            name:"opacity",
            title:"Opacity",
            type:"integerPercent",
            validators:[
            ]
        },
        {
            name:"prompt",
            title:"Tooltip Prompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"isGroup",
            title:"Is Group?",
            type:"boolean",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"groupTitle",
            title:"Group Title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hoverDelay",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hoverStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"hoverOpacity",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"hoverMoveWithMouse",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hoverWidth",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"hoverHeight",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"hoverAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"hoverVAlign",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"hoverWrap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"appImgDir",
            type:"URL",
            validators:[
            ]
        },
        {
            name:"skinImgDir",
            type:"URL",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"showResizeBar",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"resizeBarTarget",
            type:"string",
            validators:[
            ]
        },
        {
            name:"layoutAlign",
            editorType:"LayoutAlignItem",
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"extraSpace",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"overflow",
            editorType:"OverflowItem",
            title:"Scrolling",
            type:"overflowEnum",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showCustomScrollbars",
            title:"Use Custom Scollbars",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"scrollbarSize",
            title:"Scrollbar Size",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"scrollLeft",
            title:"Scroll Left Shift (Pixels)",
            type:"integer",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"scrollTop",
            title:"Scroll Top Shift (Pixels)",
            type:"integer",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"disabled",
            title:"Disabled",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"visibleWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"redrawOnDisable",
            title:"Redraw On Disable",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"enabled",
            title:"Enabled",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"redrawOnEnable",
            title:"Redraw On Enable",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"canDrag",
            title:"Can Drag",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragStartDistance",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"dragIntersectStyle",
            valueMap:[
                "mouse",
                "rect"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"canDragReposition",
            title:"Can Drag-Reposition",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragRepositionCursor",
            title:"Drag Reposition Cursor",
            type:"cursorEnum",
            validators:[
            ]
        },
        {
            name:"canDragResize",
            title:"Can Drag-Resize",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"resizeFrom",
            valueMap:[
                "L",
                "T",
                "R",
                "B",
                "TL",
                "TR",
                "BL",
                "BR"
            ],
            title:"Resize From Edge",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showEdges",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"edgeSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"edgeMarginSize",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"edgeImage",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"customEdges",
            editorType:"ArrayItem",
            type:"string",
            validators:[
            ]
        },
        {
            name:"edgeBackgroundColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"edgeShowCenter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"edgeCenterBackgroundColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"dragAppearance",
            title:"Drag Appearance",
            type:"dragAppearanceEnum",
            validators:[
            ]
        },
        {
            name:"keepInParentRect",
            title:"Keep in Parent",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragType",
            title:"Drag Type",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dragTarget",
            title:"Drag Target",
            type:"Canvas",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"showDragShadow",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragOpacity",
            type:"integerPercent",
            validators:[
            ]
        },
        {
            name:"canDrop",
            title:"Can Drop",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canAcceptDrop",
            title:"Can Accept Drop",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDropBefore",
            title:"Can Drop Before",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDragScroll",
            title:"Can dragScroll",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragScrollThreshold",
            title:"DragScroll Threshold",
            type:"measure",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"minDragScrollIncrement",
            title:"Min DragScroll Increment",
            type:"measure",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"maxDragScrollIncrement",
            title:"Max DragScroll Increment",
            type:"measure",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"dragScrollDelay",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"dropTypes",
            type:"string",
            validators:[
            ]
        },
        {
            name:"mouseStillDownDelay",
            title:"Mouse Still Down Delay",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"mouseStillDownInitialDelay",
            title:"Mouse Still Down Initial Delay",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"doubleClickDelay",
            title:"Double-Click Delay",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"noDoubleClicks",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"edgeCursorMap",
            type:"edgeCursorMap",
            validators:[
            ]
        },
        {
            idAllowed:true,
            name:"dataSource",
            hidden:true,
            type:"DataSource",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"serviceName",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"serviceNamespace",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"useAllDataSourceFields",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showComplexFields",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFetchData",
            type:"boolean",
            visibility:"internal",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoFetchTextMatchStyle",
            recreateOnChange:true,
            type:"textMatchStyleEnum",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"dataPath",
            type:"string",
            validators:[
            ]
        },
        {
            name:"valuesManager",
            type:"ValuesManager",
            validators:[
            ],
            destroyOnReplace:"false"
        },
        {
            name:"dataArity",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoPopulateData",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"testDataContext",
            flattenSingleChild:"false",
            xmlExplicitSimpleTypes:true,
            propertiesOnly:"true",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"adminSavedSearches",
            hidden:true,
            type:"Record",
            validators:[
            ]
        },
        {
            name:"showShadow",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"shadowDepth",
            type:"int",
            validators:[
            ]
        },
        {
            name:"shadowOffset",
            type:"int",
            validators:[
            ]
        },
        {
            name:"shadowSoftness",
            type:"int",
            validators:[
            ]
        },
        {
            name:"shadowImage",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"parentElement",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"peers",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            propertiesOnly:"true",
            tagName:"childComponents",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"contextMenu",
            type:"Menu",
            validators:[
            ]
        },
        {
            name:"visibility",
            title:"Visibility",
            type:"visibilityEnum",
            validators:[
            ]
        },
        {
            name:"autoShowParent",
            title:"Auto Show Parent",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoDraw",
            hidden:true,
            title:"Auto-Draw",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"observes",
            type:"Object",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"hasFocus",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"canFocus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"redrawOnFocus",
            title:"Redraw On Focus",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"tabIndex",
            type:"int",
            validators:[
            ]
        },
        {
            name:"accessKey",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canSelectText",
            title:"Can Select Text",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"eventProxy",
            type:"Canvas",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"textDirection",
            valueMap:{
                ltr:"Left to Right",
                rtl:"Right to Left"
            },
            title:"Text Direction",
            type:"enum",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"zIndex",
            title:"Z-Index",
            type:"integerOrAuto",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"redrawOnResize",
            title:"Redraw On Resize",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"animateMoveTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateResizeTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateRectTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateFadeTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateScrollTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateShowTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateHideTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateMoveAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"animateResizeAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"animateRectAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"animateScrollAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"animateShowAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"animateHideAcceleration",
            type:"function",
            validators:[
            ]
        },
        {
            name:"htmlElement",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"htmlPosition",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"matchElement",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"snapToGrid",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"snapResizeToGrid",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"childrenSnapToGrid",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"childrenSnapResizeToGrid",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"snapOnDrop",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"snapOffsetLeft",
            type:"number",
            validators:[
            ]
        },
        {
            name:"snapOffsetTop",
            type:"number",
            validators:[
            ]
        },
        {
            name:"snapTo",
            valueMap:[
                "BR",
                "BL",
                "TR",
                "TL",
                "R",
                "L",
                "B",
                "T",
                "C"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"snapHGap",
            type:"number",
            validators:[
            ]
        },
        {
            name:"snapVGap",
            type:"number",
            validators:[
            ]
        },
        {
            name:"edgeOffset",
            type:"number",
            validators:[
            ]
        },
        {
            name:"edgeOpacity",
            type:"number",
            validators:[
            ]
        },
        {
            name:"showPointer",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"pointerTarget",
            type:"string",
            validators:[
            ]
        },
        {
            name:"pointerSettings",
            type:"PointerSettings",
            validators:[
            ]
        },
        {
            name:"ruleScope",
            type:"identifier",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"isRuleScope",
            type:"boolean",
            advanced:true,
            validators:[
            ]
        },
        {
            childTagName:"property",
            multiple:true,
            name:"dynamicProperties",
            type:"DynamicProperty",
            validators:[
            ]
        },
        {
            childTagName:"workflow",
            multiple:true,
            name:"workflows",
            propertiesOnly:"true",
            type:"Process",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"HandPlacedContainer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HandPlacedContainer",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"HandPlacedContainer",
    Constructor:"AbsoluteContainer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"AbsoluteContainer",
    fields:[
    ]
})
;
isc.DataSource.create({
    Constructor:"ProcessElement",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProcessElement",
    fields:[
        {
            name:"ID",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"description",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"nextElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"bindOutput",
            type:"string",
            validators:[
            ]
        },
        {
            name:"forceSingle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"waitFor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"waitDuration",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"waitLocator",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"mapping",
            commaSeparated:"true",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"DecisionTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DecisionTask",
    fields:[
        {
            name:"criteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        errorOrientationEnum:{
            ID:"errorOrientationEnum",
            inheritsFrom:"enum",
            valueMap:[
                "left",
                "right",
                "top",
                "bottom"
            ]
        },
        readOnlyDisplayEnum:{
            ID:"readOnlyDisplayEnum",
            inheritsFrom:"enum",
            valueMap:[
                "readOnly",
                "disabled",
                "static"
            ]
        }
    },
    componentSchema:true,
    Constructor:"DynamicForm",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/edit.png",
            name:"editSelectedData",
            title:"Edit Selected"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/add.png",
            name:"editNewRecord",
            title:"Edit New Record"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/view.png",
            name:"viewSelectedData",
            title:"View Selected Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/save.png",
            name:"saveData",
            title:"Save Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/forward.png",
            name:"setValues",
            title:"Set Values"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/undo.png",
            name:"clearValues",
            title:"Clear Values"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/first.png",
            name:"reset",
            title:"Reset Values"
        },
        {
            action:true,
            name:"validate",
            title:"Validate Values"
        },
        {
            basic:true,
            name:"itemChanged",
            title:"Item Changed"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "tableLayout",
        "appearance",
        "sizing",
        "focus",
        "formLayout",
        "formTitles",
        "ruleCriteria",
        "formValuesManager"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"DynamicForm",
    fields:[
        {
            name:"ID",
            validators:[
            ]
        },
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"autoID",
            validators:[
            ]
        },
        {
            name:"values",
            hidden:true,
            type:"Object",
            validators:[
            ]
        },
        {
            name:"errors",
            hidden:true,
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            propertiesOnly:"true",
            type:"FormItem",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"fields",
            propertiesOnly:"true",
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"numCols",
            basic:true,
            title:"Number of Columns",
            type:"integer",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            validators:[
            ],
            multiple:true,
            name:"colWidths",
            basic:true,
            editorType:"ArrayItem",
            title:"Column Widths",
            xmlAttribute:true
        },
        {
            name:"overflow",
            basic:true,
            type:"overflowEnum",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"cellPadding",
            title:"Cell Padding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"cellSpacing",
            title:"Cell Spacing",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"minColWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"fixedColWidths",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"cellBorder",
            title:"Cell Border",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"itemLayout",
            type:"string",
            visibility:"absForm",
            validators:[
            ]
        },
        {
            name:"action",
            hidden:true,
            title:"Action URL",
            type:"URL",
            validators:[
            ]
        },
        {
            name:"target",
            hidden:true,
            title:"Submit Target Frame",
            type:"string",
            validators:[
            ]
        },
        {
            name:"method",
            valueMap:[
                "GET",
                "POST"
            ],
            hidden:true,
            title:"Submit Method",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"encoding",
            valueMap:[
                "normal",
                "multipart"
            ],
            title:"Encoding",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"canSubmit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"saveOnEnter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sectionVisibilityMode",
            valueMap:[
                "mutex",
                "multiple"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"titleOrientation",
            valueMap:{
                left:"left",
                right:"right",
                top:"top"
            },
            basic:true,
            title:"Title Orientation",
            type:"string",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"titlePrefix",
            title:"Title Prefix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"rightTitlePrefix",
            title:"Right Title Prefix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"titleSuffix",
            title:"Title Suffix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"rightTitleSuffix",
            title:"Right Title Suffix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"titleWidth",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"wrapItemTitles",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hiliteRequiredFields",
            title:"Highlight Required Fields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"requiredTitlePrefix",
            title:"Required Title Prefix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"requiredTitleSuffix",
            title:"Required Title Suffix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"requiredRightTitlePrefix",
            title:"Required Right Title Prefix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"requiredRightTitleSuffix",
            title:"Required Right Title Suffix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"autoComplete",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFocus",
            title:"Auto Focus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFocusOnError",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"selectOnFocus",
            title:"Select On Focus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"unknownErrorMessage",
            title:"Unspecified Validator Error Message",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"showInlineErrors",
            title:"Show Inline Errors",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"errorOrientation",
            type:"errorOrientationEnum",
            validators:[
            ]
        },
        {
            name:"errorItemProperties",
            propertiesOnly:"true",
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"errorItemCellStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"errorsPreamble",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"validationURL",
            type:"URL",
            validators:[
            ]
        },
        {
            name:"cancelParamName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"cancelParamValue",
            type:"string",
            validators:[
            ]
        },
        {
            name:"browserSpellCheck",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"readOnlyTextBoxStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"initialSort",
            type:"SortSpecifier",
            validators:[
            ]
        },
        {
            name:"itemHoverDelay",
            type:"number",
            validators:[
            ]
        },
        {
            name:"itemHoverWidth",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"itemHoverHeight",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"itemHoverAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"itemHoverVAlign",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"itemHoverStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"itemHoverOpacity",
            type:"number",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"peers",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"groupTitle",
            basic:true,
            title:"Group Title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fetchOperation",
            type:"string",
            validators:[
            ],
            requiresDSField:"dataSource"
        },
        {
            name:"initialCriteria",
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"fetchRequestProperties",
            type:"DSRequest",
            validators:[
            ]
        },
        {
            name:"selectionComponent",
            hidden:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"longTextEditorThreshold",
            title:"Long Text Editor Threshold",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"longTextEditorType",
            title:"Long Text Editor Type",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fieldIdProperty",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"titleField",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"autoSendTarget",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"autoSendTargetFieldName",
            type:"propertyName",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showTitlesWithErrorMessages",
            type:"boolean",
            validators:[
            ]
        },
        {
            idAllowed:true,
            validators:[
            ],
            destroyOnReplace:"false",
            name:"valuesManager",
            basic:true,
            editorType:"ValuesManagerChooserItem",
            type:"ValuesManager"
        },
        {
            name:"showErrorIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showErrorText",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showErrorStyle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canEdit",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"readOnlyDisplay",
            type:"readOnlyDisplayEnum",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"linearMode",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"linearOnMobile",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"linearNumCols",
            type:"positiveInteger",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DynamicForm",
    Constructor:"HandPlacedForm",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HandPlacedForm",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"HandPlacedForm",
    Constructor:"AbsoluteForm",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"AbsoluteForm",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"Layout",
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "sizing",
        "appearance",
        "contents"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"Layout",
    fields:[
        {
            multiple:true,
            name:"sizes",
            type:"measure",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"enforcePolicy",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"vPolicy",
            type:"string",
            validators:[
            ]
        },
        {
            name:"hPolicy",
            type:"string",
            validators:[
            ]
        },
        {
            name:"resizeBarSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"resizeBarClass",
            type:"string",
            validators:[
            ]
        },
        {
            name:"vertical",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"orientation",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"align",
            basic:true,
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"defaultLayoutAlign",
            basic:true,
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"members",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"animateMembers",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateMemberTime",
            type:"number",
            visibility:"animation",
            validators:[
            ]
        },
        {
            name:"canDropComponents",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"layoutMargin",
            basic:true,
            editorType:"MeasureItem",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"paddingAsLayoutMargin",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"layoutLeftMargin",
            editorType:"MeasureItem",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"layoutRightMargin",
            editorType:"MeasureItem",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"layoutTopMargin",
            editorType:"MeasureItem",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"layoutBottomMargin",
            editorType:"MeasureItem",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"membersMargin",
            basic:true,
            editorType:"MeasureItem",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"minMemberLength",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            idAllowed:true,
            name:"minBreadthMember",
            hidden:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"reverseOrder",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dropLineThickness",
            type:"number",
            validators:[
            ]
        },
        {
            name:"dropLineProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showDragPlaceHolder",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"placeHolderDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"placeHolderProperties",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"dataSource",
            validators:[
            ]
        },
        {
            name:"leaveScrollbarGap",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"Deck",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Deck",
    fields:[
        {
            idAllowed:true,
            validators:[
            ],
            name:"currentPane",
            basic:true,
            editorType:"LayoutMemberPicker",
            title:"Initial Pane",
            type:"Canvas",
            group:"basics"
        },
        {
            multiple:true,
            name:"children",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"panes",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Action",
    fields:[
        {
            name:"target",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"type",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"name",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"mapping",
            commaSeparated:"true",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DefineClass",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"extends",
            type:"string",
            validators:[
            ]
        },
        {
            name:"properties",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"methods",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ActionDeclaration",
    fields:[
        {
            type:"string",
            name:"name",
            validators:[
            ]
        },
        {
            type:"string",
            name:"title",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Object",
            name:"params",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"DetailViewer",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/view.png",
            name:"viewSelectedData",
            title:"View Selected Data"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"DetailViewer",
    fields:[
        {
            name:"ID",
            validators:[
            ]
        },
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"autoID",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"data",
            type:"DetailViewRecord",
            validators:[
            ]
        },
        {
            childTagName:"DVField",
            multiple:true,
            name:"fields",
            type:"DetailViewerField",
            validators:[
            ]
        },
        {
            name:"fieldIdProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"recordsPerBlock",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"blockSeparator",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"cellPadding",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showBorder",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"emptyCellValue",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"labelPrefix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"labelSuffix",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"wrapLabel",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"labelStyle",
            type:"cssStyle",
            validators:[
            ]
        },
        {
            name:"cellStyle",
            type:"cssStyle",
            validators:[
            ]
        },
        {
            name:"headerStyle",
            type:"cssStyle",
            validators:[
            ]
        },
        {
            name:"separatorStyle",
            type:"cssStyle",
            validators:[
            ]
        },
        {
            name:"showEmptyMessage",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"emptyMessage",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"emptyMessageStyle",
            type:"cssStyle",
            validators:[
            ]
        },
        {
            name:"loadingMessage",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"loadingMessageStyle",
            type:"cssStyle",
            validators:[
            ]
        },
        {
            name:"showEmptyField",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dateFormatter",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"hiliteIcons",
            type:"string",
            validators:[
            ]
        },
        {
            name:"hiliteIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconLeftPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconRightPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconPosition",
            valueMap:[
                "before",
                "after",
                "replace"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"initialCriteria",
            basic:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"fetchOperation",
            type:"string",
            validators:[
            ],
            requiresDSField:"dataSource"
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            name:"wrapValues",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"overflow",
            basic:true,
            type:"overflowEnum",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"BrowserPlugin",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"BrowserPlugin",
    fields:[
        {
            name:"src",
            type:"string",
            validators:[
            ]
        },
        {
            name:"extraHTML",
            type:"string",
            validators:[
            ]
        },
        {
            name:"pluginsPage",
            type:"URL",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"BrowserPlugin",
    Constructor:"ActiveXControl",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ActiveXControl",
    fields:[
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            name:"codeBase",
            type:"URL",
            validators:[
            ]
        },
        {
            name:"uuid",
            type:"string",
            validators:[
            ]
        },
        {
            name:"params",
            type:"object",
            validators:[
            ]
        },
        {
            name:"classID",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"Window",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Window",
    fields:[
        {
            name:"autoCenter",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"isModal",
            basic:true,
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dismissOnOutsideClick",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dismissOnEscape",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"visibility",
            basic:true,
            type:"visibilityEnum",
            validators:[
            ]
        },
        {
            name:"layoutMargin",
            basic:false,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"align",
            basic:false,
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"defaultLayoutAlign",
            basic:false,
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"membersMargin",
            basic:false,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"autoSize",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"src",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"contentsType",
            type:"string",
            validators:[
            ]
        },
        {
            name:"contentLayout",
            valueMap:[
                "vertical",
                "horizontal",
                "none"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showHeader",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canFocusInHeaderButtons",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"headerConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"headerStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"hiliteHeaderStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"showHeaderBackground",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"headerSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"hiliteHeaderSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"headerDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            idAllowed:true,
            multiple:true,
            name:"headerControls",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showTitle",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"title",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"headerLabelConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"headerLabelTextStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"headerLabelInnerTextStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"headerLabelDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showHeaderIcon",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"headerIconConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"headerIconDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showCloseButton",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"closeButtonConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"closeButtonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showMinimizeButton",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"minimizeButtonConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"minimizeButtonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"minimized",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"maximized",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultMinimizeHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateMinimize",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"minimizeTime",
            type:"int",
            validators:[
            ]
        },
        {
            name:"minimizeHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"minimizeAcceleration",
            type:"string",
            validators:[
            ]
        },
        {
            name:"restoreButtonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showMaximizeButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"maximizeButtonConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"maximizeButtonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showFooter",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"footerHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            idAllowed:true,
            multiple:true,
            name:"footerControls",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showStatusBar",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"statusBarConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"statusBarStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"statusBarDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showResizer",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"resizerConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"resizerDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showToolbar",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"toolbarButtons",
            propertiesOnly:"true",
            type:"Canvas",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"toolbarConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"toolbarDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showBody",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"bodyStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"bodyColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"hiliteBodyColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"bodyConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"bodyProperties",
            propertiesOnly:"true",
            type:"Layout",
            validators:[
            ]
        },
        {
            name:"bodyDefaults",
            propertiesOnly:"true",
            type:"Layout",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showModalMask",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"modalMaskOpacity",
            type:"number",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"enableWhen",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Window",
    Constructor:"Dialog",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Dialog",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"AdaptiveMenu",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"AdaptiveMenu",
    fields:[
        {
            name:"inlineImgButton",
            type:"ImgButton",
            validators:[
            ]
        },
        {
            name:"inlineSubmenuItem",
            type:"IconMenuButton",
            validators:[
            ]
        },
        {
            name:"inlineMenuItem",
            type:"ToolStripButton",
            validators:[
            ]
        },
        {
            name:"menuButtonIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"menuButton",
            type:"MenuButton",
            validators:[
            ]
        },
        {
            name:"menuButtonTitle",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"menu",
            type:"Menu",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            type:"MenuItem",
            validators:[
            ]
        },
        {
            name:"inlinePlacement",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"partialInlining",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showInlineSeparators",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showIconOnlyInline",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        LinePattern:{
            ID:"LinePattern",
            inheritsFrom:"enum",
            valueMap:[
                "solid",
                "dot",
                "dash",
                "shortdot",
                "shortdash",
                "longdash"
            ]
        },
        LineCap:{
            ID:"LineCap",
            inheritsFrom:"enum",
            valueMap:[
                "round",
                "square",
                "butt"
            ]
        },
        ArrowStyle:{
            ID:"ArrowStyle",
            inheritsFrom:"enum",
            valueMap:[
                "block",
                "open",
                "classic",
                "oval",
                "diamond"
            ]
        },
        KnobType:{
            ID:"KnobType",
            inheritsFrom:"enum",
            valueMap:[
                "resize",
                "move",
                "startPoint",
                "endPoint",
                "controlPoint1",
                "controlPoint2"
            ]
        }
    },
    Constructor:"DrawItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawItem",
    fields:[
        {
            name:"cursor",
            title:"Cursor",
            type:"cursorEnum",
            validators:[
            ]
        },
        {
            name:"canHover",
            title:"Can Hover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHover",
            title:"Show Hover",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"prompt",
            title:"Prompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"drawPane",
            title:"Draw Pane",
            type:"DrawPane",
            validators:[
            ]
        },
        {
            name:"drawGroup",
            title:"Draw Group",
            type:"DrawGroup",
            validators:[
            ]
        },
        {
            name:"lineWidth",
            title:"Line Width",
            type:"int",
            defaultValue:"3",
            validators:[
            ]
        },
        {
            name:"lineColor",
            title:"Line Color",
            type:"color",
            defaultValue:"#808080",
            validators:[
            ]
        },
        {
            name:"lineOpacity",
            title:"Line Opacity",
            type:"float",
            defaultValue:"1.0",
            validators:[
            ]
        },
        {
            name:"linePattern",
            title:"Line Pattern",
            type:"LinePattern",
            defaultValue:"solid",
            validators:[
            ]
        },
        {
            name:"lineCap",
            title:"Line Cap",
            type:"LineCap",
            defaultValue:"round",
            validators:[
            ]
        },
        {
            name:"fillColor",
            title:"Fill Color",
            type:"color",
            validators:[
            ]
        },
        {
            name:"fillGradient",
            title:"Fill Gradient",
            type:"Gradient",
            validators:[
            ]
        },
        {
            name:"fillOpacity",
            title:"Fill Opacity",
            type:"float",
            defaultValue:"1.0",
            validators:[
            ]
        },
        {
            name:"shadow",
            title:"Shadow",
            type:"Shadow",
            validators:[
            ]
        },
        {
            name:"shapeData",
            title:"Shape Data",
            type:"object",
            validators:[
            ]
        },
        {
            name:"rotation",
            title:"Rotation",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            name:"xShearFactor",
            title:"x Shear Factor",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            name:"yShearFactor",
            title:"y Shear Factor",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"scale",
            title:"Scale",
            type:"float",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"translate",
            title:"Translate",
            type:"float",
            validators:[
            ]
        },
        {
            name:"svgFilter",
            title:"SVG Filter",
            type:"string",
            validators:[
            ]
        },
        {
            name:"startArrow",
            title:"Start Arrow",
            type:"ArrowStyle",
            validators:[
            ]
        },
        {
            name:"endArrow",
            title:"End Arrow",
            type:"ArrowStyle",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"knobs",
            title:"Knobs",
            type:"KnobType",
            validators:[
            ]
        },
        {
            name:"title",
            title:"Title",
            type:"text",
            validators:[
            ],
            nillable:true
        },
        {
            name:"keepInParentRect",
            title:"Keep In Parent Rect",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragStartDistance",
            title:"Drag Start Distance",
            type:"number",
            defaultValue:"5",
            validators:[
            ]
        },
        {
            name:"canDrag",
            title:"Can Drag",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"contextMenu",
            title:"Context Menu",
            type:"Menu",
            validators:[
            ]
        },
        {
            name:"moveKnobPoint",
            title:"Move Knob Point",
            type:"string",
            defaultValue:"TL",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"moveKnobOffset",
            title:"Move Knob Offset",
            type:"integer",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"resizeKnobPoints",
            title:"Resize Knob Points",
            type:"string",
            validators:[
            ]
        },
        {
            name:"destroyed",
            title:"Destroyed",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"destroying",
            title:"Destroying",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawCurve",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawCurve",
    fields:[
        {
            name:"startPoint",
            title:"Start Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"endPoint",
            title:"End point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"controlPoint1",
            title:"Control Point 1",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"controlPoint2",
            title:"Control Point 2",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"lineCap",
            title:"Line Cap",
            type:"LineCap",
            defaultValue:"butt",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"ComponentTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ComponentTask",
    fields:[
        {
            name:"componentId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"AddScreenTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"AddScreenTask",
    fields:[
        {
            name:"screenName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"titleFormula",
            type:"UserSummary",
            validators:[
            ]
        },
        {
            name:"canClose",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dataContextBinding",
            flattenSingleChild:"false",
            xmlExplicitSimpleTypes:true,
            propertiesOnly:"true",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawDiamond",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawDiamond",
    fields:[
        {
            name:"left",
            title:"Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"top",
            title:"Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"width",
            title:"Width",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"Criterion",
    fields:[
        {
            type:"string",
            xmlAttribute:"true",
            name:"fieldName",
            validators:[
            ]
        },
        {
            type:"AdvancedCriterionSubquery",
            name:"fieldQuery",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"operator",
            validators:[
            ]
        },
        {
            xmlAttributeInRuleCriteria:"true",
            xmlExplicitSimpleTypes:"true",
            type:"any",
            name:"value",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"valuePath",
            validators:[
            ]
        },
        {
            type:"AdvancedCriterionSubquery",
            name:"valueQuery",
            validators:[
            ]
        },
        {
            type:"any",
            xmlExplicitTypes:"true",
            name:"start",
            validators:[
            ]
        },
        {
            type:"any",
            xmlExplicitTypes:"true",
            name:"end",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Criterion",
            name:"criteria",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Criterion",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"AdvancedCriteria",
    fields:[
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"strictSQLFiltering",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"fixedValue",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawGroup",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawGroup",
    fields:[
        {
            name:"useGroupRect",
            title:"Use Group Rect",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"left",
            title:"Left",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"top",
            title:"Top",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"width",
            title:"Width",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"integer",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"drawItems",
            title:"Draw Items",
            type:"DrawItem",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"AdvancedCriterionSubquery",
    fields:[
        {
            idAllowed:"true",
            type:"DataSource",
            xmlAttribute:"true",
            name:"dataSource",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Criterion",
            name:"criteria",
            validators:[
            ]
        },
        {
            multiple:"true",
            fallbackToSingle:"true",
            type:"string",
            name:"groupBy",
            validators:[
            ]
        },
        {
            type:"SummaryFunction",
            strictValidation:"false",
            name:"summaryFunctions",
            validators:[
            ]
        },
        {
            type:"fieldName",
            xmlAttribute:"true",
            name:"queryOutput",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"queryFK",
            validators:[
            ]
        },
        {
            type:"string",
            name:"operationId",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"canEmbedSQL",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawImage",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawImage",
    fields:[
        {
            name:"left",
            title:"Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"top",
            title:"Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"width",
            title:"Width",
            type:"integer",
            defaultValue:"16",
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"integer",
            defaultValue:"16",
            validators:[
            ]
        },
        {
            name:"title",
            title:"Title",
            type:"text",
            validators:[
            ]
        },
        {
            name:"src",
            editorType:"ImageChooserItem",
            title:"Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"image",
            title:"Image",
            type:"Image",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"Application",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Application",
    fields:[
        {
            multiple:true,
            name:"rpcBindings",
            propertiesOnly:"true",
            type:"ServerObject",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Array",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawLabel",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawLabel",
    fields:[
        {
            name:"contents",
            title:"Contents",
            type:"text",
            validators:[
            ]
        },
        {
            name:"left",
            title:"Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"top",
            title:"Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"alignment",
            title:"Alignment",
            type:"text",
            defaultValue:"start",
            validators:[
            ]
        },
        {
            name:"fontFamily",
            title:"Font Family",
            type:"text",
            defaultValue:"Tahoma",
            validators:[
            ]
        },
        {
            name:"fontSize",
            title:"Font Size",
            type:"integer",
            defaultValue:"18",
            validators:[
            ]
        },
        {
            name:"fontWeight",
            title:"Font Weight",
            type:"text",
            defaultValue:"bold",
            validators:[
            ]
        },
        {
            name:"fontStyle",
            title:"Font Style",
            type:"text",
            defaultValue:"normal",
            validators:[
            ]
        },
        {
            name:"rotation",
            title:"Rotation",
            type:"float",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"UserConfirmationTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"UserConfirmationTask",
    fields:[
        {
            name:"message",
            type:"string",
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"UserConfirmationTask",
    Constructor:"UserConfirmationGateway",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"UserConfirmationGateway",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"UserConfirmationGateway",
    Constructor:"AskForValueTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"AskForValueTask",
    fields:[
        {
            name:"defaultValue",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawLine",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawLine",
    fields:[
        {
            name:"startPoint",
            title:"Start Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"endPoint",
            title:"End Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"startLeft",
            title:"Start Left",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"startTop",
            title:"Start Top",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"endLeft",
            title:"End Left",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"endTop",
            title:"End Top",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        stateEnum:{
            ID:"stateEnum",
            inheritsFrom:"enum",
            valueMap:[
                "",
                "Down",
                "Over",
                "Disabled"
            ]
        },
        selectionTypeEnum:{
            ID:"selectionTypeEnum",
            inheritsFrom:"enum",
            valueMap:[
                "button",
                "checkbox",
                "radio"
            ]
        },
        selectedEnum:{
            ID:"selectedEnum",
            inheritsFrom:"enum",
            valueMap:[
                "Selected",
                ""
            ]
        }
    },
    componentSchema:true,
    Constructor:"StatefulCanvas",
    methods:[
        {
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"StatefulCanvas",
    fields:[
        {
            name:"selected",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"className",
            inapplicable:true,
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"state",
            type:"stateEnum",
            validators:[
            ]
        },
        {
            name:"showRollOver",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showOverCanvas",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDown",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDisabled",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocused",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocusedAsOver",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"radioGroup",
            type:"string",
            validators:[
            ]
        },
        {
            name:"actionType",
            type:"selectionTypeEnum",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            name:"labelDefaults",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"labelConstructor",
            inapplicable:true,
            type:"className",
            validators:[
            ]
        },
        {
            name:"redrawOnStateChange",
            inapplicable:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"iconSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"iconWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"iconHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"iconAlign",
            type:"alignEnum",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"iconOrientation",
            type:"string",
            validators:[
            ]
        },
        {
            name:"iconSpacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"showDisabledIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRollOverIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDownIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showSelectedIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocusedIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showMenuOnClick",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"align",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"valign",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"showTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"titleStyle",
            type:"cssClass",
            visibility:"internal",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"Button",
    methods:[
        {
            action:false,
            basic:true,
            "default":true,
            name:"click",
            title:"Click"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "sizing",
        "appearance",
        "buttonIcon",
        "state"
    ],
    inheritsFrom:"StatefulCanvas",
    isServerDS:true,
    ID:"Button",
    fields:[
        {
            name:"layoutAlign",
            basic:true,
            editorType:"LayoutAlignItem",
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"wrap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hiliteAccessKey",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"action",
            editorType:"ActionMenuItem",
            hidden:true,
            type:"Action",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"AutoFitButton",
    methods:[
        {
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Button",
    isServerDS:true,
    ID:"AutoFitButton",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawPath",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawPath",
    fields:[
        {
            multiple:true,
            name:"points",
            title:"Points",
            type:"Point",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawPath",
    Constructor:"DrawLinePath",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawLinePath",
    fields:[
        {
            name:"startPoint",
            title:"Start Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"endPoint",
            title:"End Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"tailSize",
            title:"Tail Size",
            type:"integer",
            defaultValue:"30",
            validators:[
            ]
        },
        {
            name:"startLeft",
            title:"Start Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"startTop",
            title:"Start Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"endLeft",
            title:"End Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"endTop",
            title:"End Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:false,
    ID:"BMPRReader",
    fields:[
        {
            name:"ID",
            hidden:true,
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"recordType",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawOval",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawOval",
    fields:[
        {
            name:"left",
            title:"Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"top",
            title:"Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"width",
            title:"Width",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        },
        {
            name:"centerPoint",
            title:"Center Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"radius",
            title:"Radius",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"VStack",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"VStack",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"VStack",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"BatchUploader",
    fields:[
        {
            childTagName:"LGField",
            multiple:true,
            name:"gridFields",
            type:"ListGridField",
            validators:[
            ]
        },
        {
            name:"gridProperties",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"uploadFormFields",
            propertiesOnly:"true",
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"uploadFormProperties",
            propertiesOnly:"true",
            type:"DynamicForm",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"DrawPane",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawPane",
    fields:[
        {
            name:"rotation",
            title:"Rotation",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            name:"zoomLevel",
            title:"Zoom Level",
            type:"float",
            defaultValue:"1.0",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"drawItems",
            title:"Draw Items",
            type:"DrawItem",
            validators:[
            ]
        },
        {
            name:"canDrag",
            title:"Can Drag",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"gradients",
            title:"Gradients",
            type:"Gradient",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"BlurbItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    substituteClasses:"TextItem, TextAreaItem, StaticTextItem",
    isServerDS:true,
    ID:"BlurbItem",
    fields:[
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disabled",
            inapplicable:true,
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"redrawOnChange",
            inapplicable:true,
            title:"Redraw On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            inapplicable:true,
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"wrap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"clipValue",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"FormItem",
    Constructor:"CycleItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"CycleItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"CheckboxItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"CycleItem",
    isServerDS:true,
    ID:"CheckboxItem",
    fields:[
        {
            defaultValue:"false",
            validators:[
            ],
            name:"defaultValue",
            valueMap:[
                "true",
                "false"
            ],
            editorType:"radioGroup",
            title:"Default Value",
            type:"boolean"
        },
        {
            name:"showNullAsTrue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"labelAsTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"allowEmptyValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"checkedImage",
            editorType:"ImageChooserItem",
            title:"Checked Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"uncheckedImage",
            editorType:"ImageChooserItem",
            title:"Unchecked Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"unsetImage",
            editorType:"ImageChooserItem",
            title:"Unset Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"required",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"type",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"titleAlign",
            validators:[
            ]
        },
        {
            name:"showLabel",
            inapplicable:true,
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CheckboxItem",
    Constructor:"CheckboxItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"BooleanItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawPath",
    Constructor:"DrawPolygon",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawPolygon",
    fields:[
        {
            multiple:true,
            name:"points",
            title:"Points",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"lineCap",
            title:"Line Cap",
            type:"LineCap",
            defaultValue:"butt",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        borderStateEnum:{
            ID:"borderStateEnum",
            inheritsFrom:"enum",
            valueMap:[
                "up",
                "down",
                "flat"
            ]
        }
    },
    componentSchema:true,
    Constructor:"Border",
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"Border",
    fields:[
        {
            name:"borderWidth",
            type:"",
            validators:[
            ]
        },
        {
            name:"state",
            type:"borderStateEnum",
            validators:[
            ]
        },
        {
            name:"lightColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"darkColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"align",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"valign",
            type:"valignEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawRect",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawRect",
    fields:[
        {
            name:"left",
            title:"Left",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"top",
            title:"Top",
            type:"integer",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"width",
            title:"Width",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        },
        {
            name:"rounding",
            title:"Rounding",
            type:"float",
            defaultValue:"0",
            validators:[
            ]
        },
        {
            name:"lineCap",
            title:"Line Cap",
            type:"LineCap",
            defaultValue:"butt",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawSector",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawSector",
    fields:[
        {
            name:"centerPoint",
            title:"Center Point",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"startAngle",
            title:"Start Angle",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            name:"endAngle",
            title:"End Angle",
            type:"float",
            defaultValue:"20.0",
            validators:[
            ]
        },
        {
            name:"radius",
            title:"Radius",
            type:"integer",
            defaultValue:"100",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawItem",
    Constructor:"DrawShape",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawShape",
    fields:[
        {
            multiple:true,
            name:"commands",
            title:"Commands",
            type:"DrawShapeCommand",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"FormItem",
    Constructor:"CanvasItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"CanvasItem",
    fields:[
        {
            name:"canvas",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"canvasConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canvasProperties",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"canvasDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ButtonItem",
    methods:[
        {
            action:false,
            basic:true,
            "default":true,
            name:"click",
            title:"Click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"CanvasItem",
    isServerDS:true,
    ID:"ButtonItem",
    fields:[
        {
            name:"baseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"autoFit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"buttonConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"buttonProperties",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"buttonTitleAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"defaultValue",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"defaultDynamicValue",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"readOnlyWhen",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"redrawOnChange",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"required",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"validators",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"validateOnChange",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"type",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"titleAlign",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"wrapTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"titleStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"titleOrientation",
            validators:[
            ]
        },
        {
            basic:false,
            name:"titleColSpan",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"textBoxStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hintStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"formula",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"textFormula",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueField",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"displayField",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawPolygon",
    Constructor:"DrawTriangle",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawTriangle",
    fields:[
        {
            multiple:true,
            name:"points",
            title:"Points",
            type:"Point",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        ButtonTableItem:{
            ID:"ButtonTableItem",
            type:"DataSource",
            fields:{
                contents:{
                    name:"contents",
                    type:"HTMLString"
                },
                action:{
                    name:"action",
                    type:"eventHandler"
                },
                style:{
                    name:"style",
                    type:"cssStyle"
                },
                align:{
                    name:"align",
                    type:"alignEnum"
                },
                extraTagStuff:{
                    name:"extraTagStuff",
                    type:"HTMLString"
                }
            }
        }
    },
    componentSchema:true,
    Constructor:"ButtonTable",
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"ButtonTable",
    fields:[
        {
            multiple:true,
            name:"items",
            type:"ButtonTableItem",
            validators:[
            ]
        },
        {
            name:"cellSpacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"cellPadding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"cellBorder",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tableStyle",
            type:"cssClass",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        ListGridFieldType:{
            ID:"ListGridFieldType",
            inheritsFrom:"enum",
            valueMap:{
                text:"text: a normal text value",
                integer:"integer: a whole number",
                "float":"float: a fractional or decimal number",
                "boolean":"boolean: only a true or false allowed",
                date:"date: a specific date, with no time",
                time:"time: a specific time, with no date",
                datetime:"datetime: a specific time on a specific date",
                sequence:"sequence: a number where every new record gets a new value automatically",
                link:"link: a link to something on the web",
                image:"image: a link to an image on the web",
                imageFile:"imageFile: an image stored in this DataSource",
                binary:"binary: any binary file that is not an image",
                icon:"icon: a field that renders just an icon, that users can click to perform an action",
                summary:"summary: renders a dynamically calculated summary value for the record",
                localeInt:"localeInt: a whole number formatted with locale-specific formatting",
                localFloat:"localeFloat: a fractional or decimal number formatted with locale-specific formatting",
                localeCurrency:"localeCurrency: a numeric currency value formatted with locale-specific currency symbol and formatting",
                phoneNumber:"phoneNumber: a telephone number",
                any:"any: this field may contain data of any type"
            }
        },
        SummaryFunction:{
            ID:"SummaryFunction",
            inheritsFrom:"enum",
            valueMap:{
                sum:"Sum: calculates the total of the values",
                avg:"Avg: alculates the average of the values",
                max:"Max: elects the maximum value",
                min:"Min: selects the minimum value",
                multiplier:"Multiplier: multiplies all values together",
                count:"Count: count of the number of records",
                concat:"Concat: concatenates each value"
            }
        },
        AutoFitWidthApproach:{
            ID:"AutoFitWidthApproach",
            inheritsFrom:"enum",
            valueMap:[
                "value",
                "title",
                "both"
            ]
        }
    },
    autoIdField:"name",
    componentSchema:true,
    methods:[
        {
            basic:true,
            name:"recordClick"
        },
        {
            basic:true,
            name:"changed"
        },
        {
            name:"editorEnter"
        },
        {
            name:"editorExit"
        },
        {
            name:"recordDoubleClick"
        },
        {
            name:"valueIconClick"
        }
    ],
    allowAdvancedCriteria:true,
    isServerDS:true,
    ID:"ListGridField",
    fields:[
        {
            name:"name",
            recreateOnChange:true,
            basic:true,
            type:"fieldName",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoName",
            hidden:true,
            type:"fieldName",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"type",
            recreateOnChange:true,
            basic:true,
            type:"ListGridFieldType",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"summaryTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"summaryFunction",
            type:"SummaryFunction",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"summaryValue",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showGridSummary",
            showNullAsTrue:"true",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showGroupSummary",
            showNullAsTrue:"true",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"applyAfterSummary",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"width",
            type:"number",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"maxWidth",
            type:"number",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"minWidth",
            type:"number",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoFit",
            type:"AutoFitWidthApproach",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoFitWidth",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoFitWidthApproach",
            type:"AutoFitWidthApproach",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"canAutoFitWidth",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"align",
            basic:true,
            type:"alignEnum",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"cellAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"wrap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"headerBaseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"headerTitleStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"hidden",
            title:"Hide Initially",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showIf",
            editorType:"checkbox",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"hideOnPhone",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hideOnTablet",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHover",
            showNullMatchingParent:"true",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHoverComponents",
            showNullMatchingParent:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"valueMap",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"cellIcon",
            basic:true,
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"icon",
            basic:true,
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"iconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"iconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"iconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"editorIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"editorIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"iconOrientation",
            type:"string",
            validators:[
            ]
        },
        {
            name:"iconSpacing",
            type:"number",
            validators:[
            ]
        },
        {
            name:"showDisabledIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRollOverIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocusedIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDownIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showSelectedIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"valueIcons",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"editorImageURLPrefix",
            type:"URL",
            validators:[
            ]
        },
        {
            name:"editorImageURLSuffix",
            type:"URL",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"icons",
            type:"FormItemIcon",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"any",
            fieldTypeProperty:"type",
            validators:[
            ]
        },
        {
            name:"iconVAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"defaultIconSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"imageSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"imageHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"imageWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconLeftPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconRightPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconOrientation",
            valueMap:[
                "left",
                "right"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"editorValueIcons",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"editorValueIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"editorValueIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"imageURLPrefix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"imageURLSuffix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showValueIconOnly",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"suppressValueIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hiliteIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconLeftPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconRightPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconPosition",
            valueMap:[
                "before",
                "after",
                "replace"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"optionDataSource",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"valueField",
            type:"fieldName",
            validators:[
            ],
            requiresDSField:"optionDataSource"
        },
        {
            name:"displayField",
            type:"fieldName",
            validators:[
            ],
            requiresDSField:"optionDataSource"
        },
        {
            name:"optionCriteria",
            type:"AdvancedCriteria",
            validators:[
            ],
            requiresDSField:"optionDataSource"
        },
        {
            name:"displayFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"inputFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"initialValue",
            type:"any",
            fieldTypeProperty:"type",
            validators:[
            ]
        },
        {
            name:"editorValueMap",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"canSort",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"emptyCellValue",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"sortDirection",
            type:"sortEnum",
            validators:[
            ]
        },
        {
            name:"sortByDisplayField",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sortByMappedValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canEdit",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canToggle",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"required",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"nextTabColNum",
            type:"boolean",
            visibility:"advancedInlineEdit",
            validators:[
            ]
        },
        {
            name:"previousTabColNum",
            type:"boolean",
            visibility:"advancedInlineEdit",
            validators:[
            ]
        },
        {
            name:"enterKeyEditAction",
            valueMap:[
                "done",
                "nextCell",
                "nextRow",
                "nextRowStart"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"escapeKeyEditAction",
            valueMap:[
                "cancel",
                "done"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"editorType",
            type:"className",
            validators:[
            ]
        },
        {
            name:"editorProperties",
            propertiesOnly:"true",
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"linkText",
            type:"text",
            validators:[
            ]
        },
        {
            name:"canFilter",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"frozen",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"editorHint",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"defaultFilterValue",
            type:"any",
            fieldTypeProperty:"type",
            validators:[
            ]
        },
        {
            name:"filterOnKeypress",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"filterEditorValueMap",
            type:"object",
            validators:[
            ]
        },
        {
            name:"filterEditorType",
            type:"className",
            validators:[
            ]
        },
        {
            name:"filterEditorProperties",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"canEditFormula",
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canEditSummary",
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canGroupBy",
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"groupingModes",
            hidden:true,
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"groupPrecision",
            type:"number",
            validators:[
            ]
        },
        {
            name:"groupGranularity",
            type:"number",
            validators:[
            ]
        },
        {
            name:"canSortClientOnly",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFetchDisplayMap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"editorFormula",
            type:"UserFormula",
            validators:[
            ],
            useRuleScope:"true"
        },
        {
            name:"editorTextFormula",
            type:"UserSummary",
            validators:[
            ],
            useRuleScope:"true"
        },
        {
            name:"userFormula",
            type:"UserFormula",
            validators:[
            ]
        },
        {
            name:"userSummary",
            type:"UserSummary",
            validators:[
            ]
        },
        {
            name:"canExport",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"cellPrompt",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"format",
            editorType:"FormatEditorItem",
            type:"text",
            validators:[
            ]
        },
        {
            name:"decimalPrecision",
            type:"number",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"visibleWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"readOnlyWhen",
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGridField",
    autoIdField:"name",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DropDownField",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"Calendar",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Data"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "date",
        "appearance",
        "workday",
        "calendarEvent",
        "editing",
        "allowedOperations",
        "visibility",
        "data"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"Calendar",
    fields:[
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"chosenDate",
            type:"Date",
            validators:[
            ]
        },
        {
            name:"firstDayOfWeek",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"dayHeaderBaseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"dayBodyBaseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"otherDayHeaderBaseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"otherDayBodyBaseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"otherDayBlankStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"selectedCellStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"eventWindowStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"weekEventBorderOverlap",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"workdayBaseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"workdayStart",
            type:"Time",
            validators:[
            ]
        },
        {
            name:"workdayEnd",
            type:"Time",
            validators:[
            ]
        },
        {
            name:"showWorkday",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"scrollToWorkday",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"nameField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"descriptionField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"startDateField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"endDateField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"eventWindowStyleField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canEditField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"eventSnapGap",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"showQuickEventDialog",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"eventEditorFields",
            type:"FormItem",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"eventDialogFields",
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"canCreateEvents",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canEditEvents",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDeleteEvents",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDateChooser",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disableWeekends",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showWeekends",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDayHeaders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showOtherDays",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDayView",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showWeekView",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showMonthView",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"invalidDateMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"initialCriteria",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"data",
            type:"CalendarEvent",
            validators:[
            ]
        },
        {
            name:"mainViewProperties",
            propertiesOnly:"true",
            type:"TabSet",
            validators:[
            ]
        },
        {
            name:"eventDialogProperties",
            propertiesOnly:"true",
            type:"Window",
            validators:[
            ]
        },
        {
            name:"eventEditorProperties",
            propertiesOnly:"true",
            type:"DynamicForm",
            validators:[
            ]
        },
        {
            name:"eventEditorLayoutProperties",
            propertiesOnly:"true",
            type:"Window",
            validators:[
            ]
        },
        {
            name:"addEventButtonProperties",
            propertiesOnly:"true",
            type:"ImgButton",
            validators:[
            ]
        },
        {
            name:"datePickerButtonProperties",
            propertiesOnly:"true",
            type:"ImgButton",
            validators:[
            ]
        },
        {
            name:"controlsBarProperties",
            propertiesOnly:"true",
            type:"HLayout",
            validators:[
            ]
        },
        {
            name:"previousButtonProperties",
            propertiesOnly:"true",
            type:"ImgButton",
            validators:[
            ]
        },
        {
            name:"nextButtonProperties",
            propertiesOnly:"true",
            type:"ImgButton",
            validators:[
            ]
        },
        {
            name:"dateDisplayProperties",
            propertiesOnly:"true",
            type:"Label",
            validators:[
            ]
        },
        {
            name:"showEventsByTypeView",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"eventOverlapPercent",
            type:"number",
            validators:[
            ]
        },
        {
            name:"showEventCanvasComponents",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"eventScreen",
            basic:true,
            editorType:"ScreenPickerItem",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"zones",
            hidden:true,
            type:"CalendarEvent",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"indicators",
            hidden:true,
            type:"CalendarEvent",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"CalendarEvent",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"EdgeSizes",
    fields:[
        {
            name:"defaultSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"top",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"bottom",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"left",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"right",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ButtonItem",
    Constructor:"CancelItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"CancelItem",
    fields:[
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"EdgedCanvas",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"EdgedCanvas",
    fields:[
        {
            name:"edgeColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"showCenter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"edgeLeft",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"edgeRight",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"edgeTop",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"edgeBottom",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"edgeOffset",
            type:"integer",
            visibility:"roundCorners",
            validators:[
            ]
        },
        {
            name:"edgeOffsetTop",
            type:"integer",
            visibility:"roundCorners",
            validators:[
            ]
        },
        {
            name:"edgeOffsetBottom",
            type:"integer",
            visibility:"roundCorners",
            validators:[
            ]
        },
        {
            name:"edgeOffsetLeft",
            type:"integer",
            visibility:"roundCorners",
            validators:[
            ]
        },
        {
            name:"edgeOffsetRight",
            type:"integer",
            visibility:"roundCorners",
            validators:[
            ]
        },
        {
            name:"centerBackgroundColor",
            type:"color",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"EditPane",
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    addGlobalId:false,
    ID:"EditPane",
    fields:[
        {
            multiple:true,
            name:"extraPalettes",
            propertiesOnly:"true",
            type:"HiddenPalette",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            propertiesOnly:"true",
            tagName:"childComponents",
            type:"BaseWidget",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Record",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Record",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ListGridRecord",
    fields:[
        {
            name:"enabled",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"isSeparator",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"singleCellValue",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canDrag",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canAcceptDrop",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"linkText",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGridRecord",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TreeNode",
    fields:[
        {
            name:"isFolder",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            name:"parentId",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            type:"TreeNode",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeNode",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Example",
    fields:[
        {
            name:"showSource",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"external",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showSkinSwitcher",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"tabs",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"CellRecord",
    fields:[
        {
            name:"enabled",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canEdit",
            type:"boolean",
            visibility:"experimental",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeNode",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ExampleFolder",
    fields:[
        {
            multiple:true,
            name:"children",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"isOpen",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"external",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        TreeModelType:{
            ID:"TreeModelType",
            inheritsFrom:"enum",
            valueMap:[
                "parent",
                "children"
            ]
        },
        loadStateEnum:{
            ID:"loadStateEnum",
            inheritsFrom:"enum",
            valueMap:[
                "",
                "loading",
                "folders",
                "loaded"
            ]
        },
        loadStateMessagesObject:{
            ID:"loadStateMessagesObject",
            fields:{
                normal:{
                    name:"normal",
                    type:"string"
                },
                loading:{
                    name:"loading",
                    type:"string"
                },
                empty:{
                    name:"empty",
                    type:"string"
                }
            }
        }
    },
    Constructor:"Tree",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Tree",
    fields:[
        {
            name:"rootValue",
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoOpenRoot",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"modelType",
            type:"TreeModelType",
            validators:[
            ]
        },
        {
            name:"isFolderProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoSetupParentLinks",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"pathDelim",
            type:"string",
            validators:[
            ]
        },
        {
            name:"nameProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"titleProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"idField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"parentIdField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"parentProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"childrenProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"openProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"discardParentlessNodes",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"cacheOpenList",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"data",
            type:"List",
            validators:[
            ]
        },
        {
            name:"root",
            type:"TreeNode",
            validators:[
            ]
        },
        {
            name:"sortProp",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"sortDirection",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showRoot",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"separateFolders",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"defaultNodeTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"defaultLoadState",
            type:"loadStateEnum",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"loadStateMessages",
            type:"loadStateMessageObject",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"defaultIsFolder",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"reportCollisions",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Tree",
    Constructor:"ExampleTree",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ExampleTree",
    fields:[
        {
            multiple:true,
            name:"children",
            type:"Example",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TextItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    substituteClasses:"BlurbItem, StaticTextItem, TextAreaItem",
    isServerDS:true,
    ID:"TextItem",
    fields:[
        {
            name:"length",
            title:"Length",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"showHintInField",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"string",
            validators:[
            ]
        },
        {
            name:"escapeHTML",
            basic:true,
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TextItem",
    Constructor:"ColorItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ColorItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        rowEndEditActionEnum:{
            ID:"rowEndEditActionEnum",
            inheritsFrom:"enum",
            valueMap:[
                "next",
                "same",
                "done",
                "stop"
            ]
        },
        AutoFitWidthApproach:{
            ID:"AutoFitWidthApproach",
            inheritsFrom:"enum",
            valueMap:[
                "value",
                "title",
                "both"
            ]
        }
    },
    componentSchema:true,
    Constructor:"ListGrid",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/filter.png",
            name:"filterData",
            title:"Filter Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchRelatedData",
            title:"Fetch Related Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/remove.png",
            name:"removeSelectedData",
            title:"Remove Selected Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/edit.png",
            name:"startEditing",
            title:"Start Editing"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/add.png",
            name:"startEditingNew",
            title:"Start Editing New"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/export.png",
            name:"exportClientData",
            title:"Export Data (Client)"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/export.png",
            name:"exportData",
            title:"Export Data (Server)"
        },
        {
            basic:true,
            "default":true,
            name:"recordClick"
        },
        {
            basic:true,
            name:"recordDoubleClick"
        },
        {
            basic:true,
            name:"selectionUpdated"
        },
        {
            basic:true,
            name:"removeRecordClick"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "dragging",
        "editing",
        "sorting",
        "databinding",
        "cellStyling",
        "emptyMessage",
        "sizing",
        "selection"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"ListGrid",
    fields:[
        {
            name:"ID",
            validators:[
            ]
        },
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"autoID",
            validators:[
            ]
        },
        {
            name:"initialCriteria",
            basic:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"fetchRequestProperties",
            type:"DSRequest",
            validators:[
            ]
        },
        {
            name:"searchForm",
            basic:true,
            editorType:"DynamicFormPicker",
            type:"identifier",
            validators:[
            ]
        },
        {
            name:"implicitCriteria",
            hidden:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"data",
            type:"ListGridRecord",
            validators:[
            ]
        },
        {
            name:"dataProperties",
            type:"ResultSet",
            validators:[
            ]
        },
        {
            name:"dataPageSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            childTagName:"LGField",
            multiple:true,
            name:"fields",
            type:"ListGridField",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"defaultFields",
            inapplicable:true,
            type:"ListGridField",
            validators:[
            ]
        },
        {
            name:"emptyCellValue",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"minHeight",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"cellHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"fixedFieldWidths",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"fastCellUpdates",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDetailFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"drawAheadRatio",
            type:"float",
            validators:[
            ]
        },
        {
            name:"fixedRecordHeights",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"editByCell",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"saveByCell",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoSaveEdits",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"modalEditing",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"stopOnErrors",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"waitForSave",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"leaveScrollbarGap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"titleField",
            type:"fieldName",
            validators:[
            ]
        },
        {
            name:"minFieldWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"addNewBeforeEditing",
            type:"boolean",
            visibility:"advancedInlineEdit",
            validators:[
            ]
        },
        {
            name:"rowEndEditAction",
            type:"rowEndEditActionEnum",
            validators:[
            ]
        },
        {
            name:"listEndEditAction",
            type:"rowEndEditActionEnum",
            validators:[
            ]
        },
        {
            name:"enterKeyEditAction",
            valueMap:{
                done:"done",
                nextCell:"nextCell",
                nextRow:"nextRow",
                nextRowStart:"nextRowStart"
            },
            type:"enum",
            validators:[
            ]
        },
        {
            name:"escapeKeyEditAction",
            valueMap:{
                cancel:"cancel",
                done:"done"
            },
            type:"enum",
            validators:[
            ]
        },
        {
            name:"generateClickOnSpace",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"generateClickOnEnter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"generateDoubleClickOnSpace",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"generateDoubleClickOnEnter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"wrapCells",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showAllRecords",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFilterEditor",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showFilterEditorHovers",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"filterEditorHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"filterByCell",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"filterOnKeypress",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"canShowFilterEditor",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"allowFilterExpressions",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"allowFilterWindow",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFilterWindowCriteriaIndicator",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"cellPadding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"canEdit",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"confirmCancelEditing",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"cancelEditingConfirmationMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"validateByCell",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"neverValidate",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDragSelect",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"selectOnEdit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"recordEditProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"editEvent",
            valueMap:[
                "click",
                "doubleClick"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"headerButtonConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"sorterConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"headerHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"wrapHeaderTitles",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFitHeaderHeights",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHeader",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHeaderContextMenu",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"headerBackgroundColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"headerBarStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"headerBaseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"headerSpans",
            type:"HeaderSpan",
            validators:[
            ]
        },
        {
            name:"headerSpanHeight",
            hidden:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"showTreeColumnPicker",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"headerTitleStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"bodyBackgroundColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"bodyStyleName",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"recordBaseStyleProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"recordCustomStyleProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"alternateRecordStyles",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"alternateRecordFrequency",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"headerDefaults",
            hidden:true,
            propertiesOnly:"true",
            type:"Toolbar",
            validators:[
            ]
        },
        {
            name:"headerButtonDefaults",
            hidden:true,
            propertiesOnly:"true",
            type:"Button",
            validators:[
            ]
        },
        {
            name:"headerButtonProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"Button",
            validators:[
            ]
        },
        {
            name:"sorterDefaults",
            hidden:true,
            propertiesOnly:"true",
            type:"Button",
            validators:[
            ]
        },
        {
            name:"sorterProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"Button",
            validators:[
            ]
        },
        {
            name:"printHeaderStyle",
            type:"cssClass",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"printCellStyle",
            type:"cssClass",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showRollOver",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hoverByCell",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showHiliteInCells",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"selectionType",
            valueMap:[
                "none",
                "single",
                "multiple",
                "simple"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"selectionAppearance",
            valueMap:[
                "rowStyle",
                "checkbox"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showEmptyMessage",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"emptyMessage",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"emptyMessageStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"singleCellValueProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"isSeparatorProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"arrowKeyAction",
            valueMap:[
                "select",
                "focus",
                "active",
                "none"
            ],
            validators:[
            ]
        },
        {
            name:"loadingDataMessage",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"loadingMessage",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"loadingDataMessageStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"canSort",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sortField",
            type:"fieldName",
            validators:[
            ]
        },
        {
            name:"sortFieldNum",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"sortDirection",
            type:"sortEnum",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"initialSort",
            type:"SortSpecifier",
            validators:[
            ]
        },
        {
            name:"showSortArrow",
            valueMap:[
                "none",
                "corner",
                "field",
                "both"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showSortNumerals",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDragRecordsOut",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canAcceptDroppedRecords",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canReorderRecords",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragTrackerMode",
            valueMap:[
                "none",
                "icon",
                "title",
                "row"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"canReorderFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canResizeFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"resizeFieldsInRealTime",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canFreezeFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"freezeFieldText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"unfreezeFieldText",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"groupByField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canGroupBy",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"groupByText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"groupIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"groupIndentSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"groupByMaxRecords",
            type:"number",
            validators:[
            ]
        },
        {
            name:"groupStartOpen",
            type:"any",
            validators:[
            ]
        },
        {
            name:"groupTitleColumnProperties",
            propertiesOnly:"true",
            type:"ListGridField",
            validators:[
            ]
        },
        {
            name:"dragDataAction",
            valueMap:[
                "none",
                "copy",
                "move"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"sortAscendingImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"sortDescendingImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"trackerImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"selectionProperty",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"fieldIdProperty",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"longTextEditorThreshold",
            title:"Long Text Editor Threshold",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"longTextEditorType",
            title:"Long Text Editor Type",
            type:"string",
            validators:[
            ]
        },
        {
            name:"timeFormatter",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dateFormatter",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dateInputFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"bodyOverflow",
            type:"overflowEnum",
            validators:[
            ]
        },
        {
            name:"bodyProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"GridRenderer",
            validators:[
            ]
        },
        {
            name:"autoFitData",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoFitMaxRecords",
            basic:true,
            type:"integer",
            validators:[
            ]
        },
        {
            name:"autoFitMaxHeight",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"autoFitMaxColumns",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"autoFitMaxWidth",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"autoFitFieldWidths",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFitWidthApproach",
            type:"AutoFitWidthApproach",
            validators:[
            ]
        },
        {
            name:"viewState",
            editorType:"hidden",
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoPersistViewState",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"editFailedBaseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"editFailedCSSText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"editPendingCSSText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"editOnFocus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"confirmDiscardEdits",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"discardEditsSaveButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"confirmDiscardEditsMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"imageSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconLeftPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"valueIconRightPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"booleanTrueImage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"booleanFalseImage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"booleanImageWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"booleanImageHeight",
            type:"number",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"hilites",
            type:"Hilite",
            validators:[
            ]
        },
        {
            name:"canEditHilites",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"hiliteIcons",
            type:"string",
            validators:[
            ]
        },
        {
            name:"hiliteIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconLeftPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconRightPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconPosition",
            valueMap:[
                "before",
                "after",
                "replace"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            name:"fetchOperation",
            type:"string",
            validators:[
            ],
            requiresDSField:"dataSource"
        },
        {
            name:"autoFetchData",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFetchDisplayMap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"fetchDelay",
            type:"number",
            validators:[
            ]
        },
        {
            name:"scrollRedrawDelay",
            type:"number",
            validators:[
            ]
        },
        {
            name:"saveLocally",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"shrinkForFreeze",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canRemoveRecords",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"warnOnRemoval",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"warnOnRemovalMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"animateRemoveRecord",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canPickFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"useAdvancedFieldPicker",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"advancedFieldPickerThreshold",
            type:"number",
            validators:[
            ]
        },
        {
            name:"canAddFormulaFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canAddSummaryFields",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHeaderMenuButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showGridSummary",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"applyFormulaAfterSummary",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hideEmptySummaryRow",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"updateSummariesDuringEditing",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showGroupSummary",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            idAllowed:true,
            multiple:true,
            name:"gridComponents",
            hidden:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"saveDefaultSearch",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canSaveSearches",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"savedSearchStoredState",
            type:"SavedSearchStoredState",
            validators:[
            ]
        },
        {
            name:"noSavedSearchesText",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"savedSearchText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"newSearchText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"savedSearchAdminSeparator",
            type:"ListGridRecord",
            validators:[
            ]
        },
        {
            name:"savedSearchDS",
            type:"string",
            validators:[
            ]
        },
        {
            name:"savedSearchAdminRole",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canExpandRecords",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canExpandMultipleRecords",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"expansionMode",
            valueMap:[
                "detailField",
                "details",
                "related",
                "editor",
                "detailRelated"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"detailField",
            basic:true,
            editorType:"SingleFieldPicker",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"detailDS",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"expansionScreen",
            basic:true,
            editorType:"ScreenPickerItem",
            type:"string",
            validators:[
            ]
        },
        {
            name:"expansionRelatedProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"showRecordComponents",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"recordComponentPosition",
            valueMap:[
                "expand",
                "within"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"recordScreen",
            basic:true,
            editorType:"ScreenPickerItem",
            type:"string",
            validators:[
            ]
        },
        {
            name:"hoverMode",
            valueMap:[
                "detailField",
                "details",
                "related",
                "detailRelated"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showHoverComponents",
            showNullAsTrueIf:"hoverMode",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hoverScreen",
            basic:true,
            editorType:"ScreenPickerItem",
            type:"string",
            validators:[
            ]
        },
        {
            name:"animateRemoveTime",
            type:"number",
            validators:[
            ]
        },
        {
            name:"animateRemoveSpeed",
            type:"number",
            validators:[
            ]
        },
        {
            name:"headerMenuButtonIconWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"headerMenuButtonIconHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"headerMenuButtonWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"headerMenuButtonHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"checkboxFieldImageWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"checkboxFieldImageHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TreeGrid",
    methods:[
        {
            basic:true,
            name:"nodeClick"
        },
        {
            basic:true,
            name:"leafClick"
        },
        {
            basic:true,
            name:"folderClick"
        },
        {
            basic:true,
            name:"selectionUpdated"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "treeField",
        "dragging",
        "cellStyling",
        "emptyMessage",
        "sizing",
        "selection",
        "sorting",
        "editing"
    ],
    inheritsFrom:"ListGrid",
    isServerDS:true,
    ID:"TreeGrid",
    fields:[
        {
            name:"ID",
            validators:[
            ]
        },
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"autoID",
            validators:[
            ]
        },
        {
            childTagName:"TGField",
            multiple:true,
            name:"fields",
            type:"TreeGridField",
            validators:[
            ]
        },
        {
            multiple:false,
            name:"data",
            type:"Tree",
            validators:[
            ]
        },
        {
            name:"dataProperties",
            type:"ResultTree",
            validators:[
            ]
        },
        {
            name:"initialData",
            type:"List",
            validators:[
            ]
        },
        {
            name:"loadDataOnDemand",
            showNullAsTrue:"true",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoOpenTree",
            valueMap:[
                "none",
                "root",
                "all"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"treeFieldTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showRoot",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"separateFolders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showConnectors",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"displayNodeType",
            valueMap:[
                "",
                "folders",
                "leaves"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"animateFolders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateFolderSpeed",
            type:"number",
            validators:[
            ]
        },
        {
            name:"animateFolderTime",
            type:"number",
            validators:[
            ]
        },
        {
            name:"animateFolderEffect",
            type:"AnimationAcceleration",
            validators:[
            ]
        },
        {
            name:"indentSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"iconSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"nodeIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"folderIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"openIconSuffix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dropIconSuffix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"closedIconSuffix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"manyItemsImage",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"openerImage",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"connectorImage",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"canReparentNodes",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDropOnLeaves",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showOpenIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDropIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"customIconProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showCustomIconOpen",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showCustomIconDrop",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"customIconOpenProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"customIconDropProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"parentAlreadyContainsChildMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"cantDragIntoSelfMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"cantDragIntoChildMessage",
            type:"string",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canGroupBy",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"groupByField",
            validators:[
            ]
        },
        {
            basic:false,
            name:"showFilterEditor",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeGrid",
    Constructor:"Explorer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Explorer",
    fields:[
        {
            name:"explorerList",
            type:"TreeGrid",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ColorItem",
    Constructor:"ColorItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ColorPickerItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeGrid",
    Constructor:"ExplorerList",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ExplorerList",
    fields:[
        {
            name:"explorer",
            type:"TreeGrid",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ColorStop",
    fields:[
        {
            name:"offset",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            name:"opacity",
            type:"float",
            defaultValue:"1.0",
            validators:[
            ]
        },
        {
            name:"color",
            title:"Color",
            type:"color",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Facet",
    fields:[
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"inlinedValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"values",
            type:"FacetValue",
            validators:[
            ]
        },
        {
            name:"rollupValue",
            type:"FacetValueId",
            validators:[
            ]
        },
        {
            name:"isTree",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showParentsLast",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCollapse",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"collapsed",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canMinimize",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"minimized",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"width",
            type:"number",
            validators:[
            ]
        },
        {
            name:"align",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"cellAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"borderBefore",
            type:"cssLineStyle",
            validators:[
            ]
        },
        {
            name:"borderAfter",
            type:"cssLineStyle",
            validators:[
            ]
        },
        {
            name:"selectionBoundary",
            type:"selectionBoundaryEnum",
            validators:[
            ]
        },
        {
            name:"canClose",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"canSort",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"summaryValue",
            type:"FacetValueId",
            validators:[
            ]
        },
        {
            name:"summaryTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"synchColumnLayout",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ComboBoxItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"ComboBoxItem",
    fields:[
        {
            name:"valueMap",
            basic:true,
            readOnlyIfOptionDataSource:"true",
            title:"Value Map",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"pickerIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickerIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickerIconSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"showHintInField",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showPickListOnKeypress",
            type:"boolean",
            visibility:"comboBox",
            validators:[
            ]
        },
        {
            name:"completeOnTab",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"textMatchStyle",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"separatorRows",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"addUnknownValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"allowExpressions",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoOpenTree",
            valueMap:[
                "none",
                "root",
                "all"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"completeOnEnter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultToFirstOption",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"formatOnBlur",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"saveOnEnter",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"optionDataSource",
            type:"DataSource",
            validators:[
            ]
        },
        {
            name:"valueField",
            type:"fieldName",
            validators:[
            ]
        },
        {
            name:"displayField",
            type:"fieldName",
            validators:[
            ]
        },
        {
            name:"pickListHeight",
            type:"number",
            visibility:"internal",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"pickListFields",
            type:"DropDownField",
            validators:[
            ]
        },
        {
            name:"pickListCriteria",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"filterLocally",
            type:"boolean",
            validators:[
            ]
        },
        {
            validators:[
            ],
            requiresDSField:"optionDataSource",
            multiple:true,
            name:"filterFields",
            basic:true,
            editorType:"BoundDSMultiFieldPicker",
            type:"string"
        },
        {
            name:"pickListBaseStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"animatePickList",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showOptionsFromDataSource",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showAllOptions",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"optionFilterContext",
            type:"RPCRequest",
            validators:[
            ]
        },
        {
            name:"pickListProperties",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"optionCriteria",
            basic:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"specialValues",
            hidden:true,
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"pickButtonWidth",
            hidden:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickButtonHeight",
            hidden:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickButtonSrc",
            editorType:"ImageChooserItem",
            hidden:true,
            type:"SCImgURL",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        ShowDataValuesMode:{
            ID:"ShowDataValuesMode",
            inheritsFrom:"enum",
            valueMap:{
                never:"Never",
                auto:"Automatically",
                inChartOnly:"In chart if all fit",
                inChartOrHover:"In chart if fit; hover otherwise",
                inChartAndHover:"In chart if fit with hovers",
                inHoverOnly:"Only in hovers"
            }
        },
        LabelCollapseMode:{
            ID:"LabelCollapseMode",
            inheritsFrom:"enum",
            valueMap:[
                "none",
                "numeric",
                "time",
                "sample"
            ]
        },
        LabelRotationMode:{
            ID:"LabelRotationMode",
            inheritsFrom:"enum",
            valueMap:[
                "never",
                "auto",
                "always"
            ]
        },
        LegendAlignEnum:{
            ID:"LegendAlignEnum",
            inheritsFrom:"enum",
            valueMap:[
                "left",
                "right",
                "center"
            ]
        },
        ZoomStartPositionEnum:{
            ID:"ZoomStartPositionEnum",
            inheritsFrom:"enum",
            valueMap:[
                "start",
                "end"
            ]
        },
        RegressionLineTypeEnum:{
            ID:"RegressionLineTypeEnum",
            inheritsFrom:"enum",
            valueMap:[
                "line",
                "polynomial"
            ]
        },
        PointShapeEnum:{
            ID:"PointShapeEnum",
            inheritsFrom:"enum",
            valueMap:[
                "Oval",
                "Square",
                "Diamond",
                "Triangle"
            ]
        }
    },
    componentSchema:true,
    Constructor:"FacetChart",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Data"
        },
        {
            basic:true,
            "default":true,
            name:"valueClick"
        },
        {
            basic:true,
            name:"pointClick"
        },
        {
            basic:true,
            name:"legendClick"
        },
        {
            basic:true,
            name:"dataLabelClick"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"FacetChart",
    fields:[
        {
            multiple:true,
            name:"data",
            hidden:true,
            type:"CellRecord",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"facets",
            hidden:true,
            type:"Facet",
            validators:[
            ]
        },
        {
            name:"searchForm",
            basic:true,
            editorType:"DynamicFormPicker",
            type:"identifier",
            validators:[
            ]
        },
        {
            name:"filterOnKeypress",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"chartType",
            valueMap:[
                "Area",
                "Column",
                "Bar",
                "Line",
                "Radar",
                "Pie",
                "Doughnut",
                "Histogram"
            ],
            basic:true,
            type:"ChartType",
            validators:[
            ]
        },
        {
            name:"stacked",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"filled",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            multiple:true,
            name:"allowedChartTypes",
            hidden:true,
            type:"ChartType",
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"showTitle",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"centerTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"drawTitleBackground",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"drawTitleBoundary",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"titlePadding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"titleRectHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"titleProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"titleBackgroundProperies",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"titleBoundaryProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"showValueAxisLabel",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"showDataAxisLabel",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"decimalPrecision",
            title:"Axis Label Precision",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"valueTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showDataLabels",
            recreateOnChange:true,
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"showDataValuesMode",
            basic:true,
            title:"Show Labels for Values",
            type:"ShowDataValuesMode",
            validators:[
            ]
        },
        {
            name:"autoRotateLabels",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"rotateLabels",
            type:"LabelRotationMode",
            validators:[
            ]
        },
        {
            name:"radarRotateLabels",
            type:"LabelRotationMode",
            validators:[
            ]
        },
        {
            name:"valueAxisLabelProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"dataAxisLabelProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"dataLabelProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"minLabelGap",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"showInlineLabels",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showChartRect",
            title:"Show Data Area Border",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"chartRectMargin",
            title:"Chart Area Margin",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"dataMargin",
            title:"Data Area Margin",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"chartRectProperties",
            propertiesOnly:"true",
            type:"DrawRect",
            validators:[
            ]
        },
        {
            name:"padChartRectByCornerRadius",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"useLogGradations",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"logScale",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"logBase",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"logGradations",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"showLegend",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showColorScaleLegend",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showBubbleLegendPerShape",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"drawLegendBoundary",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"legendAlign",
            type:"LegendAlignEnum",
            validators:[
            ]
        },
        {
            name:"legendMargin",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"legendPadding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"legendRectHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"legendSwatchSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"legendTextPadding",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"legendItemPadding",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"legendSwatchProperties",
            propertiesOnly:"true",
            type:"DrawRect",
            validators:[
            ]
        },
        {
            name:"legendRectProperties",
            propertiesOnly:"true",
            type:"DrawRect",
            validators:[
            ]
        },
        {
            name:"legendBoundaryProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"legendLabelProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"showYTicks",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showXTicks",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"tickLength",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"minorTickLength",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tickMarkToValueAxisMargin",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"showMinorTicks",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"majorTickGradations",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"majorTickTimeIntervals",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"showDataPoints",
            title:"Draw Points for Values",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dataPointSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"dataPointProperties",
            propertiesOnly:"true",
            type:"DrawItem",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"pointShapes",
            hidden:true,
            type:"PointShapeEnum",
            validators:[
            ]
        },
        {
            name:"pointSizeMetric",
            type:"string",
            validators:[
            ]
        },
        {
            name:"minDataPointSize",
            type:"float",
            validators:[
            ]
        },
        {
            name:"maxDataPointSize",
            type:"float",
            validators:[
            ]
        },
        {
            name:"logScalePointSize",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pointSizeLogBase",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"useMultiplePointShapes",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showPointSizeLegend",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"logScalePointColor",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pointColorLogBase",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"scaleStartColor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"scaleEndColor",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"dataColors",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showShadows",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"shadowProperties",
            propertiesOnly:"true",
            type:"DrawOval",
            validators:[
            ]
        },
        {
            name:"showValueOnHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"clusterMarginRatio",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"hoverLabelProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"hoverLabelPadding",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"hoverRectProperties",
            propertiesOnly:"true",
            type:"DrawRect",
            validators:[
            ]
        },
        {
            name:"allowBubbleGradients",
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoSortBubblePoints",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"bubbleProperties",
            propertiesOnly:"true",
            type:"DrawItem",
            validators:[
            ]
        },
        {
            name:"bubbleHoverMaxDistance",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"valueAxisMargin",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"canMoveAxes",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"extraAxisMetrics",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"extraAxisSettings",
            hidden:true,
            type:"MetricSettings",
            validators:[
            ]
        },
        {
            name:"colorMutePercent",
            type:"float",
            validators:[
            ]
        },
        {
            name:"autoScrollData",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"axisStartValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"axisEndValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"barMargin",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"minBarThickness",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"maxBarThickness",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"barProperties",
            propertiesOnly:"true",
            type:"DrawRect",
            validators:[
            ]
        },
        {
            name:"pieLabelAngleStart",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"pieLabelLineExtent",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"showDoughnut",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"doughnutRatio",
            type:"float",
            validators:[
            ]
        },
        {
            name:"pieStartAngle",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"pieSliceProperties",
            propertiesOnly:"true",
            type:"DrawSector",
            validators:[
            ]
        },
        {
            name:"pieBorderProperties",
            propertiesOnly:"true",
            type:"DrawOval",
            validators:[
            ]
        },
        {
            name:"pieRingBorderProperties",
            propertiesOnly:"true",
            type:"DrawOval",
            validators:[
            ]
        },
        {
            name:"doughnutHoleProperties",
            propertiesOnly:"true",
            type:"DrawOval",
            validators:[
            ]
        },
        {
            name:"pieLabelLineProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"showRadarGradationLabels",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"endValueMetric",
            type:"string",
            validators:[
            ]
        },
        {
            name:"zIndexMetric",
            type:"string",
            validators:[
            ]
        },
        {
            name:"maxDataZIndex",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"radialLabelOffset",
            recreateOnChange:true,
            type:"integer",
            validators:[
            ]
        },
        {
            name:"proportional",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"proportionalAxisLabel",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canZoom",
            recreateOnChange:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"labelCollapseMode",
            title:"Zoom Hidden Labels Mode",
            type:"LabelCollapseMode",
            validators:[
            ]
        },
        {
            name:"zoomChart",
            propertiesOnly:"true",
            type:"FacetChart",
            validators:[
            ]
        },
        {
            name:"zoomChartProperties",
            propertiesOnly:"true",
            type:"FacetChart",
            validators:[
            ]
        },
        {
            name:"zoomSelectionChart",
            propertiesOnly:"true",
            type:"FacetChart",
            validators:[
            ]
        },
        {
            name:"zoomSelectionChartProperties",
            propertiesOnly:"true",
            type:"FacetChart",
            validators:[
            ]
        },
        {
            name:"zoomShowSelection",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"zoomChartSlider",
            propertiesOnly:"true",
            type:"RangeSlider",
            validators:[
            ]
        },
        {
            name:"zoomChartHeight",
            recreateOnChange:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"zoomLogScale",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"zoomMutePercent",
            recreateOnChange:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"zoomStartPosition",
            type:"ZoomStartPositionEnum",
            validators:[
            ]
        },
        {
            name:"zoomStartValue",
            type:"any",
            validators:[
            ]
        },
        {
            name:"zoomEndValue",
            type:"any",
            validators:[
            ]
        },
        {
            name:"gradationLabelProperties",
            propertiesOnly:"true",
            type:"DrawLabel",
            validators:[
            ]
        },
        {
            name:"pixelsPerGradation",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"otherAxisPixelsPerGradation",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"gradationGaps",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"otherAxisGradationGaps",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"otherAxisGradationTimes",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"gradationLineProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"gradationZeroLineProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"pointSizeGradations",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"usePointSizeLogGradations",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"pointSizeLogGradations",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"showGradationsOverData",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"gradationLabelPadding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"gradationTickMarkLength",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"probabilityMetric",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showStatisticsOverData",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showStandardDeviationLines",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"useSymmetricStandardDeviations",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"bandedStandardDeviations",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRegressionLine",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"standardDeviations",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"standardDeviationLineProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"regressionLineProperties",
            propertiesOnly:"true",
            type:"DrawLine",
            validators:[
            ]
        },
        {
            name:"regressionLineType",
            type:"RegressionLineTypeEnum",
            validators:[
            ]
        },
        {
            name:"regressionPolynomialDegree",
            type:"number",
            validators:[
            ]
        },
        {
            name:"printZoomChart",
            type:"boolean",
            validators:[
            ]
        },
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"initialCriteria",
            basic:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"fetchRequestProperties",
            type:"DSRequest",
            validators:[
            ]
        },
        {
            name:"autoFetchData",
            recreateOnChange:true,
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFetchTextMatchStyle",
            recreateOnChange:true,
            type:"textMatchStyleEnum",
            validators:[
            ]
        },
        {
            validators:[
            ],
            requiresDSField:"dataSource",
            multiple:true,
            name:"facetFields",
            basic:true,
            editorType:"BoundDSMultiFieldPicker",
            type:"string",
            group:"databinding"
        },
        {
            name:"valueProperty",
            basic:true,
            editorType:"SingleFieldPicker",
            type:"string",
            validators:[
            ],
            requiresDSField:"dataSource"
        },
        {
            inapplicable:true,
            name:"groupTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"enableWhen",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showEdges",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"customEdges",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeBackgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeShowCenter",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeCenterBackgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeOffset",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeOpacity",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        moveGroupId:{
            ID:"moveGroupId",
            inheritsFrom:"identifier"
        },
        hiliteId:{
            ID:"hiliteId",
            inheritsFrom:"identifier"
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FacetValue",
    fields:[
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"parentId",
            type:"FacetValueId",
            validators:[
            ]
        },
        {
            name:"moveGroup",
            type:"moveGroupId",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"canCollapse",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"collapsed",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canMinimize",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"minimized",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"isMinimizeValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"nextFacetCollapsed",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"width",
            type:"number",
            validators:[
            ]
        },
        {
            name:"align",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"cellAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"borderBefore",
            type:"cssLineStyle",
            validators:[
            ]
        },
        {
            name:"borderAfter",
            type:"cssLineStyle",
            validators:[
            ]
        },
        {
            name:"titleHilite",
            type:"hiliteId",
            validators:[
            ]
        },
        {
            name:"selectionBoundary",
            type:"selectionBoundaryEnum",
            validators:[
            ]
        },
        {
            name:"canEdit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canClose",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"canSort",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"HLayout",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HLayout",
    fields:[
        {
            validators:[
            ],
            name:"overflow",
            basic:true,
            editorType:"OverflowItem",
            title:"Scrolling",
            type:"overflowEnum",
            xmlAttribute:true
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"CompoundEditor",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Related Data",
            params:[
                {
                    type:"ListGridRecord"
                }
            ]
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/filter.png",
            name:"filterData",
            title:"Filter Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchRelatedData",
            title:"Fetch Related Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/remove.png",
            name:"removeSelectedData",
            title:"Remove Selected Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/edit.png",
            name:"startEditing",
            title:"Start Editing"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/add.png",
            name:"startEditingNew",
            title:"Start Editing New"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"HLayout",
    isServerDS:true,
    ID:"CompoundEditor",
    fields:[
        {
            name:"initialCriteria",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"data",
            type:"ListGridRecord",
            validators:[
            ]
        },
        {
            name:"dataProperties",
            type:"ResultSet",
            validators:[
            ]
        },
        {
            name:"dataPageSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"fields",
            type:"ListGridField",
            validators:[
            ]
        },
        {
            name:"dataSource",
            hidden:false,
            inapplicable:false,
            type:"DataSource",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Object",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FacetValues",
    fields:[
    ]
})
;
isc.DataSource.create({
    strictValidation:"false",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"Validator",
    fields:[
        {
            type:"string",
            xmlAttribute:"true",
            name:"type",
            validators:[
            ]
        },
        {
            type:"string",
            name:"name",
            validators:[
            ]
        },
        {
            type:"string",
            name:"description",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"stopIfFalse",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"stopOnError",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"validateOnChange",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"clientOnly",
            validators:[
            ]
        },
        {
            type:"string",
            name:"errorMessage",
            validators:[
            ]
        },
        {
            type:"float",
            name:"max",
            validators:[
            ]
        },
        {
            type:"float",
            name:"min",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"exclusive",
            validators:[
            ]
        },
        {
            type:"text",
            name:"mask",
            validators:[
            ]
        },
        {
            type:"text",
            name:"transformTo",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"precision",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"roundToPrecision",
            validators:[
            ]
        },
        {
            type:"string",
            name:"expression",
            validators:[
            ]
        },
        {
            type:"string",
            name:"otherField",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"text",
            name:"list",
            validators:[
            ]
        },
        {
            type:"ValueMap",
            name:"valueMap",
            validators:[
            ]
        },
        {
            type:"text",
            name:"substring",
            validators:[
            ]
        },
        {
            type:"text",
            name:"operator",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"count",
            validators:[
            ]
        },
        {
            type:"AdvancedCriteria",
            name:"applyWhen",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"string",
            name:"dependentFields",
            validators:[
            ]
        },
        {
            type:"string",
            name:"scriptImport",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"caseSensitive",
            validators:[
            ]
        },
        {
            type:"string",
            name:"operationId",
            validators:[
            ]
        },
        {
            idAllowed:"true",
            type:"Object",
            name:"serverCondition",
            validators:[
            ]
        },
        {
            type:"ServerObject",
            name:"serverObject",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"fieldName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"triggerEvent",
            validators:[
            ]
        },
        {
            type:"any",
            xmlAttribute:"true",
            name:"value",
            validators:[
            ]
        },
        {
            type:"string",
            name:"message",
            validators:[
            ]
        },
        {
            type:"string",
            name:"severity",
            validators:[
            ]
        },
        {
            type:"string",
            name:"displayMode",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"duration",
            validators:[
            ]
        },
        {
            type:"string",
            name:"formula",
            validators:[
            ]
        },
        {
            type:"ValueMap",
            name:"formulaVars",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"contains",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"ContainsValidator",
    fields:[
        {
            type:"string",
            name:"substring",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"FileItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"FileItem",
    fields:[
        {
            inapplicable:true,
            name:"defaultValue",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"length",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"defaultDynamicValue",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FileMonitor",
    fields:[
        {
            name:"eventType",
            validators:[
            ]
        },
        {
            name:"fileType",
            validators:[
            ]
        },
        {
            name:"name",
            validators:[
            ]
        },
        {
            name:"path",
            validators:[
            ]
        },
        {
            name:"canonicalPath",
            validators:[
            ]
        },
        {
            name:"length",
            type:"number",
            validators:[
            ]
        },
        {
            name:"lastModified",
            type:"datetime",
            validators:[
            ]
        },
        {
            length:100000000,
            name:"file",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        FacetId:{
            ID:"FacetId",
            inheritsFrom:"identifier"
        },
        FacetValueId:{
            ID:"FacetValueId",
            inheritsFrom:"identifier"
        },
        sideFacetsObject:{
            ID:"sideFacetsObject",
            fields:{
                facets:{
                    multiple:true,
                    name:"facets",
                    type:"FacetId"
                }
            }
        },
        facetEnum:{
            ID:"facetEnum",
            inheritsFrom:"enum",
            valueMap:[
                "true",
                "false",
                "number"
            ]
        },
        cssLineStyle:{
            ID:"cssLineStyle",
            inheritsFrom:"string"
        },
        selectionBoundaryEnum:{
            ID:"selectionBoundaryEnum",
            inheritsFrom:"enum",
            valueMap:[
                "before",
                "after",
                "both"
            ]
        }
    },
    componentSchema:true,
    Constructor:"CubeGrid",
    allowAdvancedCriteria:true,
    inheritsFrom:"ListGrid",
    isServerDS:true,
    ID:"CubeGrid",
    fields:[
        {
            multiple:true,
            name:"data",
            type:"CellRecord",
            validators:[
            ]
        },
        {
            name:"cellIdProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"valueProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"valueTitle",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"facets",
            type:"Facet",
            validators:[
            ]
        },
        {
            name:"rollupValue",
            type:"FacetValueId",
            validators:[
            ]
        },
        {
            name:"metricFacetId",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"columnFacets",
            type:"FacetId",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"rowFacets",
            type:"FacetId",
            validators:[
            ]
        },
        {
            name:"hideEmptyFacetValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"fixedFacetValues",
            type:"FacetValues",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"facetValueGroups",
            type:"FacetValueGroup",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"canMoveFacets",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canReorderColumns",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"rows",
            type:"sideFacetsObject",
            visibility:"hidden",
            validators:[
            ]
        },
        {
            name:"columns",
            type:"sideFacetsObject",
            visibility:"hidden",
            validators:[
            ]
        },
        {
            name:"canCollapseFacets",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canMinimizeFacets",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"bodyMinWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"bodyMinHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"defaultFacetWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"padTitles",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"wrapFacetTitles",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"wrapFacetValueTitles",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoSizeHeaders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"facetTitleAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"facetValueAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"cellAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"canResizeColumns",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canMinimizeColumns",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"bodyStyleName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"alternateRecordStyles",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"hilites",
            type:"CubeGridHilite",
            validators:[
            ]
        },
        {
            name:"hiliteProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canSelectValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canSelectHeaders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoSelectValues",
            valueMap:[
                "cols",
                "rows",
                "both",
                "none"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"autoSelectHeaders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"simpleDeselect",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canEdit",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"facetValueHoverWidth",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"facetValueHoverHeight",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"facetValueHoverAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"facetValueHoverVAlign",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"facetValueHoverStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"facetLabelHoverWidth",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"facetLabelHoverHeight",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"facetLabelHoverAlign",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"facetLabelHoverVAlign",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"facetLabelHoverStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"showCellContextMenus",
            type:"boolean",
            visibility:"experimental",
            validators:[
            ]
        },
        {
            name:"showFacetValueContextMenus",
            type:"boolean",
            visibility:"experimental",
            validators:[
            ]
        },
        {
            name:"showFacetContextMenus",
            type:"boolean",
            visibility:"experimental",
            validators:[
            ]
        },
        {
            name:"contextMenuProperties",
            propertiesOnly:"true",
            type:"Menu",
            visibility:"experimental",
            validators:[
            ]
        },
        {
            name:"controlLabels",
            type:"valueMap",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"canCloseColumns",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"canSortData",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"canSortFacets",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"sortedFacetValues",
            type:"FacetValue",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"sortedFacetId",
            type:"FacetId",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"sortDirection",
            type:"boolean",
            visibility:"infa",
            validators:[
            ]
        },
        {
            name:"chartConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"chartType",
            type:"string",
            validators:[
            ]
        },
        {
            name:"chartConfirmThreshold",
            type:"int",
            validators:[
            ]
        },
        {
            name:"showColumnSummary",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"summaryHilite",
            type:"hiliteId",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"summaryBorder",
            type:"cssLineStyle",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"summaryValue",
            type:"FacetValueId",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"summaryTitle",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"rowHeaderGridMode",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"innerHeaderControlSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"innerHeaderReorderHandleWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"enableCharting",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"mergeRowFacets",
            type:"facetEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DynamicForm",
    Constructor:"Filter",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Filter",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"FilterBuilder",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FilterBuilder",
    fields:[
        {
            name:"criteria",
            hidden:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    operationBindings:[
        {
            operationType:"fetch"
        }
    ],
    isServerDS:true,
    allowAdvancedCriteria:true,
    dropExtraFields:false,
    ID:"DBListDS",
    fields:[
        {
            name:"name",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"type",
            validators:[
            ]
        },
        {
            name:"version",
            validators:[
            ]
        },
        {
            name:"driverVersion",
            validators:[
            ]
        },
        {
            name:"status",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeGrid",
    Constructor:"Finder",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Finder",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    operationBindings:[
        {
            operationType:"fetch"
        }
    ],
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DBSchema",
    fields:[
        {
            name:"name",
            validators:[
            ]
        },
        {
            name:"itemType",
            validators:[
            ]
        },
        {
            name:"type",
            validators:[
            ]
        },
        {
            name:"length",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"primaryKey",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"path",
            hidden:true,
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"parentID",
            hidden:true,
            foreignKey:"DBSchema.path",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"LayoutSpacer",
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "sizing"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"LayoutSpacer",
    fields:[
        {
            name:"width",
            basic:true,
            type:"measure",
            validators:[
            ]
        },
        {
            name:"height",
            basic:true,
            type:"measure",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"backgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"backgroundImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"backgroundRepeat",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"margin",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"border",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"padding",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"styleName",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"overflow",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"left",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"top",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"prompt",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canHover",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showHover",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hoverWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hoverHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showShadow",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"shadowDepth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showEdges",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"customEdges",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeBackgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeCenterBackgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"edgeShowCenter",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        }
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"FixedSpacer",
    allowAdvancedCriteria:true,
    inheritsFrom:"LayoutSpacer",
    isServerDS:true,
    ID:"FixedSpacer",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    inheritsFrom:"TreeGrid",
    Constructor:"DOMGrid",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DOMGrid",
    fields:[
        {
            name:"rootElement",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"BrowserPlugin",
    Constructor:"Flashlet",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Flashlet",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"params",
            type:"object",
            validators:[
            ]
        },
        {
            name:"classID",
            type:"string",
            validators:[
            ]
        },
        {
            name:"codeBase",
            type:"URL",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"Task",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Task",
    fields:[
        {
            name:"inputField",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"inputFieldList",
            type:"string",
            validators:[
            ]
        },
        {
            name:"outputField",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"outputFieldList",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"outputExpression",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Task",
    Constructor:"ServiceTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ServiceTask",
    fields:[
        {
            idAllowed:true,
            name:"dataSource",
            type:"DataSource",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"operationType",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"operationId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"exportFormat",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"criteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"values",
            fieldsCanBeFormula:true,
            type:"Record",
            validators:[
            ]
        },
        {
            name:"fixedCriteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"fixedValues",
            type:"Record",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"sort",
            type:"SortSpecifier",
            validators:[
            ]
        },
        {
            name:"summaryFunctions",
            flattenSingleChild:"false",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"groupBy",
            fallbackToSingle:"true",
            type:"string",
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ServiceTask",
    Constructor:"DSAddTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSAddTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"FlexSpacer",
    allowAdvancedCriteria:true,
    inheritsFrom:"LayoutSpacer",
    isServerDS:true,
    ID:"FlexSpacer",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    inheritsFrom:"ServiceTask",
    Constructor:"DSFetchTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSFetchTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"FloatItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"FloatItem",
    fields:[
        {
            name:"defaultValue",
            type:"float",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"DataSourceField",
    fields:[
        {
            basic:"true",
            title:"Name",
            type:"string",
            required:"true",
            xmlAttribute:"true",
            primaryKey:"true",
            name:"name",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"description",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"sequenceName",
            validators:[
            ]
        },
        {
            type:"FieldFilterMode",
            xmlAttribute:"true",
            name:"filterOn",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"useHavingClause",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"uniqueProperty",
            validators:[
            ]
        },
        {
            basic:"true",
            title:"Type",
            type:"string",
            xmlAttribute:"true",
            name:"type",
            validators:[
            ]
        },
        {
            title:"Disabled",
            type:"boolean",
            name:"disabled",
            validators:[
            ]
        },
        {
            title:"ID Allowed",
            type:"boolean",
            xmlAttribute:"true",
            name:"idAllowed",
            validators:[
            ]
        },
        {
            title:"Required",
            type:"boolean",
            xmlAttribute:"true",
            name:"required",
            validators:[
            ]
        },
        {
            title:"Required Message",
            type:"string",
            xmlAttribute:"true",
            name:"requiredMessage",
            validators:[
            ]
        },
        {
            type:"ValueMap",
            name:"valueMap",
            validators:[
            ]
        },
        {
            multiple:"true",
            propertiesOnly:"true",
            type:"Validator",
            name:"validators",
            validators:[
            ]
        },
        {
            title:"Length",
            type:"integer",
            xmlAttribute:"true",
            name:"length",
            validators:[
            ]
        },
        {
            title:"Decimal Pad",
            type:"integer",
            xmlAttribute:"true",
            name:"decimalPad",
            validators:[
            ]
        },
        {
            title:"Decimal Precision",
            type:"integer",
            xmlAttribute:"true",
            name:"decimalPrecision",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xmlRequired",
            validators:[
            ]
        },
        {
            type:"string",
            visibility:"internal",
            name:"xmlMaxOccurs",
            validators:[
            ]
        },
        {
            type:"integer",
            visibility:"internal",
            name:"xmlMinOccurs",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xmlNonEmpty",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xsElementRef",
            validators:[
            ]
        },
        {
            title:"User can hide",
            type:"boolean",
            name:"canHide",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xmlAttribute",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"mustQualify",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xmlExplicitTypes",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xmlExplicitSimpleTypes",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xmlAttributeInRuleCriteria",
            validators:[
            ]
        },
        {
            title:"Value XPath",
            type:"XPath",
            xmlAttribute:"true",
            name:"valueXPath",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"childrenProperty",
            validators:[
            ]
        },
        {
            title:"Title",
            type:"string",
            xmlAttribute:"true",
            name:"title",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"prompt",
            validators:[
            ]
        },
        {
            title:"Detail",
            type:"boolean",
            xmlAttribute:"true",
            name:"detail",
            validators:[
            ]
        },
        {
            title:"Can Edit",
            type:"boolean",
            xmlAttribute:"true",
            name:"canEdit",
            validators:[
            ]
        },
        {
            title:"Can Save",
            type:"boolean",
            xmlAttribute:"true",
            name:"canSave",
            validators:[
            ]
        },
        {
            title:"Can Init",
            type:"boolean",
            xmlAttribute:"true",
            name:"canInit",
            validators:[
            ]
        },
        {
            title:"Can Update",
            type:"boolean",
            xmlAttribute:"true",
            name:"canUpdate",
            validators:[
            ]
        },
        {
            title:"Can View",
            type:"boolean",
            xmlAttribute:"true",
            name:"canView",
            validators:[
            ]
        },
        {
            inapplicable:"true",
            title:"Inapplicable",
            type:"boolean",
            name:"inapplicable",
            validators:[
            ]
        },
        {
            inapplicable:"true",
            title:"Advanced",
            type:"boolean",
            name:"advanced",
            validators:[
            ]
        },
        {
            inapplicable:"true",
            title:"Visibility",
            type:"string",
            name:"visibility",
            validators:[
            ]
        },
        {
            inapplicable:"true",
            title:"Hidden",
            type:"boolean",
            xmlAttribute:"true",
            name:"hidden",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"isRuleCriteria",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"fieldsCanBeFormula",
            validators:[
            ]
        },
        {
            title:"Is Primary Key",
            type:"boolean",
            xmlAttribute:"true",
            name:"primaryKey",
            validators:[
            ]
        },
        {
            title:"Foreign Key",
            type:"string",
            xmlAttribute:"true",
            name:"foreignKey",
            validators:[
            ]
        },
        {
            type:"string",
            name:"otherFKs",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"displayField",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"foreignDisplayField",
            validators:[
            ]
        },
        {
            valueMap:{
                inner:"A regular inner join",
                outer:"An outer join"
            },
            type:"string",
            xmlAttribute:"true",
            name:"joinType",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"useLocalDisplayFieldValue",
            validators:[
            ]
        },
        {
            title:"Tree Root Value",
            type:"string",
            xmlAttribute:"true",
            name:"rootValue",
            validators:[
            ]
        },
        {
            title:"Include From",
            type:"string",
            xmlAttribute:"true",
            name:"includeFrom",
            validators:[
            ]
        },
        {
            title:"Include Via",
            type:"string",
            xmlAttribute:"true",
            name:"includeVia",
            validators:[
            ]
        },
        {
            title:"Related Table Alias",
            type:"string",
            xmlAttribute:"true",
            name:"relatedTableAlias",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"showFileInline",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"escapeHTML",
            validators:[
            ]
        },
        {
            type:"integerOrIdentifier",
            xmlAttribute:"true",
            name:"imageWidth",
            validators:[
            ]
        },
        {
            type:"integerOrIdentifier",
            xmlAttribute:"true",
            name:"imageHeight",
            validators:[
            ]
        },
        {
            hidden:"true",
            title:"Native Name",
            type:"string",
            name:"nativeName",
            validators:[
            ]
        },
        {
            hidden:"true",
            title:"Native Foreign Key",
            type:"string",
            xmlAttribute:"true",
            name:"nativeFK",
            validators:[
            ]
        },
        {
            hidden:"true",
            type:"boolean",
            xmlAttribute:"true",
            name:"autoDeriveFKs",
            validators:[
            ]
        },
        {
            hidden:"true",
            title:"Field Name",
            type:"string",
            name:"fieldName",
            validators:[
            ]
        },
        {
            hidden:"true",
            uniqueProperty:"name",
            childTagName:"field",
            multiple:"true",
            propertiesOnly:"true",
            type:"DataSourceField",
            name:"fields",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"multiple",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"validateEachItem",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Object",
            name:"pickListFields",
            validators:[
            ]
        },
        {
            valueMap:{
                json:"JSON serialisation",
                none:"No transformation is applied to values",
                simpleString:"Delimeter-separated string"
            },
            type:"string",
            xmlAttribute:"true",
            name:"multipleStorage",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"canFilter",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"ignore",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"skipSerialization",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"unknownType",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"canSortClientOnly",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"tagName",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"childTagName",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"basic",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"recreateOnChange",
            validators:[
            ]
        },
        {
            type:"text",
            name:"fieldDependencies",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"maxFileSize",
            validators:[
            ]
        },
        {
            title:"Frozen",
            type:"boolean",
            xmlAttribute:"true",
            name:"frozen",
            validators:[
            ]
        },
        {
            editorType:"FormatEditorItem",
            type:"string",
            xmlAttribute:"true",
            name:"format",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"precision",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"canExport",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"exportTitle",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"exportFormat",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"sqlStorageStrategy",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"encodeInResponse",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"mimeType",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"ignoreTextMatchStyle",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"lenientXPath",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"summaryFunction",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"includeSummaryFunction",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"joinString",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"joinPrefix",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"joinSuffix",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"allowClientRequestedSummaries",
            validators:[
            ]
        },
        {
            type:"any",
            xmlAttribute:"true",
            name:"defaultValue",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"group",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"ID",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"inheritsFrom",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"javaClass",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"javaCollectionClass",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"javaKeyClass",
            validators:[
            ]
        },
        {
            valueMap:{
                MD5:"Message Digest algorithm 5",
                SHA:"Secure Hashing Algorithm (SHA-1)",
                "SHA-256":"Secure Hashing Algorithm (SHA-256)",
                "SHA-512":"Secure Hashing Algorithm (SHA-512)",
                bcrypt:"Blowfish-based cipher 'bcrypt'",
                none:"Force no hashing of the value"
            },
            type:"string",
            xmlAttribute:"true",
            name:"storeWithHash",
            validators:[
            ]
        },
        {
            type:"string",
            name:"sqlDateFormat",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"storeMilliseconds",
            validators:[
            ]
        },
        {
            valueMap:{
                always:"Always audited",
                change:"Only audited when value changed",
                never:"Never audited"
            },
            type:"string",
            xmlAttribute:"true",
            name:"audit",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"initRequiresAuthentication",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"viewRequiresAuthentication",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"editRequiresAuthentication",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"updateRequiresAuthentication",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"initRequiresRole",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"viewRequiresRole",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"editRequiresRole",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"updateRequiresRole",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"initRequires",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"viewRequires",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"editRequires",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"updateRequires",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customSelectExpression",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customCriteriaExpression",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customInsertExpression",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customUpdateExpression",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"customSQL",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"autoQuoteCustomExpressions",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"creatorOverrides",
            validators:[
            ]
        },
        {
            type:"string",
            name:"valueWriteXPath",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useJoin",
            validators:[
            ]
        },
        {
            type:"string",
            name:"tableName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"multipleStorageSeparator",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"defineSQLColumnAsNotNull",
            validators:[
            ]
        },
        {
            type:"string",
            name:"valueMapEnum",
            validators:[
            ]
        },
        {
            type:"string",
            name:"sqlFalseValue",
            validators:[
            ]
        },
        {
            type:"string",
            name:"sqlTrueValue",
            validators:[
            ]
        },
        {
            type:"string",
            name:"sortByField",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"columnCode",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"stringInBrowser",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"nillable",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"string",
            name:"validOperators",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fieldTypeProperty",
            validators:[
            ]
        },
        {
            type:"string",
            name:"moveTo",
            validators:[
            ]
        },
        {
            type:"string",
            name:"uploadFieldName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"batchUploadOperationId",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"batchUploadCaseSensitive",
            validators:[
            ]
        },
        {
            type:"string",
            name:"importStrategyFailedErrorMessage",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"unionOf",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"fieldValueScript",
            validators:[
            ]
        },
        {
            type:"string",
            name:"translatorClassName",
            validators:[
            ]
        },
        {
            type:"string",
            valueMap:{
                never:"Field is never delivered.",
                single:"Field is delivered for a fetch by primary key and a cache sync data for update/insert operations.",
                whenPresent:"Field is delivered as cache sync data only if the client seems to already have it for that record (present in dsRequest.values or oldValues)."
            },
            name:"outputWhen",
            validators:[
            ]
        }
    ],
    xsi:"http://www.w3.org/2001/XMLSchema-instance"
})
;
isc.DataSource.create({
    inheritsFrom:"DataSourceField",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSField",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TileLayout",
    allowAdvancedCriteria:true,
    groups:[
        "layoutPolicy",
        "layoutMargin",
        "sizing"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"TileLayout",
    fields:[
        {
            multiple:true,
            name:"tiles",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"tileSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tileWidth",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tileHeight",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tileMargin",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tileHMargin",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"tileVMargin",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"expandMargins",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"layoutMargin",
            basic:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"layoutPolicy",
            valueMap:[
                "fit",
                "flow"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"orientation",
            basic:true,
            type:"Orientation",
            validators:[
            ]
        },
        {
            name:"tilesPerLine",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"autoWrapLines",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"paddingAsLayoutMargin",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateTileChange",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragDataAction",
            valueMap:[
                "none",
                "copy",
                "move"
            ],
            basic:true,
            type:"enum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TileLayout",
    Constructor:"FlowLayout",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FlowLayout",
    fields:[
        {
            name:"autoWrapLines",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"tilesPerLine",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    operationBindings:[
        {
            operationType:"fetch"
        }
    ],
    isServerDS:true,
    allowAdvancedCriteria:true,
    dropExtraFields:false,
    ID:"DSRegistryListDS",
    fields:[
        {
            name:"ID",
            title:"Name",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"type",
            validators:[
            ]
        },
        {
            name:"version",
            validators:[
            ]
        },
        {
            name:"objectFormat",
            validators:[
            ]
        },
        {
            name:"object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ServiceTask",
    Constructor:"DSRemoveTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSRemoveTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    autoIdField:"name",
    componentSchema:true,
    methods:[
        {
            basic:true,
            "default":true,
            name:"click",
            description:"Fires when this icon is clicked",
            params:[
                {
                    name:"form",
                    type:"DynamicForm"
                },
                {
                    name:"item",
                    type:"FormItem"
                },
                {
                    name:"icon",
                    type:"FormItemIcon"
                }
            ]
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Object",
    isServerDS:true,
    ID:"FormItemIcon",
    fields:[
        {
            name:"name",
            basic:true,
            type:"fieldName",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoName",
            hidden:true,
            type:"fieldName",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            recreateOnChange:true,
            validators:[
            ],
            name:"src",
            basic:true,
            editorType:"ImageChooserItem",
            title:"Image",
            type:"SCImgURL"
        },
        {
            name:"showOver",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"overSrc",
            recreateOnChange:true,
            editorType:"ImageChooserItem",
            title:"Over Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"width",
            recreateOnChange:true,
            basic:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"height",
            recreateOnChange:true,
            basic:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"neverDisable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFocused",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"inline",
            recreateOnChange:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"prompt",
            type:"string",
            validators:[
            ]
        },
        {
            name:"disabled",
            recreateOnChange:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"visibleWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSRequest",
    fields:[
        {
            name:"exportAs",
            valueMap:[
                "csv",
                "xml",
                "json",
                "xls",
                "ooxml",
                "custom"
            ],
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"exportDisplay",
            valueMap:[
                "download",
                "window",
                "return"
            ],
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"groupBy",
            type:"string",
            validators:[
            ]
        },
        {
            name:"summaryFunctions",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"sortBy",
            type:"any",
            validators:[
            ]
        },
        {
            name:"applyCriteriaBeforeAggregation",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DynamicForm",
    Constructor:"FormLayout",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormLayout",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSRequestModifier",
    fields:[
        {
            name:"fieldName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"operator",
            type:"string",
            validators:[
            ]
        },
        {
            name:"value",
            type:"string",
            validators:[
            ]
        },
        {
            name:"start",
            type:"string",
            validators:[
            ]
        },
        {
            name:"end",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"criteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"criterion",
            hidden:true,
            type:"Criterion",
            validators:[
            ],
            moveTo:"criteria"
        },
        {
            name:"Criterion",
            hidden:true,
            type:"Criterion",
            validators:[
            ],
            moveTo:"criteria"
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Gradient",
    fields:[
        {
            name:"ref",
            title:"Identifier",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"colorStops",
            type:"ColorStop",
            validators:[
            ]
        },
        {
            name:"startColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"endColor",
            type:"color",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ServiceTask",
    Constructor:"DSUpdateTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DSUpdateTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        cssText:{
            ID:"cssText",
            inheritsFrom:"text"
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridHilite",
    fields:[
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"htmlBefore",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"htmlAfter",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"style",
            type:"cssText",
            validators:[
            ]
        },
        {
            name:"disabled",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"DataSource",
    allowAdvancedCriteria:true,
    xsi:"http://www.w3.org/2001/XMLSchema-instance",
    isServerDS:true,
    addGlobalId:"false",
    ID:"DataSource",
    fields:[
        {
            type:"string",
            xmlAttribute:"true",
            name:"ID",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"description",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Object",
            name:"sampleData",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"autoIdField",
            validators:[
            ]
        },
        {
            title:"Superclass",
            type:"string",
            xmlAttribute:"true",
            name:"inheritsFrom",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useParentFieldOrder",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useLocalFieldsOnly",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"restrictToParentFields",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"tableCollation",
            validators:[
            ]
        },
        {
            valueMap:{
                custom:"Custom Binding",
                iscServer:"ISC Java Server",
                json:"JSON Web Service",
                xml:"XML / WSDL Web Service"
            },
            title:"DataFormat",
            type:"string",
            xmlAttribute:"true",
            name:"dataFormat",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"useStrictJSON",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"apidoc",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"isSampleDS",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"noAutoFetch",
            validators:[
            ]
        },
        {
            valueMap:{
                exec:"executes a command external to the JVM",
                generic:"Requests will be delivered to the server and you are expected to write Java code to create a valid response",
                hibernate:"ISC Server Hibernate Connectors",
                jpa:"Use SmartClient's built-in JPA 2.0 connector",
                jpa1:"Use SmartClient's built-in JPA 1.0 connector",
                rest:"Server-side REST implementation",
                sql:"ISC Server SQL Connectors",
                stream:"DataSource connected to a messaging broker"
            },
            title:"Server Type",
            type:"string",
            xmlAttribute:"true",
            name:"serverType",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"schemaBean",
            validators:[
            ]
        },
        {
            title:"Callback Parameter",
            type:"string",
            xmlAttribute:"true",
            name:"callbackParam",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"requestProperties",
            validators:[
            ]
        },
        {
            childTagName:"DSField",
            multiple:"true",
            propertiesOnly:"true",
            type:"DataSourceField",
            name:"fields",
            validators:[
            ]
        },
        {
            title:"Add Global ID",
            type:"boolean",
            name:"addGlobalId",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"showPrompt",
            validators:[
            ]
        },
        {
            title:"DataSource Version",
            type:"number",
            visibility:"internal",
            xmlAttribute:"true",
            name:"dataSourceVersion",
            validators:[
            ]
        },
        {
            title:"Database Name",
            type:"string",
            xmlAttribute:"true",
            name:"dbName",
            validators:[
            ]
        },
        {
            title:"Schema",
            type:"string",
            xmlAttribute:"true",
            name:"schema",
            validators:[
            ]
        },
        {
            title:"Audit Schema",
            type:"string",
            xmlAttribute:"true",
            name:"auditSchema",
            validators:[
            ]
        },
        {
            title:"Table Name",
            type:"string",
            xmlAttribute:"true",
            name:"tableName",
            validators:[
            ]
        },
        {
            title:"Quote Table Name?",
            type:"boolean",
            xmlAttribute:"true",
            name:"quoteTableName",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"tableCode",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"tableCharacterSet",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"strictSQLFiltering",
            validators:[
            ]
        },
        {
            type:"string",
            name:"relatedTableAlias",
            validators:[
            ]
        },
        {
            title:"Stream realtime updates for changes to this datasource?",
            type:"boolean",
            xmlAttribute:"true",
            name:"realtimeUpdates",
            validators:[
            ]
        },
        {
            type:"ServerObject",
            name:"serverObject",
            validators:[
            ]
        },
        {
            type:"string",
            name:"serverConstructor",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"OperationBinding",
            name:"operationBindings",
            validators:[
            ]
        },
        {
            hidden:"true",
            propertiesOnly:"true",
            type:"DataSourceField",
            moveTo:"fields",
            name:"field",
            validators:[
            ]
        },
        {
            hidden:"true",
            type:"OperationBinding",
            moveTo:"operationBindings",
            name:"operationBinding",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"serviceNamespace",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"dataURL",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"dataProtocol",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"dataTransport",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"defaultParams",
            validators:[
            ]
        },
        {
            type:"string",
            name:"soapAction",
            validators:[
            ]
        },
        {
            type:"string",
            name:"jsonPrefix",
            validators:[
            ]
        },
        {
            type:"string",
            name:"jsonSuffix",
            validators:[
            ]
        },
        {
            type:"string",
            name:"messageTemplate",
            validators:[
            ]
        },
        {
            propertiesOnly:"true",
            type:"Object",
            visibility:"internal",
            name:"defaultCriteria",
            validators:[
            ]
        },
        {
            type:"string",
            visibility:"xmlBinding",
            name:"tagName",
            validators:[
            ]
        },
        {
            type:"XPath",
            name:"recordXPath",
            validators:[
            ]
        },
        {
            type:"string",
            name:"recordName",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"xmlNamespaces",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"dropExtraFields",
            validators:[
            ]
        },
        {
            type:"string",
            visibility:"internal",
            xmlAttribute:"true",
            name:"schemaNamespace",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"mustQualify",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xsdSimpleContent",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xsdAnyElement",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            name:"xsdAbstract",
            validators:[
            ]
        },
        {
            title:"Title",
            type:"string",
            name:"title",
            validators:[
            ]
        },
        {
            title:"Title Field",
            type:"string",
            name:"titleField",
            validators:[
            ]
        },
        {
            title:"Plural Title",
            type:"string",
            name:"pluralTitle",
            validators:[
            ]
        },
        {
            title:"Client Only",
            type:"boolean",
            xmlAttribute:"true",
            name:"clientOnly",
            validators:[
            ]
        },
        {
            title:"Test File Name",
            type:"URL",
            xmlAttribute:"true",
            name:"testFileName",
            validators:[
            ]
        },
        {
            type:"URL",
            xmlAttribute:"true",
            name:"dbImportFileName",
            validators:[
            ]
        },
        {
            multiple:"true",
            skipSerialization:"true",
            type:"Object",
            name:"testData",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Object",
            name:"cacheData",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"cacheAllData",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"cacheAcrossOperationIds",
            validators:[
            ]
        },
        {
            multiple:"true",
            hidden:"true",
            type:"SandboxedTestFile",
            name:"sandboxedTestFiles",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"mockMode",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"mockDataRows",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"Criterion",
            name:"mockDataCriteria",
            validators:[
            ]
        },
        {
            multiple:"true",
            propertiesOnly:"true",
            type:"DataSourceField",
            uniqueProperty:"ID",
            visibility:"internal",
            name:"types",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"string",
            visibility:"internal",
            name:"groups",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"MethodDeclaration",
            visibility:"internal",
            name:"methods",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"showSuperClassActions",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"createStandalone",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useFlatFields",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"showLocalFieldsOnly",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"showSuperClassEvents",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"globalNamespaces",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"autoDeriveSchema",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"autoDeriveFKs",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useLocalValidators",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"autoDeriveTitles",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"qualifyColumnNames",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"validateRelatedRecords",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"requiresAuthentication",
            validators:[
            ]
        },
        {
            type:"string",
            name:"requiresRole",
            validators:[
            ]
        },
        {
            type:"string",
            name:"requires",
            validators:[
            ]
        },
        {
            type:"string",
            name:"ownerIdField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"ownerIdNullRole",
            validators:[
            ]
        },
        {
            valueMap:{
                edit:"all users can fetch and update",
                none:"fetch, update disallowed",
                view:"all users can fetch"
            },
            type:"string",
            xmlAttribute:"true",
            name:"ownerIdNullAccess",
            validators:[
            ]
        },
        {
            type:"string",
            name:"guestUserId",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"beanClassName",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"autoJoinTransactions",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useAnsiJoins",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"useSpringTransaction",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"sparseUpdates",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"noNullUpdates",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"canExport",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"progressiveLoading",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"autoConvertRelativeDates",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"allowAdvancedCriteria",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"dropUnknownCriteria",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"allowDynamicTreeJoins",
            validators:[
            ]
        },
        {
            type:"string",
            name:"scriptImport",
            validators:[
            ]
        },
        {
            idAllowed:"true",
            type:"Object",
            name:"script",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"transformRequestScript",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"transformResponseScript",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"allowClientRequestedSummaries",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"string",
            name:"patternMultiWildcard",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"string",
            name:"patternSingleWildcard",
            validators:[
            ]
        },
        {
            type:"string",
            valueMap:{
                dropOnChange:"Drop on criteria change",
                dropOnShortening:"Drop if criteria became more restrictive"
            },
            name:"criteriaPolicy",
            validators:[
            ]
        },
        {
            type:"string",
            name:"substituteClasses",
            validators:[
            ]
        },
        {
            type:"string",
            name:"idClassName",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"supportTransactions",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"creatorOverrides",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"loadParents",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"loadID",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"audit",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditDataSourceID",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditDSConstructor",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditRevisionFieldName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditTimeStampFieldName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditTypeFieldName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditUserFieldName",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"compareMetadataForAuditChangeStatus",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"auditChangedFieldsFieldLength",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auditedDataSourceID",
            validators:[
            ]
        },
        {
            childTagName:"addedAuditField",
            multiple:"true",
            propertiesOnly:"true",
            type:"DataSourceField",
            name:"addedAuditFields",
            validators:[
            ]
        },
        {
            hidden:"true",
            propertiesOnly:"true",
            type:"DataSourceField",
            moveTo:"addedAuditFields",
            name:"addedAuditField",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"autoCreateAuditTable",
            validators:[
            ]
        },
        {
            type:"string",
            valueMap:{
                full:"Inherit fields by copying them onto the inheriting DataSource's underlying table.",
                none:"Do not physically inherit fields onto the inheriting DataSource's SQL table"
            },
            name:"inheritanceMode",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"quoteColumnNames",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"generatedBy",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useUTCDateTimes",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useOfflineStorage",
            validators:[
            ]
        },
        {
            type:"string",
            name:"enumOrdinalProperty",
            validators:[
            ]
        },
        {
            type:"string",
            valueMap:{
                bean:"Translates to/from a Javascript object containing one property for each property defined within the enum.",
                ordinal:"Translates to/from an integer matching the ordinal number of the constant within the enumeration",
                string:"Translates to/from a String matching the constant name."
            },
            name:"enumTranslateStrategy",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"xmlFromConfig",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"translatePatternOperators",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileNameField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileTypeField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileFormatField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileSizeField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileLastModifiedField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileContentsField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileVersionField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"fileSourceExtensionFields",
            validators:[
            ]
        },
        {
            type:"string",
            name:"projectFileKey",
            validators:[
            ]
        },
        {
            childTagName:"location",
            multiple:"true",
            type:"string",
            name:"projectFileLocations",
            validators:[
            ]
        },
        {
            type:"string",
            name:"defaultTextMatchStyle",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"ignoreTextMatchStyleCaseSensitive",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"arrayCriteriaForceExact",
            validators:[
            ]
        },
        {
            valueMap:{
                always:"PK always required no matter what",
                clientRequest:"PK required for client requests only",
                never:"PK never required",
                rpcManager:"PK required for requests associated with RPCManager"
            },
            type:"string",
            xmlAttribute:"true",
            name:"defaultMultiUpdatePolicy",
            validators:[
            ]
        },
        {
            type:"string",
            name:"maxFileSizeExceededMessage",
            validators:[
            ]
        },
        {
            title:"Required Message",
            type:"string",
            xmlAttribute:"true",
            name:"requiredMessage",
            validators:[
            ]
        },
        {
            type:"AdvancedCriteria",
            xmlAttribute:"true",
            name:"implicitCriteria",
            validators:[
            ]
        },
        {
            type:"boolean",
            visibility:"internal",
            xmlAttribute:"true",
            name:"immutableAcrossSandboxes",
            validators:[
            ]
        },
        {
            title:"Is a Reify sample DS?",
            type:"boolean",
            xmlAttribute:"true",
            name:"sample",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"readOnly",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"canDelete",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"unionOf",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"unionFields",
            validators:[
            ]
        },
        {
            valueMap:{
                all:"Include all fields from all member databases",
                intersect:"Only include fields that appear on all member dataSources (match by name)",
                matching:"Only include fields that appear on two or more member dataSources (match by name)"
            },
            type:"text",
            xmlAttribute:"true",
            name:"defaultUnionFieldsStrategy",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"cacheSyncStrategy",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"cacheSyncTiming",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowSQL",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowFetch",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowAdd",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowUpdate",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowRemove",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowCustom",
            validators:[
            ]
        },
        {
            type:"DataSource",
            name:"serverConfig",
            validators:[
            ]
        },
        {
            type:"text",
            name:"requestFormat",
            validators:[
            ]
        },
        {
            type:"text",
            name:"responseFormat",
            validators:[
            ]
        },
        {
            type:"text",
            name:"requestTemplate",
            validators:[
            ]
        },
        {
            type:"text",
            name:"responseTemplate",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"wrapInList",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"headers",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"params",
            validators:[
            ]
        },
        {
            type:"text",
            name:"httpMethod",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"requiresCompleteRESTResponse",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"includeExtraValuesInTemplatedResponse",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"requestMaxRows",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"clientRequestMaxRows",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"allowAggregation",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"suppressManualAggregation",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SectionItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"CanvasItem",
    isServerDS:true,
    ID:"SectionItem",
    fields:[
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disabled",
            inapplicable:true,
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"redrawOnChange",
            inapplicable:true,
            title:"Redraw On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            inapplicable:true,
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"title",
            inapplicable:true,
            title:"Title",
            type:"string",
            validators:[
            ]
        },
        {
            validators:[
            ],
            name:"defaultValue",
            basic:true,
            title:"Title",
            type:"string",
            xmlAttribute:true,
            group:"basics"
        },
        {
            name:"showTitle",
            inapplicable:true,
            title:"Show Title",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"canCollapse",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sectionVisible",
            title:"Section Visible",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sectionExpanded",
            title:"Section Expanded",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sectionHeaderClass",
            type:"className",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"itemIds",
            title:"Item Ids",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            title:"Inline Items",
            type:"FormItem",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SectionItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GroupItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    operationBindings:[
        {
            operationId:"dsFromSQL",
            operationType:"custom"
        },
        {
            operationId:"dsFromTable",
            operationType:"custom"
        },
        {
            operationId:"dsFromConfig",
            operationType:"custom"
        }
    ],
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DataSourceStore",
    fields:[
        {
            name:"ID",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"version",
            validators:[
            ]
        },
        {
            length:50000,
            name:"dsXML",
            type:"text",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"config",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"dbName",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"tableName",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"schema",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"sql",
            validators:[
            ]
        },
        {
            name:"ds",
            hidden:true,
            type:"DataSource",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"HStack",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HStack",
    fields:[
    ]
})
;
isc.DataSource.create({
    Constructor:"DataSource",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"DataSources",
    fields:[
        {
            type:"string",
            xmlAttribute:"true",
            name:"loadID",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"HTMLFlow",
    methods:[
        {
            action:true,
            name:"setContentsURL",
            title:"Set URL"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"HTMLFlow",
    fields:[
        {
            name:"contents",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"dynamicContents",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"contentsURL",
            basic:true,
            type:"url",
            validators:[
            ]
        },
        {
            name:"contentsURLParams",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"httpMethod",
            type:"SendMethod",
            validators:[
            ]
        },
        {
            name:"contentsType",
            valueMap:[
                "page",
                "fragment"
            ],
            basic:true,
            type:"enum",
            defaultValue:"fragment",
            validators:[
            ]
        },
        {
            name:"evalScriptBlocks",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"loadingMessage",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"peers",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"allowCaching",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"captureSCComponents",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"VLayout",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"VLayout",
    fields:[
        {
            validators:[
            ],
            name:"overflow",
            basic:true,
            editorType:"OverflowItem",
            title:"Scrolling",
            type:"overflowEnum",
            xmlAttribute:true
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"DataView",
    methods:[
        {
            basic:true,
            name:"drawn",
            title:"Drawn"
        },
        {
            basic:true,
            name:"dataContextChanged",
            title:"Screen Inputs Changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"VLayout",
    isServerDS:true,
    ID:"DataView",
    fields:[
        {
            multiple:true,
            name:"operations",
            type:"ServiceOperation",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"minMemberLength",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"HTMLPane",
    allowAdvancedCriteria:true,
    groups:[
        "contentLoading",
        "contents",
        "appearance"
    ],
    inheritsFrom:"HTMLFlow",
    isServerDS:true,
    ID:"HTMLPane",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"DateChooser",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DateChooser",
    fields:[
        {
            name:"showTodayButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showCancelButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"todayButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"cancelButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"firstDayOfWeek",
            type:"int",
            validators:[
            ]
        },
        {
            name:"baseButtonStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"baseWeekdayStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"baseWeekendStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"headerStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showDoubleYearIcon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disableWeekends",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showWeekends",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"prevYearIconWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"prevYearIconHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"prevMonthIconWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"prevMonthIconHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"nextYearIconWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"nextYearIconHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"nextMonthIconHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"nextMonthIconWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"todayButtonHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"headerHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"ToolStrip",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolStrip",
    fields:[
        {
            name:"vertical",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"separatorClass",
            type:"string",
            validators:[
            ]
        },
        {
            name:"separatorSize",
            type:"int",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ToolStrip",
    Constructor:"Header",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Header",
    fields:[
        {
            name:"title",
            basic:true,
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"HeaderItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    isServerDS:true,
    ID:"HeaderItem",
    fields:[
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disabled",
            inapplicable:true,
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"redrawOnChange",
            inapplicable:true,
            title:"Redraw On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            inapplicable:true,
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"title",
            inapplicable:true,
            title:"Title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showTitle",
            inapplicable:true,
            title:"Show Title",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"dateRange",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"DateRangeValidator",
    fields:[
        {
            type:"date",
            name:"max",
            validators:[
            ]
        },
        {
            type:"date",
            name:"min",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"exclusive",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"Img",
    methods:[
        {
            basic:true,
            name:"click"
        },
        {
            basic:true,
            name:"doubleClick"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StatefulCanvas",
    isServerDS:true,
    ID:"Img",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"imageType",
            basic:true,
            type:"imageTypeEnum",
            validators:[
            ]
        },
        {
            name:"size",
            hidden:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"imageHeight",
            basic:true,
            type:"measureOrIdentifier",
            validators:[
            ]
        },
        {
            name:"imageWidth",
            basic:true,
            type:"measureOrIdentifier",
            validators:[
            ]
        },
        {
            name:"activeAreaHTML",
            type:"string",
            validators:[
            ]
        },
        {
            name:"src",
            basic:true,
            editorType:"ImageChooserItem",
            title:"Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"title",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFit",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            name:"width",
            basic:true,
            title:"Canvas Width",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"height",
            basic:true,
            title:"Canvas Height",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DecisionBranch",
    fields:[
        {
            name:"criteria",
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"targetTask",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"MultiDecisionTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MultiDecisionTask",
    fields:[
        {
            multiple:true,
            name:"decisionList",
            type:"DecisionBranch",
            validators:[
            ]
        },
        {
            name:"defaultElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"nextElement",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"MultiDecisionTask",
    Constructor:"DecisionGateway",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DecisionGateway",
    fields:[
        {
            name:"criteriaMap",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        DetailViewerFieldType:{
            ID:"DetailViewerFieldType",
            inheritsFrom:"enum",
            valueMap:{
                text:"text: a normal text value",
                integer:"integer: a whole number",
                "float":"float: a fractional or decimal number",
                "boolean":"boolean: only a true or false allowed",
                date:"date: a specific date, with no time",
                time:"time: a specific time, with no date",
                datetime:"datetime: a specific time on a specific date",
                link:"link: a link to something on the web",
                image:"image: a link to an image on the web",
                header:"header: a header value",
                separator:"separator: a separator between fields"
            }
        }
    },
    autoIdField:"name",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DetailViewerField",
    fields:[
        {
            name:"name",
            recreateOnChange:true,
            basic:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoName",
            hidden:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"type",
            recreateOnChange:true,
            basic:true,
            type:"DetailViewerFieldType",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            type:"HTMLString",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"valueMap",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"showIf",
            hidden:true,
            type:"expression",
            validators:[
            ]
        },
        {
            name:"asHTML",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"value",
            title:"Header value",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"dateFormatter",
            type:"string",
            validators:[
            ]
        },
        {
            name:"decimalPad",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"decimalPrecision",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"cellStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"printCellStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"linkText",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"linkTextProperty",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"target",
            title:"Open in (target)",
            type:"string",
            validators:[
            ]
        },
        {
            name:"width",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"height",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"imageSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"imageWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"imageHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"canHilite",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hiliteIconSize",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconLeftPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconRightPadding",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteIconPosition",
            valueMap:[
                "before",
                "after",
                "replace"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"format",
            editorType:"FormatEditorItem",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DetailViewerRecord",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"doesntContain",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"DoesntContainValidator",
    fields:[
        {
            type:"string",
            name:"substring",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DrawCurve",
    Constructor:"DrawBlockConnector",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawBlockConnector",
    fields:[
        {
            name:"controlPoint1",
            title:"Control Point 1",
            type:"Point",
            validators:[
            ]
        },
        {
            name:"controlPoint2",
            title:"Control Point 2",
            type:"Point",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        DrawShapeCommandType:{
            ID:"DrawShapeCommandType",
            inheritsFrom:"enum",
            valueMap:[
                "close",
                "moveto",
                "lineto",
                "circleto",
                "ellipseto"
            ]
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawShapeCommand",
    fields:[
        {
            name:"type",
            title:"Type",
            type:"DrawShapeCommandType",
            validators:[
            ]
        },
        {
            name:"args",
            type:"DrawShapeCommandArgs",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"DrawShapeCommandArgs",
    fields:[
    ]
})
;
isc.DataSource.create({
    autoIdField:"name",
    componentSchema:true,
    Constructor:"DynamicProperty",
    allowAdvancedCriteria:true,
    isServerDS:true,
    addGlobalId:false,
    ID:"DynamicProperty",
    fields:[
        {
            name:"name",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"dataPath",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"formula",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"template",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"trueWhen",
            type:"TrueWhen",
            validators:[
            ]
        },
        {
            childTagName:"case",
            multiple:true,
            name:"valueFrom",
            propertiesOnly:"true",
            type:"ValueFromMapping",
            validators:[
            ]
        },
        {
            name:"type",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Window",
    Constructor:"EditSearchWindow",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"EditSearchWindow",
    fields:[
        {
            name:"savedSearchEditor",
            type:"SavedSearchEditor",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"EnableDisableTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"EnableDisableTask",
    fields:[
        {
            name:"targetTabName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetFieldName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"disable",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"EndProcessTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"EndProcessTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FacetValueGroup",
    fields:[
        {
            name:"id",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"values",
            type:"FacetValue",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"facetValues",
            type:"FacetValue",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FetchRelatedDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FetchRelatedDataTask",
    fields:[
        {
            idAllowed:true,
            name:"dataSource",
            type:"DataSource",
            validators:[
            ]
        },
        {
            name:"recordSourceComponent",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"floatLimit",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"FloatLimitValidator",
    fields:[
        {
            type:"float",
            name:"min",
            validators:[
            ]
        },
        {
            type:"float",
            name:"max",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"precision",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"roundToPrecision",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"floatPrecision",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"FloatPrecisionValidator",
    fields:[
        {
            type:"integer",
            name:"precision",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"roundToPrecision",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"floatRange",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"FloatRangeValidator",
    fields:[
        {
            type:"float",
            name:"max",
            validators:[
            ]
        },
        {
            type:"float",
            name:"min",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"exclusive",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormClearValuesTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormClearValuesTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormDisableFieldTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormDisableFieldTask",
    fields:[
        {
            name:"targetField",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"disable",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormEditNewRecordTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormEditNewRecordTask",
    fields:[
        {
            name:"initialValues",
            fieldsCanBeFormula:true,
            type:"Record",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"FormEditNewRecordTask",
    Constructor:"FormEditRecordTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormEditRecordTask",
    fields:[
        {
            name:"recordSourceComponent",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormEditSelectedTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormEditSelectedTask",
    fields:[
        {
            name:"selectionComponentId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TextItem",
    Constructor:"FormFieldMeasureItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormFieldMeasureItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormHideFieldTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormHideFieldTask",
    fields:[
        {
            name:"targetField",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"hide",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormResetValuesTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormResetValuesTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormSaveDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormSaveDataTask",
    fields:[
        {
            name:"showNotification",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"notifyMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"notifyType",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"notifyPosition",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"clearAfterSave",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormSetFieldValueTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormSetFieldValueTask",
    fields:[
        {
            name:"targetField",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"value",
            xmlAttributeInRuleCriteria:true,
            xmlExplicitTypes:true,
            type:"any",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormSetValuesTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormSetValuesTask",
    fields:[
        {
            name:"values",
            fieldsCanBeFormula:true,
            type:"Record",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"FormValidateValuesTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"FormValidateValuesTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GetPropertiesTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GetPropertiesTask",
    fields:[
        {
            name:"targetFieldName",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"properties",
            type:"ValueMap",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GmailAttachmentDS",
    fields:[
        {
            name:"userId",
            type:"text",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"messageId",
            type:"text",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"attachmentId",
            type:"text",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"file",
            type:"binary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    progressiveLoading:true,
    ID:"GmailMessageDS",
    fields:[
        {
            name:"userId",
            type:"text",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"messageId",
            type:"text",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"to",
            type:"text",
            validators:[
            ]
        },
        {
            name:"from",
            type:"text",
            validators:[
            ]
        },
        {
            name:"date",
            type:"text",
            validators:[
            ]
        },
        {
            name:"subject",
            type:"text",
            validators:[
            ]
        },
        {
            name:"snippet",
            type:"text",
            validators:[
            ]
        },
        {
            name:"body",
            type:"text",
            validators:[
            ]
        },
        {
            name:"mimeType",
            type:"text",
            validators:[
            ]
        },
        {
            name:"hasAttachments",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"q",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridEditRecordTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridEditRecordTask",
    fields:[
        {
            name:"criteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"initialValues",
            fieldsCanBeFormula:true,
            type:"Record",
            validators:[
            ]
        },
        {
            name:"editFirstRecord",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridExportClientDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridExportClientDataTask",
    fields:[
        {
            name:"requestProperties",
            propertiesOnly:"true",
            type:"DSRequest",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridExportDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridExportDataTask",
    fields:[
        {
            name:"requestProperties",
            propertiesOnly:"true",
            type:"DSRequest",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridFetchDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridFetchDataTask",
    fields:[
        {
            name:"criteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"applyToImplicitCriteria",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"summaryFunctions",
            strictValidation:"false",
            type:"SummaryFunction",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"groupBy",
            fallbackToSingle:"true",
            type:"string",
            validators:[
            ]
        },
        {
            name:"requestProperties",
            type:"DSRequest",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridFetchRelatedDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridFetchRelatedDataTask",
    fields:[
        {
            idAllowed:true,
            name:"dataSource",
            type:"DataSource",
            validators:[
            ]
        },
        {
            name:"recordSourceComponent",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridRemoveSelectedDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridRemoveSelectedDataTask",
    fields:[
        {
            name:"allowMultiRecordRemove",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"refuseMultiRemoveMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showConfirmation",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"confirmationMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"multipleConfirmationMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"unboundConfirmationMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"unboundMultipleConfirmationMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridSaveAllEditsTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridSaveAllEditsTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridSelectRecordsTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridSelectRecordsTask",
    fields:[
        {
            name:"select",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"criteria",
            type:"Criterion",
            validators:[
            ]
        },
        {
            name:"selectMultiple",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"keepExistingSelection",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"scrollIntoView",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridSetEditValueTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridSetEditValueTask",
    fields:[
        {
            name:"targetField",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"value",
            xmlAttributeInRuleCriteria:true,
            xmlExplicitTypes:true,
            type:"any",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridStartEditingTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridStartEditingTask",
    fields:[
        {
            name:"initialValues",
            fieldsCanBeFormula:true,
            type:"Record",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridTransferDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridTransferDataTask",
    fields:[
        {
            name:"sourceComponent",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"GridViewSelectedDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"GridViewSelectedDataTask",
    fields:[
        {
            name:"selectionComponentId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"hasRelatedRecord",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"HasRelatedRecordValidator",
    fields:[
        {
            type:"string",
            name:"relatedField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"relatedDataSource",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HeaderSpan",
    fields:[
        {
            name:"align",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"fields",
            type:"string",
            validators:[
            ]
        },
        {
            name:"headerBaseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"headerTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"headerTitleStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"height",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"name",
            type:"identifier",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"spans",
            type:"HeaderSpan",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"valign",
            type:"valignEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"HiddenItem",
    methods:[
        {
            action:false,
            inapplicable:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    isServerDS:true,
    ID:"HiddenItem",
    fields:[
        {
            name:"title",
            inapplicable:true,
            title:"Title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showTitle",
            inapplicable:true,
            title:"Show Title",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"titleOrientation",
            inapplicable:true,
            title:"Title Orientation",
            type:"directionEnum",
            prompt:"Position item title to the left or right of text",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            inapplicable:true,
            title:"Title Alignment",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"colSpan",
            inapplicable:true,
            title:"Column Span",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"rowSpan",
            inapplicable:true,
            title:"Row Span",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"startRow",
            inapplicable:true,
            title:"Start Row",
            type:"boolean",
            prompt:"Check to position this item on a new row",
            validators:[
            ]
        },
        {
            name:"endRow",
            inapplicable:true,
            title:"End Row",
            type:"boolean",
            prompt:"Check to start a new row after this item",
            validators:[
            ]
        },
        {
            name:"visible",
            inapplicable:true,
            title:"Visible",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            validators:[
            ],
            hint:"JS expression",
            name:"showIf",
            inapplicable:true,
            title:"Show If",
            type:"expression",
            prompt:"JS expression - item will be visible if this evaluates to true"
        },
        {
            name:"disabled",
            inapplicable:true,
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            inapplicable:true,
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"prompt",
            inapplicable:true,
            title:"Prompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"hint",
            inapplicable:true,
            title:"Hint",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"showHint",
            inapplicable:true,
            title:"Show Hint",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"width",
            inapplicable:true,
            title:"Width",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"height",
            inapplicable:true,
            title:"Height",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"align",
            inapplicable:true,
            title:"Text Alignment",
            type:"alignEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"HiddenPalette",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:false,
    ID:"HiddenPalette",
    fields:[
        {
            multiple:true,
            name:"data",
            type:"PaletteNode",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"HideComponentTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HideComponentTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"ShowHideTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShowHideTask",
    fields:[
        {
            name:"targetTabName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetFieldName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetSectionName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetSectionTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"hide",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showRecursively",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"scrollIntoView",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"moveFocusToTarget",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ShowHideTask",
    Constructor:"HideTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"HideTask",
    fields:[
        {
            inapplicable:true,
            name:"hide",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Object",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Hilite",
    fields:[
        {
            name:"id",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fieldName",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"disabled",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"canEdit",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"criteria",
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"textColor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"backgroundColor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"cssText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"icon",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"StretchImg",
    methods:[
        {
            basic:true,
            name:"click"
        },
        {
            basic:true,
            name:"doubleClick"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StatefulCanvas",
    isServerDS:true,
    ID:"StretchImg",
    fields:[
        {
            name:"vertical",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"capSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"src",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"hSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"vSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"imageType",
            type:"imageTypeEnum",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"autoCalculateSizes",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"cacheImageSizes",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"StretchImgButton",
    methods:[
        {
            action:false,
            basic:true,
            name:"click",
            title:"Click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StretchImg",
    isServerDS:true,
    ID:"StretchImgButton",
    fields:[
        {
            name:"labelHPad",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"labelVPad",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"labelLengthPad",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"labelBreadthPad",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"wrap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hiliteAccessKey",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"action",
            editorType:"ActionMenuItem",
            hidden:true,
            type:"Action",
            validators:[
            ]
        },
        {
            name:"layoutAlign",
            basic:true,
            editorType:"LayoutAlignItem",
            type:"anyAlignEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"IButton",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StretchImgButton",
    isServerDS:true,
    ID:"IButton",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        UserTypeFieldMap:{
            ID:"UserTypeFieldMap",
            serverConstructor:"com.isomorphic.datasource.UserTypeFieldMap",
            type:"DataSource",
            fields:{
                userType:{
                    name:"userType",
                    type:"string"
                }
            }
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IDAOperation",
    fields:[
        {
            name:"ID",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dataSource",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dataSources",
            type:"string",
            validators:[
            ]
        },
        {
            name:"filterType",
            valueMap:[
                "basic",
                "windowed",
                "local"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"type",
            valueMap:[
                "summary",
                "filter",
                "insert",
                "update",
                "replace",
                "delete",
                "custom"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"resultSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"batchSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"constraints",
            type:"UserTypeFieldMap",
            validators:[
            ]
        },
        {
            name:"outputs",
            type:"UserTypeFieldMap",
            validators:[
            ]
        },
        {
            name:"replyCallback",
            type:"eventHandler",
            validators:[
            ]
        },
        {
            name:"loadDataOnDemand",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"prompt",
            type:"HTMLString",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IDAPage",
    fields:[
        {
            name:"ID",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"operations",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"defaultComponents",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"defaultOperations",
            type:"expression",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        Requirement:{
            ID:"Requirement",
            fields:{
                type:{
                    name:"type",
                    type:"string"
                },
                value:{
                    name:"value",
                    type:"string"
                }
            }
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IDAUserType",
    fields:[
        {
            name:"ID",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"requirements",
            type:"Requirement",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Button",
    Constructor:"MenuButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MenuButton",
    fields:[
        {
            name:"menu",
            type:"Menu",
            validators:[
            ]
        },
        {
            name:"menuAnimationEffect",
            type:"string",
            visibility:"animation",
            validators:[
            ]
        },
        {
            name:"showMenuButtonImage",
            title:"Show Menu Icon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"menuButtonImage",
            title:"Menu Icon",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"menuButtonImageUp",
            title:"Menu Icon Up",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"showMenuBelow",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showMenuOnRollOver",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"MenuButton",
    Constructor:"IMenuButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IMenuButton",
    fields:[
        {
            name:"menu",
            type:"Menu",
            validators:[
            ]
        },
        {
            name:"menuAnimationEffect",
            type:"string",
            visibility:"animation",
            validators:[
            ]
        },
        {
            name:"showMenuButtonImage",
            title:"Show Menu Icon",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"menuButtonImage",
            title:"Menu Icon",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"menuButtonImageUp",
            title:"Menu Icon Up",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"showMenuBelow",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showMenuOnRollOver",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"RibbonButton",
    methods:[
        {
            action:false,
            basic:true,
            name:"click",
            title:"Click"
        },
        {
            action:false,
            basic:true,
            name:"iconClick",
            title:"Icon Click"
        },
        {
            action:false,
            basic:true,
            name:"menuIconClick",
            title:"Menu-icon Click"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "button",
        "icon",
        "sizing",
        "menu"
    ],
    inheritsFrom:"Button",
    isServerDS:true,
    ID:"RibbonButton",
    fields:[
        {
            name:"icon",
            basic:true,
            editorType:"ImageChooserItem",
            title:"Icon",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"largeIcon",
            basic:true,
            editorType:"ImageChooserItem",
            title:"Large Icon",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"largeIconSize",
            basic:true,
            type:"int",
            validators:[
            ]
        },
        {
            name:"rowSpan",
            basic:true,
            type:"int",
            validators:[
            ]
        },
        {
            name:"vertical",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showButtonTitle",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showIcon",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"menuIconSrc",
            basic:true,
            editorType:"ImageChooserItem",
            title:"Menu Icon",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"menuIconHeight",
            basic:true,
            type:"int",
            validators:[
            ]
        },
        {
            name:"menuIconWidth",
            basic:true,
            type:"int",
            validators:[
            ]
        },
        {
            name:"showMenuIcon",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showMenuOnClick",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"menu",
            basic:true,
            title:"Menu",
            type:"Menu",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"orientation",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconAlign",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconOrientation",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"RibbonButton",
    Constructor:"IconButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IconButton",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ImgButton",
    methods:[
        {
            basic:true,
            "default":true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Img",
    isServerDS:true,
    ID:"ImgButton",
    fields:[
        {
            name:"labelHPad",
            type:"number",
            validators:[
            ]
        },
        {
            name:"labelVPad",
            type:"number",
            validators:[
            ]
        },
        {
            name:"hiliteAccessKey",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"action",
            editorType:"ActionMenuItem",
            hidden:true,
            type:"Action",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"IconImgButton",
    methods:[
        {
            basic:true,
            "default":true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"ImgButton",
    isServerDS:true,
    ID:"IconImgButton",
    fields:[
        {
            name:"src",
            basic:true,
            editorType:"StatefulImageChooserItem",
            title:"Image",
            type:"object",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"icon",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconAlign",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconOrientation",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"iconSpacing",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showDisabledIcon",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showRollOverIcon",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showDownIcon",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showSelectedIcon",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showFocusedIcon",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"RibbonButton",
    Constructor:"RibbonMenuButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RibbonMenuButton",
    fields:[
        {
            name:"showMenuIcon",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"RibbonMenuButton",
    Constructor:"IconMenuButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IconMenuButton",
    fields:[
        {
            name:"showMenuIcon",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ImageChooserItem",
    methods:[
        {
            basic:true,
            name:"pickerCancelled"
        },
        {
            basic:true,
            name:"pickerImageSelected"
        },
        {
            basic:true,
            name:"getImageProperties"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"ImageChooserItem",
    fields:[
        {
            name:"pickerTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showActionIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHeaderIcons",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ImagePicker",
    methods:[
        {
            basic:true,
            name:"pickerCancelled"
        },
        {
            basic:true,
            name:"pickerImageSelected"
        },
        {
            basic:true,
            name:"getImageProperties"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"VLayout",
    isServerDS:true,
    ID:"ImagePicker",
    fields:[
        {
            name:"showActionIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"actionIconsTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showHeaderIcons",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"headerIconsTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"tipText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"thumbnailSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"thumbnailWidth",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"thumbnailHeight",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ImgProperties",
    fields:[
        {
            name:"src",
            type:"url",
            validators:[
            ]
        },
        {
            name:"width",
            type:"number",
            validators:[
            ]
        },
        {
            name:"height",
            type:"number",
            validators:[
            ]
        },
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"extraStuff",
            type:"string",
            validators:[
            ]
        },
        {
            name:"imgDir",
            type:"url",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"Label",
    methods:[
        {
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "contents",
        "sizing",
        "appearance"
    ],
    inheritsFrom:"Button",
    isServerDS:true,
    ID:"Label",
    fields:[
        {
            name:"contents",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"dynamicContents",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"align",
            basic:true,
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"valign",
            basic:true,
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"autoFit",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"padding",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"wrap",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"title",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Label",
    Constructor:"SectionHeader",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SectionHeader",
    fields:[
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"showClippedTitleOnHover",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SectionHeader",
    Constructor:"ImgSectionHeader",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ImgSectionHeader",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"StretchImg",
    Constructor:"ImgSplitbar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ImgSplitbar",
    fields:[
        {
            name:"canCollapse",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDrag",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"src",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"StretchImgButton",
    Constructor:"ImgTab",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ImgTab",
    fields:[
        {
            name:"pane",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"FormItem",
    Constructor:"InlineFormItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"InlineFormItem",
    fields:[
        {
            name:"formProperties",
            propertiesOnly:"true",
            type:"DynamicForm",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Window",
    Constructor:"InlineWindow",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"InlineWindow",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        FileSandbox:{
            ID:"FileSandbox",
            fields:{
                ID:{
                    name:"ID",
                    type:"identifier"
                }
            }
        }
    },
    componentSchema:true,
    Constructor:"InstantDataApp",
    allowAdvancedCriteria:true,
    inheritsFrom:"Application",
    isServerDS:true,
    ID:"InstantDataApp",
    fields:[
        {
            name:"ID",
            type:"identifier",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"dataSources",
            type:"identifier",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"userTypes",
            type:"IDAUserType",
            uniqueProperty:"ID",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"operations",
            type:"IDAOperation",
            uniqueProperty:"ID",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"components",
            propertiesOnly:"true",
            type:"IDAComponent",
            uniqueProperty:"ID",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"pages",
            type:"IDAPage",
            uniqueProperty:"ID",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"fileSandboxes",
            type:"FileSandbox",
            uniqueProperty:"ID",
            validators:[
            ]
        },
        {
            name:"height",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"width",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"top",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"left",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"marginHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"marginWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"defaultPrompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"actionURL",
            type:"URL",
            validators:[
            ]
        },
        {
            name:"commType",
            type:"string",
            validators:[
            ]
        },
        {
            name:"definedOperationsOnly",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultWindowSettings",
            type:"string",
            validators:[
            ]
        },
        {
            name:"defaultWindowHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"defaultWindowWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"defaultWindowName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"appImplementer",
            type:"string",
            validators:[
            ]
        },
        {
            name:"appAssembly",
            type:"string",
            validators:[
            ]
        },
        {
            name:"appVersion",
            type:"float",
            validators:[
            ]
        },
        {
            name:"makeHeader",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"headerConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"headerDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"makeInstructions",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"instructionsConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"instructionsDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"makeToolbar",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"toolbarConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"toolbarDefaults",
            propertiesOnly:"true",
            type:"Toolbar",
            validators:[
            ]
        },
        {
            name:"buttonWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"filterConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"filterDefaults",
            propertiesOnly:"true",
            type:"DynamicForm",
            validators:[
            ]
        },
        {
            name:"emptyFilterMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"summaryConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"summaryDefaults",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"treeConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"treeDefaults",
            propertiesOnly:"true",
            type:"TreeGrid",
            validators:[
            ]
        },
        {
            name:"editorConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"editorDefaults",
            propertiesOnly:"true",
            type:"DynamicForm",
            validators:[
            ]
        },
        {
            name:"fieldIdProperty",
            type:"string",
            validators:[
            ]
        },
        {
            name:"viewerConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"viewerDefaults",
            propertiesOnly:"true",
            type:"DetailViewer",
            validators:[
            ]
        },
        {
            name:"graphConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"graphDefaults",
            propertiesOnly:"true",
            type:"BarGraph",
            validators:[
            ]
        },
        {
            name:"batchEditorConstructor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"batchEditorDefaults",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"componentSpacerHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"spacerConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"spacerDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"initialAppLoad",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TextItem",
    Constructor:"IntegerItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"IntegerItem",
    fields:[
        {
            name:"defaultValue",
            basic:true,
            title:"Default Value",
            type:"integer",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"integerRange",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IntegerRangeValidator",
    fields:[
        {
            type:"integer",
            name:"min",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"max",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"exclusive",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isBoolean",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsBooleanValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isFloat",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsFloatValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isFunction",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsFunctionValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isInteger",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsIntegerValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isOneOf",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsOneOfValidator",
    fields:[
        {
            multiple:"true",
            type:"string",
            name:"list",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isString",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsStringValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"isUnique",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"IsUniqueValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"JS",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"JSExpression",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    operationBindings:[
        {
            operationType:"fetch"
        }
    ],
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"JVMClassTreeDS",
    fields:[
        {
            name:"name",
            validators:[
            ]
        },
        {
            name:"path",
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"parentID",
            hidden:true,
            foreignKey:"JVMClassTreeDS.path",
            validators:[
            ]
        },
        {
            name:"isFolder",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGridField",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"LGField",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        MultipleAppearanceType:{
            ID:"MultipleAppearanceType",
            valueMap:[
                "picklist",
                "grid"
            ]
        }
    },
    componentSchema:true,
    Constructor:"SelectItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "Basics",
        "FormLayout",
        "ValueMap",
        "Appearance"
    ],
    inheritsFrom:"FormItem",
    isServerDS:true,
    ID:"SelectItem",
    fields:[
        {
            name:"multiple",
            title:"Select Multiple",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"multipleAppearance",
            type:"MultipleAppearanceType",
            validators:[
            ]
        },
        {
            name:"addUnknownValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"valueMap",
            basic:true,
            readOnlyIfOptionDataSource:"true",
            title:"Value Map",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"showOver",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHintInField",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pickerIconWidth",
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickerIconHeight",
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickerIconSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"escapeHTML",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"optionDataSource",
            type:"DataSource",
            validators:[
            ]
        },
        {
            name:"valueField",
            type:"fieldName",
            validators:[
            ]
        },
        {
            name:"displayField",
            type:"fieldName",
            validators:[
            ]
        },
        {
            name:"pickListHeight",
            type:"number",
            visibility:"internal",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"pickListFields",
            type:"DropDownField",
            validators:[
            ]
        },
        {
            name:"pickListCriteria",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"filterLocally",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pickListBaseStyle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"animatePickList",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showOptionsFromDataSource",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"optionFilterContext",
            type:"RPCRequest",
            validators:[
            ]
        },
        {
            name:"pickListProperties",
            propertiesOnly:"true",
            type:"ListGrid",
            validators:[
            ]
        },
        {
            name:"optionCriteria",
            basic:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"specialValues",
            hidden:true,
            type:"ValueMap",
            validators:[
            ]
        },
        {
            name:"allowEmptyValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showPickerIcon",
            validators:[
            ]
        },
        {
            name:"hiliteOnFocus",
            hidden:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pickButtonWidth",
            hidden:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickButtonHeight",
            hidden:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"pickButtonSrc",
            editorType:"ImageChooserItem",
            hidden:true,
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"hiliteColor",
            hidden:true,
            type:"color",
            validators:[
            ]
        },
        {
            name:"hiliteTextColor",
            hidden:true,
            type:"color",
            validators:[
            ]
        },
        {
            name:"defaultToFirstOption",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hint",
            type:"HTMLString",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SelectItem",
    Constructor:"LayoutAlignItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"LayoutAlignItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"StretchImg",
    Constructor:"Splitbar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Splitbar",
    fields:[
        {
            name:"canCollapse",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCollapseOnTap",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDrag",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"capSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"gripImgSuffix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"src",
            editorType:"ImageChooserItem",
            title:"Image",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"hSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"vSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"showGrip",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showClosedGrip",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDownGrip",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRollOverGrip",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hResizeCursor",
            type:"cursorEnum",
            validators:[
            ]
        },
        {
            name:"vResizeCursor",
            type:"cursorEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Splitbar",
    Constructor:"Snapbar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Snapbar",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        resizeEnum:{
            ID:"resizeEnum",
            inheritsFrom:"enum",
            valueMap:[
                "before",
                "after"
            ]
        }
    },
    componentSchema:true,
    Constructor:"LayoutResizeBar",
    allowAdvancedCriteria:true,
    inheritsFrom:"Snapbar",
    isServerDS:true,
    ID:"LayoutResizeBar",
    fields:[
        {
            name:"resizeDirection",
            basic:true,
            title:"Resize Before or After",
            type:"resizeEnum",
            defaultValue:"before",
            validators:[
            ]
        },
        {
            name:"canCollapse",
            basic:true,
            title:"Can collapse Target Member",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"title",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"enableWhen",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"visibleWhen",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"lengthRange",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"LengthRangeValidator",
    fields:[
        {
            type:"integer",
            name:"min",
            validators:[
            ]
        },
        {
            type:"integer",
            name:"max",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGrid",
    Constructor:"LineEditor",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"LineEditor",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Gradient",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"LinearGradient",
    fields:[
        {
            name:"x1",
            type:"string",
            validators:[
            ]
        },
        {
            name:"y1",
            type:"string",
            validators:[
            ]
        },
        {
            name:"x2",
            type:"string",
            validators:[
            ]
        },
        {
            name:"y2",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"StaticTextItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    substituteClasses:"BlurbItem, TextItem, TextAreaItem",
    isServerDS:true,
    ID:"StaticTextItem",
    fields:[
        {
            name:"wrap",
            title:"Allow text wrap",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"clipValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"string",
            validators:[
            ]
        },
        {
            name:"outputAsHTML",
            title:"Output as HTML",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"disabled",
            inapplicable:true,
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"redrawOnChange",
            inapplicable:true,
            title:"Redraw On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            inapplicable:true,
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"escapeHTML",
            basic:true,
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"LinkItem",
    methods:[
        {
            basic:true,
            "default":true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StaticTextItem",
    isServerDS:true,
    ID:"LinkItem",
    fields:[
        {
            validators:[
            ],
            name:"defaultValue",
            basic:true,
            title:"URL",
            type:"string",
            xmlAttribute:true,
            group:"basics"
        },
        {
            name:"linkTitle",
            basic:true,
            title:"Link Text",
            type:"string",
            validators:[
            ],
            group:"basics"
        },
        {
            name:"target",
            valueMap:{
                "":"Current Window",
                _blank:"New Tab",
                javascript:"JavaScript Handler"
            },
            title:"Open in (target)",
            type:"string",
            validators:[
            ],
            group:"basics"
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"List",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"VLayout",
    Constructor:"SectionStack",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SectionStack",
    fields:[
        {
            name:"sectionHeaderClass",
            type:"string",
            validators:[
            ]
        },
        {
            name:"headerHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"canTabToHeaders",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canResizeSections",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCollapseAll",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"scrollSectionIntoView",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"sections",
            propertiesOnly:"true",
            type:"SectionStackSection",
            validators:[
            ]
        },
        {
            name:"visibilityMode",
            valueMap:[
                "mutex",
                "multiple"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"itemEndIndent",
            type:"number",
            validators:[
            ]
        },
        {
            name:"itemIndent",
            type:"number",
            validators:[
            ]
        },
        {
            name:"itemStartIndent",
            type:"number",
            validators:[
            ]
        },
        {
            name:"showExpandControls",
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"members",
            validators:[
            ]
        },
        {
            name:"animateSections",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCloseSections",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"closeSectionIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"closeSectionIconSize",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SectionStack",
    Constructor:"ListBar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ListBar",
    fields:[
        {
            multiple:true,
            name:"groups",
            propertiesOnly:"true",
            type:"ListBarGroup",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SectionStackSection",
    fields:[
        {
            name:"ID",
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoID",
            hidden:true,
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoShow",
            type:"boolean",
            visibility:"hidden",
            validators:[
            ]
        },
        {
            name:"expanded",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hidden",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCollapse",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"resizeable",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showHeader",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showClippedTitleOnHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"controls",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"canClose",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"closeIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"closeIconSize",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SectionStackSection",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ListBarGroup",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGrid",
    Constructor:"ListPalette",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ListPalette",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGrid",
    Constructor:"ListGrid",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ListViewer",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"LogOutTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"LogOutTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Dialog",
    Constructor:"LoginDialog",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"LoginDialog",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Mail",
    fields:[
        {
            type:"URL",
            name:"templateFile",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"multiple",
            validators:[
            ]
        },
        {
            type:"string",
            name:"to",
            validators:[
            ]
        },
        {
            type:"string",
            name:"from",
            validators:[
            ]
        },
        {
            type:"string",
            name:"replyTo",
            validators:[
            ]
        },
        {
            type:"string",
            name:"cc",
            validators:[
            ]
        },
        {
            type:"string",
            name:"bcc",
            validators:[
            ]
        },
        {
            type:"string",
            name:"subject",
            validators:[
            ]
        },
        {
            type:"string",
            name:"host",
            validators:[
            ]
        },
        {
            type:"string",
            name:"port",
            validators:[
            ]
        },
        {
            type:"string",
            name:"auth",
            validators:[
            ]
        },
        {
            type:"string",
            name:"user",
            validators:[
            ]
        },
        {
            type:"string",
            name:"password",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"mask",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"MaskValidator",
    fields:[
        {
            type:"string",
            name:"mask",
            validators:[
            ]
        },
        {
            type:"string",
            name:"transformTo",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"MasterDetail",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Related Data",
            params:[
                {
                    type:"ListGridRecord"
                }
            ]
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"VLayout",
    isServerDS:true,
    ID:"MasterDetail",
    fields:[
        {
            name:"detailDataSource",
            type:"DataSource",
            validators:[
            ]
        },
        {
            idAllowed:true,
            name:"dataSource",
            hidden:false,
            inapplicable:false,
            type:"DataSource",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"matchesField",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"MatchesFieldValidator",
    fields:[
        {
            type:"string",
            name:"otherField",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TextItem",
    Constructor:"MeasureItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MeasureItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    showSuperClassActions:false,
    componentSchema:true,
    Constructor:"Menu",
    allowAdvancedCriteria:true,
    inheritsFrom:"ListGrid",
    isServerDS:true,
    ID:"Menu",
    fields:[
        {
            multiple:true,
            name:"data",
            type:"MenuItem",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            type:"MenuItem",
            validators:[
            ]
        },
        {
            name:"useKeys",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showKeys",
            basic:true,
            title:"Show Shortcut Key Column",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showIcons",
            basic:true,
            title:"Show Icon Column",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showSubmenus",
            title:"Show Submenu Arrows",
            type:"boolean",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"canSelectParentItems",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showEmptyMessage",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"cellSpacing",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"cellPadding",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"iconWidth",
            type:"positiveInteger",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"iconHeight",
            type:"positiveInteger",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"defaultWidth",
            basic:true,
            title:"Default Width",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"showAnimationEffect",
            type:"string",
            visibility:"animation",
            validators:[
            ]
        },
        {
            name:"autoSetDynamicItems",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"submenuImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"submenuDisabledImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"checkmarkImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"checkmarkDisabledImage",
            type:"imageProperty",
            validators:[
            ]
        },
        {
            name:"autoDismiss",
            type:"boolean",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"initialCriteria",
            type:"AdvancedCriteria",
            advanced:true,
            validators:[
            ]
        },
        {
            idAllowed:true,
            name:"dataSource",
            hidden:false,
            type:"DataSource",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"baseStyle",
            type:"cssClass",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"bodyStyleName",
            type:"cssClass",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"cellHeight",
            type:"positiveInteger",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"canEdit",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"editByCell",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"saveByCell",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showFilterEditor",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            basic:false,
            name:"editEvent",
            validators:[
            ]
        },
        {
            basic:false,
            name:"selectionType",
            validators:[
            ]
        },
        {
            name:"emptyMessage",
            basic:false,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"loadingDataMessage",
            basic:false,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"canSort",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canDragRecordsOut",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canAcceptDroppedRecords",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canReorderRecords",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragDataAction",
            basic:false,
            type:"enum",
            validators:[
            ]
        },
        {
            name:"canGroupBy",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoFitData",
            basic:false,
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoFitMaxRecords",
            basic:false,
            type:"integer",
            validators:[
            ]
        },
        {
            name:"autoFetchData",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canRemoveRecords",
            basic:false,
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"dataProperties",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"dataPageSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"fields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"defaultFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"emptyCellValue",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"minHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"fixedFieldWidths",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"fastCellUpdates",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showDetailFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"drawAheadRatio",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"fixedRecordHeights",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canHover",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showHover",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoSaveEdits",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"modalEditing",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"stopOnErrors",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"waitForSave",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"leaveScrollbarGap",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"titleField",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"minFieldWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"addNewBeforeEditing",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"rowEndEditAction",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"listEndEditAction",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"enterKeyEditAction",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"escapeKeyEditAction",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"generateClickOnSpace",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"generateClickOnEnter",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"generateDoubleClickOnSpace",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"generateDoubleClickOnEnter",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"wrapCells",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showAllRecords",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"filterEditorHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"filterByCell",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"filterOnKeypress",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"confirmCancelEditing",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"cancelEditingConfirmationMessage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"validateOnChange",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"validateByCell",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"neverValidate",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canDragSelect",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"selectOnEdit",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"recordEditProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerButtonConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sorterConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showHeader",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showHeaderContextMenu",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerBackgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerBarStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerBaseStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerSpans",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerSpanHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerTitleStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"bodyBackgroundColor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"recordBaseStyleProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"recordCustomStyleProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"alternateRecordStyles",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"alternateRecordFrequency",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerDefaults",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerButtonDefaults",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerButtonProperties",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sorterDefaults",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sorterProperties",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"printHeaderStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"printCellStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showRollOver",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hoverByCell",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showHiliteInCells",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"selectionAppearance",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"emptyMessageStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"singleCellValueProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"isSeparatorProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"arrowKeyAction",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"loadingMessage",
            validators:[
            ]
        },
        {
            name:"loadingDataMessageStyle",
            inapplicable:true,
            type:"cssClass",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sortField",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sortFieldNum",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sortDirection",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showSortArrow",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showSortNumerals",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"dragTrackerMode",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canReorderFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canResizeFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"resizeFieldsInRealTime",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canFreezeFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"freezeFieldText",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"unfreezeFieldText",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"groupByText",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"groupIconSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"groupIndentSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"groupByMaxRecords",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sortAscendingImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"sortDescendingImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"trackerImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"selectionProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"fieldIdProperty",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"longTextEditorThreshold",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"longTextEditorType",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"timeFormatter",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"dateFormatter",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"dateInputFormat",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"bodyOverflow",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFitMaxHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFitMaxColumns",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFitMaxWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFitFieldWidths",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFitWidthApproach",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"editFailedBaseStyle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"editFailedCSSText",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"editPendingCSSText",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"editOnFocus",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"confirmDiscardEdits",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"discardEditsSaveButtonTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"confirmDiscardEditsMessage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"imageSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueIconWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueIconHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueIconSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueIconLeftPadding",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueIconRightPadding",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"booleanTrueImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"booleanFalseImage",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"booleanImageWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"booleanImageHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hilites",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIcons",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIconSize",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIconWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIconHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIconLeftPadding",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIconRightPadding",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"hiliteIconPosition",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFetchDisplayMap",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"fetchDelay",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"scrollRedrawDelay",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"saveLocally",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showTreeColumnPicker",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"shrinkForFreeze",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"animateRemoveRecord",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canPickFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canAddFormulaFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canAddSummaryFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showHeaderMenuButton",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canExpandRecords",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"animateRemoveTime",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"animateRemoveSpeed",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerMenuButtonIconWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerMenuButtonIconHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerMenuButtonWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"headerMenuButtonHeight",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"checkboxFieldImageWidth",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"checkboxFieldImageHeight",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"Toolbar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Toolbar",
    fields:[
        {
            name:"vertical",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canReorderItems",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canResizeItems",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"buttonConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"buttonDefaults",
            propertiesOnly:"true",
            type:"Button",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"buttons",
            propertiesOnly:"true",
            type:"Button",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Toolbar",
    Constructor:"MenuBar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MenuBar",
    fields:[
        {
            multiple:true,
            name:"menus",
            propertiesOnly:"true",
            type:"Menu",
            validators:[
            ]
        },
        {
            name:"tabIndex",
            type:"number",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SelectItem",
    Constructor:"MenuChooserItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MenuChooserItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    types:{
        key:{
            ID:"key",
            fields:{
                ctrlKey:{
                    name:"ctrlKey",
                    type:"boolean"
                },
                shiftKey:{
                    name:"shiftKey",
                    type:"boolean"
                },
                metaKey:{
                    name:"metaKey",
                    type:"boolean"
                },
                altKey:{
                    name:"altKey",
                    type:"boolean"
                }
            }
        }
    },
    autoIdField:"name",
    componentSchema:true,
    methods:[
        {
            basic:true,
            name:"click",
            description:"Fires when this menu item is clicked",
            params:[
                {
                    name:"target",
                    type:"Canvas"
                },
                {
                    name:"item",
                    type:"MenuItem"
                },
                {
                    name:"menu",
                    type:"Menu"
                }
            ]
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"ListGridRecord",
    isServerDS:true,
    showLocalFieldsOnly:true,
    ID:"MenuItem",
    fields:[
        {
            name:"autoName",
            hidden:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"submenu",
            type:"Menu",
            validators:[
            ]
        },
        {
            name:"enabled",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"checked",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            basic:true,
            name:"isSeparator",
            validators:[
            ]
        },
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"iconWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"iconHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"keys",
            type:"key",
            validators:[
            ]
        },
        {
            name:"keyTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"enableIf",
            type:"expression",
            validators:[
            ]
        },
        {
            name:"checkIf",
            type:"expression",
            validators:[
            ]
        },
        {
            name:"dynamicTitle",
            type:"expression",
            validators:[
            ]
        },
        {
            name:"dynamicIcon",
            type:"expression",
            validators:[
            ]
        },
        {
            name:"action",
            editorType:"ActionMenuItem",
            hidden:true,
            type:"Action",
            validators:[
            ]
        },
        {
            name:"canSelectParent",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"embeddedComponent",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"embeddedComponentFields",
            type:"string",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"visibleWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Validator",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"Rule",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"message",
    allowAdvancedCriteria:true,
    inheritsFrom:"Rule",
    isServerDS:true,
    addGlobalId:"false",
    ID:"MessageRule",
    fields:[
        {
            type:"string",
            name:"message",
            validators:[
            ]
        },
        {
            type:"string",
            name:"severity",
            validators:[
            ]
        },
        {
            type:"string",
            name:"displayMode",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"message",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"MessageValidator",
    fields:[
        {
            type:"string",
            name:"message",
            validators:[
            ]
        },
        {
            type:"string",
            name:"severity",
            validators:[
            ]
        },
        {
            type:"string",
            name:"displayMode",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Method",
    fields:[
        {
            type:"string",
            name:"name",
            validators:[
            ]
        },
        {
            type:"string",
            name:"args",
            validators:[
            ]
        },
        {
            type:"string",
            name:"language",
            validators:[
            ]
        },
        {
            type:"string",
            name:"script",
            validators:[
            ]
        },
        {
            type:"string",
            name:"scriptImport",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MethodDeclaration",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"description",
            type:"string",
            validators:[
            ]
        },
        {
            name:"action",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"params",
            type:"ParamsDeclaration",
            validators:[
            ]
        },
        {
            name:"basic",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"default",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"tip",
            type:"string",
            validators:[
            ]
        },
        {
            name:"inapplicable",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MetricSettings",
    fields:[
        {
            name:"axisStartValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"chartType",
            valueMap:[
                "Area",
                "Column",
                "Bar",
                "Line",
                "Radar",
                "Pie",
                "Doughnut",
                "Histogram"
            ],
            basic:true,
            type:"ChartType",
            validators:[
            ]
        },
        {
            name:"stacked",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"filled",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"multiFacet",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showValueAxisLabel",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"decimalPrecision",
            title:"Axis Label Precision",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"valueTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showDataValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDataPoints",
            title:"Draw Points for Values",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dataPointSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"dataColors",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showShadows",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showValueOnHover",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"fixedFacetValue",
            type:"number",
            validators:[
            ]
        },
        {
            name:"legendLabel",
            type:"string",
            validators:[
            ]
        },
        {
            name:"useLogGradations",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"logScale",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"logBase",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"logGradations",
            hidden:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"matchGradiations",
            type:"string",
            validators:[
            ]
        },
        {
            name:"minDataSpreadPercent",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"proportional",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"proportionalAxisLabel",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showAxis",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showAxisLine",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"xAxisEndValue",
            type:"float",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"MockDataSource",
    allowAdvancedCriteria:true,
    inheritsFrom:"DataSource",
    isServerDS:true,
    addGlobalId:false,
    ID:"MockDataSource",
    fields:[
        {
            name:"mockData",
            type:"string",
            validators:[
            ]
        },
        {
            name:"mockDataFormat",
            type:"string",
            validators:[
            ]
        },
        {
            name:"mockDataType",
            type:"string",
            validators:[
            ]
        },
        {
            name:"mockDataPrimaryKey",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fromServer",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"fieldNamingConvention",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"MockupContainer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MockupContainer",
    fields:[
        {
            multiple:true,
            name:"dataSources",
            propertiesOnly:"true",
            type:"DataSource",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"components",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"MockupElement",
    methods:[
        {
            basic:true,
            name:"click"
        },
        {
            basic:true,
            name:"doubleClick"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"Img",
    isServerDS:true,
    ID:"MockupElement",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"controlName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"imageType",
            basic:true,
            type:"imageTypeEnum",
            validators:[
            ]
        },
        {
            name:"size",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"imageHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"imageWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"activeAreaHTML",
            type:"string",
            validators:[
            ]
        },
        {
            name:"src",
            basic:true,
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"title",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoFit",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Window",
    Constructor:"ModalWindow",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ModalWindow",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CanvasItem",
    Constructor:"RelationItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RelationItem",
    fields:[
        {
            name:"showEditButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"editButtonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showRemoveButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"removeButtonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"RelationItem",
    Constructor:"MultiFileItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"MultiFileItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"MultiView",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/filter.png",
            name:"filterData",
            title:"Filter Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchRelatedData",
            title:"Fetch Related Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/remove.png",
            name:"removeSelectedData",
            title:"Remove Selected Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/edit.png",
            name:"startEditing",
            title:"Start Editing"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/add.png",
            name:"startEditingNew",
            title:"Start Editing New"
        },
        {
            basic:true,
            name:"recordClick"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "editMode",
        "cellStyling",
        "emptyMessage",
        "sizing",
        "selection",
        "sorting",
        "editing"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"MultiView",
    fields:[
        {
            idAllowed:true,
            name:"dataSource",
            type:"DataSource",
            validators:[
            ]
        },
        {
            name:"views",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"FormItem",
    Constructor:"NativeCheckboxItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"NativeCheckboxItem",
    fields:[
        {
            name:"showLabel",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGridRecord",
    autoIdField:"id",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"NavItem",
    fields:[
        {
            name:"id",
            basic:true,
            title:"Identifier",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoId",
            hidden:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            basic:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"isHeader",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"isSeparator",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"pane",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"items",
            type:"NavItem",
            validators:[
            ]
        },
        {
            name:"linkText",
            inapplicable:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SplitPane",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/forward.png",
            name:"navigateListPane"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/forward.png",
            name:"navigateDetailPane"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"VLayout",
    isServerDS:true,
    ID:"SplitPane",
    fields:[
        {
            name:"navigationPane",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"navigationTitle",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"navigationPaneWidth",
            title:"Nav Pane Width",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"listPane",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"listTitle",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"detailPane",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"detailTitle",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"autoNavigate",
            hidden:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"listPaneTitleTemplate",
            type:"string",
            validators:[
            ]
        },
        {
            name:"detailPaneTitleTemplate",
            type:"string",
            validators:[
            ]
        },
        {
            name:"addHistoryEntries",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"notifyAfterNavigationClick",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showLeftButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRightButton",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showNavigationBar",
            basic:true,
            type:"boolean",
            validators:[
            ],
            allowEmptyValue:"true"
        },
        {
            name:"showDetailToolStrip",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showListToolStrip",
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            idAllowed:true,
            multiple:true,
            name:"detailToolButtons",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"currentPane",
            hidden:true,
            skipSerialization:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"pageOrientation",
            hidden:true,
            skipSerialization:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"align",
            hidden:true,
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"defaultLayoutAlign",
            hidden:true,
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"layoutMargin",
            hidden:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"membersMargin",
            hidden:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"reverseOrder",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"NavPanel",
    methods:[
        {
            action:true,
            inapplicable:true,
            name:"navigateListPane"
        },
        {
            action:true,
            inapplicable:true,
            name:"navigateDetailPane"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"SplitPane",
    isServerDS:true,
    ID:"NavPanel",
    fields:[
        {
            name:"headerStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"navItemBaseStyle",
            type:"CSSStyleName",
            validators:[
            ]
        },
        {
            name:"isTree",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"navItems",
            type:"NavItem",
            validators:[
            ]
        },
        {
            name:"defaultToFirstItem",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoOpenItems",
            basic:true,
            showNullAsTrue:"true",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"currentItemId",
            basic:true,
            editorType:"NavItemPicker",
            title:"Initial NavItem",
            type:"string",
            validators:[
            ]
        },
        {
            name:"currentItem",
            hidden:true,
            skipSerialization:true,
            type:"NavItem",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"navBeforeMembers",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"navAfterMembers",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"detailPane",
            inapplicable:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"detailTitle",
            validators:[
            ]
        },
        {
            name:"listPane",
            inapplicable:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"listTitle",
            validators:[
            ]
        },
        {
            name:"navigationPane",
            inapplicable:true,
            type:"Canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"autoNavigate",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"listPaneTitleTemplate",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"detailPaneTitleTemplate",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"NavigateDetailPaneTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"NavigateDetailPaneTask",
    fields:[
        {
            name:"title",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"NavigateListPaneTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"NavigateListPaneTask",
    fields:[
        {
            name:"title",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"NavigateSplitPaneTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"NavigateSplitPaneTask",
    fields:[
        {
            name:"targetPane",
            valueMap:[
                "navigation",
                "list",
                "detail"
            ],
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            type:"text",
            validators:[
            ]
        },
        {
            name:"showRecursively",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        type:{
            ID:"DSProtocol",
            inheritsFrom:"enum",
            valueMap:{
                value:[
                    "getParams",
                    "postParams",
                    "postXML",
                    "soap",
                    "postMessage"
                ]
            }
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"OperationBinding",
    fields:[
        {
            type:"string",
            xmlAttribute:"true",
            name:"operationType",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customSQL",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customHQL",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customJQL",
            validators:[
            ]
        },
        {
            type:"string",
            name:"groupClause",
            validators:[
            ]
        },
        {
            type:"string",
            name:"orderClause",
            validators:[
            ]
        },
        {
            type:"string",
            name:"selectClause",
            validators:[
            ]
        },
        {
            type:"string",
            name:"tableClause",
            validators:[
            ]
        },
        {
            type:"string",
            name:"valuesClause",
            validators:[
            ]
        },
        {
            type:"string",
            name:"whereClause",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useHavingClause",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"apidoc",
            validators:[
            ]
        },
        {
            type:"string",
            name:"requiredCriterion",
            validators:[
            ]
        },
        {
            valueMap:{
                custom:"Custom Binding",
                iscServer:"ISC Java Server",
                json:"JSON Web Service",
                xml:"XML / WSDL Web Service"
            },
            title:"DataFormat",
            type:"string",
            name:"dataFormat",
            validators:[
            ]
        },
        {
            type:"string",
            name:"wsOperation",
            validators:[
            ]
        },
        {
            type:"string",
            name:"recordName",
            validators:[
            ]
        },
        {
            type:"XPath",
            name:"recordXPath",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"dropExtraFields",
            validators:[
            ]
        },
        {
            type:"DataSource",
            name:"responseDataSchema",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"operationId",
            validators:[
            ]
        },
        {
            type:"string",
            name:"description",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useFlatFields",
            validators:[
            ]
        },
        {
            type:"URL",
            name:"dataURL",
            validators:[
            ]
        },
        {
            type:"string",
            name:"dataTransport",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"defaultParams",
            validators:[
            ]
        },
        {
            type:"string",
            name:"soapAction",
            validators:[
            ]
        },
        {
            type:"DSProtocol",
            name:"dataProtocol",
            validators:[
            ]
        },
        {
            title:"Callback Parameter",
            type:"string",
            name:"callbackParam",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"requestProperties",
            validators:[
            ]
        },
        {
            type:"ServerObject",
            name:"serverObject",
            validators:[
            ]
        },
        {
            type:"string",
            name:"serverMethod",
            validators:[
            ]
        },
        {
            type:"string",
            name:"methodArguments",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"xmlNamespaces",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"preventHTTPCaching",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"spoofResponses",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"exportResults",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"exportDatesAsFormattedString",
            validators:[
            ]
        },
        {
            type:"string",
            name:"exportAs",
            validators:[
            ]
        },
        {
            type:"string",
            name:"exportFilename",
            validators:[
            ]
        },
        {
            type:"string",
            name:"lineBreakStyle",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useForCacheSync",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"canSyncCache",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"allowMultiUpdate",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"providesMissingKeys",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"requiresAuthentication",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"requiresRole",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"requires",
            validators:[
            ]
        },
        {
            type:"string",
            name:"ownerIdField",
            validators:[
            ]
        },
        {
            type:"string",
            name:"guestUserId",
            validators:[
            ]
        },
        {
            type:"Mail",
            name:"mail",
            validators:[
            ]
        },
        {
            type:"string",
            name:"beanClassName",
            validators:[
            ]
        },
        {
            type:"string",
            name:"sqlType",
            validators:[
            ]
        },
        {
            type:"string",
            name:"outputs",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"arrayCriteriaForceExact",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"autoJoinTransactions",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"useSpringTransaction",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"progressiveLoading",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"allowAdvancedCriteria",
            validators:[
            ]
        },
        {
            type:"string",
            name:"scriptImport",
            validators:[
            ]
        },
        {
            idAllowed:"true",
            type:"Object",
            name:"script",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"transformRequestScript",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"transformResponseScript",
            validators:[
            ]
        },
        {
            type:"SummaryFunction",
            strictValidation:"false",
            name:"summaryFunctions",
            validators:[
            ]
        },
        {
            multiple:"true",
            fallbackToSingle:"true",
            type:"string",
            name:"groupBy",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"allowClientRequestedSummaries",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"applyCriteriaBeforeAggregation",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"skipRowCount",
            validators:[
            ]
        },
        {
            type:"string",
            name:"language",
            validators:[
            ]
        },
        {
            multiple:"true",
            type:"DSRequestModifier",
            name:"values",
            validators:[
            ]
        },
        {
            type:"DSRequestModifier",
            name:"criteria",
            validators:[
            ]
        },
        {
            type:"string",
            name:"cacheSyncOperation",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"relaxSecurityForCacheSync",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customCriteriaFields",
            validators:[
            ]
        },
        {
            type:"string",
            name:"excludeCriteriaFields",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customValueFields",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"creatorOverrides",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"qualifyColumnNames",
            validators:[
            ]
        },
        {
            type:"string",
            name:"customFields",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"skipAudit",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"includeAnsiJoinsInTableClause",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"unionFields",
            validators:[
            ]
        },
        {
            type:"boolean",
            xmlAttribute:"true",
            name:"isDDL",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"cacheSyncStrategy",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"cacheSyncTiming",
            validators:[
            ]
        },
        {
            type:"integer",
            xmlAttribute:"true",
            name:"logSlowSQL",
            validators:[
            ]
        },
        {
            type:"text",
            name:"requestFormat",
            validators:[
            ]
        },
        {
            type:"text",
            name:"responseFormat",
            validators:[
            ]
        },
        {
            type:"text",
            name:"requestTemplate",
            validators:[
            ]
        },
        {
            type:"text",
            name:"responseTemplate",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"wrapInList",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"headers",
            validators:[
            ]
        },
        {
            type:"Object",
            name:"params",
            validators:[
            ]
        },
        {
            type:"text",
            name:"httpMethod",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"requiresCompleteRESTResponse",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"includeExtraValuesInTemplatedResponse",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"PageHeader",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PageHeader",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"VLayout",
    Constructor:"PaneContainer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PaneContainer",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ParamsDeclaration",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"type",
            type:"string",
            validators:[
            ]
        },
        {
            name:"optional",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"description",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"PasswordItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"PasswordItem",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGrid",
    Constructor:"ScrollingMenu",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ScrollingMenu",
    fields:[
        {
            name:"cancel",
            type:"function",
            validators:[
            ]
        },
        {
            name:"itemClick",
            type:"function",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ScrollingMenu",
    Constructor:"PickListMenu",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PickListMenu",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CanvasItem",
    Constructor:"PickTreeItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PickTreeItem",
    fields:[
        {
            name:"buttonDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            idAllowed:true,
            name:"dataSource",
            type:"string",
            validators:[
            ]
        },
        {
            name:"valueTree",
            type:"Tree",
            validators:[
            ]
        },
        {
            name:"loadDataOnDemand",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canSelectParentItems",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"valueField",
            type:"string",
            validators:[
            ]
        },
        {
            name:"emptyMenuMessage",
            type:"string",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"Placeholder",
    allowAdvancedCriteria:true,
    inheritsFrom:"Label",
    xmlExplicitTypes:"true",
    isServerDS:true,
    ID:"Placeholder",
    fields:[
        {
            name:"ID",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoID",
            hidden:true,
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"placeholderDefaults",
            xmlExplicitTypes:false,
            type:"object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Point",
    fields:[
        {
            name:"x",
            title:"X",
            type:"float",
            validators:[
            ]
        },
        {
            name:"y",
            title:"Y",
            type:"float",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PointerSettings",
    fields:[
        {
            name:"snapTo",
            type:"text",
            validators:[
            ]
        },
        {
            name:"snapOffsetTop",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"snapOffsetLeft",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"cornerOffset",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"targetSnapTo",
            type:"text",
            validators:[
            ]
        },
        {
            name:"targetOffsetInto",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"targetOffsetTop",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"targetOffsetLeft",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"populate",
    allowAdvancedCriteria:true,
    inheritsFrom:"Rule",
    isServerDS:true,
    addGlobalId:"false",
    ID:"PopulateRule",
    fields:[
        {
            type:"string",
            name:"formula",
            validators:[
            ]
        },
        {
            type:"ValueMap",
            name:"formulaVars",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"populate",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"PopulateValidator",
    fields:[
        {
            type:"string",
            name:"formula",
            validators:[
            ]
        },
        {
            type:"ValueMap",
            name:"formulaVars",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"PortalColumn",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PortalColumn",
    fields:[
        {
            multiple:true,
            name:"portalRows",
            propertiesOnly:"true",
            type:"PortalRow",
            validators:[
            ]
        },
        {
            name:"width",
            basic:true,
            title:"Width",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"minWidth",
            title:"Min Width",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"maxWidth",
            title:"Max Width",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"portlets",
            type:"Portlet",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"PortalColumnBody",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PortalColumnBody",
    fields:[
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"members",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"PortalLayout",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PortalLayout",
    fields:[
        {
            multiple:true,
            name:"portalColumns",
            propertiesOnly:"true",
            type:"PortalColumn",
            validators:[
            ]
        },
        {
            name:"showColumnMenus",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"columnBorder",
            basic:true,
            type:"string",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"canResizeColumns",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"canResizePortlets",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"numColumns",
            basic:true,
            type:"integer",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"columnSpacing",
            basic:true,
            type:"integer",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"portletVSpacing",
            basic:true,
            type:"integer",
            validators:[
            ],
            group:"portal"
        },
        {
            name:"portletHSpacing",
            basic:true,
            type:"integer",
            validators:[
            ],
            group:"portal"
        },
        {
            multiple:true,
            name:"portletDropTypes",
            type:"string",
            validators:[
            ]
        },
        {
            basic:true,
            name:"overflow",
            validators:[
            ]
        },
        {
            validators:[
            ],
            name:"columnOverflow",
            valueMap:[
                "auto",
                "visible",
                "hidden",
                "scroll"
            ],
            basic:true,
            type:"overflowEnum",
            xmlAttribute:true,
            group:"sizing"
        },
        {
            name:"preventUnderflow",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"sizing"
        },
        {
            name:"preventColumnUnderflow",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"sizing"
        },
        {
            name:"preventRowUnderflow",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"sizing"
        },
        {
            name:"canStretchColumnWidths",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"sizing"
        },
        {
            name:"canShrinkColumnWidths",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"sizing"
        },
        {
            name:"canResizeRows",
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"members",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"membersMargin",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"PortalRow",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PortalRow",
    fields:[
        {
            name:"height",
            basic:true,
            title:"Height",
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"minHeight",
            title:"Min Height",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"maxHeight",
            title:"Max Height",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"portlets",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Window",
    Constructor:"Portlet",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Portlet",
    fields:[
        {
            name:"closeConfirmationMessage",
            basic:true,
            type:"string",
            validators:[
            ],
            group:"Portlet"
        },
        {
            name:"showCloseConfirmationMessage",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"Portlet"
        },
        {
            name:"destroyOnClose",
            basic:true,
            type:"boolean",
            validators:[
            ],
            group:"Portlet"
        },
        {
            name:"minWidth",
            basic:true,
            validators:[
            ],
            group:"Portlet"
        },
        {
            name:"minHeight",
            basic:true,
            validators:[
            ],
            group:"Portlet"
        },
        {
            name:"rowHeight",
            basic:true,
            type:"measure",
            validators:[
            ],
            group:"Portlet"
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"PrintCanvasTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PrintCanvasTask",
    fields:[
        {
            name:"exportAsPdf",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"exportFilename",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Task",
    Constructor:"Process",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Process",
    fields:[
        {
            name:"autoStart",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"wizard",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"containerId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"startElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"sequences",
            type:"ProcessSequence",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"elements",
            type:"ProcessElement",
            validators:[
            ]
        },
        {
            name:"state",
            type:"Record",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"views",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"defaultWaitFor",
            type:"string",
            validators:[
            ]
        },
        {
            name:"defaultWaitDuration",
            type:"integer",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"sequence",
            hidden:true,
            type:"ProcessElement",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"Sequence",
            hidden:true,
            type:"ProcessElement",
            validators:[
            ]
        },
        {
            name:"serviceTask",
            hidden:true,
            type:"ServiceTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"ServiceTask",
            hidden:true,
            type:"ServiceTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"stateTask",
            hidden:true,
            type:"StateTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"StateTask",
            hidden:true,
            type:"StateTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"userTask",
            hidden:true,
            type:"UserTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"UserTask",
            hidden:true,
            type:"UserTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"DecisionTask",
            hidden:true,
            type:"DecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"decisionTask",
            hidden:true,
            type:"DecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"MultiDecisionTask",
            hidden:true,
            type:"MultiDecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"multiDecisionTask",
            hidden:true,
            type:"MultiDecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"EndProcessTask",
            hidden:true,
            type:"EndProcessTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"DecisionGateway",
            hidden:true,
            type:"DecisionGateway",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"decisionGateway",
            hidden:true,
            type:"DecisionGateway",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"XORGateway",
            hidden:true,
            type:"XORGateway",
            validators:[
            ],
            moveTo:"elements"
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"ProcessSequence",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProcessSequence",
    fields:[
        {
            multiple:true,
            name:"elements",
            type:"ProcessElement",
            validators:[
            ]
        },
        {
            name:"serviceTask",
            hidden:true,
            type:"ServiceTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"ServiceTask",
            hidden:true,
            type:"ServiceTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"stateTask",
            hidden:true,
            type:"StateTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"StateTask",
            hidden:true,
            type:"StateTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"scriptTask",
            hidden:true,
            type:"ScriptTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"ScriptTask",
            hidden:true,
            type:"ScriptTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"userTask",
            hidden:true,
            type:"UserTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"UserTask",
            hidden:true,
            type:"UserTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"DecisionTask",
            hidden:true,
            type:"DecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"decisionTask",
            hidden:true,
            type:"DecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"MultiDecisionTask",
            hidden:true,
            type:"MultiDecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"multiDecisionTask",
            hidden:true,
            type:"MultiDecisionTask",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"DecisionGateway",
            hidden:true,
            type:"DecisionGateway",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"decisionGateway",
            hidden:true,
            type:"DecisionGateway",
            validators:[
            ],
            moveTo:"elements"
        },
        {
            name:"XORGateway",
            hidden:true,
            type:"XORGateway",
            validators:[
            ],
            moveTo:"elements"
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"StretchImg",
    Constructor:"Progressbar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Progressbar",
    fields:[
        {
            name:"length",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"breadth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"percentDone",
            type:"integerPercent",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"ReifyProject",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Project",
    fields:[
        {
            name:"screens",
            type:"ScreenTree",
            validators:[
            ]
        },
        {
            name:"currentScreenFileName",
            type:"string",
            validators:[
            ]
        },
        {
            childTagName:"datasource",
            multiple:true,
            name:"datasources",
            type:"ProjectDataSource",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"runConfigurations",
            type:"Record",
            validators:[
            ]
        },
        {
            name:"authentication",
            type:"ProjectAuthentication",
            validators:[
            ]
        },
        {
            name:"skin",
            type:"string",
            validators:[
            ]
        },
        {
            name:"skinUrl",
            type:"string",
            validators:[
            ]
        },
        {
            name:"density",
            type:"string",
            validators:[
            ]
        },
        {
            name:"currentScreenID",
            type:"any",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProjectAuthentication",
    fields:[
        {
            name:"provider",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            childTagName:"user",
            multiple:true,
            name:"users",
            type:"ProjectAuthenticationUser",
            validators:[
            ]
        },
        {
            childTagName:"role",
            multiple:true,
            name:"availableRoles",
            type:"ProjectAuthenticationRole",
            validators:[
            ]
        },
        {
            name:"lastSelectedUser",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Record",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProjectAuthenticationRole",
    fields:[
        {
            name:"name",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"description",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Record",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProjectAuthenticationUser",
    fields:[
        {
            name:"userId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"email",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"firstName",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"lastName",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"phone",
            type:"phoneNumber",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"superUser",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Record",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProjectDataSource",
    fields:[
        {
            name:"dsName",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"dsType",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ProjectFile",
    fields:[
        {
            name:"fileName",
            type:"text",
            validators:[
            ]
        },
        {
            name:"fileType",
            type:"text",
            validators:[
            ]
        },
        {
            name:"fileFormat",
            type:"text",
            validators:[
            ]
        },
        {
            canView:false,
            name:"fileNameLength"
        },
        {
            length:10485760,
            name:"fileContents",
            type:"text",
            audit:"change",
            validators:[
            ]
        },
        {
            name:"fileLastModified",
            type:"datetime",
            storeMilliseconds:true,
            validators:[
            ]
        },
        {
            name:"fileSize",
            type:"integer",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DynamicForm",
    Constructor:"PropertySheet",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PropertySheet",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"PropertyValue",
    fields:[
        {
            name:"name",
            type:"string",
            validators:[
            ]
        },
        {
            name:"value",
            xmlExplicitSimpleTypes:true,
            type:"any",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Gradient",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RadialGradient",
    fields:[
        {
            name:"cx",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"cy",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"r",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fx",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fy",
            type:"string",
            defaultValue:"0",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"RadioGroupItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"ContainerItem",
    isServerDS:true,
    ID:"RadioGroupItem",
    fields:[
        {
            name:"valueMap",
            basic:true,
            title:"Value Map",
            type:"ValueMap",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"disabledValues",
            type:"string",
            validators:[
            ]
        },
        {
            name:"vertical",
            basic:true,
            title:"Vertical",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"itemHeight",
            title:"Item Height",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"prompt",
            inapplicable:true,
            title:"Prompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"itemPrompt",
            title:"Item Prompt",
            type:"HTMLString",
            visibility:"internal",
            validators:[
            ],
            hint:"Prompt for each item - \"*\" denotes the item title"
        },
        {
            multiple:true,
            name:"items",
            inapplicable:true,
            type:"FormItem",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CheckboxItem",
    Constructor:"RadioItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RadioItem",
    fields:[
        {
            name:"value",
            visibility:"internal",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"unselectedValue",
            visibility:"internal",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"RangeSlider",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RangeSlider",
    fields:[
        {
            name:"baseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"startThumb",
            propertiesOnly:"true",
            type:"Snapbar",
            validators:[
            ]
        },
        {
            name:"endThumb",
            propertiesOnly:"true",
            type:"Snapbar",
            validators:[
            ]
        },
        {
            name:"startValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"endValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"maxValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"minValue",
            type:"float",
            validators:[
            ]
        },
        {
            name:"scrollbar",
            propertiesOnly:"true",
            type:"Scrollbar",
            validators:[
            ]
        },
        {
            name:"track",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"vertical",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Progressbar",
    Constructor:"Rangebar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Rangebar",
    fields:[
        {
            name:"value",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"minValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"maxValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"title",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"showTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRange",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"minValueLabel",
            type:"string",
            validators:[
            ]
        },
        {
            name:"maxValueLabel",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"readOnly",
    allowAdvancedCriteria:true,
    inheritsFrom:"Rule",
    isServerDS:true,
    addGlobalId:"false",
    ID:"ReadOnlyRule",
    fields:[
        {
            name:"fieldAppearance",
            valueMap:{
                value:[
                    "readOnly",
                    "hidden",
                    "disabled"
                ]
            },
            type:"enum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"readOnly",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"ReadOnlyValidator",
    fields:[
        {
            type:"string",
            name:"fieldAppearance",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"regexp",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"RegExpValidator",
    fields:[
        {
            type:"string",
            name:"expression",
            validators:[
            ]
        },
        {
            type:"string",
            name:"errorMessage",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Reify",
    fields:[
        {
            name:"projectID",
            type:"any",
            validators:[
            ]
        },
        {
            name:"projectOwnerId",
            type:"any",
            validators:[
            ]
        },
        {
            name:"projectFileName",
            type:"any",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"recentProjects",
            type:"MenuItem",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Process",
    Constructor:"Tour",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Tour",
    fields:[
        {
            name:"autoReset",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"mode",
            valueMap:[
                "tour",
                "tutorial"
            ],
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"steps",
            type:"ProcessElement",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"cancelSteps",
            type:"ProcessElement",
            validators:[
            ]
        },
        {
            name:"showProgress",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showProgressPercent",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showProgressPercentInline",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"outlineBorder",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dropOutlineBorder",
            type:"string",
            validators:[
            ]
        },
        {
            name:"notifyType",
            type:"string",
            validators:[
            ]
        },
        {
            name:"notifyMessageSettings",
            propertiesOnly:"true",
            type:"NotifySettings",
            validators:[
            ]
        },
        {
            name:"showInputValidationMessage",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"stepActionButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"firstStepActionButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"lastStepActionButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"stepCancelButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"firstStepCancelButtonTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"windowDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"allowDropOnDescendants",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Tour",
    Constructor:"ReifyTour",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ReifyTour",
    fields:[
        {
            name:"showRevertOption",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"resetUIAtStart",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"startWithNewScreen",
            valueMap:[
                "no",
                "always",
                "prompt"
            ],
            type:"enum",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"newScreenContent",
            type:"text",
            validators:[
            ]
        },
        {
            name:"requiresDataSources",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Task",
    Constructor:"ScriptTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ScriptTask",
    fields:[
        {
            name:"isAsync",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"execute",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ScriptTask",
    Constructor:"ReifyTourCloseWindow",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ReifyTourCloseWindow",
    fields:[
        {
            name:"target",
            type:"text",
            validators:[
            ]
        },
        {
            name:"closeMethod",
            valueMap:[
                "closeClick",
                "destroy",
                "hide",
                "custom"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"customClose",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ScriptTask",
    Constructor:"ReifyTourCreateNewScreen",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ReifyTourCreateNewScreen",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Task",
    Constructor:"UserTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"UserTask",
    fields:[
        {
            name:"wizard",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"saveToServer",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"cancelElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"previousElement",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"inlineView",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            idAllowed:true,
            name:"targetView",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"targetForm",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetVM",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"UserTask",
    Constructor:"TourStep",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TourStep",
    fields:[
        {
            name:"title",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"instructions",
            type:"text",
            validators:[
            ]
        },
        {
            name:"contents",
            type:"text",
            validators:[
            ]
        },
        {
            name:"target",
            type:"text",
            validators:[
            ]
        },
        {
            name:"dropTarget",
            type:"text",
            validators:[
            ]
        },
        {
            name:"afterInputTarget",
            type:"text",
            validators:[
            ]
        },
        {
            name:"allowDropOnDescendants",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"actionType",
            valueMap:[
                "click",
                "doubleClick",
                "rightClick",
                "mouseDown",
                "mouseOver",
                "drag",
                "change",
                "menuItemSelect",
                "menuItemOpen",
                "none",
                "any"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"autoComplete",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showOutline",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showPointer",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showArrow",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showArrowAroundSmallTarget",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"windowDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"bindEnteredText",
            type:"text",
            validators:[
            ]
        },
        {
            name:"pointerSnapTo",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showCancelButton",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"cancelButtonTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showActionButton",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"actionButtonTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"expectedValue",
            type:"any",
            validators:[
            ]
        },
        {
            name:"expectedValueCaseSensitive",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"inputValidation",
            valueMap:[
                "strict",
                "notify",
                "onExit"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showInputValidationMessage",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"inputValidationNotifyDelay",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"inputValidationNotifyMessage",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TourStep",
    Constructor:"ReifyTourTypeTextStep",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ReifyTourTypeTextStep",
    fields:[
        {
            name:"text",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"RelativeDate",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RelativeDate",
    fields:[
        {
            name:"rangePosition",
            valueMap:[
                "start",
                "end"
            ],
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"value",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CubeGrid",
    Constructor:"CubeGrid",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ReportViewer",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"requiredIf",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"RequiredIfValidator",
    fields:[
        {
            type:"string",
            name:"expression",
            validators:[
            ]
        },
        {
            type:"string",
            name:"errorMessage",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"required",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"RequiredValidator",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ResetItem",
    methods:[
        {
            action:false,
            basic:true,
            "default":true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"ButtonItem",
    isServerDS:true,
    ID:"ResetItem",
    fields:[
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"ResetPasswordTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ResetPasswordTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DataSource",
    Constructor:"RestDataSource",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RestDataSource",
    fields:[
        {
            name:"fetchDataURL",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"addDataURL",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"removeDataURL",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"updateDataURL",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"xmlRecordXPath",
            type:"XPath",
            validators:[
            ]
        },
        {
            name:"jsonRecordXPath",
            type:"XPath",
            validators:[
            ]
        },
        {
            name:"metaDataPrefix",
            type:"string",
            validators:[
            ]
        },
        {
            name:"prettyPrintJSON",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sendMetaData",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"List",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ResultSet",
    fields:[
        {
            idAllowed:true,
            name:"dataSource",
            type:"string",
            validators:[
            ]
        },
        {
            name:"dropCacheOnUpdate",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"fetchDelay",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"fetchMode",
            valueMap:[
                "paged",
                "basic",
                "local"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"fetchOperation",
            type:"string",
            validators:[
            ]
        },
        {
            name:"resultSize",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"useClientFiltering",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"useClientSorting",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Tree",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ResultTree",
    fields:[
        {
            idAllowed:true,
            name:"dataSource",
            type:"string",
            validators:[
            ]
        },
        {
            name:"loadDataOnDemand",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ToolStrip",
    Constructor:"RibbonBar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RibbonBar",
    fields:[
        {
            name:"groupTitleAlign",
            basic:false,
            title:"Group Title Align",
            type:"valignEnum",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Layout",
    Constructor:"RibbonGroup",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RibbonGroup",
    fields:[
        {
            name:"title",
            basic:true,
            title:"Title",
            type:"text",
            validators:[
            ]
        },
        {
            name:"titleOrientation",
            basic:true,
            title:"Title Orientation",
            type:"valignEnum",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            basic:true,
            title:"Title Align",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"titleHeight",
            basic:true,
            title:"Title Height",
            type:"int",
            validators:[
            ]
        },
        {
            name:"numRows",
            basic:true,
            title:"Row Count",
            type:"number",
            validators:[
            ]
        },
        {
            name:"rowHeight",
            basic:true,
            title:"Row Height",
            type:"number",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"controls",
            basic:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"autoSizeToTitle",
            basic:true,
            title:"Size to Title",
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"members",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"VLayout",
    Constructor:"RichTextEditor",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RichTextEditor",
    fields:[
        {
            multiple:true,
            name:"controlGroups",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"fontControls",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"colorControls",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"formatControls",
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"styleControls",
            type:"string",
            validators:[
            ]
        },
        {
            name:"value",
            type:"string",
            validators:[
            ]
        },
        {
            name:"fontNames",
            type:"valueMap",
            validators:[
            ]
        },
        {
            name:"fontSizes",
            type:"valueMap",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CanvasItem",
    Constructor:"RichTextItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RichTextItem",
    fields:[
        {
            multiple:true,
            name:"controlGroups",
            type:"string",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SpacerItem",
    methods:[
        {
            action:false,
            inapplicable:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    isServerDS:true,
    ID:"SpacerItem",
    fields:[
        {
            name:"title",
            inapplicable:true,
            title:"Title",
            type:"string",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            inapplicable:true,
            title:"Default Value",
            type:"string",
            validators:[
            ]
        },
        {
            validators:[
            ],
            hint:"JS expression to evaluate on redraw",
            name:"defaultDynamicValue",
            inapplicable:true,
            title:"Default Dynamic Value",
            type:"expression",
            prompt:"JS expression - evaluates to default value"
        },
        {
            name:"showTitle",
            inapplicable:true,
            title:"Show Title",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"titleOrientation",
            inapplicable:true,
            title:"Title Orientation",
            type:"directionEnum",
            prompt:"Position item title to the left or right of text",
            validators:[
            ]
        },
        {
            name:"titleAlign",
            inapplicable:true,
            title:"Title Alignment",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"align",
            inapplicable:true,
            title:"Text Alignment",
            type:"alignEnum",
            validators:[
            ]
        },
        {
            name:"disabled",
            inapplicable:true,
            title:"Disable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"required",
            inapplicable:true,
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"validators",
            inapplicable:true,
            title:"Validators",
            type:"Validator",
            validators:[
            ]
        },
        {
            name:"validateOnChange",
            inapplicable:true,
            title:"Validate On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"prompt",
            inapplicable:true,
            title:"Prompt",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"hint",
            inapplicable:true,
            title:"Hint",
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"showHint",
            inapplicable:true,
            title:"Show Hint",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"redrawOnChange",
            inapplicable:true,
            title:"Redraw On Change",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"changeOnBlur",
            inapplicable:true,
            title:"Change On Blur",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"RowSpacerItem",
    methods:[
        {
            action:false,
            inapplicable:true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"SpacerItem",
    isServerDS:true,
    ID:"RowSpacerItem",
    fields:[
        {
            name:"colSpan",
            inapplicable:true,
            title:"Column Span",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"startRow",
            inapplicable:true,
            title:"Start Row",
            type:"boolean",
            prompt:"Check to position this item on a new row",
            validators:[
            ]
        },
        {
            name:"endRow",
            inapplicable:true,
            title:"End Row",
            type:"boolean",
            prompt:"Check to start a new row after this item",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"RulesEngine",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"RulesEngine",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    allowAdvancedCriteria:true,
    isServerDS:true,
    operationBindings:[
        {
            operationId:"checkUploadFeature",
            operationType:"custom"
        }
    ],
    addGlobalId:false,
    ID:"SCUploadSaveFile",
    fields:[
        {
            name:"path",
            hidden:true,
            validators:[
            ],
            primaryKey:true
        },
        {
            name:"file",
            type:"binary",
            validators:[
            ]
        },
        {
            hidden:true,
            name:"file_dir",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"BrowserPlugin",
    Constructor:"SVG",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SVG",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SandboxedTestFile",
    fields:[
        {
            name:"ownerId",
            type:"text",
            validators:[
            ]
        },
        {
            name:"fileName",
            type:"text",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        SearchEditorMode:{
            ID:"SearchEditorMode",
            inheritsFrom:"enum",
            valueMap:[
                "normal"
            ]
        }
    },
    componentSchema:true,
    Constructor:"SavedSearchEditor",
    allowAdvancedCriteria:true,
    inheritsFrom:"VLayout",
    isServerDS:true,
    ID:"SavedSearchEditor",
    fields:[
        {
            name:"mode",
            type:"SearchEditorMode",
            validators:[
            ]
        },
        {
            name:"isAdmin",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sharedSearchCheckbox",
            type:"CheckboxItem",
            validators:[
            ]
        },
        {
            name:"sharedSearchTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"defaultSearchCheckbox",
            type:"CheckboxItem",
            validators:[
            ]
        },
        {
            name:"defaultSearchTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"promptLabel",
            type:"Label",
            validators:[
            ]
        },
        {
            name:"addSearchText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"gridAddSearchText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"editSearchText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"searchNameItem",
            type:"TextItem",
            validators:[
            ]
        },
        {
            name:"filterBuilder",
            type:"FilterBuilder",
            validators:[
            ]
        },
        {
            name:"saveButton",
            type:"IButton",
            validators:[
            ]
        },
        {
            name:"cancelButton",
            type:"IButton",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        SavedSearchStoredState:{
            ID:"SavedSearchStoredState",
            inheritsFrom:"enum",
            valueMap:[
                "criteria"
            ]
        }
    },
    componentSchema:true,
    Constructor:"SavedSearchItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"searchChanged"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"SelectItem",
    isServerDS:true,
    ID:"SavedSearchItem",
    fields:[
        {
            name:"canAddSearch",
            recreateOnChange:true,
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"addSearchIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            defaultValue:"/DynamicForm/default_formItem_icon.gif",
            validators:[
            ]
        },
        {
            name:"targetEditsCriteria",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canModifyProperty",
            editorType:"SingleFieldPicker",
            type:"string",
            validators:[
            ],
            requiresDSField:"optionDataSource"
        },
        {
            name:"editSearchField",
            type:"ListGridField",
            validators:[
            ]
        },
        {
            name:"editSearchHoverText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"removeSearchHoverText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"copySearchHoverText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"markAsDefaultHoverText",
            type:"string",
            validators:[
            ]
        },
        {
            name:"canEditSearch",
            recreateOnChange:true,
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canRemoveSearch",
            recreateOnChange:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCopySearch",
            recreateOnChange:true,
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            idAllowed:true,
            validators:[
            ],
            name:"targetComponent",
            basic:true,
            editorType:"NonFormDBCPicker",
            type:"Canvas",
            xmlAttribute:true
        },
        {
            idAllowed:true,
            validators:[
            ],
            name:"targetDataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource",
            xmlAttribute:true
        },
        {
            name:"confirmRemoval",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"confirmRemovalMessage",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"editSearchWindow",
            type:"EditSearchWindow",
            validators:[
            ]
        },
        {
            name:"adminRole",
            type:"string",
            validators:[
            ]
        },
        {
            name:"newRecordValues",
            type:"Record",
            validators:[
            ]
        },
        {
            name:"saveLastSearch",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"saveDefaultSearch",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"storedState",
            type:"SavedSearchStoredState",
            validators:[
            ]
        },
        {
            name:"offlineStorageKey",
            type:"string",
            validators:[
            ]
        },
        {
            name:"adminSeparatorRecord",
            type:"ListGridRecord",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"valueMap",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"optionDataSource",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"colSpan",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"filterLocally",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"pickListFields",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"showTitle",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"type",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DynamicForm",
    Constructor:"ScalarViewer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ScalarViewer",
    fields:[
        {
            name:"fieldName",
            validators:[
            ]
        },
        {
            name:"title",
            validators:[
            ]
        },
        {
            name:"valueItemProperties",
            type:"FormItem",
            validators:[
            ]
        },
        {
            name:"fetchRequestProperties",
            type:"DSRequest",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"SchemaSet",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:false,
    ID:"SchemaSet",
    fields:[
        {
            name:"schemaNamespace",
            type:"url",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"schemaImports",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"qualifyAll",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"schema",
            type:"DataSource",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ScreenLoader",
    methods:[
        {
            basic:true,
            name:"dataContextChanged",
            title:"Screen Inputs Changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"VLayout",
    isServerDS:true,
    ID:"ScreenLoader",
    fields:[
        {
            name:"screenName",
            basic:true,
            type:"string",
            validators:[
            ],
            canEdit:false
        },
        {
            name:"screenLoaderURL",
            type:"url",
            validators:[
            ]
        },
        {
            name:"dataContextBinding",
            flattenSingleChild:"false",
            xmlExplicitSimpleTypes:true,
            propertiesOnly:"true",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeNode",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ScreenNode",
    fields:[
        {
            name:"mockupMode",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"fileName",
            type:"string",
            validators:[
            ]
        },
        {
            name:"contents",
            type:"string",
            validators:[
            ]
        },
        {
            name:"isCurrent",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"isOpen",
            type:"boolean",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            type:"ScreenNode",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Tree",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ScreenTree",
    fields:[
        {
            name:"root",
            type:"ScreenNode",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"StretchImg",
    Constructor:"Scrollbar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Scrollbar",
    fields:[
        {
            name:"btnSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"state",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"autoEnable",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showCorner",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"allowThumbDownState",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"thumbResizeThreshold",
            type:"float",
            validators:[
            ]
        },
        {
            name:"thumbMinSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"thumbOverlap",
            type:"number",
            validators:[
            ]
        },
        {
            name:"scrollTarget",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"trackEndWidth",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"trackEndHeight",
            type:"number",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"cornerSize",
            type:"number",
            advanced:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SearchForm",
    methods:[
        {
            basic:true,
            name:"search"
        },
        {
            basic:true,
            name:"criteriaChanged"
        },
        {
            action:true,
            basic:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"search",
            title:"Perform Search"
        },
        {
            action:true,
            inapplicable:true,
            name:"editSelectedData"
        },
        {
            action:true,
            inapplicable:true,
            name:"editRecord"
        },
        {
            action:true,
            inapplicable:true,
            name:"editNewRecord"
        },
        {
            action:true,
            inapplicable:true,
            name:"saveData"
        },
        {
            action:true,
            inapplicable:true,
            name:"validate"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"DynamicForm",
    isServerDS:true,
    ID:"SearchForm",
    fields:[
        {
            name:"searchOnEnter",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"criteriaChangedDelay",
            type:"positiveInteger",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"saveOnEnter",
            inapplicable:true,
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SelectOtherItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"SelectItem",
    isServerDS:true,
    ID:"SelectOtherItem",
    fields:[
        {
            name:"separatorTitle",
            title:"Separator Text",
            type:"string",
            validators:[
            ],
            hint:"Text for the separator option"
        },
        {
            name:"otherTitle",
            title:"Other Text",
            type:"string",
            validators:[
            ],
            hint:"Title for the 'Other' option"
        },
        {
            name:"selectOtherPrompt",
            title:"Select Other Title",
            type:"string",
            validators:[
            ],
            hint:"Title to show in prompt for 'Other' value"
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"SendEmailTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SendEmailTask",
    fields:[
        {
            name:"to",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"subject",
            type:"text",
            validators:[
            ]
        },
        {
            name:"subjectFormula",
            type:"UserSummary",
            validators:[
            ]
        },
        {
            name:"message",
            type:"text",
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"SendSMSTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SendSMSTask",
    fields:[
        {
            name:"to",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"message",
            type:"text",
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"SendTransactionTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SendTransactionTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"serverCustom",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"ServerCustomValidator",
    fields:[
        {
            type:"string",
            name:"serverCondition",
            validators:[
            ]
        },
        {
            type:"ServerObject",
            name:"serverObject",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ServerObject",
    fields:[
        {
            type:"string",
            name:"ID",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"className",
            validators:[
            ]
        },
        {
            type:"string",
            xmlAttribute:"true",
            name:"methodName",
            validators:[
            ]
        },
        {
            valueMap:{
                attribute:"attribute",
                cdi:"cdi",
                factory:"factory",
                "new":"new",
                spring:"spring"
            },
            type:"enum",
            xmlAttribute:"true",
            name:"lookupStyle",
            validators:[
            ]
        },
        {
            type:"string",
            name:"attributeName",
            validators:[
            ]
        },
        {
            type:"enum",
            valueMap:{
                application:"application",
                request:"request",
                session:"session"
            },
            name:"attributeScope",
            validators:[
            ]
        },
        {
            type:"string",
            name:"bean",
            validators:[
            ]
        },
        {
            multiple:"true",
            propertiesOnly:"true",
            type:"Method",
            name:"visibleMethods",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"dropExtraFields",
            validators:[
            ]
        },
        {
            type:"boolean",
            name:"crudOnly",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"ServiceOperation",
    methods:[
        {
            action:true,
            basic:true,
            name:"invoke",
            title:"Invoke"
        }
    ],
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ServiceOperation",
    fields:[
        {
            name:"operationName",
            title:"Operation Name",
            required:true,
            validators:[
            ]
        },
        {
            name:"serviceNamespace",
            title:"Service Namespace",
            validators:[
            ]
        },
        {
            name:"serviceName",
            title:"Service Name",
            validators:[
            ]
        },
        {
            name:"serviceDescription",
            title:"Service Descriptive Name",
            validators:[
            ]
        },
        {
            name:"portTypeName",
            title:"PortType Name",
            validators:[
            ]
        },
        {
            name:"location",
            title:"WSDL location",
            validators:[
            ]
        },
        {
            name:"inputVM",
            title:"Input ValuesManager",
            type:"ValuesManager",
            validators:[
            ]
        },
        {
            name:"outputVM",
            title:"Output ValuesManager",
            type:"ValuesManager",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"SetButtonTitleTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SetButtonTitleTask",
    fields:[
        {
            name:"title",
            type:"text",
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"SetLabelTextTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SetLabelTextTask",
    fields:[
        {
            name:"value",
            type:"text",
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"SetPropertiesTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SetPropertiesTask",
    fields:[
        {
            name:"targetFieldName",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"properties",
            type:"PropertyValue",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"setRequired",
    allowAdvancedCriteria:true,
    inheritsFrom:"Rule",
    isServerDS:true,
    addGlobalId:"false",
    ID:"SetRequiredRule",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"SetScreenDataTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SetScreenDataTask",
    fields:[
        {
            name:"dataContextBinding",
            flattenSingleChild:"false",
            xmlExplicitSimpleTypes:true,
            propertiesOnly:"true",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"SetSectionTitleTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SetSectionTitleTask",
    fields:[
        {
            name:"targetSectionName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetSectionTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            type:"text",
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"SetTitleTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SetTitleTask",
    fields:[
        {
            name:"targetTabName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetFieldName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetSectionName",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetSectionTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"title",
            type:"text",
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Shadow",
    fields:[
        {
            name:"color",
            type:"color",
            defaultValue:"black",
            validators:[
            ]
        },
        {
            name:"blur",
            type:"integer",
            defaultValue:"10",
            validators:[
            ]
        },
        {
            name:"offset",
            type:"Point",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"ShowComponentTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShowComponentTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"ShowMessageTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShowMessageTask",
    fields:[
        {
            name:"type",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"message",
            type:"string",
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ComponentTask",
    Constructor:"ShowNextToComponentTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShowNextToComponentTask",
    fields:[
        {
            name:"nextToComponentId",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"ShowNotificationTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShowNotificationTask",
    fields:[
        {
            name:"notifyType",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"message",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"textFormula",
            type:"UserSummary",
            validators:[
            ]
        },
        {
            name:"autoDismiss",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"position",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ShowHideTask",
    Constructor:"ShowTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShowTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CanvasItem",
    Constructor:"ShuttleItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ShuttleItem",
    fields:[
        {
            multiple:true,
            name:"shuttleFields",
            type:"ListGridField",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Gradient",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SimpleGradient",
    fields:[
        {
            name:"direction",
            type:"float",
            defaultValue:"0.0",
            validators:[
            ]
        },
        {
            name:"startColor",
            type:"color",
            validators:[
            ]
        },
        {
            name:"endColor",
            type:"color",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Button",
    Constructor:"SimpleTabButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SimpleTabButton",
    fields:[
        {
            name:"pane",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SimpleType",
    allowAdvancedCriteria:true,
    inheritsFrom:"DataSourceField",
    isServerDS:true,
    addGlobalId:false,
    ID:"SimpleType",
    fields:[
        {
            name:"inheritsFrom",
            type:"string",
            validators:[
            ]
        },
        {
            name:"editorType",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"Slider",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Slider",
    fields:[
        {
            name:"title",
            basic:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"length",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"vertical",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"thumbThickWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"thumbThinWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"trackWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"thumbSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"trackSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"trackCapSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"trackImageType",
            valueMap:[
                "center",
                "tile",
                "stretch"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showTitle",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showRange",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"labelWidth",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"labelHeight",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"labelSpacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"hLabelSpacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"vLabelSpacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"titleSpacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"value",
            type:"float",
            validators:[
            ]
        },
        {
            name:"minValue",
            basic:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"minValueLabel",
            type:"string",
            validators:[
            ]
        },
        {
            name:"maxValue",
            basic:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"maxValueLabel",
            type:"string",
            validators:[
            ]
        },
        {
            name:"numValues",
            basic:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"roundValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"roundPrecision",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"flipValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"sliderTarget",
            type:"reference",
            validators:[
            ]
        },
        {
            name:"canFocus",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"stepPercent",
            type:"float",
            validators:[
            ]
        },
        {
            name:"animateThumb",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateThumbTime",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"animateThumbInit",
            type:"boolean",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SliderItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"CanvasItem",
    isServerDS:true,
    ID:"SliderItem",
    fields:[
        {
            name:"vertical",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"minValue",
            basic:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"maxValue",
            basic:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"numValues",
            basic:true,
            type:"number",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            basic:true,
            type:"float",
            validators:[
            ]
        },
        {
            name:"changeOnDrag",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"roundValues",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"roundPrecision",
            type:"number",
            validators:[
            ]
        },
        {
            name:"sliderProperties",
            propertiesOnly:"true",
            type:"Slider",
            validators:[
            ]
        },
        {
            name:"sliderDefaults",
            propertiesOnly:"true",
            type:"Slider",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    types:{
        sortEnum:{
            ID:"sortEnum",
            inheritsFrom:"enum",
            valueMap:[
                "ascending",
                "descending"
            ]
        }
    },
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SortSpecifier",
    fields:[
        {
            name:"direction",
            type:"sortEnum",
            validators:[
            ]
        },
        {
            name:"property",
            type:"identifier",
            validators:[
            ]
        },
        {
            name:"normalizer",
            type:"function",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    showSuperClassActions:false,
    componentSchema:true,
    Constructor:"LayoutSpacer",
    allowAdvancedCriteria:true,
    inheritsFrom:"Canvas",
    isServerDS:true,
    showLocalFieldsOnly:true,
    ID:"Spacer",
    fields:[
        {
            name:"width",
            title:"Width",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"height",
            title:"Height",
            type:"measure",
            validators:[
            ]
        },
        {
            name:"visibility",
            title:"Visibility",
            type:"visibilityEnum",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"children",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"peers",
            inapplicable:true,
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TextItem",
    Constructor:"SpinnerItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"SpinnerItem",
    fields:[
        {
            name:"step",
            type:"float",
            validators:[
            ]
        },
        {
            name:"max",
            type:"number",
            validators:[
            ]
        },
        {
            name:"min",
            type:"number",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"number",
            validators:[
            ]
        },
        {
            name:"writeStackedIcons",
            title:"Write stacked icons",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ScriptTask",
    Constructor:"StartProcessTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"StartProcessTask",
    fields:[
        {
            name:"process",
            type:"Process",
            validators:[
            ]
        },
        {
            name:"isAsync",
            inapplicable:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"execute",
            inapplicable:true,
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ProcessElement",
    Constructor:"StartTransactionTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"StartTransactionTask",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Task",
    Constructor:"StateTask",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"StateTask",
    fields:[
        {
            name:"type",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"value",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"outputExpression",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"SubmitItem",
    methods:[
        {
            action:false,
            basic:true,
            "default":true,
            name:"click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"ButtonItem",
    isServerDS:true,
    ID:"SubmitItem",
    fields:[
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"substringCount",
    allowAdvancedCriteria:true,
    inheritsFrom:"Validator",
    isServerDS:true,
    addGlobalId:"false",
    ID:"SubstringCountValidator",
    fields:[
        {
            type:"string",
            name:"operator",
            validators:[
            ]
        },
        {
            type:"string",
            name:"substring",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"SummaryFunction",
    fields:[
        {
            title:"Field name",
            type:"string",
            xmlAttribute:"true",
            primaryKey:"true",
            name:"fieldName",
            validators:[
            ]
        },
        {
            title:"Function",
            type:"string",
            xmlAttribute:"true",
            name:"function",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    methods:[
        {
            action:true,
            name:"select",
            title:"Select Tab"
        },
        {
            action:true,
            name:"hide",
            title:"Hide Tab"
        },
        {
            action:true,
            name:"show",
            title:"Show Tab"
        },
        {
            basic:true,
            name:"tabSelected"
        },
        {
            basic:true,
            name:"tabDeselected"
        }
    ],
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Tab",
    fields:[
        {
            name:"title",
            basic:true,
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"pane",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"ID",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"autoID",
            hidden:true,
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"width",
            basic:true,
            type:"measure",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"disabled",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"hidden",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"pickerTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"icon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"canClose",
            basic:true,
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"closeIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"enabled",
            type:"boolean",
            visibility:"hidden",
            validators:[
            ]
        },
        {
            name:"enableWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        },
        {
            name:"visibleWhen",
            basic:true,
            type:"AdvancedCriteria",
            isRuleCriteria:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Toolbar",
    Constructor:"TabBar",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TabBar",
    fields:[
        {
            multiple:true,
            name:"tabs",
            propertiesOnly:"true",
            type:"Tab",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"buttonConstructor",
            type:"className",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"breadth",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"defaultTabSize",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"selectedTabExpansion",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"baseLineThickness",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"baseLineCapSize",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"baseLineSrc",
            type:"URL",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"tabBarPosition",
            type:"valignEnum",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"tabBarAlign",
            type:"halignEnum",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"tabDefaults",
            propertiesOnly:"true",
            type:"TabBar",
            visibility:"internal",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TabSet",
    methods:[
        {
            basic:true,
            name:"tabSelected"
        },
        {
            basic:true,
            name:"tabDeselected"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "tabBar",
        "appearance",
        "sizing",
        "TabSet Methods"
    ],
    inheritsFrom:"Canvas",
    isServerDS:true,
    ID:"TabSet",
    fields:[
        {
            multiple:true,
            name:"tabBarControls",
            type:"Canvas",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"tabs",
            propertiesOnly:"true",
            type:"Tab",
            validators:[
            ]
        },
        {
            name:"tabBarDefaults",
            propertiesOnly:"true",
            type:"TabBar",
            validators:[
            ]
        },
        {
            name:"tabBarProperties",
            propertiesOnly:"true",
            type:"TabBar",
            validators:[
            ]
        },
        {
            name:"tabProperties",
            propertiesOnly:"true",
            type:"Tab",
            validators:[
            ]
        },
        {
            name:"showTabScroller",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showTabPicker",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateTabScrolling",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"scrollerButtonSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"pickerButtonSize",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"scrollerHSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"scrollerVSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"pickerButtonHSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"pickerButtonVSrc",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"useSimpleTabs",
            type:"boolean",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"simpleTabBaseStyle",
            type:"cssClass",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"canReorderTabs",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canCloseTabs",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"closeTabIcon",
            editorType:"ImageChooserItem",
            type:"SCImgURL",
            validators:[
            ]
        },
        {
            name:"destroyPanes",
            type:"boolean",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"tabBarPosition",
            recreateOnChange:true,
            type:"sideEnum",
            validators:[
            ]
        },
        {
            name:"tabBarAlign",
            type:"anyAlignEnum",
            validators:[
            ]
        },
        {
            name:"tabBarThickness",
            recreateOnChange:true,
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"selectedTab",
            basic:true,
            editorType:"TabSetTabPicker",
            title:"Initial Tab",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"paneContainerDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"paneContainerClassName",
            type:"cssClass",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"paneContainerOverflow",
            type:"overflowEnum",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"children",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"peers",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canSelectText",
            validators:[
            ]
        },
        {
            name:"showPaneContainerEdges",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showPartialEdges",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"symmetricEdges",
            type:"boolean",
            advanced:true,
            validators:[
            ]
        },
        {
            name:"topEdgeSizes",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"bottomEdgeSizes",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"leftEdgeSizes",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"rightEdgeSizes",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"topEdgeOffsets",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"bottomEdgeOffsets",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"leftEdgeOffsets",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"rightEdgeOffsets",
            type:"EdgeSizes",
            validators:[
            ]
        },
        {
            name:"closeTabIconSize",
            type:"number",
            advanced:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DecisionBranch",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TaskDecision",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TextAreaItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"FormItem",
    substituteClasses:"BlurbItem, StaticTextItem, TextItem",
    isServerDS:true,
    ID:"TextAreaItem",
    fields:[
        {
            name:"wrap",
            valueMap:{
                HARD:"hard",
                OFF:"off",
                SOFT:"soft"
            },
            title:"Wrap Style",
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showHintInField",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"escapeHTML",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"length",
            hidden:true,
            title:"Length",
            type:"positiveInteger",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TileGrid",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/view.png",
            name:"viewSelectedData",
            title:"View Selected Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/search.png",
            name:"fetchData",
            title:"Fetch Data"
        },
        {
            basic:true,
            "default":true,
            name:"recordClick"
        },
        {
            basic:true,
            name:"selectionUpdated"
        }
    ],
    allowAdvancedCriteria:true,
    groups:[
        "basics",
        "appearance",
        "selection"
    ],
    inheritsFrom:"TileLayout",
    isServerDS:true,
    ID:"TileGrid",
    fields:[
        {
            name:"ID",
            validators:[
            ]
        },
        {
            idAllowed:true,
            hidden:false,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"DataSource"
        },
        {
            name:"autoID",
            validators:[
            ]
        },
        {
            name:"initialCriteria",
            basic:true,
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"implicitCriteria",
            type:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            name:"fetchOperation",
            type:"string",
            validators:[
            ],
            requiresDSField:"dataSource"
        },
        {
            name:"searchForm",
            basic:true,
            editorType:"DynamicFormPicker",
            type:"identifier",
            validators:[
            ]
        },
        {
            name:"filterOnKeypress",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            multiple:true,
            name:"data",
            type:"TileRecord",
            validators:[
            ]
        },
        {
            childTagName:"DVField",
            multiple:true,
            name:"fields",
            type:"TileGridField",
            validators:[
            ]
        },
        {
            name:"selectionType",
            valueMap:[
                "none",
                "single",
                "multiple",
                "simple"
            ],
            type:"enum",
            validators:[
            ]
        },
        {
            name:"showAllRecords",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"animateTileChange",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showDetailFields",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"showEmptyMessage",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"emptyMessage",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"emptyMessageStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"loadingDataMessage",
            basic:true,
            type:"HTMLString",
            validators:[
            ]
        },
        {
            name:"loadingDataMessageStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"canDragTilesOut",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canAcceptDroppedRecords",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"canReorderTiles",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"dragTrackerStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            name:"detailViewerProperties",
            hidden:true,
            propertiesOnly:"true",
            type:"DetailViewer",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"tileConstructor",
            validators:[
            ]
        },
        {
            name:"tileScreen",
            recreateOnChange:true,
            basic:true,
            editorType:"ScreenPickerItem",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DetailViewerField",
    autoIdField:"name",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TileGridField",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TileGrid",
    Constructor:"TilePalette",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TilePalette",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Record",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TileRecord",
    fields:[
        {
            name:"tileProperties",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"TimeItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"TimeItem",
    fields:[
        {
            name:"showSeconds",
            title:"Show Seconds",
            type:"boolean",
            defaultValue:"false",
            validators:[
            ]
        },
        {
            name:"show24HourTime",
            title:"Show 24Hour Time",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"showHintInField",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"length",
            inapplicable:true,
            title:"Length",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"required",
            title:"Required",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"displayFormat",
            type:"string",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"type",
            validators:[
            ]
        },
        {
            name:"showHourItem",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"hourMinValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"hourMaxValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"hourIncrement",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"hourItemTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"hourItemPrompt",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showMinuteItem",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"minuteMinValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"minuteMaxValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"minuteIncrement",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"minuteItemTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"minuteItemPrompt",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showSecondItem",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"secondMinValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"secondMaxValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"secondIncrement",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"secondItemTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"secondItemPrompt",
            type:"string",
            validators:[
            ]
        },
        {
            name:"showMillisecondItem",
            type:"boolean",
            defaultValue:"true",
            validators:[
            ]
        },
        {
            name:"millisecondMinValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"millisecondMaxValue",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"millisecondIncrement",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"millisecondItemTitle",
            type:"string",
            validators:[
            ]
        },
        {
            name:"millisecondItemPrompt",
            type:"string",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Calendar",
    Constructor:"Timeline",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Timeline",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ToggleItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"click"
        },
        {
            action:false,
            basic:true,
            name:"changed",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"CanvasItem",
    isServerDS:true,
    ID:"ToggleItem",
    fields:[
        {
            name:"toggleProperties",
            propertiesOnly:"true",
            type:"ToggleSwitch",
            validators:[
            ]
        },
        {
            name:"toggleDefaults",
            propertiesOnly:"true",
            type:"ToggleSwitch",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ToggleSwitch",
    methods:[
        {
            action:false,
            basic:true,
            name:"valueChanged",
            whenRuleTip:"true"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StatefulCanvas",
    isServerDS:true,
    ID:"ToggleSwitch",
    fields:[
        {
            name:"animateThumb",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"defaultValue",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"thumbProperties",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"thumbDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"thumbOffset",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"thumbRadius",
            type:"string",
            validators:[
            ]
        },
        {
            name:"toggleOnThumbClick",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"toggleOnKeypress",
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"value",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"ToolStripButton",
    methods:[
        {
            action:false,
            basic:true,
            "default":true,
            name:"click",
            title:"Click"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"StretchImgButton",
    isServerDS:true,
    ID:"ToolStripButton",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"RibbonGroup",
    Constructor:"ToolStripGroup",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolStripGroup",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"IMenuButton",
    Constructor:"ToolStripMenuButton",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolStripMenuButton",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ImgSplitbar",
    Constructor:"ToolStripResizer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolStripResizer",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Img",
    Constructor:"ToolStripSeparator",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolStripSeparator",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Img",
    Constructor:"ToolStripSpacer",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolStripSpacer",
    fields:[
        {
            name:"space",
            basic:true,
            type:"Number",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CanvasItem",
    Constructor:"ToolbarItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ToolbarItem",
    fields:[
        {
            multiple:true,
            name:"buttons",
            propertiesOnly:"true",
            type:"ButtonItem",
            validators:[
            ]
        },
        {
            name:"spacing",
            title:"Spacing",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"separatorWidth",
            title:"Separator Width",
            type:"positiveInteger",
            validators:[
            ]
        },
        {
            name:"buttonConstructor",
            type:"className",
            validators:[
            ]
        },
        {
            name:"buttonProperties",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"buttonBaseStyle",
            type:"cssClass",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"UserTask",
    Constructor:"TourConfirmStep",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TourConfirmStep",
    fields:[
        {
            name:"title",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"instructions",
            type:"text",
            validators:[
            ]
        },
        {
            name:"contents",
            type:"text",
            validators:[
            ]
        },
        {
            name:"windowDefaults",
            propertiesOnly:"true",
            type:"Canvas",
            validators:[
            ]
        },
        {
            name:"showPointer",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"pointerSnapTo",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"pointerTarget",
            type:"text",
            validators:[
            ]
        },
        {
            name:"targetSnapTo",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"targetOffsetInto",
            type:"integer",
            validators:[
            ]
        },
        {
            name:"showCancelButton",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"cancelButtonTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showActionButton",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"actionButtonTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"nextElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"failureElement",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Window",
    Constructor:"TourWindow",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TourWindow",
    fields:[
        {
            name:"title",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"contents",
            type:"text",
            validators:[
            ]
        },
        {
            name:"showCancelButton",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"cancelButtonTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showActionButton",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"actionButtonTitle",
            type:"text",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"actionButtonURL",
            type:"text",
            validators:[
            ]
        },
        {
            name:"showProgress",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showProgressPercent",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"showProgressPercentInline",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"ListGridField",
    useParentFieldOrder:true,
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TreeGridField",
    fields:[
        {
            name:"treeField",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeGrid",
    Constructor:"TreePalette",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TreePalette",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"TreeGrid",
    Constructor:"TreeGrid",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TreeViewer",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"SplitPane",
    Constructor:"TriplePane",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"TriplePane",
    fields:[
        {
            name:"showListToolStrip",
            basic:true,
            type:"boolean",
            validators:[
            ]
        },
        {
            name:"autoNavigate",
            type:"boolean",
            xmlAttribute:true,
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"TrueWhen",
    fields:[
        {
            type:"AdvancedCriteria",
            name:"advancedCriteria",
            validators:[
            ]
        },
        {
            type:"AdvancedCriteria",
            name:"AdvancedCriteria",
            validators:[
            ]
        },
        {
            type:"AdvancedCriteria",
            name:"criteria",
            validators:[
            ]
        },
        {
            type:"AdvancedCriteria",
            name:"Criteria",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Tour",
    Constructor:"Tutorial",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"Tutorial",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"UploadItem",
    methods:[
        {
            action:false,
            basic:true,
            name:"changed"
        }
    ],
    allowAdvancedCriteria:true,
    inheritsFrom:"TextItem",
    isServerDS:true,
    ID:"UploadItem",
    fields:[
        {
            inapplicable:true,
            name:"defaultValue",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"length",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"defaultDynamicValue",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"formula",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"textFormula",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"UserFormula",
    fields:[
        {
            name:"text",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"formulaVars",
            type:"ValueMap",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"UserSummary",
    fields:[
        {
            name:"text",
            type:"string",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"summaryVars",
            type:"ValueMap",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:"false",
    ID:"ValueFromMapping",
    fields:[
        {
            type:"any",
            xmlAttribute:"true",
            name:"value",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"dataPath",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"formula",
            validators:[
            ]
        },
        {
            type:"text",
            xmlAttribute:"true",
            name:"template",
            validators:[
            ]
        },
        {
            type:"AdvancedCriteria",
            name:"criteria",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    strictValidation:"false",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ValueMap",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"CanvasItem",
    Constructor:"ValueMapItem",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ValueMapItem",
    fields:[
        {
            name:"newOptionRowMessage",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"displayTitle",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"valueTitle",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"showMapTypeButton",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"undefinedKeyErrorMessage",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"duplicateValueErrorMessage",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"saveAsArrayTitle",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            name:"saveAsObjectTitle",
            type:"string",
            visibility:"internal",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvas",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasConstructor",
            validators:[
            ]
        },
        {
            inapplicable:true,
            name:"canvasProperties",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"ValuesManager",
    methods:[
        {
            action:true,
            icon:"[SKINIMG]/actions/edit.png",
            name:"editSelectedData",
            title:"Edit Selected"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/edit.png",
            name:"editRecord",
            title:"Edit Record"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/add.png",
            name:"editNewRecord",
            title:"Edit New Record"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/save.png",
            name:"saveData",
            title:"Save Data"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/forward.png",
            name:"setValues",
            title:"Set Values"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/undo.png",
            name:"clearValues",
            title:"Clear Values"
        },
        {
            action:true,
            icon:"[SKINIMG]/actions/first.png",
            name:"reset",
            title:"Reset Values"
        },
        {
            action:true,
            name:"validate",
            title:"Validate Values"
        },
        {
            basic:true,
            name:"itemChanged",
            title:"Item Changed"
        }
    ],
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ValuesManager",
    fields:[
        {
            name:"ID",
            basic:true,
            title:"Identifier",
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            idAllowed:true,
            validators:[
            ],
            name:"dataSource",
            basic:true,
            editorType:"ProjectDataSourcePicker",
            type:"string",
            xmlAttribute:true
        },
        {
            name:"autoID",
            hidden:true,
            type:"identifier",
            xmlAttribute:true,
            validators:[
            ]
        },
        {
            name:"fetchOperation",
            type:"string",
            validators:[
            ],
            requiresDSField:"dataSource"
        },
        {
            name:"serviceName",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"serviceNamespace",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            name:"unknownErrorMessage",
            hidden:true,
            type:"string",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"members",
            propertiesOnly:"true",
            type:"DynamicForm",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"Canvas",
    Constructor:"ViewLoader",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"ViewLoader",
    fields:[
        {
            name:"viewURL",
            type:"url",
            validators:[
            ]
        },
        {
            name:"viewURLParams",
            type:"Object",
            validators:[
            ]
        },
        {
            name:"loadingMessage",
            type:"string",
            validators:[
            ]
        },
        {
            name:"httpMethod",
            type:"SendMethod",
            validators:[
            ]
        },
        {
            name:"allowCaching",
            type:"boolean",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WSDLMessage",
    allowAdvancedCriteria:true,
    inheritsFrom:"DataSource",
    isServerDS:true,
    addGlobalId:false,
    ID:"WSDLMessage",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DataSource",
    Constructor:"WSDataSource",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"WSDataSource",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:false,
    ID:"WSOperationHeader",
    fields:[
        {
            name:"encoding",
            validators:[
            ]
        },
        {
            name:"message",
            validators:[
            ]
        },
        {
            name:"part",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    Constructor:"WebService",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:false,
    ID:"WebService",
    fields:[
        {
            name:"location",
            type:"url",
            validators:[
            ]
        },
        {
            name:"targetNamespace",
            type:"url",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"schemaImports",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"wsdlImports",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"operations",
            type:"WebServiceOperation",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"portTypes",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"bindings",
            type:"Object",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"messages",
            type:"WSDLMessage",
            validators:[
            ]
        },
        {
            name:"globalNamespaces",
            type:"Object",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    addGlobalId:false,
    ID:"WebServiceOperation",
    fields:[
        {
            name:"name",
            title:"Operation Name",
            required:true,
            validators:[
            ]
        },
        {
            name:"soapAction",
            title:"SOAPAction Header",
            validators:[
            ]
        },
        {
            name:"inputMessage",
            title:"Input Message",
            validators:[
            ]
        },
        {
            name:"outputMessage",
            title:"Output Message",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"inputHeaders",
            type:"WSOperationHeader",
            validators:[
            ]
        },
        {
            multiple:true,
            name:"outputHeaders",
            type:"WSOperationHeader",
            validators:[
            ]
        }
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowCloseButton",
    allowAdvancedCriteria:true,
    inheritsFrom:"ImgButton",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowCloseButton",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowFooterSpacer",
    allowAdvancedCriteria:true,
    inheritsFrom:"LayoutSpacer",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowFooterSpacer",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowHeaderIcon",
    allowAdvancedCriteria:true,
    inheritsFrom:"Img",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowHeaderIcon",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowHeaderLabel",
    allowAdvancedCriteria:true,
    inheritsFrom:"Label",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowHeaderLabel",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowMaximizeButton",
    allowAdvancedCriteria:true,
    inheritsFrom:"ImgButton",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowMaximizeButton",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowMinimizeButton",
    allowAdvancedCriteria:true,
    inheritsFrom:"ImgButton",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowMinimizeButton",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"WindowResizer",
    allowAdvancedCriteria:true,
    inheritsFrom:"ImgButton",
    isServerDS:true,
    showLocalFieldsOnly:true,
    addGlobalId:false,
    ID:"WindowResizer",
    fields:[
    ],
    showSuperClassEvents:false
})
;
isc.DataSource.create({
    inheritsFrom:"DataSource",
    Constructor:"XJSONDataSource",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"XJSONDataSource",
    fields:[
    ]
})
;
isc.DataSource.create({
    inheritsFrom:"DecisionTask",
    Constructor:"XORGateway",
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"XORGateway",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"XSComplexType",
    allowAdvancedCriteria:true,
    inheritsFrom:"DataSource",
    isServerDS:true,
    addGlobalId:false,
    ID:"XSComplexType",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    Constructor:"XSElement",
    allowAdvancedCriteria:true,
    inheritsFrom:"DataSource",
    isServerDS:true,
    addGlobalId:false,
    ID:"XSElement",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    isServerDS:true,
    allowAdvancedCriteria:true,
    ID:"isomorphicXML",
    fields:[
    ]
})
;
isc.DataSource.create({
    componentSchema:true,
    allowAdvancedCriteria:true,
    inheritsFrom:"ProjectFile",
    serverType:"projectFile",
    isServerDS:true,
    ID:"dsStore",
    fields:[
    ]
})
;

isc.loadingSystemSchema=false;
