/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.tm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.testing.tm.SimpleJtaTransactionImpl;

public class SimpleJtaTransactionManagerImpl
implements TransactionManager {
    private static final SimpleJtaTransactionManagerImpl INSTANCE = new SimpleJtaTransactionManagerImpl();
    private SimpleJtaTransactionImpl currentTransaction;

    public static SimpleJtaTransactionManagerImpl getInstance() {
        return INSTANCE;
    }

    public int getStatus() throws SystemException {
        return this.currentTransaction == null ? 6 : this.currentTransaction.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.currentTransaction;
    }

    public SimpleJtaTransactionImpl getCurrentTransaction() {
        return this.currentTransaction;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.currentTransaction = new SimpleJtaTransactionImpl(this);
    }

    public Transaction suspend() throws SystemException {
        SimpleJtaTransactionImpl suspended = this.currentTransaction;
        this.currentTransaction = null;
        return suspended;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.currentTransaction = (SimpleJtaTransactionImpl)transaction;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("no current transaction to commit");
        }
        this.currentTransaction.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("no current transaction");
        }
        this.currentTransaction.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("no current transaction");
        }
        this.currentTransaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
    }

    void endCurrent(SimpleJtaTransactionImpl transaction) {
        if (transaction == this.currentTransaction) {
            this.currentTransaction = null;
        }
    }
}

