/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class MysqlDriver
extends SQLDriver {
    private static Logger log = new Logger(MysqlDriver.class.getName());

    public MysqlDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public String openQuote() {
        return "`";
    }

    @Override
    public String closeQuote() {
        return "`";
    }

    public boolean isMariaDB() throws Exception {
        return this.getDatabaseProductVersion().indexOf("MariaDB") != -1;
    }

    @Override
    public boolean supportsMilliseconds() throws Exception {
        Boolean supportsMilliseconds = this.sqlConfig.getBoolean((Object)"_supportsMilliseconds");
        if (supportsMilliseconds == null) {
            supportsMilliseconds = new Boolean(false);
            if (this.isMariaDB()) {
                String version = this.getDatabaseProductVersion();
                String[] _version = version.split("\\.");
                version = version.substring(version.indexOf("-") + 1);
                int major = Integer.parseInt(_version[0]);
                int minor = Integer.parseInt(_version[1]);
                supportsMilliseconds = new Boolean(major >= 6 || major == 5 && minor >= 3);
            } else {
                supportsMilliseconds = new Boolean(this.getDatabaseMajorVersion() >= 6 || this.getDatabaseMajorVersion() == 5 && this.getDatabaseMinorVersion() >= 6);
            }
            this.sqlConfig.put((Object)"_supportsMilliseconds", (Object)supportsMilliseconds);
        }
        return supportsMilliseconds;
    }

    @Override
    public boolean supportsFieldComparison(String columnType, String otherColumnType) {
        if (columnType != null && otherColumnType != null) {
            if (columnType.equals(otherColumnType)) {
                return true;
            }
            boolean isText = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"text");
            boolean isInteger = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"integer");
            boolean isFloat = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"float");
            boolean isTextOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"text");
            boolean isIntegerOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"integer");
            boolean isFloatOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"float");
            if ((isText || isInteger || isFloat) && (isTextOther || isIntegerOther || isFloatOther)) {
                return true;
            }
        }
        return super.supportsFieldComparison(columnType, otherColumnType);
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        return query + " LIMIT " + startRow + ", " + batchSize;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("mysql can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            String obj = MysqlDriver.getScalarResult("SELECT LAST_INSERT_ID()", this.dbConnection, this.dbName, this, req).toString();
            Long sequenceValue = new Long(obj.toString());
            primaryKeys.put(sequenceName, sequenceValue);
        }
        return primaryKeys;
    }

    @Override
    public boolean supportsNativeReplace() {
        return true;
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + remapName;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value, false) + "'";
    }

    public String escapeValueForFilter(Object value) {
        return this.escapeValueForFilter(value, null);
    }

    @Override
    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        if (filterStyle == null) {
            filterStyle = "substring";
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (!escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
        } else {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE_DOUBLE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.utcDateTimeFormatter.format((Date)value);
        }
        return value.toString();
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(actualValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        long millis = timestamp.getTime();
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    @Override
    public int caseInsensitiveStrategy() {
        return 0;
    }

    @Override
    public String caseSensitiveEqualsPredicate() {
        return " LIKE BINARY ";
    }

    @Override
    public String caseSensitiveNotEqualPredicate() {
        return " NOT LIKE BINARY ";
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName;
    }

    @Override
    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer("CONCAT(");
        for (String s : strings) {
            if (sql.length() > "CONCAT(".length()) {
                sql.append(", ");
            }
            sql.append(s);
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public boolean aliasRequiredForSubselect() {
        return true;
    }

    @Override
    public boolean tableExists(String tableName, String schema) throws Exception {
        return new SQLMetaData(this.dbConnection).tableExists(tableName, null, schema);
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }

    public int maxAllowedSequenceColumns() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        snapshotFile.deleteOnExit();
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " snapshot " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " restore " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected String getCredentialsCLI() {
        String user = this.driverConfig.getString((Object)"user", "root");
        String password = this.driverConfig.getString((Object)"password", null);
        String serverName = this.driverConfig.getString((Object)"serverName", null);
        return "-u" + user + (password == null ? "" : " -p'" + password + "'") + (serverName == null ? "" : " -h'" + serverName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSandbox(String sandboxName) throws Exception {
        String credentialsCLI = this.getCredentialsCLI();
        String string = sandboxName.intern();
        synchronized (string) {
            if (this.exists(sandboxName)) {
                log.debug((Object)("Sandboxed db " + sandboxName + " already exists, not rebuilding"));
                return;
            }
            String cmd = "echo 'drop database if exists " + sandboxName + "' | mysql " + credentialsCLI + " && echo 'create database " + sandboxName + "' | mysql " + credentialsCLI + " && mysqldump " + credentialsCLI + " " + this.defaultSchemaName + " --no-create-db --skip-add-locks --skip-add-drop-table |mysql " + credentialsCLI + " " + sandboxName;
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSandbox(String sandboxName) throws Exception {
        String credentialsCLI = this.getCredentialsCLI();
        String cmd = "echo 'drop if exists " + sandboxName + "' | mysql " + credentialsCLI;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean exists(String schemaName) throws Exception {
        return this.lastModified(schemaName) != -1L;
    }

    @Override
    public long lastModified(String schemaName) throws Exception {
        String credentialsCLI = this.getCredentialsCLI();
        String cmd = "echo 'select UNIX_TIMESTAMP(max(create_time)) from information_schema.tables where table_schema=\"" + schemaName + "\"' | mysql -N " + credentialsCLI;
        ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
        int exitValue = iscSystem.exitValue();
        if (exitValue != 0) {
            throw new Exception(iscSystem.getFormattedErrorString());
        }
        String lastModifiedString = iscSystem.getStdout().trim();
        log.warn((Object)("VALUE IS: " + lastModifiedString));
        if (lastModifiedString.equals("NULL")) {
            return -1L;
        }
        return Long.valueOf(lastModifiedString);
    }
}

