/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.CanPerformActionChain;
import org.openqa.selenium.interactions.internal.MultiAction;

public class CompositeAction
implements Action {
    private WebDriver driver;
    private List<Action> actionsList = new ArrayList<Action>();

    public CompositeAction() {
    }

    public CompositeAction(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public void perform() {
        if (this.driver != null && this.driver instanceof CanPerformActionChain) {
            ((CanPerformActionChain)((Object)this.driver)).getActionChainExecutor().execute(this);
        } else {
            for (Action action : this.actionsList) {
                action.perform();
            }
        }
    }

    public CompositeAction addAction(Action action) {
        this.actionsList.add(action);
        return this;
    }

    @VisibleForTesting
    int getNumberOfActions() {
        return this.actionsList.size();
    }

    public List<Action> asList() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Action action : this.actionsList) {
            if (action instanceof MultiAction) {
                builder.addAll(((MultiAction)((Object)action)).getActions());
                continue;
            }
            builder.add((Object)action);
        }
        return builder.build();
    }
}

