/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.SimpleHttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class HttpUtil
extends Base {
    private static Logger log = new Logger(HttpUtil.class.getName());

    public static void main(String[] args) throws Exception {
        String url = args[0];
        SimpleHttpResponse httpResponse = HttpUtil.httpGet(url, (Map)((Object)DataTools.buildMap("numRetriesFileNotFound", new Integer(12))));
        if (httpResponse.isSuccess()) {
            System.out.println("SUCCESS:" + httpResponse.getBodyAsString());
        } else {
            System.out.println("FAIL: " + httpResponse.getBodyAsString());
        }
    }

    public static SimpleHttpResponse httpRequest(String method, String url, Map optsIn) throws IOException, InterruptedException {
        int numRetriesFileNotFound;
        int numRetriesServerDown;
        DataTypeMap opts = optsIn == null ? new DataTypeMap() : new DataTypeMap(optsIn);
        int initialNumRetriesServerDown = numRetriesServerDown = opts.getInteger((Object)"numRetriesServerDown", 10);
        int retryDelayServerDown = opts.getInteger((Object)"retryDelayServerDown", 60);
        int initialNumRetriesFileNotFound = numRetriesFileNotFound = opts.getInteger((Object)"numRetriesFileNotFound", 0);
        int retryDelayFileNotFound = opts.getInteger((Object)"retryDelayFileNotFound", 5);
        boolean wantedRetriesForFileNotFound = numRetriesFileNotFound != 0;
        while (true) {
            SimpleHttpResponse httpResponse = null;
            try {
                RequestBuilder builder = RequestBuilder.create((String)method).setUri(url);
                builder = HttpUtil.addParams(builder, (Map)((Object)opts.getMap("params")));
                builder = HttpUtil.addHeaders(builder, (Map)((Object)opts.getMap("headers")));
                HttpClientContext clientContext = HttpUtil.getClientContext(url, opts);
                CloseableHttpClient httpClient = HttpClients.createDefault();
                HttpUriRequest httpRequest = builder.build();
                httpResponse = new SimpleHttpResponse(httpClient.execute(httpRequest, (HttpContext)clientContext));
                if (httpResponse.isSuccess()) {
                    return httpResponse;
                }
            }
            catch (Exception e) {
                if (numRetriesServerDown == 0) {
                    log.error((Object)("Failed to load " + url + " - all " + initialNumRetriesServerDown + " retries exhausted and server still not available"), e);
                    return httpResponse;
                }
                log.warn("Server down while loading " + url + " - will retry " + numRetriesServerDown + " more times on a " + retryDelayServerDown + "s delay");
                Thread.sleep(retryDelayServerDown * 1000);
                --numRetriesServerDown;
            }
            if (numRetriesFileNotFound == 0) {
                if (wantedRetriesForFileNotFound) {
                    log.error("File not found at " + url + " and all " + initialNumRetriesFileNotFound + " retries exhausted");
                    return httpResponse;
                }
                log.info("File not found at " + url + " no retries specified, so not considered an error");
                return httpResponse;
            }
            log.warn("File not found at " + url + " will retry " + numRetriesFileNotFound + " more times on a " + retryDelayFileNotFound + "s delay");
            Thread.sleep(retryDelayFileNotFound * 1000);
            --numRetriesFileNotFound;
        }
    }

    public static SimpleHttpResponse httpGet(String url) throws Exception {
        return HttpUtil.httpGet(url, null);
    }

    public static SimpleHttpResponse httpGet(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("GET", url, opts);
    }

    public static SimpleHttpResponse httpHead(String url) throws Exception {
        return HttpUtil.httpHead(url, null);
    }

    public static SimpleHttpResponse httpHead(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("HEAD", url, opts);
    }

    public static SimpleHttpResponse httpPut(String url) throws Exception {
        return HttpUtil.httpPut(url, null);
    }

    public static SimpleHttpResponse httpPut(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("PUT", url, opts);
    }

    public static SimpleHttpResponse httpPost(String url) throws Exception {
        return HttpUtil.httpPost(url, null);
    }

    public static SimpleHttpResponse httpPost(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("POST", url, opts);
    }

    public static SimpleHttpResponse httpDelete(String url) throws Exception {
        return HttpUtil.httpDelete(url, null);
    }

    public static SimpleHttpResponse httpDelete(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("DELETE", url, opts);
    }

    protected static HttpClientContext getClientContext(String url, DataTypeMap opts) throws MalformedURLException {
        String username = opts.getString("username");
        if (username == null) {
            return HttpClientContext.create();
        }
        String password = opts.getString("password");
        URL urlObj = new URL(url);
        String host = urlObj.getHost();
        String protocol = urlObj.getProtocol();
        int port = urlObj.getPort();
        if (port == -1) {
            port = urlObj.getDefaultPort();
        }
        HttpHost targetHost = new HttpHost(host, port, protocol);
        AuthScope authScope = new AuthScope(targetHost, "realm", "basic");
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(username, password));
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    protected static RequestBuilder addParams(RequestBuilder builder, Map params) {
        if (params != null) {
            for (String key : params.keySet()) {
                String value = (String)params.get(key);
                builder.addParameter(key, value);
            }
        }
        return builder;
    }

    protected static RequestBuilder addHeaders(RequestBuilder builder, Map params) {
        if (params != null) {
            for (String key : params.keySet()) {
                String value = (String)params.get(key);
                builder.addHeader(key, value);
            }
        }
        return builder;
    }
}

