/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected ServletContext servletContext;
    protected static Config config;
    protected static String webRoot;
    protected Logger log;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        Init.go(filterConfig.getServletContext(), true);
        config = Config.getGlobal();
        webRoot = config.getPath("webRoot");
        String filterName = filterConfig.getFilterName();
        String className = this.getClass().getName();
        String logPrefix = null;
        if (!className.endsWith(filterName)) {
            logPrefix = filterName;
        }
        this.log = new Logger(this.getClass().getName(), logPrefix);
        ServletTools.applyConfigToServletOrFilter(this, filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        boolean ignoredThread = false;
        try {
            String rpcContext;
            if (ServletTools.ignoreLog((HttpServletRequest)request) && !Logger.threadIgnored() && !Logger.threadIgnored()) {
                Logger.ignoreThread();
                ignoredThread = true;
            }
            boolean hadThreadLocal = RequestContext.getThreadLocal() != null;
            RequestContext requestContext = RequestContext.instance(this.servletContext, request, response);
            if (hadThreadLocal) {
                RequestContext.pushThreadLocal(requestContext);
            }
            if ((rpcContext = ServletTools.rpcContext((HttpServletRequest)request)) != null) {
                Logger.pushUniqueContext(rpcContext);
            }
            this._doFilter(request, response, chain);
        }
        catch (Throwable e) {
            this.handleError((HttpServletResponse)response, "BaseServlet Global Exception", e);
        }
        finally {
            Logger.removeContext();
            if (ignoredThread) {
                Logger.observeThread();
            }
            RequestContext.popThreadLocal();
        }
    }

    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        throw new ServletException("BaseFilter is not for direct use.");
    }

    public void handleError(HttpServletResponse response, Throwable t) {
        this.handleError(response, this.getClass().getName() + " top-level exception", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpServletResponse response, String errorMessage, Throwable t) {
        boolean threadWasIgnored = Logger.threadIgnored();
        try {
            Logger.observeThread();
            this.log.error((Object)errorMessage, Reflection.getRealTargetException(t));
        }
        finally {
            if (threadWasIgnored) {
                Logger.ignoreThread();
            }
        }
        ServletTools.handleServletError(response, errorMessage, t);
    }

    public void destroy() {
    }
}

