/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthenticatedUser
extends DataTypeMap
implements Principal,
Serializable,
IToJSON {
    private String name;
    private List<String> clientSafeFields;

    public AuthenticatedUser() {
    }

    public AuthenticatedUser(String name, IAuthenticator authenticator) {
        this(name, new HashMap(), authenticator);
    }

    public AuthenticatedUser(String name, Map userData, IAuthenticator authenticator) {
        super(userData);
        this.name = name;
        this.clientSafeFields = authenticator == null ? new ArrayList<String>() : authenticator.getClientSafeFields();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AuthenticatedUser)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getName().equals(((AuthenticatedUser)o).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.getName() + ")";
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.clientSafeMap(), out);
    }

    public DataTypeMap clientSafeMap() {
        HashMap clientSafeMap = new HashMap(this);
        DataTools.divideMap(clientSafeMap, this.clientSafeFields);
        return new DataTypeMap(clientSafeMap);
    }
}

