/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.taglib.BaseTag;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;

public class LoadSystemSchemaTag
extends BaseTag {
    public int doStartTag() throws JspException {
        this.init();
        try {
            LoadSystemSchemaTag.loadFrameworkDataSources((Writer)this.pageContext.getOut());
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadSystemSchema tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public static List<String> getFrameworkDataSources() {
        ArrayList<String> dsList = new ArrayList<String>();
        List paths = config.getCommaSeparatedList("framework.datasources");
        if (paths == null) {
            staticLog.error("LoadSystemSchemaTag.getFrameworkDataSources(): could not get framework.datasources from configuration");
        } else {
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                String dsDirPath = ISCFile.canonicalizePath((String)j.next());
                File dsDir = new File(dsDirPath);
                String[] files = dsDir.list();
                if (files == null) {
                    staticLog.error("LoadSystemSchemaTag.getFrameworkDataSources(): the following path configured for framework.datasources is not a directory: " + dsDirPath);
                    continue;
                }
                for (int i = 0; i < files.length; ++i) {
                    String filename = files[i];
                    if (filename.equals("Object.ds.xml") || filename.equals("FileAssembly.ds.xml") || filename.equals("FileAssemblyEntry.ds.xml") || filename.equals("Filesystem.ds.xml") || !filename.endsWith(".ds.xml")) continue;
                    String dsName = filename.substring(0, filename.lastIndexOf(".ds.xml"));
                    dsList.add(dsName);
                }
            }
        }
        return dsList;
    }

    public static void loadFrameworkDataSources(Writer out) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        HashMap loadedSoFar = new HashMap();
        List<String> dsList = LoadSystemSchemaTag.getFrameworkDataSources();
        for (String dsName : dsList) {
            LoadSystemSchemaTag.outputDSForName(dsName, out, loadedSoFar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputDSForName(String dataSourceId, Writer out, Map loadedSoFar) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        BasicDataSource ds = null;
        if (loadedSoFar.get(dataSourceId) != null) {
            return;
        }
        try {
            ds = (BasicDataSource)DataSourceManager.getDataSource(dataSourceId, null);
            if (ds == null) {
                throw new Exception("No datasource for name: " + dataSourceId);
            }
            String superDSName = ds.getSuperDSName();
            if (superDSName != null && !"Object".equals(superDSName)) {
                LoadSystemSchemaTag.outputDSForName(superDSName, out, loadedSoFar);
            }
            ds.setComponentSchema(true);
            jsTrans.toJS(ds, out);
            loadedSoFar.put(dataSourceId, dataSourceId);
        }
        finally {
            if (ds != null) {
                DataSourceManager.freeDataSource(ds);
            }
        }
        out.write(";\r");
    }
}

