/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.DynamicScreenGenerator;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.Screen;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.lang.StringEscapeUtils;

public class ScreenLoaderServlet
extends BaseServlet {
    public static final String PARAM_SCREEN_NAME = "screenName";
    public static final String PROJECT_UI = "project.ui";
    public static final String PARAM_STRUCTURED_RESPONSE = "structuredResponse";
    private static Logger log = new Logger(DataSource.class.getName());
    private static DynamicScreenGenerator defaultDynamicScreenGenerator = null;
    private static Map dynamicScreenGenerators = Collections.synchronizedMap(new LinkedMap());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/javascript;charset=" + encoding);
        } else {
            response.setContentType("application/javascript");
        }
        Locale locale = null;
        String localeName = request.getParameter("locale");
        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
            log.warn("Locale name " + localeName + " is not valid - ignoring");
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        try {
            StringWriter writer = new StringWriter();
            String screenNames = request.getParameter(PARAM_SCREEN_NAME);
            if (screenNames == null) {
                log.warn("Parameter \"screenName\" is not specified.");
            } else if ("".equals(screenNames.trim())) {
                log.warn("No data specified in parameter \"screenName\".");
            } else {
                log.debug("Requested screens:" + screenNames);
                if (request.getParameter(PARAM_STRUCTURED_RESPONSE) == null) {
                    for (String screenName : DataTools.commaSeparatedStringToList(screenNames)) {
                        screenName = screenName.trim();
                        log.debug("Processing screen \"" + screenName + "\".");
                        if (!"".equals(screenName)) {
                            try {
                                String screen = this._loadScreen(screenName, locale, request);
                                if (screen == null) {
                                    log.warn("Screen \"" + screenName + "\" not found in configured locations. Skipping.");
                                    continue;
                                }
                                ((Writer)writer).write(screen.toString());
                                ((Writer)writer).write("\r\n");
                            }
                            catch (Exception ex) {
                                log.error((Object)("Failed to load screen \"" + screenName + "\". Skipping."), ex);
                            }
                            continue;
                        }
                        log.warn("Empty string specified as screen name. Skipping.");
                    }
                } else {
                    ((Writer)writer).write("{\n\r");
                    ((Writer)writer).write("  screens: [\n\r");
                    int separator = 32;
                    for (String screenName : DataTools.commaSeparatedStringToList(screenNames)) {
                        screenName = screenName.trim();
                        log.debug("Processing screen \"" + screenName + "\".");
                        if (!"".equals(screenName)) {
                            try {
                                String screen = this._loadScreen(screenName, locale, request);
                                if (screen == null) {
                                    log.warn("Screen \"" + screenName + "\" not found in configured locations. Skipping.");
                                    continue;
                                }
                                ((Writer)writer).write("      " + (char)separator + "{ screenName:\"" + screenName + "\",\n\r");
                                ((Writer)writer).write("        source:\"" + StringEscapeUtils.escapeJavaScript((String)screen.toString()) + "\"}\n\r");
                                ((Writer)writer).write("\r\n");
                                separator = 44;
                            }
                            catch (Exception ex) {
                                log.error((Object)("Failed to load screen \"" + screenName + "\". Skipping."), ex);
                            }
                            continue;
                        }
                        log.warn("Empty string specified as screen name. Skipping.");
                    }
                    ((Writer)writer).write("      ]\n\r");
                    ((Writer)writer).write("}\n\r");
                    ((Writer)writer).write("\r\n");
                }
            }
            log.debug("Generated response:" + ((Object)writer).toString());
            response.setStatus(200);
            PrintWriter rw = response.getWriter();
            rw.print(((Object)writer).toString());
            rw.close();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException writer) {}
        }
    }

    protected String _loadScreen(String screenName, Locale locale, HttpServletRequest request) throws Exception {
        String screenJS = ScreenLoaderServlet.loadScreen(screenName, locale);
        if (screenJS == null) {
            String shareId = request.getParameter("shareId");
            boolean isShared = false;
            if (shareId != null) {
                DSRequest sharedDSRequest = new DSRequest("sharedProjects", "fetch");
                sharedDSRequest.setCriteria((Object)DataTools.buildMap("shareId", shareId));
                DSResponse sharedDSResponse = sharedDSRequest.execute();
                Map<String, Object> record = sharedDSResponse.getRecord();
                if (record == null) {
                    throw new Exception("Invalid shareId");
                }
                isShared = true;
            }
            Screen screen = null;
            screen = isShared ? Screen.load(screenName) : Screen.load(screenName, request.getRemoteUser());
            if (screen != null) {
                JSTranslater jst = JSTranslater.instance();
                jst.setLocale(locale);
                jst.setObfuscation(false);
                StringWriter sw = new StringWriter();
                screen.toJSON(sw, jst);
                return sw.toString();
            }
        }
        return screenJS;
    }

    public static String loadScreen(String screenName, Locale locale) throws Exception {
        String screenFile;
        String screen = ScreenLoaderServlet.getDynamicScreen(screenName);
        if (screen == null && (screenFile = DataStructCache.getInstanceFile(screenName, "ui", "ui")) != null) {
            screen = ISCFile.newInstance(screenFile).getAsString();
        }
        if (screen != null) {
            StringWriter screenWriter = new StringWriter();
            XML.toJS("<isomorphicXML xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\">" + screen + "</isomorphicXML>", locale, (Writer)screenWriter);
            return ((Object)screenWriter).toString();
        }
        return null;
    }

    public static void addDynamicScreenGenerator(DynamicScreenGenerator dsg) {
        defaultDynamicScreenGenerator = dsg;
    }

    public static void addDynamicScreenGenerator(DynamicScreenGenerator dsg, String prefix) {
        dynamicScreenGenerators.put(prefix, dsg);
    }

    public static void addDynamicScreenGenerator(DynamicScreenGenerator dsg, Pattern regex) {
        dynamicScreenGenerators.put(regex, dsg);
    }

    public static DynamicScreenGenerator removeDynamicScreenGenerator() {
        DynamicScreenGenerator dsg = defaultDynamicScreenGenerator;
        defaultDynamicScreenGenerator = null;
        return dsg;
    }

    public static DynamicScreenGenerator removeDynamicScreenGenerator(String prefix) {
        if (dynamicScreenGenerators.containsKey(prefix)) {
            DynamicScreenGenerator dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(prefix);
            dynamicScreenGenerators.remove(prefix);
            return dsg;
        }
        return null;
    }

    public static DynamicScreenGenerator removeDynamicScreenGenerator(Pattern regex) {
        if (dynamicScreenGenerators.containsKey(regex)) {
            DynamicScreenGenerator dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(regex);
            dynamicScreenGenerators.remove(regex);
            return dsg;
        }
        return null;
    }

    public static void clearDynamicScreenGenerators() {
        defaultDynamicScreenGenerator = null;
        dynamicScreenGenerators.clear();
    }

    private static String getDynamicScreen(String id) {
        DynamicScreenGenerator dsg = null;
        for (Object keyObj : dynamicScreenGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicScreenGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        if (dsg == null) {
            dsg = defaultDynamicScreenGenerator;
        }
        String screen = null;
        if (dsg != null) {
            screen = dsg.getScreen(id);
        }
        return screen;
    }
}

