/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.JenkinsBuild;
import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.HttpUtil;
import com.isomorphic.util.SimpleHttpResponse;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;

public class Jenkins
extends Base {
    private static Logger log = new Logger(Jenkins.class.getName());
    public String baseURL = config.getString((Object)"jenkins.baseURL");
    public String username = config.getString((Object)"jenkins.username");
    public String password = config.getString((Object)"jenkins.password");

    public Jenkins() throws MalformedURLException {
        this.setBaseURL(this.baseURL);
    }

    public Jenkins(String baseURL, String username, String password) throws MalformedURLException {
        this.setBaseURL(baseURL);
        this.username = username;
        this.password = password;
    }

    public void setBaseURL(String baseURL) throws MalformedURLException {
        this.baseURL = baseURL;
    }

    public JenkinsBuild triggerBuild(String buildName) throws Exception {
        return this.triggerBuild(buildName, null, null);
    }

    public JenkinsBuild triggerBuild(String buildName, Map params) throws Exception {
        return this.triggerBuild(buildName, params, null);
    }

    public JenkinsBuild triggerBuild(String buildName, Map params, Map options) throws Exception {
        String jobURL = this.baseURL + "/job/" + buildName;
        if (params != null) {
            jobURL = jobURL + "/buildWithParameters";
        } else {
            params = new DataTypeMap();
            jobURL = jobURL + "/build";
        }
        SimpleHttpResponse httpResponse = this.httpPostWithCrumb(jobURL, params);
        if (!httpResponse.isSuccess()) {
            log.error((Object)("Failed to trigger build $buildName - at endpoint " + jobURL + " server said:" + httpResponse.getBodyAsString()));
            return null;
        }
        String queueURL = null;
        HeaderIterator hi = httpResponse.headerIterator("Location");
        if (hi.hasNext()) {
            Header h = (Header)hi.next();
            queueURL = h.getValue();
        }
        return new JenkinsBuild(this, buildName, queueURL);
    }

    public DataTypeMap jsonGet(String url) throws Exception {
        String responseBody;
        if (!url.contains("/api/json")) {
            url = url + "/api/json";
        }
        if ((responseBody = HttpUtil.httpGet((String)url).getBodyAsString()) == null) {
            return null;
        }
        Map m = (Map)JSTranslater.instance().fromJS(responseBody);
        if (m == null) {
            return null;
        }
        return new DataTypeMap(m);
    }

    protected SimpleHttpResponse httpPostWithCrumb(String url, Map params) throws Exception {
        return HttpUtil.httpPost((String)url, (Map)DataTools.buildMap((Object[])new Object[]{"params", params, "headers", this.addCrumbHeader(null), "username", this.username, "password", this.password}));
    }

    protected Map addCrumbHeader(Map headers) throws Exception {
        if (headers == null) {
            headers = new DataTypeMap();
        }
        String crumbURL = this.baseURL + "/crumbIssuer/api/xml?xpath=concat(//crumbRequestField,%22:%22,//crumb)";
        String crumbHeader = HttpUtil.httpGet((String)crumbURL, (Map)DataTools.buildMap((Object[])new Object[]{"numRetriesFileNotFound", new Integer(12), "username", this.username, "password", this.password})).getBodyAsString();
        if (crumbHeader == null) {
            throw new Exception("Couldn't obtain crumb - server returned: " + crumbHeader);
        }
        List s = DataTools.simpleSplit((String)crumbHeader, (String)":");
        if (s.size() != 2) {
            throw new Exception("Couldn't obtain crumb - server returned: " + crumbHeader);
        }
        String crumbRequestField = (String)s.get(0);
        String crumb = (String)s.get(1);
        headers.put(crumbRequestField, crumb);
        return headers;
    }
}

