/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Objects;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SafariOptions {
    public static final String CAPABILITY = "safari.options";
    private int port = 0;
    private boolean useCleanSession = false;

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            try {
                return SafariOptions.fromJsonMap((Map)cap);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
        return new SafariOptions();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUseCleanSession(boolean useCleanSession) {
        this.useCleanSession = useCleanSession;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getUseCleanSession() {
        return this.useCleanSession;
    }

    public JsonObject toJson() throws IOException {
        JsonObject options = new JsonObject();
        options.addProperty("port", (Number)this.port);
        options.addProperty("cleanSession", Boolean.valueOf(this.useCleanSession));
        return options;
    }

    private static SafariOptions fromJsonMap(Map<?, ?> options) throws IOException {
        Boolean useCleanSession;
        SafariOptions safariOptions = new SafariOptions();
        Number port = (Number)options.get("port");
        if (port != null) {
            safariOptions.setPort(port.intValue());
        }
        if ((useCleanSession = (Boolean)options.get("cleanSession")) != null) {
            safariOptions.setUseCleanSession(useCleanSession);
        }
        return safariOptions;
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.safari();
        capabilities.setCapability(CAPABILITY, this);
        return capabilities;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SafariOptions)) {
            return false;
        }
        SafariOptions that = (SafariOptions)other;
        return this.port == that.port && this.useCleanSession == that.useCleanSession;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.port, this.useCleanSession});
    }

    private static class Option {
        private static final String CLEAN_SESSION = "cleanSession";
        private static final String PORT = "port";

        private Option() {
        }
    }
}

