/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IExecutable;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ThreadTimer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ISCSystem
extends Base {
    public static final int NO_TIMEOUT = 0;
    private static final int POLL_DELAY = 50;
    private static Logger log = new Logger(ISCSystem.class.getName());
    String stdout;
    String stderr;
    Process process;
    int exitValue = 256;
    String command;
    int timeout;
    InputStream is;
    InputStream es;
    ProcessStreamReader stdoutThread;
    ProcessStreamReader stderrThread;
    ThreadTimer threadTimer;
    private PrintStream processStdin;

    public static ISCSystem execute(IExecutable theClass) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), 0);
    }

    public static ISCSystem execute(IExecutable theClass, String[] envp) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), envp, 0);
    }

    public static ISCSystem execute(IExecutable theClass, String[] envp, File dir) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), envp, dir, 0);
    }

    public static ISCSystem execute(IExecutable theClass, int timeout) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), timeout);
    }

    public static ISCSystem execute(IExecutable theClass, String[] envp, int timeout) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), envp, timeout);
    }

    public static ISCSystem execute(IExecutable theClass, String[] envp, File dir, int timeout) throws Exception {
        return ISCSystem.execute(theClass.getCommand(), envp, dir, timeout);
    }

    public static ISCSystem execute(String command) throws Exception {
        return ISCSystem.execute(command, 0);
    }

    public static ISCSystem execute(String command, String[] envp) throws Exception {
        return ISCSystem.execute(command, envp, 0);
    }

    public static ISCSystem execute(String command, String[] envp, File dir) throws Exception {
        return ISCSystem.execute(command, envp, dir, 0);
    }

    public static ISCSystem execute(String command, int timeout) throws Exception {
        return new ISCSystem().run(command, timeout);
    }

    public static ISCSystem execute(String command, String[] envp, int timeout) throws Exception {
        return new ISCSystem().run(command, envp, timeout);
    }

    public static ISCSystem execute(String command, String[] envp, File dir, int timeout) throws Exception {
        return new ISCSystem().run(command, envp, dir, timeout);
    }

    public static ISCSystem execute(String[] command) throws Exception {
        return ISCSystem.execute(command, 0);
    }

    public static ISCSystem execute(String[] command, String[] envp) throws Exception {
        return ISCSystem.execute(command, envp, 0);
    }

    public static ISCSystem execute(String[] command, String[] envp, File dir) throws Exception {
        return ISCSystem.execute(command, envp, dir, 0);
    }

    public static ISCSystem execute(String[] command, int timeout) throws Exception {
        return new ISCSystem().run(command, timeout);
    }

    public static ISCSystem execute(String[] command, String[] envp, int timeout) throws Exception {
        return new ISCSystem().run(command, envp, timeout);
    }

    public static ISCSystem execute(String[] command, String[] envp, File dir, int timeout) throws Exception {
        return new ISCSystem().run(command, envp, dir, timeout);
    }

    public ISCSystem run(String command, int timeout) throws Exception {
        return this.run(command, null, timeout);
    }

    public ISCSystem run(String command, String[] envp, int timeout) throws Exception {
        return this.run(command, null, null, timeout);
    }

    public ISCSystem run(String command, String[] envp, File dir, int timeout) throws Exception {
        return this.run(new String[]{"sh", "-c", command}, envp, dir, timeout);
    }

    public ISCSystem run(String[] command, int timeout) throws Exception {
        return this.run(command, null, timeout);
    }

    public ISCSystem run(String[] command, String[] envp, int timeout) throws Exception {
        return this.run(command, null, null, timeout);
    }

    public ISCSystem run(String[] command, String[] envp, File dir, int timeout) throws Exception {
        this.timeout = timeout;
        log.debug("executing command (" + (timeout == 0 ? "no" : timeout + "ms") + " timeout): " + Arrays.asList(command).toString());
        this.command = Arrays.toString(command);
        if (config.getBoolean((Object)"devenv", false)) {
            ArrayList<String> envList = new ArrayList<String>();
            String classpath = null;
            String devenvClasspath = null;
            HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
            for (String envVar : envMap.keySet()) {
                String envValue = (String)envMap.get(envVar);
                if (envVar.equals("DEVENV_CLASSPATH")) {
                    devenvClasspath = envValue;
                    continue;
                }
                if (envVar.equals("CLASSPATH")) {
                    classpath = envValue;
                    continue;
                }
                envList.add(envVar + "=" + envValue);
            }
            if (devenvClasspath != null) {
                envList.add("CLASSPATH=" + devenvClasspath);
            } else if (classpath != null) {
                envList.add("CLASSPATH=" + classpath);
            }
            if (envp == null) {
                envp = DataTools.listToStringArray(envList);
            } else {
                DataTools.listToStringArray(DataTools.addAll(DataTools.arrayToList(envp), envList));
            }
        }
        this.process = Runtime.getRuntime().exec(command, envp, dir);
        this.is = this.process.getInputStream();
        this.es = this.process.getErrorStream();
        this.stdoutThread = new ProcessStreamReader(this.process.getInputStream(), "STDOUT");
        this.stderrThread = new ProcessStreamReader(this.process.getErrorStream(), "STDERR");
        this.stdoutThread.start();
        this.stderrThread.start();
        return this;
    }

    public ISCSystem waitFor() throws Exception {
        try {
            if (this.timeout != 0) {
                this.threadTimer = new ThreadTimer(Thread.currentThread(), this.timeout);
                this.threadTimer.start();
            }
            this.exitValue = this.process.waitFor();
            if (this.threadTimer != null) {
                this.threadTimer.cancelInterrupt();
                this.threadTimer = null;
            }
            ThreadTimer outputTimer = new ThreadTimer(Thread.currentThread(), 250);
            outputTimer.start();
            this.stdoutThread.join();
            this.stderrThread.join();
            outputTimer.cancelInterrupt();
        }
        catch (InterruptedException e) {
            this.process.destroy();
            if (this.threadTimer != null) {
                throw new Exception("Timed out (" + this.timeout + "ms) and killed process while executing command: " + this.command);
            }
            log.warn("Process failed to properly close one of its output streams after exiting.  This can happen if it spawned a background process that writes to the parent process output stream(s).  In order to not leak memory, the parent process will be terminated which will cause the child to have at least one of its output streams closed which may or may not adversely affect its execution. Command that caused this error: " + this.command);
        }
        finally {
            if (this.threadTimer != null) {
                this.threadTimer.cancelInterrupt();
            }
            this.stdout = this.stdoutThread.getString();
            this.stderr = this.stderrThread.getString();
        }
        return this;
    }

    public void terminate() throws Exception {
        if (this.process == null) {
            return;
        }
        try {
            this.process.destroy();
            ThreadTimer outputTimer = new ThreadTimer(Thread.currentThread(), 250);
            outputTimer.start();
            this.stdoutThread.join();
            this.stderrThread.join();
            outputTimer.cancelInterrupt();
        }
        finally {
            if (this.threadTimer != null) {
                this.threadTimer.cancelInterrupt();
            }
            this.stdout = this.stdoutThread.getString();
            this.stderr = this.stderrThread.getString();
        }
    }

    public int exitValue() {
        return this.exitValue;
    }

    public Process getProcess() {
        return this.process;
    }

    public PrintStream getProcessStdin() {
        if (this.processStdin == null) {
            this.processStdin = new PrintStream(this.process.getOutputStream(), true);
        }
        return this.processStdin;
    }

    public String getStdout() throws Exception {
        return this.stdout == null ? this.stdoutThread.getString() : this.stdout;
    }

    public String getStderr() throws Exception {
        return this.stderr == null ? this.stderrThread.getString() : this.stderr;
    }

    public String getFormattedErrorString() throws Exception {
        return "\ncommand: " + this.command + "exited with error code: " + this.exitValue() + "\nSTDOUT:\n-------------" + this.getStdout() + "\nSTDERR:\n-------------" + this.getStderr();
    }

    private static class ProcessStreamReader
    extends Thread {
        StringWriter sw = new StringWriter();
        String name;
        InputStream is;

        public ProcessStreamReader(InputStream is, String name) {
            this.is = is;
            this.name = name;
        }

        @Override
        public void run() {
            try {
                IOUtil.copyCharacterStreams((Reader)new InputStreamReader(this.is), (Writer)this.sw, false);
            }
            catch (IOException ioe) {
                log.debug((Object)("Failure to read stream: " + this.name), ioe);
            }
            log.debug("Thread reader done for stream: " + this.name);
        }

        public String getString() {
            return this.sw.toString();
        }
    }
}

