/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.HttpServletRequestParser;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RESTHandler;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RestRequestParser
implements HttpServletRequestParser {
    private Logger log = new Logger(this.getClass().getCanonicalName());
    public static final String ISC_META_DATA_PREFIX_PARAMETER_NAME = "isc_metaDataPrefix";
    public static final String DEFAULT_ISC_META_DATA_PREFIX = "_";
    private static final String DEFAULT_JSON_PREFIX = "<SCRIPT>//'\"]]>>isc_JSONResponseStart>>";
    private static final String DEFAULT_JSON_SUFFIX = "//isc_JSONResponseEnd";
    private static final Set<String> hybridModeReservedParams = new HashSet<String>(Arrays.asList("criteria", "sortBy", "startRow", "endRow", "textMatchStyle"));
    private String defaultDataFormat = "xml";
    private Boolean wrapJSONResponses = Boolean.TRUE;
    private String jsonPrefix;
    private String jsonSuffix;
    private DSResponse errorResponse;
    private Boolean hybridModeDefault;
    private String dynamicDataFormatParamName;
    SimpleDateFormat xmlSchemaDatetime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    SimpleDateFormat xmlSchemaDatetimeTZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    SimpleDateFormat xmlSchemaDatetimeMillis = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    SimpleDateFormat xmlSchemaDatetimeMillisTZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    SimpleDateFormat xmlSchemaDate = new SimpleDateFormat("yyyy-MM-dd");

    public DSResponse getErrorResponse() {
        return this.errorResponse;
    }

    public Boolean getHybridModeDefault() {
        return this.hybridModeDefault;
    }

    public void setHybridModeDefault(Boolean rawRestHybridMode) {
        this.hybridModeDefault = rawRestHybridMode;
    }

    public String getDefaultDataFormat() {
        return this.defaultDataFormat;
    }

    public void setDefaultDataFormat(String defaultDataFormat) {
        if (!"xml".equalsIgnoreCase(defaultDataFormat) && !"json".equalsIgnoreCase(defaultDataFormat)) {
            throw new IllegalArgumentException("Accepted values: xml, json. Passed value:" + defaultDataFormat);
        }
        this.defaultDataFormat = defaultDataFormat.toLowerCase();
    }

    public void setDynamicDataFormatParamName(String dynamicDataFormatParamName) {
        this.dynamicDataFormatParamName = dynamicDataFormatParamName;
    }

    public Boolean getWrapJSONResponses() {
        return this.wrapJSONResponses;
    }

    public void setWrapJSONResponses(Boolean wrapJSONResponses) {
        this.wrapJSONResponses = wrapJSONResponses;
    }

    public String getJSONPrefix() {
        return this.jsonPrefix;
    }

    public String getJSONSuffix() {
        return this.jsonPrefix;
    }

    public void setJSONPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setJSONSuffix(String jsonSuffix) {
        this.jsonSuffix = jsonSuffix;
    }

    private DSRequest createRestDSRequest(RPCManager rpc, Map reqProps, String dataFormat) throws Exception {
        DSRequest dsReq = new DSRequest(reqProps, rpc.getContext(), rpc);
        dsReq.setREST(Boolean.TRUE);
        dsReq.setDataFormat(dataFormat);
        dsReq.setWrapJSONResponses(this.getWrapJSONResponses());
        return dsReq;
    }

    public RestRequestParser() {
    }

    public RestRequestParser(String defaultDataFormat, String dynamicDataFormatParamName) {
        this.setDefaultDataFormat(defaultDataFormat);
        this.setDynamicDataFormatParamName(dynamicDataFormatParamName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parseRequest(RPCManager rpc, HttpServletRequest req) throws Exception {
        ISCHttpServletRequest request;
        String[] additionalSegments;
        String hybridModeParam;
        Map reqProps = null;
        String dataFormat = req.getParameter(this.dynamicDataFormatParamName);
        if (dataFormat == null) {
            dataFormat = this.getDefaultDataFormat();
        }
        Boolean hybridMode = (hybridModeParam = req.getParameter("hybridMode")) == null ? this.getHybridModeDefault() : Boolean.valueOf(hybridModeParam);
        boolean isRawREST = RESTHandler.isRawREST(req);
        String extraPath = RESTHandler.getExtraPath(req);
        String[] stringArray = additionalSegments = isRawREST ? extraPath.substring(1).split("/") : null;
        if (!isRawREST) {
            hybridMode = false;
        }
        if ((request = rpc.getContext().request).isMultipart()) {
            reqProps = request.getStringParams();
            String t = (String)reqProps.get("_transaction");
            if (t != null) {
                ValidationContext vc = new ValidationContext();
                vc.setRestrictedXMLMode(true);
                Object to = XML.toDSRecords(new StringReader(t), vc);
                vc.freeResources();
                reqProps.put("transaction", to);
                rpc.setJsCallback((String)((Map)to).get("jscallback"));
            }
        } else {
            Object reqPropsObj;
            String js = "";
            String contentType = req.getContentType();
            if (contentType == null || !contentType.contains("application/x-www-form-urlencoded")) {
                js = IOUtil.readerToString(req.getReader()).trim();
            }
            if (js.length() > 0) {
                if ("xml".equals(dataFormat)) {
                    this.log.debug("Parsing xml object: '" + js + "'");
                    ValidationContext vc = new ValidationContext();
                    vc.setRestrictedXMLMode(true);
                    reqPropsObj = XML.toDSRecords(new StringReader(js), vc);
                    vc.freeResources();
                } else {
                    JSTranslater jst = JSTranslater.get();
                    jst.preserveLiteralNulls(true);
                    this.log.debug("Parsing json object: '" + js + "'");
                    reqPropsObj = jst.fromJS(js);
                }
            } else {
                reqProps = request.getStringParams();
                reqPropsObj = reqProps;
                String t = (String)reqProps.get("_transaction");
                if (t != null) {
                    ValidationContext validationContext = new ValidationContext();
                    validationContext.setRestrictedXMLMode(true);
                    Object to = XML.toDSRecords(new StringReader(t), validationContext);
                    validationContext.freeResources();
                    reqProps.put("transaction", to);
                    rpc.setJsCallback((String)((Map)to).get("jscallback"));
                }
            }
            if (!(reqPropsObj instanceof Map)) {
                throw new Exception("Invalid request format: " + (reqPropsObj == null ? "null" : reqPropsObj.getClass().getName()));
            }
            reqProps = reqPropsObj;
        }
        try {
            boolean isQueue = false;
            List<Map> queue = null;
            Map trx = (Map)reqProps.get("transaction");
            if (trx != null) {
                isQueue = true;
                queue = (ArrayList<Map>)trx.get("operations");
            } else if (reqProps.get("operations") instanceof Map) {
                Map operations = (Map)reqProps.get("operations");
                if (operations.get("request") instanceof List) {
                    queue = (List)operations.get("request");
                } else if (operations.get("request") instanceof Map) {
                    queue = new ArrayList();
                    queue.add((Map)operations.get("request"));
                }
            } else {
                queue = new ArrayList<Map>();
                queue.add(reqProps);
            }
            if (queue == null) {
                throw new Exception("Fail: The request doesn't look like a single request, and it doesn't look like a queue either!");
            }
            for (Object e : queue) {
                String metaDataPrefix;
                Map<String, ArrayList<Object>> data;
                Object dsName;
                void var15_22;
                if (e instanceof String) {
                    JSTranslater jst = JSTranslater.get();
                    jst.preserveLiteralNulls(true);
                    Object object = jst.fromJS((String)e);
                }
                reqProps = (Map)var15_22;
                if ("xml".equals(dataFormat) && (dsName = reqProps.get("dataSource")) != null && (data = (Map<String, ArrayList<Object>>)reqProps.get("data")) instanceof Map && data.containsKey(dsName)) {
                    Object dsData = ((Map)data).get(dsName);
                    ((Map)data).remove(dsName);
                    if (dsData == null) {
                        reqProps.put("data", new HashMap());
                    } else {
                        reqProps.put("data", dsData);
                    }
                }
                Object dataObj = reqProps.get("data");
                data = null;
                if (dataObj instanceof Map) {
                    data = (HashMap<String, String>)dataObj;
                }
                if (data == null) {
                    data = new HashMap<String, String>();
                }
                if ((metaDataPrefix = req.getParameter(ISC_META_DATA_PREFIX_PARAMETER_NAME)) == null) {
                    metaDataPrefix = DEFAULT_ISC_META_DATA_PREFIX;
                }
                boolean advancedCriteria = false;
                Enumeration parameterNames = req.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String[] values;
                    String parameterName = (String)parameterNames.nextElement();
                    this.log.debug("Parameter:'" + parameterName + "'. Value:'" + req.getParameter(parameterName) + "'.");
                    if (ISC_META_DATA_PREFIX_PARAMETER_NAME.equals(parameterName) || this.dynamicDataFormatParamName.equals(parameterName) || hybridMode.booleanValue() && hybridModeReservedParams.contains(parameterName) || "hybridMode".equals(parameterName)) continue;
                    if (parameterName.equals("_constructor")) {
                        String constructor = req.getParameter(parameterName);
                        if (!"AdvancedCriteria".equals(constructor)) continue;
                        advancedCriteria = true;
                        data.put(parameterName, (ArrayList<Object>)((Object)constructor));
                        continue;
                    }
                    if (parameterName.startsWith(metaDataPrefix)) {
                        String realParameterName = parameterName.substring(metaDataPrefix.length());
                        reqProps.put(realParameterName, req.getParameter(parameterName));
                        continue;
                    }
                    if ("criteria".equals(parameterName)) {
                        values = req.getParameterValues(parameterName);
                        for (int i = 0; i < values.length; ++i) {
                            Object critObj = JSTranslater.get().fromJS(values[i]);
                            if (critObj instanceof Map) {
                                if (values.length == 1) {
                                    data = (Map)critObj;
                                    continue;
                                }
                                ArrayList<Object> subCriteria = (ArrayList<Object>)data.get("criteria");
                                if (subCriteria == null) {
                                    subCriteria = new ArrayList<Object>();
                                    data.put("criteria", subCriteria);
                                }
                                subCriteria.add(critObj);
                                continue;
                            }
                            throw new Exception("Invalid criteria object: " + DataTools.prettyPrint(critObj) + " - must be an object literal");
                        }
                        continue;
                    }
                    if ("summaryFunctions".equals(parameterName)) {
                        String[] summaryFunctionValues;
                        LinkedHashMap summaryFunctions = new LinkedHashMap();
                        for (String summaryfunctionAsJsonString : summaryFunctionValues = req.getParameterValues(parameterName)) {
                            Object jsObject = JSTranslater.get().fromJS(summaryfunctionAsJsonString);
                            if (!(jsObject instanceof Map)) continue;
                            summaryFunctions.putAll((Map)jsObject);
                        }
                        reqProps.put("summaryFunctions", summaryFunctions);
                        continue;
                    }
                    if ("groupBy".equals(parameterName)) {
                        String[] groupByValues = req.getParameterValues(parameterName);
                        reqProps.put("groupBy", new LinkedList<String>(Arrays.asList(groupByValues)));
                        continue;
                    }
                    if ("sortBy".equals(parameterName)) {
                        String[] sortByValues = req.getParameterValues(parameterName);
                        reqProps.put("sortBy", new LinkedList<String>(Arrays.asList(sortByValues)));
                        continue;
                    }
                    values = req.getParameterValues(parameterName);
                    if (values.length > 1) {
                        ArrayList<Object> critValues = new ArrayList<Object>();
                        for (int i = 0; i < values.length; ++i) {
                            critValues.add(JSTranslater.get().fromJS(values[i]));
                        }
                        data.put(parameterName, critValues);
                        continue;
                    }
                    data.put(parameterName, (ArrayList<Object>)((Object)req.getParameter(parameterName)));
                }
                String pk = null;
                HashMap primaryKeyMap = null;
                Object critFromParam = null;
                if (isRawREST) {
                    try {
                        String dsName2 = additionalSegments[0];
                        DataSource ds = DataSourceManager.get(dsName2);
                        if (ds == null && dsName2.equals(dsName2.toLowerCase()) && (ds = DataSourceManager.get(dsName2 = dsName2.toUpperCase())) == null) {
                            dsName2 = dsName2.toLowerCase();
                        }
                        reqProps.put("dataSource", dsName2);
                        String opId = null;
                        String opType = null;
                        String fieldNamePK = null;
                        if (ds != null) {
                            Object criteriaParam;
                            if (additionalSegments.length > 1 && additionalSegments[1] != null) {
                                opType = additionalSegments[1];
                            }
                            if ("fetch".equalsIgnoreCase(opType) || "add".equalsIgnoreCase(opType) || "update".equalsIgnoreCase(opType) || "remove".equalsIgnoreCase(opType)) {
                                if (additionalSegments.length > 2 && additionalSegments[2] != null) {
                                    opId = additionalSegments[2];
                                }
                            } else {
                                pk = opType;
                                opType = null;
                            }
                            fieldNamePK = null;
                            primaryKeyMap = new HashMap();
                            List<DSField> listDSFields = ds.getFields();
                            for (int i = 0; i < listDSFields.size(); ++i) {
                                DSField dsf = listDSFields.get(i);
                                String columnName = dsf.getName();
                                Object value = reqProps.get(columnName);
                                if (value != null) {
                                    data.put(columnName, (ArrayList<Object>)value);
                                    if (dsf.isPrimaryKey()) {
                                        primaryKeyMap.put(columnName, value);
                                    }
                                }
                                if (!dsf.isPrimaryKey()) continue;
                                fieldNamePK = columnName;
                            }
                            if (hybridMode.booleanValue() && (criteriaParam = reqProps.get("criteria")) != null && criteriaParam instanceof String) {
                                critFromParam = JSTranslater.get().fromJS((String)criteriaParam);
                            }
                        } else {
                            this.setErrorResponse(rpc, reqProps, 404, "DataSource '" + dsName2 + "' is invalid. Can't continue", dataFormat);
                            return;
                        }
                        if (pk != null) {
                            if (data.isEmpty()) {
                                data.put(fieldNamePK, (ArrayList<Object>)((Object)pk));
                            }
                            primaryKeyMap.put(fieldNamePK, pk);
                        }
                        if (!primaryKeyMap.isEmpty()) {
                            this.convertStringsToSchemaType(primaryKeyMap, ds);
                        }
                        String httpMethod = request.getMethod();
                        if (opType != null) {
                            reqProps.put("operationType", opType);
                            if (opId != null) {
                                reqProps.put("operationId", opId);
                            }
                        } else if ("GET".equals(httpMethod)) {
                            reqProps.put("operationType", "fetch");
                        } else if ("DELETE".equals(httpMethod)) {
                            reqProps.put("operationType", "remove");
                        } else if ("POST".equals(httpMethod)) {
                            reqProps.put("operationType", "add");
                        } else if ("PATCH".equals(httpMethod)) {
                            reqProps.put("operationType", "update");
                        } else if ("PUT".equals(httpMethod)) {
                            opType = primaryKeyMap.size() == 0 ? "add" : "update";
                            reqProps.put("operationType", opType);
                        }
                    }
                    catch (Exception e2) {
                        this.setErrorResponse(rpc, reqProps, 500, "An error occurred while parsing simplified URLs:", dataFormat, e2);
                        return;
                    }
                }
                reqProps.put("data", data);
                if (reqProps.get("dataSource") == null) {
                    throw new Exception("The DataSource ID was missing from the request.");
                }
                DataSource ds = DataSourceManager.get((String)reqProps.get("dataSource"), null);
                String opType = (String)reqProps.get("operationType");
                if ("add".equals(opType) || "saveFile".equals(opType) || "getFile".equals(opType) || "hasFile".equals(opType) || "renameFile".equals(opType) || "removeFile".equals(opType)) {
                    DataTools.mapMerge(primaryKeyMap, data);
                    reqProps.put("values", data);
                } else if ("fetch".equals(opType) || "viewFile".equals(opType) || "listFiles".equals(opType)) {
                    DataTools.mapMerge(primaryKeyMap, data);
                    reqProps.put("criteria", data);
                } else if (primaryKeyMap != null && !primaryKeyMap.isEmpty()) {
                    reqProps.put("values", data);
                    reqProps.put("criteria", primaryKeyMap);
                } else {
                    reqProps.put("values", data);
                    Map criteria = new HashMap();
                    if (ds != null) {
                        for (String fieldName : data.keySet()) {
                            DSField field = ds.getField(fieldName);
                            if (field == null || !field.isPrimaryKey()) continue;
                            criteria.put(fieldName, data.get(fieldName));
                        }
                    }
                    if (criteria.isEmpty()) {
                        criteria = data;
                    }
                    reqProps.put("criteria", criteria);
                }
                Boolean singularResponse = true;
                if (isRawREST) {
                    if ("fetch".equals(opType)) {
                        singularResponse = pk != null;
                    } else if ("update".equals(opType) || "remove".equals(opType)) {
                        singularResponse = primaryKeyMap.size() != 0;
                    }
                    if (hybridMode.booleanValue()) {
                        Object sortByFromParam;
                        String sortByParam;
                        Object builtCriteria = reqProps.get("criteria");
                        if (critFromParam != null) {
                            if (builtCriteria == null || !(critFromParam instanceof Map) || !(builtCriteria instanceof Map) || ((Map)builtCriteria).isEmpty()) {
                                builtCriteria = critFromParam;
                            } else {
                                DataTools.mapMerge((Map)critFromParam, (Map)builtCriteria);
                            }
                            if (builtCriteria instanceof Map) {
                                this.convertStringsToSchemaType((Map)builtCriteria, ds);
                            }
                            reqProps.put("criteria", builtCriteria);
                        }
                        if ((sortByParam = (String)reqProps.get("sortBy")) != null && sortByParam.indexOf("[") >= 0 && (sortByFromParam = JSTranslater.get().fromJS(sortByParam)) != null) {
                            reqProps.put("sortBy", sortByFromParam);
                        }
                    }
                }
                this.convertStringsToSchemaType(data, ds);
                HashMap opConfig = new HashMap();
                opConfig.put("operationType", reqProps.get("operationType"));
                opConfig.put("dataSource", reqProps.get("dataSource"));
                if (reqProps.get("textMatchStyle") != null) {
                    opConfig.put("textMatchStyle", reqProps.get("textMatchStyle"));
                }
                reqProps.put("operationConfig", opConfig);
                if (reqProps.get("operationId") != null) {
                    reqProps.put("operation", reqProps.get("operationId"));
                } else {
                    reqProps.put("operation", reqProps.get("dataSource") + DEFAULT_ISC_META_DATA_PREFIX + reqProps.get("operationType"));
                }
                DSRequest dsReq = this.createRestDSRequest(rpc, reqProps, dataFormat);
                if (isRawREST && !hybridMode.booleanValue()) {
                    dsReq.setRawREST(Boolean.TRUE);
                    dsReq.setParameter("singularResponse", singularResponse);
                }
                if (ds != null) {
                    String dsJSONPrefix = (String)ds.getConfig().get("jsonPrefix");
                    if (dsJSONPrefix != null) {
                        dsReq.setJsonPrefix(dsJSONPrefix);
                    } else if (this.jsonPrefix != null) {
                        dsReq.setJsonPrefix(this.jsonPrefix);
                    } else {
                        dsReq.setJsonPrefix(DEFAULT_JSON_PREFIX);
                    }
                    String dsJSONSuffix = (String)ds.getConfig().get("jsonSuffix");
                    if (dsJSONSuffix != null) {
                        dsReq.setJsonSuffix(dsJSONSuffix);
                    } else if (this.jsonSuffix != null) {
                        dsReq.setJsonSuffix(this.jsonSuffix);
                    } else {
                        dsReq.setJsonSuffix(DEFAULT_JSON_SUFFIX);
                    }
                } else {
                    if (this.jsonPrefix != null) {
                        dsReq.setJsonPrefix(this.jsonPrefix);
                    } else {
                        dsReq.setJsonPrefix(DEFAULT_JSON_PREFIX);
                    }
                    if (this.jsonSuffix != null) {
                        dsReq.setJsonSuffix(this.jsonSuffix);
                    } else {
                        dsReq.setJsonSuffix(DEFAULT_JSON_SUFFIX);
                    }
                }
                rpc.addRequest(dsReq);
            }
        }
        catch (Exception e) {
            if (isRawREST && !hybridMode.booleanValue()) {
                this.setErrorResponse(rpc, reqProps, 500, "Unable to parse the request: ", dataFormat, e);
            }
            throw e;
        }
        catch (Error e) {
            if (isRawREST && !hybridMode.booleanValue()) {
                this.setErrorResponse(rpc, new HashMap(), 500, "Unable to parse the request: ", dataFormat, e);
            }
            throw e;
        }
    }

    public void setErrorResponse(RPCManager rpc, Map reqProps, int errorCode, String errorMessage, String dataFormat) throws Exception {
        this.setErrorResponse(rpc, reqProps, errorCode, errorMessage, dataFormat, null);
    }

    public void setErrorResponse(RPCManager rpc, Map reqProps, int statusCode, String errorMessage, String dataFormat, Throwable t) throws Exception {
        reqProps.put("operation", "failed");
        DSRequest dsReq = this.createRestDSRequest(rpc, reqProps, dataFormat);
        dsReq.setRawREST(Boolean.TRUE);
        rpc.addRequest(dsReq);
        if (t == null) {
            this.log.warn(errorMessage);
        } else {
            this.log.error((Object)errorMessage, t);
            errorMessage = errorMessage + t.getMessage();
        }
        rpc.setRawRestStatus(statusCode);
        this.errorResponse = new RawRestErrorResponse(errorMessage);
    }

    protected void convertStringsToSchemaType(Map props, DataSource ds) {
        Map criteriaMap;
        if (props == null) {
            return;
        }
        if (!(ds instanceof BasicDataSource)) {
            this.log.warn("parseOutCriteria: " + (ds == null ? "'null'" : ds.getName()) + " is not a BasicDataSource, cannot continue");
            return;
        }
        BasicDataSource bds = (BasicDataSource)ds;
        Object criteria = props.get("criteria");
        if (criteria instanceof Map && (criteriaMap = (Map)criteria).size() == 1 && criteriaMap.get("criterion") != null) {
            Object crit = criteriaMap.get("criterion");
            if (crit instanceof List) {
                props.put("criteria", crit);
            } else {
                ArrayList list = new ArrayList();
                list.add(crit);
                props.put("criteria", list);
            }
        }
        if ((criteria = props.get("criteria")) instanceof List) {
            List criteriaList = (List)criteria;
            for (int i = 0; i < criteriaList.size(); ++i) {
                String baseType;
                DSField field;
                Object crit = criteriaList.get(i);
                if (!(crit instanceof Map)) continue;
                Map critMap = (Map)crit;
                this.convertStringsToSchemaType((Map)criteriaList.get(i), ds);
                String fieldName = (String)critMap.get("fieldName");
                if (fieldName == null || (field = bds.getField(fieldName)) == null) continue;
                try {
                    baseType = bds.getSimpleBaseType(field.getType());
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error during getSimpleBaseType call", e);
                    return;
                }
                this.convertValueToSchemaType(fieldName, baseType, critMap, true);
            }
        }
        if (!props.containsKey("criteria")) {
            HashSet keys = new HashSet(props.keySet());
            for (String fieldName : keys) {
                String baseType;
                DSField field;
                if (fieldName == null || (field = bds.getField(fieldName)) == null) continue;
                try {
                    baseType = bds.getSimpleBaseType(field.getType());
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error during getSimpleBaseType call", e);
                    return;
                }
                this.convertValueToSchemaType(fieldName, baseType, props, false);
            }
        }
    }

    private void convertValueToSchemaType(String fieldName, String baseType, Map critMap, boolean isAdvanced) {
        ArrayList values = null;
        boolean wasMultiple = false;
        String keyName = isAdvanced ? "value" : fieldName;
        Object valueObj = critMap.get(keyName);
        if (valueObj instanceof List) {
            values = (ArrayList)valueObj;
            wasMultiple = true;
        } else {
            values = new ArrayList();
            values.add(valueObj);
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < values.size(); ++i) {
            Object converted;
            block19: {
                converted = values.get(i);
                if (converted instanceof String) {
                    String value = (String)converted;
                    if ("date".equals(baseType)) {
                        String dateValue = value;
                        try {
                            if (dateValue.length() == 19 || dateValue.length() == 23) {
                                dateValue = dateValue + "-0000";
                            }
                            if (dateValue.length() == 24) {
                                converted = this.xmlSchemaDatetimeTZ.parse(dateValue);
                                break block19;
                            }
                            converted = this.xmlSchemaDatetimeMillisTZ.parse(dateValue);
                        }
                        catch (ParseException pe) {
                            try {
                                converted = this.xmlSchemaDate.parse(dateValue);
                            }
                            catch (ParseException pe2) {
                                this.log.warn("Parse failure attempting to parse a date for field " + fieldName + " in criteria.  String value was '" + dateValue + "'.  Values for date fields should be sent in XML Schema format - eg '2006-08-03T11:27:17'");
                            }
                        }
                    } else if ("boolean".equals(baseType)) {
                        converted = DataTools.parseBoolean(value);
                    } else if ("integer".equals(baseType)) {
                        converted = new Long(value);
                    } else if ("float".equals(baseType)) {
                        converted = new Double(value);
                    }
                }
            }
            result.add(i, converted);
        }
        if (wasMultiple) {
            critMap.put(keyName, result);
        } else {
            critMap.put(keyName, result.get(0));
        }
    }

    public class RawRestErrorResponse
    extends DSResponse {
        public RawRestErrorResponse(String errorMessage) {
            this.setData(errorMessage);
            this.setStatus(-1);
        }
    }
}

