/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.ConfigLoader;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.lang.StringUtils;

public class Config
extends DataTypeMap {
    private static Logger log = new Logger(Config.class.getName());
    public static List loadedConfigFiles = new ArrayList();
    protected static Config globalConfig = null;
    public Map cache = new ConcurrentHashMap();
    protected boolean doInterpolate = true;
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("(?<!\\\\)(?:(?:\\$ENV\\{)|(?:\\$\\{ENV:))([^}{]+)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("(?<!\\\\)\\$\\{([^}{]+)\\}");
    private static final Pattern BARE_VAR_PATTERN = Pattern.compile("(?<!\\\\)\\$(?!ENV)([\\w.]+)");
    private static final Pattern JNDI_PATTERN = Pattern.compile("(?<!\\\\)jndi\\:([^:]+):([^:]+)?:(\\S+)");
    private static final Pattern REF_ESCAPE_PATTERN = Pattern.compile("\\\\\\$");
    private static PathExpansionVariable[] pathExpansionVariables = null;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static Config getGlobal(boolean initIfNull) {
        if (globalConfig == null && initIfNull) {
            try {
                Config.initGlobalConfig(false);
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return globalConfig;
    }

    public static Config getGlobal() {
        return Config.getGlobal(true);
    }

    public static Object getProperty(String propertyName) {
        return Config.getGlobal().get(propertyName);
    }

    public static synchronized Config initGlobalConfig() throws Exception {
        return Config.initGlobalConfig(true);
    }

    public static synchronized Config initGlobalConfig(boolean reloadConfig) throws Exception {
        if (!reloadConfig && globalConfig != null) {
            return globalConfig;
        }
        globalConfig = new Config();
        new ConfigLoader().loadConfig(globalConfig);
        Config setPropertyMap = globalConfig.getSubtree("system.setProperty");
        for (String property : setPropertyMap.keySet()) {
            String value = (String)setPropertyMap.get(property);
            log.info("Applying system property " + property + ": " + value);
            System.setProperty(property, value);
        }
        return globalConfig;
    }

    public static Properties buildProperties(Map map) {
        return (Properties)DataTools.mapMerge(map, new Properties());
    }

    public void load(ISCFile iscFile) throws IOException {
        this.load(iscFile.getInputStream());
    }

    public void load(String fileName) throws IOException {
        this.load(ISCFile.newInstance(fileName));
    }

    public void load(InputStream is) throws IOException {
        this.putAll(ConfigLoader.load(is));
    }

    public void setInterpolation(boolean value) {
        this.doInterpolate = value;
    }

    public Config clone() {
        return new Config(this.map);
    }

    public Config() {
        this((Map)new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config(Map data) {
        Map map = data;
        synchronized (map) {
            this.map = new ConcurrentHashMap(data){

                @Override
                public Object remove(Object key) {
                    Object value = this.get(key);
                    super.remove(key);
                    Config.this.clearCache();
                    return value;
                }

                @Override
                public Object put(Object key, Object value) {
                    Object oldValue = this.get(key);
                    super.put(key, value);
                    Config.this.clearCache();
                    return oldValue;
                }

                @Override
                public void putAll(Map map) {
                    super.putAll(map);
                    Config.this.clearCache();
                }

                @Override
                public void clear() {
                    super.clear();
                    Config.this.clearCache();
                }
            };
        }
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public Object get(Object key) {
        return this.get(key, true);
    }

    public Object get(Object key, boolean removeBackslashEscapeChars) {
        if (key == null) {
            return null;
        }
        Object value = null;
        if (removeBackslashEscapeChars && (value = (Object)this.cache.get(key)) != null) {
            return value;
        }
        value = super.get(key);
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            try {
                if (this.doInterpolate) {
                    value = this.interpolate(value.toString());
                }
                if (removeBackslashEscapeChars) {
                    value = REF_ESCAPE_PATTERN.matcher(value.toString()).replaceAll("\\$");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (value != null && removeBackslashEscapeChars) {
            this.cache.put(key, value);
        }
        return value;
    }

    protected Object interpolate(Object value) throws Exception {
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        return value;
    }

    protected String interpolate(String value) throws Exception {
        boolean matched;
        if (value == null) {
            return null;
        }
        do {
            String interpolatedValue;
            Object interpolatedValueObj;
            String varName;
            matched = false;
            Matcher matcher = ENV_VAR_PATTERN.matcher(value);
            if (matcher.reset(value).find()) {
                matched = true;
                String envRef = matcher.group(1);
                String envVarName = null;
                String defaultValue = null;
                int commaIndex = envRef.indexOf(",");
                if (commaIndex != -1) {
                    envVarName = envRef.substring(0, commaIndex).trim();
                    defaultValue = envRef.substring(commaIndex + 1).trim();
                } else {
                    envVarName = envRef;
                }
                String envVarValue = System.getenv(envVarName);
                if (envVarValue == null && defaultValue != null) {
                    envVarValue = defaultValue;
                }
                if (envVarValue == null) {
                    throw new Exception("$ENV directive: " + value + " references undefined env var and does not specify a default");
                }
                value = matcher.replaceFirst(Matcher.quoteReplacement(envVarValue));
            }
            matcher.usePattern(VAR_PATTERN);
            if (matcher.reset(value).find()) {
                matched = true;
                varName = matcher.group(1);
                interpolatedValueObj = this.get(varName, false);
                if (interpolatedValueObj == null) {
                    throw new Exception("variable expansion failed for variable: " + varName);
                }
                interpolatedValue = interpolatedValueObj.toString();
                value = matcher.replaceFirst(Matcher.quoteReplacement(interpolatedValue));
            }
            matcher.usePattern(BARE_VAR_PATTERN);
            if (matcher.reset(value).find()) {
                matched = true;
                varName = matcher.group(1);
                interpolatedValueObj = this.get(varName, false);
                if (interpolatedValueObj == null) {
                    throw new Exception("variable expansion failed for variable: " + varName);
                }
                interpolatedValue = interpolatedValueObj.toString();
                value = matcher.replaceFirst(Matcher.quoteReplacement(interpolatedValue));
            }
            matcher.usePattern(JNDI_PATTERN);
            if (!matcher.reset(value).find()) continue;
            matched = true;
            String contextName = this.interpolate(matcher.group(1));
            String jndiKey = this.interpolate(matcher.group(2));
            String keyContext = this.interpolate(matcher.group(3));
            Context ctx = JNDI.bindConfiguredContext(contextName);
            String interpolatedValue2 = "";
            if (ctx instanceof DirContext) {
                Attributes attrs = ((DirContext)ctx).getAttributes(keyContext, new String[]{jndiKey});
                Attribute attr = null;
                if (attrs != null) {
                    attr = attrs.get(jndiKey);
                }
                if (attrs == null || attr == null) {
                    throw new Exception("unable to resolve jndi reference: " + value + " - lookup failed for key: " + jndiKey);
                }
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    interpolatedValue2 = interpolatedValue2 + ne.next().toString();
                    if (!ne.hasMore()) continue;
                    interpolatedValue2 = interpolatedValue2 + ",";
                }
            } else {
                throw new Exception("Resolved context type: " + ctx.getClass().getName() + " is not supported.");
            }
            value = matcher.replaceFirst(Matcher.quoteReplacement(interpolatedValue2));
        } while (matched);
        return value;
    }

    public Config getConfigBlock(String key) {
        return new Config(DataTools.getPrefixed(key, (Map)((Object)this)));
    }

    public Config getSubtree(String key) {
        return new Config(DataTools.getSubtreePrefixed(key, (Map)((Object)this)));
    }

    public void clearSubtree(String key) {
        DataTools.clearSubtreePrefixed(key, this);
    }

    public void putSubtree(String key, Map subTree) {
        for (String subKey : subTree.keySet()) {
            this.put(key + "." + subKey, subTree.get(subKey));
        }
    }

    public Properties asProperties() {
        return Config.buildProperties((Map)((Object)this));
    }

    public void setIfNull(Object key, Object value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    public Object getClassInstance(String key) throws Exception {
        if (this.get(key) == null) {
            return null;
        }
        Class theClass = null;
        String value = this.get(key).toString();
        try {
            theClass = Reflection.classForName(value);
        }
        catch (Exception ce) {
            if (value.equals("true") || value.equals("yes")) {
                return new Boolean(true);
            }
            if (value.equals("false") || value.equals("no")) {
                return new Boolean(false);
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return value;
            }
        }
        Object classInstance = Reflection.instantiateClass(value);
        if (classInstance instanceof IAutoConfigurable) {
            String configRoot = null;
            configRoot = key;
            ((IAutoConfigurable)classInstance).setConfigPrefix(configRoot);
            Field[] fields = theClass.getFields();
            for (int ii = 0; ii < fields.length; ++ii) {
                Field field = fields[ii];
                String fieldName = field.getName();
                String configPath = configRoot + "." + fieldName;
                if (this.get(configPath) == null) continue;
                field.set(classInstance, this.getClassInstance(configPath));
            }
        }
        return classInstance;
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    @Override
    public String getString(Object key, String defaultValue) {
        String s = super.getString(key, defaultValue);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getPath(String key) {
        return this.getPath(key, null);
    }

    public String getPath(String key, String defaultValue) {
        String value = this.getString(key, defaultValue);
        if (value == null) {
            return value;
        }
        value = ISCFile.canonicalizePath(value);
        this.cache.put(key, value);
        return value;
    }

    public static void deleteProperties(List properties) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Config.deleteProperty((String)i.next());
        }
    }

    public static void deleteProperty(String key) throws Exception {
        Config.persistProperty(key, null);
    }

    public static void deleteProperties(List properties, String propertyFile) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Config.deleteProperty((String)i.next(), propertyFile);
        }
    }

    public static void deleteProperty(String key, String propertyFile) throws Exception {
        Config.persistProperty(key, null, propertyFile);
    }

    public static void persistProperties(Map properties, String propertyFile) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            Object value = properties.get(key);
            if (value == null) {
                Config.persistProperty(key, null, propertyFile);
                continue;
            }
            Config.persistProperty(key, value.toString(), propertyFile);
        }
    }

    public static void persistProperties(Map properties) throws Exception {
        if (properties == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            Object value = properties.get(key);
            if (value == null) {
                Config.persistProperty(key, null);
                continue;
            }
            Config.persistProperty(key, value.toString());
        }
    }

    public static void persistProperty(String key, String value) throws Exception {
        for (Map configData : loadedConfigFiles) {
            String filename = (String)configData.get("filename");
            Config.persistProperty(key, value, filename);
        }
    }

    public static void persistProperty(String key, String value, String propertyFile) throws Exception {
        boolean created;
        Config config = Config.getGlobal();
        if (key == null) {
            return;
        }
        if (propertyFile == null) {
            return;
        }
        String logContext = "property '" + key + "' with value: " + value + " to file: " + propertyFile;
        log.debug("Going to write " + logContext);
        if (DataTools.pathIsRelative(propertyFile)) {
            propertyFile = config.getBoolean((Object)"devenv", false) ? config.getPath("webRoot") + "/isomorphicConfig/" + propertyFile : config.getPath("webRoot") + "/WEB-INF/classes/" + propertyFile;
        }
        if (DataTools.isContainerIOPath(propertyFile)) {
            throw new Exception("Unable to persist " + logContext + " because SmartClient is running in containerIO mode (WAR deployment, no direct filesystem access).  To fix this, set the webRoot variable in your server.properties if possible.");
        }
        File theFile = new File(propertyFile);
        if (!theFile.exists() && !(created = theFile.createNewFile())) {
            throw new Exception("Unable to persist " + logContext + " because " + propertyFile + " does not exist and creating new file at that location failed.");
        }
        FileInputStream is = null;
        Object os = null;
        PrintStream ps = null;
        try {
            is = new FileInputStream(theFile);
            os = new AtomicFileOutputStream(theFile);
            ps = new PrintStream((OutputStream)os);
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
            String line = null;
            boolean replacedInline = false;
            ArrayList<String> seenProperties = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                Matcher matcher = Pattern.compile("^" + Pattern.quote(key) + "\\s*(:|=)").matcher(line);
                if (matcher.find()) {
                    replacedInline = true;
                    if (value != null) {
                        ps.println(key + ": " + value);
                    }
                    seenProperties.add(key);
                    continue;
                }
                if (seenProperties.contains(key)) continue;
                ps.println(line);
            }
            if (!replacedInline && value != null) {
                ps.println(key + ": " + value);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to persist property '" + key + "' with value: " + value + " to propertyFile: " + propertyFile), e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {}
        }
    }

    public static String expandPathVariables(String path) {
        return Config.expandPathVariables(path, false);
    }

    public static String expandPathVariables(String path, boolean removeWebroot) {
        return Config.expandPathVariables(path, removeWebroot, false);
    }

    public static String expandPathVariables(String path, boolean removeWebroot, boolean dontAddWebroot) {
        if (path == null) {
            return path;
        }
        String webroot = globalConfig.getPath("webRoot");
        for (PathExpansionVariable variable : Config.getPathExpansionVariables()) {
            path = variable.expand(path);
        }
        if (removeWebroot) {
            path = StringUtils.replace((String)path, (String)webroot, (String)"");
        } else if (!dontAddWebroot && !path.startsWith(webroot)) {
            path = webroot + "/" + path;
        }
        return path;
    }

    public static String contractPathVariables(String path) {
        if (path == null) {
            return path;
        }
        for (PathExpansionVariable variable : Config.getPathExpansionVariables()) {
            path = variable.contract(path);
        }
        return path;
    }

    public static synchronized PathExpansionVariable[] getPathExpansionVariables() {
        if (pathExpansionVariables == null) {
            pathExpansionVariables = new PathExpansionVariable[]{new PathExpansionVariable("[WEBROOT]", globalConfig.getPath("webRoot")), new PathExpansionVariable("[SCROOT]", globalConfig.getPath("isomorphicDir")), new PathExpansionVariable("[SHAREDDS]", globalConfig.getPath("project.datasources")), new PathExpansionVariable("[SHAREDAPPS]", globalConfig.getPath("project.apps")), new PathExpansionVariable("[VBWORKSPACE]", globalConfig.getPath("workspaceDir")), new PathExpansionVariable("[TOOLS]", globalConfig.getPath("toolsDir"))};
            Arrays.sort(pathExpansionVariables, new Comparator<PathExpansionVariable>(){

                @Override
                public int compare(PathExpansionVariable o1, PathExpansionVariable o2) {
                    int length2;
                    int length1 = o1.expansion.length();
                    if (length1 > (length2 = o2.expansion.length())) {
                        return -1;
                    }
                    if (length1 == length2) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return pathExpansionVariables;
    }

    public static Charset defaultCharset() {
        return UTF_8;
    }

    protected static class PathExpansionVariable {
        protected String variable;
        protected String expansion;

        PathExpansionVariable(String variable, String expansion) {
            if (variable == null) {
                throw new IllegalArgumentException("Must supply a non-null variable to be expanded");
            }
            if (expansion == null) {
                expansion = "";
            }
            this.variable = variable;
            this.expansion = expansion;
        }

        protected String expand(String path) {
            return StringUtils.replace((String)path, (String)this.variable, (String)this.expansion);
        }

        protected String contract(String path) {
            return StringUtils.replace((String)path, (String)this.expansion, (String)this.variable);
        }
    }
}

