/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum CoreMessage implements Message
{
    ON_ACTIVE(1),
    ON_IDLE(2),
    GET_BROWSER_INFORMATION(3),
    CLEAR_PRIVATE_DATA(4),
    DEFAULT(-1);

    private static final Map<Integer, CoreMessage> lookup;
    private final int code;

    private CoreMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "core";
    }

    public static CoreMessage get(int code) {
        CoreMessage command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])CoreMessage.values()), (Function)new Function<CoreMessage, Integer>(){

            public Integer apply(CoreMessage command) {
                return command.getID();
            }
        });
    }
}

